/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.student.pc.impl;

import com.baijia.tianxiao.constant.Relatives;
import com.baijia.tianxiao.constants.org.BizConf;
import com.baijia.tianxiao.dal.org.constant.DeleteStatus;
import com.baijia.tianxiao.dal.org.constant.StudentType;
import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.dao.OrgClassLessonDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgInfoDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentLessonDao;
import com.baijia.tianxiao.dal.org.dao.TXCascadeCredentialDao;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.org.po.OrgCourse;
import com.baijia.tianxiao.dal.org.po.OrgStudent;
import com.baijia.tianxiao.dal.pcAuthority.constant.ApplicationType;
import com.baijia.tianxiao.dal.roster.constant.AddType;
import com.baijia.tianxiao.dal.roster.dao.TxConsultUserDao;
import com.baijia.tianxiao.dal.roster.dao.TxStudentCommentDao;
import com.baijia.tianxiao.dal.roster.dao.TxStudentTagDao;
import com.baijia.tianxiao.dal.roster.po.TxConsultUser;
import com.baijia.tianxiao.dal.roster.po.TxStudentComment;
import com.baijia.tianxiao.dal.roster.po.TxStudentTag;
import com.baijia.tianxiao.dal.solr.dto.StudentDto;
import com.baijia.tianxiao.dal.solr.query.CrmStudentQuery;
import com.baijia.tianxiao.dal.todo.dao.TxBacklogDao;
import com.baijia.tianxiao.dal.todo.po.TxBacklog;
import com.baijia.tianxiao.dal.util.AreaUtils;
import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.dto.query.CommonSearchRequestDto;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.enums.CrmErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.filter.TianxiaoPCContext;
import com.baijia.tianxiao.sal.organization.constant.TXPermissionConst;
import com.baijia.tianxiao.sal.organization.org.dto.TxCascadeCredentialDto;
import com.baijia.tianxiao.sal.organization.org.service.TXCampusAccountService;
import com.baijia.tianxiao.sal.organization.org.service.TxAccountPermissionService;
import com.baijia.tianxiao.sal.organization.org.service.TxCascadeCredentialService;
import com.baijia.tianxiao.sal.student.api.OrgStudentService;
import com.baijia.tianxiao.sal.student.dto.request.StudentListRequestDto;
import com.baijia.tianxiao.sal.student.dto.response.pc.StudentInfoResponseDto;
import com.baijia.tianxiao.sal.student.dto.response.pc.StudentListResponseDto;
import com.baijia.tianxiao.sal.student.pc.StudentUserService;
import com.baijia.tianxiao.sal.student.util.OrgStudentUtil;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.util.BaseUtils;
import com.baijia.tianxiao.util.CollectorUtil;
import com.baijia.tianxiao.util.GenericsUtils;
import com.baijia.tianxiao.util.mobile.MaskUtil;
import com.beust.jcommander.internal.Maps;
import com.beust.jcommander.internal.Sets;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class StudentUserServiceImpl
implements StudentUserService {
    private static final Logger log = LoggerFactory.getLogger(StudentUserServiceImpl.class);
    @Resource
    private OrgStudentDao orgStudentDao;
    @Resource
    private OrgAccountDao orgAccountDao;
    @Autowired
    private TxConsultUserDao txConsultUserDao;
    @Autowired
    private TxBacklogDao txBacklogDao;
    @Autowired
    private TxStudentCommentDao txStudentCommentDao;
    @Autowired
    private TxStudentTagDao txStudentTagDao;
    @Autowired(required=false)
    private CrmStudentQuery query;
    @Autowired
    private TxAccountPermissionService txAccountPermissionService;
    @Autowired
    private TXCascadeCredentialDao txCascadeCredentialDao;
    @Autowired
    private OrgStudentCourseDao orgStudentCourseDao;
    @Autowired
    private OrgStudentService orgStudentService;
    @Autowired
    private OrgInfoDao orgInfoDao;
    @Autowired
    private TxCascadeCredentialService txCascadeCredentialService;
    @Autowired
    private TXCampusAccountService txCampusAccountService;
    @Autowired
    private OrgStudentLessonDao orgStudentLessonDao;
    @Autowired
    private OrgClassLessonDao orgClassLessonDao;
    @Autowired
    private OrgCourseDao orgCourseDao;
    @Autowired
    private CrmStudentQuery crmStudentQuery;

    @Override
    public StudentInfoResponseDto getBaseInfo(Long orgId, Long studentId) throws Exception {
        if (null == orgId || orgId <= 0L || null == studentId || studentId <= 0L) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR);
        }
        OrgAccount account = (OrgAccount)this.orgAccountDao.getById((Serializable)orgId, new String[0]);
        if (account == null) {
            throw new BussinessException((UniverseErrorCode)CrmErrorCode.ORG_NOT_EXIST);
        }
        OrgStudent orgStudent = (OrgStudent)this.orgStudentDao.getById((Serializable)studentId, new String[0]);
        if (null == orgStudent || orgStudent.getDelStatus().intValue() == DeleteStatus.DELETED.getValue() || orgStudent.getOrgId().longValue() != orgId.longValue()) {
            throw new BussinessException((UniverseErrorCode)CrmErrorCode.CONSULTER_NOT_EXISTS);
        }
        StudentInfoResponseDto baseInfoDto = new StudentInfoResponseDto();
        this.studentPo2Dto(orgStudent, baseInfoDto);
        boolean isShowMobile = this.txCascadeCredentialService.isShowMobile(orgId, TianxiaoPCContext.getTXCascadeId());
        if (!isShowMobile) {
            baseInfoDto.setMobile(MaskUtil.maskMobile((String)baseInfoDto.getMobile()));
            baseInfoDto.setParentMobile(MaskUtil.maskMobile((String)baseInfoDto.getParentMobile()));
        }
        log.info("getBaseInfo---------baseInfoDto={}", (Object)baseInfoDto);
        return baseInfoDto;
    }

    @Override
    @Transactional(rollbackFor={Exception.class, BussinessException.class})
    public Long addStudentInfo(Long orgId, Integer cascadeId, StudentListResponseDto studentInfo) throws Exception {
        if (null == orgId || orgId <= 0L || null == studentInfo) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR);
        }
        this.doSaveBefore(orgId, studentInfo);
        Map<String, Long> userInfoMap = OrgStudentUtil.getUserIdAndNumber(studentInfo.getName());
        Long userId = userInfoMap.get("id");
        OrgStudent orgStudent = new OrgStudent();
        this.studentDto2Po(studentInfo, orgStudent, orgId, userId);
        orgStudent.setAddCascadeId(Integer.valueOf(cascadeId == null ? 0 : cascadeId));
        this.orgStudentDao.save((Object)orgStudent, Boolean.valueOf(false), new String[0]);
        log.info("addStudentInfo---------orgStudent={}", (Object)orgStudent);
        this.updateSolr(orgStudent);
        return orgStudent.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class, BussinessException.class})
    public Long addStudentInfo(Long orgId, Integer cascadeId, StudentListResponseDto studentInfo, boolean updateRepeat) throws Exception {
        Map<String, Long> userInfoMap;
        if (null == orgId || orgId <= 0L || null == studentInfo) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR);
        }
        log.info("orgId:{}, studentInfo:{}, updateRepeat:{}", new Object[]{orgId, studentInfo, updateRepeat});
        Long userId = null;
        OrgStudent orgStudent = null;
        if (updateRepeat) {
            orgStudent = this.orgStudentDao.getStudentByMobileAndName(orgId, studentInfo.getMobile(), studentInfo.getName());
            if (orgStudent == null) {
                userInfoMap = OrgStudentUtil.getUserIdAndNumber(studentInfo.getName());
                userId = userInfoMap.get("id");
                orgStudent = new OrgStudent();
            } else {
                userId = orgStudent.getUserId();
                studentInfo.setId(orgStudent.getId());
            }
        } else {
            this.doSaveBefore(orgId, studentInfo);
            userInfoMap = OrgStudentUtil.getUserIdAndNumber(studentInfo.getName());
            userId = userInfoMap.get("id");
            orgStudent = new OrgStudent();
        }
        this.studentDto2Po(studentInfo, orgStudent, orgId, userId);
        if (orgStudent.getId() != null && orgStudent.getId() > 0L) {
            orgStudent.nullToEmpty();
            this.orgStudentDao.updateWithDefaultVal((Object)orgStudent, new String[0]);
        } else {
            orgStudent.setAddCascadeId(cascadeId);
            this.orgStudentDao.save((Object)orgStudent, Boolean.valueOf(false), new String[0]);
        }
        log.info("addStudentInfo---------orgStudent={}", (Object)orgStudent);
        if (StringUtils.isNotBlank((CharSequence)studentInfo.getTagsStr())) {
            this.txStudentTagDao.delTags(orgStudent.getUserId(), orgId);
            String[] tags = studentInfo.getTagsStr().split(",");
            ArrayList<TxStudentTag> tagList = new ArrayList<TxStudentTag>();
            for (String tagStr : tags) {
                if (!StringUtils.isNotBlank((CharSequence)"tagStr")) continue;
                TxStudentTag tag = new TxStudentTag();
                tag.setOrgId(orgStudent.getOrgId());
                tag.setUserId(orgStudent.getUserId());
                tag.setContent(tagStr);
                tagList.add(tag);
            }
            this.txStudentTagDao.saveAll(tagList, new String[]{"consultUserId", "userId", "orgId", "content"});
        }
        this.updateSolr(orgStudent);
        return orgStudent.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class, BussinessException.class})
    public void editStudentInfo(Long orgId, StudentListResponseDto studentInfo) throws Exception {
        if (null == orgId || orgId <= 0L || null == studentInfo || null == studentInfo.getId() || studentInfo.getId() <= 0L) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR);
        }
        OrgStudent orgStudent = (OrgStudent)this.orgStudentDao.getById((Serializable)studentInfo.getId(), new String[0]);
        if (orgStudent == null || orgStudent.getDelStatus().intValue() == DeleteStatus.DELETED.getValue() || orgStudent.getOrgId().longValue() != orgId.longValue()) {
            throw new BussinessException((UniverseErrorCode)CrmErrorCode.STUDENT_NOT_EXISTS);
        }
        this.doSaveBefore(orgId, studentInfo);
        this.checkAndCreateComment(studentInfo, orgStudent);
        this.cascadeUpdateTxConsulter(orgId, orgStudent, studentInfo);
        if (studentInfo.getMobile().contains("****")) {
            studentInfo.setMobile(orgStudent.getMobile());
        }
        if (studentInfo.getParentMobile().contains("****")) {
            studentInfo.setParentMobile(orgStudent.getParentMobile());
        }
        this.studentDto2Po(studentInfo, orgStudent, orgId, null);
        this.orgStudentDao.update((Object)orgStudent, Boolean.valueOf(false), new String[0]);
        log.info("editStudentInfo---------orgStudent={}", (Object)orgStudent);
        this.updateSolr(orgStudent);
    }

    @Override
    @Transactional(rollbackFor={Exception.class, BussinessException.class})
    public void BatchDelStudent(Long orgId, Set<Long> studentIds) {
        if (CollectionUtils.isEmpty(studentIds)) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR);
        }
        List list = this.orgStudentDao.getStudentByIds(orgId, studentIds, new String[0]);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            for (OrgStudent orgStudent : list) {
                if (orgStudent.getDelStatus().intValue() != DeleteStatus.NORMAL.getValue()) continue;
                List consultUserList = this.txConsultUserDao.lookByStudentId(orgId, orgStudent.getId(), new String[0]);
                log.info("delStudent--------consultUserList={}", (Object)consultUserList);
                if (null != consultUserList && !consultUserList.isEmpty()) {
                    this.delSysBacklog(orgId, orgStudent, (TxConsultUser)consultUserList.get(0));
                    for (TxConsultUser consulterUser : consultUserList) {
                        consulterUser.setStudentId(Long.valueOf(0L));
                        this.txConsultUserDao.update((Object)consulterUser, new String[]{"studentId"});
                    }
                } else {
                    this.delSysBacklog(orgId, orgStudent, null);
                }
                orgStudent.setDelStatus(Integer.valueOf(DeleteStatus.DELETED.getValue()));
                TxStudentComment comment = new TxStudentComment();
                comment.setContent("\u673a\u6784\u5220\u9664\u5b66\u5458");
                comment.setUserId(orgStudent.getUserId());
                comment.setOrgId(orgStudent.getOrgId());
                comment.setIsSystem(Integer.valueOf(AddType.SYSTEM.getCode()));
                this.txStudentCommentDao.save((Object)comment, new String[0]);
                this.txStudentTagDao.delTags(orgStudent.getUserId(), orgId);
                this.orgStudentDao.update((Object)orgStudent, new String[]{"delStatus"});
                this.updateSolr(orgStudent);
            }
        }
    }

    private void studentPo2Dto(OrgStudent po, StudentInfoResponseDto dto) throws IllegalAccessException, InvocationTargetException {
        BeanUtils.copyProperties((Object)dto, (Object)po);
        log.info("StudentPo2Dto---------po={},dto={}", (Object)ToStringBuilder.reflectionToString((Object)po), (Object)dto);
        if (po.getBirthday() != null) {
            dto.setBirthday(po.getBirthday().getTime());
        }
        if (po.getNextRemindTime() != null) {
            dto.setNextRemindTime(po.getNextRemindTime().getTime());
            dto.setNextRemindTimeStr(po.getNextRemindTime());
        }
        if (dto.getGender() == null || dto.getGender() == -1L) {
            dto.setGenderStr("");
        } else {
            dto.setGenderStr(po.getGender() == 1 ? "\u5973" : "\u7537");
        }
        dto.setRelationshipStr(Relatives.getLabel((Integer)dto.getRelationship()));
        if (null != po.getAreaId() && dto.getAreaId() > 0) {
            Map areaMap = AreaUtils.getAreaNameByCode((Integer)dto.getAreaId());
            dto.setProvince((String)areaMap.get("province"));
            dto.setCity((String)areaMap.get("city"));
            dto.setCounty((String)areaMap.get("county"));
        }
    }

    private void studentDto2Po(StudentListResponseDto dto, OrgStudent po, Long orgId, Long userId) throws IllegalAccessException, InvocationTargetException {
        BeanUtils.copyProperties((Object)po, (Object)dto);
        log.info("studentDto2Po---------dto={},po:{}", (Object)dto, (Object)ToStringBuilder.reflectionToString((Object)po));
        if (dto.getNextRemindTime() != null && dto.getNextRemindTime() > 0L) {
            po.setNextRemindTime(new Date(dto.getNextRemindTime()));
        } else {
            po.setNextRemindTime(null);
        }
        if (null == po.getId() || 0L == po.getId()) {
            po.setOrgId(orgId);
            po.setCreateTime(new Date());
            po.setUserId(userId);
        }
        if (null != dto.getBirthday()) {
            po.setBirthday(new Date(dto.getBirthday()));
        }
        po.setUpdateTime(new Date());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void doSaveBefore(Long orgId, StudentListResponseDto studentInfo) {
        OrgStudent student = null;
        if (studentInfo.getId() != null && studentInfo.getId() > 0L) {
            student = (OrgStudent)this.orgStudentDao.getById((Serializable)studentInfo.getId(), new String[0]);
            if (student == null || student.getOrgId().longValue() != orgId.longValue() || student.getDelStatus().intValue() != DeleteStatus.NORMAL.getValue()) throw new BussinessException((UniverseErrorCode)CrmErrorCode.STUDENT_NOT_EXISTS);
            String mobile = student.getMobile();
            String name = student.getName();
            log.debug("mobile={},stMobile={},name={},stuName={}", new Object[]{mobile, studentInfo.getMobile(), name, studentInfo.getName()});
            if (mobile.equals(studentInfo.getMobile()) && studentInfo.getName().equals(name)) {
                return;
            }
            this.procSameMobileAndName(orgId, studentInfo.getMobile(), studentInfo.getName());
            return;
        } else {
            this.procSameMobileAndName(orgId, studentInfo.getMobile(), studentInfo.getName());
        }
    }

    private void procSameMobileAndName(Long orgId, String mobile, String name) {
        OrgStudent student = this.orgStudentDao.getStudentByMobileAndName(orgId, mobile, name);
        if (student != null) {
            throw new BussinessException((UniverseErrorCode)CrmErrorCode.STUDENT_HAS_EXISTS);
        }
    }

    @Override
    public List<StudentListResponseDto> searchStudentByCustomParams(long orgId, Integer cascadeId, CommonSearchRequestDto request, PageDto pageDto) throws Exception {
        StudentListRequestDto studentListRequestDto = new StudentListRequestDto();
        studentListRequestDto.setStudentStatus(request.getStatus());
        studentListRequestDto.setQueryStr(request.getName());
        studentListRequestDto.setQueryValue(request.getQuery());
        studentListRequestDto.setCascadeId(cascadeId);
        studentListRequestDto.setOrderName(request.getOrderName());
        studentListRequestDto.setOrderType(request.getOrderType());
        studentListRequestDto.setNeedAvatar(false);
        if (StringUtils.isNotBlank((CharSequence)request.getQuery())) {
            studentListRequestDto.setQueryStr(request.getName());
            studentListRequestDto.setQueryValue(request.getQuery());
        }
        List<StudentDto> solrStudents = this.orgStudentService.searchStudentList(studentListRequestDto, orgId, pageDto);
        log.debug("studentListRequestDto={},orgId={},pagedto={},solrStudnets = {}", new Object[]{studentListRequestDto, orgId, pageDto, solrStudents == null ? 0 : solrStudents.size()});
        if (solrStudents.isEmpty()) {
            return GenericsUtils.emptyList();
        }
        final ArrayList userIds = new ArrayList(pageDto.getPageSize());
        Map studentDtoMap = CollectorUtil.collectMap(solrStudents, (Function)new Function<StudentDto, Long>(){

            public Long apply(StudentDto studentDto) {
                userIds.add(studentDto.getUserId());
                return studentDto.getStudentId();
            }
        });
        Map<Long, String> searchTeacherNames = this.searchTeacherNames(new HashSet<Long>(userIds), orgId, cascadeId);
        log.info("headTeacherNames {} ", searchTeacherNames);
        List students = this.orgStudentDao.getByIds(studentDtoMap.keySet(), new String[0]);
        boolean isShowMobile = this.txCascadeCredentialService.isShowMobile(Long.valueOf(orgId), TianxiaoPCContext.getTXCascadeId());
        List studentTags = this.txStudentTagDao.getTags(userIds, Long.valueOf(orgId), Integer.valueOf(StudentType.ORG_STUDENTS.getCode()), new String[0]);
        HashMap<Long, ArrayList<TxStudentTag>> tagMap = new HashMap<Long, ArrayList<TxStudentTag>>();
        if (studentTags != null && studentTags.size() > 0) {
            for (TxStudentTag tag : studentTags) {
                ArrayList<TxStudentTag> tagList = (ArrayList<TxStudentTag>)tagMap.get(tag.getUserId());
                if (tagList == null) {
                    tagList = new ArrayList<TxStudentTag>();
                    tagMap.put(tag.getUserId(), tagList);
                }
                tagList.add(tag);
            }
        }
        ArrayList result = Lists.newArrayList();
        for (OrgStudent student : students) {
            StudentDto studentDto;
            List tags = (List)tagMap.get(student.getUserId());
            StudentListResponseDto dto = StudentListResponseDto.convertToDto(student, tags);
            if (!isShowMobile) {
                dto.setMobile(MaskUtil.maskMobile((String)dto.getMobile()));
                dto.setParentMobile(MaskUtil.maskMobile((String)dto.getParentMobile()));
            }
            dto.setHasLesson((studentDto = (StudentDto)studentDtoMap.get(student.getId())).isHasLesson() ? "\u662f" : "\u5426");
            dto.setCascadeIdStr(searchTeacherNames.get(student.getUserId()));
            dto.setLessonNum(studentDto.getFinishClassHour() + "/" + (studentDto.getLeftClassHour() + studentDto.getFinishClassHour()));
            result.add(dto);
        }
        return result;
    }

    private Map<Long, String> searchTeacherNames(Set<Long> userIds, Long orgId, Integer cascadeId) {
        boolean hasPermission;
        boolean isStaffAccount = false;
        if (cascadeId != null && !(hasPermission = this.txAccountPermissionService.hasPermission(Long.valueOf(cascadeId.longValue()), ApplicationType.PC, TXPermissionConst.CHAKAN_SUOYOU_XUEYUAN))) {
            isStaffAccount = true;
        }
        log.info("isStaffAccount : {} , cascadeId : {} , orgId : {} ", new Object[]{isStaffAccount, cascadeId, orgId});
        Map byTxCasCadeIds = Maps.newHashMap();
        if (isStaffAccount) {
            TxCascadeCredentialDto byTxCasCade = this.txCascadeCredentialService.getByTxCasCade(orgId, cascadeId);
            if (byTxCasCade != null) {
                byTxCasCadeIds.put(cascadeId.longValue(), byTxCasCade.getName());
            }
        } else {
            byTxCasCadeIds.putAll(this.txCascadeCredentialService.getByTxCasCadeIds(orgId));
        }
        Map headTeacherNameMap = Maps.newHashMap();
        Map orgStudentCourseIds = this.orgStudentCourseDao.getOrgCourseIdMap(orgId.longValue(), userIds);
        Set courseIdSet = Sets.newHashSet();
        for (List courses : orgStudentCourseIds.values()) {
            courseIdSet.addAll(courses);
        }
        List allCourse = this.orgCourseDao.getByIds((Collection)courseIdSet, new String[]{"id", "cascadeId"});
        Map courseCascadeNameMap = Maps.newHashMap();
        for (OrgCourse orgCourse : allCourse) {
            Long courseId = orgCourse.getId();
            Integer courseCascadeId = orgCourse.getCascadeId();
            String headTeacherName = (String)byTxCasCadeIds.get(courseCascadeId.longValue());
            if (!GenericsUtils.notNullAndEmpty((Object)headTeacherName)) continue;
            courseCascadeNameMap.put(courseId, headTeacherName);
        }
        for (Long userId : userIds) {
            List courseIds = (List)orgStudentCourseIds.get(userId);
            if (GenericsUtils.isNullOrEmpty((Object)courseIds)) continue;
            StringBuilder sb = new StringBuilder();
            for (Long courseId : courseIds) {
                String headTeacherName = (String)courseCascadeNameMap.get(courseId);
                if (!GenericsUtils.notNullAndEmpty((Object)headTeacherName)) continue;
                sb.append(headTeacherName).append("\u3001");
            }
            String headTeacherNames = GenericsUtils.deleteLastCharToString((StringBuilder)sb);
            headTeacherNameMap.put(userId, headTeacherNames);
        }
        return headTeacherNameMap;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void addSysBacklog(Long orgId, Long studentId, Long consultUserId) {
        if (null == orgId || orgId <= 0L || null == studentId || studentId <= 0L) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR);
        }
        OrgStudent student = (OrgStudent)this.orgStudentDao.getById((Serializable)studentId, new String[0]);
        log.info("addSysBacklog---------orgId={}, student={}, consultUserId={}", new Object[]{orgId, student, consultUserId});
        if (null != student && student.getDelStatus().intValue() == DeleteStatus.NORMAL.getValue() && student.getOrgId().longValue() == orgId.longValue()) {
            List list = this.txBacklogDao.getBacklogByStudentIdAndOrgId(studentId, orgId, Boolean.valueOf(false), new String[]{"id"});
            if (CollectionUtils.isNotEmpty((Collection)list)) {
                throw new BussinessException((UniverseErrorCode)CommonErrorCode.SYSTEM_ERROR, "\u5df2\u5b58\u5728\u672a\u8fc7\u671f\u7684\u5b66\u5458\u6863\u6848\u7cfb\u7edf\u5f85\u529e\u4e8b\u9879");
            }
            TxBacklog txBacklog = new TxBacklog();
            txBacklog.setOrgId(orgId);
            txBacklog.setStudentId(student.getId());
            txBacklog.setContent("\u8ddf\u8fdb\u5ba2\u6237: " + (StringUtils.isNotBlank((CharSequence)student.getName()) ? student.getName() : "\u533f\u540d\u5b66\u751f"));
            txBacklog.setCreateTime(new Date());
            txBacklog.setUpdateTime(new Date());
            txBacklog.setIsSys(BizConf.TRUE.intValue());
            txBacklog.setEndTime(student.getNextRemindTime());
            txBacklog.setRemindTime(student.getNextRemindTime());
            if (null != consultUserId && consultUserId > 0L) {
                txBacklog.setConsultUserId(consultUserId);
            }
            this.txBacklogDao.save((Object)txBacklog, Boolean.valueOf(false), new String[0]);
            log.info("addSysBacklog--------txBacklog={}", (Object)txBacklog);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateSysBacklog(Long orgId, Long studentId) {
        if (null == orgId || orgId <= 0L || null == studentId || studentId <= 0L) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR);
        }
        OrgStudent student = (OrgStudent)this.orgStudentDao.getById((Serializable)studentId, new String[0]);
        log.info("updateSysBacklog---------orgId={}, student={}", (Object)orgId, (Object)student);
        if (null != student && student.getDelStatus().intValue() == DeleteStatus.NORMAL.getValue() && student.getOrgId().longValue() == orgId.longValue()) {
            List list = this.txBacklogDao.getBacklogByStudentIdAndOrgId(student.getId(), orgId, Boolean.valueOf(false), new String[0]);
            if (CollectionUtils.isNotEmpty((Collection)list)) {
                TxBacklog txBacklog = (TxBacklog)list.get(0);
                if (txBacklog.getEndTime().getTime() != student.getNextRemindTime().getTime()) {
                    txBacklog.setContent("\u8ddf\u8fdb\u5ba2\u6237: " + (StringUtils.isNotBlank((CharSequence)student.getName()) ? student.getName() : "\u533f\u540d\u5b66\u751f"));
                    txBacklog.setEndTime(student.getNextRemindTime());
                    txBacklog.setRemindTime(student.getNextRemindTime());
                    txBacklog.setUpdateTime(new Date());
                    this.txBacklogDao.update((Object)txBacklog, Boolean.valueOf(false), new String[0]);
                }
            } else {
                Long consulterId = null;
                List consultUserList = this.txConsultUserDao.lookByStudentId(orgId, student.getId(), new String[]{"id"});
                if (CollectionUtils.isNotEmpty((Collection)consultUserList)) {
                    consulterId = ((TxConsultUser)consultUserList.get(0)).getId();
                }
                this.addSysBacklog(orgId, student.getId(), consulterId);
            }
        }
    }

    private void delSysBacklog(Long orgId, OrgStudent student, TxConsultUser consulterUser) {
        block5: {
            List list;
            block4: {
                log.info("delSysBacklog-------orgId={},student={},consulterUser={}", new Object[]{orgId, student, consulterUser});
                list = null;
                if (null == consulterUser) break block4;
                list = this.txBacklogDao.getBacklogByConsulterIdAndOrgId(consulterUser.getId(), orgId, null, new String[0]);
                if (!CollectionUtils.isNotEmpty((Collection)list)) break block5;
                for (TxBacklog txBacklog : list) {
                    if (null == txBacklog || txBacklog.getStudentId().longValue() != student.getId().longValue()) continue;
                    txBacklog.setStudentId(Long.valueOf(0L));
                    if (!txBacklog.getEndTime().before(new Date())) {
                        txBacklog.setContent("\u8ddf\u8fdb\u5ba2\u6237: " + (StringUtils.isNotBlank((CharSequence)consulterUser.getName()) ? consulterUser.getName() : "\u533f\u540d\u5b66\u751f"));
                        txBacklog.setEndTime(consulterUser.getNextRemindTime());
                        txBacklog.setRemindTime(consulterUser.getNextRemindTime());
                    }
                    txBacklog.setUpdateTime(new Date());
                    this.txBacklogDao.update((Object)txBacklog, Boolean.valueOf(false), new String[0]);
                }
                break block5;
            }
            list = this.txBacklogDao.getBacklogByStudentIdAndOrgId(student.getId(), orgId, null, new String[0]);
            if (CollectionUtils.isNotEmpty((Collection)list)) {
                for (TxBacklog txBacklog : list) {
                    if (null == txBacklog) continue;
                    txBacklog.setStudentId(Long.valueOf(0L));
                    txBacklog.setDelStatus(BizConf.TRUE.intValue());
                    txBacklog.setUpdateTime(new Date());
                    this.txBacklogDao.update((Object)txBacklog, Boolean.valueOf(false), new String[0]);
                }
            }
        }
    }

    private void checkAndCreateComment(StudentListResponseDto dto, OrgStudent po) {
        StringBuffer content;
        String sourceName = po.getName();
        String sourceMobile = po.getMobile();
        String destName = dto.getName();
        String destMobile = dto.getMobile();
        ArrayList comments = Lists.newArrayList();
        String formatTime = BaseUtils.getFormatDate((String)"yyyy-MM-dd HH:mm", (int)0, (int)5);
        if (!destName.equals(sourceName)) {
            content = new StringBuffer();
            content.append(formatTime).append(" \u5c06\u59d3\u540d\u3010").append(sourceName).append("\u3011").append("\u4fee\u6539\u4e3a\u3010").append(destName).append("\u3011");
            comments.add(this.generateComment(po.getOrgId(), content.toString(), po.getUserId()));
        }
        if (!destMobile.equals(sourceMobile)) {
            content = new StringBuffer();
            content.append(formatTime).append(" \u5c06\u624b\u673a\u53f7\u3010").append(sourceMobile).append("\u3011").append("\u4fee\u6539\u4e3a\u3010").append(destMobile).append("\u3011");
            comments.add(this.generateComment(po.getOrgId(), content.toString(), po.getUserId()));
        }
        if (!comments.isEmpty()) {
            this.txStudentCommentDao.saveAll((List)comments, new String[0]);
        }
    }

    private TxStudentComment generateComment(long orgId, String content, long userId) {
        TxStudentComment comment = new TxStudentComment();
        comment.setContent(content);
        comment.setCreateTime(new Date());
        comment.setIsSystem(BizConf.TRUE);
        comment.setOrgId(Long.valueOf(orgId));
        comment.setOrigin(0);
        comment.setUserId(Long.valueOf(userId));
        return comment;
    }

    private void cascadeUpdateTxConsulter(long orgId, OrgStudent orgStudent, StudentListResponseDto studentInfo) {
        List consultUsers;
        boolean updateMobile;
        boolean updateName = !studentInfo.getName().equals(orgStudent.getName());
        boolean bl = updateMobile = !studentInfo.getMobile().equals(orgStudent.getMobile());
        if ((updateName || updateMobile) && (consultUsers = this.txConsultUserDao.lookByStudentId(Long.valueOf(orgId), orgStudent.getId(), new String[0])) != null && !consultUsers.isEmpty()) {
            for (TxConsultUser consultUser : consultUsers) {
                consultUser.setName(updateName ? studentInfo.getName() : null);
                consultUser.setMobile(updateMobile ? studentInfo.getMobile() : null);
                consultUser.setUpdateTime(new Date());
                this.txConsultUserDao.update((Object)consultUser, Boolean.valueOf(false), new String[0]);
            }
        }
    }

    void updateSolr(OrgStudent orgStudent) {
        if (orgStudent == null) {
            return;
        }
        try {
            this.crmStudentQuery.updateOldRow(orgStudent.toSolrMap());
            log.info("solr - student - update - end - orgStudent:{}", (Object)orgStudent);
        }
        catch (Exception e) {
            log.error("solr - student - update - exception", (Throwable)e);
        }
    }
}

