/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.student.impl;

import com.baijia.commons.lang.utils.collection.CollectionUtils;
import com.baijia.tianxiao.constant.Flag;
import com.baijia.tianxiao.constants.CourseType;
import com.baijia.tianxiao.constants.PayStatus;
import com.baijia.tianxiao.constants.TianXiaoConstant;
import com.baijia.tianxiao.constants.org.BizConf;
import com.baijia.tianxiao.dal.callservice.dao.CallServiceInfoDao;
import com.baijia.tianxiao.dal.callservice.dao.OrgPushCallInfoDao;
import com.baijia.tianxiao.dal.callservice.po.CallServiceInfo;
import com.baijia.tianxiao.dal.callservice.po.OrgPushCallInfo;
import com.baijia.tianxiao.dal.enums.CourseTypeEnum;
import com.baijia.tianxiao.dal.org.constant.DeleteStatus;
import com.baijia.tianxiao.dal.org.constant.StudentType;
import com.baijia.tianxiao.dal.org.dao.CoursePurchaseDao;
import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgInfoDao;
import com.baijia.tianxiao.dal.org.dao.OrgStorageDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentLessonDao;
import com.baijia.tianxiao.dal.org.dao.TXCascadeCredentialDao;
import com.baijia.tianxiao.dal.org.dto.StudentClasHourDocument;
import com.baijia.tianxiao.dal.org.dto.StudentClassHourStatusDocument;
import com.baijia.tianxiao.dal.org.po.AccountRoleType;
import com.baijia.tianxiao.dal.org.po.CoursePurchase;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.org.po.OrgCourse;
import com.baijia.tianxiao.dal.org.po.OrgInfo;
import com.baijia.tianxiao.dal.org.po.OrgStorage;
import com.baijia.tianxiao.dal.org.po.OrgStudent;
import com.baijia.tianxiao.dal.org.po.OrgStudentCourse;
import com.baijia.tianxiao.dal.pcAuthority.constant.ApplicationType;
import com.baijia.tianxiao.dal.pcAuthority.constant.RoleType;
import com.baijia.tianxiao.dal.push.constant.MessageSource;
import com.baijia.tianxiao.dal.roster.constant.AddType;
import com.baijia.tianxiao.dal.roster.constant.DownLoadStatus;
import com.baijia.tianxiao.dal.roster.constant.MobileStatus;
import com.baijia.tianxiao.dal.roster.dao.TxConsultUserDao;
import com.baijia.tianxiao.dal.roster.dao.TxStudentCommentDao;
import com.baijia.tianxiao.dal.roster.dao.TxStudentTagDao;
import com.baijia.tianxiao.dal.roster.po.TxConsultUser;
import com.baijia.tianxiao.dal.roster.po.TxStudentComment;
import com.baijia.tianxiao.dal.roster.po.TxStudentTag;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupCourseDao;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupInfoDao;
import com.baijia.tianxiao.dal.signup.po.OrgSignupCourse;
import com.baijia.tianxiao.dal.solr.dto.StudentDto;
import com.baijia.tianxiao.dal.solr.dto.StudentQueryParam;
import com.baijia.tianxiao.dal.solr.enums.OpType;
import com.baijia.tianxiao.dal.solr.enums.StudentLessonStatus;
import com.baijia.tianxiao.dal.solr.enums.TimeType;
import com.baijia.tianxiao.dal.solr.po.StudentClass;
import com.baijia.tianxiao.dal.solr.po.StudentClassHour;
import com.baijia.tianxiao.dal.solr.po.StudentStatusStatistics;
import com.baijia.tianxiao.dal.solr.query.CrmStudentQuery;
import com.baijia.tianxiao.dal.storage.dao.StorageDao;
import com.baijia.tianxiao.dal.storage.po.Storage;
import com.baijia.tianxiao.dal.todo.dao.TxBacklogDao;
import com.baijia.tianxiao.dal.todo.po.TxBacklog;
import com.baijia.tianxiao.dal.user.dao.StudentDao;
import com.baijia.tianxiao.dal.user.dao.UserDao;
import com.baijia.tianxiao.dal.user.po.Student;
import com.baijia.tianxiao.dal.user.po.User;
import com.baijia.tianxiao.dal.util.AreaUtils;
import com.baijia.tianxiao.dal.wechat.constant.WechatOpenIdEntityType;
import com.baijia.tianxiao.dal.wechat.dao.AuthorizationInfoDao;
import com.baijia.tianxiao.dal.wechat.dao.FansDao;
import com.baijia.tianxiao.dal.wechat.dao.OrgWechatOpenIdRecordDao;
import com.baijia.tianxiao.dal.wechat.po.AuthorizationInfo;
import com.baijia.tianxiao.dal.wechat.po.Fans;
import com.baijia.tianxiao.dal.wechat.po.OrgWechatOpenIdRecord;
import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.enums.CrmErrorCode;
import com.baijia.tianxiao.enums.StudentCourseStatus;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.exception.ParameterException;
import com.baijia.tianxiao.exception.PermissionException;
import com.baijia.tianxiao.filter.TianxiaoMContext;
import com.baijia.tianxiao.sal.common.api.ConsultUserStudentSynchService;
import com.baijia.tianxiao.sal.organization.constant.TXPermissionConst;
import com.baijia.tianxiao.sal.organization.org.service.TxAccountHelpService;
import com.baijia.tianxiao.sal.organization.org.service.TxAccountPermissionService;
import com.baijia.tianxiao.sal.organization.org.service.TxCascadeCredentialService;
import com.baijia.tianxiao.sal.organization.org.service.impl.RequestSourceDesc;
import com.baijia.tianxiao.sal.organization.utils.DataAuthority;
import com.baijia.tianxiao.sal.push.dto.ConsultAvatarUrlAndNameDto;
import com.baijia.tianxiao.sal.push.service.ConsultAvatarUrlService;
import com.baijia.tianxiao.sal.student.api.OrgStudentCourseService;
import com.baijia.tianxiao.sal.student.api.OrgStudentService;
import com.baijia.tianxiao.sal.student.dto.CommentInfoDto;
import com.baijia.tianxiao.sal.student.dto.CreatorDto;
import com.baijia.tianxiao.sal.student.dto.StudentInfoDto;
import com.baijia.tianxiao.sal.student.dto.TagInfoDto;
import com.baijia.tianxiao.sal.student.dto.customFields.StudentCustomFieldResponse;
import com.baijia.tianxiao.sal.student.dto.request.MobileCheckInfoRequestDto;
import com.baijia.tianxiao.sal.student.dto.request.StudentCommenRequestDto;
import com.baijia.tianxiao.sal.student.dto.request.StudentListRequestDto;
import com.baijia.tianxiao.sal.student.dto.response.BatchAddStudentResponseDto;
import com.baijia.tianxiao.sal.student.dto.response.MobileCheckReponseDto;
import com.baijia.tianxiao.sal.student.dto.response.OrgStudentAddresponseDto;
import com.baijia.tianxiao.sal.student.dto.response.StudentInfoListReponseDto;
import com.baijia.tianxiao.sal.student.dto.response.StudentInfoReponseDto;
import com.baijia.tianxiao.sal.student.enums.StarEnum;
import com.baijia.tianxiao.sal.student.enums.StudentErrorCode;
import com.baijia.tianxiao.sal.student.util.CommentUtil;
import com.baijia.tianxiao.sal.student.util.OrgStudentUtil;
import com.baijia.tianxiao.sal.student.util.WechatProperties;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.util.GenericsUtils;
import com.baijia.tianxiao.util.HanZiPinYinUtils;
import com.baijia.tianxiao.util.ListUtil;
import com.baijia.tianxiao.util.collection.CollectorUtil;
import com.baijia.tianxiao.util.mobile.MaskUtil;
import com.baijia.tianxiao.util.storage.StorageUtil;
import com.baijia.tianxiao.validation.ParamValidateUtils;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class OrgStudentServiceImpl
implements OrgStudentService {
    private static final Logger log = LoggerFactory.getLogger(OrgStudentServiceImpl.class);
    @Autowired
    private OrgStudentDao orgStudentsDao;
    @Autowired
    private StudentDao studentDao;
    @Autowired
    private TxStudentTagDao txStudentTagDao;
    @Autowired
    private TxConsultUserDao txConsultUserDao;
    @Autowired
    private TxStudentCommentDao txStudentCommentDao;
    @Autowired
    private UserDao userDao;
    @Autowired
    private OrgStorageDao orgStorageDao;
    @Autowired
    private StorageDao storageDao;
    @Autowired
    private CoursePurchaseDao coursePurchaseDao;
    @Autowired
    private OrgStudentCourseDao orgStudentCourseDao;
    @Autowired
    private OrgCourseDao orgCourseDao;
    @Autowired
    private OrgAccountDao orgAccountDao;
    @Autowired
    private OrgSignupInfoDao orgSignupInfoDao;
    @Autowired
    private OrgSignupCourseDao orgSignupCourseDao;
    @Autowired
    private CallServiceInfoDao callServiceInfoDao;
    @Autowired
    private FansDao fansDao;
    @Autowired
    private TxBacklogDao txBacklogDao;
    @Autowired
    private OrgPushCallInfoDao orgPushCallInfoDao;
    @Autowired
    private OrgStudentCourseService orgStudentCourseService;
    @Autowired(required=false)
    private CrmStudentQuery solrStudentQuery;
    @Autowired
    private TXCascadeCredentialDao txCascadeCredentialDao;
    @Autowired
    private OrgInfoDao orgInfoDao;
    @Autowired
    private TxAccountHelpService txAccountHelpService;
    @Autowired
    private TxCascadeCredentialService txCascadeCredentialService;
    @Autowired
    private ConsultAvatarUrlService consultAvatarUrlService;
    @Autowired
    private TxAccountPermissionService txAccountPermissionService;
    @Autowired
    private CrmStudentQuery crmStudentQuery;
    @Autowired
    private OrgWechatOpenIdRecordDao orgWechatOpenIdRecordDao;
    @Autowired
    private AuthorizationInfoDao authorizationInfoDao;
    @Autowired
    private OrgStudentLessonDao orgStudentLessonDao;
    @Autowired
    private ConsultUserStudentSynchService consultUserStudentSynchService;
    private LoadingCache<Long, Long> orgInfoCache = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterAccess(1L, TimeUnit.DAYS).build((CacheLoader)new CacheLoader<Long, Long>(){

        public Long load(Long orgId) throws Exception {
            OrgAccount byId = (OrgAccount)OrgStudentServiceImpl.this.orgAccountDao.getById((Serializable)orgId, new String[]{"number"});
            if (byId != null) {
                return byId.getNumber().longValue();
            }
            return null;
        }
    });

    @Override
    @Transactional(rollbackFor={Exception.class, BussinessException.class})
    public int syncStudent(PageDto pageDto) {
        log.info("############### start======");
        List students = this.orgStudentsDao.getStudentsByPage(pageDto);
        if (students != null) {
            for (OrgStudent student : students) {
                if (student.getMobile() == null || student.getName() == null) continue;
                List stuList = this.orgStudentsDao.getStudentsByMobileAndName(student.getOrgId(), student.getMobile(), student.getName());
                log.info("############### ====== size=" + stuList.size());
                if (stuList == null || stuList.size() <= 1) continue;
                for (int i = 0; i < stuList.size(); ++i) {
                    OrgStudent orgStudent = (OrgStudent)stuList.get(i);
                    orgStudent.setName(orgStudent.getName() + "(" + (i + 1) + ")");
                    log.info("############### ====== name=" + orgStudent.getName());
                    this.orgStudentsDao.saveOrUpdate((Object)orgStudent, new String[0]);
                }
            }
        }
        log.info("############### end======");
        return students.size();
    }

    @Override
    @Transactional(rollbackFor={Exception.class, BussinessException.class})
    public OrgStudentAddresponseDto addStudent(StudentInfoDto studentInfoDto, List<CommentInfoDto> commentDtos, List<TagInfoDto> tagDtos, Long orgId) throws BussinessException {
        User user;
        List orgStudents;
        log.debug("add student studentInfo={}, orgId={}", (Object)studentInfoDto, (Object)orgId);
        Preconditions.checkArgument((orgId != null ? 1 : 0) != 0, (Object)"orgId can not be null");
        if (StringUtils.isBlank((CharSequence)studentInfoDto.getMobile()) || StringUtils.isBlank((CharSequence)studentInfoDto.getName())) {
            log.warn("add student error: mobile or name is null!");
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR);
        }
        String mobile = studentInfoDto.getMobile();
        mobile = mobile.replaceAll("-", "");
        studentInfoDto.setMobile(mobile);
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{studentInfoDto.getParentMobile()})) {
            String parentMobile = studentInfoDto.getParentMobile();
            parentMobile = parentMobile.replaceAll("-", "");
            studentInfoDto.setParentMobile(parentMobile);
        }
        if (!ParamValidateUtils.validateMobile((String)studentInfoDto.getMobile())) {
            throw new BussinessException((UniverseErrorCode)StudentErrorCode.MOBILE_WRONG);
        }
        this.saveBefore(studentInfoDto, orgId);
        if (StringUtils.isBlank((CharSequence)studentInfoDto.getWeixin()) && (orgStudents = this.orgStudentsDao.getStudentByMobileAndOrgId(orgId, studentInfoDto.getMobile(), Integer.valueOf(100), new String[0])) != null) {
            for (OrgStudent orgStudent : orgStudents) {
                if (!StringUtils.isNotBlank((CharSequence)orgStudent.getWeixin())) continue;
                studentInfoDto.setWeixin(orgStudent.getWeixin());
                break;
            }
        }
        OrgStudentAddresponseDto response = new OrgStudentAddresponseDto();
        Long userId = null;
        Long userNumber = null;
        if (null != studentInfoDto.getStudentNumber() && studentInfoDto.getStudentNumber() > 0L && null != (user = this.userDao.getByNumber(studentInfoDto.getStudentNumber(), new String[]{"id", "number"}))) {
            userId = user.getId();
            userNumber = user.getNumber();
        }
        if (null == userId) {
            Map<String, Long> userInfoMap = OrgStudentUtil.getUserIdAndNumber(studentInfoDto.getName());
            userId = userInfoMap.get("id");
            userNumber = userInfoMap.get("number");
        }
        response.setUserId(userId);
        response.setUserNumber(userNumber);
        OrgStudent student = this.orgStudentsDao.getStudent(orgId, userId, null, new String[0]);
        if (student != null && student.getDelStatus().intValue() == DeleteStatus.NORMAL.getValue()) {
            throw new BussinessException((UniverseErrorCode)StudentErrorCode.MOBILE_REGISTERED);
        }
        if (student != null && student.getDelStatus().intValue() == DeleteStatus.DELETED.getValue()) {
            student.setDelStatus(Integer.valueOf(DeleteStatus.NORMAL.getValue()));
            response.setStudentId(student.getId());
            this.studentDto2Po(studentInfoDto, student, orgId, userId);
            student.setCreateTime(new Date());
            this.orgStudentsDao.updateWithDefaultVal((Object)student, new String[0]);
            if (studentInfoDto.getConsultUserId() == null) {
                this.saveCommentsAndTags(studentInfoDto, commentDtos, tagDtos, orgId, student);
                this.addSysBacklog(orgId, student, null);
            } else {
                this.txStudentCommentDao.updateComment(studentInfoDto.getConsultUserId(), userId);
                this.txStudentTagDao.updateTag(studentInfoDto.getConsultUserId(), userId);
                this.updateSysBacklog(orgId, student, studentInfoDto.getConsultUserId());
            }
            return response;
        }
        if (studentInfoDto.getConsultUserId() != null) {
            log.info("add orgStudent from consult_user");
            TxConsultUser consultUser = (TxConsultUser)this.txConsultUserDao.getById((Serializable)studentInfoDto.getConsultUserId(), new String[]{"orgId"});
            if (consultUser == null) {
                throw new BussinessException((UniverseErrorCode)StudentErrorCode.CONSULT_USER_NOT_EXIST);
            }
        }
        student = new OrgStudent();
        this.studentDto2Po(studentInfoDto, student, orgId, userId);
        student.setAddCascadeId(Integer.valueOf(studentInfoDto.getAddCascadeId() == null ? 0 : studentInfoDto.getAddCascadeId()));
        this.orgStudentsDao.save((Object)student, Boolean.valueOf(false), new String[0]);
        this.saveCommentsAndTags(studentInfoDto, commentDtos, tagDtos, orgId, student);
        if (studentInfoDto.getConsultUserId() != null) {
            this.txStudentCommentDao.updateComment(studentInfoDto.getConsultUserId(), userId);
            this.txStudentTagDao.updateTag(studentInfoDto.getConsultUserId(), userId);
            this.updateSysBacklog(orgId, student, studentInfoDto.getConsultUserId());
        } else {
            this.addSysBacklog(orgId, student, null);
        }
        log.info("addStudent success!");
        response.setStudentId(student.getId());
        return response;
    }

    @Override
    @Transactional(rollbackFor={Exception.class, BussinessException.class})
    public OrgStudentAddresponseDto addStudentIgnoreExistMobile(StudentInfoDto studentInfoDto, List<CommentInfoDto> commentDtos, List<TagInfoDto> tagDtos, Long orgId) throws BussinessException {
        User user;
        List orgStudents;
        log.debug("add student studentInfo={}, orgId={}", (Object)studentInfoDto, (Object)orgId);
        Preconditions.checkArgument((orgId != null ? 1 : 0) != 0, (Object)"orgId can not be null");
        if (StringUtils.isBlank((CharSequence)studentInfoDto.getMobile()) || StringUtils.isBlank((CharSequence)studentInfoDto.getName())) {
            log.warn("add student error: mobile or name is null!");
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR);
        }
        if (!ParamValidateUtils.validateMobile((String)studentInfoDto.getMobile())) {
            throw new BussinessException((UniverseErrorCode)StudentErrorCode.MOBILE_WRONG);
        }
        if (StringUtils.isBlank((CharSequence)studentInfoDto.getWeixin()) && (orgStudents = this.orgStudentsDao.getStudentByMobileAndOrgId(orgId, studentInfoDto.getMobile(), Integer.valueOf(100), new String[0])) != null) {
            for (OrgStudent orgStudent : orgStudents) {
                if (!StringUtils.isNotBlank((CharSequence)orgStudent.getWeixin())) continue;
                studentInfoDto.setWeixin(orgStudent.getWeixin());
                break;
            }
        }
        OrgStudentAddresponseDto response = new OrgStudentAddresponseDto();
        Long userId = null;
        Long userNumber = null;
        if (null != studentInfoDto.getStudentNumber() && studentInfoDto.getStudentNumber() > 0L && null != (user = this.userDao.getByNumber(studentInfoDto.getStudentNumber(), new String[]{"id", "number"}))) {
            userId = user.getId();
            userNumber = user.getNumber();
        }
        if (null == userId) {
            Map<String, Long> userInfoMap = OrgStudentUtil.getUserIdAndNumber(studentInfoDto.getName());
            userId = userInfoMap.get("id");
            userNumber = userInfoMap.get("number");
        }
        response.setUserId(userId);
        response.setUserNumber(userNumber);
        OrgStudent student = this.orgStudentsDao.getStudent(orgId, userId, null, new String[0]);
        if (student != null && student.getDelStatus().intValue() == DeleteStatus.NORMAL.getValue()) {
            throw new BussinessException((UniverseErrorCode)StudentErrorCode.MOBILE_REGISTERED);
        }
        if (student != null && student.getDelStatus().intValue() == DeleteStatus.DELETED.getValue()) {
            student.setDelStatus(Integer.valueOf(DeleteStatus.NORMAL.getValue()));
            response.setStudentId(student.getId());
            this.studentDto2Po(studentInfoDto, student, orgId, userId);
            student.setCreateTime(new Date());
            this.orgStudentsDao.update((Object)student, Boolean.valueOf(false), new String[0]);
            if (studentInfoDto.getConsultUserId() == null) {
                this.saveCommentsAndTags(studentInfoDto, commentDtos, tagDtos, orgId, student);
                this.addSysBacklog(orgId, student, null);
            } else {
                this.txStudentCommentDao.updateComment(studentInfoDto.getConsultUserId(), userId);
                this.txStudentTagDao.updateTag(studentInfoDto.getConsultUserId(), userId);
                this.updateSysBacklog(orgId, student, studentInfoDto.getConsultUserId());
            }
            return response;
        }
        if (studentInfoDto.getConsultUserId() != null) {
            log.info("add orgStudent from consult_user");
            TxConsultUser consultUser = (TxConsultUser)this.txConsultUserDao.getById((Serializable)studentInfoDto.getConsultUserId(), new String[]{"orgId"});
            if (consultUser == null) {
                throw new BussinessException((UniverseErrorCode)StudentErrorCode.CONSULT_USER_NOT_EXIST);
            }
        }
        Date now = new Date();
        student = new OrgStudent();
        student.setCreateTime(now);
        student.setUpdateTime(now);
        log.info("%%%%%%%@@  studentInfoDto:{}", (Object)studentInfoDto);
        student.setAddCascadeId(Integer.valueOf(studentInfoDto.getAddCascadeId() == null ? 0 : studentInfoDto.getAddCascadeId()));
        this.studentDto2Po(studentInfoDto, student, orgId, userId);
        log.info("%%%%%%%@@  student:{}", (Object)student);
        this.orgStudentsDao.save((Object)student, Boolean.valueOf(false), new String[0]);
        this.saveCommentsAndTags(studentInfoDto, commentDtos, tagDtos, orgId, student);
        if (studentInfoDto.getConsultUserId() != null) {
            this.txStudentCommentDao.updateComment(studentInfoDto.getConsultUserId(), userId);
            this.txStudentTagDao.updateTag(studentInfoDto.getConsultUserId(), userId);
            this.updateSysBacklog(orgId, student, studentInfoDto.getConsultUserId());
        } else {
            this.addSysBacklog(orgId, student, null);
        }
        log.info("addStudent success!");
        response.setStudentId(student.getId());
        return response;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void saveBefore(StudentInfoDto studentInfoDto, Long orgId) throws BussinessException {
        log.debug("saveBefore.studentInfoDto:{}", (Object)studentInfoDto);
        if (studentInfoDto.getNextRemindTime() != null && studentInfoDto.getNextRemindTime() > TianXiaoConstant.MAX_TIMESTAMP_CALEN.getTime().getTime()) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u4e0b\u6b21\u63d0\u9192\u65f6\u95f4\u8d85\u8fc7\u6700\u5927\u8303\u56f4(2037-1-1)\u4e86");
        }
        if (studentInfoDto.getBirthday() != null && studentInfoDto.getBirthday() > System.currentTimeMillis()) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u672a\u6765\u7684\u60a8\u8fd8\u672a\u51fa\u751f\u5427");
        }
        if (studentInfoDto.getConfirm() != null && studentInfoDto.getConfirm().intValue() != BizConf.FALSE.intValue()) return;
        OrgStudent student = null;
        if (studentInfoDto.getStudentId() != null && studentInfoDto.getStudentId() > 0L) {
            student = (OrgStudent)this.orgStudentsDao.getById((Serializable)studentInfoDto.getStudentId(), new String[0]);
            if (student == null || student.getOrgId().longValue() != orgId.longValue() || student.getDelStatus().intValue() != DeleteStatus.NORMAL.getValue()) throw new BussinessException((UniverseErrorCode)StudentErrorCode.STUDENT_NOT_EXIST);
            String mobile = student.getMobile();
            String name = student.getName();
            String paramMobile = studentInfoDto.getMobile();
            String paramName = student.getName();
            if (paramMobile.contains("****")) {
                paramMobile = mobile;
            }
            if (mobile.equals(paramMobile) && name.equals(paramName)) {
                return;
            }
            if (mobile.equals(paramMobile) && !name.equals(paramName)) {
                this.procSameMobileAndName(orgId, paramMobile, paramName);
                return;
            } else {
                this.procSameMobileAndName(orgId, studentInfoDto.getMobile(), studentInfoDto.getName());
                this.procSameMobile(orgId, paramMobile);
            }
            return;
        } else {
            this.procSameMobileAndName(orgId, studentInfoDto.getMobile(), studentInfoDto.getName());
            this.procSameMobile(orgId, studentInfoDto.getMobile());
        }
    }

    private void procSameMobileAndName(Long orgId, String mobile, String name) {
        OrgStudent student = this.orgStudentsDao.getStudentByMobileAndName(orgId, mobile, name);
        if (student != null) {
            throw new BussinessException((UniverseErrorCode)CrmErrorCode.STUDENT_HAS_EXISTS);
        }
    }

    private void procSameMobile(Long orgId, String mobile) {
        OrgStudent student = this.orgStudentsDao.getStudentByMobileAndOrgId(orgId, mobile, new String[0]);
        if (student != null) {
            throw new BussinessException((UniverseErrorCode)CrmErrorCode.CUSTOM_HAS_EXISTS);
        }
    }

    private void saveCommentsAndTags(StudentInfoDto studentInfoDto, List<CommentInfoDto> commentDtos, List<TagInfoDto> tagDtos, Long orgId, OrgStudent student) {
        ArrayList comments = Lists.newArrayList();
        ArrayList tags = Lists.newArrayList();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(commentDtos)) {
            for (CommentInfoDto commentInfoDto : commentDtos) {
                TxStudentComment comment = new TxStudentComment();
                if (studentInfoDto.getConsultUserId() != null) {
                    comment.setConsultUserId(studentInfoDto.getConsultUserId());
                }
                this.commentDto2Po(commentInfoDto, comment, student.getId(), StudentType.ORG_STUDENTS.getCode(), student);
                comments.add(comment);
            }
            this.txStudentCommentDao.saveAll((List)comments, new String[0]);
            log.info("add comments success!");
        }
        if (CollectionUtils.isNotEmpty(tagDtos)) {
            if (tagDtos.size() > 30) {
                throw new BussinessException((UniverseErrorCode)StudentErrorCode.MAX_TAGS);
            }
            for (TagInfoDto tagDto : tagDtos) {
                String content = tagDto.getContent();
                if (content.length() > 15) {
                    throw new BussinessException((UniverseErrorCode)StudentErrorCode.MAX_TAG_CONTENT_LENGTH);
                }
                TxStudentTag tag = new TxStudentTag();
                if (StringUtils.isNotBlank((CharSequence)content)) {
                    this.tagDto2Po(tagDto, tag, student.getId(), StudentType.ORG_STUDENTS.getCode(), student);
                }
                tags.add(tag);
            }
            this.txStudentTagDao.saveAll((List)tags, new String[]{"consultUserId", "userId", "orgId", "content"});
            log.info("add tags success!");
        }
    }

    private void studentDto2Po(StudentInfoDto dto, OrgStudent po, Long orgId, Long userId) {
        if (StringUtils.isNotBlank((CharSequence)dto.getMobile()) && !dto.getMobile().contains("****")) {
            if (!ParamValidateUtils.validateMobile((String)dto.getMobile())) {
                throw new BussinessException((UniverseErrorCode)StudentErrorCode.MOBILE_WRONG);
            }
            po.setShowMobile(dto.getMobile());
            po.setMobile(dto.getMobile());
        }
        po.setAddress(dto.getAddress());
        if (dto.getBirthday() != null && dto.getBirthday() > 0L) {
            po.setBirthday(new Date(dto.getBirthday()));
        } else {
            po.setBirthday(null);
        }
        po.setDegreeClass(dto.getDegreeClass());
        po.setFatherOccupation(dto.getFatherOccupation());
        po.setMail(dto.getMail());
        po.setMatherOccupation(dto.getMatherOccupation());
        po.setName(dto.getName());
        po.setNickName(dto.getName());
        if (dto.getNextRemindTime() != null && dto.getNextRemindTime() > 0L) {
            po.setNextRemindTime(new Date(dto.getNextRemindTime()));
        } else {
            po.setNextRemindTime(null);
        }
        po.setOrgId(orgId);
        po.setParentName(dto.getParentName());
        po.setParentMobile(dto.getParentMobile());
        po.setQq(dto.getQq());
        if (null != dto.getSource()) {
            po.setSource(dto.getSource());
        }
        if (po.getId() == null || po.getId() == 0L) {
            if (po.getSource() != null && po.getSource().intValue() == MessageSource.ONLINE_IM.getValue()) {
                po.setOrigin(Integer.valueOf(0));
            } else {
                po.setOrigin(Integer.valueOf(1));
            }
        }
        po.setRemark(dto.getRemark());
        po.setGender(dto.getGender());
        po.setUserId(userId);
        po.setWeixin(dto.getWeixin());
        po.setSchool(dto.getSchool());
        po.setBranchId(dto.getBranchId());
        po.setRelationship(dto.getRelationship());
        po.setAvatar(dto.getStorageId());
        po.setAreaId(dto.getAreaId());
        po.setLatitude(dto.getLatitude());
        po.setLongitude(dto.getLongitude());
    }

    private void checkAndCreateComment(StudentInfoDto dto, OrgStudent po) {
        String sourceName = po.getName();
        String sourceMobile = po.getMobile();
        String destName = dto.getName();
        String destMobile = dto.getMobile();
        ArrayList comments = Lists.newArrayList();
        if (destName != null && !destName.equals(sourceName)) {
            StringBuffer content = new StringBuffer();
            content.append(" \u5c06\u59d3\u540d\u3010").append(sourceName).append("\u3011").append("\u4fee\u6539\u4e3a\u3010").append(destName).append("\u3011");
            comments.add(this.generateComment(po.getOrgId(), content.toString(), po.getUserId()));
        }
        log.info("destMobile param:{}, sourceMobile param:{}", (Object)destMobile, (Object)sourceMobile);
        boolean isdozenMobile = false;
        String dozen = "****";
        if (destMobile.contains(dozen)) {
            isdozenMobile = true;
        }
        if (!isdozenMobile && destMobile != null && !destMobile.equals(sourceMobile)) {
            StringBuffer content = new StringBuffer();
            content.append(" \u5c06\u624b\u673a\u53f7\u3010").append(sourceMobile).append("\u3011").append("\u4fee\u6539\u4e3a\u3010").append(destMobile).append("\u3011");
            comments.add(this.generateComment(po.getOrgId(), content.toString(), po.getUserId()));
        }
        if (!comments.isEmpty()) {
            this.txStudentCommentDao.saveAll((List)comments, new String[0]);
        }
    }

    private TxStudentComment generateComment(long orgId, String content, long userId) {
        TxStudentComment comment = new TxStudentComment();
        comment.setContent(content);
        comment.setCreateTime(new Date());
        comment.setIsSystem(BizConf.TRUE);
        comment.setOrgId(Long.valueOf(orgId));
        comment.setOrigin(0);
        comment.setUserId(Long.valueOf(userId));
        return comment;
    }

    private void commentDto2Po(CommentInfoDto dto, TxStudentComment po, Long studentId, Integer type, OrgStudent student) {
        if (type.intValue() == StudentType.ORG_STUDENTS.getCode()) {
            po.setOrgId(student.getOrgId());
            po.setUserId(student.getUserId());
        }
        po.setSeconds(dto.getSeconds());
        po.setDownStatus(Integer.valueOf(DownLoadStatus.FINISH.getCode()));
        po.setSoundId(dto.getSoundId());
        po.setStorageIds(dto.getStorageIds());
        po.setContent(dto.getContent());
    }

    private void tagDto2Po(TagInfoDto dto, TxStudentTag po, Long studentId, Integer type, OrgStudent student) {
        if (type.intValue() == StudentType.ORG_STUDENTS.getCode()) {
            po.setOrgId(student.getOrgId());
            po.setUserId(student.getUserId());
        } else {
            po.setConsultUserId(studentId);
        }
        po.setContent(dto.getContent());
    }

    private void studentPo2Dto(OrgStudent po, StudentInfoDto dto, Long orgNumber) {
        OrgStorage storage;
        dto.setOrigin(po.getOrigin());
        dto.setStudentId(po.getId());
        dto.setAddress(po.getAddress());
        if (po.getBirthday() != null) {
            dto.setBirthday(po.getBirthday().getTime());
        }
        dto.setDegreeClass(po.getDegreeClass());
        dto.setFatherOccupation(po.getFatherOccupation());
        dto.setMail(po.getMail());
        dto.setMatherOccupation(po.getMatherOccupation());
        dto.setMobile(po.getMobile());
        dto.setName(po.getName());
        if (StringUtils.isBlank((CharSequence)po.getName())) {
            if (StringUtils.isNotEmpty((CharSequence)po.getNickName())) {
                dto.setName(po.getNickName());
            } else {
                dto.setName(MaskUtil.maskMobile((String)po.getMobile()));
            }
        }
        if (po.getNextRemindTime() != null) {
            dto.setNextRemindTime(po.getNextRemindTime().getTime());
        }
        dto.setParentMobile(po.getParentMobile());
        dto.setParentName(po.getParentName());
        dto.setGender(po.getGender());
        dto.setBranchId(po.getBranchId());
        dto.setRelationship(po.getRelationship());
        dto.setQq(po.getQq());
        dto.setSchool(po.getSchool());
        dto.setSource(po.getSource());
        dto.setLatitude(po.getLatitude());
        dto.setLongitude(po.getLongitude());
        dto.setAreaId(po.getAreaId());
        dto.setWeixin(StringUtils.isNotBlank((CharSequence)po.getWeixin()) ? po.getWeixin() : this.getWeixinOpenId(dto.getConsultUserId()));
        if (po.getAvatar() != null && (storage = this.orgStorageDao.getById(po.getAvatar().intValue())) != null) {
            dto.setStorageId(storage.getId().longValue());
            String url = StorageUtil.constructUrl((String)storage.getFid(), (String)storage.getSn(), (Integer)storage.getMimeType());
            dto.setAvatarUrl(url);
        }
    }

    private String getWeixinOpenId(Long consultId) {
        TxConsultUser consulter;
        String weixinOpenId = "";
        if (consultId != null && consultId > 0L && (consulter = (TxConsultUser)this.txConsultUserDao.getById((Serializable)consultId, new String[0])) != null) {
            weixinOpenId = consulter.getWeixinOpenId();
        }
        return weixinOpenId;
    }

    @Override
    public void setPayMoneyAndTimes(Long userId, Long orgNumber, Long orgId, StudentInfoDto dto) {
        if (dto == null) {
            dto = new StudentInfoDto();
        }
        if (dto.getUserId() != null) {
            userId = dto.getUserId();
        }
        if (userId == null && dto != null && dto.getStudentId() != null) {
            userId = this.getUserId(dto.getStudentId());
            dto.setUserId(userId);
        }
        if (orgNumber == null) {
            try {
                orgNumber = (Long)this.orgInfoCache.get((Object)orgId);
            }
            catch (ExecutionException e) {
                throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, orgId + "\u5bf9\u5e94\u7684\u673a\u6784\u4e0d\u5b58\u5728!");
            }
        }
        List signupPurchase = this.orgSignupInfoDao.getPurchases(userId, orgNumber, null, Integer.valueOf(PayStatus.SUCESS.getCode()), new String[]{"totalPrices", "signupPurchaseId"});
        HashSet courseIds = Sets.newHashSet();
        HashSet purchaseIds = Sets.newHashSet();
        double payMoney = 0.0;
        log.info("OrgStudentServiceImpl:getPayMoneyAndTimes--------signupPurchase{}", (Object)signupPurchase);
        for (Object orgSignupInfo : signupPurchase) {
            payMoney += orgSignupInfo.getTotalPrices().doubleValue() / 100.0;
            purchaseIds.add(orgSignupInfo.getSignupPurchaseId());
        }
        log.info("OrgStudentServiceImpl:getPayMoneyAndTimes---------purchaseIds{}", (Object)purchaseIds);
        List sinupCourses = this.orgSignupCourseDao.loadByPurchaseIds((Collection)purchaseIds, new String[]{"orgCourseId"});
        for (OrgSignupCourse orgSignupCourse : sinupCourses) {
            courseIds.add(orgSignupCourse.getOrgCourseId());
        }
        log.info("OrgStudentServiceImpl:getPayMoneyAndTimes---------sinupCourses{}", (Object)sinupCourses);
        List mPurchase = this.coursePurchaseDao.getCoursePurchaseList(orgId, userId, Long.valueOf(0L), Integer.valueOf(CourseType.ORG_COURSE.getCode()), Integer.valueOf(PayStatus.SUCESS.getCode()), new String[0]);
        for (CoursePurchase coursePurchase : mPurchase) {
            payMoney += coursePurchase.getPayMoney().doubleValue();
            courseIds.add(coursePurchase.getCourseId());
        }
        log.info("OrgStudentServiceImpl:getPayMoneyAndTimes---------courseIds{}", (Object)courseIds);
        dto.setStar(StarEnum.getStarByPrice(payMoney).getCode());
        dto.setPayMoney(payMoney);
        log.info("studentId ={}, payMoney={}", (Object)orgId, (Object)payMoney);
    }

    @Override
    public void setClassHour(Long userId, Long orgId, StudentInfoDto dto) {
        if (dto == null) {
            dto = new StudentInfoDto();
        }
        if (dto.getUserId() != null) {
            userId = dto.getUserId();
        }
        if (userId == null && dto != null && dto.getStudentId() != null) {
            userId = this.getUserId(dto.getStudentId());
            dto.setUserId(userId);
        }
        List courseList = this.orgStudentCourseDao.getOrgCourseIds(orgId, userId, null, null);
        int finishCount = 0;
        int leftCount = 0;
        int totalCount = 0;
        try {
            List list = this.solrStudentQuery.queryStudentClassHourList(userId, orgId);
            Map classHourMap = com.baijia.commons.lang.utils.collection.CollectionUtils.extractMap((Collection)list, (CollectionUtils.Extracter)new CollectionUtils.Extracter<Long, StudentClassHour>(){

                public Long extract(StudentClassHour classHour) {
                    return classHour.getCourseId();
                }
            });
            for (OrgStudentCourse course : courseList) {
                StudentClassHour classHour = (StudentClassHour)classHourMap.get(course.getCourseId());
                int tmp = 0;
                if (course.getStatus().intValue() == StudentCourseStatus.NORMAL.getCode()) {
                    if (classHour != null) {
                        log.info("[ClassHour] classHour={},courseId={}", (Object)classHour, (Object)classHour.getCourseId());
                        leftCount += classHour.getLeftCount();
                        finishCount += classHour.getFinishCount();
                        tmp = classHour.getLeftCount() + classHour.getFinishCount();
                    }
                    tmp = Math.max(tmp, course.getLessonCount());
                    log.info("[ClassHour] classHour={},tmp={}", (Object)classHour, (Object)tmp);
                    totalCount += tmp;
                    continue;
                }
                if (classHour == null) continue;
                log.info("[ClassHour] classHour={},courseId={}", (Object)classHour, (Object)classHour.getCourseId());
                finishCount += classHour.getFinishCount();
                totalCount += classHour.getFinishCount();
            }
        }
        catch (Exception e) {
            log.error("[Solr] Query exception", (Throwable)e);
        }
        dto.setTotalClassTime(totalCount);
        dto.setFinishClassTime(finishCount);
    }

    private Long getUserId(Long studentId) {
        OrgStudent orgStudent = (OrgStudent)this.orgStudentsDao.getById((Serializable)studentId, new String[]{"userId"});
        if (orgStudent == null) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, String.format("id%s\u5bf9\u5e94\u7684\u5b66\u5458\u4e0d\u5b58\u5728!", studentId));
        }
        User user = (User)this.userDao.getById((Serializable)orgStudent.getUserId(), new String[0]);
        if (user == null) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, String.format("id%s\u5bf9\u5e94\u7684\u7528\u6237\u4e0d\u5b58\u5728!", studentId));
        }
        return orgStudent.getUserId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void delStudent(StudentCommenRequestDto studentCommenRequestDto, Long orgId) {
        Preconditions.checkArgument((orgId != null ? 1 : 0) != 0, (Object)"orgId can not be null");
        if (studentCommenRequestDto.getStudentId() == null) {
            log.warn("mod student error: studentId is null!");
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR);
        }
        OrgStudent orgStudent = (OrgStudent)this.orgStudentsDao.getById((Serializable)studentCommenRequestDto.getStudentId(), new String[0]);
        if (orgStudent == null || orgStudent.getDelStatus().intValue() == DeleteStatus.DELETED.getValue() || orgStudent.getOrgId().longValue() != orgId.longValue()) {
            throw new BussinessException((UniverseErrorCode)StudentErrorCode.STUDENT_NOT_EXIST);
        }
        studentCommenRequestDto.setUserId(orgStudent.getUserId());
        List consultUserList = this.txConsultUserDao.lookByStudentId(orgId, studentCommenRequestDto.getStudentId(), new String[0]);
        log.info("OrgStudentServiceImpl:delStudent--------consultUserList={}", (Object)consultUserList);
        if (null != consultUserList && !consultUserList.isEmpty()) {
            this.delSysBacklog(orgId, orgStudent, (TxConsultUser)consultUserList.get(0));
            for (TxConsultUser consulterUser : consultUserList) {
                consulterUser.setStudentId(Long.valueOf(0L));
                consulterUser.setIsConsulter(Integer.valueOf(0));
                this.txConsultUserDao.update((Object)consulterUser, new String[]{"studentId", "isConsulter"});
            }
        } else {
            this.delSysBacklog(orgId, orgStudent, null);
        }
        orgStudent.setDelStatus(Integer.valueOf(DeleteStatus.DELETED.getValue()));
        TxStudentComment comment = new TxStudentComment();
        comment.setContent("\u673a\u6784\u5220\u9664\u5b66\u5458");
        comment.setUserId(orgStudent.getUserId());
        comment.setOrgId(orgStudent.getOrgId());
        comment.setIsSystem(Integer.valueOf(AddType.SYSTEM.getCode()));
        this.txStudentCommentDao.save((Object)comment, new String[0]);
        this.txStudentTagDao.delTags(orgStudent.getUserId(), orgId);
        this.orgStudentsDao.update((Object)orgStudent, new String[]{"delStatus"});
        this.updateSolr(orgStudent);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void modStudent(StudentInfoDto studentInfoDto, List<CommentInfoDto> commentDtos, List<TagInfoDto> tagDtos, Long orgId) {
        Preconditions.checkArgument((orgId != null ? 1 : 0) != 0, (Object)"orgId can not be null");
        if (studentInfoDto.getStudentId() == null) {
            log.warn("mod student error: studentId is null!");
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR);
        }
        this.saveBefore(studentInfoDto, orgId);
        OrgStudent orgStudent = (OrgStudent)this.orgStudentsDao.getById((Serializable)studentInfoDto.getStudentId(), new String[0]);
        log.info("orgStudent param:{}", (Object)orgStudent);
        if (orgStudent == null || orgStudent.getDelStatus().intValue() == DeleteStatus.DELETED.getValue() || orgStudent.getOrgId().longValue() != orgId.longValue()) {
            throw new BussinessException((UniverseErrorCode)StudentErrorCode.STUDENT_NOT_EXIST);
        }
        this.checkAndCreateComment(studentInfoDto, orgStudent);
        this.cascadeUpdateTxConsultName(orgId, orgStudent, studentInfoDto);
        this.studentDto2Po(studentInfoDto, orgStudent, orgId, orgStudent.getUserId());
        log.info("studentId param:{}, orgId param:{}", (Object)orgStudent.getUserId(), (Object)orgId);
        this.txStudentTagDao.delTags(orgStudent.getUserId(), orgId);
        if (GenericsUtils.notNullAndEmpty(tagDtos)) {
            if (tagDtos.size() > 30) {
                throw new BussinessException((UniverseErrorCode)StudentErrorCode.MAX_TAGS);
            }
            ArrayList<TxStudentTag> tags = new ArrayList<TxStudentTag>();
            for (TagInfoDto tagInfoDto : tagDtos) {
                String content = tagInfoDto.getContent();
                if (content.length() > 15) {
                    throw new BussinessException((UniverseErrorCode)StudentErrorCode.MAX_TAG_CONTENT_LENGTH);
                }
                TxStudentTag tag = new TxStudentTag();
                this.tagDto2Po(tagInfoDto, tag, orgStudent.getId(), StudentType.ORG_STUDENTS.getCode(), orgStudent);
                tags.add(tag);
            }
            this.txStudentTagDao.delTags(orgStudent.getUserId(), orgId);
            this.txStudentTagDao.saveAll(tags, new String[]{"consultUserId", "userId", "orgId", "content"});
            log.info("add tags success!");
        } else {
            this.txStudentTagDao.delTags(orgStudent.getUserId(), orgId);
        }
        orgStudent.setUpdateTime(new Date());
        this.orgStudentsDao.updateWithDefaultVal((Object)orgStudent, new String[0]);
        this.updateSysBacklog(orgId, orgStudent, null);
    }

    private void cascadeUpdateTxConsultName(long orgId, OrgStudent orgStudent, StudentInfoDto studentInfo) {
        List consultUsers;
        boolean updateMobile;
        boolean updateName = !studentInfo.getName().equals(orgStudent.getName());
        boolean bl = updateMobile = !studentInfo.getMobile().equals(orgStudent.getMobile());
        if ((updateName || updateMobile) && (consultUsers = this.txConsultUserDao.lookByStudentId(Long.valueOf(orgId), orgStudent.getId(), new String[0])) != null && !consultUsers.isEmpty()) {
            for (TxConsultUser consultUser : consultUsers) {
                consultUser.setName(updateName ? studentInfo.getName() : null);
                consultUser.setMobile(updateMobile ? studentInfo.getMobile() : null);
                consultUser.setUpdateTime(new Date());
                this.txConsultUserDao.update((Object)consultUser, Boolean.valueOf(false), new String[0]);
            }
        }
    }

    private void cascadeUpdateTxConsultName(long orgId, long studentId, String sourceName, String destName) {
        List consultUsers;
        if (!destName.equals(sourceName) && (consultUsers = this.txConsultUserDao.lookByStudentId(Long.valueOf(orgId), Long.valueOf(studentId), new String[0])) != null && !consultUsers.isEmpty()) {
            for (TxConsultUser consultUser : consultUsers) {
                consultUser.setName(destName);
                consultUser.setUpdateTime(new Date());
                this.txConsultUserDao.update((Object)consultUser, new String[]{"name", "updateTime"});
            }
        }
    }

    @Override
    @Transactional(readOnly=true)
    public StudentInfoDto getStudentInfo(StudentCommenRequestDto studentCommenRequestDto, Long orgId, Integer cascadeId) {
        Preconditions.checkArgument((orgId != null ? 1 : 0) != 0, (Object)"orgId can not be null");
        Long studentId = studentCommenRequestDto.getStudentId();
        Integer applicationType = studentCommenRequestDto.getApplicationType();
        StudentInfoDto dto = new StudentInfoDto();
        this.setStudentBaseInfo(studentId, orgId, cascadeId, dto);
        Long userId = dto.getUserId();
        Long orgNumber = dto.getOrgNumber();
        Boolean isShowMobile = dto.getIsShowMobile();
        dto.setCascadeId(cascadeId);
        this.setPayMoneyAndTimes(userId, orgNumber, orgId, dto);
        this.setClassHour(userId, orgId, dto);
        this.setStudentComment(userId, orgId, isShowMobile, dto);
        this.setStudentTags(userId, orgId, dto);
        this.setHeaderAndClassNum(userId, orgId, cascadeId, applicationType, dto);
        this.setFansInfo(studentId, orgId, dto);
        return dto;
    }

    @Override
    public void setStudentBaseInfo(Long studentId, Long orgId, Integer cascadeId, StudentInfoDto dto) {
        User user;
        OrgAccount account = (OrgAccount)this.orgAccountDao.getById((Serializable)orgId, new String[0]);
        Long orgNumber = null;
        if (account == null) {
            throw new BussinessException((UniverseErrorCode)StudentErrorCode.ORG_NOT_EXIST);
        }
        orgNumber = account.getNumber().longValue();
        if (studentId == null) {
            log.warn("get student info error: studentId is null!");
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR);
        }
        OrgStudent orgStudent = (OrgStudent)this.orgStudentsDao.getById((Serializable)studentId, new String[0]);
        log.debug("query result------student:{}", (Object)orgStudent);
        if (orgStudent == null || orgStudent.getDelStatus().intValue() == DeleteStatus.DELETED.getValue() || orgStudent.getOrgId().longValue() != orgId.longValue()) {
            throw new BussinessException((UniverseErrorCode)StudentErrorCode.STUDENT_NOT_EXIST);
        }
        AccountRoleType findAccountRoleType = this.txAccountHelpService.findAccountRoleType(orgId, cascadeId);
        if (findAccountRoleType.getRoleType() == RoleType.EMPLOYEE) {
            boolean canVisit = false;
            canVisit = orgStudent.getAddCascadeId().equals(cascadeId) ? true : this.checkCanVisit(orgStudent.getUserId(), orgNumber.intValue(), cascadeId, orgId);
            if (!canVisit) {
                throw new BussinessException((UniverseErrorCode)StudentErrorCode.STUDENT_NOT_BELONG);
            }
        }
        if ((user = (User)this.userDao.getById((Serializable)orgStudent.getUserId(), new String[0])) == null) {
            throw new BussinessException((UniverseErrorCode)StudentErrorCode.STUDENT_NOT_EXIST);
        }
        boolean isShowMobile = this.isShowMobileForStudentInfo(orgId, cascadeId);
        dto.setUserId(user.getId());
        dto.setOrgNumber(orgNumber);
        dto.setIsShowMobile(isShowMobile);
        List consults = this.txConsultUserDao.lookByStudentId(orgId, orgStudent.getId(), new String[0]);
        if (CollectionUtils.isNotEmpty((Collection)consults)) {
            HashSet consultUserIds = Sets.newHashSet();
            for (TxConsultUser txConsultUser : consults) {
                consultUserIds.add(txConsultUser.getId());
            }
            dto.setConsultUserIds(StringUtils.join((Object[])consultUserIds.toArray(), (char)','));
            dto.setConsultUserId(((TxConsultUser)consults.get(0)).getId());
        }
        dto.setStudentNumber(user.getNumber());
        this.studentPo2Dto(orgStudent, dto, orgNumber);
        Map studentAvatarUrlMap = this.consultAvatarUrlService.batchStudentAvatarUrlAndNameDMap((Collection)Lists.newArrayList((Object[])new Long[]{user.getId()}), orgId);
        ConsultAvatarUrlAndNameDto avartarUrlDto = (ConsultAvatarUrlAndNameDto)studentAvatarUrlMap.get(user.getId());
        String avatarUrl = avartarUrlDto.getAvatarUrl();
        log.info("avatarUrl param:{}", (Object)avatarUrl);
        dto.setAvatarUrl(avatarUrl);
        if (!isShowMobile) {
            dto.setMobile(MaskUtil.maskMobile((String)dto.getMobile()));
            dto.setParentMobile(MaskUtil.maskMobile((String)dto.getParentMobile()));
        }
        if (null != dto.getAreaId() && dto.getAreaId() > 0) {
            Map areaMap = AreaUtils.getAreaNameByCode((Integer)dto.getAreaId());
            log.debug("\u533a\u57df\u4fe1\u606fareaMap {}", (Object)areaMap);
            dto.setProvince((String)areaMap.get("province"));
            dto.setCity((String)areaMap.get("city"));
            dto.setCounty((String)areaMap.get("county"));
        }
    }

    @Override
    public boolean isShowMobileForStudentInfo(Long orgId, Integer cascadeId) {
        if (orgId == null) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.NO_LOGIN, "organization does not exists");
        }
        return this.txCascadeCredentialService.isShowMobile(orgId, cascadeId);
    }

    @Override
    public void setHeaderAndClassNum(Long userId, Long orgId, Integer cascadeId, Integer applicationType, StudentInfoDto dto) {
        boolean hasPermission;
        boolean isStaffAccount = false;
        if (cascadeId != null && !(hasPermission = this.txAccountPermissionService.hasPermission(Long.valueOf(cascadeId.longValue()), ApplicationType.getApplicationType((Integer)applicationType), TXPermissionConst.SEE_ALL_ORG_STUDENTS))) {
            isStaffAccount = true;
        }
        if (dto == null) {
            dto = new StudentInfoDto();
        }
        if (dto.getUserId() != null) {
            userId = dto.getUserId();
        }
        if (userId == null && dto != null && dto.getStudentId() != null) {
            userId = this.getUserId(dto.getStudentId());
            dto.setUserId(userId);
        }
        HashSet<Integer> casCadeIds = new HashSet<Integer>();
        List orgCourseIds = this.orgStudentCourseDao.getOrgCourseIds(orgId, userId, null);
        List courseIds = ListUtil.toKeyList((Collection)orgCourseIds, (String)"courseId", OrgStudentCourse.class);
        List courses = this.orgCourseDao.getByIds((Collection)courseIds, new String[]{"cascadeId"});
        List retCascadeIds = ListUtil.toKeyList((Collection)courses, (String)"cascadeId", OrgCourse.class);
        if (!isStaffAccount) {
            casCadeIds.addAll(retCascadeIds);
        } else if (cascadeId != null && retCascadeIds.contains(cascadeId)) {
            casCadeIds.add(cascadeId);
        }
        Map txCascadCredentialListByCascdeIds = this.txCascadeCredentialDao.getTxCascadCredentialListByCascdeIds(casCadeIds);
        StringBuilder sb = new StringBuilder();
        if (casCadeIds.contains(0)) {
            OrgInfo orginfo = this.orgInfoDao.getOrgInfo(Integer.valueOf(orgId.intValue()), new String[0]);
            txCascadCredentialListByCascdeIds.put(0L, orginfo.getContacts());
        }
        for (String name : txCascadCredentialListByCascdeIds.values()) {
            sb.append(name).append("\u3001");
        }
        String headTeacherNames = GenericsUtils.deleteLastCharToString((StringBuilder)sb);
        dto.setHeadTeacher(headTeacherNames);
        Integer sumClasses = GenericsUtils.isNullOrEmpty((Object)orgCourseIds) ? 0 : orgCourseIds.size();
        dto.setSumClasses(sumClasses);
    }

    @Override
    public void setStudentTags(Long userId, Long orgId, StudentInfoDto dto) {
        if (userId == null && dto != null && dto.getStudentId() != null) {
            userId = this.getUserId(dto.getStudentId());
        }
        List tags = this.txStudentTagDao.getTags(userId, orgId, Integer.valueOf(StudentType.ORG_STUDENTS.getCode()), new String[0]);
        ArrayList tagsDto = Lists.newArrayList();
        for (TxStudentTag tag : tags) {
            TagInfoDto tagDto = new TagInfoDto();
            this.tagPo2Dto(tagDto, tag);
            tagsDto.add(tagDto);
        }
        dto.setTagsResp(tagsDto);
    }

    @Override
    public void setStudentComment(Long userId, Long orgId, Boolean isShowMobile, StudentInfoDto dto) {
        if (userId == null && dto != null && dto.getStudentId() != null) {
            userId = this.getUserId(dto.getStudentId());
        }
        if (isShowMobile == null) {
            isShowMobile = this.txCascadeCredentialService.isShowMobile(orgId, dto.getCascadeId());
        }
        List comments = this.txStudentCommentDao.getComments(userId, orgId, Integer.valueOf(StudentType.ORG_STUDENTS.getCode()), new String[0]);
        log.info("OrgStudentServiceImpl:getStudentInfo--------List<TxStudentComment> comments={}", (Object)comments);
        ArrayList commentsDto = Lists.newArrayList();
        HashSet callIds = Sets.newHashSet();
        HashSet call400Ids = Sets.newHashSet();
        for (TxStudentComment comment : comments) {
            if (comment.getDownStatus().intValue() != DownLoadStatus.UNFINISH.getCode()) continue;
            if (comment.getIsMobile().intValue() == MobileStatus.IS_CALL.getCode()) {
                callIds.add(comment.getSoundId());
                continue;
            }
            if (comment.getIsMobile().intValue() != MobileStatus.IS_400_CALL.getCode()) continue;
            call400Ids.add(comment.getSoundId());
        }
        Map<Long, Long> callMap = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty((Collection)callIds)) {
            List callInfos = this.callServiceInfoDao.getByIds((Collection)callIds, new String[0]);
            callMap = CollectorUtil.collectMap((Collection)callInfos, (Function)new Function<CallServiceInfo, Long>(){

                public Long apply(CallServiceInfo arg0) {
                    return arg0.getId();
                }
            }, (Function)new Function<CallServiceInfo, Long>(){

                public Long apply(CallServiceInfo arg0) {
                    return arg0.getStorageId();
                }
            });
        }
        Map<Long, Long> call400Map = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty((Collection)call400Ids)) {
            List call400Infos = this.orgPushCallInfoDao.getByIds((Collection)call400Ids, new String[0]);
            call400Map = CollectorUtil.collectMap((Collection)call400Infos, (Function)new Function<OrgPushCallInfo, Long>(){

                public Long apply(OrgPushCallInfo arg0) {
                    return arg0.getId();
                }
            }, (Function)new Function<OrgPushCallInfo, Long>(){

                public Long apply(OrgPushCallInfo arg0) {
                    return arg0.getStorageId();
                }
            });
        }
        HashSet storageIds = Sets.newHashSet();
        for (TxStudentComment comment : comments) {
            if (StringUtils.isNotEmpty((CharSequence)comment.getStorageIds())) {
                String[] storageIdsStr = comment.getStorageIds().split(",");
                for (String storageId : storageIdsStr) {
                    storageIds.add(Integer.parseInt(storageId));
                }
            }
            if (comment.getDownStatus().intValue() == DownLoadStatus.UNFINISH.getCode()) {
                Long storageId = null;
                if (comment.getIsMobile().intValue() == MobileStatus.IS_CALL.getCode()) {
                    storageId = (Long)callMap.get(comment.getSoundId());
                } else if (comment.getIsMobile().intValue() == MobileStatus.IS_400_CALL.getCode()) {
                    storageId = (Long)call400Map.get(comment.getSoundId());
                }
                if (storageId == null || storageId <= 0L) continue;
                storageIds.add(storageId.intValue());
                continue;
            }
            if (comment.getDownStatus().intValue() != DownLoadStatus.FINISH.getCode() || comment.getSoundId() == null || comment.getSoundId() <= 0L) continue;
            storageIds.add(comment.getSoundId().intValue());
        }
        List storages = this.orgStorageDao.getByIds((Collection)storageIds, new String[0]);
        Map storageMap = CollectorUtil.collectMap((Collection)storages, (Function)new Function<OrgStorage, Integer>(){

            public Integer apply(OrgStorage arg0) {
                return arg0.getId();
            }
        });
        HashSet<Integer> cascadeIds = new HashSet<Integer>();
        for (TxStudentComment comment : comments) {
            cascadeIds.add(comment.getCreatorCascadeId());
        }
        Map cascadeIdVSNameMap = this.txCascadeCredentialDao.getTxCascadCredentialListByCascdeIds(cascadeIds);
        OrgInfo orgInfo = this.orgInfoDao.getOrgInfo(Integer.valueOf(orgId.intValue()), new String[0]);
        cascadeIdVSNameMap.put(0L, orgInfo.getShowName());
        for (TxStudentComment comment : comments) {
            CommentInfoDto commentDto = new CommentInfoDto();
            this.commentPo2Dto(commentDto, comment, callMap, call400Map, storageMap, cascadeIdVSNameMap);
            if (!isShowMobile.booleanValue()) {
                commentDto.setContent(CommentUtil.maskMobile(comment.getContent()));
            }
            commentsDto.add(commentDto);
        }
        log.info("OrgStudentServiceImpl:getStudentInfo--------List<CommentInfoDto> commentsDto={}", (Object)commentsDto);
        dto.setCommentsResp(commentsDto);
    }

    public static void main(String[] args) {
        Map areaMap = AreaUtils.getAreaNameByCode((Integer)0x11081000);
        Gson gson = new Gson();
        System.out.println(gson.toJson((Object)areaMap));
    }

    @Override
    public StudentCustomFieldResponse getSimpleStudentInfo(StudentCommenRequestDto studentCommenRequestDto, Long orgId, Integer cascadeId) {
        StudentInfoDto dto = new StudentInfoDto();
        if (studentCommenRequestDto.getStudentId() != null && studentCommenRequestDto.getStudentId() > 0L) {
            dto = this.getStudentInfo(studentCommenRequestDto, orgId, cascadeId);
        }
        StudentCustomFieldResponse response = new StudentCustomFieldResponse();
        BeanUtils.copyProperties((Object)((Object)dto), (Object)((Object)response));
        return response;
    }

    @Override
    public boolean checkCanVisit(Long userId, Integer orgNumber, Integer cascadeId, Long orgId) {
        List courseByCasCadeIds = this.orgCourseDao.getCourseByCasCadeIds(orgNumber, Arrays.asList(cascadeId), null, CourseTypeEnum.IS_CLASS_TRUE.getCode(), null, new String[]{"id"});
        if (GenericsUtils.isNullOrEmpty((Object)courseByCasCadeIds)) {
            return false;
        }
        List courseIds = ListUtil.toKeyList((Collection)courseByCasCadeIds, (String)"id", OrgCourse.class);
        for (Long courseId : courseIds) {
            OrgStudentCourse studentCourse = this.orgStudentCourseDao.getStudentCourse(orgId, courseId, userId);
            if (studentCourse == null) continue;
            return true;
        }
        return false;
    }

    private int sumClasses(long orgId, long userId) {
        HashSet<Long> ret = new HashSet<Long>();
        List courseIds = this.orgStudentCourseDao.getStudentCourseIds(Long.valueOf(orgId), Long.valueOf(userId), Integer.valueOf(0));
        ret.addAll(courseIds);
        try {
            List classHourList = this.solrStudentQuery.queryStudentClassHourList(Long.valueOf(userId), Long.valueOf(orgId));
            for (StudentClassHour classHour : classHourList) {
                ret.add(classHour.getCourseId());
            }
        }
        catch (Exception e) {
            log.error("[Solr] Query exception.", (Throwable)e);
        }
        return ret.size();
    }

    private Integer getSignupClassCount(OrgStudent po, long orgNumber) {
        return this.orgStudentCourseService.getStudentSignupCourse(po, orgNumber);
    }

    @Override
    public void setFansInfo(Long studentId, Long orgId, StudentInfoDto dto) {
        log.info("this.authorizationInfoDao is null : {} ", (Object)(this.authorizationInfoDao == null ? 1 : 0));
        AuthorizationInfo authorizationInfo = this.authorizationInfoDao.getByOrgId(Integer.valueOf(orgId.intValue()));
        OrgWechatOpenIdRecord record = null;
        if (authorizationInfo == null || authorizationInfo.getAuthorizerAppId().equals(WechatProperties.getWechatAppidForFreeVersion())) {
            log.info("000000");
            record = this.orgWechatOpenIdRecordDao.getBy(WechatProperties.getWechatAppidForFreeVersion(), orgId, studentId, WechatOpenIdEntityType.STUDENT);
        } else {
            log.info("11111");
            record = this.orgWechatOpenIdRecordDao.getBy(authorizationInfo.getAuthorizerAppId(), orgId, studentId, WechatOpenIdEntityType.STUDENT);
        }
        log.info("record is :{} ", (Object)record);
        dto.setChat(BizConf.FALSE);
        if (record != null) {
            Fans fans = this.fansDao.getByOpenId(record.getOpenId());
            log.info("fans is :{} ", (Object)fans);
            if (fans != null && fans.isSubscribed()) {
                dto.setChat(BizConf.TRUE);
                dto.setLastCommunicationTime(fans.getLastCommunicationTime() == null ? null : Long.valueOf(fans.getLastCommunicationTime().getTime()));
            }
        }
    }

    private void commentPo2Dto(CommentInfoDto dto, TxStudentComment po, Map<Long, Long> callMap, Map<Long, Long> call400Map, Map<Integer, OrgStorage> storageMap, Map<Long, String> cascadeIdVSNameMap) {
        OrgStorage storage;
        dto.setCommentId(po.getId());
        dto.setContent(po.getContent());
        dto.setStorageIds(po.getStorageIds());
        dto.setCreateTime(po.getCreateTime());
        dto.setCallStatus(po.getCallStatus());
        dto.setIsMobile(po.getIsMobile());
        dto.setIsSystem(po.getIsSystem());
        if (null != po.getIsMobile() && po.getIsMobile().intValue() == MobileStatus.IS_CALL.getCode()) {
            dto.setOrigin(-1);
        } else {
            dto.setOrigin(po.getOrigin());
        }
        if (StringUtils.isNotEmpty((CharSequence)dto.getStorageIds())) {
            String[] storageIdsStr = dto.getStorageIds().split(",");
            ArrayList urls = Lists.newArrayList();
            for (String storageId : storageIdsStr) {
                OrgStorage storage2 = storageMap.get(Integer.parseInt(storageId));
                if (storage2 == null) continue;
                String url = StorageUtil.constructUrl((String)storage2.getFid(), (String)storage2.getSn(), (Integer)storage2.getMimeType());
                urls.add(url);
            }
            dto.setUrls(StringUtils.join((Object[])urls.toArray(new String[urls.size()]), (String)","));
        }
        if (po.getDownStatus().intValue() == DownLoadStatus.UNFINISH.getCode()) {
            Long storageId = null;
            if (po.getIsMobile().intValue() == MobileStatus.IS_CALL.getCode()) {
                storageId = callMap.get(po.getSoundId());
            } else if (po.getIsMobile().intValue() == MobileStatus.IS_400_CALL.getCode()) {
                storageId = call400Map.get(po.getSoundId());
            }
            if (storageId != null && storageId > 0L) {
                po.setSoundId(storageId);
                po.setDownStatus(Integer.valueOf(DownLoadStatus.FINISH.getCode()));
                this.txStudentCommentDao.update((Object)po, new String[]{"downStatus", "soundId"});
            }
        }
        if (po.getSoundId() > 0L && po.getDownStatus().intValue() == DownLoadStatus.FINISH.getCode() && (storage = storageMap.get(po.getSoundId().intValue())) != null) {
            dto.setSeconds(po.getSeconds());
            dto.setSoundId(po.getSoundId());
            dto.setSoundUrl(StorageUtil.constructUrl((String)storage.getFid(), (String)storage.getSn(), (Integer)storage.getMimeType()));
        }
        dto.setDownLoadStatus(po.getDownStatus());
        dto.setCommentType(po.getCommentType());
        dto.setGrowthComments(po.getGrowthComments());
        dto.setNotifyParents(po.getNotifyParents());
        dto.setCreatorCascadeId(po.getCreatorCascadeId());
        CreatorDto creatorDto = new CreatorDto();
        creatorDto.setCascadeId(po.getCreatorCascadeId());
        if (po.getCreatorCascadeId().intValue() != Flag.NULL.getInt()) {
            creatorDto.setName(cascadeIdVSNameMap.get(Long.parseLong(po.getCreatorCascadeId() + "")));
        } else if (po.getIsSystem().intValue() == Flag.TRUE.getInt()) {
            creatorDto.setName("\u7cfb\u7edf");
        } else {
            creatorDto.setName("\u5386\u53f2\u7528\u6237");
        }
        dto.setCreator(creatorDto);
    }

    private void tagPo2Dto(TagInfoDto dto, TxStudentTag po) {
        dto.setTagId(po.getId());
        dto.setContent(po.getContent());
    }

    @Override
    @Transactional(readOnly=true)
    public StudentInfoListReponseDto getStudentList(StudentListRequestDto studentListRequestDto, Long orgId, PageDto pageDto) {
        Preconditions.checkArgument((orgId != null ? 1 : 0) != 0, (Object)"orgId can not be null");
        OrgAccount account = (OrgAccount)this.orgAccountDao.getById((Serializable)orgId, new String[0]);
        if (account == null) {
            throw new BussinessException((UniverseErrorCode)StudentErrorCode.ORG_NOT_EXIST);
        }
        StudentInfoListReponseDto responseDto = new StudentInfoListReponseDto();
        ArrayList dtos = Lists.newArrayList();
        List list = Lists.newArrayList();
        responseDto.setList(dtos);
        if (studentListRequestDto.getCourseNumber() != null && studentListRequestDto.getCourseType() != null) {
            if (studentListRequestDto.getCourseType().intValue() == CourseType.CLASS.getCode() || studentListRequestDto.getCourseType().intValue() == CourseType.TRIAL_COURSE.getCode()) {
                ArrayList purchases = Lists.newArrayList();
                HashSet userIds = Sets.newHashSet();
                for (CoursePurchase coursePurchase : purchases) {
                    userIds.add(coursePurchase.getUserId());
                }
                list = this.orgStudentsDao.getStudents(orgId, (Collection)userIds, Integer.valueOf(DeleteStatus.NORMAL.getValue()), pageDto, new String[]{"id", "name", "mobile", "weixin", "createTime"});
            } else {
                OrgCourse course = this.orgCourseDao.getCourseByCourseNumberAndOrgNumber(Long.valueOf(account.getId().longValue()), studentListRequestDto.getCourseNumber(), new String[]{"id"});
                if (course != null) {
                    List studentIds = this.orgStudentCourseDao.getStudents(orgId, course.getId());
                    list = this.orgStudentsDao.getByIdsAndOrderByParam((Collection)studentIds, "createTime", new String[]{"id", "name", "mobile", "weixin", "createTime"});
                }
            }
        } else {
            if (pageDto == null) {
                throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR);
            }
            list = this.orgStudentsDao.getStudents(orgId, studentListRequestDto.getSearchKey(), Integer.valueOf(DeleteStatus.NORMAL.getValue()), pageDto, new String[]{"id", "name", "mobile", "weixin", "createTime"});
        }
        for (OrgStudent student : list) {
            StudentInfoReponseDto dto = new StudentInfoReponseDto();
            this.buidStudentInfoReponseDto(dto, student);
            dtos.add(dto);
        }
        return responseDto;
    }

    @Override
    @Transactional(readOnly=true)
    public StudentInfoListReponseDto getStudentList(StudentListRequestDto studentListRequestDto, List<Long> studentids, Long orgId, PageDto pageDto) {
        Preconditions.checkArgument((orgId != null ? 1 : 0) != 0, (Object)"orgId can not be null");
        OrgAccount account = (OrgAccount)this.orgAccountDao.getById((Serializable)orgId, new String[0]);
        if (account == null) {
            throw new BussinessException((UniverseErrorCode)StudentErrorCode.ORG_NOT_EXIST);
        }
        StudentInfoListReponseDto responseDto = new StudentInfoListReponseDto();
        ArrayList dtos = Lists.newArrayList();
        List list = Lists.newArrayList();
        responseDto.setList(dtos);
        if (pageDto == null) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR);
        }
        list = this.orgStudentsDao.getStudents(orgId, studentids, studentListRequestDto.getSearchKey(), Integer.valueOf(DeleteStatus.NORMAL.getValue()), pageDto, new String[]{"id", "name", "mobile", "weixin", "createTime"});
        for (OrgStudent student : list) {
            StudentInfoReponseDto dto = new StudentInfoReponseDto();
            this.buidStudentInfoReponseDto(dto, student);
            dtos.add(dto);
        }
        return responseDto;
    }

    @Override
    @Transactional(readOnly=true)
    public List<StudentDto> searchStudentClassInfo(Set<Long> studnetIds, Long orgId) {
        if (GenericsUtils.isNullOrEmpty(studnetIds)) {
            return GenericsUtils.emptyList();
        }
        List dtos = this.orgStudentsDao.getByIds(studnetIds, new String[]{"id", "userId"});
        log.info("find all Student is : {} ", (Object)dtos);
        ArrayList retDtos = Lists.newArrayListWithCapacity((int)dtos.size());
        for (OrgStudent student : dtos) {
            StudentDto dto = new StudentDto();
            dto.setUserId(student.getUserId());
            dto.setStudentId(student.getId());
            retDtos.add(dto);
        }
        this.setStudentClassInfos(retDtos, orgId, null);
        log.info("after ret:{}", (Object)retDtos);
        return retDtos;
    }

    @Override
    @Transactional(readOnly=true)
    public List<StudentDto> searchStudentList(StudentListRequestDto studentListRequestDto, Long orgId, PageDto pageDto) {
        Preconditions.checkArgument((orgId != null ? 1 : 0) != 0, (Object)"orgId can not be null");
        OrgAccount account = (OrgAccount)this.orgAccountDao.getById((Serializable)orgId, new String[0]);
        if (account == null) {
            throw new BussinessException((UniverseErrorCode)StudentErrorCode.ORG_NOT_EXIST);
        }
        boolean needFilterWithSolr = studentListRequestDto.needFilter();
        StudentQueryParam param = this.buildByStudentListRequestDto(studentListRequestDto);
        param.setOrgId(orgId);
        if (studentListRequestDto.getCourseNumber() != null && studentListRequestDto.getCourseNumber() > 0L) {
            OrgCourse course = this.orgCourseDao.getOrgCourse(account.getNumber(), studentListRequestDto.getCourseNumber());
            if (course == null) {
                return Collections.emptyList();
            }
            List userIds = this.orgStudentCourseDao.getStudents(orgId, course.getId());
            if (userIds == null || userIds.size() < 1) {
                return Collections.emptyList();
            }
            param.setStudentIds(new HashSet(userIds));
        }
        log.info("[studnetQueryParam] is : {} ", (Object)param);
        AccountRoleType roleType = this.txAccountHelpService.findAccountRoleType(orgId, studentListRequestDto.getCascadeId());
        final boolean isShow = this.txCascadeCredentialService.isShowMobile(orgId, studentListRequestDto.getCascadeId());
        log.info("show mark mobile : {}  for orgId :{} and cascadeId :{}", new Object[]{isShow, orgId, studentListRequestDto.getCascadeId()});
        ArrayList studentDtos = null;
        if (roleType.needDataAuthority()) {
            log.info("\u5f53\u524d\u89d2\u8272 orgId : {} , cascadeId : {}\u6ca1\u6709\u83b7\u53d6\u5b66\u5458\u5217\u8868\u7684\u6743\u9650\uff0c\u8fdb\u884c\u6570\u636e\u63a7\u5236", (Object)orgId, (Object)roleType.getCascadeId());
            param.setNeedQueryByAuthority(true);
            List ownCourseIds = this.orgCourseDao.getCourseIdsByCascadeId(studentListRequestDto.getCascadeId(), null, null, null);
            Set ids = this.solrStudentQuery.queryCourseStudentUserIds((Collection)ownCourseIds, param.getOrgId());
            List addedUserIds = this.orgStudentsDao.getStudentIdsByAdder(studentListRequestDto.getCascadeId().intValue(), param.getOrgId().longValue());
            ids.addAll(addedUserIds);
            if (ids.isEmpty()) {
                log.info("[OrgStudentList] no users!,orgId={},cascadeId={}", (Object)param.getOrgId(), (Object)studentListRequestDto.getCascadeId());
                return Collections.emptyList();
            }
            param.setStudentIds(ids);
        }
        studentDtos = Lists.newArrayList();
        try {
            if (needFilterWithSolr) {
                log.info("need query with solr ");
                if (pageDto.getPageSize() > 1000) {
                    int requestPageSize = pageDto.getPageSize();
                    int totalPageNum = requestPageSize / 1000;
                    int pageNumCount = requestPageSize % 1000 == 0 ? totalPageNum : totalPageNum + 1;
                    for (int i = 1; i <= pageNumCount; ++i) {
                        pageDto.setPageNum(Integer.valueOf(i));
                        pageDto.setPageSize(Integer.valueOf(1000));
                        studentDtos.addAll(this.solrStudentQuery.queryStudent(param, pageDto));
                    }
                } else {
                    studentDtos.addAll(this.solrStudentQuery.queryStudent(param, pageDto));
                }
                if (param.isNeedClassInfo()) {
                    this.setStudentClassInfos(studentDtos, orgId, null);
                }
            } else {
                log.info(" query with db ");
                studentDtos.addAll(this.searchStudentListFromDB(orgId, pageDto, param, roleType, param.isNeedClassInfo()));
            }
        }
        catch (Exception e) {
            log.error("[searchStudentList ] list:{}", (Throwable)e);
            studentDtos.addAll(this.searchStudentListFromDB(orgId, pageDto, param, roleType, param.isNeedClassInfo()));
        }
        log.info("searchStudentList params={},page={},result={}", new Object[]{param, pageDto, studentDtos.size()});
        final HashSet courseIds = new HashSet();
        Map userIdMap = com.baijia.commons.lang.utils.collection.CollectionUtils.extractMap((Collection)studentDtos, (CollectionUtils.Extracter)new CollectionUtils.Extracter<Long, StudentDto>(){

            public Long extract(StudentDto studentDto) {
                String pinyin = studentDto.getPinyin();
                if (StringUtils.isBlank((CharSequence)pinyin)) {
                    pinyin = StringUtils.isNotBlank((CharSequence)studentDto.getName()) ? HanZiPinYinUtils.getLowerCasePinYin((String)studentDto.getName()) : HanZiPinYinUtils.getLowerCasePinYin((String)studentDto.getMobile());
                }
                String str = "#";
                if (StringUtils.isNotBlank((CharSequence)pinyin)) {
                    char init = pinyin.charAt(0);
                    str = String.valueOf(init);
                }
                if (str.equals("~")) {
                    str = "#";
                }
                studentDto.setInitial(str.toUpperCase());
                if (!isShow) {
                    studentDto.setMobile(MaskUtil.maskMobile((String)studentDto.getMobile()));
                }
                courseIds.add(studentDto.getCourseId());
                return studentDto.getUserId();
            }
        });
        Map studentAvatarUrlMap = Maps.newHashMap();
        if (studentListRequestDto.isNeedAvatar()) {
            studentAvatarUrlMap = this.consultAvatarUrlService.batchStudentAvatarUrlAndNameDMap(userIdMap.keySet(), orgId);
        }
        log.info("studentAvatarUrlMap param:{}", (Object)studentAvatarUrlMap);
        for (Long userId : userIdMap.keySet()) {
            ConsultAvatarUrlAndNameDto dto;
            StudentDto student = (StudentDto)userIdMap.get(userId);
            if (student == null || (dto = (ConsultAvatarUrlAndNameDto)studentAvatarUrlMap.get(userId)) == null) continue;
            student.setAvatarUrl(dto.getAvatarUrl());
        }
        return studentDtos;
    }

    private List<StudentDto> searchStudentListFromDB(Long orgId, PageDto pageDto, StudentQueryParam param, AccountRoleType roleType, boolean needClassInfo) {
        log.info("[searchStudentListFromDB] params is : {} ", (Object)param);
        ArrayList<StudentDto> studentDtos = null;
        ArrayList lessonStatus = Lists.newArrayList();
        if (param.getStatus() != null && param.getStatus() != StudentLessonStatus.ALL) {
            if (StudentLessonStatus.STUDYING == param.getStatus()) {
                lessonStatus.add(StudentLessonStatus.STUDYING.getStatus());
                lessonStatus.add(StudentLessonStatus.TO_CHARGE.getStatus());
            } else if (StudentLessonStatus.ALL != param.getStatus()) {
                lessonStatus.add(param.getStatus().getStatus());
            }
        }
        List students = this.orgStudentsDao.getStudentList(orgId.intValue(), (List)lessonStatus, (Collection)param.getStudentIds(), param.getOrderType() == 0, pageDto);
        log.info("find all studnets are : {} ", (Object)students.size());
        if (students != null) {
            studentDtos = new ArrayList<StudentDto>(students.size());
            for (OrgStudent stu : students) {
                studentDtos.add(this.buildStudentDto(stu));
            }
        }
        if (needClassInfo) {
            log.info(" needSetClassInfo with db : {}", (Object)orgId);
            this.setClassInfofromDB(studentDtos, orgId);
            this.setStudentClassName(studentDtos);
        }
        return studentDtos;
    }

    public void setClassInfofromDB(List<StudentDto> studentDtos, Long orgId) {
        long begin = System.currentTimeMillis();
        HashMap<String, StudentClassHour> map = new HashMap<String, StudentClassHour>();
        try {
            if (studentDtos == null || studentDtos.size() < 1) {
                return;
            }
            Map studentIdMap = com.baijia.commons.lang.utils.collection.CollectionUtils.extractMap(studentDtos, (CollectionUtils.Extracter)new CollectionUtils.Extracter<Long, StudentDto>(){

                public Long extract(StudentDto studentDto) {
                    return studentDto.getUserId();
                }
            });
            List<StudentClasHourDocument> list = this.searchStudentClasHourDocuments(studentIdMap.keySet(), orgId);
            log.info("query all StudnetClassHourDocument's size are : {} ", (Object)list.size());
            List<StudentClassHourStatusDocument> StudentClassHourStatusDocumentLists = this.searchStudentClassHourStatusDocuments(studentIdMap.keySet(), orgId);
            log.info("searchStudentClassHourStatusDocuments's size are : {} ", (Object)list.size());
            Map<String, StudentClass> statusMap = this.createStatusMap(StudentClassHourStatusDocumentLists);
            HashMap<Long, ArrayList<StudentClassHour>> sscCache = new HashMap<Long, ArrayList<StudentClassHour>>();
            for (StudentClasHourDocument document : list) {
                StudentClassHour classHour = this.buildStudentClassHour(document);
                Long userId = classHour.getUserId();
                Long courseId = classHour.getCourseId();
                String key = userId + "_" + courseId;
                log.info("before :{} ", (Object)classHour);
                StudentClass studentClass = statusMap.get(key);
                if (studentClass != null) {
                    if (studentClass.getStatus() != 0) {
                        classHour.setTotalCount(classHour.getFinishCount());
                    } else {
                        classHour.setTotalCount(Math.max(studentClass.getContractCount(), classHour.getTotalCount()));
                    }
                }
                log.info("after :{} ", (Object)classHour);
                if (map.get(key) == null) {
                    map.put(key, classHour);
                } else {
                    classHour = (StudentClassHour)map.get(key);
                }
                ArrayList<StudentClassHour> courseList = (ArrayList<StudentClassHour>)sscCache.get(userId);
                if (courseList == null) {
                    courseList = new ArrayList<StudentClassHour>();
                    sscCache.put(userId, courseList);
                }
                courseList.add(classHour);
            }
            HashMap<Long, StudentClassHour> retMap = new HashMap<Long, StudentClassHour>();
            for (String stuCourseId : map.keySet()) {
                StudentClassHour tempClassHour = (StudentClassHour)map.get(stuCourseId);
                StudentClassHour retClassHour = (StudentClassHour)retMap.get(tempClassHour.getUserId());
                if (retClassHour == null) {
                    retMap.put(tempClassHour.getUserId(), tempClassHour);
                    continue;
                }
                if (tempClassHour.getLeftCount() > 0) {
                    if (retClassHour.getLeftCount() <= 0) {
                        retMap.put(tempClassHour.getUserId(), tempClassHour);
                        continue;
                    }
                    if (retClassHour.getLeftCount() > tempClassHour.getLeftCount()) {
                        retMap.put(tempClassHour.getUserId(), tempClassHour);
                        continue;
                    }
                    if (retClassHour.getLeftCount() != tempClassHour.getLeftCount() || retClassHour.getCourseId() >= tempClassHour.getCourseId()) continue;
                    retMap.put(tempClassHour.getUserId(), tempClassHour);
                    continue;
                }
                if (retClassHour.getLeftCount() > 0 || retClassHour.getCourseId() >= tempClassHour.getCourseId()) continue;
                retMap.put(tempClassHour.getUserId(), tempClassHour);
            }
            for (StudentDto dto : studentDtos) {
                StudentClassHour studentClassHour = (StudentClassHour)retMap.get(dto.getUserId());
                if (studentClassHour == null) continue;
                dto.setLeftClassHour(studentClassHour.getLeftCount());
                dto.setFinishClassHour(studentClassHour.getFinishCount());
                dto.setCourseId(Long.valueOf(studentClassHour.getCourseId()));
                dto.setHasLesson(true);
            }
        }
        catch (Exception e) {
            log.error("[Solr replace with DB] IOException ", (Throwable)e);
        }
        log.info("[Solr replace with DB] Query course info cost={},orgId={}", (Object)(System.currentTimeMillis() - begin), (Object)orgId);
    }

    private List<StudentClassHourStatusDocument> searchStudentClassHourStatusDocuments(Set<Long> studentIds, Long orgId) {
        if (GenericsUtils.isNullOrEmpty(studentIds)) {
            return GenericsUtils.emptyList();
        }
        return this.orgStudentCourseDao.searchStudentClassHourStatus(studentIds, orgId);
    }

    private List<StudentClasHourDocument> searchStudentClasHourDocuments(Set<Long> studentIds, Long orgId) {
        if (GenericsUtils.isNullOrEmpty(studentIds)) {
            return GenericsUtils.emptyList();
        }
        List ret = this.orgStudentLessonDao.queryStudentClassHours(studentIds, orgId);
        return ret;
    }

    private Map<String, StudentClass> createStatusMap(List<StudentClassHourStatusDocument> studentClassHourStatusDocumentLists) {
        HashMap statusMap = Maps.newHashMap();
        for (StudentClassHourStatusDocument next : studentClassHourStatusDocumentLists) {
            Long userId = next.getUserId();
            Long courseId = next.getCourseId();
            Integer lessonCount = next.getLessonCount();
            StudentClass studentClass = new StudentClass();
            String key = userId + "_" + courseId;
            Integer status = next.getStatus();
            studentClass.setStatus(status.intValue());
            studentClass.setContractCount(lessonCount == null ? 0 : lessonCount);
            studentClass.setUserId(userId.longValue());
            studentClass.setCourseId(courseId.longValue());
            statusMap.put(key, studentClass);
        }
        log.info("statusMap is :{}", (Object)statusMap);
        return statusMap;
    }

    private StudentClassHour buildStudentClassHour(StudentClasHourDocument document) {
        Long studentId = document.getUserId();
        Long courseId = document.getCourseId();
        Long totalCount = document.getTotal();
        Long finishCount = document.getFinished();
        totalCount = totalCount == null ? 0L : totalCount;
        finishCount = finishCount == null ? 0L : finishCount;
        StudentClassHour classHour = new StudentClassHour();
        classHour.setUserId(studentId.longValue());
        classHour.setCourseId(courseId.longValue());
        classHour.setFinishCount(finishCount.intValue());
        classHour.setTotalCount(totalCount.intValue());
        return classHour;
    }

    private void setStudentClassInfos(List<StudentDto> studentDtos, Long orgId, Object object) {
        try {
            this.solrStudentQuery.setClassInfo(studentDtos, orgId, null);
        }
        catch (Exception e) {
            log.error("error is : {} ", (Throwable)e);
        }
        log.info("after solrSetClassInfo : {} ", studentDtos);
        this.setStudentClassName(studentDtos);
    }

    private void setStudentClassName(List<StudentDto> studentDtos) {
        HashSet courseIds = new HashSet(com.baijia.commons.lang.utils.collection.CollectionUtils.extractList(studentDtos, (CollectionUtils.Extracter)new CollectionUtils.Extracter<Long, StudentDto>(){

            public Long extract(StudentDto arg0) {
                return arg0.getCourseId();
            }
        }));
        List courses = this.orgCourseDao.getByIds(courseIds, new String[]{"id", "name"});
        Map courseMap = com.baijia.commons.lang.utils.collection.CollectionUtils.extractMap((Collection)courses, (CollectionUtils.Extracter)new CollectionUtils.Extracter<Long, OrgCourse>(){

            public Long extract(OrgCourse orgCourse) {
                return orgCourse.getId();
            }
        });
        for (StudentDto dto : studentDtos) {
            OrgCourse course = (OrgCourse)courseMap.get(dto.getCourseId());
            if (course == null) continue;
            dto.setClassName(course.getName());
        }
    }

    private StudentDto buildStudentDto(OrgStudent orgStudent) {
        StudentDto stu = new StudentDto();
        stu.setName(orgStudent.getName());
        stu.setMobile(orgStudent.getMobile());
        stu.setWeixin(orgStudent.getWeixin());
        stu.setStudentId(orgStudent.getId());
        stu.setUserId(orgStudent.getUserId());
        stu.setPinyin(orgStudent.getPinyin());
        return stu;
    }

    private StudentQueryParam buildByStudentListRequestDto(StudentListRequestDto dto) {
        StudentQueryParam param = new StudentQueryParam();
        param.setLessonStatus(dto.getIsSchedule());
        param.setLeftMinClassHour(dto.getLeftMinClassHour());
        param.setLeftMaxClassHour(dto.getLeftMaxClassHour());
        param.setEnrollTime(TimeType.getTimeTypeByCode((Integer)dto.getEnrollDate()));
        param.setFollowTime(TimeType.getTimeTypeByCode((Integer)dto.getFollowDate()));
        param.setCreateTime(TimeType.getTimeTypeByCode((Integer)dto.getCreateDate()));
        param.setStatus(StudentLessonStatus.getStatus((Integer)dto.getStudentStatus()));
        param.setOpType(OpType.getOpType((Integer)dto.getOpType()));
        param.setSearchKey(dto.getSearchKey());
        param.setGender(dto.getSex());
        param.setQueryStr(dto.getQueryStr());
        param.setQueryValue(dto.getQueryValue());
        param.setCascadeId(dto.getCascadeId());
        param.setOrderName(dto.getOrderName());
        param.setOrderType(dto.getOrderType().intValue());
        param.setNeedClassInfo(dto.isNeedClassInfo());
        return param;
    }

    private void buidStudentInfoReponseDto(StudentInfoReponseDto dto, OrgStudent student) {
        OrgStorage storage;
        dto.setName(student.getName());
        dto.setStudentId(student.getId());
        if (StringUtils.isBlank((CharSequence)student.getShowMobile())) {
            dto.setMobile(MaskUtil.maskMobile((String)student.getMobile()));
        } else {
            dto.setMobile(student.getShowMobile());
        }
        dto.setWeixin(student.getWeixin());
        if (StringUtils.isBlank((CharSequence)student.getName())) {
            if (StringUtils.isNotEmpty((CharSequence)student.getNickName())) {
                dto.setName(student.getNickName());
            } else {
                dto.setName(dto.getMobile());
            }
        }
        if (student.getAvatar() != null && (storage = (OrgStorage)this.orgStorageDao.getById((Serializable)student.getAvatar(), new String[0])) != null) {
            String url = StorageUtil.constructUrl((String)storage.getFid(), (String)storage.getSn(), (Integer)storage.getMimeType());
            dto.setAvatarUrl(url);
        }
        if (StringUtils.isNotBlank((CharSequence)student.getPinyin())) {
            char init = student.getPinyin().charAt(0);
            String str = String.valueOf(init);
            dto.setInitial(str.toLowerCase());
        }
    }

    @Override
    @Transactional(readOnly=true)
    public MobileCheckReponseDto checkmobile(Long orgId, List<MobileCheckInfoRequestDto> mobiles) {
        MobileCheckReponseDto reponse = new MobileCheckReponseDto();
        ArrayList failds = Lists.newArrayList();
        reponse.setFailds(failds);
        if (CollectionUtils.isNotEmpty(mobiles)) {
            HashSet mobileSet = Sets.newHashSet();
            for (MobileCheckInfoRequestDto dto : mobiles) {
                mobileSet.add(dto.getMobile());
            }
            List students = this.orgStudentsDao.getStudents(orgId, (Collection)mobileSet, Integer.valueOf(DeleteStatus.NORMAL.getValue()), new String[]{"mobile"});
            HashSet existMobile = Sets.newHashSet();
            for (OrgStudent student : students) {
                existMobile.add(student.getMobile());
            }
            for (MobileCheckInfoRequestDto dto : mobiles) {
                if (!existMobile.contains(dto.getMobile())) continue;
                failds.add(dto.getId());
            }
        }
        return reponse;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public List<BatchAddStudentResponseDto> batchAddStudent(List<? extends StudentInfoDto> studentInfoDtos, Long orgId) {
        for (StudentInfoDto studentInfoDto : studentInfoDtos) {
            if (ParamValidateUtils.validateMobile((String)studentInfoDto.getMobile())) continue;
            throw new BussinessException((UniverseErrorCode)StudentErrorCode.MOBILE_WRONG);
        }
        ArrayList addStudentResponseDtos = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(studentInfoDtos)) {
            Map map = CollectorUtil.collectMap(new ArrayList<StudentInfoDto>(studentInfoDtos), (Function)new Function<StudentInfoDto, String>(){

                public String apply(StudentInfoDto input) {
                    return input.getMobile();
                }
            });
            List students = this.orgStudentsDao.getStudents(orgId, map.keySet(), Integer.valueOf(DeleteStatus.NORMAL.getValue()), new String[]{"mobile"});
            HashSet mobiles = Sets.newHashSet();
            for (OrgStudent orgStudent : students) {
                mobiles.add(orgStudent.getMobile());
            }
            for (StudentInfoDto studentInfoDto : studentInfoDtos) {
                OrgStudentAddresponseDto result;
                if (mobiles.contains(studentInfoDto.getMobile()) || (result = this.addStudent(studentInfoDto, null, null, orgId)) == null) continue;
                BatchAddStudentResponseDto responseDto = new BatchAddStudentResponseDto();
                responseDto.setMobile(studentInfoDto.getMobile());
                responseDto.setStudentId(result.getStudentId());
                addStudentResponseDtos.add(responseDto);
            }
        }
        return addStudentResponseDtos;
    }

    @Override
    @Transactional(readOnly=true)
    public Map<Long, Long> getStudentIdUserIdMap(Collection<Long> studentIds) {
        return this.orgStudentsDao.getStudentIdUserIdMap(studentIds);
    }

    @Override
    public Map<Long, String> getStudentNameMap(Collection<Long> studentIds) {
        return this.orgStudentsDao.getStudentNameMap(studentIds);
    }

    @Override
    public Map<Long, Long> getUserIdStudentIdMap(Collection<Long> userIds, Long orgId) {
        return this.orgStudentsDao.getUserIdStudentIdMap(userIds, orgId);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public StudentInfoDto getAndUpdateOrgStudentByMobile(Long orgId, String mobile, String name, String weinOpenId) throws BussinessException {
        List students = this.orgStudentsDao.getStudentByMobileAndOrgId(orgId, mobile, Integer.valueOf(0), new String[0]);
        StudentInfoDto result = null;
        if (students != null && !students.isEmpty()) {
            result = this.getResult((OrgStudent)students.get(0));
            for (OrgStudent student : students) {
                String weixin = student.getWeixin();
                if (weinOpenId.equals(weixin)) continue;
                student.setWeixin(weinOpenId);
                student.setUpdateTime(new Date());
                this.orgStudentsDao.update((Object)student, new String[]{"name", "weixin", "updateTime"});
            }
        } else {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.NOT_FOUND, "\u7ed1\u5b9a\u5931\u8d25\uff0c\u60a8\u6240\u586b\u5199\u7684\u624b\u673a\u53f7\u4e0d\u662f\u5b66\u5458\u624b\u673a\u53f7");
        }
        return result;
    }

    private StudentInfoDto getResult(OrgStudent student) {
        StudentInfoDto result = new StudentInfoDto();
        BeanUtils.copyProperties((Object)student, (Object)((Object)result));
        result.setStudentId(student.getId());
        return result;
    }

    @Override
    @Transactional(readOnly=true)
    public StudentInfoDto getOrgStudentByMobile(Long orgId, String mobile) {
        OrgStudent student = this.orgStudentsDao.getStudentByMobileAndOrgId(orgId, mobile, new String[0]);
        StudentInfoDto result = null;
        if (student != null) {
            result = new StudentInfoDto();
            BeanUtils.copyProperties((Object)student, (Object)((Object)result));
        }
        return result;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public List<StudentInfoDto> getAndUpdateOrgStudentByOpenId(Long orgId, String weixinOpenId) {
        List students = this.orgStudentsDao.getStudentByOpenIdAndOrgId(orgId, weixinOpenId, new String[0]);
        ArrayList result = Lists.newArrayList();
        if (students != null && !students.isEmpty()) {
            StudentInfoDto item = null;
            for (OrgStudent student : students) {
                item = new StudentInfoDto();
                BeanUtils.copyProperties((Object)student, (Object)((Object)item));
                item.setStudentId(student.getId());
                item.setClassName(this.getClassName(orgId, student.getUserId()));
                result.add(item);
                if (weixinOpenId.equals(student.getWeixin())) continue;
                student.setWeixin(weixinOpenId);
                student.setUpdateTime(new Date());
                this.orgStudentsDao.update((Object)student, new String[]{"weixin", "updateTime"});
            }
        }
        return result;
    }

    private String getClassName(Long orgId, Long studentId) {
        List courses = this.orgStudentCourseDao.getOrgCourseIds(orgId, studentId, Integer.valueOf(0), null);
        String name = "";
        if (courses != null && !courses.isEmpty()) {
            ArrayList courseIds = Lists.newArrayList();
            for (OrgStudentCourse course : courses) {
                courseIds.add(course.getCourseId());
            }
            List courseList = this.orgCourseDao.getByIds((Collection)courseIds, new String[]{"id", "name"});
            if (CollectionUtils.isNotEmpty((Collection)courseList)) {
                ArrayList courseNameList = Lists.newArrayList();
                for (OrgCourse orgCourse : courseList) {
                    courseNameList.add(orgCourse.getName());
                }
                if (courseNameList.size() > 0) {
                    name = StringUtils.join((Iterable)courseNameList, (String)",");
                }
            }
        }
        return StringUtils.isNotBlank((CharSequence)name) ? name : "\u672a\u62a5\u73ed";
    }

    @Override
    @Transactional(readOnly=true)
    public StudentInfoDto getBasicStudentInfo(Long studentId, Long orgId, boolean hideMobile) {
        Preconditions.checkArgument((studentId != null ? 1 : 0) != 0, (Object)"studentId is null");
        OrgStudent orgStudent = (OrgStudent)this.orgStudentsDao.getById((Serializable)studentId, new String[0]);
        if (orgStudent == null || orgStudent.getOrgId().longValue() != orgId.longValue()) {
            throw new BussinessException((UniverseErrorCode)StudentErrorCode.STUDENT_NOT_EXIST);
        }
        StudentInfoDto dto = new StudentInfoDto();
        dto.setAvatarUrl(this.getAvtarUrl(orgStudent));
        dto.setStudentId(studentId);
        if (StringUtils.isBlank((CharSequence)orgStudent.getName())) {
            if (StringUtils.isBlank((CharSequence)orgStudent.getNickName())) {
                dto.setName(MaskUtil.maskMobile((String)orgStudent.getMobile()));
            } else {
                dto.setName(orgStudent.getNickName());
            }
        } else {
            dto.setName(orgStudent.getName());
        }
        if (hideMobile) {
            if (StringUtils.isNotBlank((CharSequence)orgStudent.getShowMobile())) {
                if (orgStudent.getShowMobile().contains("*")) {
                    dto.setMobile(orgStudent.getShowMobile());
                } else {
                    dto.setMobile(MaskUtil.maskMobile((String)orgStudent.getMobile()));
                }
            } else {
                dto.setMobile(MaskUtil.maskMobile((String)orgStudent.getMobile()));
            }
        } else if (StringUtils.isNotBlank((CharSequence)orgStudent.getShowMobile())) {
            if (orgStudent.getShowMobile().contains("*")) {
                dto.setMobile(orgStudent.getMobile());
            } else {
                dto.setMobile(orgStudent.getShowMobile());
            }
        } else {
            dto.setMobile(orgStudent.getMobile());
        }
        if (!this.txCascadeCredentialService.isShowMobile(orgId, TianxiaoMContext.getTXCascadeId())) {
            dto.setMobile(MaskUtil.maskMobile((String)dto.getMobile()));
            dto.setParentMobile(MaskUtil.maskMobile((String)dto.getParentMobile()));
        }
        return dto;
    }

    private String getAvtarUrl(OrgStudent orgStudent) {
        Storage storage;
        Integer stuAvatarId;
        Student student;
        Fans fans;
        OrgStorage orgStorage;
        String avatarUrl = null;
        Long avatarId = orgStudent.getAvatar();
        String openId = orgStudent.getWeixin();
        if (avatarId != null && avatarId > 0L && (orgStorage = (OrgStorage)this.orgStorageDao.getById((Serializable)avatarId, new String[0])) != null) {
            avatarUrl = StorageUtil.constructUrl((String)orgStorage.getFid(), (String)orgStorage.getSn(), (Integer)orgStorage.getMimeType());
        }
        if (StringUtils.isBlank(avatarUrl) && StringUtils.isNotBlank((CharSequence)openId) && (fans = this.fansDao.getByOpenId(openId)) != null) {
            avatarUrl = fans.getHeadImgUrl();
        }
        if (StringUtils.isBlank(avatarUrl) && (student = this.studentDao.getByUserId(orgStudent.getUserId(), new String[0])) != null && (stuAvatarId = student.getAvatar()) != null && stuAvatarId > 0 && (storage = this.storageDao.getStorageById(Long.valueOf(stuAvatarId.longValue()))) != null) {
            avatarUrl = StorageUtil.constructUrl((Long)storage.getFid(), (String)storage.getMimetype(), (String)storage.getSn());
        }
        if (StringUtils.isBlank(avatarUrl)) {
            avatarUrl = "http://img.gsxservice.com/21565943_l6z55rbz.png";
        }
        return avatarUrl;
    }

    @Override
    @Transactional(readOnly=true)
    public List<OrgStudent> searchHasMobileConsulter(PageDto pageDto, String format, String value) {
        List students = this.orgStudentsDao.searchHasMobileConsulter(pageDto, format, value);
        log.debug("students:{}", (Object)students);
        return students;
    }

    @Override
    @Transactional(readOnly=true)
    public Map<Long, StudentInfoReponseDto> getUserIdStudentDtoMap(Collection<Long> userIds, Long orgId) {
        Map studentMap = this.orgStudentsDao.getStudentMap(userIds, orgId);
        log.debug("studentMap={}", (Object)studentMap);
        Map storageMap = this.studentDao.getAvatarsMap(studentMap.keySet());
        HashSet aratarIds = Sets.newHashSet();
        for (Integer avatar : storageMap.values()) {
            aratarIds.add(avatar.longValue());
        }
        Map avatarMap = this.storageDao.getStorageMapByIds((Collection)aratarIds);
        HashMap response = Maps.newHashMap();
        for (Long userId : studentMap.keySet()) {
            StudentInfoReponseDto dto = new StudentInfoReponseDto();
            OrgStudent student = (OrgStudent)studentMap.get(userId);
            if (student != null) {
                Storage storage;
                dto.setStudentId(student.getId());
                dto.setMobile(this.getMobile(student, false));
                dto.setName(this.getName(student));
                Integer avatar = (Integer)storageMap.get(userId);
                if (avatar != null && (storage = (Storage)avatarMap.get(avatar.longValue())) != null) {
                    dto.setAvatarUrl(StorageUtil.constructUrl((Long)storage.getFid(), (String)storage.getMimetype(), (String)storage.getSn()));
                }
            }
            response.put(userId, dto);
        }
        return response;
    }

    @Override
    @DataAuthority(resourceTypes={RequestSourceDesc.STUDENT_LIST})
    public List<StudentStatusStatistics> getStudentStatusStatisticsByOrgId(Long orgId) {
        boolean needDataAuthority = false;
        Integer cascadeId = null;
        List studentIds = null;
        boolean canAccess = RequestSourceDesc.STUDENT_LIST.canAccess("getStudentStatusStatisticsByOrgId", this.getClass(), new Class[]{Long.class});
        if (!canAccess) {
            AccountRoleType accountRoleType = RequestSourceDesc.STUDENT_LIST.getAccountRoleType();
            log.info(" can not access in getStudentStatusStatisticsByOrgId and accountRoleType is : {} ", (Object)accountRoleType);
            cascadeId = accountRoleType.getCascadeId();
            List courseIds = this.orgCourseDao.getCourseIdsByCascadeId(cascadeId, null, null, null);
            studentIds = this.orgStudentCourseDao.getStudentIdsByCourseIds(orgId, (Collection)courseIds);
            needDataAuthority = true;
        }
        List statisticses = null;
        try {
            statisticses = this.solrStudentQuery.queryCountByStatus(orgId.longValue(), needDataAuthority, studentIds, cascadeId);
            return statisticses;
        }
        catch (Exception e) {
            log.error("[Solr] query exception.", (Throwable)e);
            statisticses = StudentStatusStatistics.getDefaut();
            Map ret = this.orgStudentsDao.getStatisticsByLessonStatus(orgId.intValue(), needDataAuthority, studentIds, cascadeId);
            for (StudentStatusStatistics stat : statisticses) {
                Integer count = (Integer)ret.get(stat.getStatus());
                if (count != null) {
                    stat.setNumber((long)count.intValue());
                }
                if (stat.getStatus() != StudentLessonStatus.ALL.getStatus()) continue;
                stat.setNumber((long)((Integer)ret.get(StudentLessonStatus.STUDYING.getStatus()) + (Integer)ret.get(StudentLessonStatus.PAST.getStatus())));
            }
            log.info("Success==={}", (Object)statisticses);
            return statisticses;
        }
    }

    private String getName(OrgStudent student) {
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{student.getName()})) {
            return student.getName();
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{student.getNickName()})) {
            return student.getNickName();
        }
        return MaskUtil.maskMobile((String)student.getMobile());
    }

    private String getMobile(OrgStudent student, boolean mask) {
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{student.getShowMobile()}) && student.getShowMobile().contains("*")) {
            return mask ? MaskUtil.maskMobile((String)student.getMobile()) : student.getMobile();
        }
        return mask ? MaskUtil.maskMobile((String)student.getShowMobile()) : student.getShowMobile();
    }

    private void addSysBacklog(Long orgId, OrgStudent student, Long consultUserId) {
        log.info("addSysBacklog---------orgId={}, student={}\uff0cconsultUserId={}", new Object[]{orgId, student, consultUserId});
        List list = this.txBacklogDao.getBacklogByStudentIdAndOrgId(student.getId(), orgId, Boolean.valueOf(false), new String[]{"id"});
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.SYSTEM_ERROR, "\u5df2\u5b58\u5728\u672a\u8fc7\u671f\u7684\u6b63\u5f0f\u5b66\u5458\u7cfb\u7edf\u5f85\u529e\u4e8b\u9879");
        }
        if (student.getNextRemindTime() != null && student.getNextRemindTime().getTime() > 0L) {
            TxBacklog txBacklog = new TxBacklog();
            txBacklog.setOrgId(orgId);
            txBacklog.setStudentId(student.getId());
            if (null != consultUserId && consultUserId > 0L) {
                txBacklog.setConsultUserId(consultUserId);
            }
            txBacklog.setContent("\u8ddf\u8fdb\u5ba2\u6237: " + (StringUtils.isNotBlank((CharSequence)student.getName()) ? student.getName() : "\u533f\u540d\u5b66\u751f"));
            txBacklog.setCreateTime(new Date());
            txBacklog.setUpdateTime(new Date());
            txBacklog.setIsSys(BizConf.TRUE.intValue());
            txBacklog.setCascadeId(student.getAddCascadeId());
            txBacklog.setEndTime(student.getNextRemindTime());
            txBacklog.setRemindTime(student.getNextRemindTime());
            this.txBacklogDao.save((Object)txBacklog, Boolean.valueOf(false), new String[0]);
            log.info("addSysBacklog--------txBacklog={}", (Object)txBacklog);
        }
    }

    @Override
    public void updateSysBacklog(Long orgId, OrgStudent student, Long consulterId) {
        log.info("updateSysBacklog-------orgId={},student={},consulterId={}", new Object[]{orgId, student, consulterId});
        List list = null;
        if (null != consulterId && consulterId > 0L) {
            list = this.txBacklogDao.getBacklogByConsulterIdAndOrgId(consulterId, orgId, Boolean.valueOf(false), new String[0]);
            if (CollectionUtils.isNotEmpty((Collection)list)) {
                TxBacklog txBacklog = (TxBacklog)list.get(0);
                if (student.getNextRemindTime() == null) {
                    this.txBacklogDao.delById((Serializable)txBacklog.getId());
                } else {
                    txBacklog.setStudentId(student.getId());
                    txBacklog.setContent("\u8ddf\u8fdb\u5ba2\u6237: " + (StringUtils.isNotBlank((CharSequence)student.getName()) ? student.getName() : "\u533f\u540d\u5b66\u751f"));
                    txBacklog.setEndTime(student.getNextRemindTime());
                    txBacklog.setRemindTime(student.getNextRemindTime());
                    txBacklog.setUpdateTime(new Date());
                    this.txBacklogDao.update((Object)txBacklog, Boolean.valueOf(false), new String[0]);
                }
            } else if (student.getNextRemindTime() != null) {
                this.addSysBacklog(orgId, student, consulterId);
            }
        } else {
            list = this.txBacklogDao.getBacklogByStudentIdAndOrgId(student.getId(), orgId, Boolean.valueOf(false), new String[0]);
            if (CollectionUtils.isNotEmpty((Collection)list)) {
                TxBacklog txBacklog = (TxBacklog)list.get(0);
                log.info("[TxBackLogList] txBacklog param:{}, student nextRemindTime param:{}", (Object)txBacklog, (Object)student.getNextRemindTime());
                if (student.getNextRemindTime() == null) {
                    this.txBacklogDao.delById((Serializable)txBacklog.getId());
                } else if (txBacklog.getEndTime().getTime() != student.getNextRemindTime().getTime()) {
                    txBacklog.setContent("\u8ddf\u8fdb\u5ba2\u6237: " + (StringUtils.isNotBlank((CharSequence)student.getName()) ? student.getName() : "\u533f\u540d\u5b66\u751f"));
                    txBacklog.setEndTime(student.getNextRemindTime());
                    txBacklog.setRemindTime(student.getNextRemindTime());
                    txBacklog.setUpdateTime(new Date());
                    this.txBacklogDao.update((Object)txBacklog, Boolean.valueOf(false), new String[0]);
                }
            } else if (student.getNextRemindTime() != null) {
                List consultUserList = this.txConsultUserDao.lookByStudentId(orgId, student.getId(), new String[]{"id"});
                if (CollectionUtils.isNotEmpty((Collection)consultUserList)) {
                    consulterId = ((TxConsultUser)consultUserList.get(0)).getId();
                }
                this.addSysBacklog(orgId, student, consulterId);
            }
        }
    }

    @Override
    public void updateSysBacklogForConsulter(Long orgId, TxConsultUser consultUser) {
        TxBacklog txBacklog = null;
        List backlogByConsulterIdAndOrgId = this.txBacklogDao.getBacklogByConsulterIdAndOrgId(consultUser.getId(), orgId, Boolean.valueOf(false), new String[0]);
        log.info("[TxBackLogList] txBacklog param:{}, consultUser nextRemindTime param:{}", (Object)backlogByConsulterIdAndOrgId, (Object)consultUser.getNextRemindTime());
        if (GenericsUtils.notNullAndEmpty((Object)backlogByConsulterIdAndOrgId)) {
            txBacklog = (TxBacklog)backlogByConsulterIdAndOrgId.get(0);
            if (consultUser.getNextRemindTime() == null) {
                this.txBacklogDao.delById((Serializable)txBacklog.getId());
            } else if (txBacklog.getEndTime().getTime() != consultUser.getNextRemindTime().getTime()) {
                this.addOrUpdateSysBackForConsult(consultUser, txBacklog);
            }
        } else {
            log.info("not have record ");
            if (consultUser.getNextRemindTime() != null) {
                txBacklog = new TxBacklog();
                this.addOrUpdateSysBackForConsult(consultUser, txBacklog);
            }
        }
    }

    public void addOrUpdateSysBackForConsult(TxConsultUser consultUser, TxBacklog txBacklog) {
        txBacklog.setConsultUserId(consultUser.getId());
        txBacklog.setContent("\u8ddf\u8fdb\u7ebf\u7d22: " + (StringUtils.isNotBlank((CharSequence)consultUser.getName()) ? consultUser.getName() : "\u533f\u540d\u7ebf\u7d22"));
        txBacklog.setEndTime(consultUser.getNextRemindTime());
        txBacklog.setIsSys(BizConf.TRUE.intValue());
        txBacklog.setCascadeId(Integer.valueOf(consultUser.getCascadeId() == null ? 0 : consultUser.getCascadeId().intValue()));
        txBacklog.setOrgId(consultUser.getOrgId());
        txBacklog.setEndTime(consultUser.getNextRemindTime());
        if (txBacklog.getId() == null) {
            txBacklog.setCreateTime(new Date());
        }
        txBacklog.setRemindTime(consultUser.getNextRemindTime());
        txBacklog.setUpdateTime(new Date());
        this.txBacklogDao.saveOrUpdate((Object)txBacklog, new String[0]);
        log.info("add backlog : {} ", (Object)txBacklog);
    }

    private void delSysBacklog(Long orgId, OrgStudent student, TxConsultUser consulterUser) {
        block5: {
            List list;
            block4: {
                log.info("delSysBacklog-------orgId={},student={},consulterUser={}", new Object[]{orgId, student, consulterUser});
                list = null;
                if (null == consulterUser) break block4;
                list = this.txBacklogDao.getBacklogByConsulterIdAndOrgId(consulterUser.getId(), orgId, null, new String[0]);
                if (!CollectionUtils.isNotEmpty((Collection)list)) break block5;
                for (TxBacklog txBacklog : list) {
                    if (null == txBacklog || txBacklog.getStudentId().longValue() != student.getId().longValue()) continue;
                    txBacklog.setStudentId(Long.valueOf(0L));
                    if (!txBacklog.getEndTime().before(new Date())) {
                        txBacklog.setContent("\u8ddf\u8fdb\u5ba2\u6237: " + (StringUtils.isNotBlank((CharSequence)consulterUser.getName()) ? consulterUser.getName() : "\u533f\u540d\u5b66\u751f"));
                        txBacklog.setEndTime(consulterUser.getNextRemindTime());
                        txBacklog.setRemindTime(consulterUser.getNextRemindTime());
                    }
                    txBacklog.setUpdateTime(new Date());
                    this.txBacklogDao.update((Object)txBacklog, Boolean.valueOf(false), new String[0]);
                }
                break block5;
            }
            list = this.txBacklogDao.getBacklogByStudentIdAndOrgId(student.getId(), orgId, null, new String[0]);
            if (CollectionUtils.isNotEmpty((Collection)list)) {
                for (TxBacklog txBacklog : list) {
                    if (null == txBacklog) continue;
                    txBacklog.setStudentId(Long.valueOf(0L));
                    txBacklog.setDelStatus(BizConf.TRUE.intValue());
                    txBacklog.setUpdateTime(new Date());
                    this.txBacklogDao.update((Object)txBacklog, Boolean.valueOf(false), new String[0]);
                }
            }
        }
    }

    @Override
    public List<StudentInfoDto> listOrgStudentByMobile(Long orgId, String mobile) {
        List students = this.orgStudentsDao.getStudentByMobileAndOrgId(orgId, mobile, Integer.valueOf(9999), new String[0]);
        ArrayList<StudentInfoDto> result = new ArrayList<StudentInfoDto>();
        if (students != null) {
            for (OrgStudent stu : students) {
                StudentInfoDto dto = new StudentInfoDto();
                BeanUtils.copyProperties((Object)stu, (Object)((Object)dto));
                dto.setStudentId(stu.getUserId());
                dto.setName(stu.getName());
                result.add(dto);
            }
        }
        return result;
    }

    @Override
    public void updateStudentNextRemindTime(Integer orgId, Long studentId, Long nextRemindTime) {
        if (nextRemindTime != null && nextRemindTime > TianXiaoConstant.MAX_TIMESTAMP_CALEN.getTime().getTime()) {
            throw new ParameterException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u4e0b\u6b21\u63d0\u9192\u65f6\u95f4\u8d85\u8fc7\u6700\u5927\u8303\u56f4(2037-1-1)\u4e86");
        }
        OrgStudent student = (OrgStudent)this.orgStudentsDao.getById((Serializable)studentId, new String[0]);
        if (student == null || student.getOrgId().intValue() != orgId.intValue()) {
            throw new PermissionException();
        }
        if (nextRemindTime != null && nextRemindTime > 0L) {
            student.setNextRemindTime(new Date(nextRemindTime));
        } else {
            student.setNextRemindTime(null);
        }
        this.orgStudentsDao.updateWithDefaultVal((Object)student, new String[]{"nextRemindTime"});
        this.updateSysBacklog(orgId.longValue(), student, null);
    }

    @Override
    public List<Long> getStudentidsByCourseIds(Long orgId, List<Long> courseIds) {
        return this.orgStudentCourseDao.getStudentIdsByCourseIds(Long.valueOf(orgId), courseIds);
    }

    @Override
    public List<StudentInfoDto> listOrgStudentByMobiles(Long orgId, List<String> mobile) {
        List students = this.orgStudentsDao.getOrgStudents(orgId, mobile);
        ArrayList<StudentInfoDto> result = new ArrayList<StudentInfoDto>();
        if (students != null) {
            for (OrgStudent stu : students) {
                StudentInfoDto dto = new StudentInfoDto();
                BeanUtils.copyProperties((Object)stu, (Object)((Object)dto));
                dto.setStudentId(stu.getUserId());
                dto.setName(stu.getName());
                result.add(dto);
            }
        }
        return result;
    }

    @Override
    public void updateSolr(Long id) {
        OrgStudent stu = (OrgStudent)this.orgStudentsDao.getById((Serializable)id, new String[0]);
        this.updateSolr(stu);
    }

    void updateSolr(OrgStudent orgStudent) {
        if (orgStudent == null) {
            return;
        }
        try {
            this.crmStudentQuery.updateOldRow(orgStudent.toSolrMap());
            log.info("solr - student - update - end - orgStudent:{}", (Object)orgStudent);
        }
        catch (Exception e) {
            log.error("solr - student - update - exception", (Throwable)e);
        }
    }

    @Override
    public ArrayListMultimap<String, StudentInfoDto> getStudentMap(Long orgId, List<String> mobiles) {
        List students = this.orgStudentsDao.getOrgStudents(orgId, mobiles);
        ArrayListMultimap result = ArrayListMultimap.create();
        if (CollectionUtils.isNotEmpty((Collection)students)) {
            for (OrgStudent stu : students) {
                StudentInfoDto dto = new StudentInfoDto();
                BeanUtils.copyProperties((Object)stu, (Object)((Object)dto));
                dto.setStudentId(stu.getUserId());
                dto.setName(stu.getName());
                result.put((Object)dto.getMobile(), (Object)dto);
            }
        }
        return result;
    }
}

