package com.baijia.tianxiao.sal.student.dto.response.pc;

import com.baijia.tianxiao.dal.org.po.OrgStudent;
import com.baijia.tianxiao.dal.roster.po.TxStudentTag;
import lombok.Data;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;

import java.util.Date;
import java.util.List;

/**
 * Created by hanlaijin on 17/3/6.
 */
@Data
@Slf4j
public class SignupStudentListDto {
    private Long id;
    private String name;
    private String mobile;
    private Long gender;
    private String genderStr;
    private String parentName;
    private String parentMobile;
    private Long birthday;
    private Date birthdayStr;
    private String mail;
    private String qq;
    private String studentRemark;
    private String pinyin;
    private String studentTags;
    private String tagsStr;


    public static SignupStudentListDto convertToDto(OrgStudent student,List<TxStudentTag> tagList){
        SignupStudentListDto dto = new SignupStudentListDto();
        dto.setId(student.getId());
        dto.setName(student.getName());
        dto.setMobile(student.getMobile());

        dto.setParentName(student.getParentName());
        dto.setParentMobile(student.getParentMobile());
        dto.setQq(student.getQq());

        dto.setGender(student.getGender().longValue());
        if (dto.getGender() == null || dto.getGender() == -1) {
            dto.setGenderStr("");
        } else {
            dto.setGenderStr(dto.getGender() == 1 ? "女" : "男");
        }

        StringBuilder tagStr = new StringBuilder("");
        if(tagList!=null) {
            for (int i = 0; i < tagList.size(); i++) {
                TxStudentTag txStudentTag = tagList.get(i);
                if (i < 5) {
                    tagStr.append(txStudentTag.getContent()).append(" ");
                }
            }
        }
        dto.setStudentTags(tagStr.toString());

        if(student.getBirthday() != null) {
            dto.setBirthday(student.getBirthday().getTime());
            dto.setBirthdayStr(student.getBirthday());
        }
        dto.setMail(student.getMail());
        dto.setStudentRemark(student.getRemark());
        String pinyin = student.getPinyin();
        if(StringUtils.isBlank(pinyin) || (pinyin.charAt(0) <= '9' && pinyin.charAt(0) >= '0')){
            dto.setPinyin("#");
        }else {
            dto.setPinyin(student.getPinyin());
        }
        return dto;
    }
}
