
package com.baijia.tianxiao.sal.student.dto.customFields.fieldTypes;

import com.baijia.tianxiao.sal.organization.org.dto.addressbook.TXAddressBookDto;
import com.baijia.tianxiao.sal.student.enums.CustomFieldType;

import org.springframework.stereotype.Component;

import lombok.Data;
import lombok.EqualsAndHashCode;

@Data
@EqualsAndHashCode(callSuper = false)
@Component
public class PositionFieldType extends AbstractCustomFieldType<PositionFieldType> {

    private String address;
    private Double longitude;
    private Double latitude;
    private TXAddressBookDto addressDetail;

    @Override
    public String objToJson(PositionFieldType obj) {
        return super.toJson(obj);
    }

    @Override
    public PositionFieldType jsonToObj(String json) {
        return super.fromJson(json);
    }

    @Override
    public CustomFieldType matchFieldType() {
        return CustomFieldType.POSITION;
    }

    /* (non-Javadoc)
     * @see com.baijia.tianxiao.sal.student.dto.customFields.fieldTypes.CustomFieldTypeInterface#instance()
     */
        
    @Override
    public CustomFieldTypeInterface<PositionFieldType> instance() {
        return new PositionFieldType();
    }

}
