/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.student.impl;

import com.baijia.tianxiao.constant.Flag;
import com.baijia.tianxiao.dal.roster.dao.TxCustomRecordKeyDao;
import com.baijia.tianxiao.dal.roster.dao.TxCustomRecordTemplateDao;
import com.baijia.tianxiao.dal.roster.dao.TxCustomRecordValueDao;
import com.baijia.tianxiao.dal.roster.dao.TxStudentCommentDao;
import com.baijia.tianxiao.dal.roster.po.TxCustomRecordKey;
import com.baijia.tianxiao.dal.roster.po.TxCustomRecordTemplate;
import com.baijia.tianxiao.dal.roster.po.TxCustomRecordValue;
import com.baijia.tianxiao.dal.roster.po.TxStudentComment;
import com.baijia.tianxiao.sal.student.api.TxCustomRecordService;
import com.baijia.tianxiao.sal.student.dto.TxCustomRecordDto;
import com.baijia.tianxiao.util.collection.CollectorUtil;
import com.baijia.tianxiao.util.exception.BussinessPreconditions;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class TxCustomRecordServiceImpl
implements TxCustomRecordService {
    private static final Logger log = LoggerFactory.getLogger(TxCustomRecordServiceImpl.class);
    @Autowired
    private TxCustomRecordTemplateDao txCustomRecordTemplateDao;
    @Autowired
    private TxCustomRecordKeyDao txCustomRecordKeyDao;
    @Autowired
    private TxCustomRecordValueDao txCustomRecordValueDao;
    @Autowired
    private TxStudentCommentDao txStudentCommentDao;

    @Override
    public TxCustomRecordDto getRecord(Long orgId, Long templateId, Long commentId) {
        TxCustomRecordTemplate template = (TxCustomRecordTemplate)this.txCustomRecordTemplateDao.getById((Serializable)templateId, new String[0]);
        List keyList = this.txCustomRecordKeyDao.getKeysByOrgId(orgId, templateId, null);
        Map keyValues = CollectorUtil.collectMap((Collection)this.txCustomRecordValueDao.listByOrgCommentKeyIds(orgId, commentId, (Collection)keyList.stream().map(txCustomRecordKey -> txCustomRecordKey.getId()).collect(Collectors.toList())), input -> input.getKeyId());
        TxCustomRecordDto recordDto = new TxCustomRecordDto();
        recordDto.setTemplateId(template.getId());
        recordDto.setName(template.getName());
        recordDto.setSort(template.getSort());
        recordDto.setType(template.getType());
        ArrayList fields = Lists.newArrayList();
        for (TxCustomRecordKey key : keyList) {
            TxCustomRecordDto.RecordField field = new TxCustomRecordDto.RecordField();
            field.setKeyId(key.getId());
            field.setKeyName(key.getKeyName());
            field.setDisable(key.getDisable());
            field.setSort(key.getSort());
            TxCustomRecordValue value = (TxCustomRecordValue)keyValues.get(key.getId());
            field.setValueId(null == value ? null : value.getId());
            field.setValue(null == value ? null : value.getValue());
            if (field.getDisable().intValue() == Flag.TRUE.getInt() && StringUtils.isBlank((CharSequence)field.getValue())) continue;
            fields.add(field);
        }
        recordDto.setFields(fields);
        recordDto.sort();
        return recordDto;
    }

    @Override
    public TxCustomRecordDto getEmptyRecord(Long orgId, Long templateId) {
        TxCustomRecordTemplate template = (TxCustomRecordTemplate)this.txCustomRecordTemplateDao.getById((Serializable)templateId, new String[0]);
        List keyList = this.txCustomRecordKeyDao.getKeysByOrgId(orgId, templateId, Integer.valueOf(Flag.FALSE.getInt()));
        TxCustomRecordDto recordDto = new TxCustomRecordDto();
        recordDto.setTemplateId(template.getId());
        recordDto.setName(template.getName());
        recordDto.setSort(template.getSort());
        recordDto.setType(template.getType());
        ArrayList fields = Lists.newArrayList();
        for (TxCustomRecordKey key : keyList) {
            TxCustomRecordDto.RecordField field = new TxCustomRecordDto.RecordField();
            field.setKeyId(key.getId());
            field.setKeyName(key.getKeyName());
            field.setDisable(key.getDisable());
            field.setSort(key.getSort());
            field.setValueId(null);
            field.setValue(null);
            fields.add(field);
        }
        recordDto.setFields(fields);
        recordDto.sort();
        return recordDto;
    }

    @Override
    public void saveNewRecord(Long orgId, Long commentId, TxCustomRecordDto txCustomRecordDto) {
        log.debug("txCustomRecordDto:{}", (Object)txCustomRecordDto);
        TxCustomRecordTemplate template = this.txCustomRecordTemplateDao.getByTemplateId(txCustomRecordDto.getTemplateId());
        BussinessPreconditions.checkArgument((null != template && template.getDisable().intValue() == Flag.FALSE.getInt() && template.getOrgId().longValue() == orgId.longValue() ? 1 : 0) != 0, (Object)"\u6a21\u677f\u4fe1\u606f\u5df2\u7ecf\u6539\u53d8\uff0c\u8bf7\u9000\u51fa\u5f53\u524d\u9875\u9762\u91cd\u8bd5");
        TxStudentComment studentComment = (TxStudentComment)this.txStudentCommentDao.getById((Serializable)commentId, new String[0]);
        BussinessPreconditions.checkArgument((null != studentComment && studentComment.getOrgId().longValue() == orgId.longValue() ? 1 : 0) != 0, (Object)"can not find studentComment!");
        if (CollectionUtils.isEmpty(txCustomRecordDto.getFields())) {
            return;
        }
        ArrayList saveList = Lists.newArrayList();
        for (TxCustomRecordDto.RecordField field : txCustomRecordDto.getFields()) {
            TxCustomRecordValue value = new TxCustomRecordValue();
            value.setOrgId(orgId);
            value.setCommentId(commentId);
            value.setKeyId(field.getKeyId());
            value.setValue(field.getValue());
            if (StringUtils.isBlank((CharSequence)value.getValue()) || null == value.getKeyId()) continue;
            saveList.add(value);
        }
        this.txCustomRecordValueDao.saveAll((List)saveList, false, new String[0]);
    }
}

