/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.student.impl;

import com.baijia.tianxiao.constant.LessonStatus;
import com.baijia.tianxiao.dal.constant.ChargeUnit;
import com.baijia.tianxiao.dal.enums.CourseTypeEnum;
import com.baijia.tianxiao.dal.org.dao.OrgClassLessonDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentLessonDao;
import com.baijia.tianxiao.dal.org.dao.OrgSubAccountDao;
import com.baijia.tianxiao.dal.org.dto.StudentClassHourStatusDocument;
import com.baijia.tianxiao.dal.org.po.OrgClassLesson;
import com.baijia.tianxiao.dal.org.po.OrgStudentCourse;
import com.baijia.tianxiao.dal.org.po.OrgStudentLesson;
import com.baijia.tianxiao.dal.org.po.OrgSubAccount;
import com.baijia.tianxiao.dal.org.po.StudentLessonStatistics;
import com.baijia.tianxiao.dal.solr.enums.StudentLessonStatus;
import com.baijia.tianxiao.dal.solr.po.StudentClass;
import com.baijia.tianxiao.enums.StudentCourseStatus;
import com.baijia.tianxiao.redis.AbstractBaseRedisDao;
import com.baijia.tianxiao.sal.student.api.OrgStudentCourseService;
import com.baijia.tianxiao.sal.student.api.StudentLessonService;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.util.CollectionHelper;
import com.baijia.tianxiao.util.ListUtil;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Semaphore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class StudentLessonServiceImpl
extends AbstractBaseRedisDao
implements StudentLessonService {
    private static final Logger log = LoggerFactory.getLogger(StudentLessonServiceImpl.class);
    private static final int PAGE_SIZE = 500;
    private static final int UPDATE_TIME_TYPE = 1;
    private static final int START_TIME_TYPE = 2;
    @Autowired
    private OrgStudentDao studentDao;
    @Autowired
    private OrgClassLessonDao classLessonDao;
    @Autowired
    private OrgStudentLessonDao studentLessonDao;
    @Autowired
    private OrgStudentCourseDao orgStudentCourseDao;
    @Autowired
    private OrgSubAccountDao subAccountDao;
    @Autowired
    private OrgCourseDao orgCourseDao;
    @Autowired
    private OrgStudentCourseService courseService;
    private static final Semaphore updateTimeStuLessonStatusSemaphore = new Semaphore(1);
    private static final Semaphore startTimeStuLessonStatusSemaphore = new Semaphore(1);
    private static final BigDecimal TO_CHARGE_VALUE = new BigDecimal("0.2");
    public static final int DEFAULT_COURSE = 0;
    public static final int IN_STUDYING_COURSE = 1;
    public static final int TO_CHARGE_COURSE = 2;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional
    public void syncClassLessonStatus(int beforeMinutes, int type) {
        log.info("[ClassLessonStatus] Start===============");
        long begin = System.currentTimeMillis();
        if (type == 1) {
            boolean isUpdateTimeAllowed = updateTimeStuLessonStatusSemaphore.tryAcquire();
            if (!isUpdateTimeAllowed) {
                log.info("[StudentLesson] Other thread is execute.");
                return;
            }
        } else {
            boolean isStartTimeAllowed = startTimeStuLessonStatusSemaphore.tryAcquire();
            if (!isStartTimeAllowed) {
                log.info("[StudentLesson] Other thread is execute.");
                return;
            }
        }
        try {
            Calendar calendar = Calendar.getInstance();
            calendar.add(12, -1 * beforeMinutes);
            PageDto pageDto = new PageDto();
            pageDto.setPageSize(Integer.valueOf(500));
            Date now = new Date();
            List lessons = null;
            lessons = type == 1 ? this.classLessonDao.getOrgClassLessonsByUpdateTime(calendar.getTime(), now, pageDto) : this.classLessonDao.getOrgClassLessonsByStartTime(calendar.getTime(), now, pageDto);
            while (lessons != null && lessons.size() > 0) {
                log.info("[ClassLessonStatus]Executing===============");
                this.updateClassLessonStatus(lessons);
                pageDto.setPageNum(Integer.valueOf(pageDto.getPageNum() + 1));
                if (type == 1) {
                    lessons = this.classLessonDao.getOrgClassLessonsByUpdateTime(calendar.getTime(), now, pageDto);
                    continue;
                }
                lessons = this.classLessonDao.getOrgClassLessonsByStartTime(calendar.getTime(), now, pageDto);
            }
        }
        finally {
            if (type == 1) {
                updateTimeStuLessonStatusSemaphore.release();
            } else {
                startTimeStuLessonStatusSemaphore.release();
            }
        }
        log.info("[ClassLessonStatus] cost={}", (Object)(System.currentTimeMillis() - begin));
    }

    private void updateClassLessonStatus(List<OrgClassLesson> lessons) {
        Date now = new Date();
        HashSet<Long> unStartIds = new HashSet<Long>();
        HashSet<Long> finishedIds = new HashSet<Long>();
        for (OrgClassLesson lesson : lessons) {
            if (lesson.getStartTime().compareTo(now) <= 0) {
                finishedIds.add(lesson.getId());
                continue;
            }
            unStartIds.add(lesson.getId());
        }
        if (unStartIds.size() > 0) {
            this.studentLessonDao.batchUpdateStatus(unStartIds, LessonStatus.UN_START.getStatus());
        }
        if (finishedIds.size() > 0) {
            this.studentLessonDao.batchUpdateStatus(finishedIds, LessonStatus.FINISHED.getStatus());
        }
    }

    @Override
    @Transactional
    public void syncStuLessonStatus(int beforeMinutes) {
        Calendar calendar = Calendar.getInstance();
        calendar.add(12, -1 * beforeMinutes);
        PageDto pageDto = new PageDto();
        pageDto.setPageSize(Integer.valueOf(500));
        Date now = new Date();
        List stuLessons = this.studentLessonDao.getStuLessonsByUpdateTime(calendar.getTime(), now, pageDto);
        while (stuLessons != null && stuLessons.size() > 0) {
            log.info("[StudentLesson] Sync by student lesson changed.size={}", (Object)stuLessons.size());
            this.updateLessonStartStatusByUpdateTime(stuLessons);
            pageDto.setPageNum(Integer.valueOf(pageDto.getPageNum() + 1));
            stuLessons = this.studentLessonDao.getStuLessonsByUpdateTime(calendar.getTime(), now, pageDto);
        }
    }

    private void updateLessonStartStatusByUpdateTime(List<OrgStudentLesson> stuLessons) {
        HashSet<Long> lessonIds = new HashSet<Long>();
        for (OrgStudentLesson stuLesson : stuLessons) {
            lessonIds.add(stuLesson.getLessonId());
        }
        List classLessons = this.classLessonDao.getByIds(lessonIds, new String[0]);
        Map classLessonMap = CollectionHelper.toIdMap((Collection)classLessons);
        HashSet finishedIds = Sets.newHashSet();
        HashSet unStartedIds = Sets.newHashSet();
        Date now = new Date();
        for (OrgStudentLesson stuLesson : stuLessons) {
            OrgClassLesson classLesson = (OrgClassLesson)classLessonMap.get(stuLesson.getLessonId());
            if (classLesson.getStartTime().compareTo(now) <= 0) {
                finishedIds.add(stuLesson.getId());
                continue;
            }
            unStartedIds.add(stuLesson.getId());
        }
        log.info("[StudentLesson] finishedIds={},unStartedIds={}", (Object)finishedIds, (Object)unStartedIds);
        if (!finishedIds.isEmpty()) {
            this.studentLessonDao.batchUpdateStartStatusById((Collection)finishedIds, LessonStatus.FINISHED.getStatus());
        }
        if (!unStartedIds.isEmpty()) {
            this.studentLessonDao.batchUpdateStartStatusById((Collection)unStartedIds, LessonStatus.UN_START.getStatus());
        }
    }

    @Override
    @Transactional
    public void syncStudentStatus(long orgId) {
        log.info("[SyncStudentStatus] Start===============,orgId={}", (Object)orgId);
        long begin = System.currentTimeMillis();
        PageDto pageDto = new PageDto();
        pageDto.setPageSize(Integer.valueOf(500));
        List stuStatisticsList = this.studentLessonDao.getStudentLessonCounterList(orgId, pageDto);
        List allCourseIds = ListUtil.toKeyList((Collection)stuStatisticsList, (String)"courseId", StudentLessonStatistics.class);
        Map<CourseTypeEnum, Set<Long>> courseIdsMap = this.courseService.splitCourseIdsByCourseType(allCourseIds);
        Long lastId = null;
        StudentLessonCount lastStuLessonCount = null;
        boolean isToCharge = false;
        HashSet<Long> lessonUserIds = new HashSet<Long>();
        while (stuStatisticsList.size() > 0) {
            log.info("[StudentLesson] sync data size={},orgId={}", (Object)stuStatisticsList.size(), (Object)orgId);
            HashSet<Long> toChargeIds = new HashSet<Long>();
            HashSet<Long> pastIds = new HashSet<Long>();
            Set<Object> studyingIds = new HashSet();
            HashSet<Long> unLessonIds = new HashSet<Long>();
            HashMap<Long, StudentLessonCount> countMap = new HashMap<Long, StudentLessonCount>();
            if (lastId != null) {
                countMap.put(lastId, lastStuLessonCount);
            }
            HashSet userIds = Sets.newHashSet();
            for (StudentLessonStatistics statistics : stuStatisticsList) {
                long userId = statistics.getUserId();
                userIds.add(userId);
                lessonUserIds.add(userId);
            }
            List searchStudentClassHourStatus = this.orgStudentCourseDao.searchStudentClassHourStatus((Set)userIds, Long.valueOf(orgId));
            Map<String, StudentClass> statusMap = this.buildStudentClassStatusInfo(searchStudentClassHourStatus);
            for (StudentLessonStatistics statistics : stuStatisticsList) {
                Long courseId;
                Long userId = statistics.getUserId();
                String key = String.format("%s_%s", userId, courseId = Long.valueOf(statistics.getCourseId()));
                StudentClass sc = statusMap.get(key);
                if (sc != null) {
                    statistics.setStudentLessonStatus(sc.getStatus());
                    if (ChargeUnit.isByTime((int)sc.getChargeUnit())) {
                        statistics.setTotalCount(Math.max((long)sc.getContractCount(), statistics.getTotalArrangeTime()));
                        statistics.setFinishedCount(statistics.getKexiaoTime());
                        continue;
                    }
                    statistics.setTotalCount(Math.max((long)sc.getContractCount(), statistics.getTotalCount()));
                    continue;
                }
                statistics.setStudentLessonStatus(StudentCourseStatus.NORMAL.getCode());
                statistics.setTotalCount(statistics.getFinishedCount());
            }
            for (StudentLessonStatistics counter : stuStatisticsList) {
                int courseStatus;
                long userId = counter.getUserId();
                StudentLessonCount count = (StudentLessonCount)countMap.get(userId);
                if (count == null) {
                    count = new StudentLessonCount();
                    countMap.put(counter.getUserId(), count);
                }
                if ((courseStatus = count.add(counter)) == 2) {
                    toChargeIds.add(counter.getUserId());
                    isToCharge = true;
                } else {
                    isToCharge = false;
                }
                lastId = counter.getUserId();
                lastStuLessonCount = count;
            }
            for (Long uerId : countMap.keySet()) {
                StudentLessonCount count = (StudentLessonCount)countMap.get(uerId);
                log.info("[StudentLesson] userId={},courseIds={}", (Object)uerId, count.getCourseIds());
                if (!count.isPast()) continue;
                pastIds.add(uerId);
            }
            studyingIds = countMap.keySet();
            Map<Long, List<Long>> stuLessonMap = this.getStuCourseId(userIds, orgId);
            log.info("[StudentLesson] pass studentId enroll map={}", stuLessonMap);
            for (Long uerId : pastIds) {
                List courses;
                Set<Long> lessonCourseIds = ((StudentLessonCount)countMap.get(uerId)).getCourseIds();
                List<Long> enrollCourseId = stuLessonMap.get(uerId);
                if (enrollCourseId == null) {
                    log.warn("[StudentLesson] uerId {} no enroll record", (Object)uerId);
                    continue;
                }
                enrollCourseId.removeAll(lessonCourseIds);
                if (enrollCourseId.size() <= 0 || (courses = this.orgCourseDao.getNormalCourseList(enrollCourseId, new String[0])) == null || courses.size() <= 0) continue;
                unLessonIds.add(uerId);
            }
            log.info("[StudentLesson] Before: toChargeIds={},pastIds={},studyingIds={},lastId={}", new Object[]{toChargeIds, pastIds, studyingIds, lastId});
            toChargeIds.remove(lastId);
            pastIds.remove(lastId);
            studyingIds.remove(lastId);
            pastIds.removeAll(unLessonIds);
            studyingIds.removeAll(pastIds);
            studyingIds.removeAll(toChargeIds);
            log.info("[StudentLesson] After: toChargeIds={},pastIds={},studyingIds={},lastId={}", new Object[]{toChargeIds, pastIds, studyingIds, lastId});
            if (toChargeIds.size() > 0) {
                this.studentDao.batchUpdateStudentStatus(orgId, toChargeIds, StudentLessonStatus.TO_CHARGE.getStatus());
            }
            if (pastIds.size() > 0) {
                this.studentDao.batchUpdateStudentStatus(orgId, pastIds, StudentLessonStatus.PAST.getStatus());
            }
            if (studyingIds.size() > 0) {
                this.studentDao.batchUpdateStudentStatus(orgId, studyingIds, StudentLessonStatus.STUDYING.getStatus());
            }
            pageDto.setPageNum(Integer.valueOf(pageDto.getPageNum() + 1));
            stuStatisticsList = this.studentLessonDao.getStudentLessonCounterList(orgId, pageDto);
        }
        if (lastId != null) {
            StudentLessonStatus status = null;
            if (isToCharge) {
                status = StudentLessonStatus.TO_CHARGE;
            } else if (lastStuLessonCount.isHasInStudying()) {
                status = StudentLessonStatus.STUDYING;
            } else if (lastStuLessonCount.isPast()) {
                status = StudentLessonStatus.PAST;
            }
            if (status != null) {
                this.studentDao.batchUpdateStudentStatus(orgId, Arrays.asList(lastId), status.getStatus());
            }
        }
        List allStuCourses = this.orgStudentCourseDao.getOrgStudentCourseByUserIds(Long.valueOf(orgId), null, new String[]{"userId", "status"});
        HashSet<Long> studyingIds = new HashSet<Long>();
        HashSet<Long> pastIds = new HashSet<Long>();
        for (OrgStudentCourse studentCourse : allStuCourses) {
            if (lessonUserIds.contains(studentCourse.getUserId())) continue;
            if (studentCourse.getStatus() != 0 && !studyingIds.contains(studentCourse.getUserId())) {
                pastIds.add(studentCourse.getUserId());
                continue;
            }
            pastIds.remove(studentCourse.getUserId());
            studyingIds.add(studentCourse.getUserId());
        }
        if (studyingIds.size() > 0) {
            log.info("[StudentLesson] Reset studyingIds={}", studyingIds);
            this.studentDao.batchUpdateStudentStatus(orgId, studyingIds, StudentLessonStatus.STUDYING.getStatus());
        }
        if (pastIds.size() > 0) {
            log.info("[StudentLesson] Reset pastIds={}", pastIds);
            this.studentDao.batchUpdateStudentStatus(orgId, pastIds, StudentLessonStatus.PAST.getStatus());
        }
        log.info("[ClassLessonStatus] Org({}) Update finished.cost={}", (Object)orgId, (Object)(System.currentTimeMillis() - begin));
    }

    private Map<String, StudentClass> buildStudentClassStatusInfo(List<StudentClassHourStatusDocument> studentClassHourStatusDocumentLists) {
        HashMap statusMap = Maps.newHashMap();
        for (StudentClassHourStatusDocument next : studentClassHourStatusDocumentLists) {
            Long userId = next.getUserId();
            Long courseId = next.getCourseId();
            Integer lessonCount = next.getLessonCount();
            StudentClass studentClass = new StudentClass();
            String key = userId + "_" + courseId;
            Integer status = next.getStatus();
            studentClass.setStatus(status.intValue());
            studentClass.setContractCount(lessonCount == null ? 0 : lessonCount);
            studentClass.setUserId(userId.longValue());
            studentClass.setCourseId(courseId.longValue());
            studentClass.setChargeUnit(Integer.valueOf(next.getChargeUnit()));
            statusMap.put(key, studentClass);
        }
        log.info("statusMap is :{}", (Object)statusMap);
        return statusMap;
    }

    private Map<Long, List<Long>> getStuCourseId(Collection<Long> stuIds, Long orgId) {
        if (stuIds == null || stuIds.size() < 1) {
            return Collections.EMPTY_MAP;
        }
        return this.orgStudentCourseDao.getCourseIdMapByStuIds(stuIds, orgId);
    }

    @Override
    public List<Integer> getAllTxOrgIds() {
        List accounts = this.subAccountDao.getAll(new String[]{"orgId"});
        List list = ListUtil.toKeyList((Collection)accounts, (String)"orgId", OrgSubAccount.class);
        return list;
    }

    private class StudentLessonCount {
        private Set<Long> courseIds = new HashSet<Long>();
        private boolean hasInStudying;
        private boolean hasToCharge;
        private boolean isPast = true;
        private boolean hasCourse = false;

        public int add(StudentLessonStatistics statistics) {
            log.info("statistics is :{} ", (Object)statistics);
            int retStatus = 0;
            boolean classIsNormal = statistics.isNormalCourse();
            long maxCount = statistics.getTotalCount();
            long finishCount = statistics.getFinishedCount();
            if (classIsNormal && finishCount < maxCount) {
                this.isPast = false;
                this.hasInStudying = true;
                retStatus = 1;
                if (this.isToCharge(maxCount, maxCount - finishCount)) {
                    this.hasToCharge = true;
                    retStatus = 2;
                }
            }
            this.hasCourse = true;
            this.courseIds.add(statistics.getCourseId());
            return retStatus;
        }

        public boolean isPast() {
            return this.isPast && this.hasCourse;
        }

        private boolean isToCharge(long totalCount, long leftCount) {
            return this.getLeftCountRatio(totalCount, leftCount).compareTo(TO_CHARGE_VALUE) < 0;
        }

        public BigDecimal getLeftCountRatio(long totalCount, long leftCount) {
            if (leftCount <= 0L || totalCount == 0L) {
                return BigDecimal.ZERO;
            }
            BigDecimal total = new BigDecimal(totalCount);
            BigDecimal left = new BigDecimal(leftCount);
            return left.divide(total, 2, 6);
        }

        public Set<Long> getCourseIds() {
            return this.courseIds;
        }

        public boolean isHasInStudying() {
            return this.hasInStudying;
        }

        public boolean isHasToCharge() {
            return this.hasToCharge;
        }

        public boolean isHasCourse() {
            return this.hasCourse;
        }

        public void setCourseIds(Set<Long> courseIds) {
            this.courseIds = courseIds;
        }

        public void setHasInStudying(boolean hasInStudying) {
            this.hasInStudying = hasInStudying;
        }

        public void setHasToCharge(boolean hasToCharge) {
            this.hasToCharge = hasToCharge;
        }

        public void setPast(boolean isPast) {
            this.isPast = isPast;
        }

        public void setHasCourse(boolean hasCourse) {
            this.hasCourse = hasCourse;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof StudentLessonCount)) {
                return false;
            }
            StudentLessonCount other = (StudentLessonCount)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Set<Long> this$courseIds = this.getCourseIds();
            Set<Long> other$courseIds = other.getCourseIds();
            if (this$courseIds == null ? other$courseIds != null : !((Object)this$courseIds).equals(other$courseIds)) {
                return false;
            }
            if (this.isHasInStudying() != other.isHasInStudying()) {
                return false;
            }
            if (this.isHasToCharge() != other.isHasToCharge()) {
                return false;
            }
            if (this.isPast() != other.isPast()) {
                return false;
            }
            return this.isHasCourse() == other.isHasCourse();
        }

        protected boolean canEqual(Object other) {
            return other instanceof StudentLessonCount;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Set<Long> $courseIds = this.getCourseIds();
            result = result * 59 + ($courseIds == null ? 43 : ((Object)$courseIds).hashCode());
            result = result * 59 + (this.isHasInStudying() ? 79 : 97);
            result = result * 59 + (this.isHasToCharge() ? 79 : 97);
            result = result * 59 + (this.isPast() ? 79 : 97);
            result = result * 59 + (this.isHasCourse() ? 79 : 97);
            return result;
        }

        public String toString() {
            return "StudentLessonServiceImpl.StudentLessonCount(courseIds=" + this.getCourseIds() + ", hasInStudying=" + this.isHasInStudying() + ", hasToCharge=" + this.isHasToCharge() + ", isPast=" + this.isPast() + ", hasCourse=" + this.isHasCourse() + ")";
        }
    }
}

