/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.student.impl;

import com.baijia.tianxiao.constant.AvatarConstants;
import com.baijia.tianxiao.constant.Flag;
import com.baijia.tianxiao.constants.CourseType;
import com.baijia.tianxiao.constants.PayStatus;
import com.baijia.tianxiao.dal.callservice.dao.CallServiceInfoDao;
import com.baijia.tianxiao.dal.callservice.dao.OrgPushCallInfoDao;
import com.baijia.tianxiao.dal.callservice.po.CallServiceInfo;
import com.baijia.tianxiao.dal.callservice.po.OrgPushCallInfo;
import com.baijia.tianxiao.dal.org.constant.DeleteStatus;
import com.baijia.tianxiao.dal.org.constant.StudentType;
import com.baijia.tianxiao.dal.org.dao.CoursePurchaseDao;
import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgInfoDao;
import com.baijia.tianxiao.dal.org.dao.OrgStorageDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.dao.OrgSubAccountDao;
import com.baijia.tianxiao.dal.org.dao.TXCascadeAccountDao;
import com.baijia.tianxiao.dal.org.dao.TXCascadeCredentialDao;
import com.baijia.tianxiao.dal.org.po.CoursePurchase;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.org.po.OrgInfo;
import com.baijia.tianxiao.dal.org.po.OrgStorage;
import com.baijia.tianxiao.dal.org.po.OrgStudent;
import com.baijia.tianxiao.dal.org.po.OrgSubAccount;
import com.baijia.tianxiao.dal.org.po.TXCascadeAccount;
import com.baijia.tianxiao.dal.org.po.TXCascadeCredential;
import com.baijia.tianxiao.dal.push.constant.CardType;
import com.baijia.tianxiao.dal.push.constant.MessageSource;
import com.baijia.tianxiao.dal.push.constant.MsgType;
import com.baijia.tianxiao.dal.push.constant.MsgUserRole;
import com.baijia.tianxiao.dal.push.dto.content.AudioMsgContent;
import com.baijia.tianxiao.dal.push.dto.content.CardMsgContent;
import com.baijia.tianxiao.dal.push.dto.content.ImageMsgContent;
import com.baijia.tianxiao.dal.push.po.ConsultMessage;
import com.baijia.tianxiao.dal.roster.CommentSearchDto;
import com.baijia.tianxiao.dal.roster.constant.AddType;
import com.baijia.tianxiao.dal.roster.constant.DownLoadStatus;
import com.baijia.tianxiao.dal.roster.constant.MobileStatus;
import com.baijia.tianxiao.dal.roster.dao.TxConsultUserDao;
import com.baijia.tianxiao.dal.roster.dao.TxStudentCommentDao;
import com.baijia.tianxiao.dal.roster.po.TxConsultUser;
import com.baijia.tianxiao.dal.roster.po.TxStudentComment;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupCourseDao;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupInfoDao;
import com.baijia.tianxiao.dal.signup.po.OrgSignupCourse;
import com.baijia.tianxiao.dal.signup.po.OrgSignupInfo;
import com.baijia.tianxiao.dal.sync.constant.MsgSyncType;
import com.baijia.tianxiao.dal.sync.dao.TxMsgSyncTimestampDao;
import com.baijia.tianxiao.dal.sync.po.TxMsgSyncTimestamp;
import com.baijia.tianxiao.dal.user.dao.TeacherDao;
import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.filter.TianxiaoMContext;
import com.baijia.tianxiao.sal.common.api.AccountApiService;
import com.baijia.tianxiao.sal.common.api.OrgStudentApiService;
import com.baijia.tianxiao.sal.common.api.TXStudentCommentAPIService;
import com.baijia.tianxiao.sal.organization.constant.DeviceType;
import com.baijia.tianxiao.sal.organization.constant.TXPermissionConst;
import com.baijia.tianxiao.sal.organization.org.service.OrgInfoService;
import com.baijia.tianxiao.sal.organization.org.service.TxAccountPermissionService;
import com.baijia.tianxiao.sal.organization.org.service.TxCascadeCredentialService;
import com.baijia.tianxiao.sal.push.service.ConsultMessageService;
import com.baijia.tianxiao.sal.push.utils.PushTipFactory;
import com.baijia.tianxiao.sal.student.api.OrgStudentCommentService;
import com.baijia.tianxiao.sal.student.api.TxCustomRecordService;
import com.baijia.tianxiao.sal.student.dto.CommentInfoDto;
import com.baijia.tianxiao.sal.student.dto.CreatorDto;
import com.baijia.tianxiao.sal.student.dto.TxCustomRecordHistoryDto;
import com.baijia.tianxiao.sal.student.dto.request.RosterCommentRequestDto;
import com.baijia.tianxiao.sal.student.dto.request.StudentCommenRequestDto;
import com.baijia.tianxiao.sal.student.dto.response.OrgCommentsListReponse;
import com.baijia.tianxiao.sal.student.enums.StudentErrorCode;
import com.baijia.tianxiao.sal.student.util.CommentUtil;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.util.GenericsUtils;
import com.baijia.tianxiao.util.collection.CollectorUtil;
import com.baijia.tianxiao.util.exception.BussinessPreconditions;
import com.baijia.tianxiao.util.json.JacksonUtil;
import com.baijia.tianxiao.util.storage.StorageUtil;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class OrgStudentCommentServiceImpl
implements OrgStudentCommentService {
    private static final Logger log = LoggerFactory.getLogger(OrgStudentCommentServiceImpl.class);
    private static int MAX_SYNC_NUM = 100;
    @Autowired
    private OrgStudentDao orgStudentsDao;
    @Autowired
    private TxConsultUserDao txConsultUserDao;
    @Autowired
    private TxStudentCommentDao txStudentCommentDao;
    @Autowired
    private OrgStorageDao orgStorageDao;
    @Autowired
    private CoursePurchaseDao coursePurchaseDao;
    @Autowired
    private TxMsgSyncTimestampDao txMsgSyncTimestampDao;
    @Autowired
    private OrgSignupInfoDao orgSignupInfoDao;
    @Autowired
    private OrgSignupCourseDao orgSignupCourseDao;
    @Autowired
    private OrgCourseDao orgCourseDao;
    @Autowired
    private CallServiceInfoDao callServiceInfoDao;
    @Autowired
    private OrgPushCallInfoDao orgPushCallInfoDao;
    @Autowired
    private TXCascadeAccountDao txCascadeAccountDao;
    @Autowired
    private TXCascadeCredentialDao txCascadeCredentialDao;
    @Autowired
    private OrgSubAccountDao orgSubAccountDao;
    @Autowired
    private ConsultMessageService consultMessageService;
    @Autowired
    private OrgInfoDao orgInfoDao;
    @Autowired
    private OrgAccountDao orgAccountDao;
    @Autowired
    private TxCascadeCredentialService credentialService;
    @Autowired
    private TXStudentCommentAPIService txStudentCommentAPIService;
    @Autowired
    private TxAccountPermissionService permissionService;
    @Autowired
    private AccountApiService accountApiService;
    @Autowired
    private OrgInfoService orgInfoService;
    @Autowired
    private TxCustomRecordService txCustomRecordService;
    @Autowired
    private TeacherDao teacherDao;
    @Autowired
    private OrgStudentApiService orgStudentApiService;
    @Autowired
    private OrgStudentDao orgStudentDao;

    @Override
    @Transactional(rollbackFor={Exception.class}, propagation=Propagation.REQUIRES_NEW)
    public List<Long> addStudentComment(RosterCommentRequestDto dto, Long orgId) throws Exception {
        Date now = new Date();
        if (!dto.vaildate()) {
            log.warn("add comments error: type ,studentId or comments is null!");
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR);
        }
        OrgStudent student = null;
        List commentDtos = new ArrayList();
        try {
            commentDtos = JacksonUtil.str2List((String)dto.getComments(), CommentInfoDto.class);
            log.info("commentDtos param:{}", commentDtos);
        }
        catch (Exception e) {
            log.info("json \u89e3\u6790\u5931\u8d25 param:{}", (Throwable)e);
        }
        String preInfoFormat = "%s:%s\n";
        String type = "";
        String name = "";
        if (dto.getType().intValue() == StudentType.ORG_STUDENTS.getCode()) {
            student = (OrgStudent)this.orgStudentsDao.getById((Serializable)dto.getStudentId(), new String[]{"id", "userId", "orgId", "name", "nickName", "mobile"});
            if (student == null || student.getOrgId().longValue() != orgId.longValue()) {
                throw new BussinessException((UniverseErrorCode)StudentErrorCode.STUDENT_NOT_EXIST);
            }
            name = student.getName();
            name = GenericsUtils.isNullOrEmpty((Object)name) ? student.getNickName() : name;
            name = GenericsUtils.isNullOrEmpty((Object)name) ? student.getMobile() : name;
            type = "\u5b66\u5458";
            student.setLastRemindTime(now);
            student.setUpdateTime(now);
            this.orgStudentsDao.update((Object)student, new String[0]);
            log.info("======{}", (Object)student);
        } else {
            student = new OrgStudent();
            TxConsultUser user = (TxConsultUser)this.txConsultUserDao.getById((Serializable)dto.getStudentId(), new String[0]);
            if (user == null || user.getOrgId().longValue() != orgId.longValue()) {
                throw new BussinessException((UniverseErrorCode)StudentErrorCode.CONSULT_USER_NOT_EXIST);
            }
            name = user.getName();
            name = GenericsUtils.isNullOrEmpty((Object)name) ? user.getNickName() : name;
            name = GenericsUtils.isNullOrEmpty((Object)name) ? user.getMobile() : name;
            type = "\u7ebf\u7d22";
            student.setUserId(user.getUserId());
            student.setOrgId(Long.valueOf(user.getOrgId()));
            user.setLastRemindTime(now);
            user.setUpdateTime(now);
            this.txConsultUserDao.update((Object)user, new String[0]);
        }
        if (GenericsUtils.isNullOrEmpty((Object)name)) {
            name = "";
        }
        String preInfoStr = String.format(preInfoFormat, type, name);
        ArrayList comments = Lists.newArrayList();
        for (CommentInfoDto ciDto : commentDtos) {
            TxStudentComment po = new TxStudentComment();
            if (dto.getType().intValue() == StudentType.CONSULT_USER.getCode()) {
                po.setConsultUserId(dto.getStudentId());
            }
            po.setUserId(student.getUserId());
            po.setOrgId(orgId);
            po.setSeconds(ciDto.getSeconds());
            po.setSoundId(ciDto.getSoundId());
            po.setStorageIds(ciDto.getStorageIds());
            po.setContent(ciDto.getContent());
            po.setCommentType(ciDto.getCommentType());
            po.setGrowthComments(Integer.valueOf(ciDto.getGrowthComments() != null ? ciDto.getGrowthComments().intValue() : Flag.FALSE.getInt()));
            po.setNotifyParents(Integer.valueOf(ciDto.getNotifyParents() != null ? ciDto.getNotifyParents().intValue() : Flag.FALSE.getInt()));
            po.setCreatorCascadeId(dto.getCreatorCascadeId());
            ciDto.setCreatorCascadeId(dto.getCreatorCascadeId());
            if (ciDto.getCommentType() == null) {
                ciDto.setCommentType(0);
            }
            if (StringUtils.isNotBlank((CharSequence)ciDto.getNotifyColleague())) {
                try {
                    this.sendNotifyToColleague(preInfoStr, ciDto, orgId);
                }
                catch (Exception e) {
                    log.error("addStudentComment NotifyColleague error {} ", (Throwable)e);
                }
            }
            comments.add(po);
        }
        this.txStudentCommentDao.saveAll((List)comments, new String[0]);
        ArrayList result = Lists.newArrayList();
        for (TxStudentComment txStudentComment : comments) {
            result.add(txStudentComment.getId());
        }
        return result;
    }

    private String generateSendNotifyInfos(Long userId, Long orgId, Integer userType) {
        String preInfoFormat = "%s:%s\n";
        String type = "";
        String name = "";
        if (userType.intValue() == StudentType.ORG_STUDENTS.getCode()) {
            OrgStudent student = this.orgStudentsDao.getStudentByUserId(orgId, userId, new String[]{"userId", "orgId", "name", "nickName", "mobile"});
            if (student == null || student.getOrgId().longValue() != orgId.longValue()) {
                throw new BussinessException((UniverseErrorCode)StudentErrorCode.STUDENT_NOT_EXIST);
            }
            name = student.getName();
            name = GenericsUtils.isNullOrEmpty((Object)name) ? student.getNickName() : name;
            name = GenericsUtils.isNullOrEmpty((Object)name) ? student.getMobile() : name;
            type = "\u5b66\u5458";
        } else {
            TxConsultUser user = (TxConsultUser)this.txConsultUserDao.getById((Serializable)userId, new String[0]);
            if (user == null || user.getOrgId().longValue() != orgId.longValue()) {
                throw new BussinessException((UniverseErrorCode)StudentErrorCode.CONSULT_USER_NOT_EXIST);
            }
            name = user.getName();
            name = GenericsUtils.isNullOrEmpty((Object)name) ? user.getNickName() : name;
            name = GenericsUtils.isNullOrEmpty((Object)name) ? user.getMobile() : name;
            type = "\u7ebf\u7d22";
        }
        String preInfoStr = String.format(preInfoFormat, type, name);
        return preInfoStr;
    }

    private void sendNotifyToColleague(String preInfoStr, CommentInfoDto ciDto, Long orgId) {
        OrgAccount accountById;
        String notifyColleague = ciDto.getNotifyColleague();
        log.info("notifyColleague is : {} ", (Object)notifyColleague);
        if (GenericsUtils.isNullOrEmpty((Object)notifyColleague)) {
            return;
        }
        Integer cascadeId = ciDto.getCreatorCascadeId() != null ? ciDto.getCreatorCascadeId().intValue() : Flag.FALSE.getInt();
        List<String> colleagues = Arrays.asList(notifyColleague.split(","));
        log.info("colleagues list is : {} ", colleagues);
        HashSet<Long> receiveCascadeIds = new HashSet<Long>();
        Long selfAccount = null;
        for (String colleagueId : colleagues) {
            if (GenericsUtils.isNullOrEmpty((Object)colleagueId)) continue;
            Long receiveId = Long.parseLong(colleagueId);
            if (receiveId != 0L) {
                receiveCascadeIds.add(receiveId);
                continue;
            }
            selfAccount = 0L;
        }
        log.info("all receive CascadeIDs is : {}", receiveCascadeIds);
        List byIds = this.txCascadeAccountDao.getByIds(receiveCascadeIds, new String[0]);
        log.info(" \u6240\u6709\u5f85\u63a5\u6536\u901a\u77e5\u7684\u540c\u4e8b\u662f:{}  ", (Object)byIds);
        ConsultMessage consultMessage = new ConsultMessage();
        consultMessage.setMsgType(MsgType.CARD.getValue());
        consultMessage.setSenderRole(this.getMsgUserType(orgId.intValue(), cascadeId).intValue());
        consultMessage.setSenderId((long)cascadeId.intValue());
        this.fillMsgInfos(preInfoStr, consultMessage, ciDto);
        String senderName = this.accountApiService.getAccountName(orgId, Long.valueOf(cascadeId.intValue()));
        String tip = PushTipFactory.getFollowTip((String)senderName);
        consultMessage.setTip(tip);
        consultMessage.setPushTitle("\u8ddf\u8fdb\u901a\u77e5");
        if (GenericsUtils.notNullAndEmpty((Object)byIds)) {
            for (TXCascadeAccount ta : byIds) {
                Integer accountType = ta.getAccountType();
                consultMessage.setReceiverRole(accountType.intValue());
                consultMessage.setReceiverId((long)ta.getId().intValue());
                try {
                    boolean sendStaffMsg = this.consultMessageService.sendStaffMsg(orgId.longValue(), cascadeId, consultMessage);
                    log.info("success to send to staff :{} for message : {} and status is : {} ", new Object[]{cascadeId, consultMessage, sendStaffMsg});
                }
                catch (Exception e) {
                    log.info("can not send notify to colleague whose info is : {} ", (Object)consultMessage);
                }
            }
        }
        if ((accountById = this.orgAccountDao.getAccountById(orgId.intValue(), new String[0])) == null) {
            throw new RuntimeException("can not send message to org master account cause by no exists : " + orgId);
        }
        if (selfAccount != null && 0L == selfAccount) {
            consultMessage.setReceiverRole(MsgUserRole.HEADER.getValue());
            consultMessage.setReceiverId((long)accountById.getNumber().intValue());
            this.consultMessageService.sendStaffMsg(orgId.longValue(), cascadeId, consultMessage);
        }
    }

    private void fillMsgInfos(String preInfoStr, ConsultMessage consultMessage, CommentInfoDto ciDto) {
        String storageIds;
        consultMessage.setConsultType(MessageSource.STAFF_INFO.getValue());
        CardMsgContent cardMsgContent = new CardMsgContent();
        cardMsgContent.setTitle(CardType.FOLLOW.getDesc());
        cardMsgContent.setType(CardType.FOLLOW.getValue());
        cardMsgContent.setText(preInfoStr + ciDto.getContent());
        if (ciDto.getSeconds() != 0 && ciDto.getSoundId() != 0L) {
            ArrayList<AudioMsgContent> msgList = new ArrayList<AudioMsgContent>();
            OrgStorage storage = (OrgStorage)this.orgStorageDao.getById((Serializable)ciDto.getSoundId(), new String[0]);
            AudioMsgContent msg = new AudioMsgContent();
            if (storage != null) {
                msg.setUrl(StorageUtil.constructUrl((String)storage.getFid(), (String)storage.getSn(), (Integer)storage.getMimeType()));
                msg.setLen(ciDto.getSeconds().intValue());
                msg.setStorageId(ciDto.getSoundId().longValue());
                msgList.add(msg);
                cardMsgContent.setAudios(msgList);
            }
        }
        if (GenericsUtils.notNullAndEmpty((Object)(storageIds = ciDto.getStorageIds()))) {
            ArrayList<ImageMsgContent> imgMsgList = new ArrayList<ImageMsgContent>();
            List<String> storageIdList = Arrays.asList(storageIds.split(","));
            for (int i = 0; i < storageIdList.size(); ++i) {
                ImageMsgContent imgMsg = new ImageMsgContent();
                imgMsg.setStorageId(Integer.parseInt(storageIdList.get(i)));
                OrgStorage orgStorage = (OrgStorage)this.orgStorageDao.getById((Serializable)((Object)storageIdList.get(i)), new String[0]);
                if (orgStorage == null) continue;
                imgMsg.setUrl(StorageUtil.constructUrl((String)orgStorage.getFid(), (String)orgStorage.getSn(), (Integer)orgStorage.getMimeType()));
                imgMsgList.add(imgMsg);
            }
            cardMsgContent.setImages(imgMsgList);
        }
        Gson gson = new Gson();
        String text = gson.toJson((Object)cardMsgContent);
        log.info("cardMsgContent is : {} ", (Object)text);
        consultMessage.setContent(text);
    }

    private Integer getMsgUserType(Integer orgId, Integer cascadeId) {
        OrgAccount accountById = this.orgAccountDao.getAccountById(orgId.intValue(), new String[0]);
        Integer superRoleType = null;
        if (cascadeId != null && (long)cascadeId.intValue() != 0L) {
            TXCascadeAccount tca = (TXCascadeAccount)this.txCascadeAccountDao.getById((Serializable)cascadeId, new String[0]);
            if (tca == null) {
                log.info("can not find any cascade account with cadcadeId : {} ", (Object)cascadeId);
                return null;
            }
            superRoleType = tca.getAccountType();
        } else {
            OrgSubAccount osa = this.orgSubAccountDao.getByOrgId(Integer.valueOf(orgId), new String[0]);
            if (osa == null) {
                if (accountById == null) {
                    log.info(" can not find any org account with orgId : {} ", (Object)orgId);
                    return null;
                }
                superRoleType = MsgUserRole.HEADER.getValue();
            } else {
                Integer pId = osa.getPid();
                superRoleType = 0 == pId ? Integer.valueOf(MsgUserRole.HEADER.getValue()) : Integer.valueOf(MsgUserRole.BRANCH_HEADER.getValue());
            }
        }
        return superRoleType;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void delStudentComment(StudentCommenRequestDto studentCommenRequestDto, Long orgId) {
        if (studentCommenRequestDto.getCommentId() == null) {
            log.warn("del comment error: commentId is null!");
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR);
        }
        TxStudentComment comment = (TxStudentComment)this.txStudentCommentDao.getById((Serializable)studentCommenRequestDto.getCommentId(), new String[0]);
        if (comment == null || comment.getOrgId().longValue() != orgId.longValue()) {
            throw new BussinessException((UniverseErrorCode)StudentErrorCode.COMMENT_NOT_EXIST);
        }
        if (comment.getIsSystem().intValue() == AddType.SYSTEM.getCode()) {
            throw new BussinessException((UniverseErrorCode)StudentErrorCode.SYSTEM_COMMENT);
        }
        this.txStudentCommentDao.delById((Serializable)comment.getId());
    }

    @Override
    public OrgCommentsListReponse getComments(Integer userType, Long studentId, Long orgId, Integer cascadeId, Integer isGrowth) {
        CommentSearchDto dto = new CommentSearchDto();
        dto.setUserId(studentId.longValue());
        dto.setType(userType.intValue());
        dto.setIsGrowth(isGrowth);
        return this.searchComments(dto, orgId, cascadeId, null);
    }

    @Override
    public OrgCommentsListReponse getComments(Integer userType, Long studentId, Long orgId, Integer cascadeId, Integer isGrowth, PageDto pageDto) {
        CommentSearchDto dto = new CommentSearchDto();
        dto.setUserId(studentId.longValue());
        dto.setType(userType.intValue());
        dto.setIsGrowth(isGrowth);
        return this.searchComments(dto, orgId, cascadeId, pageDto);
    }

    @Override
    public OrgCommentsListReponse searchComments(CommentSearchDto searchDto, Long orgId, Integer cascadeId, PageDto pageDto) {
        List list;
        boolean isShow = this.credentialService.isShowMobile(orgId, TianxiaoMContext.getTXCascadeId());
        List comments = Lists.newArrayList();
        Long studentId = null;
        if (searchDto.getType() == StudentType.ORG_STUDENTS.getCode()) {
            studentId = searchDto.getUserId();
            OrgStudent student = (OrgStudent)this.orgStudentsDao.getById((Serializable)studentId, new String[]{"orgId", "userId"});
            if (student == null || student.getOrgId().longValue() != orgId.longValue()) {
                throw new BussinessException((UniverseErrorCode)StudentErrorCode.STUDENT_NOT_EXIST);
            }
            searchDto.setUserId(student.getUserId().longValue());
        } else {
            TxConsultUser user = (TxConsultUser)this.txConsultUserDao.getById((Serializable)Long.valueOf(searchDto.getUserId()), new String[0]);
            if (user == null || user.getOrgId().longValue() != orgId.longValue()) {
                throw new BussinessException((UniverseErrorCode)StudentErrorCode.CONSULT_USER_NOT_EXIST);
            }
        }
        Integer type = null;
        boolean hasPermission = this.permissionService.checkPermission(orgId, cascadeId, DeviceType.APP, Long.valueOf(TXPermissionConst.SIGN_TRANS_QUIT_DATA_ACCESS.getPCode()));
        HashSet<Integer> excludeFollowTypes = new HashSet<Integer>();
        if (!hasPermission) {
            type = 1;
            excludeFollowTypes.add(type);
        }
        if (StringUtils.isNotBlank((CharSequence)searchDto.getSearchKey()) && (list = this.credentialService.getCascadeIdsLikeName(orgId.longValue(), searchDto.getSearchKey())) != null && list.size() > 0) {
            searchDto.setUnionCascadeIds(list);
        }
        comments = this.txStudentCommentDao.searchComments(orgId, searchDto, pageDto, excludeFollowTypes);
        OrgCommentsListReponse reponse = new OrgCommentsListReponse();
        HashSet callIds = Sets.newHashSet();
        HashSet call400Ids = Sets.newHashSet();
        for (TxStudentComment comment : comments) {
            if (comment.getDownStatus().intValue() != DownLoadStatus.UNFINISH.getCode()) continue;
            if (comment.getIsMobile().intValue() == MobileStatus.IS_CALL.getCode()) {
                callIds.add(comment.getSoundId());
                continue;
            }
            if (comment.getIsMobile().intValue() != MobileStatus.IS_400_CALL.getCode()) continue;
            call400Ids.add(comment.getSoundId());
        }
        Map<Long, Long> callMap = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty((Collection)callIds)) {
            List callInfos = this.callServiceInfoDao.getByIds((Collection)callIds, new String[0]);
            callMap = CollectorUtil.collectMap((Collection)callInfos, (Function)new Function<CallServiceInfo, Long>(){

                public Long apply(CallServiceInfo arg0) {
                    return arg0.getId();
                }
            }, (Function)new Function<CallServiceInfo, Long>(){

                public Long apply(CallServiceInfo arg0) {
                    return arg0.getStorageId();
                }
            });
        }
        Map<Long, Long> call400Map = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty((Collection)call400Ids)) {
            List call400Infos = this.orgPushCallInfoDao.getByIds((Collection)call400Ids, new String[0]);
            call400Map = CollectorUtil.collectMap((Collection)call400Infos, (Function)new Function<OrgPushCallInfo, Long>(){

                public Long apply(OrgPushCallInfo arg0) {
                    return arg0.getId();
                }
            }, (Function)new Function<OrgPushCallInfo, Long>(){

                public Long apply(OrgPushCallInfo arg0) {
                    return arg0.getStorageId();
                }
            });
        }
        HashSet storageIds = Sets.newHashSet();
        for (TxStudentComment comment : comments) {
            if (StringUtils.isNotEmpty((CharSequence)comment.getStorageIds())) {
                if (comment.getStorageIds().contains(",")) {
                    String[] storageIdsStr;
                    for (String storageId : storageIdsStr = comment.getStorageIds().split(",")) {
                        storageIds.add(Integer.parseInt(storageId));
                    }
                } else {
                    storageIds.add(Integer.parseInt(comment.getStorageIds()));
                }
            }
            if (comment.getDownStatus().intValue() == DownLoadStatus.UNFINISH.getCode()) {
                Long storageId = null;
                if (comment.getIsMobile().intValue() == MobileStatus.IS_CALL.getCode()) {
                    storageId = (Long)callMap.get(comment.getSoundId());
                } else if (comment.getIsMobile().intValue() == MobileStatus.IS_400_CALL.getCode()) {
                    storageId = (Long)call400Map.get(comment.getSoundId());
                }
                if (storageId == null || storageId <= 0L) continue;
                storageIds.add(storageId.intValue());
                continue;
            }
            if (comment.getDownStatus().intValue() != DownLoadStatus.FINISH.getCode() || comment.getSoundId() == null || comment.getSoundId() <= 0L) continue;
            storageIds.add(comment.getSoundId().intValue());
        }
        List storages = this.orgStorageDao.getByIds((Collection)storageIds, new String[0]);
        Map storageMap = CollectorUtil.collectMap((Collection)storages, (Function)new Function<OrgStorage, Integer>(){

            public Integer apply(OrgStorage arg0) {
                return arg0.getId();
            }
        });
        ArrayList commentsDto = Lists.newArrayList();
        if (!CollectionUtils.isEmpty(comments)) {
            HashSet<Integer> cascadeIds = new HashSet<Integer>();
            for (TxStudentComment comment : comments) {
                cascadeIds.add(comment.getCreatorCascadeId());
            }
            Map credentialMap = this.txCascadeCredentialDao.getTxCascadeNameAndAvatar(cascadeIds);
            OrgInfo orgInfo = this.orgInfoDao.getOrgInfo(Integer.valueOf(orgId.intValue()), new String[0]);
            String logo = this.orgInfoService.getLogo(orgId.intValue());
            for (TxStudentComment comment : comments) {
                CommentInfoDto commentDto = new CommentInfoDto();
                this.commentPo2Dto(commentDto, comment, callMap, call400Map, storageMap);
                if (!isShow) {
                    commentDto.setContent(CommentUtil.maskMobile(comment.getContent()));
                }
                CreatorDto creatorDto = new CreatorDto();
                creatorDto.setCascadeId(comment.getCreatorCascadeId());
                if (comment.getCreatorCascadeId().intValue() != Flag.NULL.getInt()) {
                    if (comment.getCreatorCascadeId() == 0) {
                        creatorDto.setName(orgInfo.getContacts());
                        if (StringUtils.isNotBlank((CharSequence)logo)) {
                            creatorDto.setAvatarUrl(logo);
                        }
                    } else {
                        creatorDto.setName(((TXCascadeCredential)credentialMap.get((int)comment.getCreatorCascadeId())).getName());
                        creatorDto.setAvatarUrl(((TXCascadeCredential)credentialMap.get((int)comment.getCreatorCascadeId())).getAvatar());
                    }
                } else {
                    creatorDto.setAvatarUrl(AvatarConstants.SYSTEM_AVATAR_URL);
                    if (comment.getIsSystem().intValue() == Flag.TRUE.getInt()) {
                        creatorDto.setName("\u7cfb\u7edf");
                    } else {
                        creatorDto.setName("\u5386\u53f2\u7528\u6237");
                    }
                }
                commentDto.setCreator(creatorDto);
                commentsDto.add(commentDto);
            }
        }
        reponse.setComments(commentsDto);
        return reponse;
    }

    private void commentPo2Dto(CommentInfoDto dto, TxStudentComment po, Map<Long, Long> callMap, Map<Long, Long> call400Map, Map<Integer, OrgStorage> storageMap) {
        OrgStorage storage;
        dto.setCommentId(po.getId());
        dto.setUserId(po.getUserId());
        dto.setConsultUserId(po.getConsultUserId());
        dto.setContent(po.getContent());
        dto.setTemplateId(po.getTemplateId());
        dto.setStorageIds(po.getStorageIds());
        dto.setCreateTime(po.getCreateTime());
        dto.setCallStatus(po.getCallStatus());
        dto.setIsMobile(po.getIsMobile());
        dto.setIsSystem(po.getIsSystem());
        if (null != po.getIsMobile() && po.getIsMobile().intValue() == MobileStatus.IS_CALL.getCode()) {
            dto.setOrigin(-1);
        } else {
            dto.setOrigin(po.getOrigin());
        }
        dto.setOrigin(po.getOrigin());
        if (StringUtils.isNotEmpty((CharSequence)dto.getStorageIds())) {
            String[] storageIdsStr = dto.getStorageIds().split(",");
            ArrayList urls = Lists.newArrayList();
            for (String storageId : storageIdsStr) {
                OrgStorage storage2 = storageMap.get(Integer.parseInt(storageId));
                if (storage2 == null) continue;
                String url = StorageUtil.constructUrl((String)storage2.getFid(), (String)storage2.getSn(), (Integer)storage2.getMimeType());
                urls.add(url);
            }
            dto.setUrls(StringUtils.join((Object[])urls.toArray(new String[urls.size()]), (String)","));
        }
        if (po.getDownStatus().intValue() == DownLoadStatus.UNFINISH.getCode()) {
            Long storageId = null;
            if (po.getIsMobile().intValue() == MobileStatus.IS_CALL.getCode()) {
                storageId = callMap.get(po.getSoundId());
            } else if (po.getIsMobile().intValue() == MobileStatus.IS_400_CALL.getCode()) {
                storageId = call400Map.get(po.getSoundId());
            }
            if (storageId != null && storageId > 0L) {
                po.setSoundId(storageId);
                po.setDownStatus(Integer.valueOf(DownLoadStatus.FINISH.getCode()));
                this.txStudentCommentDao.update((Object)po, new String[]{"downStatus", "soundId"});
            }
        }
        if (po.getSoundId() > 0L && po.getDownStatus().intValue() == DownLoadStatus.FINISH.getCode() && (storage = storageMap.get(po.getSoundId().intValue())) != null) {
            dto.setSeconds(po.getSeconds());
            dto.setSoundId(po.getSoundId());
            dto.setSoundUrl(StorageUtil.constructUrl((String)storage.getFid(), (String)storage.getSn(), (Integer)storage.getMimeType()));
        }
        dto.setDownLoadStatus(po.getDownStatus());
        dto.setCommentType(po.getCommentType());
        dto.setGrowthComments(po.getGrowthComments());
        dto.setNotifyParents(po.getNotifyParents());
        dto.setCreatorCascadeId(po.getCreatorCascadeId());
        dto.setCreatorTeacherId(po.getCreatorTeacherId());
    }

    @Override
    public boolean syncAddOrgStudent() {
        TxMsgSyncTimestamp syncInfo = this.txMsgSyncTimestampDao.getSyncTimestampByType(MsgSyncType.ADD_STU.getSyncType());
        if (syncInfo == null) {
            syncInfo = new TxMsgSyncTimestamp();
            syncInfo.setSyncType(Integer.valueOf(MsgSyncType.ADD_STU.getSyncType()));
            syncInfo.setSyncTime(new Date());
            this.txMsgSyncTimestampDao.save((Object)syncInfo, Boolean.valueOf(false), new String[0]);
        }
        PageDto page = new PageDto();
        page.setPageNum(Integer.valueOf(1));
        page.setPageSize(Integer.valueOf(MAX_SYNC_NUM));
        log.info("syncAddOrgStudent,syncTime={}", (Object)syncInfo.getSyncTime());
        List students = this.orgStudentsDao.getStudents(syncInfo.getSyncTime(), Integer.valueOf(DeleteStatus.NORMAL.getValue()), page, new String[]{"orgId", "userId", "createTime", "name", "nickName"});
        if (CollectionUtils.isNotEmpty((Collection)students)) {
            if (((OrgStudent)students.get(0)).getCreateTime().after(new Date())) {
                return false;
            }
            syncInfo.setSyncTime(((OrgStudent)students.get(0)).getCreateTime());
            ArrayList comments = Lists.newArrayList();
            for (OrgStudent orgStudents : students) {
                this.txStudentCommentAPIService.saveByAddStudent(orgStudents);
            }
            this.txMsgSyncTimestampDao.update((Object)syncInfo, new String[]{"syncTime"});
        }
        return true;
    }

    @Override
    public boolean syncCoursePurchase() {
        TxMsgSyncTimestamp syncInfo = this.txMsgSyncTimestampDao.getSyncTimestampByType(MsgSyncType.COURSE_PURCHASE.getSyncType());
        if (syncInfo == null) {
            syncInfo = new TxMsgSyncTimestamp();
            syncInfo.setSyncType(Integer.valueOf(MsgSyncType.COURSE_PURCHASE.getSyncType()));
            syncInfo.setSyncTime(new Date());
            this.txMsgSyncTimestampDao.save((Object)syncInfo, Boolean.valueOf(false), new String[0]);
        }
        PageDto page = new PageDto();
        page.setPageNum(Integer.valueOf(1));
        page.setPageSize(Integer.valueOf(MAX_SYNC_NUM));
        ArrayList classType = Lists.newArrayList();
        classType.add(CourseType.ORG_COURSE.getCode());
        log.info("syncCoursePurchase,syncTime={}", (Object)syncInfo.getSyncTime());
        List purchases = this.coursePurchaseDao.getCoursePurchaseList(syncInfo.getSyncTime(), Integer.valueOf(PayStatus.SUCESS.getCode()), (List)classType, page, new String[0]);
        if (CollectionUtils.isNotEmpty((Collection)purchases)) {
            if (((CoursePurchase)purchases.get(0)).getUpdateTime().after(new Date())) {
                return false;
            }
            syncInfo.setSyncTime(((CoursePurchase)purchases.get(0)).getUpdateTime());
            HashSet courseIds = Sets.newHashSet();
            for (CoursePurchase coursePurchase : purchases) {
                courseIds.add(coursePurchase.getCourseId());
            }
            Map nameMap = this.orgCourseDao.getCourseNameMap((Collection)courseIds);
            ArrayList comments = Lists.newArrayList();
            for (CoursePurchase coursePurchase : purchases) {
                this.txStudentCommentAPIService.saveByCoursePurchase(coursePurchase.getOrgId(), coursePurchase.getUserId(), coursePurchase.getUpdateTime(), (String)nameMap.get(coursePurchase.getCourseId()), coursePurchase.getPayMoney());
            }
            this.txMsgSyncTimestampDao.update((Object)syncInfo, new String[]{"syncTime"});
        }
        return true;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void modComment(CommentInfoDto dto, Long orgId) {
        Date now = new Date();
        if (dto.getCommentId() == null) {
            log.warn("mod comment error: commentId is null!");
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR);
        }
        TxStudentComment comment = (TxStudentComment)this.txStudentCommentDao.getById((Serializable)dto.getCommentId(), new String[0]);
        if (comment == null || comment.getOrgId().longValue() != orgId.longValue()) {
            throw new BussinessException((UniverseErrorCode)StudentErrorCode.COMMENT_NOT_EXIST);
        }
        if (comment.getIsSystem().intValue() == AddType.SYSTEM.getCode()) {
            throw new BussinessException((UniverseErrorCode)StudentErrorCode.SYSTEM_COMMENT);
        }
        comment.setSeconds(dto.getSeconds());
        comment.setSoundId(dto.getSoundId());
        comment.setStorageIds(dto.getStorageIds());
        comment.setContent(dto.getContent());
        comment.setCommentType(dto.getCommentType());
        comment.setGrowthComments(dto.getGrowthComments());
        comment.setNotifyParents(dto.getNotifyParents());
        comment.setCreatorCascadeId(dto.getCreatorCascadeId());
        comment.setCreatorTeacherId(dto.getCreatorTeacherId());
        comment.setUpdateTime(now);
        this.txStudentCommentDao.update((Object)comment, new String[0]);
        if (comment.getConsultUserId() != null && comment.getConsultUserId() > 0L) {
            TxConsultUser user = (TxConsultUser)this.txConsultUserDao.getById((Serializable)comment.getConsultUserId(), new String[0]);
            user.setLastRemindTime(now);
            user.setUpdateTime(now);
            this.txConsultUserDao.update((Object)user, new String[0]);
        }
        if (dto.getNotifyColleague() != null && !dto.getNotifyColleague().equals("null")) {
            try {
                Long consultUserId = comment.getConsultUserId();
                Long userId = comment.getUserId();
                Integer userType = StudentType.ORG_STUDENTS.getCode();
                if (consultUserId != null && consultUserId > 0L) {
                    userType = StudentType.CONSULT_USER.getCode();
                    userId = consultUserId;
                }
                log.info("comment dto={},userId={},userType={}", new Object[]{comment, userId, userType});
                String preInfoStr = this.generateSendNotifyInfos(userId, orgId, userType);
                this.sendNotifyToColleague(preInfoStr, dto, orgId);
            }
            catch (Exception e) {
                log.error("modComment NotifyColleague error", (Throwable)e);
            }
        }
    }

    @Override
    public void modComment(TxStudentComment comment) {
        this.txStudentCommentDao.update((Object)comment, new String[0]);
    }

    @Override
    public TxStudentComment getTxStudentComment(long id) {
        return (TxStudentComment)this.txStudentCommentDao.getById((Serializable)Long.valueOf(id), new String[0]);
    }

    @Override
    public boolean syncSignupPurchase() {
        TxMsgSyncTimestamp syncInfo = this.txMsgSyncTimestampDao.getSyncTimestampByType(MsgSyncType.SIGNUP_PURCHASE.getSyncType());
        if (syncInfo == null) {
            syncInfo = new TxMsgSyncTimestamp();
            syncInfo.setSyncType(Integer.valueOf(MsgSyncType.SIGNUP_PURCHASE.getSyncType()));
            syncInfo.setSyncTime(new Date());
            this.txMsgSyncTimestampDao.save((Object)syncInfo, Boolean.valueOf(false), new String[0]);
        }
        PageDto page = new PageDto();
        page.setPageNum(Integer.valueOf(1));
        page.setPageSize(Integer.valueOf(MAX_SYNC_NUM));
        log.info("syncSignupPurchase,syncTime={}", (Object)syncInfo.getSyncTime());
        List sinupInfos = this.orgSignupInfoDao.getPurchases(syncInfo.getSyncTime(), Integer.valueOf(PayStatus.SUCESS.getCode()), page, new String[0]);
        if (CollectionUtils.isNotEmpty((Collection)sinupInfos)) {
            if (((OrgSignupInfo)sinupInfos.get(0)).getUpdateTime().after(new Date())) {
                return false;
            }
            syncInfo.setSyncTime(((OrgSignupInfo)sinupInfos.get(0)).getUpdateTime());
            HashSet signupPurchaseIds = Sets.newHashSet();
            for (OrgSignupInfo orgSignupInfo : sinupInfos) {
                signupPurchaseIds.add(orgSignupInfo.getSignupPurchaseId());
            }
            List coursePurchases = this.orgSignupCourseDao.loadByPurchaseIds((Collection)signupPurchaseIds, new String[]{"signupPurchaseId", "orgCourseId"});
            HashSet courseIds = Sets.newHashSet();
            HashMap coursePurhaseMap = Maps.newHashMap();
            for (OrgSignupCourse orgSignupCourse : coursePurchases) {
                if (!coursePurhaseMap.containsKey(orgSignupCourse.getSignupPurchaseId())) {
                    coursePurhaseMap.put(orgSignupCourse.getSignupPurchaseId(), Lists.newArrayList());
                }
                ((List)coursePurhaseMap.get(orgSignupCourse.getSignupPurchaseId())).add(orgSignupCourse);
                courseIds.add(orgSignupCourse.getOrgCourseId());
            }
            List courseList = this.orgCourseDao.getByIds((Collection)courseIds, new String[]{"id", "name", "chargeType", "chargeUnit"});
            Map courseMap = GenericsUtils.toFieldMap((Collection)courseList, (String[])new String[]{"id"});
            for (OrgSignupInfo orgSignupInfo : sinupInfos) {
                List purchases = (List)coursePurhaseMap.get(orgSignupInfo.getSignupPurchaseId());
                HashMap orgSignupCourseMap = Maps.newHashMap();
                HashMap orgCourseMap = Maps.newHashMap();
                if (CollectionUtils.isNotEmpty((Collection)purchases)) {
                    for (OrgSignupCourse orgSignupCourse : purchases) {
                        orgCourseMap.put(orgSignupCourse.getOrgCourseId(), courseMap.get(orgSignupCourse.getOrgCourseId()));
                        orgSignupCourseMap.put(orgSignupCourse.getOrgCourseId(), orgSignupCourse);
                    }
                }
                this.txStudentCommentAPIService.saveBySignUpPurchase(orgSignupInfo, (Map)orgSignupCourseMap, (Map)orgCourseMap);
            }
            this.txMsgSyncTimestampDao.update((Object)syncInfo, new String[]{"syncTime"});
        }
        return true;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void mergeCommentRecord(TxConsultUser sourceConsultUser, TxConsultUser destConsultUser, Long orgId) {
        this.txStudentCommentAPIService.saveByStudentMerge(sourceConsultUser, destConsultUser, orgId);
    }

    void doAfter(TxConsultUser sourceConsultUser, TxConsultUser destConsultUser, Long orgId) {
        TxStudentComment addComment = new TxStudentComment();
        addComment.setCallStatus(Integer.valueOf(0));
        addComment.setConsultUserId(destConsultUser.getId());
        addComment.setUserId(destConsultUser.getUserId());
        addComment.setContent(this.getCommentRecord(sourceConsultUser, destConsultUser));
        addComment.setOrgId(orgId);
        addComment.setCreateTime(new Date());
        addComment.setIsSystem(Integer.valueOf(AddType.SYSTEM.getCode()));
        log.info("orgId:{}, addComment:{}", (Object)orgId, (Object)addComment);
        this.txStudentCommentDao.save((Object)addComment, new String[0]);
    }

    private String getCommentRecord(TxConsultUser sourceConsultUser, TxConsultUser destConsultUser) {
        String sourceName = sourceConsultUser.getName();
        String sourceNickName = sourceConsultUser.getNickName();
        String destName = destConsultUser.getName();
        String destNickName = destConsultUser.getNickName();
        String sourceMobile = sourceConsultUser.getMobile();
        String destMobile = destConsultUser.getMobile();
        StringBuffer sb = new StringBuffer();
        sb.append("\u60a8\u5c06\u5b66\u751f\u3010" + this.getConsulterName(sourceName, sourceNickName) + "\u3011");
        if (StringUtils.isNotBlank((CharSequence)sourceMobile)) {
            sb.append("\u3010" + sourceMobile + "\u3011");
        }
        sb.append("\u548c\u5b66\u751f\u3010" + this.getConsulterName(destName, destNickName) + "\u3011");
        if (StringUtils.isNotBlank((CharSequence)destMobile)) {
            sb.append("\u3010" + destMobile + "\u3011");
        }
        sb.append("\u5408\u5e76\u4e86");
        return sb.toString();
    }

    private String getConsulterName(String source, String dest) {
        return StringUtils.isNotBlank((CharSequence)source) ? source : (StringUtils.isNotBlank((CharSequence)dest) ? dest : "\u533f\u540d\u7528\u6237");
    }

    @Override
    public List<CommentInfoDto> listCommentsByStudentId(Long orgId, Long studentId, Integer studentType, Integer notifyParents) {
        OrgStudent orgStudent = (OrgStudent)this.orgStudentsDao.getById((Serializable)studentId, new String[0]);
        List comments = this.txStudentCommentDao.getCommentList(orgStudent.getUserId(), orgId, Integer.valueOf(StudentType.ORG_STUDENTS.getCode()), null, notifyParents, true, null, new String[0]);
        ArrayList commentsDto = Lists.newArrayList();
        HashSet callIds = Sets.newHashSet();
        HashSet call400Ids = Sets.newHashSet();
        for (TxStudentComment comment : comments) {
            if (comment.getDownStatus().intValue() != DownLoadStatus.UNFINISH.getCode()) continue;
            if (comment.getIsMobile().intValue() == MobileStatus.IS_CALL.getCode()) {
                callIds.add(comment.getSoundId());
                continue;
            }
            if (comment.getIsMobile().intValue() != MobileStatus.IS_400_CALL.getCode()) continue;
            call400Ids.add(comment.getSoundId());
        }
        Map<Long, Long> callMap = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty((Collection)callIds)) {
            List callInfos = this.callServiceInfoDao.getByIds((Collection)callIds, new String[0]);
            callMap = CollectorUtil.collectMap((Collection)callInfos, (Function)new Function<CallServiceInfo, Long>(){

                public Long apply(CallServiceInfo arg0) {
                    return arg0.getId();
                }
            }, (Function)new Function<CallServiceInfo, Long>(){

                public Long apply(CallServiceInfo arg0) {
                    return arg0.getStorageId();
                }
            });
        }
        Map<Long, Long> call400Map = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty((Collection)call400Ids)) {
            List call400Infos = this.orgPushCallInfoDao.getByIds((Collection)call400Ids, new String[0]);
            call400Map = CollectorUtil.collectMap((Collection)call400Infos, (Function)new Function<OrgPushCallInfo, Long>(){

                public Long apply(OrgPushCallInfo arg0) {
                    return arg0.getId();
                }
            }, (Function)new Function<OrgPushCallInfo, Long>(){

                public Long apply(OrgPushCallInfo arg0) {
                    return arg0.getStorageId();
                }
            });
        }
        HashSet storageIds = Sets.newHashSet();
        for (TxStudentComment comment : comments) {
            if (StringUtils.isNotEmpty((CharSequence)comment.getStorageIds())) {
                String[] storageIdsStr = comment.getStorageIds().split(",");
                for (String storageId : storageIdsStr) {
                    storageIds.add(Integer.parseInt(storageId));
                }
            }
            if (comment.getDownStatus().intValue() == DownLoadStatus.UNFINISH.getCode()) {
                Long storageId = null;
                if (comment.getIsMobile().intValue() == MobileStatus.IS_CALL.getCode()) {
                    storageId = (Long)callMap.get(comment.getSoundId());
                } else if (comment.getIsMobile().intValue() == MobileStatus.IS_400_CALL.getCode()) {
                    storageId = (Long)call400Map.get(comment.getSoundId());
                }
                if (storageId == null || storageId <= 0L) continue;
                storageIds.add(storageId.intValue());
                continue;
            }
            if (comment.getDownStatus().intValue() != DownLoadStatus.FINISH.getCode() || comment.getSoundId() == null || comment.getSoundId() <= 0L) continue;
            storageIds.add(comment.getSoundId().intValue());
        }
        List storages = this.orgStorageDao.getByIds((Collection)storageIds, new String[0]);
        Map storageMap = CollectorUtil.collectMap((Collection)storages, (Function)new Function<OrgStorage, Integer>(){

            public Integer apply(OrgStorage arg0) {
                return arg0.getId();
            }
        });
        HashSet<Integer> cascadeIds = new HashSet<Integer>();
        for (TxStudentComment comment : comments) {
            cascadeIds.add(comment.getCreatorCascadeId());
        }
        Map cascadeIdVSNameMap = this.txCascadeCredentialDao.getTxCascadCredentialListByCascdeIds(cascadeIds);
        OrgInfo orgInfo = this.orgInfoDao.getOrgInfo(Integer.valueOf(orgId.intValue()), new String[0]);
        cascadeIdVSNameMap.put(0L, orgInfo.getShowName());
        for (TxStudentComment comment : comments) {
            CommentInfoDto commentDto = new CommentInfoDto();
            this.commentPo2Dto(commentDto, comment, callMap, call400Map, storageMap);
            CreatorDto creatorDto = new CreatorDto();
            creatorDto.setCascadeId(comment.getCreatorCascadeId());
            if (comment.getCreatorCascadeId().intValue() != Flag.NULL.getInt()) {
                if (comment.getCreatorCascadeId() == 0) {
                    creatorDto.setName(orgInfo.getContacts());
                } else {
                    creatorDto.setName((String)cascadeIdVSNameMap.get((int)comment.getCreatorCascadeId()));
                }
            } else if (comment.getIsSystem().intValue() == Flag.TRUE.getInt()) {
                creatorDto.setName("\u7cfb\u7edf");
            } else {
                creatorDto.setName("\u5386\u53f2\u7528\u6237");
            }
            commentDto.setCreator(creatorDto);
            if (commentDto.getTemplateId() > 0L) {
                commentDto.setCustomRecord(this.txCustomRecordService.getRecord(orgId, commentDto.getTemplateId(), commentDto.getCommentId()));
            }
            commentsDto.add(commentDto);
        }
        return commentsDto;
    }

    @Override
    @Transactional(readOnly=true)
    public CommentInfoDto getCommentByCommentId(Long orgId, Long commentId) {
        TxStudentComment comment = (TxStudentComment)this.txStudentCommentDao.getById((Serializable)commentId, new String[0]);
        BussinessPreconditions.checkArgument((null != comment ? 1 : 0) != 0, (Object)"can not find comment!");
        HashSet callIds = Sets.newHashSet();
        HashSet call400Ids = Sets.newHashSet();
        if (comment.getDownStatus().intValue() == DownLoadStatus.UNFINISH.getCode()) {
            if (comment.getIsMobile().intValue() == MobileStatus.IS_CALL.getCode()) {
                callIds.add(comment.getSoundId());
            } else if (comment.getIsMobile().intValue() == MobileStatus.IS_400_CALL.getCode()) {
                call400Ids.add(comment.getSoundId());
            }
        }
        Map<Long, Long> callMap = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty((Collection)callIds)) {
            List callInfos = this.callServiceInfoDao.getByIds((Collection)callIds, new String[0]);
            callMap = CollectorUtil.collectMap((Collection)callInfos, (Function)new Function<CallServiceInfo, Long>(){

                public Long apply(CallServiceInfo arg0) {
                    return arg0.getId();
                }
            }, (Function)new Function<CallServiceInfo, Long>(){

                public Long apply(CallServiceInfo arg0) {
                    return arg0.getStorageId();
                }
            });
        }
        Map<Long, Long> call400Map = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty((Collection)call400Ids)) {
            List call400Infos = this.orgPushCallInfoDao.getByIds((Collection)call400Ids, new String[0]);
            call400Map = CollectorUtil.collectMap((Collection)call400Infos, (Function)new Function<OrgPushCallInfo, Long>(){

                public Long apply(OrgPushCallInfo arg0) {
                    return arg0.getId();
                }
            }, (Function)new Function<OrgPushCallInfo, Long>(){

                public Long apply(OrgPushCallInfo arg0) {
                    return arg0.getStorageId();
                }
            });
        }
        HashSet storageIds = Sets.newHashSet();
        if (StringUtils.isNotEmpty((CharSequence)comment.getStorageIds())) {
            String[] storageIdsStr;
            for (String storageId : storageIdsStr = comment.getStorageIds().split(",")) {
                storageIds.add(Integer.parseInt(storageId));
            }
        }
        if (comment.getDownStatus().intValue() == DownLoadStatus.UNFINISH.getCode()) {
            Long storageId = null;
            if (comment.getIsMobile().intValue() == MobileStatus.IS_CALL.getCode()) {
                storageId = (Long)callMap.get(comment.getSoundId());
            } else if (comment.getIsMobile().intValue() == MobileStatus.IS_400_CALL.getCode()) {
                storageId = (Long)call400Map.get(comment.getSoundId());
            }
            if (storageId != null && storageId > 0L) {
                storageIds.add(storageId.intValue());
            }
        } else if (comment.getDownStatus().intValue() == DownLoadStatus.FINISH.getCode() && comment.getSoundId() != null && comment.getSoundId() > 0L) {
            storageIds.add(comment.getSoundId().intValue());
        }
        Map storageMap = CollectorUtil.collectMap((Collection)this.orgStorageDao.getByIds((Collection)storageIds, new String[0]), arg0 -> arg0.getId());
        HashSet<Integer> cascadeIds = new HashSet<Integer>();
        cascadeIds.add(comment.getCreatorCascadeId());
        Map cascadeIdVSNameMap = this.txCascadeCredentialDao.getTxCascadCredentialListByCascdeIds(cascadeIds);
        OrgInfo orgInfo = this.orgInfoDao.getOrgInfo(Integer.valueOf(orgId.intValue()), new String[0]);
        cascadeIdVSNameMap.put(0L, orgInfo.getShowName());
        HashSet teacherIds = Sets.newHashSet();
        if (comment.getCreatorTeacherId() > 0L) {
            teacherIds.add(comment.getCreatorTeacherId());
        }
        Map teacherIdNameMap = this.teacherDao.getTeacherRealNameMap((Collection)teacherIds);
        CommentInfoDto commentDto = new CommentInfoDto();
        this.commentPo2Dto(commentDto, comment, callMap, call400Map, storageMap);
        CreatorDto creatorDto = new CreatorDto();
        creatorDto.setCascadeId(comment.getCreatorCascadeId());
        creatorDto.setTeacherId(comment.getCreatorTeacherId());
        if (comment.getCreatorCascadeId().intValue() != Flag.NULL.getInt()) {
            if (comment.getCreatorCascadeId() == 0) {
                creatorDto.setName(orgInfo.getContacts());
            } else {
                creatorDto.setName((String)cascadeIdVSNameMap.get((int)comment.getCreatorCascadeId()));
            }
        } else if (comment.getCreatorTeacherId() > 0L) {
            creatorDto.setName((String)teacherIdNameMap.get(comment.getCreatorTeacherId()));
        } else if (comment.getIsSystem().intValue() == Flag.TRUE.getInt()) {
            creatorDto.setName("\u7cfb\u7edf");
        } else {
            creatorDto.setName("\u5386\u53f2\u7528\u6237");
        }
        commentDto.setCreator(creatorDto);
        if (commentDto.getTemplateId() > 0L) {
            commentDto.setCustomRecord(this.txCustomRecordService.getRecord(orgId, commentDto.getTemplateId(), commentDto.getCommentId()));
        }
        if (commentDto.getUserId() > 0L) {
            OrgStudent orgStudent = this.orgStudentDao.getStudentByUserId(orgId, commentDto.getUserId(), new String[]{"id", "userId", "avatar", "weixin", "nickName", "mobile"});
            Map studentAvatarMap = this.orgStudentApiService.batchGetStudentAvatarUrl((Collection)Lists.newArrayList((Object[])new OrgStudent[]{orgStudent}));
            HashMap studentInfo = Maps.newHashMap();
            studentInfo.put("studentName", orgStudent.getNotEmptyName());
            studentInfo.put("studentAvatar", studentAvatarMap.get(orgStudent.getId()));
            studentInfo.put("mobile", orgStudent.getMobile());
            commentDto.setStudentInfo(studentInfo);
        }
        return commentDto;
    }

    @Override
    @Transactional(readOnly=true)
    public List<TxCustomRecordHistoryDto> listCustomRecordHistory(Long orgId, Long templateId, Long teacherId, String key, PageDto pageDto) {
        List userIds = null;
        if (StringUtils.isNotBlank((CharSequence)key) && CollectionUtils.isEmpty((Collection)(userIds = this.orgStudentDao.listUserIdByNameOrMobile(orgId, key)))) {
            return Collections.EMPTY_LIST;
        }
        List comments = this.txStudentCommentDao.getTemplateCommentHistory(orgId, templateId, teacherId, userIds, pageDto);
        List students = this.orgStudentDao.getStudentByUserIdsAndDelStatus(orgId, (Collection)comments.stream().map(txStudentComment -> txStudentComment.getUserId()).collect(Collectors.toList()), null, new String[]{"id", "userId", "avatar", "weixin", "nickName", "mobile"});
        Map studentAvatarMap = this.orgStudentApiService.batchGetStudentAvatarUrl((Collection)students);
        Map studentMap = CollectorUtil.collectMap((Collection)students, input -> input.getUserId());
        ArrayList result = Lists.newArrayList();
        for (TxStudentComment comment : comments) {
            TxCustomRecordHistoryDto historyDto = new TxCustomRecordHistoryDto();
            historyDto.setCommentId(comment.getId());
            historyDto.setTemplateId(comment.getTemplateId());
            historyDto.setUserId(comment.getUserId());
            historyDto.setConsultUserId(comment.getConsultUserId());
            historyDto.setCreateTime(comment.getCreateTime());
            OrgStudent student = (OrgStudent)studentMap.get(comment.getUserId());
            historyDto.setStudentName(student.getNotEmptyName());
            historyDto.setStudentAvatar((String)studentAvatarMap.get(student.getId()));
            result.add(historyDto);
        }
        return result;
    }

    @Override
    public void deleteComment(Long commentId) {
        TxStudentComment comment = (TxStudentComment)this.txStudentCommentDao.getById((Serializable)commentId, new String[0]);
        BussinessPreconditions.checkArgument((null != comment ? 1 : 0) != 0, (Object)"\u627e\u4e0d\u5230\u8bb0\u5f55");
        comment.setIsdel(Integer.valueOf(DeleteStatus.DELETED.getValue()));
        comment.setUpdateTime(new Date());
        this.txStudentCommentDao.update((Object)comment, new String[]{"isdel", "updateTime"});
    }

    @Override
    public CommentInfoDto getEmptyComment(Long orgId, Long templateId) {
        CommentInfoDto commentInfoDto = new CommentInfoDto();
        commentInfoDto.setCustomRecord(this.txCustomRecordService.getEmptyRecord(orgId, templateId));
        commentInfoDto.setTemplateId(commentInfoDto.getCustomRecord().getTemplateId());
        return commentInfoDto;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveNewCustomRecordComment(Long orgId, Long teacherId, CommentInfoDto commentInfoDto) {
        BussinessPreconditions.checkArgument((null != commentInfoDto && null != orgId ? 1 : 0) != 0, (Object)"param null!");
        BussinessPreconditions.checkArgument((null != commentInfoDto.getTemplateId() ? 1 : 0) != 0, (Object)"templateId can not be null");
        BussinessPreconditions.checkArgument((null != commentInfoDto.getUserId() ? 1 : 0) != 0, (Object)"userId can not be null");
        TxStudentComment comment = new TxStudentComment();
        comment.setConsultUserId(commentInfoDto.getConsultUserId());
        comment.setUserId(commentInfoDto.getUserId());
        comment.setOrgId(orgId);
        comment.setTemplateId(commentInfoDto.getTemplateId());
        comment.setStorageIds(commentInfoDto.getStorageIds());
        comment.setContent(commentInfoDto.getContent());
        comment.setCreateTime(new Date());
        comment.setUpdateTime(comment.getCreateTime());
        comment.setGrowthComments(Integer.valueOf(1));
        comment.setNotifyParents(Integer.valueOf(1));
        comment.setCreatorTeacherId(teacherId);
        comment.setType(Integer.valueOf(0));
        comment.setFollowType(Integer.valueOf(0));
        comment.setIsdel(Integer.valueOf(0));
        this.txStudentCommentDao.save((Object)comment, Boolean.valueOf(false), new String[0]);
        this.txCustomRecordService.saveNewRecord(orgId, comment.getId(), commentInfoDto.getCustomRecord());
    }
}

