package com.baijia.tianxiao.sal.student.enums;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;

import com.baijia.tianxiao.constant.Relatives;
import com.baijia.tianxiao.dal.roster.po.CustomField;
import com.baijia.tianxiao.sal.student.dto.TagInfoDto;
import com.baijia.tianxiao.sal.student.dto.customFields.FieldOption;
import com.baijia.tianxiao.sal.student.dto.customFields.ValidatorExpression;
import com.baijia.tianxiao.sal.student.dto.customFields.fieldTypes.DateFieldType;
import com.baijia.tianxiao.sal.student.dto.customFields.fieldTypes.DateTimeFieldType;
import com.baijia.tianxiao.sal.student.dto.customFields.fieldTypes.PictureFieldType;
import com.baijia.tianxiao.sal.student.dto.customFields.fieldTypes.PositionFieldType;
import com.baijia.tianxiao.sal.student.dto.customFields.fieldTypes.SingleChoiceFieldType;
import com.baijia.tianxiao.sal.student.dto.customFields.fieldTypes.TagsCustomFieldType;
import com.baijia.tianxiao.sal.student.dto.customFields.fieldTypes.TagsTypeDto;
import com.baijia.tianxiao.sal.student.dto.customFields.fieldTypes.TextCustomFieldType;
import com.baijia.tianxiao.sal.student.util.JsonUtil;
import com.baijia.tianxiao.util.GenericsUtils;
import com.baijia.tianxiao.util.ListUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;

/**
 * little Boy Tell me, where do you dream? Rezar Jul 24, 2016
 */
public enum SystemFields {

    // 因为PM要求新添的字段要排到最上面，所以这里需要对系统字段进行倒序排序 从头像依次为 15， 14，。。。。。
    
    STUDENT_AVATAR(1, "avatarUrl,storageId", "头像", 8, CustomFieldSections.BASE_INFO.getId(),
        RequireStatus.NOT_REQUIRE.getStatus(), 15,0) {
        public PictureFieldType instance(Map<String, Object> valueMap) {
            PictureFieldType pft = new PictureFieldType();
            if (valueMap.get("storageId") != null) {
                pft.setStorageId(Long.parseLong(valueMap.get("storageId").toString()));
            }

            if (valueMap.get("avatarUrl") != null) {
                pft.setUrl(String.valueOf(valueMap.get("avatarUrl")));
            }
            return pft;
        }

        @Override
        public Map<String, Object> toObjKeyValue(Object obj) {
            PictureFieldType type = (PictureFieldType) obj;
            Map<String, Object> valueMap = Maps.newHashMap();
            if (type != null) {
                valueMap.put("storageId", type.getStorageId());
                valueMap.put("avatarUrl", type.getUrl());
            }
            return valueMap;
        }

    },
    STUDENT_NAME(2, "name", "学员姓名", 1, CustomFieldSections.BASE_INFO.getId(), RequireStatus.IS_REQUIRE.getStatus(),
        14,0) {
        public TextCustomFieldType instance(Map<String, Object> valueMap) {
            TextCustomFieldType tcft = new TextCustomFieldType();
            if (valueMap.get("name") != null) {
                tcft.setContent(String.valueOf(valueMap.get("name")));
            }
            return tcft;
        }

        @Override
        public Map<String, Object> toObjKeyValue(Object obj) {
            TextCustomFieldType type = (TextCustomFieldType) obj;
            Map<String, Object> valueMap = Maps.newHashMap();
            if (type != null) {
                valueMap.put("name", type.getContent());
            }
            return valueMap;
        }
    },
    MOBILE(3, "mobile", "学员手机", 1, CustomFieldSections.BASE_INFO.getId(), RequireStatus.IS_REQUIRE.getStatus(), 13,0) {
        public TextCustomFieldType instance(Map<String, Object> valueMap) {
            TextCustomFieldType type = new TextCustomFieldType();
            if (valueMap.get("mobile") != null) {
                type.setContent(String.valueOf(valueMap.get("mobile")));
            } else {
                type.setContent("");
            }
            return type;
        }

        @Override
        public Map<String, Object> toObjKeyValue(Object obj) {
            TextCustomFieldType type = (TextCustomFieldType) obj;
            Map<String, Object> valueMap = Maps.newHashMap();
            if (type != null) {
                valueMap.put("mobile", type.getContent());
            } else {
                valueMap.put("mobile", "");
            }
            return valueMap;
        }
    },
    SEX(4, "sex", "性别", 2, CustomFieldSections.BASE_INFO.getId(), RequireStatus.NOT_REQUIRE.getStatus(), 12,0) {
        public SingleChoiceFieldType instance(Map<String, Object> valueMap) {
            SingleChoiceFieldType ret = null;
            Integer sexValue = (Integer) valueMap.get("sex");
            if (sexValue != null && sexValue >= 0) {
                SexEnum sexEnum = SexEnum.getSexWithId(sexValue);
                if (sexEnum != null) {
                    ret = new SingleChoiceFieldType();
                    ret.setId(sexValue);
                    ret.setValue(sexEnum.label);
                }
            }
            return ret;
        }

        @Override
        public Map<String, Object> toObjKeyValue(Object obj) {
            SingleChoiceFieldType type = (SingleChoiceFieldType) obj;
            Map<String, Object> valueMap = Maps.newHashMap();
            if (type != null) {
                valueMap.put("sex", type.getId());
            } else {
                valueMap.put("sex", -1);
            }
            return valueMap;
        }

        public List<FieldOption> getFieldOptionForChoiceField() {
            List<FieldOption> fields = Lists.newArrayList();
            for (SexEnum sexEnum : SexEnum.values()) {
                Integer id = sexEnum.id;
                String label = sexEnum.label;
                FieldOption.buildDto(id.longValue(), label);
            }
            return fields;
        }

    },
    TAGS(5, "tagsResp", "标签", 10, CustomFieldSections.BASE_INFO.getId(), RequireStatus.NOT_REQUIRE.getStatus(), 11,0) {
        @SuppressWarnings("unchecked")
        public TagsTypeDto instance(Map<String, Object> valueMap) {
            List<TagInfoDto> list = (List<TagInfoDto>) valueMap.get("tagsResp");
            TagsTypeDto dto = new TagsTypeDto();
            if (list != null) {
                List<String> listStr = ListUtil.toKeyList(list, "content", TagInfoDto.class);
                dto.setTags(listStr);
            }
            return dto;
        }

        @SuppressWarnings("unchecked")
        @Override
        public Map<String, Object> toObjKeyValue(Object obj) {
            TagsCustomFieldType type = (TagsCustomFieldType) obj;
            List<TagInfoDto> list = null;
            if (type != null) {
                list = new ArrayList<>();
                for (String str : type.getTags()) {
                    TagInfoDto dto = new TagInfoDto();
                    dto.setContent(str);
                    list.add(dto);
                }
            }
            Map<String, Object> valueMap = Maps.newHashMap();
            valueMap.put("tagsResp", list);
            return valueMap;
        }
    },
    NEXT_REMAIND_TIME(6, "nextRemindTime", "下次跟进时间", 5, CustomFieldSections.BASE_INFO.getId(),
        RequireStatus.NOT_REQUIRE.getStatus(), 10,1) {
        public DateTimeFieldType instance(Map<String, Object> valueMap) {
            DateTimeFieldType dtft = new DateTimeFieldType();
            if (valueMap.get("nextRemindTime") != null) {
                Object object = valueMap.get("nextRemindTime");
                Long nextRemindTime = Long.parseLong(object.toString());
                // 去除时间戳是0的情况
                if (nextRemindTime > 0l) {
                    dtft.setContent(nextRemindTime);
                }
            }
            return dtft;
        }

        @Override
        public Map<String, Object> toObjKeyValue(Object obj) {
            DateTimeFieldType type = (DateTimeFieldType) obj;
            Map<String, Object> valueMap = null;
            if (type.getContent() > 0l) {
                valueMap = Maps.newHashMap();
                valueMap.put("nextRemindTime", type.getContent());
            }
            return valueMap;

        }
    },
    RELATIONSHIP(7, "relationship", "亲属关系", 2, CustomFieldSections.OTHER_INFO.getId(),
        RequireStatus.NOT_REQUIRE.getStatus(), 9,0) {
        public SingleChoiceFieldType instance(Map<String, Object> valueMap) {
            SingleChoiceFieldType type = null;
            Integer id = (Integer) valueMap.get("relationship");
            if (id != null && id > 0) {
                type = new SingleChoiceFieldType();
                String label = Relatives.getLabel(id);
                type.setId(id);
                type.setValue(label);
            }
            return type;

        }

        @Override
        public Map<String, Object> toObjKeyValue(Object obj) {
            SingleChoiceFieldType type = (SingleChoiceFieldType) obj;
            Map<String, Object> valueMap = Maps.newHashMap();
            valueMap.put("relationship", type.getId());
            return valueMap;
        }

        public List<FieldOption> getFieldOptionForChoiceField() {
            List<FieldOption> fields = Lists.newArrayList();
            for (Relatives enumObj : Relatives.values()) {
                Integer id = enumObj.getValue();
                String label = enumObj.getLabel();
                FieldOption.buildDto(id.longValue(), label);
            }
            return fields;
        }
    },

    PARENTNAME(8, "parentName", "家长姓名", 1, CustomFieldSections.OTHER_INFO.getId(),
        RequireStatus.NOT_REQUIRE.getStatus(), 8,0) {
        public TextCustomFieldType instance(Map<String, Object> valueMap) {
            TextCustomFieldType type = new TextCustomFieldType();
            if (valueMap.get("parentName") != null) {
                type.setContent(String.valueOf(valueMap.get("parentName")));
            } else {
                type.setContent("");
            }
            return type;
        }

        @Override
        public Map<String, Object> toObjKeyValue(Object obj) {
            TextCustomFieldType type = (TextCustomFieldType) obj;
            Map<String, Object> valueMap = Maps.newHashMap();
            valueMap.put("parentName", type.getContent());
            return valueMap;
        }
    },
    PARENTMOBILE(9, "parentMobile", "家长手机", 1, CustomFieldSections.OTHER_INFO.getId(),
        RequireStatus.NOT_REQUIRE.getStatus(), 7,0) {
        public TextCustomFieldType instance(Map<String, Object> valueMap) {
            TextCustomFieldType type = new TextCustomFieldType();
            if (valueMap.get("parentMobile") != null) {
                type.setContent(String.valueOf(valueMap.get("parentMobile")));
            } else {
                type.setContent("");
            }
            return type;
        }

        @Override
        public Map<String, Object> toObjKeyValue(Object obj) {
            TextCustomFieldType type = (TextCustomFieldType) obj;
            Map<String, Object> valueMap = Maps.newHashMap();
            valueMap.put("parentMobile", type.getContent());
            return valueMap;
        }
    },
    STUDENT_BIRTHDAY(10, "birthday", "学员生日", 4, CustomFieldSections.OTHER_INFO.getId(),
        RequireStatus.NOT_REQUIRE.getStatus(), 6,0) {
        public DateFieldType instance(Map<String, Object> valueMap) {
            DateFieldType type = new DateFieldType();
            Object time = valueMap.get("birthday");
            if (time != null) {
                Long birthDayTime = Long.parseLong(time.toString());
                // 去除时间戳是0的情况
                if (birthDayTime > 0l) {
                    type.setContent(birthDayTime);
                }
            }
            return type;
        }

        @Override
        public Map<String, Object> toObjKeyValue(Object obj) {
            DateFieldType type = (DateFieldType) obj;
            Map<String, Object> valueMap = Maps.newHashMap();
            if (type != null && type.getContent() > 0) {
                valueMap.put("birthday", type.getContent());
            }
            return valueMap;

        }
    },
    SCHOOL(11, "school", "公立学校", 1, CustomFieldSections.OTHER_INFO.getId(), RequireStatus.NOT_REQUIRE.getStatus(), 5,0) {
        public TextCustomFieldType instance(Map<String, Object> valueMap) {
            TextCustomFieldType type = new TextCustomFieldType();
            if (valueMap.get("school") != null) {
                type.setContent(String.valueOf(valueMap.get("school")));
            } else {
                type.setContent("");
            }
            return type;
        }

        @Override
        public Map<String, Object> toObjKeyValue(Object obj) {
            TextCustomFieldType type = (TextCustomFieldType) obj;
            Map<String, Object> valueMap = Maps.newHashMap();
            valueMap.put("school", type.getContent());
            return valueMap;
        }
    },
    DEGREE_CLASS(12, "degreeClass", "年级班级", 1, CustomFieldSections.OTHER_INFO.getId(),
        RequireStatus.NOT_REQUIRE.getStatus(), 4,0) {
        public TextCustomFieldType instance(Map<String, Object> valueMap) {
            TextCustomFieldType type = new TextCustomFieldType();
            if (valueMap.get("degreeClass") != null) {
                type.setContent(String.valueOf(valueMap.get("degreeClass")));
            } else {
                type.setContent("");
            }
            return type;
        }

        @Override
        public Map<String, Object> toObjKeyValue(Object obj) {
            TextCustomFieldType type = (TextCustomFieldType) obj;
            Map<String, Object> valueMap = Maps.newHashMap();
            valueMap.put("degreeClass", type.getContent());
            return valueMap;
        }
    },
    POSITION(13, "longitude,latitude,address", "居住区域", 9, CustomFieldSections.OTHER_INFO.getId(),
        RequireStatus.NOT_REQUIRE.getStatus(), 3,0) {

        public PositionFieldType instance(Map<String, Object> valueMap) {
            PositionFieldType type = new PositionFieldType();
            if (valueMap.get("address") != null) {
                type.setAddress(String.valueOf(valueMap.get("address")));
            } else {
                type.setAddress("");
            }
            if (valueMap.get("longitude") != null) {
                type.setLongitude(Double.parseDouble(valueMap.get("longitude").toString()));
            }

            if (valueMap.get("latitude") != null) {
                type.setLatitude(Double.parseDouble(valueMap.get("latitude").toString()));
            }
            return type;
        }

        @Override
        public Map<String, Object> toObjKeyValue(Object obj) {
            PositionFieldType type = (PositionFieldType) obj;
            Map<String, Object> valueMap = Maps.newHashMap();
            valueMap.put("longitude", type.getLongitude());
            valueMap.put("latitude", type.getLatitude());
            valueMap.put("address", type.getAddress());
            return valueMap;
        }
    },
    QQ(14, "qq", "QQ", 1, CustomFieldSections.OTHER_INFO.getId(), RequireStatus.NOT_REQUIRE.getStatus(), 2,0) {
        public TextCustomFieldType instance(Map<String, Object> valueMap) {
            TextCustomFieldType type = new TextCustomFieldType();
            if (valueMap.get("qq") != null) {
                type.setContent(String.valueOf(valueMap.get("qq")));
            } else {
                type.setContent("");
            }
            return type;
        }

        @Override
        public Map<String, Object> toObjKeyValue(Object obj) {
            TextCustomFieldType type = (TextCustomFieldType) obj;
            Map<String, Object> valueMap = Maps.newHashMap();
            valueMap.put("qq", type.getContent());
            return valueMap;
        }
    },
    MAIL(15, "mail", "邮箱", 1, CustomFieldSections.OTHER_INFO.getId(), RequireStatus.NOT_REQUIRE.getStatus(), 1,0) {
        public TextCustomFieldType instance(Map<String, Object> valueMap) {
            TextCustomFieldType type = new TextCustomFieldType();
            if (valueMap.get("mail") != null) {
                type.setContent(String.valueOf(valueMap.get("mail")));
            } else {
                type.setContent("");
            }
            return type;
        }

        @Override
        public Map<String, Object> toObjKeyValue(Object obj) {
            TextCustomFieldType type = (TextCustomFieldType) obj;
            Map<String, Object> valueMap = Maps.newHashMap();
            valueMap.put("mail", type.getContent());
            return valueMap;
        }
    },

    CREATE_TIME(16, "createTime", "创建时间", 5, 3,CustomFieldSections.BASE_INFO.getId(),null,
            RequireStatus.NOT_REQUIRE.getStatus(), -1,1,1) {
        public DateTimeFieldType instance(Map<String, Object> valueMap) {
            DateTimeFieldType dtft = new DateTimeFieldType();
            if (valueMap.get("createTime") != null) {
                Object object = valueMap.get("createTime");
                Long createTime = Long.parseLong(object.toString());
                dtft.setContent(createTime);
            }
            return dtft;
        }

        @Override
        public Map<String, Object> toObjKeyValue(Object obj) {
            DateTimeFieldType type = (DateTimeFieldType) obj;
            Map<String, Object> valueMap = null;
            if (type.getContent() > 0l) {
                valueMap = Maps.newHashMap();
                valueMap.put("createTime", type.getContent());
            }
            return valueMap;

        }
    },

    UPDATE_TIME(17, "updateTime", "更新时间", 5, 3,CustomFieldSections.BASE_INFO.getId(),null,
            RequireStatus.NOT_REQUIRE.getStatus(), -1,1,1) {
        public DateTimeFieldType instance(Map<String, Object> valueMap) {
            DateTimeFieldType dtft = new DateTimeFieldType();
            if (valueMap.get("updateTime") != null) {
                Object object = valueMap.get("updateTime");
                Long updateTime = Long.parseLong(object.toString());
                dtft.setContent(updateTime);
            }
            return dtft;
        }

        @Override
        public Map<String, Object> toObjKeyValue(Object obj) {
            DateTimeFieldType type = (DateTimeFieldType) obj;
            Map<String, Object> valueMap = null;
            if (type.getContent() > 0l) {
                valueMap = Maps.newHashMap();
                valueMap.put("updateTime", type.getContent());
            }
            return valueMap;

        }
    },

    LAST_REMAIND_TIME(18, "lastRemindTime", "最后跟进时间", 5, 3,CustomFieldSections.BASE_INFO.getId(),null,
            RequireStatus.NOT_REQUIRE.getStatus(),  -1,1,1) {
        public DateTimeFieldType instance(Map<String, Object> valueMap) {
            DateTimeFieldType dtft = new DateTimeFieldType();
            if (valueMap.get("lastRemindTime") != null) {
                Object object = valueMap.get("lastRemindTime");
                Long lastRemindTime = Long.parseLong(object.toString());
                // 去除时间戳是0的情况
                if (lastRemindTime > 0l) {
                    dtft.setContent(lastRemindTime);
                }
            }
            return dtft;
        }

        @Override
        public Map<String, Object> toObjKeyValue(Object obj) {
            DateTimeFieldType type = (DateTimeFieldType) obj;
            Map<String, Object> valueMap = null;
            if (type.getContent() > 0l) {
                valueMap = Maps.newHashMap();
                valueMap.put("lastRemindTime", type.getContent());
            }
            return valueMap;

        }
    },
    ;

    public Integer num; // 系统字段的编号
    public String nameList; // 基本字段的名称
    public String label; // 基本字段的属性字符串 姓名:name
    public CustomFieldType fieldType; // 字段类型
    public Integer customType = 3; // 1.学员 2:线索 3:两者都是
    public Integer sectionId; // 所属section 1:基本信息，2：其他信息
    public Enum enums;
    public Integer isRequire;
    public Integer sorted;
    public Integer isPaused;
    public Integer showStatus=0;//是否要返回前端展示,0:是,1:不返回给前端,2:返回给前端,但不展示

    private SystemFields(Integer num, String name, String label, Integer fieldType, Integer customType,
        Integer sectionId, Enum enums, Integer isRequire, Integer sorted,Integer isPaused,Integer showStatus) {
        this.num = num;
        this.nameList = name;
        this.label = label;
        this.fieldType = CustomFieldType.getCustomFieldType(fieldType);
        this.customType = customType;
        this.sectionId = sectionId;
        this.enums = enums;
        this.isRequire = isRequire;
        this.sorted = sorted;
        this.isPaused = isPaused;
        this.showStatus = showStatus;
    }

    private SystemFields(Integer num, String name, String label, Integer fieldType, Integer sectionId,
        Integer isRequire, Integer sorted,Integer isPaused) {
        this(num, name, label, fieldType, 3, sectionId, null, isRequire, sorted,isPaused,0);
    }

    private SystemFields(Integer num, String name, String label, Integer fieldType, Integer sectionId, Enum enums,
        Integer isRequire, Integer sorted,Integer isPaused) {
        this(num, name, label, fieldType, 3, sectionId, enums, isRequire, sorted,isPaused,0);
    }

    public abstract Object instance(Map<String, Object> valueMap);

    public abstract Map<String, Object> toObjKeyValue(Object obj);

    protected Map<String, Object> fieldValueWithType(Map<String, Object> valueMap) {
        return valueMap;
    }

    /**
     * 如果是选择项字段，需要覆盖该方法返回所有可以选择的值
     * 
     * @return
     */
    public List<FieldOption> getFieldOptionForChoiceField() {
        return Collections.emptyList();
    }

    /**
     * 从json中解析出属性值
     * 
     * @param values
     * @return
     */
    public Map<String, Object> setRequestObjFieldValue(String values) {
        if (GenericsUtils.isNullOrEmpty(values)) {
            return Collections.emptyMap();
        }
        Map<String, Object> valueJson = JsonUtil.jsonToMap(values);
        if (GenericsUtils.isNullOrEmpty(valueJson)) {
            return Collections.emptyMap();
        }
        Map<String, Object> fieldValueWithType = this.fieldValueWithType(valueJson);
        return fieldValueWithType;
    }

    protected ValidatorExpression getValidatorExpression() {
        return ValidatorExpression.EMPTY_VALIDATOR;
    }

    public static List<CustomField> generatorCustomSystemFields(Long orgId) {
        return generatorCustomSystemFields(orgId, null);
    }

    public static List<CustomField> generatorCustomSystemFields(Long orgId, Integer customType) {
        List<CustomField> currentOrgSystemFields = new ArrayList<>();
        for (SystemFields sf : SystemFields.values()) {
            boolean add = true;
            if (customType != null && !(sf.customType == customType || sf.customType == 3)) {
                add = false;
            }
            if (add && sf.isPaused == 0) {
                currentOrgSystemFields.add(sf.generatorCustomField(orgId));
            }
        }
        return currentOrgSystemFields;
    }

    public CustomField generatorCustomField(Long orgId) {
        CustomField customField = new CustomField();
        Date currentDate = new Date();
        customField.setCreateTime(currentDate);
        customField.setType(this.fieldType.type);
        customField.setName(nameList);
        customField.setOrgId(orgId);
        customField.setSystemFieldNum(num);
        customField.setUpdateTime(currentDate);
        customField.setLabel(label);
        customField.setIsRequired(isRequire);
        customField.setSorted(sorted);
        customField.setSectionId(this.sectionId);
        customField.setIsPaused(isPaused);
        return customField;
    }

    public static List<String> fieldNames = new ArrayList<String>(SystemFields.values().length);

    public static Map<String, SystemFields> fieldMap = Maps.newHashMapWithExpectedSize(SystemFields.values().length);

    public static Map<Integer, SystemFields> fieldMapWithNum =
        Maps.newHashMapWithExpectedSize(SystemFields.values().length);

    public static List<String> getAllFieldNames() {
        return fieldNames;
    }

    public static SystemFields getSystemField(String name) {
        return fieldMap.get(name);
    }

    static {
        initInfos();
    }

    private static void initInfos() {
        for (SystemFields sf : SystemFields.values()) {
            fieldNames.add(sf.nameList);
            fieldMap.put(sf.nameList, sf);
            fieldMapWithNum.put(sf.num, sf);
        }
    }

    /**
     * @param systemFieldNum
     * @return
     */
    public static SystemFields getSystemFieldWithSystemNum(Integer systemFieldNum) {
        return fieldMapWithNum.get(systemFieldNum);
    }

    private static final List<SystemFields> DATE_LIST = new ArrayList<>();
    static {
        DATE_LIST.add(LAST_REMAIND_TIME);
        DATE_LIST.add(CREATE_TIME);
        DATE_LIST.add(STUDENT_BIRTHDAY);
    }

    public static List<SystemFields> getFilterDateFields() {
        return DATE_LIST;
    }
}

