
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */

package com.baijia.tianxiao.sal.student.dto.customFields.fieldTypes;

import com.baijia.tianxiao.sal.student.enums.CustomFieldType;

import org.springframework.stereotype.Component;

import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * little Boy Tell me, where do you dream? Rezar Jul 25, 2016
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Component
public class DateFieldType extends AbstractCustomFieldType<DateFieldType> {

    private Long content;

    /*
     * (non-Javadoc)
     * 
     * @see
     * com.baijia.tianxiao.sal.student.dto.customFields.fieldTypes.CustomFieldTypeInterface#objToJson(java.lang.Object)
     */

    @Override
    public String objToJson(DateFieldType obj) {
        return super.toJson(obj);
    }

    @Override
    public DateFieldType jsonToObj(String json) {
        return super.fromJson(json);

    }

    @Override
    public CustomFieldType matchFieldType() {
        return CustomFieldType.DAY_DATE;
    }

    @Override
    public CustomFieldTypeInterface<DateFieldType> instance() {
        return new DateFieldType();
    }

}
