
package com.baijia.tianxiao.sal.student.dto.customFields.fieldTypes;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

public abstract class AbstractCustomFieldType<E> implements CustomFieldTypeInterface<E> {

    public String toJson(Object obj) {
        Gson gson = new GsonBuilder().serializeNulls().create();
        return gson.toJson(obj);
    }

    @SuppressWarnings("unchecked")
    public <T> T fromJson(String json) {
        Gson gson = new Gson();
        return (T) gson.fromJson(json, this.getClass());
    }

    public String createJsonWithKeyValue(String tagsKey, Object obj) {
        Map<String, Object> jsonMap = new HashMap<>();
        jsonMap.put(tagsKey, obj);
        if (obj.getClass().isArray() || obj instanceof Collections || obj instanceof Map) {
            return JSONArray.fromObject(jsonMap).toString();
        } else {
            return JSONObject.fromObject(jsonMap).toString();
        }
    }

}
