/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2015 All Rights Reserved.
 */

package com.baijia.tianxiao.sal.student.dto;

import java.util.Date;
import java.util.List;

import org.codehaus.jackson.annotate.JsonIgnore;

import com.baijia.tianxiao.dto.BaseDto;

import lombok.Data;

/**
 * @title RosterAddRequestDto
 * @desc 添加花名册（学员）请求实体类
 * @author shanyu
 * @date 2015年12月4日
 * @version 1.0
 */
@Data
public class StudentInfoDto extends BaseDto {

    private static final long serialVersionUID = -675009717008338515L;

    private Long consultUserId;
    
    public void setConsultUserId(Long consultUserId){
        this.consultUserId = consultUserId;
    }

    private String consultUserIds;

    private Long studentId;

    private Long studentNumber;

    private String name;

    private String mobile;

    private String weixin;

    private String parentName;

    private String parentMobile;

    private Long nextRemindTime;

    private String school;

    private String qq;

    private Integer gender;

    private String remark;

    private Integer star;// 学员星级，需要根据学员消费金额计算

    private String mail;

    private Long birthday;

    private String address;

    private String degreeClass;

    private String fatherOccupation;

    private String matherOccupation;

    private Integer source;

    private Double payMoney; // 消费总额

    // private String payMoenyStr;//消费金额

    private Integer totalClassTime; // 总课次

    private Integer finishClassTime; // 已完成课次

    // 已报班级
    private Integer sumClasses;

    private String comments;

    private String tags;

    private Date lastFollowDate;//最近跟进时间

    private Integer status;

    private List<CommentInfoDto> commentsResp;

    private List<TagInfoDto> tagsResp;

    private String avatarUrl;

    // 机构是否可以与学员进行微信聊天
    private int chat = 0;

    // 最后一次的聊天时间
    private Long lastCommunicationTime;

    // 用户是否有确认动作
    private Integer confirm;

    // 班级名称
    private String className;

    // 学生来源0=跟谁学,1=非跟谁学
    private Integer origin;

    private Long storageId;

    private Integer relationship;

    private Long branchId;

    private Double latitude;
    private Double longitude;
    private Long areaId;

    private String headTeacher;

    private Integer addCascadeId;// 学员添加人

    private String cascadeIdStr;//顧問

    private String province; // 省份

    private String city; // 市

    private String county; // 区

    private Integer lessonStatus;

    // 数据传输对象，不参与结果返回
    @JsonIgnore
    private Long userId = null;
    @JsonIgnore
    private Long orgNumber = null;
    @JsonIgnore
    private Boolean isShowMobile = false;
    @JsonIgnore
    private Integer cascadeId;
    @JsonIgnore
    private Long orgId; // 数据传输属性
    @JsonIgnore
    private boolean needSetClassHour = true; // 课消需求上线前的老接口同样设置已上课次/总课次信息
    @JsonIgnore
    private String customSearchValue;

    public String getAddress() {
        return this.address;
    }

    public void setAreaId(Long areaId) {
        this.areaId = areaId;
    }

    /**
     */
    public void setBirthdayDate(Date birthday) {
        if (birthday != null) {
            this.birthday = birthday.getTime();
        }
    }

    /**
     * @param nextRemindTime2
     */
    public void setNextRemindTimeDate(Date nextRemindTime2) {
        if (nextRemindTime2 != null) {
            this.nextRemindTime = nextRemindTime2.getTime();
        }
    }
}
