package com.baijia.tianxiao.sal.student.dto;

import com.baijia.tianxiao.dal.solr.po.StudentClassHour;
import lombok.Data;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by lxp on 2017/3/2.
 */
@Data
public class StudentCourseStatisticsDetail {
    private String username;
    private String mobile;
    private long userId;
    private long finishedTimes;
    private int totalTimes;
    private long finishedHour;
    private long totalHour;
    private boolean hasLesson;
    private String timesStr;
    private String hourStr;
    private List<StudentCourseTime> courseTimeList = new ArrayList<>();

    @Data
    public static class StudentCourseTime extends StudentCourseStatisticsDetail{
        private String className;
        private String classHeader = "未分配";
        private String teacherName = "未分配";

        public static StudentCourseTime getInstance(StudentClassHour classHour){
            StudentCourseTime courseTime = new StudentCourseTime();
            courseTime.setTotalHour(classHour.getTotalTime());
            courseTime.setFinishedHour(classHour.getFinishedTime());
            courseTime.setFinishedTimes(classHour.getFinishCount());
            courseTime.setTotalTimes(classHour.getTotalCount());
            return courseTime;
        }
    }
}
