/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.student.impl;

import com.baijia.tianxiao.constants.CourseType;
import com.baijia.tianxiao.constants.PayStatus;
import com.baijia.tianxiao.dal.constant.ChargeUnit;
import com.baijia.tianxiao.dal.enums.CourseTypeEnum;
import com.baijia.tianxiao.dal.org.constant.DeleteStatus;
import com.baijia.tianxiao.dal.org.dao.CoursePurchaseDao;
import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.dao.OrgClassLessonDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgInfoDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentKexiaoRecordDao;
import com.baijia.tianxiao.dal.org.dao.TXCascadeCredentialDao;
import com.baijia.tianxiao.dal.org.dto.KexiaoStatisticss;
import com.baijia.tianxiao.dal.org.po.CoursePurchase;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.org.po.OrgCourse;
import com.baijia.tianxiao.dal.org.po.OrgInfo;
import com.baijia.tianxiao.dal.org.po.OrgStudent;
import com.baijia.tianxiao.dal.org.po.OrgStudentCourse;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupCourseDao;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupInfoDao;
import com.baijia.tianxiao.dal.signup.dto.OrgStudentSignupStatistics;
import com.baijia.tianxiao.dal.signup.po.OrgSignupCourse;
import com.baijia.tianxiao.dal.signup.po.OrgSignupInfo;
import com.baijia.tianxiao.dal.solr.po.StudentClassHour;
import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.enums.StudentCourseStatus;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sal.common.api.KexiaoApiService;
import com.baijia.tianxiao.sal.common.api.StudentKexiaoStatisticsApiService;
import com.baijia.tianxiao.sal.common.dto.KexiaoStatisticsSuper;
import com.baijia.tianxiao.sal.common.dto.kexiao.KexiaoStatistics;
import com.baijia.tianxiao.sal.common.utils.KexiaoUtil;
import com.baijia.tianxiao.sal.organization.constant.DeviceType;
import com.baijia.tianxiao.sal.organization.constant.TXPermissionConst;
import com.baijia.tianxiao.sal.organization.org.service.TxAccountPermissionService;
import com.baijia.tianxiao.sal.student.api.OrgStudentCourseService;
import com.baijia.tianxiao.sal.student.dto.request.StudentCommenRequestDto;
import com.baijia.tianxiao.sal.student.dto.response.OrgStudentPurchaseReponseDto;
import com.baijia.tianxiao.sal.student.dto.response.StudentCourseInfoReponseDto;
import com.baijia.tianxiao.sal.student.dto.response.StudentCourseListResponse;
import com.baijia.tianxiao.sal.student.enums.StudentErrorCode;
import com.baijia.tianxiao.util.GenericsUtils;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OrgStudentCourseServiceImpl
implements OrgStudentCourseService {
    private static final Logger log = LoggerFactory.getLogger(OrgStudentCourseServiceImpl.class);
    private static final String TIP_INFO = "\u5b66\u5458\u5728\u8be5\u73ed\u7ea7\u7684\u5269\u4f59\u5b66\u8d39\u53ca\u8bfe\u6b21\u4fe1\u606f\u4e0d\u5b8c\u6574\uff0c\u65e0\u6cd5\u6838\u7b97\u8bfe\u6d88\uff0c\u53ef\u81f3\u7535\u8111\u7aef\u8fdb\u884c\u8865\u5145\u3002";
    private static final String TIP_INFO_URL = "http://www.baidu.com";
    @Autowired
    private OrgStudentDao orgStudentsDao;
    @Autowired
    private OrgCourseDao orgCourseDao;
    @Autowired
    private OrgAccountDao orgAccountDao;
    @Autowired
    private OrgSignupInfoDao orgSignupInfoDao;
    @Autowired
    private OrgSignupCourseDao orgSignupCourseDao;
    @Autowired
    private OrgStudentCourseDao orgStudentCourseDao;
    @Autowired
    private OrgClassLessonDao orgClassLessonDao;
    @Autowired
    private CoursePurchaseDao coursePurchaseDao;
    @Autowired
    private TXCascadeCredentialDao txCascadeCredentialDao;
    @Autowired
    private OrgInfoDao orgInfoDao;
    @Autowired
    private OrgStudentKexiaoRecordDao orgStudentKexiaoRecordDao;
    @Autowired
    private StudentKexiaoStatisticsApiService studSentKexiaoStatisticsApiService;
    @Autowired
    private KexiaoApiService kexiaoApiService;
    @Autowired
    private TxAccountPermissionService permissionService;

    @Override
    public List<StudentCourseInfoReponseDto> getCurrentStudnetCourseInfos(StudentCommenRequestDto studentCommenRequestDto, Long orgId) {
        OrgAccount account = (OrgAccount)this.orgAccountDao.getById((Serializable)orgId, new String[0]);
        if (account == null) {
            throw new BussinessException((UniverseErrorCode)StudentErrorCode.ORG_NOT_EXIST);
        }
        if (studentCommenRequestDto.getStudentId() == null) {
            log.warn("error: studentId is null!");
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR);
        }
        OrgStudent orgStudent = (OrgStudent)this.orgStudentsDao.getById((Serializable)studentCommenRequestDto.getStudentId(), new String[0]);
        if (orgStudent == null || orgStudent.getDelStatus().intValue() == DeleteStatus.DELETED.getValue() || orgStudent.getOrgId().longValue() != orgId.longValue()) {
            throw new BussinessException((UniverseErrorCode)StudentErrorCode.STUDENT_NOT_EXIST);
        }
        List courseList = this.orgStudentCourseDao.getOrgCourseIds(orgId, orgStudent.getUserId(), Integer.valueOf(StudentCourseStatus.NORMAL.getCode()), null);
        Map<Long, StudentCourseInfoReponseDto> map = this.reviseStudentCourseInfoDto(courseList, orgId, orgStudent.getId(), orgStudent.getUserId());
        ArrayList<StudentCourseInfoReponseDto> retList = new ArrayList<StudentCourseInfoReponseDto>();
        for (StudentCourseInfoReponseDto dto : map.values()) {
            if (dto.getStatus() != StudentCourseStatus.NORMAL.getCode()) continue;
            retList.add(dto);
        }
        this.studSentKexiaoStatisticsApiService.fillStudentKeXiaoStatistics(orgId, retList, Integer.valueOf(2));
        log.info("retList is:{}", retList);
        Iterator iterator = retList.iterator();
        boolean hasPermission = this.permissionService.checkPermission(orgId, studentCommenRequestDto.getCasCadeId(), DeviceType.APP, TXPermissionConst.REMAINNING_FEE.getpCode());
        while (iterator.hasNext()) {
            StudentCourseInfoReponseDto dto = (StudentCourseInfoReponseDto)iterator.next();
            KexiaoStatistics statistics = this.kexiaoApiService.queryKexiaoStatByStudentClass(orgId.longValue(), orgStudent.getUserId().longValue(), dto.getCourseId().longValue());
            this.kexiaoApiService.fillKexiaoData((KexiaoStatisticsSuper)dto, statistics);
            if (statistics.getLeftNumber() <= 0L && statistics.getTotalNumber() > 0L) {
                iterator.remove();
                continue;
            }
            if (statistics.getLeftNumber() <= 0L && statistics.getTransferNumber() > 0L) {
                iterator.remove();
                continue;
            }
            this.fillPresentAndTipInfo(dto);
            if (hasPermission) continue;
            dto.setRemainTuition("******");
        }
        return retList;
    }

    @Override
    public StudentCourseListResponse getCurrentStudentCourseList(Long orgId, StudentCommenRequestDto request) {
        return this.wrapperStudentCourseList(this.getCurrentStudnetCourseInfos(request, orgId));
    }

    @Override
    public StudentCourseListResponse getHistoryStudentCourseList(Long orgId, StudentCommenRequestDto request) {
        return this.wrapperStudentCourseList(this.getHistoryStudnetCourseInfos(request, orgId));
    }

    private StudentCourseListResponse wrapperStudentCourseList(List<StudentCourseInfoReponseDto> dtoList) {
        StudentCourseListResponse response = new StudentCourseListResponse();
        long sumTotalTimes = 0L;
        long sumFinishedTimes = 0L;
        long sumLeftTimes = 0L;
        long sumTotalHour = 0L;
        long sumFinishedHour = 0L;
        long sumLeftHour = 0L;
        block4: for (StudentCourseInfoReponseDto dto : dtoList) {
            ChargeUnit unit = ChargeUnit.getByCode((int)dto.getChargeUnit());
            switch (unit) {
                case BY_TIMES: {
                    response.getTimesCourses().add(dto);
                    sumTotalTimes += (long)dto.getTotalClassTimesForKexiaoValue().intValue();
                    sumFinishedTimes += (long)dto.getFinishClassTimesForKexiaoValue().intValue();
                    sumLeftTimes += (long)dto.getLeftClassTimesForKexiaoValue().intValue();
                    continue block4;
                }
                case BY_HOUR: 
                case BY_HALF_HOUR: {
                    response.getHourCourses().add(dto);
                    sumTotalHour += (long)dto.getTotalClassTimesForKexiaoValue().intValue();
                    sumFinishedHour += (long)dto.getFinishClassTimesForKexiaoValue().intValue();
                    sumLeftHour += (long)dto.getLeftClassTimesForKexiaoValue().intValue();
                    continue block4;
                }
            }
            log.info("[StudentCourse] chargeType error.type=" + dto.getChargeUnit());
        }
        response.setSumTotalTimes(String.valueOf(sumTotalTimes));
        response.setSumFinishedTimes(String.valueOf(sumFinishedTimes));
        response.setSumLeftTimes(String.valueOf(sumLeftTimes));
        response.setSumTotalHour(KexiaoUtil.classHourFormat((long)sumTotalHour));
        response.setSumFinishedHour(KexiaoUtil.classHourFormat((long)sumFinishedHour));
        response.setSumLeftHour(KexiaoUtil.classHourFormat((long)sumLeftHour));
        return response;
    }

    private void fillPresentAndTipInfo(StudentCourseInfoReponseDto dto) {
        boolean currentCourseCanSetInfo = dto.isCurrentCourseCanSetInfo();
        if (currentCourseCanSetInfo) {
            Integer totalCount = dto.getTotalClassTimesForKexiaoValue();
            Integer finishCount = dto.getFinishClassTimesForKexiaoValue();
            int finishPercent = OrgStudentCourseServiceImpl.countClassHour(totalCount, finishCount);
            dto.setFinishPercent(finishPercent);
        }
        if (!currentCourseCanSetInfo) {
            dto.setTipInfo(TIP_INFO);
            dto.setTipInfoUrl(TIP_INFO_URL);
        }
    }

    public static int countClassHour(int totalCount, int finishCount) {
        if (totalCount == 0) {
            return 0;
        }
        BigDecimal b1 = new BigDecimal(finishCount * 100);
        BigDecimal b2 = new BigDecimal(totalCount);
        return b1.divide(b2, 0, 4).intValue();
    }

    private Map<Long, StudentCourseInfoReponseDto> reviseStudentCourseInfoDto(List<OrgStudentCourse> orgStudentCourseList, Long orgId, Long studentId, Long userId) {
        LinkedHashMap<Long, StudentCourseInfoReponseDto> map = new LinkedHashMap<Long, StudentCourseInfoReponseDto>();
        HashMap<Long, OrgStudentCourse> studentCourseMap = new HashMap<Long, OrgStudentCourse>();
        if (orgStudentCourseList == null || orgStudentCourseList.size() < 1) {
            return map;
        }
        for (OrgStudentCourse course : orgStudentCourseList) {
            studentCourseMap.put(course.getCourseId(), course);
        }
        log.info("find all courseIds is : {} ", studentCourseMap.keySet());
        List courses = this.orgCourseDao.getByIds(studentCourseMap.keySet(), new String[0]);
        HashSet parentCourseIds = Sets.newHashSet();
        for (OrgCourse orgCourse : courses) {
            if (orgCourse.getParentId() <= 0L) continue;
            parentCourseIds.add(orgCourse.getParentId());
        }
        HashSet casCadeIds = Sets.newHashSet();
        List retCascadeIds = GenericsUtils.toFieldList((Collection)courses, (String)"cascadeId");
        casCadeIds.addAll(retCascadeIds);
        log.info("all casCadeIds are :{} ", (Object)casCadeIds);
        Map txCascadCredentialListByCascdeIds = this.txCascadeCredentialDao.getTxCascadCredentialListByCascdeIds((Collection)casCadeIds);
        if (casCadeIds.contains(0)) {
            OrgInfo orginfo = this.orgInfoDao.getOrgInfo(Integer.valueOf(orgId.intValue()), new String[0]);
            txCascadCredentialListByCascdeIds.put(0L, orginfo.getContacts());
        }
        log.info("txCascadCredentialListByCascdeIds are :{} ", (Object)txCascadCredentialListByCascdeIds);
        Map parentCourseMap = Maps.newHashMap();
        if (parentCourseIds.size() > 0) {
            parentCourseMap = this.orgCourseDao.getOrgCourseMap((Collection)parentCourseIds, new String[0]);
        }
        if (courses != null) {
            for (OrgCourse course : courses) {
                OrgCourse parentCourse;
                StudentCourseInfoReponseDto dto = StudentCourseInfoReponseDto.getInstance(course);
                if (course.getCascadeId() != null) {
                    dto.setHeadTeacher((String)txCascadCredentialListByCascdeIds.get(course.getCascadeId().longValue()));
                }
                dto.setParentCourseId(course.getParentId());
                dto.setCourseId(course.getId());
                dto.setStudentId(studentId);
                dto.setUserId(userId);
                if (dto.getParentId() > 0L && (parentCourse = (OrgCourse)parentCourseMap.get(dto.getParentId())) != null) {
                    dto.setCourseNumber(parentCourse.getNumber());
                }
                OrgStudentCourse studentCourse = (OrgStudentCourse)studentCourseMap.get(course.getId());
                dto.setStatus(studentCourse.getStatus());
                dto.setBuyCount(studentCourse.getLessonCount());
                dto.setChargeUnit(course.getChargeUnit() == null || course.getChargeUnit().intValue() == ChargeUnit.BY_OTHER.getCode() ? 1 : course.getChargeUnit());
                map.put(course.getId(), dto);
            }
        }
        return map;
    }

    @Override
    public List<StudentCourseInfoReponseDto> getHistoryStudnetCourseInfos(StudentCommenRequestDto studentCommenRequestDto, Long orgId) {
        OrgAccount account = (OrgAccount)this.orgAccountDao.getById((Serializable)orgId, new String[0]);
        if (account == null) {
            throw new BussinessException((UniverseErrorCode)StudentErrorCode.ORG_NOT_EXIST);
        }
        if (studentCommenRequestDto.getStudentId() == null) {
            log.warn("error: studentId is null!");
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR);
        }
        OrgStudent orgStudent = (OrgStudent)this.orgStudentsDao.getById((Serializable)studentCommenRequestDto.getStudentId(), new String[0]);
        if (orgStudent == null || orgStudent.getDelStatus().intValue() == DeleteStatus.DELETED.getValue() || orgStudent.getOrgId().longValue() != orgId.longValue()) {
            throw new BussinessException((UniverseErrorCode)StudentErrorCode.STUDENT_NOT_EXIST);
        }
        List courseList = this.orgStudentCourseDao.getOrgCourseIds(orgId, orgStudent.getUserId(), null, null);
        Map<Long, StudentCourseInfoReponseDto> map = this.reviseStudentCourseInfoDto(courseList, orgId, orgStudent.getId(), orgStudent.getUserId());
        this.studSentKexiaoStatisticsApiService.fillStudentKeXiaoStatistics(orgId, map.values(), Integer.valueOf(2));
        boolean hasPermission = this.permissionService.checkPermission(orgId, studentCommenRequestDto.getCasCadeId(), DeviceType.APP, TXPermissionConst.REMAINNING_FEE.getpCode());
        ArrayList<StudentCourseInfoReponseDto> retList = new ArrayList<StudentCourseInfoReponseDto>();
        for (StudentCourseInfoReponseDto dto : map.values()) {
            this.fillPresentAndTipInfo(dto);
            KexiaoStatistics statistics = this.kexiaoApiService.queryKexiaoStatByStudentClass(orgId.longValue(), orgStudent.getUserId().longValue(), dto.getCourseId().longValue());
            log.info("KexiaoStatistics={}", (Object)statistics);
            this.kexiaoApiService.fillKexiaoData((KexiaoStatisticsSuper)dto, statistics);
            if (!hasPermission) {
                dto.setRemainTuition("******");
            }
            if (dto.getStatus() == StudentCourseStatus.WITHDRAW.getCode()) {
                retList.add(dto);
                continue;
            }
            if (dto.getStatus() == StudentCourseStatus.TRANSFER.getCode()) {
                retList.add(dto);
                continue;
            }
            long leftClassTimesForKexiaoValue = statistics.getLeftNumber();
            long totalClassTimesForKexiaoValue = statistics.getTotalNumber();
            if (leftClassTimesForKexiaoValue <= 0L && totalClassTimesForKexiaoValue != 0L) {
                retList.add(dto);
                continue;
            }
            if (statistics.getLeftNumber() > 0L || statistics.getTransferNumber() <= 0L) continue;
            retList.add(dto);
        }
        map.clear();
        return retList;
    }

    @Deprecated
    public void setKexiaoStatistics(Long orgId, Long studentId, Long userId, List<StudentCourseInfoReponseDto> studentCourseInfoReponseDtoList) {
        if (GenericsUtils.isNullOrEmpty(studentCourseInfoReponseDtoList)) {
            return;
        }
        List courseIds = GenericsUtils.toFieldList(studentCourseInfoReponseDtoList, (String)"courseId");
        List<Long> studentIds = Arrays.asList(studentId);
        List findKexiaoStatistics = this.orgStudentKexiaoRecordDao.findKexiaoStatistics(orgId, studentIds, (Collection)courseIds);
        List<Long> userIds = Arrays.asList(userId);
        List findAllOrgStudentSigupStatistics = this.orgSignupCourseDao.findAllOrgStudentSignupStatistics(orgId, userIds, (Collection)courseIds);
        Map orgStudentSigupStatisticsMap = GenericsUtils.toFieldMap((Collection)findAllOrgStudentSigupStatistics, (String[])new String[]{"courseId"});
        Map kexiaoStaisticsMap = GenericsUtils.toFieldMap((Collection)findKexiaoStatistics, (String[])new String[]{"courseId"});
        HashSet tempSets = Sets.newHashSetWithExpectedSize((int)1);
        tempSets.add(userId);
        for (StudentCourseInfoReponseDto dto : studentCourseInfoReponseDtoList) {
            Long courseId = dto.getCourseId();
            Integer totalCount = dto.getTotalClassTimes();
            Integer finishCount = dto.getFinishClassTimes();
            KexiaoStatisticss kexiaoStatisticss = (KexiaoStatisticss)kexiaoStaisticsMap.get(courseId);
            OrgStudentSignupStatistics orgStudentSigupStatistics = (OrgStudentSignupStatistics)orgStudentSigupStatisticsMap.get(courseId);
            Map byCourseIdsAndStudentIds = this.orgSignupCourseDao.canShowTotalCount(orgId, userIds, Arrays.asList(courseId));
            boolean canSetInfo = (Boolean)byCourseIdsAndStudentIds.get(userId);
            if (dto.getChargeUnit().intValue() == ChargeUnit.BY_HALF_HOUR.getCode() || dto.getChargeUnit().intValue() == ChargeUnit.BY_HOUR.getCode() || dto.getChargeUnit().intValue() == ChargeUnit.BY_MINUTE.getCode()) {
                dto.setFinishClassTimesForKexiao(String.valueOf((float)kexiaoStatisticss.getKexiaoTime().longValue() / 60.0f));
                if (canSetInfo) {
                    dto.setTotalClassTimesForKexiao(String.valueOf(StudentCourseInfoReponseDto.countClassHour(totalCount, dto.getChargeUnit())));
                    dto.setLeftClassTimesForKexiao(String.valueOf(StudentCourseInfoReponseDto.countClassHour(totalCount - finishCount, dto.getChargeUnit())));
                } else {
                    dto.setTotalClassTimesForKexiao("--");
                    dto.setLeftClassTimesForKexiao("--");
                }
            } else {
                dto.setFinishClassTimesForKexiao(String.valueOf(finishCount));
                if (canSetInfo) {
                    dto.setTotalClassTimesForKexiao(String.valueOf(totalCount));
                    dto.setLeftClassTimesForKexiao(totalCount == null ? "--" : String.valueOf(dto.getTotalClassTimes() - dto.getFinishClassTimes()));
                } else {
                    dto.setTotalClassTimesForKexiao("--");
                    dto.setLeftClassTimesForKexiao("--");
                }
            }
            Long kexiaoMoney = kexiaoStatisticss.getKexiaoMoney();
            Long signupMoney = orgStudentSigupStatistics.getPayMoney();
            dto.setRemainTuition(String.valueOf((double)(signupMoney - kexiaoMoney) / 100.0));
        }
    }

    private StudentCourseInfoReponseDto setClassHour(StudentCourseInfoReponseDto dto, StudentClassHour classHour) {
        dto.setFinishClassTimes(classHour.getFinishCount());
        dto.setTotalClassTimes(classHour.getTotalCount());
        dto.setLeftClassTimes(dto.getTotalClassTimes() - dto.getFinishClassTimes());
        dto.setCourseType(CourseType.ORG_COURSE.getCode());
        return dto;
    }

    @Override
    public List<OrgStudentPurchaseReponseDto> getStudentPurchases(StudentCommenRequestDto studentCommenRequestDto, Long orgId) {
        OrgAccount account = (OrgAccount)this.orgAccountDao.getById((Serializable)orgId, new String[0]);
        if (account == null) {
            throw new BussinessException((UniverseErrorCode)StudentErrorCode.ORG_NOT_EXIST);
        }
        if (studentCommenRequestDto.getStudentId() == null) {
            log.warn("error: studentId is null!");
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR);
        }
        OrgStudent orgStudent = (OrgStudent)this.orgStudentsDao.getById((Serializable)studentCommenRequestDto.getStudentId(), new String[0]);
        if (orgStudent == null || orgStudent.getDelStatus().intValue() == DeleteStatus.DELETED.getValue() || orgStudent.getOrgId().longValue() != orgId.longValue()) {
            throw new BussinessException((UniverseErrorCode)StudentErrorCode.STUDENT_NOT_EXIST);
        }
        return this.getStudentSignupInfos(orgStudent, account.getNumber().longValue());
    }

    @Override
    public int getStudentSignupCourse(OrgStudent po, Long orgNumber) {
        List<StudentCourseInfoReponseDto> result = this.getCourseInfoes(po, orgNumber);
        return result != null && !result.isEmpty() ? result.size() : 0;
    }

    private List<StudentCourseInfoReponseDto> getCourseInfoes(OrgStudent po, Long orgNumber) {
        StudentCourseInfoReponseDto dto;
        ArrayList courseDtos = Lists.newArrayList();
        List cashpurchase = this.orgSignupInfoDao.getPurchases(po.getUserId(), orgNumber, null, Integer.valueOf(PayStatus.SUCESS.getCode()), new String[]{"totalPrices", "signupPurchaseId"});
        List mPurchase = this.coursePurchaseDao.getCoursePurchaseList(po.getOrgId(), po.getUserId(), Long.valueOf(0L), Integer.valueOf(CourseType.ORG_COURSE.getCode()), Integer.valueOf(PayStatus.SUCESS.getCode()), new String[0]);
        HashSet courseIds = Sets.newHashSet();
        HashSet purchaseIds = Sets.newHashSet();
        for (Object orgSignupInfo : cashpurchase) {
            purchaseIds.add(orgSignupInfo.getSignupPurchaseId());
        }
        List sinupCourses = this.orgSignupCourseDao.loadByPurchaseIds((Collection)purchaseIds, new String[0]);
        for (OrgSignupCourse orgSignupCourse : sinupCourses) {
            courseIds.add(orgSignupCourse.getOrgCourseId());
        }
        for (CoursePurchase coursePurchase : mPurchase) {
            courseIds.add(coursePurchase.getCourseId());
        }
        Map nameMap = this.orgCourseDao.getCourseNameMap((Collection)courseIds);
        Map lessonTimeMap = this.orgClassLessonDao.getLessonTimemap((Collection)courseIds, null, po.getOrgId(), Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        Map finishLessonTimeMap = this.orgClassLessonDao.getLessonTimemap((Collection)courseIds, new Date(), po.getOrgId(), Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        for (OrgSignupCourse purchase : sinupCourses) {
            dto = new StudentCourseInfoReponseDto();
            dto.setCourseId(purchase.getOrgCourseId());
            dto.setCourseNumber((long)purchase.getOrgCourseNumber());
            dto.setCourseType(CourseType.ORG_COURSE.getCode());
            dto.setCourseName((String)nameMap.get(purchase.getOrgCourseId()));
            if (lessonTimeMap.get(purchase.getOrgCourseId()) != null) {
                dto.setTotalClassTimes((Integer)lessonTimeMap.get(purchase.getOrgCourseId()));
            } else {
                dto.setTotalClassTimes(0);
            }
            if (finishLessonTimeMap.get(purchase.getOrgCourseId()) != null) {
                dto.setFinishClassTimes((Integer)finishLessonTimeMap.get(purchase.getOrgCourseId()));
            } else {
                dto.setFinishClassTimes(0);
            }
            dto.setLeftClassTimes(dto.getTotalClassTimes() - dto.getFinishClassTimes());
            courseDtos.add(dto);
        }
        for (OrgSignupCourse purchase : mPurchase) {
            dto = new StudentCourseInfoReponseDto();
            dto.setCourseId(purchase.getCourseId());
            dto.setCourseNumber((long)purchase.getCourseNumber());
            dto.setCourseType(CourseType.ORG_COURSE.getCode());
            dto.setCourseName((String)nameMap.get(purchase.getCourseId()));
            if (lessonTimeMap.get(purchase.getCourseId()) != null) {
                dto.setTotalClassTimes((Integer)lessonTimeMap.get(purchase.getCourseId()));
            } else {
                dto.setTotalClassTimes(0);
            }
            if (finishLessonTimeMap.get(purchase.getCourseId()) != null) {
                dto.setFinishClassTimes((Integer)finishLessonTimeMap.get(purchase.getCourseId()));
            } else {
                dto.setFinishClassTimes(0);
            }
            dto.setLeftClassTimes(dto.getTotalClassTimes() - dto.getFinishClassTimes());
            courseDtos.add(dto);
        }
        log.debug("course list={}", (Object)courseDtos);
        return courseDtos;
    }

    private List<OrgStudentPurchaseReponseDto> getStudentSignupInfos(OrgStudent po, Long orgNumber) {
        ArrayList courseDtos = Lists.newArrayList();
        List cashpurchase = this.orgSignupInfoDao.getPurchases(po.getUserId(), orgNumber, null, Integer.valueOf(PayStatus.SUCESS.getCode()), new String[]{"totalPrices", "signupPurchaseId"});
        List mPurchase = this.coursePurchaseDao.getCoursePurchaseList(po.getOrgId(), po.getUserId(), Long.valueOf(0L), Integer.valueOf(CourseType.ORG_COURSE.getCode()), Integer.valueOf(PayStatus.SUCESS.getCode()), new String[0]);
        HashSet courseIds = Sets.newHashSet();
        HashSet purchaseIds = Sets.newHashSet();
        for (OrgSignupInfo orgSignupInfo : cashpurchase) {
            purchaseIds.add(orgSignupInfo.getSignupPurchaseId());
        }
        for (CoursePurchase coursePurchase : mPurchase) {
            courseIds.add(coursePurchase.getCourseId());
        }
        Map nameMap = this.orgCourseDao.getCourseNameMap((Collection)courseIds);
        if (CollectionUtils.isNotEmpty((Collection)purchaseIds)) {
            List sinupCourses = this.orgSignupCourseDao.loadByPurchaseIds((Collection)purchaseIds, new String[0]);
            for (OrgSignupCourse purchase : sinupCourses) {
                OrgStudentPurchaseReponseDto dto = new OrgStudentPurchaseReponseDto();
                dto.setCourseNumber((long)purchase.getOrgCourseNumber());
                dto.setCourseName((String)nameMap.get(purchase.getOrgCourseId()));
                dto.setPayMoney(purchase.getPayPrice().doubleValue() / 100.0);
                courseDtos.add(dto);
            }
        }
        for (CoursePurchase purchase : mPurchase) {
            OrgStudentPurchaseReponseDto dto = new OrgStudentPurchaseReponseDto();
            dto.setCourseNumber((long)purchase.getCourseNumber());
            dto.setCourseName((String)nameMap.get(purchase.getCourseId()));
            dto.setPayMoney((double)purchase.getPayMoney());
            courseDtos.add(dto);
        }
        return courseDtos;
    }

    @Override
    public OrgStudentCourse getBySidAndCid(Long orgId, Long studentId, Long courseId) {
        return this.orgStudentCourseDao.getStudentCourse(orgId, courseId, studentId);
    }

    @Override
    public void saveOrgStudentCourse(OrgStudentCourse orgStudentCourse) {
        this.orgStudentCourseDao.save((Object)orgStudentCourse, new String[0]);
    }

    @Override
    public void updateOrgStudentCourse(OrgStudentCourse orgStudentCourse) {
        this.orgStudentCourseDao.update((Object)orgStudentCourse, new String[0]);
    }

    @Override
    public Map<CourseTypeEnum, Set<Long>> splitCourseIdsByCourseType(Collection<Long> allIds) {
        HashMap<CourseTypeEnum, Set<Long>> ret = new HashMap<CourseTypeEnum, Set<Long>>();
        List courseList = this.orgCourseDao.getByIds(allIds, new String[]{"courseType", "id"});
        for (OrgCourse course : courseList) {
            CourseTypeEnum courseType = CourseTypeEnum.getByCode((int)course.getCourseType());
            HashSet<Long> courseIds = (HashSet<Long>)ret.get(courseType);
            if (courseIds == null) {
                courseIds = new HashSet<Long>();
                ret.put(courseType, courseIds);
            }
            courseIds.add(course.getId());
        }
        return ret;
    }

    @Override
    public ArrayListMultimap<Long, Long> getClassStudentIdMap(Long orgId, List<Long> classIds) {
        List orgStudentCourses;
        ArrayListMultimap data = ArrayListMultimap.create();
        if (CollectionUtils.isNotEmpty(classIds) && CollectionUtils.isNotEmpty((Collection)(orgStudentCourses = this.orgStudentCourseDao.getOrgCourseByOrgIdAndIds(orgId, classIds)))) {
            for (OrgStudentCourse orgStudentCourse : orgStudentCourses) {
                data.put((Object)orgStudentCourse.getCourseId(), (Object)orgStudentCourse.getUserId());
            }
        }
        return data;
    }

    @Override
    public int changeNoRealCourseId() {
        List list = this.orgStudentCourseDao.getNoRealCourseIdData();
        log.info("OrgStudentCourseServiceImpl  changeNoRealCourseId == {}", (Object)list);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            Map studentCourseMap = GenericsUtils.toFieldMap((Collection)list, (String[])new String[]{"courseId"});
            Map courseMap = this.orgCourseDao.getOrgCourseMap(studentCourseMap.keySet(), new String[0]);
            for (OrgStudentCourse studentCourse : list) {
                OrgCourse orgCourse = (OrgCourse)courseMap.get(studentCourse.getCourseId());
                if (orgCourse == null) continue;
                if (orgCourse.getCourseType().intValue() == CourseTypeEnum.COURSE_TYPE_1v1.getCode().intValue()) {
                    studentCourse.setRealCourseId(orgCourse.getParentId());
                } else {
                    studentCourse.setRealCourseId(orgCourse.getId());
                }
                this.orgStudentCourseDao.update((Object)studentCourse, new String[]{"realCourseId"});
            }
        }
        return list.size();
    }
}

