/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.student.dto.response.pc;

import com.baijia.tianxiao.dal.org.po.OrgStudent;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignupStudentListDto {
    private static final Logger log = LoggerFactory.getLogger(SignupStudentListDto.class);
    private Long id;
    private String name;
    private String mobile;
    private Long gender;
    private String genderStr;
    private Long birthday;
    private Date birthdayStr;
    private String mail;
    private String studentRemark;
    private String pinyin;

    public static SignupStudentListDto convertToDto(OrgStudent student) {
        SignupStudentListDto dto = new SignupStudentListDto();
        dto.setId(student.getId());
        dto.setName(student.getName());
        dto.setMobile(student.getMobile());
        dto.setGender(student.getGender().longValue());
        if (dto.getGender() == null || dto.getGender() == -1L) {
            dto.setGenderStr("");
        } else {
            dto.setGenderStr(dto.getGender() == 1L ? "\u5973" : "\u7537");
        }
        if (student.getBirthday() != null) {
            dto.setBirthday(student.getBirthday().getTime());
            dto.setBirthdayStr(student.getBirthday());
        }
        dto.setMail(student.getMail());
        dto.setStudentRemark(student.getRemark());
        String pinyin = student.getPinyin();
        if (StringUtils.isBlank((CharSequence)pinyin) || pinyin.charAt(0) <= '9' && pinyin.charAt(0) >= '0') {
            dto.setPinyin("#");
        } else {
            dto.setPinyin(student.getPinyin());
        }
        return dto;
    }

    public Long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getMobile() {
        return this.mobile;
    }

    public Long getGender() {
        return this.gender;
    }

    public String getGenderStr() {
        return this.genderStr;
    }

    public Long getBirthday() {
        return this.birthday;
    }

    public Date getBirthdayStr() {
        return this.birthdayStr;
    }

    public String getMail() {
        return this.mail;
    }

    public String getStudentRemark() {
        return this.studentRemark;
    }

    public String getPinyin() {
        return this.pinyin;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setMobile(String mobile) {
        this.mobile = mobile;
    }

    public void setGender(Long gender) {
        this.gender = gender;
    }

    public void setGenderStr(String genderStr) {
        this.genderStr = genderStr;
    }

    public void setBirthday(Long birthday) {
        this.birthday = birthday;
    }

    public void setBirthdayStr(Date birthdayStr) {
        this.birthdayStr = birthdayStr;
    }

    public void setMail(String mail) {
        this.mail = mail;
    }

    public void setStudentRemark(String studentRemark) {
        this.studentRemark = studentRemark;
    }

    public void setPinyin(String pinyin) {
        this.pinyin = pinyin;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SignupStudentListDto)) {
            return false;
        }
        SignupStudentListDto other = (SignupStudentListDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$mobile = this.getMobile();
        String other$mobile = other.getMobile();
        if (this$mobile == null ? other$mobile != null : !this$mobile.equals(other$mobile)) {
            return false;
        }
        Long this$gender = this.getGender();
        Long other$gender = other.getGender();
        if (this$gender == null ? other$gender != null : !((Object)this$gender).equals(other$gender)) {
            return false;
        }
        String this$genderStr = this.getGenderStr();
        String other$genderStr = other.getGenderStr();
        if (this$genderStr == null ? other$genderStr != null : !this$genderStr.equals(other$genderStr)) {
            return false;
        }
        Long this$birthday = this.getBirthday();
        Long other$birthday = other.getBirthday();
        if (this$birthday == null ? other$birthday != null : !((Object)this$birthday).equals(other$birthday)) {
            return false;
        }
        Date this$birthdayStr = this.getBirthdayStr();
        Date other$birthdayStr = other.getBirthdayStr();
        if (this$birthdayStr == null ? other$birthdayStr != null : !((Object)this$birthdayStr).equals(other$birthdayStr)) {
            return false;
        }
        String this$mail = this.getMail();
        String other$mail = other.getMail();
        if (this$mail == null ? other$mail != null : !this$mail.equals(other$mail)) {
            return false;
        }
        String this$studentRemark = this.getStudentRemark();
        String other$studentRemark = other.getStudentRemark();
        if (this$studentRemark == null ? other$studentRemark != null : !this$studentRemark.equals(other$studentRemark)) {
            return false;
        }
        String this$pinyin = this.getPinyin();
        String other$pinyin = other.getPinyin();
        return !(this$pinyin == null ? other$pinyin != null : !this$pinyin.equals(other$pinyin));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SignupStudentListDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $mobile = this.getMobile();
        result = result * 59 + ($mobile == null ? 43 : $mobile.hashCode());
        Long $gender = this.getGender();
        result = result * 59 + ($gender == null ? 43 : ((Object)$gender).hashCode());
        String $genderStr = this.getGenderStr();
        result = result * 59 + ($genderStr == null ? 43 : $genderStr.hashCode());
        Long $birthday = this.getBirthday();
        result = result * 59 + ($birthday == null ? 43 : ((Object)$birthday).hashCode());
        Date $birthdayStr = this.getBirthdayStr();
        result = result * 59 + ($birthdayStr == null ? 43 : ((Object)$birthdayStr).hashCode());
        String $mail = this.getMail();
        result = result * 59 + ($mail == null ? 43 : $mail.hashCode());
        String $studentRemark = this.getStudentRemark();
        result = result * 59 + ($studentRemark == null ? 43 : $studentRemark.hashCode());
        String $pinyin = this.getPinyin();
        result = result * 59 + ($pinyin == null ? 43 : $pinyin.hashCode());
        return result;
    }

    public String toString() {
        return "SignupStudentListDto(id=" + this.getId() + ", name=" + this.getName() + ", mobile=" + this.getMobile() + ", gender=" + this.getGender() + ", genderStr=" + this.getGenderStr() + ", birthday=" + this.getBirthday() + ", birthdayStr=" + this.getBirthdayStr() + ", mail=" + this.getMail() + ", studentRemark=" + this.getStudentRemark() + ", pinyin=" + this.getPinyin() + ")";
    }
}

