/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.student.impl;

import com.baijia.tianxiao.constants.CourseType;
import com.baijia.tianxiao.constants.PayStatus;
import com.baijia.tianxiao.dal.enums.CourseTypeEnum;
import com.baijia.tianxiao.dal.org.constant.DeleteStatus;
import com.baijia.tianxiao.dal.org.dao.CoursePurchaseDao;
import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.dao.OrgClassLessonDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.po.CoursePurchase;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.org.po.OrgCourse;
import com.baijia.tianxiao.dal.org.po.OrgStudent;
import com.baijia.tianxiao.dal.org.po.OrgStudentCourse;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupCourseDao;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupInfoDao;
import com.baijia.tianxiao.dal.signup.po.OrgSignupCourse;
import com.baijia.tianxiao.dal.signup.po.OrgSignupInfo;
import com.baijia.tianxiao.dal.solr.po.StudentClassHour;
import com.baijia.tianxiao.dal.solr.query.CrmStudentQuery;
import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.enums.StudentCourseStatus;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sal.student.api.OrgStudentCourseService;
import com.baijia.tianxiao.sal.student.dto.request.StudentCommenRequestDto;
import com.baijia.tianxiao.sal.student.dto.response.OrgStudentPurchaseReponseDto;
import com.baijia.tianxiao.sal.student.dto.response.StudentCourseInfoReponseDto;
import com.baijia.tianxiao.sal.student.enums.StudentErrorCode;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OrgStudentCourseServiceImpl
implements OrgStudentCourseService {
    private static final Logger log = LoggerFactory.getLogger(OrgStudentCourseServiceImpl.class);
    @Autowired
    private OrgStudentDao orgStudentsDao;
    @Autowired
    private OrgCourseDao orgCourseDao;
    @Autowired
    private OrgAccountDao orgAccountDao;
    @Autowired
    private OrgSignupInfoDao orgSignupInfoDao;
    @Autowired
    private OrgSignupCourseDao orgSignupCourseDao;
    @Autowired
    private OrgStudentCourseDao orgStudentCourseDao;
    @Autowired
    private OrgClassLessonDao orgClassLessonDao;
    @Autowired
    private CoursePurchaseDao coursePurchaseDao;
    @Autowired(required=false)
    private CrmStudentQuery crmStudentQuery;

    @Override
    public List<StudentCourseInfoReponseDto> getCurrentStudnetCourseInfos(StudentCommenRequestDto studentCommenRequestDto, Long orgId) {
        OrgAccount account = (OrgAccount)this.orgAccountDao.getById((Serializable)orgId, new String[0]);
        if (account == null) {
            throw new BussinessException((UniverseErrorCode)StudentErrorCode.ORG_NOT_EXIST);
        }
        if (studentCommenRequestDto.getStudentId() == null) {
            log.warn("error: studentId is null!");
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR);
        }
        OrgStudent orgStudent = (OrgStudent)this.orgStudentsDao.getById((Serializable)studentCommenRequestDto.getStudentId(), new String[0]);
        if (orgStudent == null || orgStudent.getDelStatus().intValue() == DeleteStatus.DELETED.getValue() || orgStudent.getOrgId().longValue() != orgId.longValue()) {
            throw new BussinessException((UniverseErrorCode)StudentErrorCode.STUDENT_NOT_EXIST);
        }
        List courseList = this.orgStudentCourseDao.getOrgCourseIds(orgId, orgStudent.getUserId(), Integer.valueOf(StudentCourseStatus.NORMAL.getCode()), null);
        List classHourList = null;
        try {
            classHourList = this.crmStudentQuery.queryStudentClassHourList(orgStudent.getUserId(), orgId);
        }
        catch (Exception e) {
            log.error("[Solr] Query exception.", (Throwable)e);
        }
        Map<Long, StudentCourseInfoReponseDto> map = this.reviseClassHourCount(courseList, classHourList);
        HashMap<Long, StudentClassHour> studentClassHourMap = new HashMap<Long, StudentClassHour>();
        if (classHourList != null) {
            for (StudentClassHour studentClassHour : classHourList) {
                studentClassHourMap.put(studentClassHour.getCourseId(), studentClassHour);
            }
        }
        ArrayList<StudentCourseInfoReponseDto> retList = new ArrayList<StudentCourseInfoReponseDto>();
        for (Map.Entry<Long, StudentCourseInfoReponseDto> entry : map.entrySet()) {
            Long courseId = entry.getKey();
            StudentClassHour sch = (StudentClassHour)studentClassHourMap.get(courseId);
            log.info("find a studentClassHour instance : {} and studentCourseInfoResponseDto is : {} ", (Object)sch, (Object)entry.getValue());
            if (entry.getValue().getStatus() != StudentCourseStatus.NORMAL.getCode()) continue;
            if (sch != null) {
                if (sch.getTotalCount() <= sch.getFinishCount()) continue;
                this.setClassHour(entry.getValue(), sch);
                retList.add(entry.getValue());
                continue;
            }
            retList.add(entry.getValue());
        }
        return retList;
    }

    private Map<Long, StudentCourseInfoReponseDto> reviseClassHourCount(List<OrgStudentCourse> courseList, List<StudentClassHour> classHourList) {
        LinkedHashMap<Long, StudentCourseInfoReponseDto> map = new LinkedHashMap<Long, StudentCourseInfoReponseDto>();
        HashMap<Long, OrgStudentCourse> studentCourseMap = new HashMap<Long, OrgStudentCourse>();
        if (courseList == null || courseList.size() < 1) {
            return map;
        }
        for (OrgStudentCourse course : courseList) {
            studentCourseMap.put(course.getCourseId(), course);
        }
        log.info("find all courseIds is : {} ", studentCourseMap.keySet());
        List courses = this.orgCourseDao.getByIds(studentCourseMap.keySet(), new String[0]);
        HashSet parentCourseIds = Sets.newHashSet();
        for (OrgCourse orgCourse : courses) {
            if (orgCourse.getParentId() <= 0L) continue;
            parentCourseIds.add(orgCourse.getParentId());
        }
        Map parentCourseMap = Maps.newHashMap();
        if (parentCourseIds.size() > 0) {
            parentCourseMap = this.orgCourseDao.getOrgCourseMap((Collection)parentCourseIds);
        }
        HashSet<Long> oneToOneCourseIds = new HashSet<Long>();
        if (courses != null) {
            for (OrgCourse course : courses) {
                OrgCourse parentCourse;
                StudentCourseInfoReponseDto dto = StudentCourseInfoReponseDto.getInstance(course);
                if (dto.getParentId() > 0L && (parentCourse = (OrgCourse)parentCourseMap.get(dto.getParentId())) != null) {
                    dto.setCourseNumber(parentCourse.getNumber());
                }
                OrgStudentCourse studentCourse = (OrgStudentCourse)studentCourseMap.get(course.getId());
                dto.setStatus(studentCourse.getStatus());
                if (CourseTypeEnum.isOneToOne((Integer)course.getCourseType())) {
                    oneToOneCourseIds.add(course.getId());
                    if (studentCourse.getStatus().intValue() == StudentCourseStatus.NORMAL.getCode()) {
                        dto.setTotalClassTimes(studentCourse.getLessonCount());
                        dto.setLeftClassTimes(studentCourse.getLessonCount());
                    } else {
                        log.info("[StudentCourse] studentCourse={}", (Object)studentCourse);
                    }
                }
                map.put(course.getId(), dto);
            }
        }
        for (StudentClassHour classHour : classHourList) {
            log.info("[StudentCourse] oneToOneCourseIds={},classHourCourseId={},keySet={}", new Object[]{oneToOneCourseIds, classHour.getCourseId(), studentCourseMap.keySet()});
            OrgStudentCourse studentCourse = (OrgStudentCourse)studentCourseMap.get(classHour.getCourseId());
            log.info("[StudentCourse] studentCourse={},courseId={}", (Object)studentCourse, (Object)classHour.getCourseId());
            if (oneToOneCourseIds.contains(classHour.getCourseId()) && studentCourse != null) {
                classHour.setTotalCount(Math.max(studentCourse.getLessonCount(), classHour.getTotalCount()));
            }
            if (studentCourse == null || studentCourse.getStatus().intValue() == StudentCourseStatus.NORMAL.getCode()) continue;
            classHour.setTotalCount(classHour.getFinishCount());
            log.info("[StudentCourse] studentCourse={}", (Object)classHour);
        }
        return map;
    }

    public static void main(String[] args) {
        HashSet<Long> oneToOneCourseIds = new HashSet<Long>();
        Long a = new Long(100000L);
        oneToOneCourseIds.add(a);
        System.out.println(oneToOneCourseIds.contains(100000L));
    }

    @Override
    public List<StudentCourseInfoReponseDto> getHistoryStudnetCourseInfos(StudentCommenRequestDto studentCommenRequestDto, Long orgId) {
        OrgAccount account = (OrgAccount)this.orgAccountDao.getById((Serializable)orgId, new String[0]);
        if (account == null) {
            throw new BussinessException((UniverseErrorCode)StudentErrorCode.ORG_NOT_EXIST);
        }
        if (studentCommenRequestDto.getStudentId() == null) {
            log.warn("error: studentId is null!");
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR);
        }
        OrgStudent orgStudent = (OrgStudent)this.orgStudentsDao.getById((Serializable)studentCommenRequestDto.getStudentId(), new String[0]);
        if (orgStudent == null || orgStudent.getDelStatus().intValue() == DeleteStatus.DELETED.getValue() || orgStudent.getOrgId().longValue() != orgId.longValue()) {
            throw new BussinessException((UniverseErrorCode)StudentErrorCode.STUDENT_NOT_EXIST);
        }
        List courseList = this.orgStudentCourseDao.getOrgCourseIds(orgId, orgStudent.getUserId(), null, null);
        List classHourList = null;
        try {
            classHourList = this.crmStudentQuery.queryStudentClassHourList(orgStudent.getUserId(), orgId);
        }
        catch (Exception e) {
            log.error("[Solr] Query exception.", (Throwable)e);
        }
        Map<Long, StudentCourseInfoReponseDto> map = this.reviseClassHourCount(courseList, classHourList);
        HashMap<Long, StudentClassHour> studentClassHourMap = new HashMap<Long, StudentClassHour>();
        if (classHourList != null) {
            for (StudentClassHour studentClassHour : classHourList) {
                studentClassHourMap.put(studentClassHour.getCourseId(), studentClassHour);
            }
        }
        ArrayList<StudentCourseInfoReponseDto> retList = new ArrayList<StudentCourseInfoReponseDto>();
        for (Map.Entry<Long, StudentCourseInfoReponseDto> entry : map.entrySet()) {
            Long courseId = entry.getKey();
            StudentClassHour sch = (StudentClassHour)studentClassHourMap.get(courseId);
            log.info("find a studentClassHour instance : {} and studentCourseInfoResponseDto is : {} ", (Object)sch, (Object)entry.getValue());
            if (entry.getValue().getStatus() != StudentCourseStatus.NORMAL.getCode()) {
                retList.add(entry.getValue());
                if (sch == null) continue;
                this.setClassHour(entry.getValue(), sch);
                continue;
            }
            if (sch == null || (sch.getLeftCount() > 0 || sch.getFinishCount() == 0) && entry.getValue().getStatus() == StudentCourseStatus.NORMAL.getCode()) continue;
            this.setClassHour(entry.getValue(), sch);
            retList.add(entry.getValue());
        }
        map.clear();
        return retList;
    }

    private StudentCourseInfoReponseDto setClassHour(StudentCourseInfoReponseDto dto, StudentClassHour classHour) {
        dto.setFinishClassTimes(classHour.getFinishCount());
        dto.setTotalClassTimes(classHour.getTotalCount());
        dto.setLeftClassTimes(dto.getTotalClassTimes() - dto.getFinishClassTimes());
        dto.setCourseType(CourseType.ORG_COURSE.getCode());
        return dto;
    }

    @Override
    public List<OrgStudentPurchaseReponseDto> getStudentPurchases(StudentCommenRequestDto studentCommenRequestDto, Long orgId) {
        OrgAccount account = (OrgAccount)this.orgAccountDao.getById((Serializable)orgId, new String[0]);
        if (account == null) {
            throw new BussinessException((UniverseErrorCode)StudentErrorCode.ORG_NOT_EXIST);
        }
        if (studentCommenRequestDto.getStudentId() == null) {
            log.warn("error: studentId is null!");
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR);
        }
        OrgStudent orgStudent = (OrgStudent)this.orgStudentsDao.getById((Serializable)studentCommenRequestDto.getStudentId(), new String[0]);
        if (orgStudent == null || orgStudent.getDelStatus().intValue() == DeleteStatus.DELETED.getValue() || orgStudent.getOrgId().longValue() != orgId.longValue()) {
            throw new BussinessException((UniverseErrorCode)StudentErrorCode.STUDENT_NOT_EXIST);
        }
        return this.getStudentSignupInfos(orgStudent, account.getNumber().longValue());
    }

    @Override
    public int getStudentSignupCourse(OrgStudent po, Long orgNumber) {
        List<StudentCourseInfoReponseDto> result = this.getCourseInfoes(po, orgNumber);
        return result != null && !result.isEmpty() ? result.size() : 0;
    }

    private List<StudentCourseInfoReponseDto> getCourseInfoes(OrgStudent po, Long orgNumber) {
        StudentCourseInfoReponseDto dto;
        ArrayList courseDtos = Lists.newArrayList();
        List cashpurchase = this.orgSignupInfoDao.getPurchases(po.getUserId(), orgNumber, null, Integer.valueOf(PayStatus.SUCESS.getCode()), new String[]{"totalPrices", "signupPurchaseId"});
        List mPurchase = this.coursePurchaseDao.getCoursePurchaseList(po.getOrgId(), po.getUserId(), Long.valueOf(0L), Integer.valueOf(CourseType.ORG_COURSE.getCode()), Integer.valueOf(PayStatus.SUCESS.getCode()), new String[0]);
        HashSet courseIds = Sets.newHashSet();
        HashSet purchaseIds = Sets.newHashSet();
        for (Object orgSignupInfo : cashpurchase) {
            purchaseIds.add(orgSignupInfo.getSignupPurchaseId());
        }
        List sinupCourses = this.orgSignupCourseDao.loadByPurchaseIds((Collection)purchaseIds, new String[0]);
        for (OrgSignupCourse orgSignupCourse : sinupCourses) {
            courseIds.add(orgSignupCourse.getOrgCourseId());
        }
        for (CoursePurchase coursePurchase : mPurchase) {
            courseIds.add(coursePurchase.getCourseId());
        }
        Map nameMap = this.orgCourseDao.getCourseNameMap((Collection)courseIds);
        Map lessonTimeMap = this.orgClassLessonDao.getLessonTimemap((Collection)courseIds, null, po.getOrgId(), Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        Map finishLessonTimeMap = this.orgClassLessonDao.getLessonTimemap((Collection)courseIds, new Date(), po.getOrgId(), Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        for (OrgSignupCourse purchase : sinupCourses) {
            dto = new StudentCourseInfoReponseDto();
            dto.setCourseId(purchase.getOrgCourseId());
            dto.setCourseNumber((long)purchase.getOrgCourseNumber());
            dto.setCourseType(CourseType.ORG_COURSE.getCode());
            dto.setCourseName((String)nameMap.get(purchase.getOrgCourseId()));
            if (lessonTimeMap.get(purchase.getOrgCourseId()) != null) {
                dto.setTotalClassTimes((Integer)lessonTimeMap.get(purchase.getOrgCourseId()));
            } else {
                dto.setTotalClassTimes(0);
            }
            if (finishLessonTimeMap.get(purchase.getOrgCourseId()) != null) {
                dto.setFinishClassTimes((Integer)finishLessonTimeMap.get(purchase.getOrgCourseId()));
            } else {
                dto.setFinishClassTimes(0);
            }
            dto.setLeftClassTimes(dto.getTotalClassTimes() - dto.getFinishClassTimes());
            courseDtos.add(dto);
        }
        for (OrgSignupCourse purchase : mPurchase) {
            dto = new StudentCourseInfoReponseDto();
            dto.setCourseId(purchase.getCourseId());
            dto.setCourseNumber((long)purchase.getCourseNumber());
            dto.setCourseType(CourseType.ORG_COURSE.getCode());
            dto.setCourseName((String)nameMap.get(purchase.getCourseId()));
            if (lessonTimeMap.get(purchase.getCourseId()) != null) {
                dto.setTotalClassTimes((Integer)lessonTimeMap.get(purchase.getCourseId()));
            } else {
                dto.setTotalClassTimes(0);
            }
            if (finishLessonTimeMap.get(purchase.getCourseId()) != null) {
                dto.setFinishClassTimes((Integer)finishLessonTimeMap.get(purchase.getCourseId()));
            } else {
                dto.setFinishClassTimes(0);
            }
            dto.setLeftClassTimes(dto.getTotalClassTimes() - dto.getFinishClassTimes());
            courseDtos.add(dto);
        }
        log.debug("course list={}", (Object)courseDtos);
        return courseDtos;
    }

    private List<OrgStudentPurchaseReponseDto> getStudentSignupInfos(OrgStudent po, Long orgNumber) {
        ArrayList courseDtos = Lists.newArrayList();
        List cashpurchase = this.orgSignupInfoDao.getPurchases(po.getUserId(), orgNumber, null, Integer.valueOf(PayStatus.SUCESS.getCode()), new String[]{"totalPrices", "signupPurchaseId"});
        List mPurchase = this.coursePurchaseDao.getCoursePurchaseList(po.getOrgId(), po.getUserId(), Long.valueOf(0L), Integer.valueOf(CourseType.ORG_COURSE.getCode()), Integer.valueOf(PayStatus.SUCESS.getCode()), new String[0]);
        HashSet courseIds = Sets.newHashSet();
        HashSet purchaseIds = Sets.newHashSet();
        for (OrgSignupInfo orgSignupInfo : cashpurchase) {
            purchaseIds.add(orgSignupInfo.getSignupPurchaseId());
        }
        for (CoursePurchase coursePurchase : mPurchase) {
            courseIds.add(coursePurchase.getCourseId());
        }
        Map nameMap = this.orgCourseDao.getCourseNameMap((Collection)courseIds);
        if (CollectionUtils.isNotEmpty((Collection)purchaseIds)) {
            List sinupCourses = this.orgSignupCourseDao.loadByPurchaseIds((Collection)purchaseIds, new String[0]);
            for (OrgSignupCourse purchase : sinupCourses) {
                OrgStudentPurchaseReponseDto dto = new OrgStudentPurchaseReponseDto();
                dto.setCourseNumber((long)purchase.getOrgCourseNumber());
                dto.setCourseName((String)nameMap.get(purchase.getOrgCourseId()));
                dto.setPayMoney(purchase.getPayPrice().doubleValue() / 100.0);
                courseDtos.add(dto);
            }
        }
        for (CoursePurchase purchase : mPurchase) {
            OrgStudentPurchaseReponseDto dto = new OrgStudentPurchaseReponseDto();
            dto.setCourseNumber((long)purchase.getCourseNumber());
            dto.setCourseName((String)nameMap.get(purchase.getCourseId()));
            dto.setPayMoney((double)purchase.getPayMoney());
            courseDtos.add(dto);
        }
        return courseDtos;
    }

    @Override
    public List<StudentCourseInfoReponseDto> getCurrentClassInfos(Long orgId, Long StudentId, PageDto page) {
        return null;
    }

    @Override
    public List<StudentCourseInfoReponseDto> getHistoryClassInfos(Long orgId, Long StudentId, PageDto page) {
        return null;
    }

    @Override
    public OrgStudentCourse getBySidAndCid(Long orgId, Long studentId, Long courseId) {
        return this.orgStudentCourseDao.getStudentCourse(orgId, courseId, studentId);
    }

    @Override
    public void saveOrgStudentCourse(OrgStudentCourse orgStudentCourse) {
        this.orgStudentCourseDao.save((Object)orgStudentCourse, new String[0]);
    }

    @Override
    public void updateOrgStudentCourse(OrgStudentCourse orgStudentCourse) {
        this.orgStudentCourseDao.update((Object)orgStudentCourse, new String[0]);
    }

    @Override
    public void splitCourseIdsByType(Collection<Long> allIds, Set<Long> oneToOneCourseIds, Set<Long> classCourseIds) {
        List courseList = this.orgCourseDao.getByIds(allIds, new String[]{"courseType", "id"});
        for (OrgCourse course : courseList) {
            if (CourseTypeEnum.isOneToOne((Integer)course.getCourseType())) {
                oneToOneCourseIds.add(course.getId());
                continue;
            }
            classCourseIds.add(course.getId());
        }
    }

    @Override
    public ArrayListMultimap<Long, Long> getClassStudentIdMap(Long orgId, List<Long> classIds) {
        List orgStudentCourses;
        ArrayListMultimap data = ArrayListMultimap.create();
        if (CollectionUtils.isNotEmpty(classIds) && CollectionUtils.isNotEmpty((Collection)(orgStudentCourses = this.orgStudentCourseDao.getOrgCourseByOrgIdAndIds(orgId, classIds)))) {
            for (OrgStudentCourse orgStudentCourse : orgStudentCourses) {
                data.put((Object)orgStudentCourse.getCourseId(), (Object)orgStudentCourse.getUserId());
            }
        }
        return data;
    }
}

