/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.student.pc.impl;

import com.baijia.tianxiao.common.service.ImportDataProcessService;
import com.baijia.tianxiao.constants.DataProcType;
import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.enums.CrmErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sal.student.dto.response.pc.StudentListResponseDto;
import com.baijia.tianxiao.sal.student.pc.StudentUserService;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ImportStudentServiceImpl
implements ImportDataProcessService {
    private static final Logger log = LoggerFactory.getLogger(ImportStudentServiceImpl.class);
    private static final Map<String, Map<String, Object>> cache = Maps.newHashMap();
    private static final ImportDataProcessService.SingleSaveErrorResult IMPORT_SUCCESS = new ImportDataProcessService.SingleSaveErrorResult(false, "\u5bfc\u5165\u6210\u529f!");
    private static final ImportDataProcessService.SingleSaveErrorResult STUDENT_EXSIST = new ImportDataProcessService.SingleSaveErrorResult(true, "\u5b66\u5458\u6863\u6848\u5df2\u5b58\u5728");
    @Autowired
    private StudentUserService studentUserService;

    public DataProcType getProcessType() {
        return DataProcType.ORG_STUDENT;
    }

    public boolean validateHeader(List<String> headers) {
        if (CollectionUtils.isEmpty(headers)) {
            return false;
        }
        int index = 0;
        for (String header : headers) {
            if (!cache.containsKey(header.trim())) {
                return false;
            }
            Map<String, Object> item = cache.get(header);
            int sequence = (Integer)item.get("index");
            if (index != sequence) {
                return false;
            }
            ++index;
        }
        return true;
    }

    public ImportDataProcessService.SingleSaveErrorResult saveSingleData(Long orgId, List<String> headers, Object[] lineData, boolean updateRepeat) {
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"illegal orgId.");
        Preconditions.checkArgument((lineData != null && lineData.length > 0 ? 1 : 0) != 0, (Object)"lineData \u4e3a\u7a7a");
        try {
            StudentListResponseDto studentInfo = new StudentListResponseDto();
            this.buildOrgCourseInfoDto(studentInfo, lineData, headers);
            this.studentUserService.addStudentInfo(orgId, studentInfo);
        }
        catch (BussinessException ex) {
            if (ex.getErrorCode().getSubsystemErrorCode() == CrmErrorCode.STUDENT_HAS_EXISTS.getSubsystemErrorCode()) {
                return STUDENT_EXSIST;
            }
            log.warn("save clue error:{}", (Throwable)ex);
            throw ex;
        }
        catch (Exception ex) {
            log.warn("save clue error:{}", (Throwable)ex);
            throw new BussinessException((UniverseErrorCode)CrmErrorCode.HANDLER_FAILED);
        }
        return IMPORT_SUCCESS;
    }

    private void buildOrgCourseInfoDto(StudentListResponseDto dto, Object[] lineData, List<String> headers) {
        Preconditions.checkArgument((lineData.length == headers.size() ? 1 : 0) != 0, (Object)"\u6570\u636e\u6570\u76ee\u548c\u8868\u5934\u4e0d\u5339\u914d");
        Preconditions.checkArgument((boolean)this.validateHeader(headers), (Object)("\u8868\u5934\u683c\u5f0f\u9519\u8bef:" + headers.toString()));
        for (int i = 0; i < lineData.length; ++i) {
            String fieldName = cache.get(headers.get(i)).get("propName").toString();
            boolean empty = Boolean.parseBoolean(cache.get(headers.get(i)).get("empty").toString());
            String name = headers.get(i);
            Object value = lineData[i];
            if (fieldName == null) continue;
            if (!empty && value == null) {
                throw new BussinessException((UniverseErrorCode)CrmErrorCode.FORMAT_ERROR, "\u3010" + name + "\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            try {
                if (value == null || value instanceof String && StringUtils.isBlank((CharSequence)((String)value))) continue;
                BeanUtils.setProperty((Object)dto, (String)fieldName, (Object)value);
                continue;
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                log.warn("set ConsultInfoResponseDto.{} = {} failed!", (Object)fieldName, value);
                throw new BussinessException((UniverseErrorCode)CrmErrorCode.FORMAT_ERROR);
            }
        }
    }

    public ImportDataProcessService.BatchSaveResult batchImportDatas(Long orgId, List<String> headers, List<Object[]> datas, boolean updateRepeat) {
        ImportDataProcessService.BatchSaveResult batchSaveResult = new ImportDataProcessService.BatchSaveResult();
        for (int i = 0; i < datas.size(); ++i) {
            Object[] data = datas.get(i);
            try {
                ImportDataProcessService.SingleSaveErrorResult singleSaveErrorResult = this.saveSingleData(orgId, headers, data, updateRepeat);
                if (!singleSaveErrorResult.isRepeat()) continue;
                batchSaveResult.getRepeatIndexs().add(i);
                continue;
            }
            catch (Throwable ex) {
                batchSaveResult.getFailIndexs().add(i);
            }
        }
        return batchSaveResult;
    }

    static {
        ResourceBundle rs = ResourceBundle.getBundle("upload");
        String header = rs.getString("upload.student.header");
        if (StringUtils.isNotBlank((CharSequence)header) && header.contains(":")) {
            String[] cells = header.split(",");
            int index = 0;
            HashMap subMap = null;
            for (String cell : cells) {
                subMap = Maps.newHashMap();
                String[] column = cell.split(":");
                String name = column[0].trim();
                String propName = column[1];
                boolean empty = Boolean.parseBoolean(column[2]);
                subMap.put("propName", propName);
                subMap.put("index", index);
                subMap.put("empty", empty);
                cache.put(name, subMap);
                ++index;
            }
        }
    }
}

