/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.student.pc.impl;

import com.baijia.tianxiao.annotation.Option;
import com.baijia.tianxiao.annotation.Snippet;
import com.baijia.tianxiao.constants.org.BizConf;
import com.baijia.tianxiao.dal.org.constant.DeleteStatus;
import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.org.po.OrgStudent;
import com.baijia.tianxiao.dal.roster.constant.AddType;
import com.baijia.tianxiao.dal.roster.dao.TxConsultUserDao;
import com.baijia.tianxiao.dal.roster.dao.TxStudentCommentDao;
import com.baijia.tianxiao.dal.roster.dao.TxStudentTagDao;
import com.baijia.tianxiao.dal.roster.po.TxConsultUser;
import com.baijia.tianxiao.dal.roster.po.TxStudentComment;
import com.baijia.tianxiao.dal.todo.dao.TxBacklogDao;
import com.baijia.tianxiao.dal.todo.po.TxBacklog;
import com.baijia.tianxiao.dal.util.AreaUtils;
import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.dto.query.AutoMatchQueryRequest;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.enums.CrmErrorCode;
import com.baijia.tianxiao.enums.SortPolicy;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sal.student.dto.request.pc.StudentSearchRequestDto;
import com.baijia.tianxiao.sal.student.dto.response.pc.StudentInfoResponseDto;
import com.baijia.tianxiao.sal.student.dto.response.pc.StudentListResponseDto;
import com.baijia.tianxiao.sal.student.pc.StudentUserService;
import com.baijia.tianxiao.sal.student.util.OrgStudentUtil;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.util.BaseUtils;
import com.baijia.tianxiao.util.date.DateUtil;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class StudentUserServiceImpl
implements StudentUserService {
    private static final Logger log = LoggerFactory.getLogger(StudentUserServiceImpl.class);
    @Resource
    private OrgStudentDao orgStudentDao;
    @Resource
    private OrgAccountDao orgAccountDao;
    @Autowired
    private TxConsultUserDao txConsultUserDao;
    @Autowired
    private TxBacklogDao txBacklogDao;
    @Autowired
    private TxStudentCommentDao txStudentCommentDao;
    @Autowired
    private TxStudentTagDao txStudentTagDao;

    @Override
    public StudentInfoResponseDto getBaseInfo(Long orgId, Long studentId) throws Exception {
        if (null == orgId || orgId <= 0L || null == studentId || studentId <= 0L) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR);
        }
        OrgAccount account = (OrgAccount)this.orgAccountDao.getById((Serializable)orgId, new String[0]);
        if (account == null) {
            throw new BussinessException((UniverseErrorCode)CrmErrorCode.ORG_NOT_EXIST);
        }
        OrgStudent orgStudent = (OrgStudent)this.orgStudentDao.getById((Serializable)studentId, new String[0]);
        if (null == orgStudent || orgStudent.getDelStatus().intValue() == DeleteStatus.DELETED.getValue() || orgStudent.getOrgId().longValue() != orgId.longValue()) {
            throw new BussinessException((UniverseErrorCode)CrmErrorCode.CONSULTER_NOT_EXISTS);
        }
        StudentInfoResponseDto baseInfoDto = new StudentInfoResponseDto();
        this.studentPo2Dto(orgStudent, baseInfoDto);
        log.info("getBaseInfo---------baseInfoDto={}", (Object)baseInfoDto);
        return baseInfoDto;
    }

    @Override
    @Transactional(rollbackFor={Exception.class, BussinessException.class})
    public Long addStudentInfo(Long orgId, StudentListResponseDto studentInfo) throws Exception {
        if (null == orgId || orgId <= 0L || null == studentInfo) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR);
        }
        this.doSaveBefore(orgId, studentInfo);
        Map<String, Long> userInfoMap = OrgStudentUtil.getUserIdAndNumber(studentInfo.getName());
        Long userId = userInfoMap.get("id");
        OrgStudent orgStudent = new OrgStudent();
        this.studentDto2Po(studentInfo, orgStudent, orgId, userId);
        this.orgStudentDao.save((Object)orgStudent, Boolean.valueOf(false), new String[0]);
        log.info("addStudentInfo---------orgStudent={}", (Object)orgStudent);
        return orgStudent.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class, BussinessException.class})
    public Long addStudentInfo(Long orgId, StudentListResponseDto studentInfo, boolean updateRepeat) throws Exception {
        if (null == orgId || orgId <= 0L || null == studentInfo) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR);
        }
        log.info("orgId:{}, studentInfo:{}, updateRepeat:{}", new Object[]{orgId, studentInfo, updateRepeat});
        Long userId = null;
        OrgStudent orgStudent = null;
        if (updateRepeat) {
            orgStudent = this.orgStudentDao.getStudentByMobileAndName(orgId, studentInfo.getMobile(), studentInfo.getName());
            if (orgStudent == null) {
                Map<String, Long> userInfoMap = OrgStudentUtil.getUserIdAndNumber(studentInfo.getName());
                userId = userInfoMap.get("id");
                orgStudent = new OrgStudent();
            } else {
                userId = orgStudent.getUserId();
                studentInfo.setId(orgStudent.getId());
            }
        } else {
            this.doSaveBefore(orgId, studentInfo);
            Map<String, Long> userInfoMap = OrgStudentUtil.getUserIdAndNumber(studentInfo.getName());
            userId = userInfoMap.get("id");
            orgStudent = new OrgStudent();
        }
        this.studentDto2Po(studentInfo, orgStudent, orgId, userId);
        if (orgStudent.getId() != null && orgStudent.getId() > 0L) {
            this.orgStudentDao.update((Object)orgStudent, new String[0]);
        } else {
            this.orgStudentDao.save((Object)orgStudent, Boolean.valueOf(false), new String[0]);
        }
        log.info("addStudentInfo---------orgStudent={}", (Object)orgStudent);
        return orgStudent.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class, BussinessException.class})
    public void editStudentInfo(Long orgId, StudentListResponseDto studentInfo) throws Exception {
        if (null == orgId || orgId <= 0L || null == studentInfo || null == studentInfo.getId() || studentInfo.getId() <= 0L) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR);
        }
        OrgStudent orgStudent = (OrgStudent)this.orgStudentDao.getById((Serializable)studentInfo.getId(), new String[0]);
        if (orgStudent == null || orgStudent.getDelStatus().intValue() == DeleteStatus.DELETED.getValue() || orgStudent.getOrgId().longValue() != orgId.longValue()) {
            throw new BussinessException((UniverseErrorCode)CrmErrorCode.STUDENT_NOT_EXISTS);
        }
        this.doSaveBefore(orgId, studentInfo);
        this.checkAndCreateComment(studentInfo, orgStudent);
        this.cascadeUpdateTxConsulter(orgId, orgStudent, studentInfo);
        this.studentDto2Po(studentInfo, orgStudent, orgId, null);
        this.orgStudentDao.update((Object)orgStudent, Boolean.valueOf(false), new String[0]);
        log.info("editStudentInfo---------orgStudent={}", (Object)orgStudent);
    }

    @Override
    @Transactional(rollbackFor={Exception.class, BussinessException.class})
    public void BatchDelStudent(Long orgId, Set<Long> studentIds) {
        if (CollectionUtils.isEmpty(studentIds)) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR);
        }
        List list = this.orgStudentDao.getStudentByIds(orgId, studentIds, new String[0]);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            for (OrgStudent orgStudent : list) {
                if (orgStudent.getDelStatus().intValue() != DeleteStatus.NORMAL.getValue()) continue;
                List consultUserList = this.txConsultUserDao.lookByStudentId(orgId, orgStudent.getId(), new String[0]);
                log.info("delStudent--------consultUserList={}", (Object)consultUserList);
                if (null != consultUserList && !consultUserList.isEmpty()) {
                    this.delSysBacklog(orgId, orgStudent, (TxConsultUser)consultUserList.get(0));
                    for (TxConsultUser consulterUser : consultUserList) {
                        consulterUser.setStudentId(Long.valueOf(0L));
                        this.txConsultUserDao.update((Object)consulterUser, new String[]{"studentId"});
                    }
                } else {
                    this.delSysBacklog(orgId, orgStudent, null);
                }
                orgStudent.setDelStatus(Integer.valueOf(DeleteStatus.DELETED.getValue()));
                TxStudentComment comment = new TxStudentComment();
                comment.setContent("\u673a\u6784\u5220\u9664\u5b66\u5458");
                comment.setUserId(orgStudent.getUserId());
                comment.setOrgId(orgStudent.getOrgId());
                comment.setIsSystem(Integer.valueOf(AddType.SYSTEM.getCode()));
                this.txStudentCommentDao.save((Object)comment, new String[0]);
                this.txStudentTagDao.delTags(orgStudent.getUserId(), orgId);
                this.orgStudentDao.update((Object)orgStudent, new String[]{"delStatus"});
            }
        }
    }

    private void studentPo2Dto(OrgStudent po, StudentInfoResponseDto dto) throws IllegalAccessException, InvocationTargetException {
        BeanUtils.copyProperties((Object)dto, (Object)po);
        log.info("StudentPo2Dto---------po={},dto={}", (Object)ToStringBuilder.reflectionToString((Object)po), (Object)dto);
        if (po.getBirthday() != null) {
            dto.setBirthday(po.getBirthday().getTime());
        }
        if (po.getNextRemindTime() != null) {
            dto.setNextRemindTime(po.getNextRemindTime().getTime());
        }
        if (null != po.getAreaId() && dto.getAreaId() > 0) {
            Map areaMap = AreaUtils.getAreaNameByCode((Integer)dto.getAreaId());
            dto.setProvince((String)areaMap.get("province"));
            dto.setCity((String)areaMap.get("city"));
            dto.setCounty((String)areaMap.get("county"));
        }
    }

    private void studentDto2Po(StudentListResponseDto dto, OrgStudent po, Long orgId, Long userId) throws IllegalAccessException, InvocationTargetException {
        BeanUtils.copyProperties((Object)po, (Object)dto);
        log.info("studentDto2Po---------dto={},po:{}", (Object)dto, (Object)ToStringBuilder.reflectionToString((Object)po));
        if (dto.getNextRemindTime() == null || dto.getNextRemindTime() <= 0L) {
            po.setNextRemindTime(DateUtil.getOffSetDate((int)5));
        } else {
            po.setNextRemindTime(new Date(dto.getNextRemindTime()));
        }
        if (null == po.getId() || 0L == po.getId()) {
            po.setOrgId(orgId);
            po.setCreateTime(new Date());
            po.setUserId(userId);
        }
        if (null != dto.getBirthday()) {
            po.setBirthday(new Date(dto.getBirthday()));
        }
        po.setUpdateTime(new Date());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void doSaveBefore(Long orgId, StudentListResponseDto studentInfo) {
        OrgStudent student = null;
        if (studentInfo.getId() != null && studentInfo.getId() > 0L) {
            student = (OrgStudent)this.orgStudentDao.getById((Serializable)studentInfo.getId(), new String[0]);
            if (student == null || student.getOrgId().longValue() != orgId.longValue() || student.getDelStatus().intValue() != DeleteStatus.NORMAL.getValue()) throw new BussinessException((UniverseErrorCode)CrmErrorCode.STUDENT_NOT_EXISTS);
            String mobile = student.getMobile();
            String name = student.getName();
            if (mobile.equals(studentInfo.getMobile()) && studentInfo.getName().equals(name)) {
                return;
            }
            this.procSameMobileAndName(orgId, studentInfo.getMobile(), studentInfo.getName());
            return;
        } else {
            this.procSameMobileAndName(orgId, studentInfo.getMobile(), studentInfo.getName());
        }
    }

    private void procSameMobileAndName(Long orgId, String mobile, String name) {
        OrgStudent student = this.orgStudentDao.getStudentByMobileAndName(orgId, mobile, name);
        if (student != null) {
            throw new BussinessException((UniverseErrorCode)CrmErrorCode.STUDENT_HAS_EXISTS);
        }
    }

    @Override
    public List<StudentListResponseDto> searchStudentByCustomParams(long orgId, StudentSearchRequestDto request, PageDto pageDto) throws Exception {
        Option option = Snippet.getAnnotation(StudentListResponseDto.class, (String)request.getName());
        AutoMatchQueryRequest matchModel = option == null ? null : this.generateAutoMatchModel(option, request);
        List students = this.orgStudentDao.searchStudentByCustomParam(orgId, matchModel, pageDto);
        ArrayList result = Lists.newArrayList();
        for (OrgStudent student : students) {
            result.add(StudentListResponseDto.convertToDto(student));
        }
        return result;
    }

    private AutoMatchQueryRequest generateAutoMatchModel(Option option, StudentSearchRequestDto request) {
        AutoMatchQueryRequest model = new AutoMatchQueryRequest();
        String value = request.getQuery();
        if (StringUtils.isBlank((CharSequence)request.getQuery()) || StringUtils.isBlank((CharSequence)request.getQuery())) {
            return null;
        }
        if (option != null) {
            model.setQueryPolicy(option.policy());
            model.setPropName(option.name());
            model.setSortPolicy(request.getOrderType() == 0 ? SortPolicy.ASC : SortPolicy.DESC);
            switch (option.type()) {
                case STRING: {
                    model.setValue(value);
                    break;
                }
                case DIGITAL: {
                    model.setValue(value);
                    break;
                }
                case DATE: {
                    model.setStart(new Date(request.getStart()));
                    model.setEnd(new Date(request.getEnd()));
                    break;
                }
            }
        }
        return model;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void addSysBacklog(Long orgId, Long studentId, Long consultUserId) {
        if (null == orgId || orgId <= 0L || null == studentId || studentId <= 0L) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR);
        }
        OrgStudent student = (OrgStudent)this.orgStudentDao.getById((Serializable)studentId, new String[0]);
        log.info("addSysBacklog---------orgId={}, student={}, consultUserId={}", new Object[]{orgId, student, consultUserId});
        if (null != student && student.getDelStatus().intValue() == DeleteStatus.NORMAL.getValue() && student.getOrgId().longValue() == orgId.longValue()) {
            List list = this.txBacklogDao.getBacklogByStudentIdAndOrgId(studentId, orgId, Boolean.valueOf(false), new String[]{"id"});
            if (CollectionUtils.isNotEmpty((Collection)list)) {
                throw new BussinessException((UniverseErrorCode)CommonErrorCode.SYSTEM_ERROR, "\u5df2\u5b58\u5728\u672a\u8fc7\u671f\u7684\u5b66\u5458\u6863\u6848\u7cfb\u7edf\u5f85\u529e\u4e8b\u9879");
            }
            TxBacklog txBacklog = new TxBacklog();
            txBacklog.setOrgId(orgId);
            txBacklog.setStudentId(student.getId());
            txBacklog.setContent("\u8ddf\u8fdb\u5ba2\u6237: " + (StringUtils.isNotBlank((CharSequence)student.getName()) ? student.getName() : "\u533f\u540d\u5b66\u751f"));
            txBacklog.setCreateTime(new Date());
            txBacklog.setUpdateTime(new Date());
            txBacklog.setIsSys(BizConf.TRUE.intValue());
            txBacklog.setEndTime(student.getNextRemindTime());
            txBacklog.setRemindTime(student.getNextRemindTime());
            if (null != consultUserId && consultUserId > 0L) {
                txBacklog.setConsultUserId(consultUserId);
            }
            this.txBacklogDao.save((Object)txBacklog, Boolean.valueOf(false), new String[0]);
            log.info("addSysBacklog--------txBacklog={}", (Object)txBacklog);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateSysBacklog(Long orgId, Long studentId) {
        if (null == orgId || orgId <= 0L || null == studentId || studentId <= 0L) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR);
        }
        OrgStudent student = (OrgStudent)this.orgStudentDao.getById((Serializable)studentId, new String[0]);
        log.info("updateSysBacklog---------orgId={}, student={}", (Object)orgId, (Object)student);
        if (null != student && student.getDelStatus().intValue() == DeleteStatus.NORMAL.getValue() && student.getOrgId().longValue() == orgId.longValue()) {
            List list = this.txBacklogDao.getBacklogByStudentIdAndOrgId(student.getId(), orgId, Boolean.valueOf(false), new String[0]);
            if (CollectionUtils.isNotEmpty((Collection)list)) {
                TxBacklog txBacklog = (TxBacklog)list.get(0);
                if (txBacklog.getEndTime().getTime() != student.getNextRemindTime().getTime()) {
                    txBacklog.setContent("\u8ddf\u8fdb\u5ba2\u6237: " + (StringUtils.isNotBlank((CharSequence)student.getName()) ? student.getName() : "\u533f\u540d\u5b66\u751f"));
                    txBacklog.setEndTime(student.getNextRemindTime());
                    txBacklog.setRemindTime(student.getNextRemindTime());
                    txBacklog.setUpdateTime(new Date());
                    this.txBacklogDao.update((Object)txBacklog, Boolean.valueOf(false), new String[0]);
                }
            } else {
                Long consulterId = null;
                List consultUserList = this.txConsultUserDao.lookByStudentId(orgId, student.getId(), new String[]{"id"});
                if (CollectionUtils.isNotEmpty((Collection)consultUserList)) {
                    consulterId = ((TxConsultUser)consultUserList.get(0)).getId();
                }
                this.addSysBacklog(orgId, student.getId(), consulterId);
            }
        }
    }

    private void delSysBacklog(Long orgId, OrgStudent student, TxConsultUser consulterUser) {
        block5: {
            List list;
            block4: {
                log.info("delSysBacklog-------orgId={},student={},consulterUser={}", new Object[]{orgId, student, consulterUser});
                list = null;
                if (null == consulterUser) break block4;
                list = this.txBacklogDao.getBacklogByConsulterIdAndOrgId(consulterUser.getId(), orgId, null, new String[0]);
                if (!CollectionUtils.isNotEmpty((Collection)list)) break block5;
                for (TxBacklog txBacklog : list) {
                    if (null == txBacklog || txBacklog.getStudentId().longValue() != student.getId().longValue()) continue;
                    txBacklog.setStudentId(Long.valueOf(0L));
                    if (!txBacklog.getEndTime().before(new Date())) {
                        txBacklog.setContent("\u8ddf\u8fdb\u5ba2\u6237: " + (StringUtils.isNotBlank((CharSequence)consulterUser.getName()) ? consulterUser.getName() : "\u533f\u540d\u5b66\u751f"));
                        txBacklog.setEndTime(consulterUser.getNextRemindTime());
                        txBacklog.setRemindTime(consulterUser.getNextRemindTime());
                    }
                    txBacklog.setUpdateTime(new Date());
                    this.txBacklogDao.update((Object)txBacklog, Boolean.valueOf(false), new String[0]);
                }
                break block5;
            }
            list = this.txBacklogDao.getBacklogByStudentIdAndOrgId(student.getId(), orgId, null, new String[0]);
            if (CollectionUtils.isNotEmpty((Collection)list)) {
                for (TxBacklog txBacklog : list) {
                    if (null == txBacklog) continue;
                    txBacklog.setStudentId(Long.valueOf(0L));
                    txBacklog.setDelStatus(BizConf.TRUE.intValue());
                    txBacklog.setUpdateTime(new Date());
                    this.txBacklogDao.update((Object)txBacklog, Boolean.valueOf(false), new String[0]);
                }
            }
        }
    }

    private void checkAndCreateComment(StudentListResponseDto dto, OrgStudent po) {
        StringBuffer content;
        String sourceName = po.getName();
        String sourceMobile = po.getMobile();
        String destName = dto.getName();
        String destMobile = dto.getMobile();
        ArrayList comments = Lists.newArrayList();
        String formatTime = BaseUtils.getFormatDate((String)"yyyy-MM-dd HH:mm", (int)0, (int)5);
        if (!destName.equals(sourceName)) {
            content = new StringBuffer();
            content.append(formatTime).append(" \u5c06\u59d3\u540d\u3010").append(sourceName).append("\u3011").append("\u4fee\u6539\u4e3a\u3010").append(destName).append("\u3011");
            comments.add(this.generateComment(po.getOrgId(), content.toString(), po.getUserId()));
        }
        if (!destMobile.equals(sourceMobile)) {
            content = new StringBuffer();
            content.append(formatTime).append(" \u5c06\u624b\u673a\u53f7\u3010").append(sourceMobile).append("\u3011").append("\u4fee\u6539\u4e3a\u3010").append(destMobile).append("\u3011");
            comments.add(this.generateComment(po.getOrgId(), content.toString(), po.getUserId()));
        }
        if (!comments.isEmpty()) {
            this.txStudentCommentDao.saveAll((List)comments, new String[0]);
        }
    }

    private TxStudentComment generateComment(long orgId, String content, long userId) {
        TxStudentComment comment = new TxStudentComment();
        comment.setContent(content);
        comment.setCreateTime(new Date());
        comment.setIsSystem(BizConf.TRUE);
        comment.setOrgId(Long.valueOf(orgId));
        comment.setOrigin(0);
        comment.setUserId(Long.valueOf(userId));
        return comment;
    }

    private void cascadeUpdateTxConsulter(long orgId, OrgStudent orgStudent, StudentListResponseDto studentInfo) {
        List consultUsers;
        boolean updateMobile;
        boolean updateName = !studentInfo.getName().equals(orgStudent.getName());
        boolean bl = updateMobile = !studentInfo.getMobile().equals(orgStudent.getMobile());
        if ((updateName || updateMobile) && (consultUsers = this.txConsultUserDao.lookByStudentId(Long.valueOf(orgId), orgStudent.getId(), new String[0])) != null && !consultUsers.isEmpty()) {
            for (TxConsultUser consultUser : consultUsers) {
                consultUser.setName(updateName ? studentInfo.getName() : null);
                consultUser.setMobile(updateMobile ? studentInfo.getMobile() : null);
                consultUser.setUpdateTime(new Date());
                this.txConsultUserDao.update((Object)consultUser, Boolean.valueOf(false), new String[0]);
            }
        }
    }
}

