/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.student.impl;

import com.baijia.tianxiao.constants.CourseType;
import com.baijia.tianxiao.constants.PayStatus;
import com.baijia.tianxiao.dal.callservice.dao.CallServiceInfoDao;
import com.baijia.tianxiao.dal.callservice.po.CallServiceInfo;
import com.baijia.tianxiao.dal.org.constant.DeleteStatus;
import com.baijia.tianxiao.dal.org.constant.StudentType;
import com.baijia.tianxiao.dal.org.dao.CoursePurchaseDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgStorageDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.po.CoursePurchase;
import com.baijia.tianxiao.dal.org.po.OrgStorage;
import com.baijia.tianxiao.dal.org.po.OrgStudent;
import com.baijia.tianxiao.dal.roster.constant.AddType;
import com.baijia.tianxiao.dal.roster.constant.DownLoadStatus;
import com.baijia.tianxiao.dal.roster.dao.TxConsultUserDao;
import com.baijia.tianxiao.dal.roster.dao.TxStudentCommentDao;
import com.baijia.tianxiao.dal.roster.po.TxConsultUser;
import com.baijia.tianxiao.dal.roster.po.TxStudentComment;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupCourseDao;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupInfoDao;
import com.baijia.tianxiao.dal.signup.po.OrgSignupCourse;
import com.baijia.tianxiao.dal.signup.po.OrgSignupInfo;
import com.baijia.tianxiao.dal.sync.constant.MsgSyncType;
import com.baijia.tianxiao.dal.sync.dao.TxMsgSyncTimestampDao;
import com.baijia.tianxiao.dal.sync.po.TxMsgSyncTimestamp;
import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sal.student.api.OrgStudentCommentService;
import com.baijia.tianxiao.sal.student.dto.CommentInfoDto;
import com.baijia.tianxiao.sal.student.dto.request.StudentCommenRequestDto;
import com.baijia.tianxiao.sal.student.dto.response.OrgCommentsListReponse;
import com.baijia.tianxiao.sal.student.enums.StudentErrorCode;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.util.collection.CollectorUtil;
import com.baijia.tianxiao.util.storage.StorageUtil;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class OrgStudentCommentServiceImpl
implements OrgStudentCommentService {
    private static final Logger log = LoggerFactory.getLogger(OrgStudentCommentServiceImpl.class);
    private static int MAX_SYNC_NUM = 100;
    @Autowired
    private OrgStudentDao orgStudentsDao;
    @Autowired
    private TxConsultUserDao txConsultUserDao;
    @Autowired
    private TxStudentCommentDao txStudentCommentDao;
    @Autowired
    private OrgStorageDao orgStorageDao;
    @Autowired
    private CoursePurchaseDao coursePurchaseDao;
    @Autowired
    private TxMsgSyncTimestampDao txMsgSyncTimestampDao;
    @Autowired
    private OrgSignupInfoDao orgSignupInfoDao;
    @Autowired
    private OrgSignupCourseDao orgSignupCourseDao;
    @Autowired
    private OrgCourseDao orgCourseDao;
    @Autowired
    private CallServiceInfoDao callServiceInfoDao;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public List<Long> addStudentComment(List<CommentInfoDto> commentDtos, Integer type, Long studentId, Long orgId) {
        if (type == null || studentId == null || CollectionUtils.isEmpty(commentDtos)) {
            log.warn("add comments error: type ,studentId or comments is null!");
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR);
        }
        OrgStudent student = null;
        if (type.intValue() == StudentType.ORG_STUDENTS.getCode()) {
            student = (OrgStudent)this.orgStudentsDao.getById((Serializable)studentId, new String[]{"userId", "orgId"});
            if (student == null || student.getOrgId().longValue() != orgId.longValue()) {
                throw new BussinessException((UniverseErrorCode)StudentErrorCode.STUDENT_NOT_EXIST);
            }
        } else {
            student = new OrgStudent();
            TxConsultUser user = (TxConsultUser)this.txConsultUserDao.getById((Serializable)studentId, new String[0]);
            if (user == null || user.getOrgId().longValue() != orgId.longValue()) {
                throw new BussinessException((UniverseErrorCode)StudentErrorCode.CONSULT_USER_NOT_EXIST);
            }
            student.setUserId(user.getUserId());
            student.setOrgId(Long.valueOf(user.getOrgId()));
        }
        ArrayList comments = Lists.newArrayList();
        for (CommentInfoDto dto : commentDtos) {
            TxStudentComment po = new TxStudentComment();
            this.commentDto2Po(dto, orgId, po, studentId, type, student);
            comments.add(po);
        }
        this.txStudentCommentDao.saveAll((List)comments, new String[0]);
        ArrayList result = Lists.newArrayList();
        for (TxStudentComment txStudentComment : comments) {
            result.add(txStudentComment.getId());
        }
        return result;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void delStudentComment(StudentCommenRequestDto studentCommenRequestDto, Long orgId) {
        if (studentCommenRequestDto.getCommentId() == null) {
            log.warn("del comment error: commentId is null!");
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR);
        }
        TxStudentComment comment = (TxStudentComment)this.txStudentCommentDao.getById((Serializable)studentCommenRequestDto.getCommentId(), new String[0]);
        if (comment == null || comment.getOrgId().longValue() != orgId.longValue()) {
            throw new BussinessException((UniverseErrorCode)StudentErrorCode.COMMENT_NOT_EXIST);
        }
        if (comment.getIsSystem().intValue() == AddType.SYSTEM.getCode()) {
            throw new BussinessException((UniverseErrorCode)StudentErrorCode.SYSTEM_COMMENT);
        }
        this.txStudentCommentDao.delById((Serializable)comment.getId());
    }

    private void commentDto2Po(CommentInfoDto dto, Long orgId, TxStudentComment po, Long studentId, Integer type, OrgStudent student) {
        if (type.intValue() == StudentType.CONSULT_USER.getCode()) {
            po.setConsultUserId(studentId);
        }
        po.setUserId(student.getUserId());
        po.setOrgId(orgId);
        po.setSeconds(dto.getSeconds());
        po.setSoundId(dto.getSoundId());
        po.setStorageIds(dto.getStorageIds());
        po.setContent(dto.getContent());
    }

    @Override
    public OrgCommentsListReponse getComments(Integer type, Long studentId, Long orgId) {
        if (type == null || studentId == null) {
            log.warn("get comments error: type ,studentId or comments is null!");
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR);
        }
        List comments = Lists.newArrayList();
        if (type.intValue() == StudentType.ORG_STUDENTS.getCode()) {
            OrgStudent student = (OrgStudent)this.orgStudentsDao.getById((Serializable)studentId, new String[]{"orgId", "userId"});
            if (student == null || student.getOrgId().longValue() != orgId.longValue()) {
                throw new BussinessException((UniverseErrorCode)StudentErrorCode.STUDENT_NOT_EXIST);
            }
            comments = this.txStudentCommentDao.getComments(student.getUserId(), orgId, type, new String[0]);
        } else {
            TxConsultUser user = (TxConsultUser)this.txConsultUserDao.getById((Serializable)studentId, new String[0]);
            if (user == null || user.getOrgId().longValue() != orgId.longValue()) {
                throw new BussinessException((UniverseErrorCode)StudentErrorCode.CONSULT_USER_NOT_EXIST);
            }
            comments = this.txStudentCommentDao.getComments(studentId, orgId, type, new String[0]);
        }
        OrgCommentsListReponse reponse = new OrgCommentsListReponse();
        HashSet callIds = Sets.newHashSet();
        for (TxStudentComment comment : comments) {
            if (comment.getDownStatus().intValue() != DownLoadStatus.UNFINISH.getCode()) continue;
            callIds.add(comment.getSoundId());
        }
        Map<Long, Long> callMap = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty((Collection)callIds)) {
            List callInfos = this.callServiceInfoDao.getByIds((Collection)callIds, new String[0]);
            callMap = CollectorUtil.collectMap((Collection)callInfos, (Function)new Function<CallServiceInfo, Long>(){

                public Long apply(CallServiceInfo arg0) {
                    return arg0.getId();
                }
            }, (Function)new Function<CallServiceInfo, Long>(){

                public Long apply(CallServiceInfo arg0) {
                    return arg0.getStorageId();
                }
            });
        }
        HashSet storageIds = Sets.newHashSet();
        for (TxStudentComment comment : comments) {
            if (StringUtils.isNotEmpty((CharSequence)comment.getStorageIds())) {
                String[] storageIdsStr = comment.getStorageIds().split(",");
                for (String storageId : storageIdsStr) {
                    storageIds.add(Integer.parseInt(storageId));
                }
            }
            if (comment.getDownStatus().intValue() == DownLoadStatus.UNFINISH.getCode()) {
                Long storageId = (Long)callMap.get(comment.getSoundId());
                if (storageId == null || storageId <= 0L) continue;
                storageIds.add(storageId.intValue());
                continue;
            }
            if (comment.getDownStatus().intValue() != DownLoadStatus.FINISH.getCode() || comment.getSoundId() == null || comment.getSoundId() <= 0L) continue;
            storageIds.add(comment.getSoundId().intValue());
        }
        List storages = this.orgStorageDao.getByIds((Collection)storageIds, new String[0]);
        Map storageMap = CollectorUtil.collectMap((Collection)storages, (Function)new Function<OrgStorage, Integer>(){

            public Integer apply(OrgStorage arg0) {
                return arg0.getId();
            }
        });
        ArrayList commentsDto = Lists.newArrayList();
        for (TxStudentComment comment : comments) {
            CommentInfoDto commentDto = new CommentInfoDto();
            this.commentPo2Dto(commentDto, comment, callMap, storageMap);
            commentsDto.add(commentDto);
        }
        reponse.setComments(commentsDto);
        return reponse;
    }

    private void commentPo2Dto(CommentInfoDto dto, TxStudentComment po, Map<Long, Long> callMap, Map<Integer, OrgStorage> storageMap) {
        OrgStorage storage;
        Long storageId;
        dto.setCommentId(po.getId());
        dto.setContent(po.getContent());
        dto.setStorageIds(po.getStorageIds());
        dto.setCreateTime(po.getCreateTime());
        dto.setCallStatus(po.getCallStatus());
        dto.setIsMobile(po.getIsMobile());
        dto.setIsSystem(po.getIsSystem());
        if (StringUtils.isNotEmpty((CharSequence)dto.getStorageIds())) {
            String[] storageIdsStr = dto.getStorageIds().split(",");
            ArrayList urls = Lists.newArrayList();
            for (String storageId2 : storageIdsStr) {
                OrgStorage storage2 = storageMap.get(Integer.parseInt(storageId2));
                if (storage2 == null) continue;
                String url = StorageUtil.constructUrl((String)storage2.getFid(), (String)storage2.getSn(), (Integer)storage2.getMimeType());
                urls.add(url);
            }
            dto.setUrls(StringUtils.join((Object[])urls.toArray(new String[urls.size()]), (String)","));
        }
        if (po.getDownStatus().intValue() == DownLoadStatus.UNFINISH.getCode() && (storageId = callMap.get(po.getSoundId())) != null && storageId > 0L) {
            po.setSoundId(storageId);
            po.setDownStatus(Integer.valueOf(DownLoadStatus.FINISH.getCode()));
            this.txStudentCommentDao.update((Object)po, new String[]{"downStatus", "soundId"});
        }
        if (po.getSoundId() > 0L && po.getDownStatus().intValue() == DownLoadStatus.FINISH.getCode() && (storage = storageMap.get(po.getSoundId().intValue())) != null) {
            dto.setSeconds(po.getSeconds());
            dto.setSoundId(po.getSoundId());
            dto.setSoundUrl(StorageUtil.constructUrl((String)storage.getFid(), (String)storage.getSn(), (Integer)storage.getMimeType()));
        }
        dto.setDownLoadStatus(po.getDownStatus());
    }

    @Override
    public boolean syncAddOrgStudent() {
        TxMsgSyncTimestamp syncInfo = this.txMsgSyncTimestampDao.getSyncTimestampByType(MsgSyncType.ADD_STU.getSyncType());
        if (syncInfo == null) {
            syncInfo = new TxMsgSyncTimestamp();
            syncInfo.setSyncType(Integer.valueOf(MsgSyncType.ADD_STU.getSyncType()));
            syncInfo.setSyncTime(new Date());
            this.txMsgSyncTimestampDao.save((Object)syncInfo, Boolean.valueOf(false), new String[0]);
        }
        PageDto page = new PageDto();
        page.setPageNum(Integer.valueOf(1));
        page.setPageSize(Integer.valueOf(MAX_SYNC_NUM));
        log.info("syncAddOrgStudent,syncTime={}", (Object)syncInfo.getSyncTime());
        List students = this.orgStudentsDao.getStudents(syncInfo.getSyncTime(), Integer.valueOf(DeleteStatus.NORMAL.getValue()), page, new String[]{"orgId", "userId", "createTime", "name", "nickName"});
        if (CollectionUtils.isNotEmpty((Collection)students)) {
            if (((OrgStudent)students.get(0)).getCreateTime().after(new Date())) {
                return false;
            }
            syncInfo.setSyncTime(((OrgStudent)students.get(0)).getCreateTime());
            ArrayList comments = Lists.newArrayList();
            for (OrgStudent orgStudents : students) {
                TxStudentComment comment = new TxStudentComment();
                if (StringUtils.isNotEmpty((CharSequence)orgStudents.getName())) {
                    comment.setContent("\u6dfb\u52a0\u5b66\u5458 " + orgStudents.getName());
                } else {
                    comment.setContent("\u6dfb\u52a0\u5b66\u5458 " + orgStudents.getNickName());
                }
                comment.setOrgId(orgStudents.getOrgId());
                comment.setUserId(orgStudents.getUserId());
                comment.setCreateTime(orgStudents.getCreateTime());
                comment.setIsSystem(Integer.valueOf(AddType.SYSTEM.getCode()));
                comments.add(comment);
            }
            this.txStudentCommentDao.saveAll((List)comments, new String[0]);
            this.txMsgSyncTimestampDao.update((Object)syncInfo, new String[]{"syncTime"});
        }
        return true;
    }

    @Override
    public boolean syncCoursePurchase() {
        TxMsgSyncTimestamp syncInfo = this.txMsgSyncTimestampDao.getSyncTimestampByType(MsgSyncType.COURSE_PURCHASE.getSyncType());
        if (syncInfo == null) {
            syncInfo = new TxMsgSyncTimestamp();
            syncInfo.setSyncType(Integer.valueOf(MsgSyncType.COURSE_PURCHASE.getSyncType()));
            syncInfo.setSyncTime(new Date());
            this.txMsgSyncTimestampDao.save((Object)syncInfo, Boolean.valueOf(false), new String[0]);
        }
        PageDto page = new PageDto();
        page.setPageNum(Integer.valueOf(1));
        page.setPageSize(Integer.valueOf(MAX_SYNC_NUM));
        ArrayList classType = Lists.newArrayList();
        classType.add(CourseType.ORG_COURSE.getCode());
        log.info("syncCoursePurchase,syncTime={}", (Object)syncInfo.getSyncTime());
        List purchases = this.coursePurchaseDao.getCoursePurchaseList(syncInfo.getSyncTime(), Integer.valueOf(PayStatus.SUCESS.getCode()), (List)classType, page, new String[0]);
        if (CollectionUtils.isNotEmpty((Collection)purchases)) {
            if (((CoursePurchase)purchases.get(0)).getUpdateTime().after(new Date())) {
                return false;
            }
            syncInfo.setSyncTime(((CoursePurchase)purchases.get(0)).getUpdateTime());
            HashSet courseIds = Sets.newHashSet();
            for (CoursePurchase coursePurchase : purchases) {
                courseIds.add(coursePurchase.getCourseId());
            }
            Map nameMap = this.orgCourseDao.getCourseNameMap((Collection)courseIds);
            ArrayList comments = Lists.newArrayList();
            for (CoursePurchase coursePurchase : purchases) {
                TxStudentComment comment = new TxStudentComment();
                String name = (String)nameMap.get(coursePurchase.getCourseId());
                comment.setContent("\u62a5\u73ed:[" + name + "]\u603b\u4ef7:\u00a5" + coursePurchase.getPayMoney() + "\u5143");
                comment.setOrgId(coursePurchase.getOrgId());
                comment.setUserId(coursePurchase.getUserId());
                comment.setCreateTime(coursePurchase.getUpdateTime());
                comment.setIsSystem(Integer.valueOf(AddType.SYSTEM.getCode()));
                comments.add(comment);
            }
            this.txStudentCommentDao.saveAll((List)comments, new String[0]);
            this.txMsgSyncTimestampDao.update((Object)syncInfo, new String[]{"syncTime"});
        }
        return true;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void modComment(CommentInfoDto dto, Long orgId) {
        if (dto.getCommentId() == null) {
            log.warn("mod comment error: commentId is null!");
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR);
        }
        TxStudentComment comment = (TxStudentComment)this.txStudentCommentDao.getById((Serializable)dto.getCommentId(), new String[0]);
        if (comment == null || comment.getOrgId().longValue() != orgId.longValue()) {
            throw new BussinessException((UniverseErrorCode)StudentErrorCode.COMMENT_NOT_EXIST);
        }
        if (comment.getIsSystem().intValue() == AddType.SYSTEM.getCode()) {
            throw new BussinessException((UniverseErrorCode)StudentErrorCode.SYSTEM_COMMENT);
        }
        comment.setSeconds(dto.getSeconds());
        comment.setSoundId(dto.getSoundId());
        comment.setStorageIds(dto.getStorageIds());
        comment.setContent(dto.getContent());
        this.txStudentCommentDao.update((Object)comment, new String[]{"seconds", "soundId", "storageIds", "content"});
    }

    @Override
    public boolean syncSignupPurchase() {
        TxMsgSyncTimestamp syncInfo = this.txMsgSyncTimestampDao.getSyncTimestampByType(MsgSyncType.SIGNUP_PURCHASE.getSyncType());
        if (syncInfo == null) {
            syncInfo = new TxMsgSyncTimestamp();
            syncInfo.setSyncType(Integer.valueOf(MsgSyncType.SIGNUP_PURCHASE.getSyncType()));
            syncInfo.setSyncTime(new Date());
            this.txMsgSyncTimestampDao.save((Object)syncInfo, Boolean.valueOf(false), new String[0]);
        }
        PageDto page = new PageDto();
        page.setPageNum(Integer.valueOf(1));
        page.setPageSize(Integer.valueOf(MAX_SYNC_NUM));
        log.info("syncSignupPurchase,syncTime={}", (Object)syncInfo.getSyncTime());
        List sinupInfos = this.orgSignupInfoDao.getPurchases(syncInfo.getSyncTime(), Integer.valueOf(PayStatus.SUCESS.getCode()), page, new String[0]);
        if (CollectionUtils.isNotEmpty((Collection)sinupInfos)) {
            if (((OrgSignupInfo)sinupInfos.get(0)).getUpdateTime().after(new Date())) {
                return false;
            }
            syncInfo.setSyncTime(((OrgSignupInfo)sinupInfos.get(0)).getUpdateTime());
            HashSet signupPurchaseIds = Sets.newHashSet();
            for (OrgSignupInfo orgSignupInfo : sinupInfos) {
                signupPurchaseIds.add(orgSignupInfo.getSignupPurchaseId());
            }
            List coursePurchases = this.orgSignupCourseDao.loadByPurchaseIds((Collection)signupPurchaseIds, new String[]{"signupPurchaseId", "orgCourseId"});
            HashSet courseIds = Sets.newHashSet();
            HashMap coursePurhaseMap = Maps.newHashMap();
            for (OrgSignupCourse orgSignupCourse : coursePurchases) {
                if (!coursePurhaseMap.containsKey(orgSignupCourse.getSignupPurchaseId())) {
                    coursePurhaseMap.put(orgSignupCourse.getSignupPurchaseId(), Lists.newArrayList());
                }
                ((List)coursePurhaseMap.get(orgSignupCourse.getSignupPurchaseId())).add(orgSignupCourse);
                courseIds.add(orgSignupCourse.getOrgCourseId());
            }
            Map courseMap = this.orgCourseDao.getCourseNameMap((Collection)courseIds);
            ArrayList comments = Lists.newArrayList();
            for (OrgSignupInfo orgSignupInfo : sinupInfos) {
                TxStudentComment comment = new TxStudentComment();
                comment.setOrgId(orgSignupInfo.getOrgId());
                comment.setUserId(orgSignupInfo.getUserId());
                comment.setCreateTime(orgSignupInfo.getUpdateTime());
                List purchases = (List)coursePurhaseMap.get(orgSignupInfo.getSignupPurchaseId());
                ArrayList names = Lists.newArrayList();
                String courses = "";
                if (CollectionUtils.isNotEmpty((Collection)purchases)) {
                    for (OrgSignupCourse orgSignupCourse : purchases) {
                        String name = (String)courseMap.get(orgSignupCourse.getOrgCourseId());
                        if (!StringUtils.isNotEmpty((CharSequence)name)) continue;
                        names.add(name);
                    }
                }
                if (CollectionUtils.isNotEmpty((Collection)names)) {
                    courses = StringUtils.join((Object[])names.toArray(new String[names.size()]), (String)",");
                }
                StringBuffer sb = new StringBuffer();
                sb.append("\u62a5\u73ed:[").append(courses).append("]\u603b\u4ef7:\u00a5").append(orgSignupInfo.getTotalPrices().doubleValue() / 100.0).append("\u5143");
                comment.setContent(sb.toString());
                comment.setIsSystem(Integer.valueOf(AddType.SYSTEM.getCode()));
                comments.add(comment);
            }
            this.txStudentCommentDao.saveAll((List)comments, new String[0]);
            this.txMsgSyncTimestampDao.update((Object)syncInfo, new String[]{"syncTime"});
        }
        return true;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void mergeCommentRecord(TxConsultUser sourceConsultUser, TxConsultUser destConsultUser, Long orgId) {
        List comments = this.txStudentCommentDao.getComments(sourceConsultUser.getId(), orgId, Integer.valueOf(StudentType.CONSULT_USER.getCode()), new String[0]);
        if (comments != null && !comments.isEmpty()) {
            for (TxStudentComment comment : comments) {
                comment.setConsultUserId(destConsultUser.getId());
                comment.setUserId(destConsultUser.getUserId());
                comment.setUpdateTime(new Date());
                this.txStudentCommentDao.update((Object)comment, new String[]{"consultUserId", "userId", "updateTime"});
            }
        }
        this.doAfter(sourceConsultUser, destConsultUser, orgId);
    }

    void doAfter(TxConsultUser sourceConsultUser, TxConsultUser destConsultUser, Long orgId) {
        TxStudentComment addComment = new TxStudentComment();
        addComment.setCallStatus(Integer.valueOf(0));
        addComment.setConsultUserId(destConsultUser.getId());
        addComment.setUserId(destConsultUser.getUserId());
        addComment.setContent(this.getCommentRecord(sourceConsultUser, destConsultUser));
        addComment.setOrgId(orgId);
        addComment.setCreateTime(new Date());
        addComment.setIsSystem(Integer.valueOf(AddType.SYSTEM.getCode()));
        log.info("orgId:{}, addComment:{}", (Object)orgId, (Object)addComment);
        this.txStudentCommentDao.save((Object)addComment, new String[0]);
    }

    private String getCommentRecord(TxConsultUser sourceConsultUser, TxConsultUser destConsultUser) {
        String sourceName = sourceConsultUser.getName();
        String sourceNickName = sourceConsultUser.getNickName();
        String destName = destConsultUser.getName();
        String destNickName = destConsultUser.getNickName();
        String sourceMobile = sourceConsultUser.getMobile();
        String destMobile = destConsultUser.getMobile();
        StringBuffer sb = new StringBuffer();
        sb.append("\u60a8\u5c06\u5b66\u751f\u3010" + this.getConsulterName(sourceName, sourceNickName) + "\u3011");
        if (StringUtils.isNotBlank((CharSequence)sourceMobile)) {
            sb.append("\u3010" + sourceMobile + "\u3011");
        }
        sb.append("\u548c\u5b66\u751f\u3010" + this.getConsulterName(destName, destNickName) + "\u3011");
        if (StringUtils.isNotBlank((CharSequence)destMobile)) {
            sb.append("\u3010" + destMobile + "\u3011");
        }
        sb.append("\u5408\u5e76\u4e86");
        return sb.toString();
    }

    private String getConsulterName(String source, String dest) {
        return StringUtils.isNotBlank((CharSequence)source) ? source : (StringUtils.isNotBlank((CharSequence)dest) ? dest : "\u533f\u540d\u7528\u6237");
    }
}

