/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.student.impl;

import com.baijia.commons.lang.utils.collection.CollectionUtils;
import com.baijia.tianxiao.constant.Flag;
import com.baijia.tianxiao.constants.CourseType;
import com.baijia.tianxiao.constants.PayStatus;
import com.baijia.tianxiao.constants.org.BizConf;
import com.baijia.tianxiao.dal.callservice.dao.CallServiceInfoDao;
import com.baijia.tianxiao.dal.callservice.dao.OrgPushCallInfoDao;
import com.baijia.tianxiao.dal.callservice.po.CallServiceInfo;
import com.baijia.tianxiao.dal.callservice.po.OrgPushCallInfo;
import com.baijia.tianxiao.dal.org.constant.DeleteStatus;
import com.baijia.tianxiao.dal.org.constant.StudentType;
import com.baijia.tianxiao.dal.org.dao.CoursePurchaseDao;
import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.dao.OrgClassLessonDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgInfoDao;
import com.baijia.tianxiao.dal.org.dao.OrgStorageDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.dao.OrgSubAccountDao;
import com.baijia.tianxiao.dal.org.dao.TXCascadeAccountDao;
import com.baijia.tianxiao.dal.org.dao.TXCascadeCredentialDao;
import com.baijia.tianxiao.dal.org.po.AccountRoleType;
import com.baijia.tianxiao.dal.org.po.CoursePurchase;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.org.po.OrgCourse;
import com.baijia.tianxiao.dal.org.po.OrgInfo;
import com.baijia.tianxiao.dal.org.po.OrgStorage;
import com.baijia.tianxiao.dal.org.po.OrgStudent;
import com.baijia.tianxiao.dal.org.po.OrgStudentCourse;
import com.baijia.tianxiao.dal.org.po.OrgSubAccount;
import com.baijia.tianxiao.dal.org.po.TXCascadeAccount;
import com.baijia.tianxiao.dal.pcAuthority.constant.ApplicationType;
import com.baijia.tianxiao.dal.pcAuthority.constant.RoleType;
import com.baijia.tianxiao.dal.push.constant.MessageSource;
import com.baijia.tianxiao.dal.roster.constant.AddType;
import com.baijia.tianxiao.dal.roster.constant.DownLoadStatus;
import com.baijia.tianxiao.dal.roster.constant.MobileStatus;
import com.baijia.tianxiao.dal.roster.dao.TxConsultUserDao;
import com.baijia.tianxiao.dal.roster.dao.TxStudentCommentDao;
import com.baijia.tianxiao.dal.roster.dao.TxStudentTagDao;
import com.baijia.tianxiao.dal.roster.po.TxConsultUser;
import com.baijia.tianxiao.dal.roster.po.TxStudentComment;
import com.baijia.tianxiao.dal.roster.po.TxStudentTag;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupCourseDao;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupInfoDao;
import com.baijia.tianxiao.dal.signup.po.OrgSignupCourse;
import com.baijia.tianxiao.dal.solr.dto.StudentDto;
import com.baijia.tianxiao.dal.solr.dto.StudentQueryParam;
import com.baijia.tianxiao.dal.solr.enums.OpType;
import com.baijia.tianxiao.dal.solr.enums.StudentLessonStatus;
import com.baijia.tianxiao.dal.solr.enums.TimeType;
import com.baijia.tianxiao.dal.solr.po.StudentClassHour;
import com.baijia.tianxiao.dal.solr.po.StudentStatusStatistics;
import com.baijia.tianxiao.dal.solr.query.CrmStudentQuery;
import com.baijia.tianxiao.dal.storage.dao.StorageDao;
import com.baijia.tianxiao.dal.storage.po.Storage;
import com.baijia.tianxiao.dal.todo.dao.TxBacklogDao;
import com.baijia.tianxiao.dal.todo.po.TxBacklog;
import com.baijia.tianxiao.dal.user.dao.StudentDao;
import com.baijia.tianxiao.dal.user.dao.UserDao;
import com.baijia.tianxiao.dal.user.po.Student;
import com.baijia.tianxiao.dal.user.po.User;
import com.baijia.tianxiao.dal.wechat.dao.FansDao;
import com.baijia.tianxiao.dal.wechat.po.Fans;
import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.enums.CrmErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.exception.PermissionException;
import com.baijia.tianxiao.filter.TianxiaoMContext;
import com.baijia.tianxiao.sal.organization.constant.TXPermissionConstant;
import com.baijia.tianxiao.sal.organization.org.service.TxAccountHelpService;
import com.baijia.tianxiao.sal.organization.org.service.TxAccountPermissionService;
import com.baijia.tianxiao.sal.organization.org.service.TxCascadeCredentialService;
import com.baijia.tianxiao.sal.organization.org.service.impl.RequestSourceDesc;
import com.baijia.tianxiao.sal.organization.utils.DataAuthority;
import com.baijia.tianxiao.sal.push.dto.ConsultAvatarUrlAndNameDto;
import com.baijia.tianxiao.sal.push.service.ConsultAvatarUrlService;
import com.baijia.tianxiao.sal.student.api.OrgStudentCourseService;
import com.baijia.tianxiao.sal.student.api.OrgStudentService;
import com.baijia.tianxiao.sal.student.dto.CommentInfoDto;
import com.baijia.tianxiao.sal.student.dto.CreatorDto;
import com.baijia.tianxiao.sal.student.dto.StudentInfoDto;
import com.baijia.tianxiao.sal.student.dto.TagInfoDto;
import com.baijia.tianxiao.sal.student.dto.request.MobileCheckInfoRequestDto;
import com.baijia.tianxiao.sal.student.dto.request.StudentCommenRequestDto;
import com.baijia.tianxiao.sal.student.dto.request.StudentListRequestDto;
import com.baijia.tianxiao.sal.student.dto.response.BatchAddStudentResponseDto;
import com.baijia.tianxiao.sal.student.dto.response.MobileCheckReponseDto;
import com.baijia.tianxiao.sal.student.dto.response.OrgStudentAddresponseDto;
import com.baijia.tianxiao.sal.student.dto.response.StudentInfoListReponseDto;
import com.baijia.tianxiao.sal.student.dto.response.StudentInfoReponseDto;
import com.baijia.tianxiao.sal.student.enums.StarEnum;
import com.baijia.tianxiao.sal.student.enums.StudentErrorCode;
import com.baijia.tianxiao.sal.student.util.CommentUtil;
import com.baijia.tianxiao.sal.student.util.OrgStudentUtil;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.util.BaseUtils;
import com.baijia.tianxiao.util.GenericsUtils;
import com.baijia.tianxiao.util.HanZiPinYinUtils;
import com.baijia.tianxiao.util.ListUtil;
import com.baijia.tianxiao.util.collection.CollectorUtil;
import com.baijia.tianxiao.util.mobile.MaskUtil;
import com.baijia.tianxiao.util.storage.StorageUtil;
import com.baijia.tianxiao.validation.ParamValidateUtils;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class OrgStudentServiceImpl
implements OrgStudentService {
    private static final Logger log = LoggerFactory.getLogger(OrgStudentServiceImpl.class);
    @Autowired
    private OrgStudentDao orgStudentsDao;
    @Autowired
    private StudentDao studentDao;
    @Autowired
    private TxStudentTagDao txStudentTagDao;
    @Autowired
    private TxConsultUserDao txConsultUserDao;
    @Autowired
    private TxStudentCommentDao txStudentCommentDao;
    @Autowired
    private UserDao userDao;
    @Autowired
    private OrgStorageDao orgStorageDao;
    @Autowired
    private StorageDao storageDao;
    @Autowired
    private CoursePurchaseDao coursePurchaseDao;
    @Autowired
    private OrgStudentCourseDao orgStudentCourseDao;
    @Autowired
    private OrgCourseDao orgCourseDao;
    @Autowired
    private OrgAccountDao orgAccountDao;
    @Autowired
    private OrgSignupInfoDao orgSignupInfoDao;
    @Autowired
    private OrgSignupCourseDao orgSignupCourseDao;
    @Autowired
    private OrgClassLessonDao orgClassLessonDao;
    @Autowired
    private CallServiceInfoDao callServiceInfoDao;
    @Autowired
    private FansDao fansDao;
    @Autowired
    private TxBacklogDao txBacklogDao;
    @Autowired
    private OrgPushCallInfoDao orgPushCallInfoDao;
    @Autowired
    private OrgStudentCourseService orgStudentCourseService;
    @Autowired(required=false)
    private CrmStudentQuery solrStudentQuery;
    @Autowired
    private TXCascadeAccountDao txCascadeAccountDao;
    @Autowired
    private TXCascadeCredentialDao txCascadeCredentialDao;
    @Autowired
    private OrgInfoDao orgInfoDao;
    @Autowired
    private OrgSubAccountDao orgSubAccountDao;
    @Autowired
    private TxAccountHelpService txAccountHelpService;
    @Autowired
    private TxCascadeCredentialService txCascadeCredentialService;
    @Autowired
    private ConsultAvatarUrlService consultAvatarUrlService;
    @Autowired
    private TxAccountPermissionService txAccountPermissionService;

    @Override
    @Transactional(rollbackFor={Exception.class, BussinessException.class})
    public int syncStudent(PageDto pageDto) {
        log.info("############### start======");
        List students = this.orgStudentsDao.getStudentsByPage(pageDto);
        if (students != null) {
            for (OrgStudent student : students) {
                if (student.getMobile() == null || student.getName() == null) continue;
                List stuList = this.orgStudentsDao.getStudentsByMobileAndName(student.getOrgId(), student.getMobile(), student.getName());
                log.info("############### ====== size=" + stuList.size());
                if (stuList == null || stuList.size() <= 1) continue;
                for (int i = 0; i < stuList.size(); ++i) {
                    OrgStudent orgStudent = (OrgStudent)stuList.get(i);
                    orgStudent.setName(orgStudent.getName() + "(" + (i + 1) + ")");
                    log.info("############### ====== name=" + orgStudent.getName());
                    this.orgStudentsDao.saveOrUpdate((Object)orgStudent, new String[0]);
                }
            }
        }
        log.info("############### end======");
        return students.size();
    }

    @Override
    @Transactional(rollbackFor={Exception.class, BussinessException.class})
    public OrgStudentAddresponseDto addStudent(StudentInfoDto studentInfoDto, List<CommentInfoDto> commentDtos, List<TagInfoDto> tagDtos, Long orgId) throws BussinessException {
        User user;
        List orgStudents;
        log.debug("add student studentInfo={}, orgId={}", (Object)studentInfoDto, (Object)orgId);
        Preconditions.checkArgument((orgId != null ? 1 : 0) != 0, (Object)"orgId can not be null");
        if (StringUtils.isBlank((CharSequence)studentInfoDto.getMobile()) || StringUtils.isBlank((CharSequence)studentInfoDto.getName())) {
            log.warn("add student error: mobile or name is null!");
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR);
        }
        if (!ParamValidateUtils.validateMobile((String)studentInfoDto.getMobile())) {
            throw new BussinessException((UniverseErrorCode)StudentErrorCode.MOBILE_WRONG);
        }
        this.saveBefore(studentInfoDto, orgId);
        if (StringUtils.isBlank((CharSequence)studentInfoDto.getWeixin()) && (orgStudents = this.orgStudentsDao.getStudentByMobileAndOrgId(orgId, studentInfoDto.getMobile(), Integer.valueOf(100), new String[0])) != null) {
            for (OrgStudent orgStudent : orgStudents) {
                if (!StringUtils.isNotBlank((CharSequence)orgStudent.getWeixin())) continue;
                studentInfoDto.setWeixin(orgStudent.getWeixin());
                break;
            }
        }
        OrgStudentAddresponseDto response = new OrgStudentAddresponseDto();
        Long userId = null;
        Long userNumber = null;
        if (null != studentInfoDto.getStudentNumber() && studentInfoDto.getStudentNumber() > 0L && null != (user = this.userDao.getByNumber(studentInfoDto.getStudentNumber(), new String[]{"id", "number"}))) {
            userId = user.getId();
            userNumber = user.getNumber();
        }
        if (null == userId) {
            Map<String, Long> userInfoMap = OrgStudentUtil.getUserIdAndNumber(studentInfoDto.getName());
            userId = userInfoMap.get("id");
            userNumber = userInfoMap.get("number");
        }
        response.setUserId(userId);
        response.setUserNumber(userNumber);
        OrgStudent student = this.orgStudentsDao.getStudent(orgId, userId, null, new String[0]);
        if (student != null && student.getDelStatus().intValue() == DeleteStatus.NORMAL.getValue()) {
            throw new BussinessException((UniverseErrorCode)StudentErrorCode.MOBILE_REGISTERED);
        }
        if (student != null && student.getDelStatus().intValue() == DeleteStatus.DELETED.getValue()) {
            student.setDelStatus(Integer.valueOf(DeleteStatus.NORMAL.getValue()));
            response.setStudentId(student.getId());
            this.studentDto2Po(studentInfoDto, student, orgId, userId);
            student.setCreateTime(new Date());
            this.orgStudentsDao.update((Object)student, Boolean.valueOf(false), new String[0]);
            if (studentInfoDto.getConsultUserId() == null) {
                this.saveCommentsAndTags(studentInfoDto, commentDtos, tagDtos, orgId, student);
                this.addSysBacklog(orgId, student, null);
            } else {
                this.txStudentCommentDao.updateComment(studentInfoDto.getConsultUserId(), userId);
                this.txStudentTagDao.updateTag(studentInfoDto.getConsultUserId(), userId);
                this.updateSysBacklog(orgId, student, studentInfoDto.getConsultUserId());
            }
            return response;
        }
        if (studentInfoDto.getConsultUserId() != null) {
            log.info("add orgStudent from consult_user");
            TxConsultUser consultUser = (TxConsultUser)this.txConsultUserDao.getById((Serializable)studentInfoDto.getConsultUserId(), new String[]{"orgId"});
            if (consultUser == null) {
                throw new BussinessException((UniverseErrorCode)StudentErrorCode.CONSULT_USER_NOT_EXIST);
            }
        }
        student = new OrgStudent();
        log.info("%%%%%%%@@  studentInfoDto:{}", (Object)studentInfoDto);
        this.studentDto2Po(studentInfoDto, student, orgId, userId);
        log.info("%%%%%%%@@  student:{}", (Object)student);
        this.orgStudentsDao.save((Object)student, Boolean.valueOf(false), new String[0]);
        this.saveCommentsAndTags(studentInfoDto, commentDtos, tagDtos, orgId, student);
        if (studentInfoDto.getConsultUserId() != null) {
            this.txStudentCommentDao.updateComment(studentInfoDto.getConsultUserId(), userId);
            this.txStudentTagDao.updateTag(studentInfoDto.getConsultUserId(), userId);
            this.updateSysBacklog(orgId, student, studentInfoDto.getConsultUserId());
        } else {
            this.addSysBacklog(orgId, student, null);
        }
        log.info("addStudent success!");
        response.setStudentId(student.getId());
        return response;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void saveBefore(StudentInfoDto studentInfoDto, Long orgId) throws BussinessException {
        log.debug("saveBefore.studentInfoDto:{}", (Object)studentInfoDto);
        if (studentInfoDto.getConfirm() != null && studentInfoDto.getConfirm().intValue() != BizConf.FALSE.intValue()) return;
        OrgStudent student = null;
        if (studentInfoDto.getStudentId() != null && studentInfoDto.getStudentId() > 0L) {
            student = (OrgStudent)this.orgStudentsDao.getById((Serializable)studentInfoDto.getStudentId(), new String[0]);
            if (student == null || student.getOrgId().longValue() != orgId.longValue() || student.getDelStatus().intValue() != DeleteStatus.NORMAL.getValue()) throw new BussinessException((UniverseErrorCode)StudentErrorCode.STUDENT_NOT_EXIST);
            String mobile = student.getMobile();
            String name = student.getName();
            String paramMobile = studentInfoDto.getMobile();
            String paramName = student.getName();
            if (paramMobile.contains("****")) {
                paramMobile = mobile;
            }
            if (mobile.equals(paramMobile) && name.equals(paramName)) {
                return;
            }
            if (mobile.equals(paramMobile) && !name.equals(paramName)) {
                this.procSameMobileAndName(orgId, paramMobile, paramName);
                return;
            } else {
                this.procSameMobileAndName(orgId, studentInfoDto.getMobile(), studentInfoDto.getName());
                this.procSameMobile(orgId, paramMobile);
            }
            return;
        } else {
            this.procSameMobileAndName(orgId, studentInfoDto.getMobile(), studentInfoDto.getName());
            this.procSameMobile(orgId, studentInfoDto.getMobile());
        }
    }

    private void procSameMobileAndName(Long orgId, String mobile, String name) {
        OrgStudent student = this.orgStudentsDao.getStudentByMobileAndName(orgId, mobile, name);
        if (student != null) {
            throw new BussinessException((UniverseErrorCode)CrmErrorCode.STUDENT_HAS_EXISTS);
        }
    }

    private void procSameMobile(Long orgId, String mobile) {
        OrgStudent student = this.orgStudentsDao.getStudentByMobileAndOrgId(orgId, mobile, new String[0]);
        if (student != null) {
            throw new BussinessException((UniverseErrorCode)CrmErrorCode.CUSTOM_HAS_EXISTS);
        }
    }

    private void saveCommentsAndTags(StudentInfoDto studentInfoDto, List<CommentInfoDto> commentDtos, List<TagInfoDto> tagDtos, Long orgId, OrgStudent student) {
        ArrayList comments = Lists.newArrayList();
        ArrayList tags = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(commentDtos)) {
            for (CommentInfoDto commentInfoDto : commentDtos) {
                TxStudentComment comment = new TxStudentComment();
                if (studentInfoDto.getConsultUserId() != null) {
                    comment.setConsultUserId(studentInfoDto.getConsultUserId());
                }
                this.commentDto2Po(commentInfoDto, comment, student.getId(), StudentType.ORG_STUDENTS.getCode(), student);
                comments.add(comment);
            }
            this.txStudentCommentDao.saveAll((List)comments, new String[0]);
            log.info("add comments success!");
        }
        if (CollectionUtils.isNotEmpty(tagDtos)) {
            if (tagDtos.size() > 30) {
                throw new BussinessException((UniverseErrorCode)StudentErrorCode.MAX_TAGS);
            }
            for (TagInfoDto tagDto : tagDtos) {
                String content = tagDto.getContent();
                if (content.length() > 15) {
                    throw new BussinessException((UniverseErrorCode)StudentErrorCode.MAX_TAG_CONTENT_LENGTH);
                }
                TxStudentTag tag = new TxStudentTag();
                this.tagDto2Po(tagDto, tag, student.getId(), StudentType.ORG_STUDENTS.getCode(), student);
                tags.add(tag);
            }
            this.txStudentTagDao.saveAll((List)tags, new String[]{"consultUserId", "userId", "orgId", "content"});
            log.info("add tags success!");
        }
    }

    private void studentDto2Po(StudentInfoDto dto, OrgStudent po, Long orgId, Long userId) {
        if (StringUtils.isNotBlank((CharSequence)dto.getMobile()) && !dto.getMobile().contains("****")) {
            if (!ParamValidateUtils.validateMobile((String)dto.getMobile())) {
                throw new BussinessException((UniverseErrorCode)StudentErrorCode.MOBILE_WRONG);
            }
            po.setShowMobile(dto.getMobile());
            po.setMobile(dto.getMobile());
        }
        po.setAddress(dto.getAddress());
        if (dto.getBirthday() != null) {
            po.setBirthday(new Date(dto.getBirthday()));
        }
        po.setDegreeClass(dto.getDegreeClass());
        po.setFatherOccupation(dto.getFatherOccupation());
        po.setMail(dto.getMail());
        po.setMatherOccupation(dto.getMatherOccupation());
        po.setName(dto.getName());
        po.setNickName(dto.getName());
        if (dto.getNextRemindTime() != null) {
            po.setNextRemindTime(new Date(dto.getNextRemindTime()));
        }
        po.setOrgId(orgId);
        po.setParentName(dto.getParentName());
        po.setParentMobile(dto.getParentMobile());
        po.setQq(dto.getQq());
        if (null != dto.getSource()) {
            po.setSource(dto.getSource());
        }
        if (po.getId() == null || po.getId() == 0L) {
            if (po.getSource() != null && po.getSource().intValue() == MessageSource.ONLINE_IM.getValue()) {
                po.setOrigin(Integer.valueOf(0));
            } else {
                po.setOrigin(Integer.valueOf(1));
            }
        }
        po.setRemark(dto.getRemark());
        po.setGender(dto.getGender());
        po.setUserId(userId);
        po.setWeixin(dto.getWeixin());
        po.setSchool(dto.getSchool());
        po.setBranchId(dto.getBranchId());
        po.setRelationship(dto.getRelationship());
        po.setAvatar(dto.getStorageId());
    }

    private void checkAndCreateComment(StudentInfoDto dto, OrgStudent po) {
        String sourceName = po.getName();
        String sourceMobile = po.getMobile();
        String destName = dto.getName();
        String destMobile = dto.getMobile();
        ArrayList comments = Lists.newArrayList();
        String formatTime = BaseUtils.getFormatDate((String)"yyyy-MM-dd HH:mm", (int)0, (int)5);
        if (destName != null && !destName.equals(sourceName)) {
            StringBuffer content = new StringBuffer();
            content.append(formatTime).append(" \u5c06\u59d3\u540d\u3010").append(sourceName).append("\u3011").append("\u4fee\u6539\u4e3a\u3010").append(destName).append("\u3011");
            comments.add(this.generateComment(po.getOrgId(), content.toString(), po.getUserId()));
        }
        log.info("destMobile param:{}, sourceMobile param:{}", (Object)destMobile, (Object)sourceMobile);
        boolean isdozenMobile = false;
        String dozen = "****";
        if (destMobile.contains(dozen)) {
            isdozenMobile = true;
        }
        if (!isdozenMobile && destMobile != null && !destMobile.equals(sourceMobile)) {
            StringBuffer content = new StringBuffer();
            content.append(formatTime).append(" \u5c06\u624b\u673a\u53f7\u3010").append(sourceMobile).append("\u3011").append("\u4fee\u6539\u4e3a\u3010").append(destMobile).append("\u3011");
            comments.add(this.generateComment(po.getOrgId(), content.toString(), po.getUserId()));
        }
        if (!comments.isEmpty()) {
            this.txStudentCommentDao.saveAll((List)comments, new String[0]);
        }
    }

    private TxStudentComment generateComment(long orgId, String content, long userId) {
        TxStudentComment comment = new TxStudentComment();
        comment.setContent(content);
        comment.setCreateTime(new Date());
        comment.setIsSystem(BizConf.TRUE);
        comment.setOrgId(Long.valueOf(orgId));
        comment.setOrigin(0);
        comment.setUserId(Long.valueOf(userId));
        return comment;
    }

    private void commentDto2Po(CommentInfoDto dto, TxStudentComment po, Long studentId, Integer type, OrgStudent student) {
        if (type.intValue() == StudentType.ORG_STUDENTS.getCode()) {
            po.setOrgId(student.getOrgId());
            po.setUserId(student.getUserId());
        }
        po.setSeconds(dto.getSeconds());
        po.setDownStatus(Integer.valueOf(DownLoadStatus.FINISH.getCode()));
        po.setSoundId(dto.getSoundId());
        po.setStorageIds(dto.getStorageIds());
        po.setContent(dto.getContent());
    }

    private void tagDto2Po(TagInfoDto dto, TxStudentTag po, Long studentId, Integer type, OrgStudent student) {
        if (type.intValue() == StudentType.ORG_STUDENTS.getCode()) {
            po.setOrgId(student.getOrgId());
            po.setUserId(student.getUserId());
        } else {
            po.setConsultUserId(studentId);
        }
        po.setContent(dto.getContent());
    }

    private void studentPo2Dto(OrgStudent po, StudentInfoDto dto, Long orgNumber) {
        OrgStorage storage;
        dto.setOrigin(po.getOrigin());
        dto.setStudentId(po.getId());
        dto.setAddress(po.getAddress());
        if (po.getBirthday() != null) {
            dto.setBirthday(po.getBirthday().getTime());
        }
        dto.setDegreeClass(po.getDegreeClass());
        dto.setFatherOccupation(po.getFatherOccupation());
        dto.setMail(po.getMail());
        dto.setMatherOccupation(po.getMatherOccupation());
        dto.setAddress(po.getAddress());
        dto.setMobile(po.getMobile());
        dto.setName(po.getName());
        if (StringUtils.isBlank((CharSequence)po.getName())) {
            if (StringUtils.isNotEmpty((CharSequence)po.getNickName())) {
                dto.setName(po.getNickName());
            } else {
                dto.setName(MaskUtil.maskMobile((String)po.getMobile()));
            }
        }
        if (po.getNextRemindTime() != null) {
            dto.setNextRemindTime(po.getNextRemindTime().getTime());
        }
        dto.setParentMobile(po.getParentMobile());
        dto.setParentName(po.getParentName());
        dto.setGender(po.getGender());
        dto.setBranchId(po.getBranchId());
        dto.setRelationship(po.getRelationship());
        dto.setQq(po.getQq());
        dto.setSchool(po.getSchool());
        dto.setSource(po.getSource());
        dto.setWeixin(StringUtils.isNotBlank((CharSequence)po.getWeixin()) ? po.getWeixin() : this.getWeixinOpenId(dto.getConsultUserId()));
        if (po.getAvatar() != null && (storage = (OrgStorage)this.orgStorageDao.getById((Serializable)po.getId(), new String[0])) != null) {
            String url = StorageUtil.constructUrl((String)storage.getFid(), (String)storage.getSn(), (Integer)storage.getMimeType());
            dto.setAvatarUrl(url);
        }
    }

    private String getWeixinOpenId(Long consultId) {
        TxConsultUser consulter;
        String weixinOpenId = "";
        if (consultId != null && consultId > 0L && (consulter = (TxConsultUser)this.txConsultUserDao.getById((Serializable)consultId, new String[0])) != null) {
            weixinOpenId = consulter.getWeixinOpenId();
        }
        return weixinOpenId;
    }

    private void getPayMoneyAndTimes(OrgStudent po, StudentInfoDto dto, Long orgNumber) {
        List signupPurchase = this.orgSignupInfoDao.getPurchases(po.getUserId(), orgNumber, null, Integer.valueOf(PayStatus.SUCESS.getCode()), new String[]{"totalPrices", "signupPurchaseId"});
        HashSet courseIds = Sets.newHashSet();
        HashSet purchaseIds = Sets.newHashSet();
        double payMoney = 0.0;
        log.info("OrgStudentServiceImpl:getPayMoneyAndTimes--------signupPurchase{}", (Object)signupPurchase);
        for (Object orgSignupInfo : signupPurchase) {
            payMoney += orgSignupInfo.getTotalPrices().doubleValue() / 100.0;
            purchaseIds.add(orgSignupInfo.getSignupPurchaseId());
        }
        log.info("OrgStudentServiceImpl:getPayMoneyAndTimes---------purchaseIds{}", (Object)purchaseIds);
        List sinupCourses = this.orgSignupCourseDao.loadByPurchaseIds((Collection)purchaseIds, new String[]{"orgCourseId"});
        for (OrgSignupCourse orgSignupCourse : sinupCourses) {
            courseIds.add(orgSignupCourse.getOrgCourseId());
        }
        log.info("OrgStudentServiceImpl:getPayMoneyAndTimes---------sinupCourses{}", (Object)sinupCourses);
        List mPurchase = this.coursePurchaseDao.getCoursePurchaseList(po.getOrgId(), po.getUserId(), Long.valueOf(0L), Integer.valueOf(CourseType.ORG_COURSE.getCode()), Integer.valueOf(PayStatus.SUCESS.getCode()), new String[0]);
        for (CoursePurchase coursePurchase : mPurchase) {
            payMoney += coursePurchase.getPayMoney().doubleValue();
            courseIds.add(coursePurchase.getCourseId());
        }
        log.info("OrgStudentServiceImpl:getPayMoneyAndTimes---------courseIds{}", (Object)courseIds);
        dto.setStar(StarEnum.getStarByPrice(payMoney).getCode());
        dto.setPayMoney(payMoney);
        log.info("studentId ={}, payMoney={}", (Object)po.getId(), (Object)payMoney);
    }

    private void setClassHour(StudentInfoDto dto, Long userId, Long orgId) {
        List list = this.solrStudentQuery.queryStudentClassHourList(userId, orgId);
        int finishCount = 0;
        int leftCount = 0;
        for (StudentClassHour classHour : list) {
            leftCount += classHour.getLeftClassHour();
            finishCount += classHour.getFinishClassHour();
        }
        dto.setTotalClassTime(leftCount + finishCount);
        dto.setFinishClassTime(finishCount);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void delStudent(StudentCommenRequestDto studentCommenRequestDto, Long orgId) {
        Preconditions.checkArgument((orgId != null ? 1 : 0) != 0, (Object)"orgId can not be null");
        if (studentCommenRequestDto.getStudentId() == null) {
            log.warn("mod student error: studentId is null!");
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR);
        }
        OrgStudent orgStudent = (OrgStudent)this.orgStudentsDao.getById((Serializable)studentCommenRequestDto.getStudentId(), new String[0]);
        if (orgStudent == null || orgStudent.getDelStatus().intValue() == DeleteStatus.DELETED.getValue() || orgStudent.getOrgId().longValue() != orgId.longValue()) {
            throw new BussinessException((UniverseErrorCode)StudentErrorCode.STUDENT_NOT_EXIST);
        }
        List consultUserList = this.txConsultUserDao.lookByStudentId(orgId, studentCommenRequestDto.getStudentId(), new String[0]);
        log.info("OrgStudentServiceImpl:delStudent--------consultUserList={}", (Object)consultUserList);
        if (null != consultUserList && !consultUserList.isEmpty()) {
            this.delSysBacklog(orgId, orgStudent, (TxConsultUser)consultUserList.get(0));
            for (TxConsultUser consulterUser : consultUserList) {
                consulterUser.setStudentId(Long.valueOf(0L));
                consulterUser.setIsConsulter(Integer.valueOf(0));
                this.txConsultUserDao.update((Object)consulterUser, new String[]{"studentId", "isConsulter"});
            }
        } else {
            this.delSysBacklog(orgId, orgStudent, null);
        }
        orgStudent.setDelStatus(Integer.valueOf(DeleteStatus.DELETED.getValue()));
        TxStudentComment comment = new TxStudentComment();
        comment.setContent("\u673a\u6784\u5220\u9664\u5b66\u5458");
        comment.setUserId(orgStudent.getUserId());
        comment.setOrgId(orgStudent.getOrgId());
        comment.setIsSystem(Integer.valueOf(AddType.SYSTEM.getCode()));
        this.txStudentCommentDao.save((Object)comment, new String[0]);
        this.txStudentTagDao.delTags(orgStudent.getUserId(), orgId);
        this.orgStudentsDao.update((Object)orgStudent, new String[]{"delStatus"});
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void modStudent(StudentInfoDto studentInfoDto, List<CommentInfoDto> commentDtos, List<TagInfoDto> tagDtos, Long orgId) {
        Preconditions.checkArgument((orgId != null ? 1 : 0) != 0, (Object)"orgId can not be null");
        if (studentInfoDto.getStudentId() == null) {
            log.warn("mod student error: studentId is null!");
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR);
        }
        this.saveBefore(studentInfoDto, orgId);
        OrgStudent orgStudent = (OrgStudent)this.orgStudentsDao.getById((Serializable)studentInfoDto.getStudentId(), new String[0]);
        log.info("orgStudent param:{}", (Object)orgStudent);
        if (orgStudent == null || orgStudent.getDelStatus().intValue() == DeleteStatus.DELETED.getValue() || orgStudent.getOrgId().longValue() != orgId.longValue()) {
            throw new BussinessException((UniverseErrorCode)StudentErrorCode.STUDENT_NOT_EXIST);
        }
        this.checkAndCreateComment(studentInfoDto, orgStudent);
        this.cascadeUpdateTxConsultName(orgId, orgStudent, studentInfoDto);
        this.studentDto2Po(studentInfoDto, orgStudent, orgId, orgStudent.getUserId());
        log.info("studentId param:{}, orgId param:{}", (Object)orgStudent.getUserId(), (Object)orgId);
        this.txStudentTagDao.delTags(orgStudent.getUserId(), orgId);
        if (GenericsUtils.notNullAndEmpty(tagDtos)) {
            if (tagDtos.size() > 30) {
                throw new BussinessException((UniverseErrorCode)StudentErrorCode.MAX_TAGS);
            }
            ArrayList<TxStudentTag> tags = new ArrayList<TxStudentTag>();
            for (TagInfoDto tagInfoDto : tagDtos) {
                String content = tagInfoDto.getContent();
                if (content.length() > 15) {
                    throw new BussinessException((UniverseErrorCode)StudentErrorCode.MAX_TAG_CONTENT_LENGTH);
                }
                TxStudentTag tag = new TxStudentTag();
                this.tagDto2Po(tagInfoDto, tag, orgStudent.getId(), StudentType.ORG_STUDENTS.getCode(), orgStudent);
                tags.add(tag);
            }
            this.txStudentTagDao.saveAll(tags, new String[]{"consultUserId", "userId", "orgId", "content"});
            log.info("add tags success!");
        }
        this.orgStudentsDao.update((Object)orgStudent, Boolean.valueOf(false), new String[0]);
        this.updateSysBacklog(orgId, orgStudent, null);
    }

    private void cascadeUpdateTxConsultName(long orgId, OrgStudent orgStudent, StudentInfoDto studentInfo) {
        List consultUsers;
        boolean updateMobile;
        boolean updateName = !studentInfo.getName().equals(orgStudent.getName());
        boolean bl = updateMobile = !studentInfo.getMobile().equals(orgStudent.getMobile());
        if ((updateName || updateMobile) && (consultUsers = this.txConsultUserDao.lookByStudentId(Long.valueOf(orgId), orgStudent.getId(), new String[0])) != null && !consultUsers.isEmpty()) {
            for (TxConsultUser consultUser : consultUsers) {
                consultUser.setName(updateName ? studentInfo.getName() : null);
                consultUser.setMobile(updateMobile ? studentInfo.getMobile() : null);
                consultUser.setUpdateTime(new Date());
                this.txConsultUserDao.update((Object)consultUser, Boolean.valueOf(false), new String[0]);
            }
        }
    }

    private void cascadeUpdateTxConsultName(long orgId, long studentId, String sourceName, String destName) {
        List consultUsers;
        if (!destName.equals(sourceName) && (consultUsers = this.txConsultUserDao.lookByStudentId(Long.valueOf(orgId), Long.valueOf(studentId), new String[0])) != null && !consultUsers.isEmpty()) {
            for (TxConsultUser consultUser : consultUsers) {
                consultUser.setName(destName);
                consultUser.setUpdateTime(new Date());
                this.txConsultUserDao.update((Object)consultUser, new String[]{"name", "updateTime"});
            }
        }
    }

    @Override
    @Transactional(readOnly=true)
    public StudentInfoDto getStudentInfo(StudentCommenRequestDto studentCommenRequestDto, Long orgId) {
        boolean hasPermission;
        boolean canVisit;
        Preconditions.checkArgument((orgId != null ? 1 : 0) != 0, (Object)"orgId can not be null");
        OrgAccount account = (OrgAccount)this.orgAccountDao.getById((Serializable)orgId, new String[0]);
        boolean isShowMobile = this.txCascadeCredentialService.isShowMobile(orgId, TianxiaoMContext.getTXCascadeId());
        if (account == null) {
            throw new BussinessException((UniverseErrorCode)StudentErrorCode.ORG_NOT_EXIST);
        }
        if (studentCommenRequestDto.getStudentId() == null) {
            log.warn("get student info error: studentId is null!");
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR);
        }
        OrgStudent orgStudent = (OrgStudent)this.orgStudentsDao.getById((Serializable)studentCommenRequestDto.getStudentId(), new String[0]);
        log.debug("query result------student:{}", (Object)orgStudent);
        if (orgStudent == null || orgStudent.getDelStatus().intValue() == DeleteStatus.DELETED.getValue() || orgStudent.getOrgId().longValue() != orgId.longValue()) {
            throw new BussinessException((UniverseErrorCode)StudentErrorCode.STUDENT_NOT_EXIST);
        }
        AccountRoleType findAccountRoleType = this.txAccountHelpService.findAccountRoleType(orgId, TianxiaoMContext.getTXCascadeId());
        if (findAccountRoleType.getRoleType() == RoleType.EMPLOYEE && !(canVisit = this.checkCanVisit(orgStudent.getUserId(), account.getNumber(), TianxiaoMContext.getTXCascadeId(), orgId))) {
            throw new BussinessException((UniverseErrorCode)StudentErrorCode.STUDENT_NOT_BELONG);
        }
        User user = (User)this.userDao.getById((Serializable)orgStudent.getUserId(), new String[0]);
        if (user == null) {
            throw new BussinessException((UniverseErrorCode)StudentErrorCode.STUDENT_NOT_EXIST);
        }
        StudentInfoDto dto = new StudentInfoDto();
        List consults = this.txConsultUserDao.lookByStudentId(orgId, orgStudent.getId(), new String[0]);
        if (CollectionUtils.isNotEmpty((Collection)consults)) {
            HashSet consultUserIds = Sets.newHashSet();
            for (TxConsultUser txConsultUser : consults) {
                consultUserIds.add(txConsultUser.getId());
            }
            dto.setConsultUserIds(StringUtils.join((Object[])consultUserIds.toArray(), (char)','));
            dto.setConsultUserId(((TxConsultUser)consults.get(0)).getId());
        }
        dto.setStudentNumber(user.getNumber());
        this.studentPo2Dto(orgStudent, dto, account.getNumber().longValue());
        this.getPayMoneyAndTimes(orgStudent, dto, account.getNumber().longValue());
        this.setClassHour(dto, orgStudent.getUserId(), orgStudent.getOrgId());
        List comments = this.txStudentCommentDao.getComments(orgStudent.getUserId(), orgId, Integer.valueOf(StudentType.ORG_STUDENTS.getCode()), new String[0]);
        log.info("OrgStudentServiceImpl:getStudentInfo--------List<TxStudentComment> comments={}", (Object)comments);
        ArrayList commentsDto = Lists.newArrayList();
        HashSet callIds = Sets.newHashSet();
        HashSet call400Ids = Sets.newHashSet();
        for (TxStudentComment comment : comments) {
            if (comment.getDownStatus().intValue() != DownLoadStatus.UNFINISH.getCode()) continue;
            if (comment.getIsMobile().intValue() == MobileStatus.IS_CALL.getCode()) {
                callIds.add(comment.getSoundId());
                continue;
            }
            if (comment.getIsMobile().intValue() != MobileStatus.IS_400_CALL.getCode()) continue;
            call400Ids.add(comment.getSoundId());
        }
        Map<Long, Long> callMap = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty((Collection)callIds)) {
            List callInfos = this.callServiceInfoDao.getByIds((Collection)callIds, new String[0]);
            callMap = CollectorUtil.collectMap((Collection)callInfos, (Function)new Function<CallServiceInfo, Long>(){

                public Long apply(CallServiceInfo arg0) {
                    return arg0.getId();
                }
            }, (Function)new Function<CallServiceInfo, Long>(){

                public Long apply(CallServiceInfo arg0) {
                    return arg0.getStorageId();
                }
            });
        }
        Map<Long, Long> call400Map = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty((Collection)call400Ids)) {
            List call400Infos = this.orgPushCallInfoDao.getByIds((Collection)call400Ids, new String[0]);
            call400Map = CollectorUtil.collectMap((Collection)call400Infos, (Function)new Function<OrgPushCallInfo, Long>(){

                public Long apply(OrgPushCallInfo arg0) {
                    return arg0.getId();
                }
            }, (Function)new Function<OrgPushCallInfo, Long>(){

                public Long apply(OrgPushCallInfo arg0) {
                    return arg0.getStorageId();
                }
            });
        }
        HashSet storageIds = Sets.newHashSet();
        for (TxStudentComment comment : comments) {
            if (StringUtils.isNotEmpty((CharSequence)comment.getStorageIds())) {
                String[] storageIdsStr = comment.getStorageIds().split(",");
                for (String storageId : storageIdsStr) {
                    storageIds.add(Integer.parseInt(storageId));
                }
            }
            if (comment.getDownStatus().intValue() == DownLoadStatus.UNFINISH.getCode()) {
                Long storageId = null;
                if (comment.getIsMobile().intValue() == MobileStatus.IS_CALL.getCode()) {
                    storageId = (Long)callMap.get(comment.getSoundId());
                } else if (comment.getIsMobile().intValue() == MobileStatus.IS_400_CALL.getCode()) {
                    storageId = (Long)call400Map.get(comment.getSoundId());
                }
                if (storageId == null || storageId <= 0L) continue;
                storageIds.add(storageId.intValue());
                continue;
            }
            if (comment.getDownStatus().intValue() != DownLoadStatus.FINISH.getCode() || comment.getSoundId() == null || comment.getSoundId() <= 0L) continue;
            storageIds.add(comment.getSoundId().intValue());
        }
        List storages = this.orgStorageDao.getByIds((Collection)storageIds, new String[0]);
        Map storageMap = CollectorUtil.collectMap((Collection)storages, (Function)new Function<OrgStorage, Integer>(){

            public Integer apply(OrgStorage arg0) {
                return arg0.getId();
            }
        });
        HashSet<Integer> cascadeIds = new HashSet<Integer>();
        for (TxStudentComment comment : comments) {
            cascadeIds.add(comment.getCreatorCascadeId());
        }
        Map cascadeIdVSNameMap = this.txCascadeCredentialDao.getTxCascadCredentialListByCascdeIds(cascadeIds);
        OrgInfo orgInfo = this.orgInfoDao.getOrgInfo(Integer.valueOf(orgId.intValue()), new String[0]);
        cascadeIdVSNameMap.put(0L, orgInfo.getShowName());
        for (TxStudentComment comment : comments) {
            CommentInfoDto commentDto = new CommentInfoDto();
            this.commentPo2Dto(commentDto, comment, callMap, call400Map, storageMap, cascadeIdVSNameMap);
            if (!isShowMobile) {
                commentDto.setContent(CommentUtil.maskMobile(comment.getContent()));
            }
            commentsDto.add(commentDto);
        }
        log.info("OrgStudentServiceImpl:getStudentInfo--------List<CommentInfoDto> commentsDto={}", (Object)commentsDto);
        dto.setCommentsResp(commentsDto);
        List tags = this.txStudentTagDao.getTags(orgStudent.getUserId(), orgId, Integer.valueOf(StudentType.ORG_STUDENTS.getCode()), new String[0]);
        ArrayList tagsDto = Lists.newArrayList();
        for (TxStudentTag tag : tags) {
            TagInfoDto tagDto = new TagInfoDto();
            this.tagPo2Dto(tagDto, tag);
            tagsDto.add(tagDto);
        }
        dto.setTagsResp(tagsDto);
        boolean isStaffAccount = false;
        Integer casCadeId = studentCommenRequestDto.getCasCadeId();
        if (casCadeId != null && !(hasPermission = this.txAccountPermissionService.hasPermission(Long.valueOf(studentCommenRequestDto.getCasCadeId().longValue()), ApplicationType.getApplicationType((Integer)studentCommenRequestDto.getApplicationType()), TXPermissionConstant.CHAKAN_SUOYOU_XUEYUAN))) {
            isStaffAccount = true;
        }
        HashSet<Integer> casCadeIds = new HashSet<Integer>();
        List orgCourseIds = this.orgStudentCourseDao.getOrgCourseIds(orgId, orgStudent.getUserId(), null);
        List courseIds = ListUtil.toKeyList((Collection)orgCourseIds, (String)"courseId", OrgStudentCourse.class);
        List courses = this.orgCourseDao.getByIds((Collection)courseIds, new String[]{"cascadeId"});
        if (!isStaffAccount) {
            casCadeIds.addAll(ListUtil.toKeyList((Collection)courses, (String)"cascadeId", OrgCourse.class));
        } else if (casCadeId != null) {
            casCadeIds.add(casCadeId);
        }
        Map txCascadCredentialListByCascdeIds = this.txCascadeCredentialDao.getTxCascadCredentialListByCascdeIds(casCadeIds);
        StringBuilder sb = new StringBuilder();
        for (String name : txCascadCredentialListByCascdeIds.values()) {
            sb.append(name).append("\u3001");
        }
        String headTeacherNames = GenericsUtils.deleteLastCharToString((StringBuilder)sb);
        dto.setHeadTeacher(headTeacherNames);
        Integer sumClasses = GenericsUtils.isNullOrEmpty((Object)orgCourseIds) ? 0 : orgCourseIds.size();
        dto.setSumClasses(sumClasses);
        this.getFansInfo(dto);
        Long userId = orgStudent.getUserId();
        Map studentAvatarUrlMap = this.consultAvatarUrlService.batchStudentAvatarUrlAndNameDMap((Collection)Lists.newArrayList((Object[])new Long[]{userId}), orgId);
        ConsultAvatarUrlAndNameDto avartarUrlDto = (ConsultAvatarUrlAndNameDto)studentAvatarUrlMap.get(userId);
        String avatarUrl = avartarUrlDto.getAvatarUrl();
        log.info("avatarUrl param:{}", (Object)avatarUrl);
        dto.setAvatarUrl(avatarUrl);
        if (!isShowMobile) {
            dto.setMobile(MaskUtil.maskMobile((String)dto.getMobile()));
            dto.setParentMobile(MaskUtil.maskMobile((String)dto.getParentMobile()));
        }
        return dto;
    }

    private boolean checkCanVisit(Long userId, Integer orgNumber, Integer cascadeId, Long orgId) {
        List courseByCasCadeIds = this.orgCourseDao.getCourseByCasCadeIds(orgNumber, Arrays.asList(cascadeId), new String[]{"id"});
        if (GenericsUtils.isNullOrEmpty((Object)courseByCasCadeIds)) {
            return false;
        }
        List courseIds = ListUtil.toKeyList((Collection)courseByCasCadeIds, (String)"id", OrgCourse.class);
        for (Long courseId : courseIds) {
            OrgStudentCourse studentCourse = this.orgStudentCourseDao.getStudentCourse(orgId, courseId, userId);
            if (studentCourse == null) continue;
            return true;
        }
        return false;
    }

    private int sumClasses(long orgId, long userId) {
        HashSet<Long> ret = new HashSet<Long>();
        List courseIds = this.orgStudentCourseDao.getStudentCourseIds(Long.valueOf(orgId), Long.valueOf(userId), Integer.valueOf(0));
        ret.addAll(courseIds);
        List classHourList = this.solrStudentQuery.queryStudentClassHourList(Long.valueOf(userId), Long.valueOf(orgId));
        for (StudentClassHour classHour : classHourList) {
            ret.add(classHour.getCourseId());
        }
        return ret.size();
    }

    private Integer getSignupClassCount(OrgStudent po, long orgNumber) {
        return this.orgStudentCourseService.getStudentSignupCourse(po, orgNumber);
    }

    private void getFansInfo(StudentInfoDto dto) {
        if (dto != null && StringUtils.isNotBlank((CharSequence)dto.getWeixin())) {
            Fans fans = this.fansDao.getByOpenId(dto.getWeixin());
            if (fans != null) {
                dto.setChat(BizConf.TRUE);
                dto.setLastCommunicationTime(fans.getLastCommunicationTime() == null ? null : Long.valueOf(fans.getLastCommunicationTime().getTime()));
            } else {
                dto.setChat(BizConf.FALSE);
            }
        }
    }

    private void commentPo2Dto(CommentInfoDto dto, TxStudentComment po, Map<Long, Long> callMap, Map<Long, Long> call400Map, Map<Integer, OrgStorage> storageMap, Map<Long, String> cascadeIdVSNameMap) {
        OrgStorage storage;
        dto.setCommentId(po.getId());
        dto.setContent(po.getContent());
        dto.setStorageIds(po.getStorageIds());
        dto.setCreateTime(po.getCreateTime());
        dto.setCallStatus(po.getCallStatus());
        dto.setIsMobile(po.getIsMobile());
        dto.setIsSystem(po.getIsSystem());
        if (null != po.getIsMobile() && po.getIsMobile().intValue() == MobileStatus.IS_CALL.getCode()) {
            dto.setOrigin(-1);
        } else {
            dto.setOrigin(po.getOrigin());
        }
        if (StringUtils.isNotEmpty((CharSequence)dto.getStorageIds())) {
            String[] storageIdsStr = dto.getStorageIds().split(",");
            ArrayList urls = Lists.newArrayList();
            for (String storageId : storageIdsStr) {
                OrgStorage storage2 = storageMap.get(Integer.parseInt(storageId));
                if (storage2 == null) continue;
                String url = StorageUtil.constructUrl((String)storage2.getFid(), (String)storage2.getSn(), (Integer)storage2.getMimeType());
                urls.add(url);
            }
            dto.setUrls(StringUtils.join((Object[])urls.toArray(new String[urls.size()]), (String)","));
        }
        if (po.getDownStatus().intValue() == DownLoadStatus.UNFINISH.getCode()) {
            Long storageId = null;
            if (po.getIsMobile().intValue() == MobileStatus.IS_CALL.getCode()) {
                storageId = callMap.get(po.getSoundId());
            } else if (po.getIsMobile().intValue() == MobileStatus.IS_400_CALL.getCode()) {
                storageId = call400Map.get(po.getSoundId());
            }
            if (storageId != null && storageId > 0L) {
                po.setSoundId(storageId);
                po.setDownStatus(Integer.valueOf(DownLoadStatus.FINISH.getCode()));
                this.txStudentCommentDao.update((Object)po, new String[]{"downStatus", "soundId"});
            }
        }
        if (po.getSoundId() > 0L && po.getDownStatus().intValue() == DownLoadStatus.FINISH.getCode() && (storage = storageMap.get(po.getSoundId().intValue())) != null) {
            dto.setSeconds(po.getSeconds());
            dto.setSoundId(po.getSoundId());
            dto.setSoundUrl(StorageUtil.constructUrl((String)storage.getFid(), (String)storage.getSn(), (Integer)storage.getMimeType()));
        }
        dto.setDownLoadStatus(po.getDownStatus());
        dto.setCommentType(po.getCommentType());
        dto.setGrowthComments(po.getGrowthComments());
        dto.setNotifyParents(po.getNotifyParents());
        dto.setCreatorCascadeId(po.getCreatorCascadeId());
        CreatorDto creatorDto = new CreatorDto();
        creatorDto.setCascadeId(po.getCreatorCascadeId());
        if (po.getCreatorCascadeId().intValue() != Flag.NULL.getInt()) {
            creatorDto.setName(cascadeIdVSNameMap.get(Long.parseLong(po.getCreatorCascadeId() + "")));
        } else if (po.getIsSystem().intValue() == Flag.TRUE.getInt()) {
            creatorDto.setName("\u7cfb\u7edf");
        } else {
            creatorDto.setName("\u5386\u53f2\u7528\u6237");
        }
        dto.setCreator(creatorDto);
    }

    private void tagPo2Dto(TagInfoDto dto, TxStudentTag po) {
        dto.setTagId(po.getId());
        dto.setContent(po.getContent());
    }

    @Override
    @Transactional(readOnly=true)
    public StudentInfoListReponseDto getStudentList(StudentListRequestDto studentListRequestDto, Long orgId, PageDto pageDto) {
        Preconditions.checkArgument((orgId != null ? 1 : 0) != 0, (Object)"orgId can not be null");
        OrgAccount account = (OrgAccount)this.orgAccountDao.getById((Serializable)orgId, new String[0]);
        if (account == null) {
            throw new BussinessException((UniverseErrorCode)StudentErrorCode.ORG_NOT_EXIST);
        }
        StudentInfoListReponseDto responseDto = new StudentInfoListReponseDto();
        ArrayList dtos = Lists.newArrayList();
        List list = Lists.newArrayList();
        responseDto.setList(dtos);
        if (studentListRequestDto.getCourseNumber() != null && studentListRequestDto.getCourseType() != null) {
            if (studentListRequestDto.getCourseType().intValue() == CourseType.CLASS.getCode() || studentListRequestDto.getCourseType().intValue() == CourseType.TRIAL_COURSE.getCode()) {
                ArrayList purchases = Lists.newArrayList();
                HashSet userIds = Sets.newHashSet();
                for (CoursePurchase coursePurchase : purchases) {
                    userIds.add(coursePurchase.getUserId());
                }
                list = this.orgStudentsDao.getStudents(orgId, (Collection)userIds, Integer.valueOf(DeleteStatus.NORMAL.getValue()), pageDto, new String[]{"id", "name", "mobile", "weixin", "createTime"});
            } else {
                OrgCourse course = this.orgCourseDao.getCourseByCourseNumberAndOrgNumber(Long.valueOf(account.getId().longValue()), studentListRequestDto.getCourseNumber(), new String[]{"id"});
                if (course != null) {
                    List studentIds = this.orgStudentCourseDao.getStudents(orgId, course.getId());
                    list = this.orgStudentsDao.getByIdsAndOrderByParam((Collection)studentIds, "createTime", new String[]{"id", "name", "mobile", "weixin", "createTime"});
                }
            }
        } else {
            if (pageDto == null) {
                throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR);
            }
            list = this.orgStudentsDao.getStudents(orgId, studentListRequestDto.getSearchKey(), Integer.valueOf(DeleteStatus.NORMAL.getValue()), pageDto, new String[]{"id", "name", "mobile", "weixin", "createTime"});
        }
        for (OrgStudent student : list) {
            StudentInfoReponseDto dto = new StudentInfoReponseDto();
            this.buidStudentInfoReponseDto(dto, student);
            dtos.add(dto);
        }
        return responseDto;
    }

    @Override
    @Transactional(readOnly=true)
    public StudentInfoListReponseDto getStudentList(StudentListRequestDto studentListRequestDto, List<Long> studentids, Long orgId, PageDto pageDto) {
        Preconditions.checkArgument((orgId != null ? 1 : 0) != 0, (Object)"orgId can not be null");
        OrgAccount account = (OrgAccount)this.orgAccountDao.getById((Serializable)orgId, new String[0]);
        if (account == null) {
            throw new BussinessException((UniverseErrorCode)StudentErrorCode.ORG_NOT_EXIST);
        }
        StudentInfoListReponseDto responseDto = new StudentInfoListReponseDto();
        ArrayList dtos = Lists.newArrayList();
        List list = Lists.newArrayList();
        responseDto.setList(dtos);
        if (pageDto == null) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR);
        }
        list = this.orgStudentsDao.getStudents(orgId, studentids, studentListRequestDto.getSearchKey(), Integer.valueOf(DeleteStatus.NORMAL.getValue()), pageDto, new String[]{"id", "name", "mobile", "weixin", "createTime"});
        for (OrgStudent student : list) {
            StudentInfoReponseDto dto = new StudentInfoReponseDto();
            this.buidStudentInfoReponseDto(dto, student);
            dtos.add(dto);
        }
        return responseDto;
    }

    public AccountRoleType findAccountRoleType(Long orgId, Integer cascadeId) {
        AccountRoleType ary = new AccountRoleType();
        OrgAccount accountById = this.orgAccountDao.getAccountById(orgId.intValue(), new String[0]);
        RoleType superRole = null;
        if (cascadeId != null && (long)cascadeId.intValue() != 0L) {
            TXCascadeAccount tca = (TXCascadeAccount)this.txCascadeAccountDao.getById((Serializable)cascadeId, new String[0]);
            if (tca == null) {
                log.info("can not find any cascade account with cadcadeId : {} ", (Object)cascadeId);
                return null;
            }
            Integer accountType = tca.getAccountType();
            superRole = RoleType.getRoleType((Integer)accountType);
        } else {
            OrgSubAccount osa = this.orgSubAccountDao.getByOrgId(Integer.valueOf(orgId.intValue()));
            if (osa == null) {
                if (accountById == null) {
                    log.info(" can not find any org account with orgId : {} ", (Object)orgId);
                    return null;
                }
                superRole = RoleType.PRESIDENT;
            } else {
                Integer pId = osa.getPid();
                superRole = 0 == pId ? RoleType.PRESIDENT : RoleType.BRANCH_SCH_PRESIDENT;
            }
        }
        ary.setCasCadeId(cascadeId);
        ary.setOrgId(orgId);
        ary.setRoleType(superRole);
        ary.setOrgNumber(accountById.getNumber());
        return ary;
    }

    public static void main(String[] args) {
        boolean canAccess = RequestSourceDesc.STUDENT_LIST.canAccess("searchStudentList", OrgStudentServiceImpl.class, RoleType.CHARAGE, new Class[]{StudentListRequestDto.class, Long.class, PageDto.class});
        System.out.println("can access " + canAccess);
        canAccess = RequestSourceDesc.STUDENT_LIST.canAccess("getStudentStatusStatisticsByOrgId", OrgStudentServiceImpl.class, RoleType.CHARAGE, new Class[]{Long.class});
        System.out.println("can access " + canAccess);
    }

    @Override
    @Transactional(readOnly=true)
    @DataAuthority(resourceTypes={RequestSourceDesc.STUDENT_LIST})
    public List<StudentDto> searchStudentList(StudentListRequestDto studentListRequestDto, Long orgId, PageDto pageDto) {
        boolean canAccess;
        Preconditions.checkArgument((orgId != null ? 1 : 0) != 0, (Object)"orgId can not be null");
        OrgAccount account = (OrgAccount)this.orgAccountDao.getById((Serializable)orgId, new String[0]);
        if (account == null) {
            throw new BussinessException((UniverseErrorCode)StudentErrorCode.ORG_NOT_EXIST);
        }
        StudentQueryParam param = this.buildByStudentListRequestDto(studentListRequestDto);
        param.setOrgId(orgId);
        if (studentListRequestDto.getCourseNumber() != null && studentListRequestDto.getCourseNumber() > 0L) {
            OrgCourse course = this.orgCourseDao.getOrgCourse(account.getNumber(), studentListRequestDto.getCourseNumber());
            if (course == null) {
                return Collections.emptyList();
            }
            List userIds = this.orgStudentCourseDao.getStudents(orgId, course.getId());
            if (userIds == null || userIds.size() < 1) {
                return Collections.emptyList();
            }
            param.setStudentIds(new HashSet(userIds));
        }
        if (!(canAccess = RequestSourceDesc.STUDENT_LIST.canAccess("searchStudentList", this.getClass(), new Class[]{StudentListRequestDto.class, Long.class, PageDto.class}))) {
            log.info("\u5f53\u524d\u89d2\u8272 orgId : {} , cascadeId : {}\u6ca1\u6709\u83b7\u53d6\u5b66\u5458\u5217\u8868\u7684\u6743\u9650\uff0c\u8fdb\u884c\u6570\u636e\u63a7\u5236", (Object)orgId, (Object)TianxiaoMContext.getTXCascadeId());
            param.setNeedQueryByAuthority(true);
            AccountRoleType accountRoleType = RequestSourceDesc.STUDENT_LIST.getAccountRoleType();
            log.info("accountRoleType is : {} ", (Object)accountRoleType);
            param.setOrgId(accountRoleType.getOrgId());
            param.setCasCadeId(Integer.valueOf(accountRoleType.getCasCadeId() == null ? 0 : accountRoleType.getCasCadeId()));
            param.setOrgNumber(accountRoleType.getOrgNumber());
        }
        final boolean isShow = this.txCascadeCredentialService.isShowMobile(orgId, TianxiaoMContext.getTXCascadeId());
        List studentDtos = this.solrStudentQuery.queryStudent(param, pageDto);
        log.debug("searchStudentList params={},page={},result={}", new Object[]{param, pageDto, studentDtos.size()});
        Map userIdMap = com.baijia.commons.lang.utils.collection.CollectionUtils.extractMap((Collection)studentDtos, (CollectionUtils.Extracter)new CollectionUtils.Extracter<Long, StudentDto>(){

            public Long extract(StudentDto studentDto) {
                String pinyin = studentDto.getPinyin();
                if (StringUtils.isBlank((CharSequence)pinyin)) {
                    pinyin = StringUtils.isNotBlank((CharSequence)studentDto.getName()) ? HanZiPinYinUtils.getLowerCasePinYin((String)studentDto.getName()) : HanZiPinYinUtils.getLowerCasePinYin((String)studentDto.getMobile());
                }
                String str = "#";
                if (StringUtils.isNotBlank((CharSequence)pinyin)) {
                    char init = pinyin.charAt(0);
                    str = String.valueOf(init);
                }
                if (str.equals("~")) {
                    str = "#";
                }
                studentDto.setInitial(str.toUpperCase());
                if (!isShow) {
                    studentDto.setMobile(MaskUtil.maskMobile((String)studentDto.getMobile()));
                }
                return studentDto.getUserId();
            }
        });
        Map studentAvatarUrlMap = this.consultAvatarUrlService.batchStudentAvatarUrlAndNameDMap(userIdMap.keySet(), orgId);
        log.info("studentAvatarUrlMap param:{}", (Object)studentAvatarUrlMap);
        for (Long userId : userIdMap.keySet()) {
            StudentDto student = (StudentDto)userIdMap.get(userId);
            if (student == null) continue;
            ConsultAvatarUrlAndNameDto dto = (ConsultAvatarUrlAndNameDto)studentAvatarUrlMap.get(userId);
            student.setAvatarUrl(dto.getAvatarUrl());
        }
        return studentDtos;
    }

    private StudentQueryParam buildByStudentListRequestDto(StudentListRequestDto dto) {
        StudentQueryParam param = new StudentQueryParam();
        param.setLessonStatus(dto.getIsSchedule());
        param.setLeftMinClassHour(dto.getLeftMinClassHour());
        param.setLeftMaxClassHour(dto.getLeftMaxClassHour());
        param.setEnrollTime(TimeType.getTimeTypeByCode((Integer)dto.getEnrollDate()));
        param.setFollowTime(TimeType.getTimeTypeByCode((Integer)dto.getFollowDate()));
        param.setCreateTime(TimeType.getTimeTypeByCode((Integer)dto.getCreateDate()));
        param.setStatus(StudentLessonStatus.getStatus((Integer)dto.getStudentStatus()));
        param.setOpType(OpType.getOpType((Integer)dto.getOpType()));
        param.setSearchKey(dto.getSearchKey());
        param.setGender(dto.getSex());
        return param;
    }

    private void buidStudentInfoReponseDto(StudentInfoReponseDto dto, OrgStudent student) {
        OrgStorage storage;
        dto.setName(student.getName());
        dto.setStudentId(student.getId());
        if (StringUtils.isBlank((CharSequence)student.getShowMobile())) {
            dto.setMobile(MaskUtil.maskMobile((String)student.getMobile()));
        } else {
            dto.setMobile(student.getShowMobile());
        }
        dto.setWeixin(student.getWeixin());
        if (StringUtils.isBlank((CharSequence)student.getName())) {
            if (StringUtils.isNotEmpty((CharSequence)student.getNickName())) {
                dto.setName(student.getNickName());
            } else {
                dto.setName(dto.getMobile());
            }
        }
        if (student.getAvatar() != null && (storage = (OrgStorage)this.orgStorageDao.getById((Serializable)student.getAvatar(), new String[0])) != null) {
            String url = StorageUtil.constructUrl((String)storage.getFid(), (String)storage.getSn(), (Integer)storage.getMimeType());
            dto.setAvatarUrl(url);
        }
        if (StringUtils.isNotBlank((CharSequence)student.getPinyin())) {
            char init = student.getPinyin().charAt(0);
            String str = String.valueOf(init);
            dto.setInitial(str.toLowerCase());
        }
    }

    @Override
    @Transactional(readOnly=true)
    public MobileCheckReponseDto checkmobile(Long orgId, List<MobileCheckInfoRequestDto> mobiles) {
        MobileCheckReponseDto reponse = new MobileCheckReponseDto();
        ArrayList failds = Lists.newArrayList();
        reponse.setFailds(failds);
        if (CollectionUtils.isNotEmpty(mobiles)) {
            HashSet mobileSet = Sets.newHashSet();
            for (MobileCheckInfoRequestDto dto : mobiles) {
                mobileSet.add(dto.getMobile());
            }
            List students = this.orgStudentsDao.getStudents(orgId, (Collection)mobileSet, Integer.valueOf(DeleteStatus.NORMAL.getValue()), new String[]{"mobile"});
            HashSet existMobile = Sets.newHashSet();
            for (OrgStudent student : students) {
                existMobile.add(student.getMobile());
            }
            for (MobileCheckInfoRequestDto dto : mobiles) {
                if (!existMobile.contains(dto.getMobile())) continue;
                failds.add(dto.getId());
            }
        }
        return reponse;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public List<BatchAddStudentResponseDto> batchAddStudent(List<StudentInfoDto> studentInfoDtos, Long orgId) {
        for (StudentInfoDto studentInfoDto : studentInfoDtos) {
            if (ParamValidateUtils.validateMobile((String)studentInfoDto.getMobile())) continue;
            throw new BussinessException((UniverseErrorCode)StudentErrorCode.MOBILE_WRONG);
        }
        ArrayList addStudentResponseDtos = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(studentInfoDtos)) {
            Map mobileMap = CollectorUtil.collectMap(studentInfoDtos, (Function)new Function<StudentInfoDto, String>(){

                public String apply(StudentInfoDto input) {
                    return input.getMobile();
                }
            });
            List students = this.orgStudentsDao.getStudents(orgId, mobileMap.keySet(), Integer.valueOf(DeleteStatus.NORMAL.getValue()), new String[]{"mobile"});
            HashSet mobiles = Sets.newHashSet();
            for (OrgStudent student : students) {
                mobiles.add(student.getMobile());
            }
            for (StudentInfoDto dto : studentInfoDtos) {
                OrgStudentAddresponseDto result;
                if (mobiles.contains(dto.getMobile()) || (result = this.addStudent(dto, null, null, orgId)) == null) continue;
                BatchAddStudentResponseDto responseDto = new BatchAddStudentResponseDto();
                responseDto.setMobile(dto.getMobile());
                responseDto.setStudentId(result.getStudentId());
                addStudentResponseDtos.add(responseDto);
            }
        }
        return addStudentResponseDtos;
    }

    @Override
    @Transactional(readOnly=true)
    public Map<Long, Long> getStudentIdUserIdMap(Collection<Long> studentIds) {
        return this.orgStudentsDao.getStudentIdUserIdMap(studentIds);
    }

    @Override
    public Map<Long, String> getStudentNameMap(Collection<Long> studentIds) {
        return this.orgStudentsDao.getStudentNameMap(studentIds);
    }

    @Override
    public Map<Long, Long> getUserIdStudentIdMap(Collection<Long> userIds, Long orgId) {
        return this.orgStudentsDao.getUserIdStudentIdMap(userIds, orgId);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public StudentInfoDto getAndUpdateOrgStudentByMobile(Long orgId, String mobile, String name, String weinOpenId) throws BussinessException {
        List students = this.orgStudentsDao.getStudentByMobileAndOrgId(orgId, mobile, Integer.valueOf(0), new String[0]);
        StudentInfoDto result = null;
        if (students != null && !students.isEmpty()) {
            result = this.getResult((OrgStudent)students.get(0));
            for (OrgStudent student : students) {
                String weixin = student.getWeixin();
                if (weinOpenId.equals(weixin)) continue;
                student.setWeixin(weinOpenId);
                student.setUpdateTime(new Date());
                this.orgStudentsDao.update((Object)student, new String[]{"name", "weixin", "updateTime"});
            }
        } else {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.NOT_FOUND, "\u7ed1\u5b9a\u5931\u8d25\uff0c\u60a8\u6240\u586b\u5199\u7684\u624b\u673a\u53f7\u4e0d\u662f\u5b66\u5458\u624b\u673a\u53f7");
        }
        return result;
    }

    private StudentInfoDto getResult(OrgStudent student) {
        StudentInfoDto result = new StudentInfoDto();
        BeanUtils.copyProperties((Object)student, (Object)((Object)result));
        result.setStudentId(student.getId());
        return result;
    }

    @Override
    @Transactional(readOnly=true)
    public StudentInfoDto getOrgStudentByMobile(Long orgId, String mobile) {
        OrgStudent student = this.orgStudentsDao.getStudentByMobileAndOrgId(orgId, mobile, new String[0]);
        StudentInfoDto result = null;
        if (student != null) {
            result = new StudentInfoDto();
            BeanUtils.copyProperties((Object)student, (Object)((Object)result));
        }
        return result;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public List<StudentInfoDto> getAndUpdateOrgStudentByOpenId(Long orgId, String weixinOpenId) {
        List students = this.orgStudentsDao.getStudentByOpenIdAndOrgId(orgId, weixinOpenId, new String[0]);
        ArrayList result = Lists.newArrayList();
        if (students != null && !students.isEmpty()) {
            StudentInfoDto item = null;
            for (OrgStudent student : students) {
                item = new StudentInfoDto();
                BeanUtils.copyProperties((Object)student, (Object)((Object)item));
                item.setStudentId(student.getId());
                item.setClassName(this.getClassName(orgId, student.getId()));
                result.add(item);
                if (weixinOpenId.equals(student.getWeixin())) continue;
                student.setWeixin(weixinOpenId);
                student.setUpdateTime(new Date());
                this.orgStudentsDao.update((Object)student, new String[]{"weixin", "updateTime"});
            }
        }
        return result;
    }

    private String getClassName(Long orgId, Long studentId) {
        Long courseId;
        OrgCourse course;
        List courses = this.orgStudentCourseDao.getOrgCourseIds(orgId, studentId, Integer.valueOf(0), null);
        String name = "";
        if (courses != null && !courses.isEmpty() && (course = (OrgCourse)this.orgCourseDao.getById((Serializable)(courseId = ((OrgStudentCourse)courses.get(0)).getCourseId()), new String[]{"name"})) != null) {
            name = course.getName();
        }
        return StringUtils.isNotBlank((CharSequence)name) ? name : "\u672a\u62a5\u73ed";
    }

    @Override
    @Transactional(readOnly=true)
    public StudentInfoDto getBasicStudentInfo(Long studentId, Long orgId, boolean hideMobile) {
        Preconditions.checkArgument((studentId != null ? 1 : 0) != 0, (Object)"studentId is null");
        OrgStudent orgStudent = (OrgStudent)this.orgStudentsDao.getById((Serializable)studentId, new String[0]);
        if (orgStudent == null || orgStudent.getOrgId().longValue() != orgId.longValue()) {
            throw new BussinessException((UniverseErrorCode)StudentErrorCode.STUDENT_NOT_EXIST);
        }
        Student student = this.studentDao.getByUserId(orgStudent.getUserId(), new String[0]);
        Storage storage = null;
        if (student != null && student.getAvatar() != null) {
            storage = (Storage)this.storageDao.getById((Serializable)student.getAvatar(), new String[0]);
        }
        StudentInfoDto dto = new StudentInfoDto();
        dto.setStudentId(studentId);
        if (StringUtils.isBlank((CharSequence)orgStudent.getName())) {
            if (StringUtils.isBlank((CharSequence)orgStudent.getNickName())) {
                dto.setName(MaskUtil.maskMobile((String)orgStudent.getMobile()));
            } else {
                dto.setName(orgStudent.getNickName());
            }
        } else {
            dto.setName(orgStudent.getName());
        }
        if (storage != null) {
            dto.setAvatarUrl(StorageUtil.constructUrl((Long)storage.getFid(), (String)storage.getMimetype(), (String)storage.getSn()));
        }
        if (hideMobile) {
            if (StringUtils.isNotBlank((CharSequence)orgStudent.getShowMobile())) {
                if (orgStudent.getShowMobile().contains("*")) {
                    dto.setMobile(orgStudent.getShowMobile());
                } else {
                    dto.setMobile(MaskUtil.maskMobile((String)orgStudent.getMobile()));
                }
            } else {
                dto.setMobile(MaskUtil.maskMobile((String)orgStudent.getMobile()));
            }
        } else if (StringUtils.isNotBlank((CharSequence)orgStudent.getShowMobile())) {
            if (orgStudent.getShowMobile().contains("*")) {
                dto.setMobile(orgStudent.getMobile());
            } else {
                dto.setMobile(orgStudent.getShowMobile());
            }
        } else {
            dto.setMobile(orgStudent.getMobile());
        }
        if (!this.txCascadeCredentialService.isShowMobile(orgId, TianxiaoMContext.getTXCascadeId())) {
            dto.setMobile(MaskUtil.maskMobile((String)dto.getMobile()));
            dto.setParentMobile(MaskUtil.maskMobile((String)dto.getParentMobile()));
        }
        return dto;
    }

    @Override
    @Transactional(readOnly=true)
    public List<OrgStudent> searchHasMobileConsulter(PageDto pageDto, String format, String value) {
        List students = this.orgStudentsDao.searchHasMobileConsulter(pageDto, format, value);
        log.debug("students:{}", (Object)students);
        return students;
    }

    @Override
    @Transactional(readOnly=true)
    public Map<Long, StudentInfoReponseDto> getUserIdStudentDtoMap(Collection<Long> userIds, Long orgId) {
        Map studentMap = this.orgStudentsDao.getStudentMap(userIds, orgId);
        log.debug("studentMap={}", (Object)studentMap);
        Map storageMap = this.studentDao.getAvatarsMap(studentMap.keySet());
        HashSet aratarIds = Sets.newHashSet();
        for (Integer avatar : storageMap.values()) {
            aratarIds.add(avatar.longValue());
        }
        Map avatarMap = this.storageDao.getStorageMapByIds((Collection)aratarIds);
        HashMap response = Maps.newHashMap();
        for (Long userId : studentMap.keySet()) {
            StudentInfoReponseDto dto = new StudentInfoReponseDto();
            OrgStudent student = (OrgStudent)studentMap.get(userId);
            if (student != null) {
                Storage storage;
                dto.setStudentId(student.getId());
                dto.setMobile(this.getMobile(student, false));
                dto.setName(this.getName(student));
                Integer avatar = (Integer)storageMap.get(userId);
                if (avatar != null && (storage = (Storage)avatarMap.get(avatar.longValue())) != null) {
                    dto.setAvatarUrl(StorageUtil.constructUrl((Long)storage.getFid(), (String)storage.getMimetype(), (String)storage.getSn()));
                }
            }
            response.put(userId, dto);
        }
        return response;
    }

    @Override
    @DataAuthority(resourceTypes={RequestSourceDesc.STUDENT_LIST})
    public List<StudentStatusStatistics> getStudentStatusStatisticsByOrgId(Long orgId) {
        boolean needDataAuthority = false;
        Integer cascadeId = null;
        Integer orgNumber = null;
        boolean canAccess = RequestSourceDesc.STUDENT_LIST.canAccess("getStudentStatusStatisticsByOrgId", this.getClass(), new Class[]{Long.class});
        if (!canAccess) {
            AccountRoleType accountRoleType = RequestSourceDesc.STUDENT_LIST.getAccountRoleType();
            log.info(" can not access in getStudentStatusStatisticsByOrgId and accountRoleType is : {} ", (Object)accountRoleType);
            cascadeId = accountRoleType.getCasCadeId();
            orgNumber = accountRoleType.getOrgNumber();
            needDataAuthority = true;
        }
        return this.solrStudentQuery.queryCountByStatus(orgId.longValue(), needDataAuthority, cascadeId, orgNumber);
    }

    private String getName(OrgStudent student) {
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{student.getName()})) {
            return student.getName();
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{student.getNickName()})) {
            return student.getNickName();
        }
        return MaskUtil.maskMobile((String)student.getMobile());
    }

    private String getMobile(OrgStudent student, boolean mask) {
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{student.getShowMobile()}) && student.getShowMobile().contains("*")) {
            return mask ? MaskUtil.maskMobile((String)student.getMobile()) : student.getMobile();
        }
        return mask ? MaskUtil.maskMobile((String)student.getShowMobile()) : student.getShowMobile();
    }

    private void addSysBacklog(Long orgId, OrgStudent student, Long consultUserId) {
        log.info("addSysBacklog---------orgId={}, student={}\uff0cconsultUserId={}", new Object[]{orgId, student, consultUserId});
        List list = this.txBacklogDao.getBacklogByStudentIdAndOrgId(student.getId(), orgId, Boolean.valueOf(false), new String[]{"id"});
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.SYSTEM_ERROR, "\u5df2\u5b58\u5728\u672a\u8fc7\u671f\u7684\u6b63\u5f0f\u5b66\u5458\u7cfb\u7edf\u5f85\u529e\u4e8b\u9879");
        }
        TxBacklog txBacklog = new TxBacklog();
        txBacklog.setOrgId(orgId);
        txBacklog.setStudentId(student.getId());
        if (null != consultUserId && consultUserId > 0L) {
            txBacklog.setConsultUserId(consultUserId);
        }
        txBacklog.setContent("\u8ddf\u8fdb\u5ba2\u6237: " + (StringUtils.isNotBlank((CharSequence)student.getName()) ? student.getName() : "\u533f\u540d\u5b66\u751f"));
        txBacklog.setCreateTime(new Date());
        txBacklog.setUpdateTime(new Date());
        txBacklog.setIsSys(BizConf.TRUE.intValue());
        txBacklog.setEndTime(student.getNextRemindTime());
        txBacklog.setRemindTime(student.getNextRemindTime());
        this.txBacklogDao.save((Object)txBacklog, Boolean.valueOf(false), new String[0]);
        log.info("addSysBacklog--------txBacklog={}", (Object)txBacklog);
    }

    private void updateSysBacklog(Long orgId, OrgStudent student, Long consulterId) {
        log.info("updateSysBacklog-------orgId={},student={},consulterId={}", new Object[]{orgId, student, consulterId});
        List list = null;
        if (null != consulterId && consulterId > 0L) {
            list = this.txBacklogDao.getBacklogByConsulterIdAndOrgId(consulterId, orgId, Boolean.valueOf(false), new String[0]);
            if (CollectionUtils.isNotEmpty((Collection)list)) {
                TxBacklog txBacklog = (TxBacklog)list.get(0);
                txBacklog.setStudentId(student.getId());
                txBacklog.setContent("\u8ddf\u8fdb\u5ba2\u6237: " + (StringUtils.isNotBlank((CharSequence)student.getName()) ? student.getName() : "\u533f\u540d\u5b66\u751f"));
                txBacklog.setEndTime(student.getNextRemindTime());
                txBacklog.setRemindTime(student.getNextRemindTime());
                txBacklog.setUpdateTime(new Date());
                this.txBacklogDao.update((Object)txBacklog, Boolean.valueOf(false), new String[0]);
            } else {
                this.addSysBacklog(orgId, student, consulterId);
            }
        } else {
            list = this.txBacklogDao.getBacklogByStudentIdAndOrgId(student.getId(), orgId, Boolean.valueOf(false), new String[0]);
            if (CollectionUtils.isNotEmpty((Collection)list)) {
                TxBacklog txBacklog = (TxBacklog)list.get(0);
                if (txBacklog.getEndTime().getTime() != student.getNextRemindTime().getTime()) {
                    txBacklog.setContent("\u8ddf\u8fdb\u5ba2\u6237: " + (StringUtils.isNotBlank((CharSequence)student.getName()) ? student.getName() : "\u533f\u540d\u5b66\u751f"));
                    txBacklog.setEndTime(student.getNextRemindTime());
                    txBacklog.setRemindTime(student.getNextRemindTime());
                    txBacklog.setUpdateTime(new Date());
                    this.txBacklogDao.update((Object)txBacklog, Boolean.valueOf(false), new String[0]);
                }
            } else {
                List consultUserList = this.txConsultUserDao.lookByStudentId(orgId, student.getId(), new String[]{"id"});
                if (CollectionUtils.isNotEmpty((Collection)consultUserList)) {
                    consulterId = ((TxConsultUser)consultUserList.get(0)).getId();
                }
                this.addSysBacklog(orgId, student, consulterId);
            }
        }
    }

    private void delSysBacklog(Long orgId, OrgStudent student, TxConsultUser consulterUser) {
        block5: {
            List list;
            block4: {
                log.info("delSysBacklog-------orgId={},student={},consulterUser={}", new Object[]{orgId, student, consulterUser});
                list = null;
                if (null == consulterUser) break block4;
                list = this.txBacklogDao.getBacklogByConsulterIdAndOrgId(consulterUser.getId(), orgId, null, new String[0]);
                if (!CollectionUtils.isNotEmpty((Collection)list)) break block5;
                for (TxBacklog txBacklog : list) {
                    if (null == txBacklog || txBacklog.getStudentId().longValue() != student.getId().longValue()) continue;
                    txBacklog.setStudentId(Long.valueOf(0L));
                    if (!txBacklog.getEndTime().before(new Date())) {
                        txBacklog.setContent("\u8ddf\u8fdb\u5ba2\u6237: " + (StringUtils.isNotBlank((CharSequence)consulterUser.getName()) ? consulterUser.getName() : "\u533f\u540d\u5b66\u751f"));
                        txBacklog.setEndTime(consulterUser.getNextRemindTime());
                        txBacklog.setRemindTime(consulterUser.getNextRemindTime());
                    }
                    txBacklog.setUpdateTime(new Date());
                    this.txBacklogDao.update((Object)txBacklog, Boolean.valueOf(false), new String[0]);
                }
                break block5;
            }
            list = this.txBacklogDao.getBacklogByStudentIdAndOrgId(student.getId(), orgId, null, new String[0]);
            if (CollectionUtils.isNotEmpty((Collection)list)) {
                for (TxBacklog txBacklog : list) {
                    if (null == txBacklog) continue;
                    txBacklog.setStudentId(Long.valueOf(0L));
                    txBacklog.setDelStatus(BizConf.TRUE.intValue());
                    txBacklog.setUpdateTime(new Date());
                    this.txBacklogDao.update((Object)txBacklog, Boolean.valueOf(false), new String[0]);
                }
            }
        }
    }

    @Override
    public List<StudentInfoDto> listOrgStudentByMobile(Long orgId, String mobile) {
        List students = this.orgStudentsDao.getStudentByMobileAndOrgId(orgId, mobile, Integer.valueOf(9999), new String[0]);
        ArrayList<StudentInfoDto> result = new ArrayList<StudentInfoDto>();
        if (students != null) {
            for (OrgStudent stu : students) {
                StudentInfoDto dto = new StudentInfoDto();
                BeanUtils.copyProperties((Object)stu, (Object)((Object)dto));
                result.add(dto);
            }
        }
        return result;
    }

    @Override
    public void updateStudentNextRemindTime(Integer orgId, Long studentId, Long nextRemindTime) {
        OrgStudent student = (OrgStudent)this.orgStudentsDao.getById((Serializable)studentId, new String[0]);
        if (student == null || student.getOrgId().intValue() != orgId.intValue()) {
            throw new PermissionException();
        }
        student.setNextRemindTime(new Date(nextRemindTime));
        this.orgStudentsDao.update((Object)student, new String[0]);
    }

    @Override
    public List<Long> getStudentidsByCourseIds(Long orgId, List<Long> courseIds) {
        return this.orgStudentCourseDao.getStudentIdsByCourseIds(Long.valueOf(orgId), courseIds);
    }
}

