/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.storage.service.impl;

import com.baijia.tianxiao.constants.MIMEType;
import com.baijia.tianxiao.dal.org.dao.OrgStorageDao;
import com.baijia.tianxiao.dal.org.po.OrgStorage;
import com.baijia.tianxiao.dal.storage.dao.StorageDao;
import com.baijia.tianxiao.dal.storage.po.Storage;
import com.baijia.tianxiao.dto.upload.UploadResult;
import com.baijia.tianxiao.sal.storage.dto.UploadResultDto;
import com.baijia.tianxiao.sal.storage.exception.UploadException;
import com.baijia.tianxiao.sal.storage.service.StorageService;
import com.baijia.tianxiao.util.file.FileUtil;
import com.baijia.tianxiao.util.storage.StorageUtil;
import com.baijia.tianxiao.util.upload.FileUploadUtils;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class StorageServiceImpl
implements StorageService {
    private static final Logger log = LoggerFactory.getLogger(StorageServiceImpl.class);
    @Resource
    private OrgStorageDao orgStorageDao;
    @Resource
    private StorageDao storageDao;

    @Override
    public List<UploadResultDto> storage(Map<String, File> files, Long uid, boolean watermark, boolean saveToCdb) {
        Preconditions.checkArgument((boolean)MapUtils.isNotEmpty(files), (Object)"files is null");
        Preconditions.checkArgument((uid != null ? 1 : 0) != 0, (Object)"uid is null");
        UploadResult uploadResult = FileUploadUtils.uploadFiles((Long)uid, files, (boolean)watermark);
        if (CollectionUtils.isNotEmpty((Collection)uploadResult.getFiles())) {
            ArrayList result = Lists.newArrayList();
            for (UploadResult.UploadFile uploadFile : uploadResult.getFiles()) {
                String extension = FileUtil.getFormatedExtension((String)uploadFile.getUrl());
                MIMEType mimeType = MIMEType.getType((String)extension);
                result.add(this.saveToStorage(uploadFile, mimeType, saveToCdb));
            }
            return result;
        }
        return Collections.emptyList();
    }

    @Override
    public UploadResultDto storage(File file, Long uid, boolean watermark) {
        return this.storage(file, uid, watermark, false);
    }

    @Override
    public UploadResultDto storage(File file, Long uid, boolean watermark, boolean saveToCdb) {
        Preconditions.checkArgument((file != null ? 1 : 0) != 0, (Object)"file is null");
        Preconditions.checkArgument((uid != null ? 1 : 0) != 0, (Object)"uid is null");
        String extension = FileUtil.getFormatedExtension((String)file.getName());
        MIMEType mimeType = MIMEType.getType((String)extension);
        Preconditions.checkArgument((mimeType != null ? 1 : 0) != 0, (String)"can not get mimetype from file %s", (Object[])new Object[]{file.getName()});
        UploadResult.UploadFile uploadFile = FileUploadUtils.uploadToRemote((Long)uid, (File)file, (boolean)watermark);
        if (uploadFile == null) {
            log.warn("upload fail result is empty");
            throw new UploadException();
        }
        return this.saveToStorage(uploadFile, mimeType, saveToCdb);
    }

    private UploadResultDto saveToStorage(UploadResult.UploadFile uploadFile, MIMEType mimeType, boolean saveToCdb) {
        UploadResultDto result = new UploadResultDto();
        if (!saveToCdb) {
            OrgStorage storage = new OrgStorage();
            storage.setCreateTime(new Date());
            storage.setFid(uploadFile.getFid());
            storage.setSize(Integer.valueOf(uploadFile.getSize()));
            storage.setSn(uploadFile.getSn());
            storage.setMimeType(Integer.valueOf(mimeType.getCode()));
            storage.setUpdateTime(new Date());
            this.orgStorageDao.save(storage);
            log.info("success save upload result:{}", (Object)storage);
            result.setStorageId(storage.getId().longValue());
        } else {
            Storage storage = new Storage();
            storage.setFid(Long.valueOf(Long.parseLong(uploadFile.getFid())));
            storage.setSn(uploadFile.getSn());
            storage.setSize(Integer.valueOf(uploadFile.getSize()));
            storage.setMimetype(mimeType.getType());
            this.storageDao.save((Object)storage, new String[0]);
            result.setStorageId(storage.getId());
        }
        result.setUrl(StorageUtil.constructUrl((String)uploadFile.getFid(), (String)uploadFile.getSn(), (MIMEType)mimeType));
        return result;
    }
}

