/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.storage.service.impl;

import com.baijia.tianxiao.constants.MIMEType;
import com.baijia.tianxiao.dal.org.dao.OrgStorageDao;
import com.baijia.tianxiao.dal.org.po.OrgStorage;
import com.baijia.tianxiao.dto.upload.UploadResult;
import com.baijia.tianxiao.sal.storage.dto.UploadResultDto;
import com.baijia.tianxiao.sal.storage.exception.UploadException;
import com.baijia.tianxiao.sal.storage.service.StorageService;
import com.baijia.tianxiao.util.file.FileUtil;
import com.baijia.tianxiao.util.storage.StorageUtil;
import com.baijia.tianxiao.util.upload.FileUploadUtils;
import com.google.common.base.Preconditions;
import java.io.File;
import java.util.Date;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class StorageServiceImpl
implements StorageService {
    private static final Logger log = LoggerFactory.getLogger(StorageServiceImpl.class);
    @Resource
    private OrgStorageDao orgStorageDao;

    @Override
    public UploadResultDto storage(File file, Long uid, boolean watermark) {
        Preconditions.checkArgument((file != null ? 1 : 0) != 0, (Object)"file is null");
        Preconditions.checkArgument((uid != null ? 1 : 0) != 0, (Object)"uid is null");
        String extension = FileUtil.getFormatedExtension((String)file.getName());
        MIMEType mimeType = MIMEType.getType((String)extension);
        Preconditions.checkArgument((mimeType != null ? 1 : 0) != 0, (String)"can not get mimetype from file %s", (Object[])new Object[]{file.getName()});
        UploadResult.UploadFile uploadFile = FileUploadUtils.uploadToRemote((Long)uid, (File)file, (boolean)watermark);
        if (uploadFile == null) {
            log.warn("upload fail result is empty");
            throw new UploadException();
        }
        OrgStorage storage = new OrgStorage();
        storage.setCreateTime(new Date());
        storage.setFid(uploadFile.getFid());
        storage.setSize(Integer.valueOf(uploadFile.getSize()));
        storage.setSn(uploadFile.getSn());
        storage.setMimeType(Integer.valueOf(mimeType.getCode()));
        storage.setUpdateTime(new Date());
        this.orgStorageDao.save(storage);
        log.info("success save upload result:{}", (Object)storage);
        UploadResultDto result = new UploadResultDto();
        result.setStorageId(storage.getId().longValue());
        result.setUrl(StorageUtil.constructUrl((String)storage.getFid(), (String)storage.getSn(), (MIMEType)mimeType));
        return result;
    }
}

