package com.baijia.tianxiao.sal.statistics.impl;

import com.baijia.tianxiao.dal.sync.dao.TxMonitorTodayMinDao;
import com.baijia.tianxiao.dal.sync.po.TxMonitorCourseDay;
import com.baijia.tianxiao.dal.sync.po.TxMonitorOrgDay;
import com.baijia.tianxiao.dal.sync.po.TxMonitorTypeDay;
import com.baijia.tianxiao.sal.statistics.TxMonitorTodayMinService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;

/**
 * Created by wengshengli on 15/12/29.
 */
@Service
@Slf4j
public class TxMonitorTodayMinServiceImpl implements TxMonitorTodayMinService {

    @Autowired
    private TxMonitorTodayMinDao txMonitorTodayMinDao;

    @Override
    public List<TxMonitorOrgDay> groupByOrgDay(Long orgNumber) {
        List<TxMonitorOrgDay> orgDays = txMonitorTodayMinDao.group2OrgDay(orgNumber);

        log.info("groupByOrgDay = {}", orgDays);

        Map<String, TxMonitorOrgDay> map = Maps.newHashMap();
        for (TxMonitorOrgDay one : orgDays) {
            String key = String.valueOf(one.getOrgNumber());
            TxMonitorOrgDay value = map.get(key);
            if (value == null) {
                one.setUv(1);
                map.put(key, one);
            } else {
                value.setPv(value.getPv() + one.getPv());
                value.setUv(value.getUv() + 1);
                map.put(key, value);
            }
        }

        List<TxMonitorOrgDay> list = Lists.newArrayList();
        list.addAll(map.values());

        return list;
    }

    @Override
    public List<TxMonitorTypeDay> groupByTypeDay(Long orgNumber) {
        List<TxMonitorTypeDay> orgDays = txMonitorTodayMinDao.group2TypeDay(orgNumber);

        Map<String, TxMonitorTypeDay> map = Maps.newHashMap();
        for (TxMonitorTypeDay one : orgDays) {
            String key = String.valueOf(one.getOrgNumber()) + one.getPageType();
            TxMonitorTypeDay value = map.get(key);
            if (value == null) {
                one.setUv(1);
                map.put(key, one);
            } else {
                value.setPv(value.getPv() + one.getPv());
                value.setUv(value.getUv() + 1);
                map.put(key, value);
            }
        }
        List<TxMonitorTypeDay> list = Lists.newArrayList();
        list.addAll(map.values());

        return list;
    }

    @Override
    public List<TxMonitorCourseDay> groupByCourseDay(Long orgNumber, List<Integer> pageTypes) {
        List<TxMonitorCourseDay> orgDays = txMonitorTodayMinDao.group2CourseDay(orgNumber, pageTypes);

        Map<String, TxMonitorCourseDay> map = Maps.newHashMap();
        for (TxMonitorCourseDay one : orgDays) {
            String key = String.valueOf(one.getOrgNumber()) + one.getPageType() + one.getCourseNumber();
            TxMonitorCourseDay value = map.get(key);
            if (value == null) {
                one.setUv(1);
                map.put(key, one);
            } else {
                value.setPv(value.getPv() + one.getPv());
                value.setUv(value.getUv() + 1);
                map.put(key, value);
            }
        }
        List<TxMonitorCourseDay> list = Lists.newArrayList();
        list.addAll(map.values());

        return list;
    }

    @Override
    public void deleteTodayBase() {
        List<Long> ids = txMonitorTodayMinDao.queryForIds();
        if (ids != null && !ids.isEmpty()) {
            log.info("deleteTodayBase ids size is {}", ids.size());
            txMonitorTodayMinDao.delByIds(ids);
        }
    }
}
