package com.baijia.tianxiao.sal.signup.service;

import com.baijia.tianxiao.sal.signup.dto.request.TransferClassRequest;
import com.baijia.tianxiao.sal.signup.dto.request.TransferLessonInfoDto;
import com.baijia.tianxiao.sal.signup.dto.response.OrgSingupInfoDto;
import com.baijia.tianxiao.sal.signup.dto.response.TransferClassListDto;
import com.baijia.tianxiao.sal.signup.dto.response.TransferRefundListDto;

import java.util.List;

/**
 * Created by wengshengli on 2017/4/22.
 */
public interface TransferClassInfoService {

    void saveTransferInfo(TransferClassRequest transferClassRequest, OrgSingupInfoDto orgSingupInfoDto, List<TransferLessonInfoDto> transferLessonList);

    List<TransferClassListDto> listTransferInfo(Long orgId, Long signupPurchaseId, Long classId);

    List<TransferRefundListDto> listTransferRefund(Long inSignupPurchaseId);

    void updateReundType(Long transferNumber, Integer refundType);

    void cancelTransferClassByPurchase(Long inSignupPurchaseId);

    void cancelTransferClassByNumber(Long transferClassNumber);

    void confirmTransferClass(Long inSignupPurchaseId);

    /**
     * 班级转出合同课次
     *
     * @param signupPurchaseId
     * @param classId
     * @return
     */
    Integer transferLessonCount(Long signupPurchaseId, Long classId);
}
