package com.baijia.tianxiao.sal.signup.service.Impl;

import com.baijia.tianxiao.dal.signup.dao.TxPurchaseTimescardRefundDao;
import com.baijia.tianxiao.dal.signup.po.TxPurchaseTimescardRefund;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sal.signup.dto.request.TimesCardRefundRequest;
import com.baijia.tianxiao.sal.signup.service.TxTimesCardRefundService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;

/**
 * Created by wengshengli on 2017/7/21.
 */
@Service
@Slf4j
public class TxTimesCardRefundServiceImpl implements TxTimesCardRefundService {

    @Autowired
    private TxPurchaseTimescardRefundDao txPurchaseTimescardRefundDao;

    @Override
    public void saveTimesCardRefund(TimesCardRefundRequest timesCardRefundRequest) {
        if (timesCardRefundRequest.getSignupPurchaseId() == null) {
            throw new BussinessException(CommonErrorCode.PARAM_ERROR, "订单号不能为空");
        }

        TxPurchaseTimescardRefund timescardRefund = new TxPurchaseTimescardRefund();
        timescardRefund.setOrgId(timesCardRefundRequest.getOrgId());
        timescardRefund.setCascadeId(timesCardRefundRequest.getCascadeId());
        timescardRefund.setStudentId(timesCardRefundRequest.getStudentId());
        timescardRefund.setUserId(timesCardRefundRequest.getUserId());
        timescardRefund.setSignupPurchaseId(timesCardRefundRequest.getSignupPurchaseId());
        timescardRefund.setRefundPrice(timesCardRefundRequest.getRefundMoneyLong());
        timescardRefund.setRefundFee(timesCardRefundRequest.getRefundFee());
        timescardRefund.setRefundType(timesCardRefundRequest.getRefundType());
        timescardRefund.setRemark(timesCardRefundRequest.getRemark());
        timescardRefund.setCreateTime(new Date());

        txPurchaseTimescardRefundDao.save(timescardRefund);
    }
}
