package com.baijia.tianxiao.sal.signup.service.Impl;

import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;

import com.baijia.tianxiao.consants.DataStatus;
import com.baijia.tianxiao.dal.finance.po.TxStudentFinanceAccountDto;
import com.baijia.tianxiao.dal.org.dao.OrgStorageDao;
import com.baijia.tianxiao.dal.org.po.OrgStorage;
import com.baijia.tianxiao.dal.signup.po.OrgSignupInfo;
import com.baijia.tianxiao.enums.RedisKeyEnums;
import com.baijia.tianxiao.image.AvatarUtil;
import com.baijia.tianxiao.sal.common.api.RedisDefaultService;
import com.baijia.tianxiao.sal.signup.dto.OrgSignupStorageDto;
import com.baijia.tianxiao.sal.signup.dto.SignupRefundStorageDto;
import com.baijia.tianxiao.sal.signup.dto.response.OrgSignupStorageResponseDto;
import com.baijia.tianxiao.sal.signup.service.OrgSignupStorageService;
import com.baijia.tianxiao.sal.signup.service.SignupRefundStorageService;
import com.baijia.tianxiao.util.SerializeUtil;
import com.baijia.tianxiao.util.StringUtils;
import com.baijia.tianxiao.util.storage.StorageUtil;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.baijia.tianxiao.constant.StudentFiannceOpType;
import com.baijia.tianxiao.dal.finance.dao.TxStudentFinanceAccountDao;
import com.baijia.tianxiao.dal.finance.dao.TxStudentFinanceRecordDao;
import com.baijia.tianxiao.dal.finance.po.TxStudentFinanceAccount;
import com.baijia.tianxiao.dal.finance.po.TxStudentFinanceRecord;
import com.baijia.tianxiao.dal.org.dao.OrgInfoDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.dao.TXCascadeCredentialDao;
import com.baijia.tianxiao.dal.org.po.OrgInfo;
import com.baijia.tianxiao.dal.org.po.OrgStudent;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sal.organization.finance.constant.FinanceOpTo;
import com.baijia.tianxiao.sal.organization.org.service.TxCascadeCredentialService;
import com.baijia.tianxiao.sal.signup.dto.BalanceChangeRecord;
import com.baijia.tianxiao.sal.signup.dto.request.StudentBalanceRequestDto;
import com.baijia.tianxiao.sal.signup.dto.response.StudentBalanceResponseDto;
import com.baijia.tianxiao.sal.signup.service.TxStudentFinanceAccountService;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.util.GenericsUtils;
import com.baijia.tianxiao.util.mobile.MaskUtil;
import com.google.common.collect.Lists;

import lombok.extern.slf4j.Slf4j;

@Service
@Slf4j
public class TxStudentFinanceAccountServiceImpl implements TxStudentFinanceAccountService {

    @Resource
    private TxStudentFinanceAccountDao txStudentFinanceAccountDao;

    @Resource
    private TxStudentFinanceRecordDao txStudentFinanceRecordDao;

    @Autowired
    private TXCascadeCredentialDao txCascadeCredentialDao;
    @Autowired
    private OrgInfoDao orgInfoDao;

    @Resource
    private OrgStudentDao orgStudentDao;

    @Resource
    private TxCascadeCredentialService txCascadeCredentialService;

    @Resource
    private SignupRefundStorageService signupRefundStorageService;

    @Resource
    private OrgSignupStorageService orgSignupStorageService;

    @Autowired
    private OrgStorageDao orgStorageDao;

    @Autowired
    private RedisDefaultService redisDefaultService;

    @Override
    public void changeStudentFiannceAccount(Long orgId, Integer cascadeId, Long studentId, Long signupPurchaseId, StudentFiannceOpType opType,
                                            Long money, String opInfo, String remark) {
        log.info("ChangeStudentFiannceAccount params={},{},{} {},{},{}", orgId, cascadeId, studentId, opType, money,
                opInfo);

        OrgStudent orgStudent = orgStudentDao.getById(studentId);
        if (orgStudent == null) {
            throw new BussinessException(CommonErrorCode.BUSINESS_ERROR, "学员不存在");
        }

        String studentAccountRedisKey = RedisKeyEnums.CW.TX_STUDENT_ACCOUNT.getRedisKey() + orgId + "_" + studentId;

        byte[] redisStudentAccount = redisDefaultService.get(studentAccountRedisKey);
        TxStudentFinanceAccount txStudentFinanceAccount = null;
        if (redisStudentAccount == null) {
            /**
             * 财务账号
             */
            txStudentFinanceAccount =
                    txStudentFinanceAccountDao.getFinanceAccount(orgId, studentId);
            if (txStudentFinanceAccount == null) {
                txStudentFinanceAccount = new TxStudentFinanceAccount();
                txStudentFinanceAccount.setOrgId(orgId);
                txStudentFinanceAccount.setStudentId(studentId);
                txStudentFinanceAccount.setCreateTime(new Date());
            }
        } else {
            txStudentFinanceAccount = (TxStudentFinanceAccount) SerializeUtil.unserialize(redisStudentAccount);
        }

        /**
         * 财务变更记录
         */
        TxStudentFinanceRecord txStudentFinanceRecord = new TxStudentFinanceRecord();
        txStudentFinanceRecord.setOrgId(orgId);
        txStudentFinanceRecord.setStudentId(studentId);
        txStudentFinanceRecord.setCreateTime(new Date());
        txStudentFinanceRecord.setUpdateTime(new Date());
        txStudentFinanceRecord.setOpMoney(money);
        txStudentFinanceRecord.setOpType(opType.getCode());
        txStudentFinanceRecord.setCascadeId(cascadeId);
        txStudentFinanceRecord.setRemark(remark);
        txStudentFinanceRecord.setSignupPurchaseId(signupPurchaseId);

        if (opType == StudentFiannceOpType.QUIT_CLASS || opType == StudentFiannceOpType.TRANSFER_REFUND || opType == StudentFiannceOpType.TIMECARD_CASH) {
            txStudentFinanceRecord.setPreBalance(txStudentFinanceAccount.getBalance());
            txStudentFinanceAccount.setBalance(txStudentFinanceAccount.getBalance() + money);
            txStudentFinanceRecord.setCurrBalance(txStudentFinanceAccount.getBalance());

            txStudentFinanceRecord.setPreFreezeMoney(txStudentFinanceAccount.getFreezeMoney());
            txStudentFinanceAccount.setFreezeMoney(txStudentFinanceAccount.getFreezeMoney());
            txStudentFinanceRecord.setCurrfreezeMoney(txStudentFinanceAccount.getFreezeMoney());

            txStudentFinanceRecord.setOpTo(FinanceOpTo.INCOME.getCode());
            txStudentFinanceRecord.setOpInfo(opInfo);
        } else if (opType == StudentFiannceOpType.RECHARGE) {
            txStudentFinanceRecord.setPreBalance(txStudentFinanceAccount.getBalance());
            txStudentFinanceAccount.setBalance(txStudentFinanceAccount.getBalance() + money);
            txStudentFinanceRecord.setCurrBalance(txStudentFinanceAccount.getBalance());

            txStudentFinanceRecord.setPreFreezeMoney(txStudentFinanceAccount.getFreezeMoney());
            txStudentFinanceAccount.setFreezeMoney(txStudentFinanceAccount.getFreezeMoney());
            txStudentFinanceRecord.setCurrfreezeMoney(txStudentFinanceAccount.getFreezeMoney());

            txStudentFinanceRecord.setOpTo(FinanceOpTo.INCOME.getCode());
            txStudentFinanceRecord.setOpInfo("学员" + orgStudent.getName() + "充值");
        } else if (opType == StudentFiannceOpType.REFUND_CASH) {
            if (txStudentFinanceAccount.getId() == null || txStudentFinanceAccount.getBalance() < money) {
                throw new BussinessException(CommonErrorCode.SIGN_INVALIDATE, "学生账号变动金额异常或有冻结金额");
            }
            txStudentFinanceRecord.setPreBalance(txStudentFinanceAccount.getBalance());
            txStudentFinanceAccount.setBalance(txStudentFinanceAccount.getBalance() - money);
            txStudentFinanceRecord.setCurrBalance(txStudentFinanceAccount.getBalance());

            txStudentFinanceRecord.setPreFreezeMoney(txStudentFinanceAccount.getFreezeMoney());
            txStudentFinanceAccount.setFreezeMoney(txStudentFinanceAccount.getFreezeMoney());
            txStudentFinanceRecord.setCurrfreezeMoney(txStudentFinanceAccount.getFreezeMoney());

            txStudentFinanceRecord.setOpTo(FinanceOpTo.EXPEND.getCode());
            txStudentFinanceRecord.setOpInfo("学员" + orgStudent.getName() + "从账户退款");
        } else if (opType == StudentFiannceOpType.PAY_SUCCESS) {
            if (txStudentFinanceAccount.getId() == null || txStudentFinanceAccount.getFreezeMoney() < money) {
                throw new BussinessException(CommonErrorCode.SIGN_INVALIDATE, "学生账号变动金额异常");
            }
            txStudentFinanceRecord.setPreBalance(txStudentFinanceAccount.getBalance());
            txStudentFinanceAccount.setBalance(txStudentFinanceAccount.getBalance());
            txStudentFinanceRecord.setCurrBalance(txStudentFinanceAccount.getBalance());

            txStudentFinanceRecord.setPreFreezeMoney(txStudentFinanceAccount.getFreezeMoney());
            txStudentFinanceAccount.setFreezeMoney(txStudentFinanceAccount.getFreezeMoney() - money);
            txStudentFinanceRecord.setCurrfreezeMoney(txStudentFinanceAccount.getFreezeMoney());
            txStudentFinanceRecord.setOpTo(FinanceOpTo.EXPEND.getCode());
            txStudentFinanceRecord.setIsShow(1);
            txStudentFinanceRecord.setOpInfo("系统支付成功");
        } else if (opType == StudentFiannceOpType.PAY_CANCEL) {
            if (txStudentFinanceAccount.getId() == null || txStudentFinanceAccount.getFreezeMoney() < money) {
                throw new BussinessException(CommonErrorCode.SIGN_INVALIDATE, "学生账号变动金额异常");
            }
            txStudentFinanceRecord.setPreBalance(txStudentFinanceAccount.getBalance());
            txStudentFinanceAccount.setBalance(txStudentFinanceAccount.getBalance() + money);
            txStudentFinanceRecord.setCurrBalance(txStudentFinanceAccount.getBalance());

            txStudentFinanceRecord.setPreFreezeMoney(txStudentFinanceAccount.getFreezeMoney());
            txStudentFinanceAccount.setFreezeMoney(txStudentFinanceAccount.getFreezeMoney() - money);
            txStudentFinanceRecord.setCurrfreezeMoney(txStudentFinanceAccount.getFreezeMoney());
            txStudentFinanceRecord.setOpTo(FinanceOpTo.INCOME.getCode());
            txStudentFinanceRecord.setOpInfo(opInfo);
        } else if (opType == StudentFiannceOpType.SIGNUP_PAY) {
            if (txStudentFinanceAccount.getId() == null || txStudentFinanceAccount.getBalance() < money) {
                throw new BussinessException(CommonErrorCode.SIGN_INVALIDATE, "学生账号变动金额异常");
            }
            txStudentFinanceRecord.setPreBalance(txStudentFinanceAccount.getBalance());
            txStudentFinanceAccount.setBalance(txStudentFinanceAccount.getBalance() - money);
            txStudentFinanceRecord.setCurrBalance(txStudentFinanceAccount.getBalance());

            txStudentFinanceRecord.setPreFreezeMoney(txStudentFinanceAccount.getFreezeMoney());
            txStudentFinanceAccount.setFreezeMoney(txStudentFinanceAccount.getFreezeMoney() + money);
            txStudentFinanceRecord.setCurrfreezeMoney(txStudentFinanceAccount.getFreezeMoney());
            txStudentFinanceRecord.setOpTo(FinanceOpTo.EXPEND.getCode());
            txStudentFinanceRecord.setOpInfo(opInfo);
        }

        txStudentFinanceAccount.setUpdateTime(new Date());
        log.info("ChangeStudentFiannceAccount result1={}", txStudentFinanceAccount);
        txStudentFinanceAccountDao.saveOrUpdate(txStudentFinanceAccount);// 账号更新或保存

        redisDefaultService.setWithExpire(studentAccountRedisKey, SerializeUtil.serialize(txStudentFinanceAccount), 2 * 60);

        log.info("ChangeStudentFiannceAccount result2={}", txStudentFinanceRecord);
        txStudentFinanceRecordDao.save(txStudentFinanceRecord);// 变更记录保存
    }

    /**
     * 查找用户储值账号的操作记录
     */
    @Override
    public List<TxStudentFinanceRecord> findStudentFiannceAccountRecord(Long orgId, Long studentId, PageDto pageDto) {
        return this.txStudentFinanceRecordDao.findTxStudentFinanceRecords(orgId, studentId, pageDto);
    }

    @Override
    public List<TxStudentFinanceAccountDto> findStudentFiannceAccount(Long orgId, Integer cascadeId, String key,
                                                                      PageDto pageDto) {
        pageDto.setCount(txStudentFinanceAccountDao.countByStudentAccount(orgId, key));

        List<TxStudentFinanceAccountDto> list = this.txStudentFinanceAccountDao.searchByStudentAccount(orgId, key, pageDto);
        if (CollectionUtils.isEmpty(list)) {
            return Collections.EMPTY_LIST;
        }

        boolean isShowMobile = txCascadeCredentialService.isShowMobile(orgId, cascadeId);
        for (TxStudentFinanceAccountDto dto : list) {
            if (!isShowMobile) {
                dto.setStudentMobile(MaskUtil.maskMobile(dto.getStudentMobile()));
            } else {
                dto.setStudentMobile(dto.getStudentMobile());
            }
        }
        return list;
    }

    @Override
    public StudentBalanceResponseDto findStudentBalanceResponseDto(StudentBalanceRequestDto request) {
        Long orgId = request.getOrgId();
        Long studentId = request.getStudentId();
        TxStudentFinanceAccount financeAccount = this.txStudentFinanceAccountDao.getFinanceAccount(orgId, studentId);
        log.info("financeAccount is :{} ", financeAccount);
        List<BalanceChangeRecord> records = Lists.newArrayList();
        StudentBalanceResponseDto studentBalanceResponseDto =
                StudentBalanceResponseDto.newInstance(financeAccount, records);

        /**
         * 头像处理
         */
        OrgStudent orgStudent = orgStudentDao.getById(studentId);
        if (orgStudent != null) {
            if (orgStudent.getAvatar() != null) {
                OrgStorage storage = orgStorageDao.getById(orgStudent.getAvatar().intValue());
                if (storage != null) {
                    String url = StorageUtil.constructUrl(storage.getFid(), storage.getSn(), storage.getMimeType());
                    studentBalanceResponseDto.setStudentAvatar(url);
                }
            }
        }

        if (StringUtils.isEmpty(studentBalanceResponseDto.getStudentAvatar())) {
            // 如果头像为空，给予默认头像
            studentBalanceResponseDto.setStudentAvatar(AvatarUtil.getUserAvatar(orgStudent.getId()));
        }

        if (request.isNeedBanlacneChangeRecords()) {
            List<TxStudentFinanceRecord> findStudentFiannceAccountRecord =
                    this.findStudentFiannceAccountRecord(orgId, studentId, request.getPageDto());
            log.info("findStudentFiannceAccountRecord are :{} ", findStudentFiannceAccountRecord);
            records.addAll(createBalanceChangeRecords(findStudentFiannceAccountRecord));
            List<Integer> cascadeIds = GenericsUtils.toFieldList(records, "operatorId");
            Map<Long, String> txCascadCredentialListByCascdeIds =
                    this.txCascadeCredentialDao.getTxCascadCredentialListByCascdeIds(cascadeIds);
            if (cascadeIds.contains(0)) {
                OrgInfo orginfo = orgInfoDao.getOrgInfo(orgId.intValue());
                txCascadCredentialListByCascdeIds.put(0l, orginfo.getContacts());
            }
            for (BalanceChangeRecord bcr : records) {
                Long operatorId = bcr.getOperatorId().longValue();
                String operator = txCascadCredentialListByCascdeIds.get(operatorId);
                if (GenericsUtils.isNullOrEmpty(operator)) {
                    operator = "[系统]";
                }
                bcr.setOperator(operator);
                if (bcr.getOpType().intValue() == StudentFiannceOpType.QUIT_CLASS.getCode()) {
                    if (!StringUtils.isEmpty(bcr.getComment())) {
                        changeQuitClassRemark(bcr, orgId);
                    }
                }
                if (bcr.getOpType().intValue() == StudentFiannceOpType.TRANSFER_REFUND.getCode()
                        || bcr.getOpType().intValue() == StudentFiannceOpType.RECHARGE.getCode()
                        || bcr.getOpType().intValue() == StudentFiannceOpType.TIMECARD_CASH.getCode()) {
                    if (!StringUtils.isEmpty(bcr.getComment())) {
                        transferClassRemark(bcr, orgId);
                    }
                }
                bcr.setOpTypeDesc(StudentFiannceOpType.getByCode(bcr.getOpType()).getName());
            }
            log.info("records are :{} ", records);
        }
        return studentBalanceResponseDto;
    }


    private void changeQuitClassRemark(BalanceChangeRecord recordDto, Long orgId) {
        try {
            String[] params = recordDto.getComment().split("_");
            List<SignupRefundStorageDto> result = signupRefundStorageService.getSignupRefundStorages(orgId,
                    Long.parseLong(params[0]), Long.parseLong(params[2]), Long.parseLong(params[1]));
            recordDto.setRemarkImages(result);
            if (!result.isEmpty()) {
                recordDto.setComment(result.get(0).getRemark());
                if (result.get(0).getStorageId().longValue() == 0) {
                    recordDto.setRemarkImages(Lists.<SignupRefundStorageDto>newArrayList());
                }
            } else {
                recordDto.setComment("");
            }
        } catch (Exception e) {
            recordDto.setComment("");
        }
    }

    private void transferClassRemark(BalanceChangeRecord recordDto, Long orgId) {
        try {
            String params = recordDto.getComment();
            OrgSignupStorageResponseDto result = orgSignupStorageService.getOrgSignupStorageBySignupPurchaseId(orgId, Long.parseLong(params));
            recordDto.setComment(result.getRemark());
            List<SignupRefundStorageDto> images = Lists.newArrayList();
            for (OrgSignupStorageDto signupStorageDto : result.getList()) {
                SignupRefundStorageDto signupRefundStorageDto = new SignupRefundStorageDto();
                signupRefundStorageDto.setUrl(signupStorageDto.getUrl());
                recordDto.setComment(signupStorageDto.getRemark());
                images.add(signupRefundStorageDto);
            }
            recordDto.setRemarkImages(images);
        } catch (Exception e) {
            recordDto.setComment("");
        }
    }

    /**
     * @param findStudentFiannceAccountRecord
     * @return
     */
    private List<BalanceChangeRecord> createBalanceChangeRecords(
            List<TxStudentFinanceRecord> findStudentFiannceAccountRecord) {
        if (GenericsUtils.isNullOrEmpty(findStudentFiannceAccountRecord)) {
            return GenericsUtils.emptyList();
        }
        List<BalanceChangeRecord> retRecords = Lists.newArrayList();
        for (TxStudentFinanceRecord record : findStudentFiannceAccountRecord) {
            BalanceChangeRecord bcr = BalanceChangeRecord.newInstance(record);
            retRecords.add(bcr);
        }
        return retRecords;
    }

}
