package com.baijia.tianxiao.sal.signup.service.Impl;

import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.baijia.tianxiao.consants.DataStatus;
import com.baijia.tianxiao.constant.LessonType;
import com.baijia.tianxiao.constant.TransferClassStatus;
import com.baijia.tianxiao.dal.constant.ChargeUnit;
import com.baijia.tianxiao.dal.finance.dao.TxTransferClassInfoDao;
import com.baijia.tianxiao.dal.finance.dao.TxTransferClassRecordDao;
import com.baijia.tianxiao.dal.finance.po.TxTransferClassInfo;
import com.baijia.tianxiao.dal.finance.po.TxTransferClassRecord;
import com.baijia.tianxiao.dal.org.dao.OrgCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgInfoDao;
import com.baijia.tianxiao.dal.org.dao.TXCascadeCredentialDao;
import com.baijia.tianxiao.dal.org.po.OrgInfo;
import com.baijia.tianxiao.dal.signup.constant.SignupCourseStatus;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupCourseDao;
import com.baijia.tianxiao.dal.signup.po.OrgSignupCourse;
import com.baijia.tianxiao.sal.common.api.KexiaoApiService;
import com.baijia.tianxiao.sal.common.dto.kexiao.KexiaoStatistics;
import com.baijia.tianxiao.sal.signup.constants.SignupRefundType;
import com.baijia.tianxiao.sal.signup.dto.request.TransferClassRequest;
import com.baijia.tianxiao.sal.signup.dto.request.TransferLessonInfoDto;
import com.baijia.tianxiao.sal.signup.dto.response.OrgSingupInfoDto;
import com.baijia.tianxiao.sal.signup.dto.response.TransferClassListDto;
import com.baijia.tianxiao.sal.signup.dto.response.TransferRefundListDto;
import com.baijia.tianxiao.sal.signup.service.TransferClassInfoService;
import com.baijia.tianxiao.util.BaseUtils;
import com.baijia.tianxiao.util.GenericsUtils;
import com.baijia.tianxiao.util.NumberUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;

import lombok.extern.slf4j.Slf4j;

/**
 * Created by wengshengli on 2017/4/22.
 */
@Service
@Slf4j
public class TransferClassInfoServiceImpl implements TransferClassInfoService {

    @Autowired
    private TxTransferClassInfoDao txTransferClassinfoDao;

    @Autowired
    private TxTransferClassRecordDao txTransferClassRecordDao;

    @Autowired
    private OrgSignupCourseDao orgSignupCourseDao;

    @Autowired
    private OrgCourseDao orgCourseDao;

    @Autowired
    private TXCascadeCredentialDao txCascadeCredentialDao;

    @Autowired
    private OrgInfoDao orgInfoDao;

    @Autowired
    private KexiaoApiService kexiaoApiService;

    @Override
    @Transactional
    public void saveTransferInfo(TransferClassRequest transferClassRequest, OrgSingupInfoDto orgSingupInfoDto,
                                 List<TransferLessonInfoDto> transferLessonList) {
        log.info("saveTransferInfo by number = {},{},{}", transferClassRequest, orgSingupInfoDto, transferLessonList);
        Date now = new Date();
        TxTransferClassInfo txTransferClassInfo = new TxTransferClassInfo();
        Long transferClassNumber = NumberUtil.randomSignupPurchaseId4Excel(new Date());
        txTransferClassInfo.setOrgId(transferClassRequest.getOrgId());
        txTransferClassInfo.setTransferNumber(transferClassNumber);
        txTransferClassInfo.setTransferOutClassId(transferClassRequest.getClassId());
        txTransferClassInfo.setTransferInPurchaseId(orgSingupInfoDto.getSignupPurchaseId());
        txTransferClassInfo.setStudentId(transferClassRequest.getStudentId());
        txTransferClassInfo.setUserId(orgSingupInfoDto.getUserId());
        txTransferClassInfo.setStatus(DataStatus.NORMAL.getValue());
        txTransferClassInfo.setNeedQuitClass(
                transferClassRequest.getNeedQuitClass() == null ? 0 : transferClassRequest.getNeedQuitClass());
        txTransferClassInfo.setCascadeId(transferClassRequest.getCascadeId());
        txTransferClassInfo.setCreateTime(now);

        KexiaoStatistics outkexiaoStatistics = kexiaoApiService.queryKexiaoStatByStudentClass(
                transferClassRequest.getOrgId(), orgSingupInfoDto.getUserId(), transferClassRequest.getClassId());
        if (outkexiaoStatistics != null) {
            txTransferClassInfo.setOutLeftCount((int) outkexiaoStatistics.getLeftNumber());
            txTransferClassInfo.setOutLeftMoney(outkexiaoStatistics.getLeftAmount());
        }

        KexiaoStatistics inkexiaoStatistics =
                kexiaoApiService.queryKexiaoStatByStudentCourse(transferClassRequest.getOrgId(),
                        orgSingupInfoDto.getUserId(), orgSingupInfoDto.getCourseInfos().get(0).getOrgCourseId());
        if (inkexiaoStatistics != null) {
            txTransferClassInfo.setInLeftCount((int) inkexiaoStatistics.getLeftNumber());
            txTransferClassInfo.setInLeftMoney(inkexiaoStatistics.getLeftAmount());
        }

        log.info("kexiao statis = {},{},{},{}", transferClassRequest.getOrgId(), orgSingupInfoDto.getUserId(),
                transferClassRequest.getClassId(), outkexiaoStatistics);
        List<TxTransferClassRecord> transferClassRecordList = Lists.newArrayList();
        Double allRefundMoney = orgSingupInfoDto.getTransferRefundMoney();

        for (TransferLessonInfoDto transferLessonInfoDto : transferLessonList) {
            TxTransferClassRecord txTransferClassRecord = new TxTransferClassRecord();
            txTransferClassRecord.setTransferNumber(transferClassNumber);
            txTransferClassRecord.setTransferOutClassId(transferClassRequest.getClassId());
            txTransferClassRecord.setTransferOutUserId(orgSingupInfoDto.getUserId());
            txTransferClassRecord.setOutPurchaseId(transferLessonInfoDto.getSignupPurchaseId());
            txTransferClassRecord.setInPurchaseId(orgSingupInfoDto.getSignupPurchaseId());
            txTransferClassRecord.setLessonId(transferLessonInfoDto.getLessonId());
            txTransferClassRecord.setChargeUnit(transferLessonInfoDto.getChargeMode());
            if (transferLessonInfoDto.getLessonType().intValue() == LessonType.FREE.getCode()) {
                txTransferClassRecord.setFreeLessonCount(transferLessonInfoDto.getLessonCount());
            } else {
                txTransferClassRecord.setRealLessonCount(transferLessonInfoDto.getLessonCount());
            }
            txTransferClassRecord.setLessonMoney(
                    NumberUtil.multiply(transferLessonInfoDto.getLessonMoney(), NumberUtil.HUNDRED, 0).intValue());
            txTransferClassRecord.setRefundType(SignupRefundType.BY_OLD_PURCHASE_CASH.getCode());

            if (allRefundMoney > 0) {
                if (allRefundMoney - transferLessonInfoDto.getLessonMoney() > 0) {
                    txTransferClassRecord.setRefundMoney(
                            NumberUtil.multiply(transferLessonInfoDto.getLessonMoney(), NumberUtil.HUNDRED, 0).intValue());
                } else {
                    txTransferClassRecord
                            .setRefundMoney(NumberUtil.multiply(allRefundMoney, NumberUtil.HUNDRED, 0).intValue());
                }
                allRefundMoney -= transferLessonInfoDto.getLessonMoney();
            } else {
                txTransferClassRecord.setRefundMoney(0);
            }
            txTransferClassRecord.setStatus(DataStatus.NORMAL.getValue());
            txTransferClassRecord.setCreateTime(now);
            txTransferClassRecord.setUpdateTime(now);

            txTransferClassInfo.setChargeUnit(transferLessonInfoDto.getChargeMode());
            log.debug("transfer calss record temp={},{}", txTransferClassRecord,
                    txTransferClassRecord.getTransferLessonCount());
            txTransferClassInfo
                    .setLessonCount(txTransferClassInfo.getLessonCount() + txTransferClassRecord.getTransferLessonCount());
            txTransferClassInfo
                    .setLessonMoney(txTransferClassInfo.getLessonMoney() + txTransferClassRecord.getLessonMoney());

            transferClassRecordList.add(txTransferClassRecord);

            orgSignupCourseDao.resyncLesson(transferLessonInfoDto.getSignupPurchaseId(), transferClassRequest.getClassId(),
                    txTransferClassInfo.getUserId());
        }


        txTransferClassInfo
                .setOutLeftCount(txTransferClassInfo.getOutLeftCount() - txTransferClassInfo.getLessonCount() < 0 ? 0
                        : txTransferClassInfo.getOutLeftCount() - txTransferClassInfo.getLessonCount());
        txTransferClassInfo
                .setOutLeftMoney(txTransferClassInfo.getOutLeftMoney() - txTransferClassInfo.getLessonMoney() < 0 ? 0l
                        : (txTransferClassInfo.getOutLeftMoney() - txTransferClassInfo.getLessonMoney()));
        txTransferClassInfo.setInLeftCount(
                txTransferClassInfo.getInLeftCount() + orgSingupInfoDto.getCourseInfos().get(0).getLessonCount());
        txTransferClassInfo.setInLeftMoney(txTransferClassInfo.getInLeftMoney() + NumberUtil
                .multiply(orgSingupInfoDto.getCourseInfos().get(0).getTotalPrice(), NumberUtil.HUNDRED, 0).intValue());

        log.debug("Transfer class info = {}", txTransferClassInfo);
        txTransferClassinfoDao.save(txTransferClassInfo);
        log.debug("Transfer class record = {}", transferClassRecordList);
        txTransferClassRecordDao.saveAll(transferClassRecordList);
    }

    @Override
    public List<TransferClassListDto> listTransferInfo(Long orgId, Long outSignupPurchaseId, Long classId) {
        log.info("listTransferInfo by number = {},{},{}", orgId, outSignupPurchaseId, classId);

        List<TxTransferClassRecord> classRecords =
                txTransferClassRecordDao.groupByTransferNumber(outSignupPurchaseId, classId);
        log.info("listTransferInfo by number:{} ", classRecords);
        if (CollectionUtils.isEmpty(classRecords)) {
            return GenericsUtils.emptyList();
        }
        Set<Long> transferClassIds = BaseUtils.getPropertiesList(classRecords, "transferNumber");
        List<TxTransferClassInfo> transferClassInfos = txTransferClassinfoDao.listByTransferNumber(transferClassIds);
        Map<Long, TxTransferClassInfo> txTransferClassInfoMap =
                BaseUtils.listToMap(transferClassInfos, "transferNumber");
        log.debug("listTransferInfo by number={}", txTransferClassInfoMap);

        List<Long> inSignupPurchaseIds = Lists.newArrayList();
        List<Integer> operatorCascadeIds = Lists.newArrayList();
        List<TransferClassListDto> result = Lists.newArrayList();
        for (TxTransferClassRecord transferClassRecord : classRecords) {
            TransferClassListDto dto = new TransferClassListDto();
            dto.setTransferClassNumber(transferClassRecord.getTransferNumber());
            TxTransferClassInfo txTransferClassInfo =
                    txTransferClassInfoMap.get(transferClassRecord.getTransferNumber().longValue());
            log.info("TxTransferClassRecord is:{} and TxTransferClassInfo is:{} ", transferClassRecord,
                    txTransferClassInfo);

            if (txTransferClassInfo != null) {
                dto.setChargeUnit(ChargeUnit.isByTime(transferClassRecord.getChargeUnit())
                        ? ChargeUnit.BY_MINUTE.getCode() : transferClassRecord.getChargeUnit());
                dto.setLessonCount(transferClassRecord.getTransferLessonCount().longValue());
                dto.setLessonMoney((transferClassRecord.getLessonMoney().doubleValue()) / 100);
                dto.setLeftCount(txTransferClassInfo.getOutLeftCount());
                dto.setLeftMoney(NumberUtil.get2Double(txTransferClassInfo.getOutLeftMoney().doubleValue() / 100));
                dto.setOutSignupPurchaseId(outSignupPurchaseId);
                dto.setInSignupPurchaseId(txTransferClassInfo.getTransferInPurchaseId());
                dto.setCreateTime(txTransferClassInfo.getCreateTime());
                dto.setOperatorCascadeId(txTransferClassInfo.getCascadeId().longValue());
                operatorCascadeIds.add(txTransferClassInfo.getCascadeId());
                inSignupPurchaseIds.add(txTransferClassInfo.getTransferInPurchaseId());
                result.add(dto);
            }
        }

        Map<Long, String> transferInClassName = this.mapTransferInclassNames(inSignupPurchaseIds);

        Map<Long, String> txCascadCredentialListByCascdeIds =
                this.txCascadeCredentialDao.getTxCascadCredentialListByCascdeIds(operatorCascadeIds);

        if (operatorCascadeIds.contains(0)) {
            OrgInfo orginfo = orgInfoDao.getOrgInfo(orgId.intValue());
            txCascadCredentialListByCascdeIds.put(0l, orginfo.getContacts());
        }

        for (TransferClassListDto dto : result) {
            dto.setTransferInClassName(transferInClassName.get(dto.getInSignupPurchaseId()));
            dto.setOperator(txCascadCredentialListByCascdeIds.get(dto.getOperatorCascadeId().longValue()));
        }
        return result;
    }

    /**
     * @param inSignupPurchaseIds
     * @return
     */
    private Map<Long, String> mapTransferInclassNames(List<Long> inSignupPurchaseIds) {
        List<OrgSignupCourse> loadByPurchaseIds =
                orgSignupCourseDao.loadByPurchaseIds(inSignupPurchaseIds, "orgCourseId", "signupPurchaseId");
        log.info("loadByPurchaseIds is:{} ", loadByPurchaseIds);
        Map<Long, Long> orgCourseIdToPurchaseId = Maps.newHashMap();
        for (OrgSignupCourse osc : loadByPurchaseIds) {
            orgCourseIdToPurchaseId.put(osc.getSignupPurchaseId(), osc.getOrgCourseId());
        }
        log.info("orgCourseIdToPurchaseId is:{} ", orgCourseIdToPurchaseId);
        Map<Long, String> courseNameMap =
                orgCourseDao.getCourseNameMap(BaseUtils.getListFilter(loadByPurchaseIds, "orgCourseId"));
        log.info("courseNameMap is:{} ", courseNameMap);
        Map<Long, String> newCourseNameMap = Maps.newHashMap();
        for (Map.Entry<Long, Long> entry : orgCourseIdToPurchaseId.entrySet()) {
            newCourseNameMap.put(entry.getKey(), courseNameMap.get(entry.getValue()));
        }
        return newCourseNameMap;
    }

    @Override
    public List<TransferRefundListDto> listTransferRefund(Long inSignupPurchaseId) {
        log.info("listTransferRefund by number = {}", inSignupPurchaseId);
        List<TxTransferClassRecord> recordList = txTransferClassRecordDao.listByInPurchaseId(inSignupPurchaseId);
        if (CollectionUtils.isEmpty(recordList)) {
            return Collections.EMPTY_LIST;
        }
        List<TransferRefundListDto> result = Lists.newArrayList();
        for (TxTransferClassRecord transferClassRecord : recordList) {
            TransferRefundListDto refundListDto = new TransferRefundListDto();
            refundListDto.setTransferInfoNumber(transferClassRecord.getTransferNumber());
            refundListDto.setTransferRecordId(transferClassRecord.getId());
            refundListDto.setOutSignuppurchaseId(transferClassRecord.getOutPurchaseId());
            refundListDto.setInSignupPurchaseId(transferClassRecord.getInPurchaseId());
            refundListDto.setRefundMoney(transferClassRecord.getRefundMoney());
            result.add(refundListDto);
        }
        return result;
    }

    @Override
    public void updateReundType(Long transferClassNumber, Integer refundType) {
        log.info("updateReundType by number = {},{}", transferClassNumber, refundType);
        txTransferClassRecordDao.updateRefundType(transferClassNumber, refundType);
    }

    @Override
    public void cancelTransferClassByPurchase(Long inSignupPurchaseId) {
        log.info("cancelTransferClassByPurchase by number = {}", inSignupPurchaseId);
        List<TxTransferClassRecord> recordList = txTransferClassRecordDao.listByInPurchaseId(inSignupPurchaseId);
        if (CollectionUtils.isNotEmpty(recordList)) {
            cancelTransferClassByNumber(recordList.get(0).getTransferNumber());
        }
    }

    @Override
    public void confirmTransferClass(Long inSignupPurchaseId) {
        log.info("confirmTransferClass by number = {}", inSignupPurchaseId);
        TxTransferClassInfo txTransferClassInfo = txTransferClassinfoDao.getByInPurchaseId(inSignupPurchaseId);
        if (txTransferClassInfo != null) {
            log.info("confirmTransferClass by number 1 = {}", inSignupPurchaseId);
            txTransferClassinfoDao.updateStatus(txTransferClassInfo.getTransferNumber(),
                    TransferClassStatus.SUCCESS.getCode());
            txTransferClassRecordDao.updateStatus(txTransferClassInfo.getTransferNumber(),
                    TransferClassStatus.SUCCESS.getCode());

            List<TxTransferClassRecord> recordList =
                    txTransferClassRecordDao.listByTransferNumber(txTransferClassInfo.getTransferNumber());
            if (CollectionUtils.isNotEmpty(recordList)) {
                for (TxTransferClassRecord record : recordList) {
                    if (txTransferClassInfo.getNeedQuitClass() == 1) {
                        orgSignupCourseDao.updateStatusByPurchaseId(record.getOutPurchaseId(),
                                record.getTransferOutClassId(), txTransferClassInfo.getUserId(),
                                SignupCourseStatus.QUIT_CLASS.getCode());
                    } else {
                        orgSignupCourseDao.resyncLesson(record.getOutPurchaseId(), record.getTransferOutClassId(),
                                txTransferClassInfo.getUserId());
                    }
                }
            }
        }
    }

    @Override
    public void cancelTransferClassByNumber(Long transferClassNumber) {
        log.info("cancel transfer class by number = {}", transferClassNumber);
        txTransferClassinfoDao.updateStatus(transferClassNumber, TransferClassStatus.CANCEL.getCode());
        txTransferClassRecordDao.updateStatus(transferClassNumber, TransferClassStatus.CANCEL.getCode());
    }


    @Override
    public Integer transferLessonCount(Long userId, Long classId) {
        List<TxTransferClassRecord> classRecords =
                txTransferClassRecordDao.listByUserClass(userId, classId, null, TransferClassStatus.SUCCESS.getCode());
        Integer result = 0;
        if (CollectionUtils.isEmpty(classRecords)) {
            return result;
        }
        for (TxTransferClassRecord dto : classRecords) {
            result += dto.getRealLessonCount();
        }
        return result;
    }

}
