package com.baijia.tianxiao.sal.signup.service.Impl;

import java.util.Calendar;
import java.util.Collection;

import javax.annotation.Resource;

import com.baijia.tianxiao.constants.signup.PayResult;
import com.baijia.tianxiao.dal.org.constant.OrgImgType;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupInfoDao;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupOnlinePayDao;
import com.baijia.tianxiao.dal.signup.po.OrgSignupInfo;
import com.baijia.tianxiao.dal.signup.po.OrgSignupOnlinePay;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sal.organization.org.service.OrgPhotoService;
import com.baijia.tianxiao.sal.signup.dto.response.OrgSingupInfoDto;
import com.baijia.tianxiao.sal.signup.service.SignupOnlinePayService;
import com.baijia.tianxiao.sal.signup.service.SignupService;
import com.baijia.tianxiao.util.mobile.MaskUtil;
import lombok.extern.slf4j.Slf4j;

import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;


/**
 * @author cxm
 * @version 1.0
 * @title SignupOnlinePayServiceImpl
 * @desc TODO
 * @date 2015年10月27日
 */
@Service
@Slf4j
public class SignupOnlinePayServiceImpl implements SignupOnlinePayService {

    @Resource
    private OrgPhotoService orgPhotoService;

    @Resource
    private SignupService signupService;

    @Resource
    private OrgSignupOnlinePayDao orgSignupOnlinePayDao;

    @Resource
    private OrgSignupInfoDao orgSignupInfoDao;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public OrgSingupInfoDto loadSignupInfoBySmsKey(String smsKey, Collection<Header> headers) throws BussinessException {
        if (StringUtils.isBlank(smsKey)) {
            throw new BussinessException(CommonErrorCode.PARAM_ERROR, "短信验证码错误,请重新打开链接");
        }
        try {
            OrgSignupOnlinePay onlinePay = orgSignupOnlinePayDao.getBySmsKey(smsKey);
            if (onlinePay == null) {
                throw new BussinessException(CommonErrorCode.PARAM_ERROR, "无法找到订单,请重新发送短信");
            }
            int maxSuriveDay = 3;

            OrgSignupInfo signupInfo = orgSignupInfoDao.searchByPayPurchaseId(onlinePay.getPurchaseId(), false, "signupPurchaseId", "purchaseStatus");
            if (signupInfo.getPurchaseStatus().intValue() != PayResult.SUCCESS.getCode()) {
                // 同步一下订单是否成功
                boolean isSuccess = signupService.isPurchaseSucce(onlinePay.getPurchaseId(), onlinePay.getOrgId(), signupInfo.getCascadeId());
                log.info("Signup info sms key = {},{},{}", onlinePay, signupInfo, isSuccess);
                if (!isSuccess) {
                    Calendar cal = Calendar.getInstance();
                    cal.add(Calendar.DAY_OF_MONTH, 0 - maxSuriveDay);
                    if (onlinePay.getCreateTime().before(cal.getTime())) {
                        throw new BussinessException(CommonErrorCode.PARAM_ERROR, "短信链接已经过期,请重新获取");
                    }
                }

            }

            OrgSingupInfoDto dto =
                    signupService.getCourseInfo(headers, signupInfo.getSignupPurchaseId(), onlinePay.getOrgId(), signupInfo.getCascadeId());
            dto.setSignupPurchaseId(dto.getPayPurchaseId());//特殊处理啦，这里要支付
            dto.setOrgLogoUrl(orgPhotoService.getPhotoUrlByOrgIdAndCategory(onlinePay.getOrgId(), OrgImgType.ORG_LOGO));
            dto.setStudentMobile(MaskUtil.maskMobile(dto.getStudentMobile()));
            dto.setOrgId(null);
            dto.setStudentId(null);
            return dto;
        } catch (BussinessException e) {
            e.printStackTrace();
            log.warn("parse json:{} to object catch error:{}", smsKey, e);
            throw new BussinessException(CommonErrorCode.PARAM_ERROR, e.getMessage());
        }

    }

}
