
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2017 All Rights Reserved.
 */

package com.baijia.tianxiao.sal.signup.dto.response;

import java.util.Collection;

import com.baijia.tianxiao.sal.signup.dto.OrgSignupStorageDto;
import com.google.common.collect.Lists;

import lombok.Data;
import lombok.extern.slf4j.Slf4j;

/**
 * @say little Boy, don't be sad.
 * @name Rezar
 * @time May 2, 2017
 * @Desc this guy is too lazy, nothing left.
 */
@Data
@Slf4j
public class TransferClassRecordDto {

    private Long transferDate; // long类型的日期值
    private Long transferToPurchaseId;// long 转入班级订单id,获取备注详情传递该参数(/signup/getPayPicture.json)
    private Integer transferLessonCount;// 转出课节数
    private Double transferAmount; // 转出金额
    private String transferTo; // 转入班级
    private Integer leftLessonCount; // 剩余课次
    private Double leftAmount;// 剩余学费
    private String operator;// 操作员
    private String remark;// 备注,纯文字
    private int chargeUnit;
    private Collection<OrgSignupStorageDto> imageList = Lists.newArrayList();

    public static TransferClassRecordDto instance(TransferClassListDto tcd) {
        log.info("TransferClassListDto is:{} ", tcd);
        TransferClassRecordDto tcrd = new TransferClassRecordDto();
        tcrd.setTransferDate(tcd.getCreateTime() == null ? System.currentTimeMillis() : tcd.getCreateTime().getTime());
        tcrd.setLeftAmount(tcd.getLeftMoney());
        tcrd.setLeftLessonCount(tcd.getLeftCount());
        tcrd.setOperator(tcd.getOperator());
        tcrd.setRemark(tcd.getRemark());
        tcrd.setTransferLessonCount(tcd.getLessonCount().intValue());
        tcrd.setTransferAmount(tcd.getLessonMoney());
        tcrd.setTransferTo(tcd.getTransferInClassName());
        tcrd.setTransferToPurchaseId(tcd.getInSignupPurchaseId());
        tcrd.setChargeUnit(tcd.getChargeUnit());
        return tcrd;
    }

}
