package com.baijia.tianxiao.sal.signup.dto;

import com.baijia.tianxiao.dal.org.po.OrgClassLesson;
import com.baijia.tianxiao.dal.org.po.OrgStudentLesson;
import com.baijia.tianxiao.util.date.DateUtil;
import lombok.Data;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * Created by lxp on 2017/4/26.
 */
@Data
public class TransferClassOption {

    private CourseStat courseStat;
    private List<SignupOrder> orders = new ArrayList<>();
    private List<StudentLesson> lessons = new ArrayList<>();

    public void addSignupCourse(long signupCourseId,long leftNumber,Date signUpTime,long leftAmount){
        SignupOrder order = new SignupOrder();
        order.setPurchaseId(signupCourseId);
        order.setLeftNumber(leftNumber);
        order.setSignUpTime(signUpTime);
        order.setLeftAmount(leftAmount);
        orders.add(order);
    }

    public void addStudentLesson(long stuLessonId,long amount,int lessonType,OrgClassLesson classLesson){
        StudentLesson lesson = new StudentLesson();
        lesson.setAmount(amount);
        lesson.setDuration(DateUtil.getMinuteDiff(classLesson.getStartTime(),classLesson.getEndTime()));
        lesson.setEndTime(classLesson.getEndTime());
        lesson.setStartTime(classLesson.getStartTime());
        lesson.setLessonName(classLesson.getName());
        lesson.setStuLessonId(classLesson.getId());
        lesson.setIndex(classLesson.getNumber());
        lesson.setLessonType(lessonType);
        lesson.setLessonId(classLesson.getId());
        lessons.add(lesson);
    }

    @Data
    public static class CourseStat{
        private long totalLeftNumber;//总的剩余课次/课时
        private long leftNumber;//订单剩余课次/课时
        private long lessonNumber;//已排未课消数据
        private long totalNumber;//已购
        private long finishNumber;//已上
        private long leftAmount;//剩余学费

        private String courseName;
        private String headTeacher;//班主任
        private int chargeUnit;
        private int chargeMode;
        private int courseType;
        private long courseId;
        private long classId;
    }

    @Data
    public static class SignupOrder{
        private long purchaseId;
        private long leftNumber;
        private Date signUpTime;
        private long leftAmount;
    }

    @Data
    public static class StudentLesson{
        private String lessonName;
        private Date startTime;
        private Date endTime;
        private long amount;
        private long stuLessonId;
        private long lessonId;
        private long duration;
        private int index;
        private int lessonType;
    }
}
