package com.baijia.tianxiao.sal.signup.constants;

import com.google.common.collect.Maps;

import java.util.Map;

/**
 * create by hlj
 * 2016/07/06
 */
public enum SignupRefundType {

    BY_OLD_PURCHASE_CASH(0, "老订单退款现金"),

    BY_ORG_CASH(1, "线下退款给学员"),

    BY_STUDENT_ACCOUNT(2, "退款至学员账户");

    private Integer code;
    private String name;


    SignupRefundType(int code, String name) {
        this.code = code;
        this.name = name;
    }

    private static Map<Integer, SignupRefundType> map = Maps.newHashMap();


    static {
        for (SignupRefundType refundType : SignupRefundType.values()) {
            map.put(refundType.code, refundType);
        }
    }


    public static String getNameByCode(int code) {
        for (SignupRefundType refundType : SignupRefundType.values()) {
            if (code == refundType.getCode()) {
                return refundType.getName();
            }
        }
        return "";
    }


    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public static SignupRefundType getByCode(Integer code) {
        return map.get(code);
    }

}
