package com.baijia.tianxiao.sal.signup.service;

import java.util.Collection;
import java.util.List;
import java.util.Map;

import com.baijia.tianxiao.sal.signup.dto.PaymentResultDto;
import com.baijia.tianxiao.sal.signup.dto.response.OrgSignupListDto;
import com.baijia.tianxiao.sal.signup.dto.response.OrgSingupInfoDto;

import org.apache.http.Header;

import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sal.signup.dto.request.FillCourseInfoRequestDto;
import com.baijia.tianxiao.sal.signup.dto.request.SingupListRequestDto;

import javax.servlet.http.HttpServletResponse;

public interface SignupService {

    List<OrgSingupInfoDto> getSignupList(SingupListRequestDto signQueryRequestDto);

    // 移到course service实现
    // public List<OrgCourseQueryResponseDto> getOrgCourses(Long orgId, String key, PageDto pageDto);

    // public List<OrgCourseQueryResponseDto> getLatestOrgCourses(Long orgId, PageDto pageDto);

    /**
     * 生成收费码
     *
     * @param headers
     * @param orgId
     * @return
     */

    OrgSingupInfoDto generarateTradeNo(Collection<Header> headers, double totalPrice, Long orgId)
            throws BussinessException;

    /**
     * 报名
     *
     * @param fillCourseInfoRequestDto
     * @return
     */
    OrgSingupInfoDto signUp(FillCourseInfoRequestDto fillCourseInfoRequestDto)
            throws BussinessException;

    /**
     * 现金支付
     *
     * @param signupPurchaseId 订单id
     * @param orgId
     * @return
     */
    OrgSingupInfoDto payByCash(Long signupPurchaseId, Long orgId, Integer cascadeId) throws BussinessException;

    /**
     * 删除报名信息
     *
     * @param signupPurchaseId
     * @param orgId
     * @throws BussinessException
     */
    void delSignupInfo(Long signupPurchaseId, Long orgId) throws BussinessException;

    /**
     * 根据订单ID获取支付结果,成功返回true,否则返回false
     *
     * @param signupPurchaseId
     * @return
     * @throws BussinessException
     */
    boolean isPurchaseSucce(Long signupPurchaseId, Long orgId, Integer cascadeId) throws BussinessException;

    /**
     * @param signupPurchaseId
     * @param orgId
     * @param mobile
     * @return
     * @throws BussinessException
     */
    boolean sendOnlinePaySms(Long signupPurchaseId, Long orgId, String mobile) throws BussinessException;


    /**
     * @param signupPurchaseId
     * @param orgId
     * @param mobile
     * @return
     * @throws BussinessException
     */
    boolean sendSignUpSms(Long signupPurchaseId, Long orgId, String mobile) throws BussinessException;

    OrgSingupInfoDto getCourseInfo(Collection<Header> headers, Long signupPurchaseId, Long orgId,Integer cascadeId);

    OrgSignupListDto pcSignupList(SingupListRequestDto requestDto);

    PaymentResultDto getPaymentResultDto(Long signupPurchaseId) throws BussinessException, Exception;

    void updateSignupRemark(Long signupPurchaseId, String remark);

}
