/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.signup.service.Impl;

import com.baijia.commons.lang.utils.date.DateUtils;
import com.baijia.tianxiao.consants.UserRole;
import com.baijia.tianxiao.constants.signup.PayResult;
import com.baijia.tianxiao.constants.signup.PayType;
import com.baijia.tianxiao.constants.signup.SplitCourseResult;
import com.baijia.tianxiao.constants.sms.SmsMessageType;
import com.baijia.tianxiao.constants.sms.SmsSendResult;
import com.baijia.tianxiao.dal.enums.CourseTypeEnum;
import com.baijia.tianxiao.dal.org.constant.CampusAccountType;
import com.baijia.tianxiao.dal.org.constant.DeleteStatus;
import com.baijia.tianxiao.dal.org.constant.StudentType;
import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseTeacherDao;
import com.baijia.tianxiao.dal.org.dao.OrgInfoDao;
import com.baijia.tianxiao.dal.org.dao.OrgSinupPurchaseDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.dao.TXCascadeAccountDao;
import com.baijia.tianxiao.dal.org.dao.TtsSmsDao;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.org.po.OrgCourse;
import com.baijia.tianxiao.dal.org.po.OrgCourseTeacher;
import com.baijia.tianxiao.dal.org.po.OrgSinupPurchase;
import com.baijia.tianxiao.dal.org.po.OrgStudent;
import com.baijia.tianxiao.dal.org.po.TXCascadeAccount;
import com.baijia.tianxiao.dal.org.po.TtsSms;
import com.baijia.tianxiao.dal.signup.constant.SignupStatus;
import com.baijia.tianxiao.dal.signup.constant.SignupType;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupCourseDao;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupFeeDao;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupInfoDao;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupOnlinePayDao;
import com.baijia.tianxiao.dal.signup.po.OrgSignupCourse;
import com.baijia.tianxiao.dal.signup.po.OrgSignupFee;
import com.baijia.tianxiao.dal.signup.po.OrgSignupInfo;
import com.baijia.tianxiao.dal.signup.po.OrgSignupOnlinePay;
import com.baijia.tianxiao.dal.user.dao.TeacherDao;
import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.dto.signup.CreatePurchaseResponseDto;
import com.baijia.tianxiao.dto.signup.PayResultDto;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.enums.SignupErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sal.organization.org.service.TXAccountService;
import com.baijia.tianxiao.sal.organization.org.service.TxCascadeCredentialService;
import com.baijia.tianxiao.sal.signup.constants.SignupSourceType;
import com.baijia.tianxiao.sal.signup.dto.PaymentResultDto;
import com.baijia.tianxiao.sal.signup.dto.SignupCourseInfoDto;
import com.baijia.tianxiao.sal.signup.dto.SignupFeeItemDto;
import com.baijia.tianxiao.sal.signup.dto.request.FillCourseInfoRequestDto;
import com.baijia.tianxiao.sal.signup.dto.request.SingupListRequestDto;
import com.baijia.tianxiao.sal.signup.dto.response.OrgSignupListDto;
import com.baijia.tianxiao.sal.signup.dto.response.OrgSingupInfoDto;
import com.baijia.tianxiao.sal.signup.service.SignupService;
import com.baijia.tianxiao.sal.student.api.OrgStudentService;
import com.baijia.tianxiao.sal.student.api.OrgStudentTagService;
import com.baijia.tianxiao.sal.student.dto.CommentInfoDto;
import com.baijia.tianxiao.sal.student.dto.StudentInfoDto;
import com.baijia.tianxiao.sal.student.dto.TagInfoDto;
import com.baijia.tianxiao.sal.student.dto.response.OrgStudentAddresponseDto;
import com.baijia.tianxiao.sal.student.dto.response.OrgTagListResopnseDto;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.util.BaseUtils;
import com.baijia.tianxiao.util.DigitUppercaseUtils;
import com.baijia.tianxiao.util.NumberUtil;
import com.baijia.tianxiao.util.SerializeUtil;
import com.baijia.tianxiao.util.ShortUrlUtil;
import com.baijia.tianxiao.util.SmsSendUtil;
import com.baijia.tianxiao.util.encrypt.MD5Utils;
import com.baijia.tianxiao.util.mobile.MaskUtil;
import com.baijia.tianxiao.util.properties.UrlProperties;
import com.baijia.tianxiao.util.rest.RestUtils;
import com.baijia.tianxiao.validation.ParamValidateUtils;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import lombok.NonNull;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.Transformer;
import org.apache.commons.lang.StringUtils;
import org.apache.http.Header;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.core.RedisCallback;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SignupServiceImpl
implements SignupService {
    private static final Logger log = LoggerFactory.getLogger(SignupServiceImpl.class);
    public static final BigDecimal HUNDRED = new BigDecimal(100);
    public static final String TIANXIAO_SIGNUP_REDIS_PRE = "TIANXIAO_SIGNUP_INFO_";
    @Resource
    private OrgCourseDao orgCourseDao;
    @Resource
    private OrgCourseTeacherDao orgCourseTeacherDao;
    @Resource
    private OrgSignupCourseDao orgSignupCourseDao;
    @Resource
    private OrgSignupInfoDao orgSignupInfoDao;
    @Resource
    private OrgInfoDao orgInfoDao;
    @Resource
    private OrgSinupPurchaseDao orgSinupPurchaseDao;
    @Resource
    private OrgSignupFeeDao orgSignupFeeDao;
    @Resource
    private OrgSignupOnlinePayDao orgSignupOninePayDao;
    @Resource
    private TtsSmsDao ttsSmsDao;
    @Resource
    private OrgStudentDao orgStudentDao;
    @Autowired(required=true)
    private OrgStudentService orgStudentService;
    @Resource
    private OrgAccountDao orgAccountDao;
    @Resource
    private TeacherDao teacherDao;
    @Resource
    private TXAccountService txAccountService;
    @Resource
    private TXCascadeAccountDao txCascadeAccountDao;
    @Resource
    private TxCascadeCredentialService txCascadeCredentialService;
    @Autowired(required=false)
    private StringRedisTemplate redisTemplate;
    @Resource
    private OrgStudentTagService orgStudentTagService;

    private Long getOrgNumber(Long orgId) {
        OrgAccount account = this.orgAccountDao.getAccountById(orgId.intValue(), new String[]{"number"});
        if (account == null) {
            return null;
        }
        Integer number = account.getNumber();
        return number != null ? Long.valueOf(number.longValue()) : null;
    }

    @Override
    public OrgSignupListDto pcSignupList(SingupListRequestDto requestDto) {
        TXCascadeAccount txCascadeAccount;
        Integer cascadeId = requestDto.getCascadeId();
        if (cascadeId != null && (txCascadeAccount = (TXCascadeAccount)this.txCascadeAccountDao.getById((Serializable)cascadeId, new String[0])) != null && txCascadeAccount.getAccountType() != CampusAccountType.STAFF.getCode()) {
            cascadeId = null;
            requestDto.setCascadeId(null);
        }
        OrgSignupListDto orgSignupListDto = new OrgSignupListDto();
        orgSignupListDto.setList(this.getSignupList(requestDto));
        requestDto.setSignupStatus(SignupStatus.NOT_PAY.getCode());
        orgSignupListDto.setNotPayNum(this.orgSignupInfoDao.countByPurchaseStatus(requestDto.getOrgId(), requestDto.getPurchaseStatusCodes(), requestDto.getSplitCodes(), cascadeId));
        orgSignupListDto.setNotPayPrice(this.orgSignupInfoDao.sumByPurchaseStatus(requestDto.getOrgId(), requestDto.getPurchaseStatusCodes(), requestDto.getSplitCodes(), cascadeId, false).doubleValue() / 100.0);
        requestDto.setSignupStatus(SignupStatus.NOT_SIGN.getCode());
        orgSignupListDto.setNotSignNum(this.orgSignupInfoDao.countByPurchaseStatus(requestDto.getOrgId(), requestDto.getPurchaseStatusCodes(), requestDto.getSplitCodes(), cascadeId));
        orgSignupListDto.setNotSignPrice(this.orgSignupInfoDao.sumByPurchaseStatus(requestDto.getOrgId(), requestDto.getPurchaseStatusCodes(), requestDto.getSplitCodes(), cascadeId, false).doubleValue() / 100.0);
        return orgSignupListDto;
    }

    @Override
    public List<OrgSingupInfoDto> getSignupList(SingupListRequestDto requestDto) {
        List result;
        List courseIds;
        Preconditions.checkNotNull((Object)requestDto.getOrgId(), (Object)"orgId may not be null");
        requestDto.setOrgNumber(this.getOrgNumber(requestDto.getOrgId()));
        Preconditions.checkNotNull((Object)requestDto.getOrgNumber(), (Object)"orgNumber may not be null");
        String key = requestDto.getSearchKey();
        ArrayList purchaseIds = Lists.newArrayList();
        if (StringUtils.isNotBlank((String)key) && CollectionUtils.isNotEmpty((Collection)(courseIds = this.orgCourseDao.getCourseIdsByOrgNumberAndCourseName(requestDto.getOrgNumber(), key, Integer.valueOf(0), CourseTypeEnum.IS_COURSE_TRUE.getCode(), null, null)))) {
            purchaseIds.addAll(this.orgSignupCourseDao.searchPurchaseIdByCourseId((Collection)courseIds, requestDto.getStartTime(), requestDto.getEndTime()));
        }
        if (CollectionUtils.isEmpty((Collection)(result = this.orgSignupInfoDao.getOrgSignupInfo(requestDto.getMethod(), requestDto.getSource(), requestDto.getOrgId(), (Collection)purchaseIds, requestDto.getPurchaseStatusCodes(), requestDto.getSplitCodes(), requestDto.getPayTypeCodes(), key, requestDto.getStartTime(), requestDto.getEndTime(), requestDto.getCascadeId(), (PageDto)requestDto, new String[0])))) {
            return Collections.emptyList();
        }
        this.loadSignupCourseInfo(result);
        this.loadSignupFeeItem(result);
        boolean isShowMobile = this.txCascadeCredentialService.isShowMobile(requestDto.getOrgId(), requestDto.getCascadeId());
        return this.buildOrgSingupInfoDtos(result, this.orgInfoDao.getOrgShortNameByOrgId(Integer.valueOf(requestDto.getOrgId().intValue())), isShowMobile);
    }

    private List<OrgSingupInfoDto> buildOrgSingupInfoDtos(Collection<OrgSignupInfo> orgSignupInfos, String orgName, boolean isShowMobile) {
        ArrayList orgSingupInfoDtos = Lists.newArrayList();
        HashSet courseIds = Sets.newHashSet();
        if (CollectionUtils.isNotEmpty(orgSignupInfos)) {
            Long orgId = 0L;
            for (OrgSignupInfo orgSignupInfo : orgSignupInfos) {
                orgId = orgSignupInfo.getOrgId();
                if (!CollectionUtils.isNotEmpty((Collection)orgSignupInfo.getOrgSignupCourses())) continue;
                for (OrgSignupCourse orgSignupCourse : orgSignupInfo.getOrgSignupCourses()) {
                    courseIds.add(orgSignupCourse.getOrgCourseId());
                }
            }
            Map courseMap = this.orgCourseDao.getOrgCourseMap((Collection)courseIds);
            Map<Long, List<String>> courseTeacherNameMap = this.getCourseIdTeacherNamesMap(courseIds);
            Map cascadeMap = this.txCascadeCredentialService.getByTxCasCadeIds(orgId);
            for (OrgSignupInfo orgSignupInfo : orgSignupInfos) {
                OrgSingupInfoDto dto = this.buildOrgSignupInfoDto(orgSignupInfo, orgName, courseMap, courseTeacherNameMap, cascadeMap, isShowMobile);
                orgSingupInfoDtos.add(dto);
            }
        }
        return orgSingupInfoDtos;
    }

    private OrgSingupInfoDto buildOrgSignupInfoDto(OrgSignupInfo orgSignupInfo, String orgName, Map<Long, OrgCourse> courseMap, Map<Long, List<String>> courseTeacherNameMap, Map<Long, String> cascadeMap, boolean isShowMobile) {
        OrgSingupInfoDto dto = new OrgSingupInfoDto();
        if (orgSignupInfo != null) {
            dto.setTotalPrice(orgSignupInfo.getTotalPrices().doubleValue() / 100.0);
            dto.setChinesePrice(DigitUppercaseUtils.digitUppercase((double)dto.getTotalPrice()));
            dto.setSourceType(orgSignupInfo.getSourceType().intValue() == SignupSourceType.TX_SIANGUP.getCode().intValue() ? SignupSourceType.SIGNUP.getCode() : orgSignupInfo.getSourceType());
            dto.setPayResultEnum(PayResult.getPayResultByCode((Integer)orgSignupInfo.getPurchaseStatus()));
            dto.setPayTypeEnum(PayType.getPayTypeByCode((Integer)orgSignupInfo.getPayType()));
            dto.setSignupTypeEnum(SignupType.getTypeByCode((Integer)orgSignupInfo.getSignupType()));
            dto.setOrgId(orgSignupInfo.getOrgId());
            dto.setOrgName(orgName);
            if (dto.getSignupType().intValue() == SignupType.FRONTED.getCode()) {
                dto.setSignUpTime(orgSignupInfo.getCreateTime());
            } else {
                dto.setSignUpTime(orgSignupInfo.getUpdateTime());
            }
            if (orgSignupInfo.getPurchaseStatus() == 1) {
                dto.setPayTime(orgSignupInfo.getPayTime());
                String cascadeIdStr = cascadeMap.get(orgSignupInfo.getCascadeId() == null ? 0L : orgSignupInfo.getCascadeId().longValue());
                dto.setCascadeIdStr(cascadeIdStr == null ? "" : cascadeIdStr);
            } else {
                dto.setCascadeIdStr("--");
            }
            dto.setSignupPurchaseId(orgSignupInfo.getSignupPurchaseId());
            dto.setCreateTime(orgSignupInfo.getCreateTime());
            dto.setUpdateTime(orgSignupInfo.getUpdateTime());
            dto.setCourseInfos(Lists.newArrayList());
            dto.setId(orgSignupInfo.getId());
            dto.setStatus((int)orgSignupInfo.getPurchaseStatus(), (int)orgSignupInfo.getSplitResult());
            String remark = "\u65e0";
            if (StringUtils.isNotBlank((String)orgSignupInfo.getRemark())) {
                remark = orgSignupInfo.getRemark();
            }
            if (orgSignupInfo.getTradeNo() != null && orgSignupInfo.getTradeNo() != 0L) {
                dto.setTradeNo((long)orgSignupInfo.getTradeNo());
            } else {
                dto.setTradeNo(orgSignupInfo.getSignupPurchaseId());
            }
            if (CollectionUtils.isNotEmpty((Collection)orgSignupInfo.getHeaders())) {
                String payUrlWinxin = RestUtils.getWeiXinPurchaseUrl((Long)orgSignupInfo.getSignupPurchaseId(), (Long)orgSignupInfo.getOrgId(), (Double)(orgSignupInfo.getTotalPrices().doubleValue() / 100.0), (Collection)orgSignupInfo.getHeaders());
                dto.setPayUrlWinxin(payUrlWinxin);
            }
            dto.setRemark(remark);
            dto.setStudentId(orgSignupInfo.getUserId());
            dto.setStudentMobile(orgSignupInfo.getMobile());
            if (!isShowMobile) {
                dto.setStudentMobile(MaskUtil.maskMobile((String)dto.getStudentMobile()));
            }
            dto.setStudentName(orgSignupInfo.getStudentName());
            dto.setOperator(orgSignupInfo.getOperator());
            if (CollectionUtils.isNotEmpty((Collection)orgSignupInfo.getOrgSignupCourses())) {
                for (OrgSignupCourse orgSignupCourse : orgSignupInfo.getOrgSignupCourses()) {
                    Long courseId = orgSignupCourse.getOrgCourseId();
                    dto.getCourseInfos().add(this.buildOrgSignupCourseDto(orgSignupCourse, courseMap.get(courseId), courseTeacherNameMap.get(courseId)));
                }
            }
            if (CollectionUtils.isNotEmpty((Collection)orgSignupInfo.getOrgSignupFees())) {
                for (OrgSignupFee orgSignupFee : orgSignupInfo.getOrgSignupFees()) {
                    dto.getFeeItemDtos().add(this.buildOrgSignupFeeItemDto(orgSignupFee));
                }
            }
        }
        return dto;
    }

    private SignupCourseInfoDto buildOrgSignupCourseDto(OrgSignupCourse orgSignupCourse, OrgCourse orgCourse, List<String> teacherNames) {
        SignupCourseInfoDto dto = new SignupCourseInfoDto();
        dto.setCount(orgSignupCourse.getCount());
        dto.setDiscount(orgSignupCourse.getCourseDiscount());
        dto.setOrgCourseId(orgSignupCourse.getOrgCourseId());
        dto.setOriginPrice(orgSignupCourse.getOriginPrice().doubleValue() / 100.0);
        double preferential = ((100.0 - orgSignupCourse.getCourseDiscount().doubleValue()) / 100.0 * (double)orgSignupCourse.getOriginPrice().intValue() * (double)orgSignupCourse.getCount().intValue() + (double)orgSignupCourse.getPreferential().intValue()) / 100.0;
        dto.setPreferential(preferential);
        dto.setPayPrice(orgSignupCourse.getPayPrice().doubleValue() / 100.0);
        dto.setOrgCourseName(orgCourse == null ? "" : orgCourse.getName());
        dto.setOrgCourseNumber(orgCourse == null ? 0L : orgCourse.getNumber());
        dto.setTeacherNames(teacherNames);
        dto.setTeacherNameStr(teacherNames == null || teacherNames.size() == 0 ? "\u5f85\u5b9a" : BaseUtils.listToStr(teacherNames, (String)","));
        dto.setCourseType(orgCourse.getCourseType());
        dto.setTotalPrice(dto.getOriginPrice() * (double)dto.getCount());
        return dto;
    }

    private SignupFeeItemDto buildOrgSignupFeeItemDto(OrgSignupFee orgSignupFee) {
        SignupFeeItemDto dto = new SignupFeeItemDto();
        dto.setCount(orgSignupFee.getCount());
        dto.setDiscount(orgSignupFee.getFeeItemDiscount());
        dto.setFeeItemId(orgSignupFee.getFeeItemId());
        dto.setFeeItemName(orgSignupFee.getFeeItemName());
        dto.setOriginPrice(orgSignupFee.getOriginPrice().doubleValue() / 100.0);
        double preferential = ((100.0 - orgSignupFee.getFeeItemDiscount().doubleValue()) / 100.0 * (double)orgSignupFee.getOriginPrice().intValue() * (double)orgSignupFee.getCount().intValue() + (double)orgSignupFee.getPreferential().intValue()) / 100.0;
        dto.setPreferential(preferential);
        dto.setPayPrice(orgSignupFee.getPayPrice().doubleValue() / 100.0);
        return dto;
    }

    private void loadSignupCourseInfo(Collection<OrgSignupInfo> orgSignupInfos) {
        Long purchaseId;
        ArrayList purchaseIds = Lists.newArrayList();
        for (OrgSignupInfo info : orgSignupInfos) {
            purchaseIds.add(info.getSignupPurchaseId());
        }
        List signupCourses = this.orgSignupCourseDao.loadByPurchaseIds((Collection)purchaseIds, new String[0]);
        HashMap signupCourseMaping = Maps.newHashMap();
        for (OrgSignupCourse orgSignupCourse : signupCourses) {
            purchaseId = orgSignupCourse.getSignupPurchaseId();
            if (!signupCourseMaping.containsKey(purchaseId)) {
                signupCourseMaping.put(purchaseId, new ArrayList());
            }
            ((List)signupCourseMaping.get(purchaseId)).add(orgSignupCourse);
        }
        for (OrgSignupInfo orgSignupInfo : orgSignupInfos) {
            purchaseId = orgSignupInfo.getSignupPurchaseId();
            if (!signupCourseMaping.containsKey(purchaseId)) continue;
            orgSignupInfo.setOrgSignupCourses((List)signupCourseMaping.get(purchaseId));
        }
    }

    private void loadSignupFeeItem(Collection<OrgSignupInfo> orgSignupInfos) {
        Long purchaseId;
        ArrayList purchaseIds = Lists.newArrayList();
        for (OrgSignupInfo info : orgSignupInfos) {
            purchaseIds.add(info.getSignupPurchaseId());
        }
        List signupFeeItems = this.orgSignupFeeDao.loadByPurchaseIds((Collection)purchaseIds, new String[0]);
        HashMap signupFeeItemMaping = Maps.newHashMap();
        for (OrgSignupFee orgSignupFee : signupFeeItems) {
            purchaseId = orgSignupFee.getSignupPurchaseId();
            if (!signupFeeItemMaping.containsKey(purchaseId)) {
                signupFeeItemMaping.put(purchaseId, new ArrayList());
            }
            ((List)signupFeeItemMaping.get(purchaseId)).add(orgSignupFee);
        }
        for (OrgSignupInfo orgSignupInfo : orgSignupInfos) {
            purchaseId = orgSignupInfo.getSignupPurchaseId();
            if (!signupFeeItemMaping.containsKey(purchaseId)) continue;
            orgSignupInfo.setOrgSignupFees((List)signupFeeItemMaping.get(purchaseId));
        }
    }

    private OrgSingupInfoDto buildOrgSignupInfoDto(OrgSignupInfo orgSignupInfo, boolean isShowMobile) {
        HashSet courseIds = Sets.newHashSet();
        if (CollectionUtils.isNotEmpty((Collection)orgSignupInfo.getOrgSignupCourses())) {
            for (OrgSignupCourse orgSignupCourse : orgSignupInfo.getOrgSignupCourses()) {
                courseIds.add(orgSignupCourse.getOrgCourseId());
            }
        }
        Map courseMap = this.orgCourseDao.getOrgCourseMap((Collection)courseIds);
        Map<Long, List<String>> courseTeacherNameMap = this.getCourseIdTeacherNamesMap(courseIds);
        Map cascadeMap = this.txCascadeCredentialService.getByTxCasCadeIds(orgSignupInfo.getOrgId());
        return this.buildOrgSignupInfoDto(orgSignupInfo, this.orgInfoDao.getOrgShortNameByOrgId(orgSignupInfo.getOrgId() != null ? Integer.valueOf(orgSignupInfo.getOrgId().intValue()) : null), courseMap, courseTeacherNameMap, cascadeMap, isShowMobile);
    }

    @Override
    public OrgSingupInfoDto generarateTradeNo(Collection<Header> headers, double totalPrice, Long orgId) throws BussinessException {
        OrgSingupInfoDto dto = new OrgSingupInfoDto();
        if (totalPrice < 0.0) {
            log.error("totalPrice = {} < 0.", (Object)totalPrice);
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "totalPrice < 0");
        }
        CreatePurchaseResponseDto purchaseResponseDto = RestUtils.createPurchaseResponseDto((Long)orgId, (Double)totalPrice, headers);
        Long purchaseId = purchaseResponseDto.getData().getPurchaseId();
        dto.setSignupPurchaseId(purchaseId);
        Long tradeNo = RestUtils.getTradeNo((Long)orgId, (Long)purchaseId, (Double)totalPrice, headers);
        dto.setTradeNo(tradeNo);
        String payUrlWinxin = RestUtils.getWeiXinPurchaseUrl((Long)purchaseId, (Long)orgId, (Double)totalPrice, headers);
        log.info("payUrlWinxin=={}", (Object)payUrlWinxin);
        dto.setPayUrlWinxin(payUrlWinxin);
        dto.setOrgId(orgId);
        dto.setTotalPrice(totalPrice);
        return dto;
    }

    @Override
    public OrgSingupInfoDto signUp(FillCourseInfoRequestDto fillCourseInfoRequestDto) throws BussinessException {
        Preconditions.checkNotNull((Object)fillCourseInfoRequestDto.getOrgId(), (Object)"orgId may not be null");
        fillCourseInfoRequestDto.setOrgNumber(this.getOrgNumber(fillCourseInfoRequestDto.getOrgId()));
        Preconditions.checkNotNull((Object)fillCourseInfoRequestDto.getOrgNumber(), (Object)"orgNumber may not be null");
        Long orgId = fillCourseInfoRequestDto.getOrgId();
        Long orgNumber = fillCourseInfoRequestDto.getOrgNumber();
        log.info("signUp--> orgId {}, signupPurchaseId {}", (Object)orgId, (Object)fillCourseInfoRequestDto.getSignupPurchaseId());
        if (fillCourseInfoRequestDto.getOrgNumber() == null) {
            fillCourseInfoRequestDto.setOrgNumber(this.getOrgNumber(fillCourseInfoRequestDto.getOrgId()));
        }
        OrgSingupInfoDto dto = null;
        if (fillCourseInfoRequestDto.getSignupType() == SignupType.POS_CARD.getCode()) {
            if (!this.isPurchaseSucce(fillCourseInfoRequestDto.getSignupPurchaseId(), orgId, fillCourseInfoRequestDto.getCascadeId())) {
                throw new BussinessException((UniverseErrorCode)SignupErrorCode.PURCHASE_NOT_SUCCEED);
            }
            dto = this.signupAfterPay(fillCourseInfoRequestDto, orgId, orgNumber);
            this.saveContent(TIANXIAO_SIGNUP_REDIS_PRE + dto.getSignupPurchaseId(), SerializeUtil.serialize((Object)dto));
            return dto;
        }
        if (fillCourseInfoRequestDto.getSignupType() == SignupType.FRONTED.getCode()) {
            dto = this.signupBeforePay(fillCourseInfoRequestDto, orgId, orgNumber);
            this.saveContent(TIANXIAO_SIGNUP_REDIS_PRE + dto.getSignupPurchaseId(), SerializeUtil.serialize((Object)dto));
            return dto;
        }
        if (fillCourseInfoRequestDto.getSignupType() == SignupType.ONLINE.getCode()) {
            return this.signupPayOnline(fillCourseInfoRequestDto, orgId, orgNumber);
        }
        throw new BussinessException((UniverseErrorCode)SignupErrorCode.UNKNOWN_PURCHASE_STATUS);
    }

    private OrgSingupInfoDto signupPayOnline(FillCourseInfoRequestDto fillCourseInfoRequestDto, Long orgId, Long orgNumber) {
        throw new UnsupportedOperationException("not implement....");
    }

    private OrgSingupInfoDto signupBeforePay(FillCourseInfoRequestDto fillCourseInfoRequestDto, Long orgId, Long orgNumber) throws BussinessException {
        if (CollectionUtils.isNotEmpty(fillCourseInfoRequestDto.getCourseInfos())) {
            double totalPrice = 0.0;
            for (SignupCourseInfoDto signupCourseInfoDto : fillCourseInfoRequestDto.getCourseInfos()) {
                totalPrice += this.caculatePayPrice(signupCourseInfoDto);
            }
            if (fillCourseInfoRequestDto.getFeeItemDtos() != null) {
                for (SignupFeeItemDto signupFeeItemDto : fillCourseInfoRequestDto.getFeeItemDtos()) {
                    totalPrice += this.caculateFeePrice(signupFeeItemDto);
                }
            }
            if (totalPrice < 0.0) {
                throw new BussinessException((UniverseErrorCode)SignupErrorCode.TOTALPRICE_ERROR);
            }
            long begin = System.currentTimeMillis();
            Long purchaseId = RestUtils.getPurchaseId((Long)orgId, (Double)totalPrice, fillCourseInfoRequestDto.getHeaders());
            Long tradeNo = RestUtils.getTradeNo((Long)orgId, (Long)purchaseId, (Double)totalPrice, fillCourseInfoRequestDto.getHeaders());
            long end = System.currentTimeMillis();
            log.debug("signupBeforePay-->    RestUtils.getPurchaseId cost{}", (Object)(end - begin));
            log.info("getPurchaseId--> {}", (Object)purchaseId);
            Date now = new Date();
            OrgSignupInfo orgSignupInfo = new OrgSignupInfo();
            orgSignupInfo.setCreateTime(new Date());
            orgSignupInfo.setSplitResult(Integer.valueOf(SplitCourseResult.PENDING.getCode()));
            this.fillOrgSignupInfo(fillCourseInfoRequestDto, orgSignupInfo, orgId, orgNumber);
            orgSignupInfo.setSignupPurchaseId(purchaseId);
            orgSignupInfo.setTradeNo(tradeNo);
            fillCourseInfoRequestDto.setSignupPurchaseId(purchaseId);
            orgSignupInfo.setSignupType(Integer.valueOf(1));
            orgSignupInfo.setTotalPrices(Long.valueOf(NumberUtil.multiply((Number)totalPrice, (BigDecimal)HUNDRED, (int)0).longValue()));
            ArrayList orgSignupCourses = Lists.newArrayList();
            for (SignupCourseInfoDto signupCourseInfoDto : fillCourseInfoRequestDto.getCourseInfos()) {
                signupCourseInfoDto.setPayPrice(this.caculatePayPrice(signupCourseInfoDto));
                orgSignupCourses.add(this.fillOrgSignupCourse(fillCourseInfoRequestDto, signupCourseInfoDto, orgSignupInfo.getUserId(), now, orgId));
            }
            orgSignupInfo.setOrgSignupCourses((List)orgSignupCourses);
            ArrayList orgSignupFees = Lists.newArrayList();
            if (fillCourseInfoRequestDto.getFeeItemDtos() != null) {
                for (SignupFeeItemDto signupFeeItemDto : fillCourseInfoRequestDto.getFeeItemDtos()) {
                    signupFeeItemDto.setPayPrice(this.caculateFeePrice(signupFeeItemDto));
                    orgSignupFees.add(this.fillOrgSignupFee(fillCourseInfoRequestDto, signupFeeItemDto, orgSignupInfo.getUserId(), now, orgId));
                }
            }
            orgSignupInfo.setOrgSignupFees((List)orgSignupFees);
            orgSignupInfo.setHeaders(fillCourseInfoRequestDto.getHeaders());
            orgSignupInfo.setSourceType(Integer.valueOf(fillCourseInfoRequestDto.getSourceType()));
            this.saveOrUpdateSignupInfo(orgSignupInfo, true);
            this.saveContent(TIANXIAO_SIGNUP_REDIS_PRE + orgSignupInfo.getSignupPurchaseId(), SerializeUtil.serialize((Object)orgSignupInfo));
            boolean isShowMobile = this.txCascadeCredentialService.isShowMobile(orgId, fillCourseInfoRequestDto.getCascadeId());
            return this.buildOrgSignupInfoDto(orgSignupInfo, isShowMobile);
        }
        throw new BussinessException((UniverseErrorCode)SignupErrorCode.SIGNUPCOURSE_NULL);
    }

    public boolean signupCourseInfoEqual(OrgSignupCourse orgSignupCourse, SignupCourseInfoDto signupCourseInfoDto) {
        if (orgSignupCourse == null) {
            return true;
        }
        if (orgSignupCourse.getCount().intValue() != signupCourseInfoDto.getCount()) {
            return false;
        }
        if (orgSignupCourse.getCourseDiscount().intValue() != signupCourseInfoDto.getDiscount()) {
            return false;
        }
        if (orgSignupCourse.getOriginPrice().intValue() != signupCourseInfoDto.getOriginPrice().intValue()) {
            return false;
        }
        return orgSignupCourse.getPreferential().intValue() == NumberUtil.multiply((Number)signupCourseInfoDto.getPreferential(), (BigDecimal)HUNDRED, (int)0).intValue();
    }

    private OrgSingupInfoDto signupAfterPay(FillCourseInfoRequestDto fillCourseInfoRequestDto, Long orgId, Long orgNumber) throws BussinessException {
        long total;
        OrgSignupInfo orgSignupInfo = null;
        if (fillCourseInfoRequestDto.getSignupPurchaseId() != null) {
            orgSignupInfo = this.orgSignupInfoDao.searchByPurchaseId(fillCourseInfoRequestDto.getSignupPurchaseId(), true, new String[0]);
            orgSignupInfo.setOrgSignupCourses(this.orgSignupCourseDao.loadByPurchaseId(fillCourseInfoRequestDto.getSignupPurchaseId(), new String[0]));
            orgSignupInfo.setOrgSignupFees(this.orgSignupFeeDao.loadByPurchaseId(fillCourseInfoRequestDto.getSignupPurchaseId(), new String[0]));
        }
        if (orgSignupInfo == null || orgSignupInfo.getSignupType() != 0) {
            throw new BussinessException((UniverseErrorCode)SignupErrorCode.PURCHASEID_ERROR);
        }
        if (orgSignupInfo != null && orgSignupInfo.getSplitResult().intValue() == SplitCourseResult.SUCCESS.getCode()) {
            throw new BussinessException((UniverseErrorCode)SignupErrorCode.COURCE_CHANGE);
        }
        if (orgSignupInfo.getSplitResult() >= SplitCourseResult.PENDING.getCode()) {
            throw new BussinessException((UniverseErrorCode)SignupErrorCode.REPEAT_SUBMIT);
        }
        this.fillOrgSignupInfo(fillCourseInfoRequestDto, orgSignupInfo, orgId, orgNumber);
        orgSignupInfo.setSplitResult(Integer.valueOf(SplitCourseResult.PENDING.getCode()));
        long totalNow = 0L;
        long totalNew = 0L;
        Date now = new Date();
        HashMap<Long, OrgSignupCourse> orgSignupCourseMap = new HashMap<Long, OrgSignupCourse>();
        ArrayList orgSignupCoursesNew = Lists.newArrayList();
        ArrayList orgSignupCoursesNow = Lists.newArrayList();
        orgSignupCoursesNow.addAll(orgSignupInfo.getOrgSignupCourses());
        if (CollectionUtils.isNotEmpty((Collection)orgSignupInfo.getOrgSignupCourses())) {
            for (OrgSignupCourse orgSignupCourse : orgSignupInfo.getOrgSignupCourses()) {
                totalNow += orgSignupCourse.getPayPrice().longValue();
                orgSignupCourseMap.put(orgSignupCourse.getOrgCourseId(), orgSignupCourse);
            }
        }
        if (orgSignupInfo.getTotalPrices() <= totalNow) {
            log.warn(" signupAfterPay get error:{}", (Object)SignupErrorCode.REPEAT_SUBMIT.getMessage());
            throw new BussinessException((UniverseErrorCode)SignupErrorCode.REPEAT_SUBMIT);
        }
        if (CollectionUtils.isNotEmpty(fillCourseInfoRequestDto.getCourseInfos())) {
            for (SignupCourseInfoDto signupCourseInfoDto : fillCourseInfoRequestDto.getCourseInfos()) {
                if (orgSignupCourseMap.containsKey(signupCourseInfoDto.getOrgCourseId())) {
                    if (this.signupCourseInfoEqual((OrgSignupCourse)orgSignupCourseMap.get(signupCourseInfoDto.getOrgCourseId()), signupCourseInfoDto)) continue;
                    log.warn(" fillCourseInfo get error:{}", (Object)SignupErrorCode.COURCE_CHANGE.getMessage());
                    throw new BussinessException((UniverseErrorCode)SignupErrorCode.COURCE_CHANGE);
                }
                signupCourseInfoDto.setPayPrice(this.caculatePayPrice(signupCourseInfoDto));
                totalNew += NumberUtil.multiply((Number)signupCourseInfoDto.getPayPrice(), (BigDecimal)HUNDRED, (int)0).longValue();
                orgSignupCoursesNew.add(this.fillOrgSignupCourse(fillCourseInfoRequestDto, signupCourseInfoDto, orgSignupInfo.getUserId(), now, orgId));
            }
        }
        if ((total = totalNew + totalNow) < 0L) {
            throw new BussinessException((UniverseErrorCode)SignupErrorCode.TOTALPRICE_ERROR, SignupErrorCode.TOTALPRICE_ERROR.getMessage());
        }
        if ((double)total != orgSignupInfo.getTotalPrices().doubleValue()) {
            throw new BussinessException((UniverseErrorCode)SignupErrorCode.TOTALPRICE_NOTMATCH, SignupErrorCode.TOTALPRICE_NOTMATCH.getMessage());
        }
        if (orgSignupInfo.getPayType().intValue() == PayType.CASH.getCode()) {
            orgSignupInfo.setSplitResult(Integer.valueOf(SplitCourseResult.SUCCESS.getCode()));
        } else {
            orgSignupInfo.setSplitResult(Integer.valueOf(SplitCourseResult.PENDING.getCode()));
        }
        if (CollectionUtils.isNotEmpty((Collection)orgSignupCoursesNew)) {
            orgSignupInfo.setOrgSignupCourses((List)orgSignupCoursesNew);
        }
        orgSignupInfo.setSourceType(Integer.valueOf(fillCourseInfoRequestDto.getSourceType()));
        this.saveOrUpdateSignupInfo(orgSignupInfo, true);
        orgSignupInfo.getOrgSignupCourses().addAll(orgSignupCoursesNow);
        orgSignupInfo.setPurchaseStatus(Integer.valueOf(PayResult.SUCCESS.getCode()));
        this.saveContent(TIANXIAO_SIGNUP_REDIS_PRE + orgSignupInfo.getSignupPurchaseId(), SerializeUtil.serialize((Object)orgSignupInfo));
        boolean isShowMobile = this.txCascadeCredentialService.isShowMobile(orgId, fillCourseInfoRequestDto.getCascadeId());
        return this.buildOrgSignupInfoDto(orgSignupInfo, isShowMobile);
    }

    private double caculatePayPrice(SignupCourseInfoDto signupCourseInfoDto) {
        BigDecimal result = new BigDecimal(signupCourseInfoDto.getOriginPrice()).multiply(new BigDecimal(signupCourseInfoDto.getDiscount())).divide(HUNDRED).multiply(new BigDecimal(signupCourseInfoDto.getCount())).subtract(new BigDecimal(signupCourseInfoDto.getPreferential())).setScale(2, RoundingMode.HALF_UP);
        return result.doubleValue();
    }

    private double caculateFeePrice(SignupFeeItemDto signupFeeItemDto) {
        BigDecimal result = new BigDecimal(signupFeeItemDto.getOriginPrice()).multiply(new BigDecimal(signupFeeItemDto.getDiscount())).divide(HUNDRED).multiply(new BigDecimal(signupFeeItemDto.getCount())).subtract(new BigDecimal(signupFeeItemDto.getPreferential())).setScale(2, RoundingMode.HALF_UP);
        return result.doubleValue();
    }

    private OrgSignupCourse fillOrgSignupCourse(FillCourseInfoRequestDto fillCourseInfoRequestDto, SignupCourseInfoDto signupCourseInfoDto, Long studentId, Date now, Long orgId) {
        OrgSignupCourse orgSignupCourse = new OrgSignupCourse();
        orgSignupCourse.setCount(Integer.valueOf(signupCourseInfoDto.getCount()));
        orgSignupCourse.setCourseDiscount(Integer.valueOf(signupCourseInfoDto.getDiscount()));
        orgSignupCourse.setCreateTime(now);
        orgSignupCourse.setOrgCourseId(signupCourseInfoDto.getOrgCourseId());
        orgSignupCourse.setOrgId(orgId);
        orgSignupCourse.setOriginPrice(Integer.valueOf(NumberUtil.multiply((Number)signupCourseInfoDto.getOriginPrice(), (BigDecimal)HUNDRED, (int)0).intValue()));
        orgSignupCourse.setPreferential(Integer.valueOf(NumberUtil.multiply((Number)signupCourseInfoDto.getPreferential(), (BigDecimal)HUNDRED, (int)0).intValue()));
        orgSignupCourse.setSignupPurchaseId(fillCourseInfoRequestDto.getSignupPurchaseId());
        orgSignupCourse.setOrgCourseNumber(signupCourseInfoDto.getOrgCourseNumber());
        orgSignupCourse.setUserId(studentId);
        orgSignupCourse.setPayPrice(Long.valueOf(NumberUtil.multiply((Number)this.caculatePayPrice(signupCourseInfoDto), (BigDecimal)HUNDRED, (int)0).longValue()));
        return orgSignupCourse;
    }

    private OrgSignupFee fillOrgSignupFee(FillCourseInfoRequestDto fillCourseInfoRequestDto, SignupFeeItemDto signupFeeItemDto, Long studentId, Date now, Long orgId) {
        OrgSignupFee orgSignupFee = new OrgSignupFee();
        orgSignupFee.setCount(Integer.valueOf(signupFeeItemDto.getCount()));
        orgSignupFee.setFeeItemDiscount(Integer.valueOf(signupFeeItemDto.getDiscount()));
        orgSignupFee.setCreateTime(now);
        orgSignupFee.setFeeItemId(signupFeeItemDto.getFeeItemId());
        orgSignupFee.setOrgId(orgId);
        orgSignupFee.setOriginPrice(Integer.valueOf(NumberUtil.multiply((Number)signupFeeItemDto.getOriginPrice(), (BigDecimal)HUNDRED, (int)0).intValue()));
        orgSignupFee.setPreferential(Integer.valueOf(NumberUtil.multiply((Number)signupFeeItemDto.getPreferential(), (BigDecimal)HUNDRED, (int)0).intValue()));
        orgSignupFee.setSignupPurchaseId(fillCourseInfoRequestDto.getSignupPurchaseId());
        orgSignupFee.setFeeItemName(signupFeeItemDto.getFeeItemName());
        orgSignupFee.setUserId(studentId);
        orgSignupFee.setPayPrice(Long.valueOf(NumberUtil.multiply((Number)this.caculateFeePrice(signupFeeItemDto), (BigDecimal)HUNDRED, (int)0).longValue()));
        return orgSignupFee;
    }

    private Long getStudent(FillCourseInfoRequestDto fillCourseInfoRequestDto) throws BussinessException {
        Long usrId = null;
        Long studentId = null;
        Long orgId = fillCourseInfoRequestDto.getOrgId();
        String mobile = fillCourseInfoRequestDto.getStudentMobile();
        String studentName = fillCourseInfoRequestDto.getStudentName();
        List students = Lists.newArrayList();
        if (fillCourseInfoRequestDto.getStudentId() != null) {
            ArrayList studentIds = Lists.newArrayList();
            studentIds.add(fillCourseInfoRequestDto.getStudentId());
            students = this.orgStudentDao.getStudentByIds(fillCourseInfoRequestDto.getOrgId(), (Collection)studentIds, new String[0]);
        } else {
            students = this.orgStudentDao.getStudentId(orgId, mobile, Integer.valueOf(DeleteStatus.NORMAL.getValue()), studentName, new String[]{"userId", "id", "mobile", "showMobile"});
        }
        StudentInfoDto studentInfoDto = new StudentInfoDto();
        if (!students.isEmpty()) {
            OrgStudent stu = (OrgStudent)students.get(0);
            usrId = stu.getUserId();
            studentId = stu.getId();
            studentInfoDto = this.fillStudentInfoByStu(studentInfoDto, stu);
        }
        log.debug("studentInfoDto = {}", (Object)studentInfoDto);
        studentInfoDto = this.fillStudentInfo(studentInfoDto, fillCourseInfoRequestDto);
        List<CommentInfoDto> commentInfoDtos = this.fillCommentInfoList(fillCourseInfoRequestDto);
        List<TagInfoDto> tagInfoDtos = this.fillTagInfoList(studentId, fillCourseInfoRequestDto);
        log.debug("studentInfoDto = {},tagInfoDto={}", (Object)studentInfoDto, tagInfoDtos);
        if (studentId == null) {
            studentInfoDto.setConfirm(Integer.valueOf(1));
            OrgStudentAddresponseDto dto = this.orgStudentService.addStudent(studentInfoDto, commentInfoDtos, tagInfoDtos, orgId);
            usrId = dto.getUserId();
        } else {
            this.orgStudentService.modStudent(studentInfoDto, commentInfoDtos, tagInfoDtos, orgId);
        }
        return usrId;
    }

    private StudentInfoDto fillStudentInfoByStu(StudentInfoDto studentInfoDto, OrgStudent stu) {
        studentInfoDto.setStudentId(stu.getId());
        studentInfoDto.setMobile(stu.getStudentMobile());
        studentInfoDto.setQq(stu.getQq());
        studentInfoDto.setWeixin(stu.getWeixin());
        studentInfoDto.setName(stu.getName());
        studentInfoDto.setBirthday(stu.getBirthday() != null ? Long.valueOf(stu.getBirthday().getTime()) : null);
        studentInfoDto.setRemark(stu.getRemark());
        studentInfoDto.setMail(stu.getMail());
        studentInfoDto.setParentName(stu.getParentName());
        studentInfoDto.setParentMobile(stu.getParentMobile());
        studentInfoDto.setGender(stu.getGender());
        studentInfoDto.setNextRemindTimeDate(stu.getNextRemindTime());
        studentInfoDto.setAddress(stu.getAddress());
        studentInfoDto.setDegreeClass(stu.getDegreeClass());
        studentInfoDto.setFatherOccupation(stu.getFatherOccupation());
        studentInfoDto.setMatherOccupation(stu.getMatherOccupation());
        studentInfoDto.setSource(stu.getSource());
        studentInfoDto.setSchool(stu.getSchool());
        studentInfoDto.setBranchId(stu.getBranchId());
        studentInfoDto.setRelationship(stu.getRelationship());
        studentInfoDto.setLatitude(Double.valueOf(stu.getLatitude() != null ? stu.getLatitude() : 0.0));
        studentInfoDto.setLongitude(Double.valueOf(stu.getLongitude() != null ? stu.getLongitude() : 0.0));
        studentInfoDto.setAreaId(stu.getAreaId());
        studentInfoDto.setStorageId(stu.getAvatar());
        studentInfoDto.setNextRemindTime(stu.getNextRemindTime() != null ? Long.valueOf(stu.getNextRemindTime().getTime()) : null);
        return studentInfoDto;
    }

    private StudentInfoDto fillStudentInfo(StudentInfoDto studentInfoDto, FillCourseInfoRequestDto fillCourseInfoRequestDto) {
        if (fillCourseInfoRequestDto.getStudentId() != null) {
            studentInfoDto.setStudentId(fillCourseInfoRequestDto.getStudentId());
        }
        if (fillCourseInfoRequestDto.getStudentMobile() != null && !fillCourseInfoRequestDto.getStudentMobile().contains("*")) {
            studentInfoDto.setMobile(fillCourseInfoRequestDto.getStudentMobile());
        }
        if (fillCourseInfoRequestDto.getStudentQQ() != null) {
            studentInfoDto.setQq(fillCourseInfoRequestDto.getStudentQQ());
        }
        if (fillCourseInfoRequestDto.getStudentWx() != null) {
            studentInfoDto.setWeixin(fillCourseInfoRequestDto.getStudentWx());
        }
        if (fillCourseInfoRequestDto.getStudentName() != null) {
            studentInfoDto.setName(fillCourseInfoRequestDto.getStudentName());
        }
        if (fillCourseInfoRequestDto.getBirthday() != null) {
            studentInfoDto.setBirthday(Long.valueOf(fillCourseInfoRequestDto.getBirthday().getTime()));
        }
        if (fillCourseInfoRequestDto.getStudentRemark() != null) {
            studentInfoDto.setRemark(fillCourseInfoRequestDto.getStudentRemark());
        }
        if (fillCourseInfoRequestDto.getEmail() != null) {
            studentInfoDto.setMail(fillCourseInfoRequestDto.getEmail());
        }
        if (fillCourseInfoRequestDto.getParentName() != null) {
            studentInfoDto.setParentName(fillCourseInfoRequestDto.getParentName());
        }
        if (fillCourseInfoRequestDto.getParentMobile() != null && !fillCourseInfoRequestDto.getParentMobile().contains("*")) {
            studentInfoDto.setParentMobile(fillCourseInfoRequestDto.getParentMobile());
        }
        if (fillCourseInfoRequestDto.getGender() != null) {
            studentInfoDto.setGender(fillCourseInfoRequestDto.getGender());
        }
        if (fillCourseInfoRequestDto.getTags() != null) {
            studentInfoDto.setTags(fillCourseInfoRequestDto.getTags());
        }
        return studentInfoDto;
    }

    private List<CommentInfoDto> fillCommentInfoList(FillCourseInfoRequestDto fillCourseInfoRequestDto) {
        return Collections.EMPTY_LIST;
    }

    private List<TagInfoDto> fillTagInfoList(Long studentId, FillCourseInfoRequestDto fillCourseInfoRequestDto) {
        String[] tags;
        log.debug("fillTagInfoList={}", (Object)fillCourseInfoRequestDto);
        ArrayList tagInfoDtos = Lists.newArrayList();
        if (StringUtils.isEmpty((String)fillCourseInfoRequestDto.getTags())) {
            OrgTagListResopnseDto tagsResponse = this.orgStudentTagService.getTags(Integer.valueOf(StudentType.ORG_STUDENTS.getCode()), studentId, fillCourseInfoRequestDto.getOrgId());
            return tagsResponse.getTags();
        }
        for (String tag : tags = fillCourseInfoRequestDto.getTags().split(" ")) {
            TagInfoDto tagInfoDto = new TagInfoDto();
            tagInfoDto.setContent(tag);
            tagInfoDtos.add(tagInfoDto);
        }
        log.debug("fillTagInfoList={},{}", (Object)tagInfoDtos, (Object)tags);
        return tagInfoDtos;
    }

    private void fillOrgSignupInfo(FillCourseInfoRequestDto fillCourseInfoRequestDto, OrgSignupInfo orgSignupInfo, Long orgId, Long orgNumber) throws BussinessException {
        long begin = System.currentTimeMillis();
        Long stuUserId = this.getStudent(fillCourseInfoRequestDto);
        long end = System.currentTimeMillis();
        log.debug("-->    getStudent cost{}", (Object)(end - begin));
        orgSignupInfo.setUserId(stuUserId);
        orgSignupInfo.setOrgId(orgId);
        orgSignupInfo.setOrgNumber(orgNumber);
        orgSignupInfo.setMobile(fillCourseInfoRequestDto.getStudentMobile());
        orgSignupInfo.setStudentName(fillCourseInfoRequestDto.getStudentName());
        if (orgSignupInfo.getPayType() == null) {
            orgSignupInfo.setPayType(Integer.valueOf(PayType.PAY_POS_CARD.getCode()));
        }
        orgSignupInfo.setRemark(StringUtils.isEmpty((String)fillCourseInfoRequestDto.getRemark()) ? orgSignupInfo.getRemark() : fillCourseInfoRequestDto.getRemark());
        orgSignupInfo.setRemark(orgSignupInfo.getRemark() == null ? "" : orgSignupInfo.getRemark());
        orgSignupInfo.setOperator("");
        orgSignupInfo.setUpdateTime(new Date());
        orgSignupInfo.setSignupType(Integer.valueOf(fillCourseInfoRequestDto.getSignupType()));
        if (orgSignupInfo.getCascadeId() == null || orgSignupInfo.getCascadeId() == 0) {
            orgSignupInfo.setCascadeId(Integer.valueOf(fillCourseInfoRequestDto.getCascadeId() == null ? 0 : fillCourseInfoRequestDto.getCascadeId()));
        }
    }

    @Override
    @Transactional
    public OrgSingupInfoDto payByCash(Long signupPurchaseId, Long orgId, Integer cascadeId) throws BussinessException {
        OrgSignupInfo orgSignupInfo = this.orgSignupInfoDao.searchByPurchaseId(signupPurchaseId, new String[0]);
        boolean isNew = false;
        if (orgSignupInfo == null) {
            OrgSinupPurchase purchase = this.orgSinupPurchaseDao.getByPurchaseId(signupPurchaseId, new String[0]);
            log.debug("get purchase:{} by purchaseId:{}", (Object)purchase, (Object)signupPurchaseId);
            if (purchase != null) {
                isNew = true;
                orgSignupInfo = this.insertSuccSignupInfo(purchase, purchase.getPurchaseId(), cascadeId);
            }
        }
        if (orgSignupInfo == null) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "signup purchase error");
        }
        orgSignupInfo.setOrgSignupCourses(this.orgSignupCourseDao.loadByPurchaseId(signupPurchaseId, new String[0]));
        OrgSignupInfo saveObj = new OrgSignupInfo();
        saveObj.setId(orgSignupInfo.getId());
        saveObj.setPayType(Integer.valueOf(PayType.CASH.getCode()));
        saveObj.setPurchaseStatus(Integer.valueOf(1));
        saveObj.setPayTime(new Date());
        if (isNew) {
            saveObj.setSplitResult(Integer.valueOf(SplitCourseResult.NOT_COMMIT.getCode()));
        } else {
            saveObj.setSplitResult(Integer.valueOf(SplitCourseResult.SUCCESS.getCode()));
        }
        this.orgSignupInfoDao.update((Object)saveObj, Boolean.valueOf(false), new String[]{"payType", "purchaseStatus", "splitResult", "payTime"});
        orgSignupInfo.setPayType(Integer.valueOf(PayType.CASH.getCode()));
        orgSignupInfo.setPurchaseStatus(Integer.valueOf(1));
        orgSignupInfo.setCascadeId(cascadeId);
        this.saveContent(TIANXIAO_SIGNUP_REDIS_PRE + orgSignupInfo.getSignupPurchaseId(), SerializeUtil.serialize((Object)orgSignupInfo));
        boolean isShowMobile = this.txCascadeCredentialService.isShowMobile(orgId, cascadeId);
        return this.buildOrgSignupInfoDto(orgSignupInfo, isShowMobile);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void delSignupInfo(Long signupPurchaseId, Long orgId) throws BussinessException {
        OrgSignupInfo orgSignupInfo = this.orgSignupInfoDao.searchByPurchaseId(signupPurchaseId, new String[]{"id"});
        if (orgSignupInfo == null) {
            throw new BussinessException((UniverseErrorCode)SignupErrorCode.PURCHASEID_ERROR);
        }
        OrgSignupInfo saveObj = new OrgSignupInfo();
        saveObj.setId(orgSignupInfo.getId());
        saveObj.setIsDel(Integer.valueOf(1));
        this.orgSignupInfoDao.update((Object)saveObj, Boolean.valueOf(false), new String[]{"isDel"});
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean isPurchaseSucce(Long signupPurchaseId, Long orgId, Integer cascadeId) throws BussinessException {
        Preconditions.checkNotNull((Object)signupPurchaseId);
        Preconditions.checkArgument((signupPurchaseId > 0L ? 1 : 0) != 0, (Object)"purchase id can not be 0");
        OrgSinupPurchase purchase = this.orgSinupPurchaseDao.getByPurchaseId(signupPurchaseId, new String[0]);
        OrgSignupInfo orgSignupInfo = this.orgSignupInfoDao.searchByPurchaseId(signupPurchaseId, new String[0]);
        if (orgSignupInfo != null && orgSignupInfo.getPayType() != null && orgSignupInfo.getPayType().intValue() == PayType.CASH.getCode()) {
            byte[] signupBytes = this.getContent(TIANXIAO_SIGNUP_REDIS_PRE + signupPurchaseId);
            if (signupBytes == null) {
                return true;
            }
            OrgSignupInfo orgSignupInfoRedis = (OrgSignupInfo)SerializeUtil.unserialize((byte[])signupBytes);
            if (orgSignupInfoRedis != null) {
                orgSignupInfoRedis.setPurchaseStatus(Integer.valueOf(PayResult.SUCCESS.getCode()));
                this.saveContent(TIANXIAO_SIGNUP_REDIS_PRE + orgSignupInfoRedis.getSignupPurchaseId(), SerializeUtil.serialize((Object)orgSignupInfoRedis));
            }
            return true;
        }
        if (purchase.getStatus() != null && purchase.getStatus().intValue() == PayResult.SUCCESS.getCode()) {
            OrgSignupInfo orgSignupInfoRedis;
            Map tradeNoMap = RestUtils.getTradeNoMap((Collection)Lists.newArrayList((Object[])new Long[]{signupPurchaseId}));
            if (orgSignupInfo == null) {
                this.insertSuccSignupInfo(purchase, (Long)tradeNoMap.get(signupPurchaseId), cascadeId);
            } else if (orgSignupInfo.getPurchaseStatus().intValue() != PayResult.SUCCESS.getCode()) {
                if (tradeNoMap.isEmpty() || !tradeNoMap.containsKey(signupPurchaseId)) {
                    throw new BussinessException((UniverseErrorCode)SignupErrorCode.PURCHASE_NOT_SUCCEED);
                }
                orgSignupInfo.setPurchaseStatus(Integer.valueOf(PayResult.SUCCESS.getCode()));
                int payType = PayType.getPayTypeByTypeStr((String)purchase.getPayType()).getCode();
                orgSignupInfo.setTradeNo((Long)tradeNoMap.get(signupPurchaseId));
                orgSignupInfo.setPayType(Integer.valueOf(payType));
                orgSignupInfo.setPayTime(new Date());
                this.orgSignupInfoDao.update((Object)orgSignupInfo, new String[]{"purchaseStatus", "tradeNo", "payType", "payTime"});
                this.saveContent(TIANXIAO_SIGNUP_REDIS_PRE + signupPurchaseId, SerializeUtil.serialize((Object)orgSignupInfo));
                return true;
            }
            byte[] signupBytes = this.getContent(TIANXIAO_SIGNUP_REDIS_PRE + signupPurchaseId);
            if (signupBytes != null && (orgSignupInfoRedis = (OrgSignupInfo)SerializeUtil.unserialize((byte[])signupBytes)) != null) {
                orgSignupInfoRedis.setPurchaseStatus(Integer.valueOf(PayResult.SUCCESS.getCode()));
                this.saveContent(TIANXIAO_SIGNUP_REDIS_PRE + orgSignupInfoRedis.getSignupPurchaseId(), SerializeUtil.serialize((Object)orgSignupInfoRedis));
            }
            return true;
        }
        return false;
    }

    private OrgSignupInfo insertSuccSignupInfo(OrgSinupPurchase sinupPurchase, Long tradeNo, Integer cascadeId) {
        log.info("create signup info from purchase:{}", (Object)sinupPurchase);
        OrgSignupInfo info = new OrgSignupInfo();
        info.setCreateTime(sinupPurchase.getPayTime());
        info.setPayTime(sinupPurchase.getPayTime());
        info.setIsDel(Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        info.setMobile("");
        info.setOperator("");
        info.setOrgId(sinupPurchase.getOrgId());
        info.setOrgNumber(sinupPurchase.getOrgNumber());
        info.setPayType(Integer.valueOf(PayType.getPayTypeByTypeStr((String)sinupPurchase.getPayType()).getCode()));
        info.setPurchaseStatus(sinupPurchase.getStatus());
        info.setRemark("");
        info.setSignupPurchaseId(sinupPurchase.getPurchaseId());
        info.setSignupType(Integer.valueOf(SignupType.POS_CARD.getCode()));
        info.setSplitResult(Integer.valueOf(SplitCourseResult.NOT_COMMIT.getCode()));
        info.setStudentName("");
        info.setTotalPrices(Long.valueOf(NumberUtil.multiply((Number)sinupPurchase.getTotalPrices(), (BigDecimal)HUNDRED, (int)0).longValue()));
        info.setUpdateTime(new Date());
        info.setUserId(Long.valueOf(0L));
        info.setTradeNo(tradeNo);
        info.setCascadeId(cascadeId);
        this.saveOrUpdateSignupInfo(info, false);
        return info;
    }

    private void saveOrUpdateSignupInfo(@NonNull OrgSignupInfo signupInfo, boolean saveCourses) {
        if (signupInfo == null) {
            throw new NullPointerException("signupInfo");
        }
        if (signupInfo.getSourceType() == null || signupInfo.getSourceType() == 0) {
            signupInfo.setSourceType(SignupSourceType.TX_SIANGUP.getCode());
        }
        if (signupInfo.getId() != null && signupInfo.getId() > 0L) {
            this.orgSignupInfoDao.update((Object)signupInfo, new String[0]);
        } else {
            this.orgSignupInfoDao.save((Object)signupInfo, new String[0]);
        }
        if (saveCourses && CollectionUtils.isNotEmpty((Collection)signupInfo.getOrgSignupCourses())) {
            try {
                this.orgSignupCourseDao.saveSignupCourses(signupInfo.getOrgSignupCourses());
            }
            catch (DuplicateKeyException e) {
                log.warn("\u6570\u636e\u91cd\u590d\u3002e = {}", (Throwable)e);
            }
        }
        if (saveCourses && CollectionUtils.isNotEmpty((Collection)signupInfo.getOrgSignupFees())) {
            try {
                this.orgSignupFeeDao.saveSignupFees(signupInfo.getOrgSignupFees());
            }
            catch (Exception e) {
                log.warn("\u6570\u636eerror\u3002e = {}", (Throwable)e);
            }
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean sendOnlinePaySms(@NonNull Long signupPurchaseId, @NonNull Long orgId, @NonNull String mobile) throws BussinessException {
        if (signupPurchaseId == null) {
            throw new NullPointerException("signupPurchaseId");
        }
        if (orgId == null) {
            throw new NullPointerException("orgId");
        }
        if (mobile == null) {
            throw new NullPointerException("mobile");
        }
        OrgSignupInfo purchase = this.orgSignupInfoDao.searchByPurchaseId(signupPurchaseId, new String[0]);
        if (!ParamValidateUtils.validateMobile((String)mobile)) {
            throw new BussinessException((UniverseErrorCode)SignupErrorCode.MOBILE_FORMATE_ERROR);
        }
        if (purchase == null || !purchase.getOrgId().equals(orgId)) {
            throw new BussinessException((UniverseErrorCode)SignupErrorCode.PURCHASE_ID_INVALIDATE);
        }
        if (purchase.getPurchaseStatus().intValue() == PayResult.SUCCESS.getCode()) {
            throw new BussinessException((UniverseErrorCode)SignupErrorCode.PURCHASE_ID_ALREADY_PAY_SUCC);
        }
        if (purchase.getSplitResult().intValue() == SplitCourseResult.NOT_COMMIT.getCode()) {
            throw new BussinessException((UniverseErrorCode)SignupErrorCode.SIGNUP_HAS_NOT_COURSE_INFO);
        }
        int count = this.orgSignupOninePayDao.countByMobileAndPurchaseId(signupPurchaseId, mobile, DateUtils.getToday());
        String maxCountStr = UrlProperties.getProperty((String)"max.signup.count");
        int maxCount = 3;
        if (StringUtils.isNumeric((String)maxCountStr)) {
            maxCount = Integer.parseInt(maxCountStr);
        }
        if (count >= maxCount) {
            throw new BussinessException((UniverseErrorCode)SignupErrorCode.SEND_SMS_COUNT_TOO_SOON);
        }
        OrgSignupOnlinePay onlinePay = new OrgSignupOnlinePay();
        onlinePay.setCreateTime(new Date());
        onlinePay.setPurchaseId(signupPurchaseId);
        onlinePay.setOrgId(orgId);
        onlinePay.setToMobile(mobile);
        String smsKey = MD5Utils.MD5((String)("TTS_SIGNUP_KEY" + signupPurchaseId + mobile + System.currentTimeMillis()));
        onlinePay.setSmsKey(smsKey);
        this.orgSignupOninePayDao.save((Object)onlinePay, new String[0]);
        purchase.setPayType(Integer.valueOf(PayType.ONLINE_PAYMENT.getCode()));
        this.orgSignupInfoDao.update((Object)purchase, new String[]{"payType"});
        return this.createAndSaveTtsSms(orgId, onlinePay.getId(), mobile, this.buildSmsContent("\u60a8\u6b63\u5728\u62a5\u540d\u300e%s\u300f\u7684%s,\u8d39\u7528%s\u5143\u3002\u70b9\u51fb\u94fe\u63a5\u5b8c\u6210\u7f34\u8d39\uff1a%s", purchase, smsKey));
    }

    private String buildSmsContent(String smsTemplate, OrgSignupInfo purchase, String smsKey) {
        log.debug("buildSmsContent  purchaseId = {}", (Object)purchase.getSignupPurchaseId());
        List courses = this.orgSignupCourseDao.loadByPurchaseId(purchase.getSignupPurchaseId(), new String[]{"orgCourseId", "originPrice", "payPrice"});
        HashSet courseIds = Sets.newHashSet();
        CollectionUtils.collect((Iterable)courses, (Transformer)new Transformer<OrgSignupCourse, Long>(){

            public Long transform(OrgSignupCourse input) {
                return input.getOrgCourseId();
            }
        }, (Collection)courseIds);
        Map courseName = this.orgCourseDao.getCourseNameMap((Collection)courseIds);
        log.debug("courseIds = {} courseName={}", (Object)courseIds, (Object)courseName);
        String orgName = this.orgInfoDao.getOrgShortNameByOrgId(Integer.valueOf(purchase.getOrgId().intValue()));
        String cName = null;
        for (OrgSignupCourse course : courses) {
            if (cName != null) continue;
            cName = "\u300e" + (String)courseName.get(course.getOrgCourseId()) + "\u300f";
        }
        String h5Url = ShortUrlUtil.getShortUrl((String)(UrlProperties.getProperty((String)"signup.online.pay.url") + "?smsKey=" + smsKey));
        if (courseName.size() > 1) {
            cName = cName + "\u7b49\u8bfe\u7a0b";
        }
        return String.format(smsTemplate, orgName, cName, purchase.getTotalPrices().doubleValue() / 100.0, h5Url);
    }

    @Override
    public boolean sendSignUpSms(@NonNull Long signupPurchaseId, @NonNull Long orgId, @NonNull String mobile) throws BussinessException {
        if (signupPurchaseId == null) {
            throw new NullPointerException("signupPurchaseId");
        }
        if (orgId == null) {
            throw new NullPointerException("orgId");
        }
        if (mobile == null) {
            throw new NullPointerException("mobile");
        }
        log.info("sendSignUpSms signupPurchaseId={},orgId={},mobile={}", new Object[]{signupPurchaseId, orgId, mobile});
        OrgSignupInfo purchase = this.orgSignupInfoDao.searchByPurchaseId(signupPurchaseId, new String[0]);
        if (!ParamValidateUtils.validateMobile((String)mobile)) {
            throw new BussinessException((UniverseErrorCode)SignupErrorCode.MOBILE_FORMATE_ERROR);
        }
        if (purchase == null || !purchase.getOrgId().equals(orgId)) {
            throw new BussinessException((UniverseErrorCode)SignupErrorCode.PURCHASE_ID_INVALIDATE);
        }
        int count = this.orgSignupOninePayDao.countByMobileAndPurchaseId(signupPurchaseId, mobile, DateUtils.getToday());
        log.debug("count={}", (Object)count);
        String maxCountStr = UrlProperties.getProperty((String)"max.signup.count");
        int maxCount = 3;
        if (StringUtils.isNumeric((String)maxCountStr)) {
            maxCount = Integer.parseInt(maxCountStr);
        }
        if (count >= maxCount) {
            throw new BussinessException((UniverseErrorCode)SignupErrorCode.SEND_SMS_COUNT_TOO_SOON);
        }
        OrgSignupOnlinePay onlinePay = new OrgSignupOnlinePay();
        onlinePay.setCreateTime(new Date());
        onlinePay.setPurchaseId(signupPurchaseId);
        onlinePay.setOrgId(orgId);
        onlinePay.setToMobile(mobile);
        String smsKey = MD5Utils.MD5((String)("TTS_SIGNUP_KEY" + signupPurchaseId + mobile + System.currentTimeMillis()));
        onlinePay.setSmsKey(smsKey);
        this.orgSignupOninePayDao.save((Object)onlinePay, new String[0]);
        return this.createAndSaveTtsSms(orgId, onlinePay.getId(), mobile, this.buildSmsContent("\u606d\u559c\u60a8\u6210\u529f\u62a5\u540d\u300e%s\u300f\u7684%s,\u8d39\u7528%s\u5143\u3002\u70b9\u51fb\u94fe\u63a5\u67e5\u770b\u62a5\u540d\u51ed\u8bc1\uff1a%s", purchase, smsKey));
    }

    private boolean createAndSaveTtsSms(Long orgId, Long onlinePayId, String mobile, String content) {
        TtsSms sms = new TtsSms();
        sms.setContent(content);
        sms.setMessageType((Number)SmsMessageType.NOTIFY.getCode());
        sms.setMobile(mobile);
        boolean sendResult = SmsSendUtil.sendSms((String)mobile, (String)content, (Integer)SmsMessageType.TIANXIAO_NOTIFY.getCode(), (Integer)orgId.intValue(), (Integer)UserRole.ORGANIZATION.getRole(), (boolean)true, (Integer)this.txAccountService.getTxAccountSmsGate(Integer.valueOf(orgId.intValue())));
        sms.setSendResult((Number)(sendResult ? SmsSendResult.SUCCESS.getValue() : SmsSendResult.FAILED.getValue()));
        sms.setSendSmsKey(onlinePayId);
        try {
            this.ttsSmsDao.save((Object)sms, new String[0]);
        }
        catch (Exception e) {
            log.warn("save sms record catch error:{}", (Throwable)e);
        }
        log.info("send sms to :{},onlinePayId:{} is succ:{}", new Object[]{mobile, onlinePayId, sendResult});
        return sendResult;
    }

    private Map<Long, List<String>> getCourseIdTeacherNamesMap(Collection<Long> courseIds) {
        List orgCourseTeachers = this.orgCourseTeacherDao.getOrgCourseTeacher(courseIds, null);
        if (CollectionUtils.isNotEmpty((Collection)orgCourseTeachers)) {
            HashMap result = Maps.newHashMap();
            HashSet teacherIds = Sets.newHashSet();
            for (OrgCourseTeacher orgCourseTeacher : orgCourseTeachers) {
                teacherIds.add(orgCourseTeacher.getUserId());
            }
            Map teacherNames = this.teacherDao.getTeacherRealNameMap((Collection)teacherIds);
            for (OrgCourseTeacher orgCourseTeacher : orgCourseTeachers) {
                Long courseId = orgCourseTeacher.getOrgCourseId();
                if (!result.containsKey(courseId)) {
                    result.put(courseId, Lists.newArrayList());
                }
                ((List)result.get(courseId)).add(teacherNames.get(orgCourseTeacher.getUserId()));
            }
            return result;
        }
        return Collections.emptyMap();
    }

    @Override
    public OrgSingupInfoDto getCourseInfo(Collection<Header> headers, Long signupPurchaseId, Long orgId, Integer cascadeId) {
        OrgSignupOnlinePay onlinePayRecord;
        OrgSignupInfo orgSignupInfo = this.orgSignupInfoDao.searchByPurchaseId(signupPurchaseId, new String[0]);
        if (orgSignupInfo == null) {
            orgSignupInfo = (OrgSignupInfo)SerializeUtil.unserialize((byte[])this.getContent(TIANXIAO_SIGNUP_REDIS_PRE + signupPurchaseId));
        } else {
            orgSignupInfo.setOrgSignupCourses(this.orgSignupCourseDao.loadByPurchaseId(signupPurchaseId, new String[0]));
            orgSignupInfo.setOrgSignupFees(this.orgSignupFeeDao.loadByPurchaseId(signupPurchaseId, new String[0]));
        }
        boolean isShowMobile = this.txCascadeCredentialService.isShowMobile(orgId, cascadeId);
        OrgSingupInfoDto dto = this.buildOrgSignupInfoDto(orgSignupInfo, isShowMobile);
        if (orgSignupInfo.getPurchaseStatus().intValue() != PayResult.SUCCESS.getCode()) {
            log.info("get new TradeNo while pay status is not success");
            Long tradeNo = RestUtils.getTradeNo((Long)orgSignupInfo.getOrgId(), (Long)orgSignupInfo.getSignupPurchaseId(), (Double)(orgSignupInfo.getTotalPrices().doubleValue() / 100.0), headers);
            dto.setTradeNo(tradeNo);
            String payUrlWinxin = RestUtils.getWeiXinPurchaseUrl((Long)signupPurchaseId, (Long)orgSignupInfo.getOrgId(), (Double)(orgSignupInfo.getTotalPrices().doubleValue() / 100.0), headers);
            dto.setPayUrlWinxin(payUrlWinxin);
        }
        if ((onlinePayRecord = this.orgSignupOninePayDao.getLastRecordByPurchaseId(signupPurchaseId, new String[]{"createTime"})) != null) {
            dto.setLastSendTime(onlinePayRecord.getCreateTime());
        }
        return dto;
    }

    @Override
    public PaymentResultDto getPaymentResultDto(Long signupPurchaseId) throws BussinessException, Exception {
        PayResultDto payResultDto = RestUtils.getSignupPayResultDto((Long)signupPurchaseId);
        PaymentResultDto dto = new PaymentResultDto();
        dto.setCourseName(payResultDto.getCourseName());
        dto.setPaymentMethod(payResultDto.getPayTypeStr());
        dto.setPaymentTime(payResultDto.getPayTime());
        dto.setTotalPrice(payResultDto.getTotalPrice());
        dto.setStatus(payResultDto.getStatus());
        dto.setCount(payResultDto.getCount());
        OrgSignupInfo orgSignupInfo = this.orgSignupInfoDao.searchByPurchaseId(signupPurchaseId, new String[0]);
        dto.setStudentMobile(orgSignupInfo.getMobile());
        dto.setStudentName(orgSignupInfo.getStudentName());
        return dto;
    }

    @Override
    public void updateSignupRemark(Long signupPurchaseId, String remark) {
        OrgSignupInfo orgSignupInfo = this.orgSignupInfoDao.searchByPurchaseId(signupPurchaseId, new String[0]);
        if (orgSignupInfo != null) {
            orgSignupInfo.setRemark(remark);
            orgSignupInfo.setUpdateTime(orgSignupInfo.getUpdateTime());
            this.orgSignupInfoDao.saveOrUpdateSignupInfo(orgSignupInfo);
        }
    }

    private boolean saveContent(final String MKEY, final byte[] contents) {
        boolean result = (Boolean)this.redisTemplate.execute((RedisCallback)new RedisCallback<Boolean>(){

            public Boolean doInRedis(RedisConnection connection) throws DataAccessException {
                boolean result = connection.setNX(MKEY.getBytes(), contents);
                connection.expire(MKEY.getBytes(), 600L);
                return result;
            }
        });
        return result;
    }

    private byte[] getContent(final String MKEY) {
        byte[] result = (byte[])this.redisTemplate.execute((RedisCallback)new RedisCallback<byte[]>(){

            public byte[] doInRedis(RedisConnection connection) throws DataAccessException {
                return connection.get(MKEY.getBytes());
            }
        });
        return result;
    }
}

