/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.sal.signup.dto.response;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import com.baijia.tianxiao.sal.signup.dto.SignupFeeItemDto;

import lombok.Data;

import com.baijia.tianxiao.constants.signup.PayResult;
import com.baijia.tianxiao.constants.signup.PayType;
import com.baijia.tianxiao.constants.signup.SplitCourseResult;
import com.baijia.tianxiao.dal.signup.constant.SignupStatus;
import com.baijia.tianxiao.dal.signup.constant.SignupType;
import com.baijia.tianxiao.sal.signup.constants.AppPayType;
import com.baijia.tianxiao.sal.signup.dto.SignupCourseInfoDto;

/**
 * @author cxm
 * @version 1.0
 * @title OrgSingupInfoDto
 * @desc TODO
 * @date 2015年9月8日
 */
@Data
public class OrgSingupInfoDto implements Serializable {
    private static final long serialVersionUID = -7745255487539982963L;
    // 报名ID
    private Long id;

    private String studentName;

    private String studentMobile;

    private Long studentId;

    private Double totalPrice;

    private String chinesePrice;

    private Date signUpTime;

    private Date payTime;

    /**
     * 经办人
     */
    private String operator;

    private int payType;

    private String payTypeStr;

    private int payResult = 1;

    private String payResultStr;

    private Long tradeNo;

    private Long signupPurchaseId;

    private Long orgId;

    private String orgName;

    private List<SignupCourseInfoDto> courseInfos = new ArrayList<SignupCourseInfoDto>();

    private List<SignupFeeItemDto> feeItemDtos = new ArrayList<SignupFeeItemDto>();

    private String remark;

    private Integer signupType;

    private String signupTypeStr;

    private String orgLogoUrl;

    // 微信支付码URL
    private String payUrlWinxin;

    private Date lastSendTime;

    // 支付状态1已完成，2待收款，3待报名
    private Integer status;
    
    private Integer poundage;

    private Integer sourceType;

    private String cascadeIdStr;//经办人
    public void setStatus(Integer purchaseStatus, Integer splitResult) {

        if (purchaseStatus != PayResult.SUCCESS.getCode()) {
            status = SignupStatus.NOT_PAY.getCode();// 未支付
        } else if (purchaseStatus == PayResult.SUCCESS.getCode() && splitResult < SplitCourseResult.PENDING.getCode()) {
            status = SignupStatus.NOT_SIGN.getCode();// 待报名
        } else if (purchaseStatus == PayResult.SUCCESS.getCode() && splitResult >= SplitCourseResult.PENDING.getCode()) {
            status = SignupStatus.FINISHED.getCode();// 支付已经完成
        }
    }

    private Date createTime;
    private Date updateTime;

    public void setSignupTypeEnum(SignupType signTypeEnum) {
        if (signTypeEnum != null) {
            this.signupType = signTypeEnum.getCode();
            this.signupTypeStr = signTypeEnum.getNote();
        }
    }

    public void setPayTypeEnum(PayType payTypeEnum) {
        if (payTypeEnum != null) {
            this.payType = AppPayType.toAppPayTypeCode(payTypeEnum.getCode());
            this.payTypeStr = payTypeEnum.getNote();
        }
    }

    public void setPayResultEnum(PayResult payResultEnum) {
        if (payResultEnum != null) {
            this.payResult = payResultEnum.getCode();
            this.payResultStr = payResultEnum.getNote();
        }
    }

}
