/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.sal.signup.dto.request;

import java.util.Collection;
import java.util.Date;
import java.util.List;

import lombok.Data;
import lombok.EqualsAndHashCode;

import com.baijia.tianxiao.constants.signup.PayResult;
import com.baijia.tianxiao.constants.signup.SplitCourseResult;
import com.baijia.tianxiao.dal.signup.constant.SignupStatus;
import com.baijia.tianxiao.sal.signup.constants.AppPayType;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.google.common.collect.Lists;

/**
 * @title SingupQueryRequestDto
 * @desc TODO
 * @author cxm
 * @date 2015年9月8日
 * @version 1.0
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class SingupListRequestDto extends PageDto {
	
	private List<Integer> status;
	//支付方式
	private List<Integer> method;
	//订单来源
	private List<Integer> source;
	
    private Long orgId;

    private Long orgNumber;

    private Date startTime;

    private Date endTime;

    /**
     * 查找关键字
     */
    private String searchKey;

    /**
     * 全部0，支付宝1，微信2，POS3，银联4。 这些值和数据库不一致，用于对外提供接口。
     */
    private Integer payType = 0;

    public Collection<Integer> getPayTypeCodes() {
        return AppPayType.getByCode(payType).getPayTypeCodes();
    }

    /**
     * 报名状态：待付款，待报名，已完成，已退费。
     */
    private Integer signupStatus = SignupStatus.ALL.getCode();

    private Long signupPurchaseId;

    private Integer signupType;

    private String mobile;

    private Integer cascadeId;

    private static List<Integer> SPLIT_CODES_FINISHED = Lists.newArrayList(SplitCourseResult.FAIL.getCode(),
        SplitCourseResult.PENDING.getCode(), SplitCourseResult.SUCCESS.getCode());
    private static List<Integer> SPLIT_CODES_NOT_SIGN = Lists.newArrayList(SplitCourseResult.PENDING.getCode(),
        SplitCourseResult.NOT_COMMIT.getCode());
    private static List<Integer> SPLIT_CODES_ALL = Lists.newArrayList(SplitCourseResult.FAIL.getCode(),
        SplitCourseResult.PENDING.getCode(), SplitCourseResult.SUCCESS.getCode(),
        SplitCourseResult.NOT_COMMIT.getCode());
    public Collection<Integer> getSplitCodes() {
        if (this.signupStatus == SignupStatus.FINISHED.getCode()) {
            return SPLIT_CODES_FINISHED;
        } else if (this.signupStatus == SignupStatus.NOT_SIGN.getCode()) {
            return SPLIT_CODES_NOT_SIGN;
        } 
        return SPLIT_CODES_ALL;
    }

    private static List<Integer> PURCHASE_CODES_FINISHED = Lists.newArrayList(PayResult.SUCCESS.getCode());
    private static List<Integer> PURCHASE_CODES_NOT_SIGN = Lists.newArrayList(PayResult.SUCCESS.getCode());
    private static List<Integer> PURCHASE_CODES_NOT_PAY = Lists.newArrayList(PayResult.CANCEL.getCode(),
        PayResult.FAIL.getCode(), PayResult.IN_PROGRESS.getCode());
    private static List<Integer> PURCHASE_CODES_ALL = Lists.newArrayList(PayResult.SUCCESS.getCode(),
        PayResult.CANCEL.getCode(), PayResult.FAIL.getCode(), PayResult.IN_PROGRESS.getCode());

    public Collection<Integer> getPurchaseStatusCodes() {
        if (this.signupStatus == SignupStatus.FINISHED.getCode()) {
            return PURCHASE_CODES_FINISHED;
        } else if (this.signupStatus == SignupStatus.NOT_SIGN.getCode()) {
            return PURCHASE_CODES_NOT_SIGN;
        } else if (this.signupStatus == SignupStatus.NOT_PAY.getCode()) {
            return PURCHASE_CODES_NOT_PAY;
        }
        return PURCHASE_CODES_ALL;
    }
}
