/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.sal.signup.dto;

import com.baijia.tianxiao.sal.organization.finance.dto.SignupRefundResponse;
import com.google.common.collect.Lists;
import lombok.Data;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;

/**
 * @title SignupCourseInfoDto
 * @desc TODO
 * @author cxm
 * @date 2015年9月8日
 * @version 1.0
 */
@Data
public class SignupCourseInfoDto implements Serializable {

    private static final long serialVersionUID = 6811476720391997504L;

    /**
     * 课程id
     */
    private Long orgCourseId;

    /**
     * 课程编号
     */
    private Long orgCourseNumber;

    /**
     * 课程名
     */
    private String orgCourseName;

    /**
     * 如果多个老师
     */
    private Collection<String> teacherNames = Lists.newArrayList();

    private String teacherNameStr;//字符窜形式老师,默认待定,多个逗号分开

    /**
     * 原价
     */
    private Double originPrice;

    /**
     * 支付价格
     */
    private Double payPrice;

    /**
     * 折扣百分数
     */
    private int discount = 100;

    /**
     * 优惠金额
     */
    private double preferential;

    /**
     * 购买课程数量
     */
    private int count;

    private int courseType;

    private double poundage;
    //退款日期和金额
    private List<SignupRefundResponse> signupRefundDto;
    //累计退款金额
    private double totalRefundMoney;
    //实收净额
    private double profit;
    //合计=单价＊数量
    private double totalPrice;
}
