/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.signup.service.Impl;

import com.baijia.tianxiao.consants.UserRole;
import com.baijia.tianxiao.constant.LessonStatus;
import com.baijia.tianxiao.constant.SignStatus;
import com.baijia.tianxiao.constants.UserRoleEnum;
import com.baijia.tianxiao.dal.enums.CourseTypeEnum;
import com.baijia.tianxiao.dal.org.dao.OrgClassLessonDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgLessonSignDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentLessonDao;
import com.baijia.tianxiao.dal.org.po.OrgClassLesson;
import com.baijia.tianxiao.dal.org.po.OrgCourse;
import com.baijia.tianxiao.dal.org.po.OrgCourseConsumeRule;
import com.baijia.tianxiao.dal.org.po.OrgLessonSign;
import com.baijia.tianxiao.dal.org.po.OrgStudent;
import com.baijia.tianxiao.dal.org.po.OrgStudentLesson;
import com.baijia.tianxiao.dal.signup.constant.SignupCourseStatus;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupCourseDao;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupCourseLessonDao;
import com.baijia.tianxiao.dal.signup.po.OrgSignupCourse;
import com.baijia.tianxiao.dal.signup.po.OrgSignupCourseLesson;
import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.enums.SignupErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.exception.ParameterException;
import com.baijia.tianxiao.sal.common.api.AccountApiService;
import com.baijia.tianxiao.sal.common.api.CourseApiService;
import com.baijia.tianxiao.sal.common.api.KexiaoApiService;
import com.baijia.tianxiao.sal.common.dto.kexiao.KexiaoSignupCourseStat;
import com.baijia.tianxiao.sal.common.dto.kexiao.KexiaoStatistics;
import com.baijia.tianxiao.sal.signup.dto.TransferClassOption;
import com.baijia.tianxiao.sal.signup.dto.request.TransferClassRequest;
import com.baijia.tianxiao.sal.signup.dto.request.TransferLessonInfoDto;
import com.baijia.tianxiao.sal.signup.service.TransferClassOptionService;
import com.baijia.tianxiao.util.CollectionHelper;
import com.baijia.tianxiao.util.ListUtil;
import com.baijia.tianxiao.util.NumberUtil;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TransferClassOptionServiceImpl
implements TransferClassOptionService {
    private static final Logger log = LoggerFactory.getLogger(TransferClassOptionServiceImpl.class);
    @Autowired
    private OrgStudentLessonDao studentLessonDao;
    @Autowired
    private OrgClassLessonDao classLessonDao;
    @Autowired
    private OrgStudentDao studentDao;
    @Autowired
    private OrgSignupCourseLessonDao signupCourseLessonDao;
    @Autowired
    private KexiaoApiService kexiaoApiService;
    @Autowired
    private OrgSignupCourseDao signupCourseDao;
    @Autowired
    private OrgCourseDao courseDao;
    @Autowired
    private OrgLessonSignDao orgLessonSignDao;
    @Autowired
    private CourseApiService courseApiService;
    @Autowired
    private AccountApiService accountApi;
    @Autowired
    private OrgLessonSignDao lessonSignDao;

    @Override
    public TransferClassOption getTransferOption(long orgId, long studentId, long classId) {
        TransferClassOption option = new TransferClassOption();
        OrgStudent student = (OrgStudent)this.studentDao.getById((Serializable)Long.valueOf(studentId), new String[]{"userId", "id"});
        if (student == null) {
            throw new ParameterException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u5b66\u5458\u4e0d\u5b58\u5728\u6216");
        }
        TransferClassOption.CourseStat stat = this.getStat(orgId, classId);
        KexiaoStatistics statistics = this.kexiaoApiService.queryKexiaoStatByStudentClass(orgId, student.getUserId().longValue(), classId);
        stat.setTotalNumber(statistics.getBuyNumber());
        stat.setFinishNumber(statistics.getKexiaoNumber());
        stat.setTotalLeftNumber(statistics.getLeftNumber());
        stat.setLeftAmount(statistics.getLeftAmount());
        stat.setLeftNumber(statistics.getBuyNumber() - statistics.getArrangeNormalNumber());
        option.setCourseStat(stat);
        this.fillSignupOrders(option, orgId, student.getUserId(), stat.getCourseId());
        this.fillStudentLessons(option, orgId, student.getUserId(), classId);
        stat.setLessonNumber(option.getLessons().size());
        return option;
    }

    private TransferClassOption.CourseStat getStat(long orgId, long classId) {
        OrgCourse orgCourse = (OrgCourse)this.courseDao.getById((Serializable)Long.valueOf(classId), new String[0]);
        TransferClassOption.CourseStat stat = new TransferClassOption.CourseStat();
        stat.setCourseType(orgCourse.getCourseType());
        stat.setCourseName(orgCourse.getName());
        if (CourseTypeEnum.isOneToOne((Integer)orgCourse.getCourseType())) {
            stat.setCourseId(orgCourse.getParentId());
        } else {
            stat.setCourseId(orgCourse.getId());
        }
        stat.setClassId(orgCourse.getId());
        stat.setChargeUnit(orgCourse.getChargeUnit());
        stat.setChargeMode(orgCourse.getChargeUnit());
        String name = null;
        if (orgCourse.getCascadeId() != null && orgCourse.getCascadeId() >= 0) {
            name = this.accountApi.getAccountName(Long.valueOf(orgId), Long.valueOf(orgCourse.getCascadeId().longValue()));
        }
        if (StringUtils.isBlank(name)) {
            name = "\u672a\u5206\u914d";
        }
        stat.setHeadTeacher(name);
        return stat;
    }

    private void fillSignupOrders(TransferClassOption option, long orgId, long userId, long courseId) {
        List signupCourseList = this.signupCourseDao.getByCourseIdAndStudentId(Long.valueOf(orgId), Long.valueOf(userId), Long.valueOf(courseId), (Collection)SignupCourseStatus.PAY_SUCCESS, new String[0]);
        Map signupCourseMap = CollectionHelper.toIdMap((Collection)signupCourseList);
        Map courseStatMap = this.kexiaoApiService.queryKexiaoStatBySignUpCourseIds((Collection)signupCourseList);
        Set keySet = courseStatMap.keySet();
        for (Long id : keySet) {
            KexiaoSignupCourseStat stat = (KexiaoSignupCourseStat)courseStatMap.get(id);
            long orderLeftNumber = stat.getBuyNumber() - stat.getArrangeNormalNumber();
            long orderLeftAmount = stat.getBuyAmount() - stat.getArrangeNormalAmount();
            if (orderLeftNumber <= 0L) continue;
            OrgSignupCourse signupCourse = (OrgSignupCourse)signupCourseMap.get(id);
            option.addSignupCourse(stat.getPurchaseId(), orderLeftNumber, signupCourse.getCreateTime(), orderLeftAmount);
        }
    }

    private void fillStudentLessons(TransferClassOption option, long orgId, long userId, long classId) {
        List lessons = this.studentLessonDao.getByUserIdAndClassId(Long.valueOf(orgId), userId, classId, Integer.valueOf(LessonStatus.UN_START.getStatus()), new String[0]);
        if (lessons == null || lessons.isEmpty()) {
            return;
        }
        List lessonIds = ListUtil.toKeyList((Collection)lessons, (String)"lessonId", OrgStudentLesson.class);
        Map signupCourseLessonMap = this.signupCourseLessonDao.selectLessonInfoMap(Long.valueOf(orgId), (Collection)lessonIds, Arrays.asList(userId));
        List classLessonList = this.classLessonDao.getByIds((Collection)lessonIds, new String[0]);
        Map classLessonMap = CollectionHelper.toIdMap((Collection)classLessonList);
        List lessonSigns = this.lessonSignDao.getStudentSign(Long.valueOf(orgId), Long.valueOf(userId), Integer.valueOf(UserRole.STUDENT.getRole()), (Collection)lessonIds, new String[0]);
        Map signMap = CollectionHelper.toKeyMap((Collection)lessonSigns, (String)"lessonId");
        final HashMap<Long, Integer> sortMap = new HashMap<Long, Integer>();
        for (OrgStudentLesson stuLesson : lessons) {
            OrgClassLesson classLesson = (OrgClassLesson)classLessonMap.get(stuLesson.getLessonId());
            if (classLesson == null) {
                throw new ParameterException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u8bfe\u8282\u4e0d\u5b58\u5728");
            }
            OrgLessonSign sign = (OrgLessonSign)signMap.get(stuLesson.getLessonId());
            if (sign != null && sign.getStatus() != 0) {
                log.info("[TransferClass] OrgLessonSign={}", (Object)sign);
                continue;
            }
            sortMap.put(stuLesson.getLessonId(), classLesson.getNumber());
            OrgSignupCourseLesson signupCourseLesson = (OrgSignupCourseLesson)signupCourseLessonMap.get(stuLesson.getUserId() + "_" + stuLesson.getLessonId());
            if (signupCourseLesson == null) continue;
            option.addStudentLesson(stuLesson.getId(), signupCourseLesson.getAmount(), stuLesson.getLessonType(), classLesson);
        }
        if (option.getLessons() != null && option.getLessons().size() > 0) {
            Collections.sort(option.getLessons(), new Comparator<TransferClassOption.StudentLesson>(){

                @Override
                public int compare(TransferClassOption.StudentLesson o1, TransferClassOption.StudentLesson o2) {
                    return (Integer)sortMap.get(o1.getLessonId()) - (Integer)sortMap.get(o2.getLessonId());
                }
            });
        }
    }

    @Override
    public boolean checkTransferParam(TransferClassRequest request) {
        if (request.getTransferLessons() == null || request.getTransferLessons().size() < 1) {
            return true;
        }
        OrgStudent student = (OrgStudent)this.studentDao.getById((Serializable)request.getStudentId(), new String[]{"userId", "id"});
        if (student == null) {
            throw new ParameterException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u5b66\u5458\u4e0d\u5b58\u5728\u6216");
        }
        long userId = student.getUserId();
        HashSet<Long> classLessonIds = new HashSet<Long>();
        HashSet<Long> purchaseIds = new HashSet<Long>();
        for (TransferLessonInfoDto req : request.getTransferLessons()) {
            if (req.getLessonId() != null && req.getLessonId() > 0L) {
                classLessonIds.add(req.getLessonId());
            }
            if (req.getSignupPurchaseId() == null || req.getSignupPurchaseId() <= 0L) continue;
            purchaseIds.add(req.getSignupPurchaseId());
        }
        if (!purchaseIds.isEmpty()) {
            List signupCourseList = this.signupCourseDao.listByPurchaseIds(purchaseIds, request.getClassId(), new String[0]);
            Map purchaseIdMap = CollectionHelper.toKeyMap((Collection)signupCourseList, (String)"signupPurchaseId");
            Map courseStatMap = this.kexiaoApiService.queryKexiaoStatBySignUpCourseIds((Collection)signupCourseList);
            for (TransferLessonInfoDto req : request.getTransferLessons()) {
                OrgSignupCourse signupCourse = (OrgSignupCourse)purchaseIdMap.get(req.getSignupPurchaseId());
                if (signupCourse == null) continue;
                KexiaoSignupCourseStat stat = (KexiaoSignupCourseStat)courseStatMap.get(signupCourse.getId());
                this.checkSignupCourse(req, stat);
            }
        }
        if (!classLessonIds.isEmpty()) {
            List studentLessons = this.studentLessonDao.getByLessonIdsAndUserIds(classLessonIds, Arrays.asList(userId), null, new String[0]);
            for (OrgStudentLesson stuLesson : studentLessons) {
                this.checkStudentLesson(stuLesson);
            }
            this.checkLessonSignIn(request.getOrgId(), userId, classLessonIds);
            this.checkoutKexiaoStatus(studentLessons);
        }
        return true;
    }

    @Override
    public void delStudentLessons(long orgId, Collection<Long> lessonIds, Long urserId) {
        if (lessonIds != null && lessonIds.size() > 0) {
            this.studentLessonDao.delStudentFromLesson(Long.valueOf(orgId), lessonIds, urserId);
            this.signupCourseLessonDao.batchDelStuLesson(orgId, Arrays.asList(urserId), lessonIds);
        }
    }

    private void checkSignupCourse(TransferLessonInfoDto req, KexiaoSignupCourseStat stat) {
        if (!SignupCourseStatus.VALIDATE_STATS.contains(stat.getStatus())) {
            throw new BussinessException((UniverseErrorCode)SignupErrorCode.TRANSFER_ORDER_INVALIDATE);
        }
        if (stat.getLeftNumber() < (long)req.getLessonCount().intValue()) {
            throw new BussinessException((UniverseErrorCode)SignupErrorCode.TRANSFER_LEFT_LESSON_NOT_ENOUGH);
        }
        if (stat.getLeftAmount() < NumberUtil.multiply((Number)req.getLessonMoney(), (BigDecimal)NumberUtil.HUNDRED, (int)0).longValue()) {
            throw new BussinessException((UniverseErrorCode)SignupErrorCode.TRANSFER_LEFT_AMOUNT_NOT_ENOUGH);
        }
    }

    private void checkStudentLesson(OrgStudentLesson studentLesson) {
        if (studentLesson == null || studentLesson.getDelStatus() == 1) {
            throw new BussinessException((UniverseErrorCode)SignupErrorCode.TRANSFER_LESSON_DELETED);
        }
    }

    private void checkLessonSignIn(long orgId, Long userId, Collection<Long> lessonIds) {
        List signedLesson = this.orgLessonSignDao.getStudentSign(Long.valueOf(orgId), userId, Integer.valueOf(UserRoleEnum.STUDENT.getCode()), lessonIds, new String[0]);
        for (OrgLessonSign sign : signedLesson) {
            if (!SignStatus.OPERATED_STATUS.contains(sign.getStatus())) continue;
            log.info("[TransferClass] check fail.OrgLessonSign={}", (Object)sign);
            throw new BussinessException((UniverseErrorCode)SignupErrorCode.TRANSFER_LESSON_INVALIDATE);
        }
    }

    private void checkoutKexiaoStatus(List<OrgStudentLesson> lessons) {
        HashSet<Long> classIds = new HashSet<Long>();
        for (OrgStudentLesson lesson : lessons) {
            classIds.add(lesson.getCourseId());
        }
        Map consumeRuleMap = this.courseApiService.getClassRule(classIds);
        HashSet<Long> classLessonIds = new HashSet<Long>();
        for (OrgStudentLesson lesson : lessons) {
            OrgCourseConsumeRule rule = (OrgCourseConsumeRule)consumeRuleMap.get(lesson.getCourseId());
            if (rule != null && rule.getRuleValue() != 0) continue;
            classLessonIds.add(lesson.getLessonId());
        }
        if (!classLessonIds.isEmpty()) {
            List classLessons = this.classLessonDao.getByIds(classLessonIds, new String[0]);
            for (OrgClassLesson classLesson : classLessons) {
                if (classLesson.getStartTime().compareTo(new Date()) >= 0) continue;
                throw new BussinessException((UniverseErrorCode)SignupErrorCode.TRANSFER_LESSON_KEXIAO);
            }
        }
    }
}

