/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.signup.service.Impl;

import com.baijia.tianxiao.consants.DataStatus;
import com.baijia.tianxiao.constant.LessonType;
import com.baijia.tianxiao.constant.TransferClassStatus;
import com.baijia.tianxiao.dal.constant.ChargeUnit;
import com.baijia.tianxiao.dal.finance.dao.TxTransferClassInfoDao;
import com.baijia.tianxiao.dal.finance.dao.TxTransferClassRecordDao;
import com.baijia.tianxiao.dal.finance.po.TxTransferClassInfo;
import com.baijia.tianxiao.dal.finance.po.TxTransferClassRecord;
import com.baijia.tianxiao.dal.org.dao.OrgCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgInfoDao;
import com.baijia.tianxiao.dal.org.dao.TXCascadeCredentialDao;
import com.baijia.tianxiao.dal.org.po.OrgInfo;
import com.baijia.tianxiao.dal.signup.constant.SignupCourseStatus;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupCourseDao;
import com.baijia.tianxiao.dal.signup.po.OrgSignupCourse;
import com.baijia.tianxiao.sal.common.api.KexiaoApiService;
import com.baijia.tianxiao.sal.common.dto.kexiao.KexiaoStatistics;
import com.baijia.tianxiao.sal.signup.constants.SignupRefundType;
import com.baijia.tianxiao.sal.signup.dto.request.TransferClassRequest;
import com.baijia.tianxiao.sal.signup.dto.request.TransferLessonInfoDto;
import com.baijia.tianxiao.sal.signup.dto.response.OrgSingupInfoDto;
import com.baijia.tianxiao.sal.signup.dto.response.TransferClassListDto;
import com.baijia.tianxiao.sal.signup.dto.response.TransferRefundListDto;
import com.baijia.tianxiao.sal.signup.service.TransferClassInfoService;
import com.baijia.tianxiao.util.BaseUtils;
import com.baijia.tianxiao.util.GenericsUtils;
import com.baijia.tianxiao.util.NumberUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TransferClassInfoServiceImpl
implements TransferClassInfoService {
    private static final Logger log = LoggerFactory.getLogger(TransferClassInfoServiceImpl.class);
    @Autowired
    private TxTransferClassInfoDao txTransferClassinfoDao;
    @Autowired
    private TxTransferClassRecordDao txTransferClassRecordDao;
    @Autowired
    private OrgSignupCourseDao orgSignupCourseDao;
    @Autowired
    private OrgCourseDao orgCourseDao;
    @Autowired
    private TXCascadeCredentialDao txCascadeCredentialDao;
    @Autowired
    private OrgInfoDao orgInfoDao;
    @Autowired
    private KexiaoApiService kexiaoApiService;

    @Override
    @Transactional
    public void saveTransferInfo(TransferClassRequest transferClassRequest, OrgSingupInfoDto orgSingupInfoDto, List<TransferLessonInfoDto> transferLessonList) {
        KexiaoStatistics inkexiaoStatistics;
        log.info("saveTransferInfo by number = {},{},{}", new Object[]{transferClassRequest, orgSingupInfoDto, transferLessonList});
        Date now = new Date();
        TxTransferClassInfo txTransferClassInfo = new TxTransferClassInfo();
        Long transferClassNumber = NumberUtil.randomSignupPurchaseId4Excel((Date)new Date());
        txTransferClassInfo.setOrgId(transferClassRequest.getOrgId());
        txTransferClassInfo.setTransferNumber(transferClassNumber);
        txTransferClassInfo.setTransferOutClassId(transferClassRequest.getClassId());
        txTransferClassInfo.setTransferInPurchaseId(orgSingupInfoDto.getSignupPurchaseId());
        txTransferClassInfo.setStudentId(transferClassRequest.getStudentId());
        txTransferClassInfo.setUserId(orgSingupInfoDto.getUserId());
        txTransferClassInfo.setStatus(Integer.valueOf(DataStatus.NORMAL.getValue()));
        txTransferClassInfo.setNeedQuitClass(Integer.valueOf(transferClassRequest.getNeedQuitClass() == null ? 0 : transferClassRequest.getNeedQuitClass()));
        txTransferClassInfo.setCascadeId(transferClassRequest.getCascadeId());
        txTransferClassInfo.setCreateTime(now);
        KexiaoStatistics outkexiaoStatistics = this.kexiaoApiService.queryKexiaoStatByStudentClass(transferClassRequest.getOrgId().longValue(), orgSingupInfoDto.getUserId().longValue(), transferClassRequest.getClassId().longValue());
        if (outkexiaoStatistics != null) {
            txTransferClassInfo.setOutLeftCount(Integer.valueOf((int)outkexiaoStatistics.getLeftNumber()));
            txTransferClassInfo.setOutLeftMoney(Long.valueOf(outkexiaoStatistics.getLeftAmount()));
        }
        if ((inkexiaoStatistics = this.kexiaoApiService.queryKexiaoStatByStudentCourse(transferClassRequest.getOrgId().longValue(), orgSingupInfoDto.getUserId().longValue(), orgSingupInfoDto.getCourseInfos().get(0).getOrgCourseId().longValue())) != null) {
            txTransferClassInfo.setInLeftCount(Integer.valueOf((int)inkexiaoStatistics.getLeftNumber()));
            txTransferClassInfo.setInLeftMoney(Long.valueOf(inkexiaoStatistics.getLeftAmount()));
        }
        log.info("kexiao statis = {},{},{},{}", new Object[]{transferClassRequest.getOrgId(), orgSingupInfoDto.getUserId(), transferClassRequest.getClassId(), outkexiaoStatistics});
        ArrayList transferClassRecordList = Lists.newArrayList();
        Double allRefundMoney = orgSingupInfoDto.getTransferRefundMoney();
        for (TransferLessonInfoDto transferLessonInfoDto : transferLessonList) {
            TxTransferClassRecord txTransferClassRecord = new TxTransferClassRecord();
            txTransferClassRecord.setTransferNumber(transferClassNumber);
            txTransferClassRecord.setTransferOutClassId(transferClassRequest.getClassId());
            txTransferClassRecord.setTransferOutUserId(orgSingupInfoDto.getUserId());
            txTransferClassRecord.setOutPurchaseId(transferLessonInfoDto.getSignupPurchaseId());
            txTransferClassRecord.setInPurchaseId(orgSingupInfoDto.getSignupPurchaseId());
            txTransferClassRecord.setLessonId(transferLessonInfoDto.getLessonId());
            txTransferClassRecord.setChargeUnit(transferLessonInfoDto.getChargeMode());
            if (transferLessonInfoDto.getLessonType().intValue() == LessonType.FREE.getCode()) {
                txTransferClassRecord.setFreeLessonCount(transferLessonInfoDto.getLessonCount());
            } else {
                txTransferClassRecord.setRealLessonCount(transferLessonInfoDto.getLessonCount());
            }
            txTransferClassRecord.setLessonMoney(Integer.valueOf(NumberUtil.multiply((Number)transferLessonInfoDto.getLessonMoney(), (BigDecimal)NumberUtil.HUNDRED, (int)0).intValue()));
            txTransferClassRecord.setRefundType(SignupRefundType.BY_OLD_PURCHASE_CASH.getCode());
            if (allRefundMoney > 0.0) {
                if (allRefundMoney - transferLessonInfoDto.getLessonMoney() > 0.0) {
                    txTransferClassRecord.setRefundMoney(Integer.valueOf(NumberUtil.multiply((Number)transferLessonInfoDto.getLessonMoney(), (BigDecimal)NumberUtil.HUNDRED, (int)0).intValue()));
                } else {
                    txTransferClassRecord.setRefundMoney(Integer.valueOf(NumberUtil.multiply((Number)allRefundMoney, (BigDecimal)NumberUtil.HUNDRED, (int)0).intValue()));
                }
                allRefundMoney = allRefundMoney - transferLessonInfoDto.getLessonMoney();
            } else {
                txTransferClassRecord.setRefundMoney(Integer.valueOf(0));
            }
            txTransferClassRecord.setStatus(Integer.valueOf(DataStatus.NORMAL.getValue()));
            txTransferClassRecord.setCreateTime(now);
            txTransferClassRecord.setUpdateTime(now);
            txTransferClassInfo.setChargeUnit(transferLessonInfoDto.getChargeMode());
            log.debug("transfer calss record temp={},{}", (Object)txTransferClassRecord, (Object)txTransferClassRecord.getTransferLessonCount());
            txTransferClassInfo.setLessonCount(Integer.valueOf(txTransferClassInfo.getLessonCount() + txTransferClassRecord.getTransferLessonCount()));
            txTransferClassInfo.setLessonMoney(Long.valueOf(txTransferClassInfo.getLessonMoney() + (long)txTransferClassRecord.getLessonMoney().intValue()));
            transferClassRecordList.add(txTransferClassRecord);
            this.orgSignupCourseDao.resyncLesson(transferLessonInfoDto.getSignupPurchaseId(), transferClassRequest.getClassId(), txTransferClassInfo.getUserId());
        }
        txTransferClassInfo.setOutLeftCount(Integer.valueOf(txTransferClassInfo.getOutLeftCount() - txTransferClassInfo.getLessonCount() < 0 ? 0 : txTransferClassInfo.getOutLeftCount() - txTransferClassInfo.getLessonCount()));
        txTransferClassInfo.setOutLeftMoney(Long.valueOf(txTransferClassInfo.getOutLeftMoney() - txTransferClassInfo.getLessonMoney() < 0L ? 0L : txTransferClassInfo.getOutLeftMoney() - txTransferClassInfo.getLessonMoney()));
        txTransferClassInfo.setInLeftCount(Integer.valueOf(txTransferClassInfo.getInLeftCount() + orgSingupInfoDto.getCourseInfos().get(0).getLessonCount()));
        txTransferClassInfo.setInLeftMoney(Long.valueOf(txTransferClassInfo.getInLeftMoney() + (long)NumberUtil.multiply((Number)orgSingupInfoDto.getCourseInfos().get(0).getTotalPrice(), (BigDecimal)NumberUtil.HUNDRED, (int)0).intValue()));
        log.debug("Transfer class info = {}", (Object)txTransferClassInfo);
        this.txTransferClassinfoDao.save((Object)txTransferClassInfo, new String[0]);
        log.debug("Transfer class record = {}", (Object)transferClassRecordList);
        this.txTransferClassRecordDao.saveAll((List)transferClassRecordList, new String[0]);
    }

    @Override
    public List<TransferClassListDto> listTransferInfo(Long orgId, Long outSignupPurchaseId, Long classId) {
        log.info("listTransferInfo by number = {},{},{}", new Object[]{orgId, outSignupPurchaseId, classId});
        List classRecords = this.txTransferClassRecordDao.groupByTransferNumber(outSignupPurchaseId, classId);
        log.info("listTransferInfo by number:{} ", (Object)classRecords);
        if (CollectionUtils.isEmpty((Collection)classRecords)) {
            return GenericsUtils.emptyList();
        }
        Set transferClassIds = BaseUtils.getPropertiesList((List)classRecords, (String)"transferNumber");
        List transferClassInfos = this.txTransferClassinfoDao.listByTransferNumber(transferClassIds);
        Map txTransferClassInfoMap = BaseUtils.listToMap((List)transferClassInfos, (String)"transferNumber");
        log.debug("listTransferInfo by number={}", (Object)txTransferClassInfoMap);
        ArrayList inSignupPurchaseIds = Lists.newArrayList();
        ArrayList operatorCascadeIds = Lists.newArrayList();
        ArrayList result = Lists.newArrayList();
        for (TxTransferClassRecord transferClassRecord : classRecords) {
            TransferClassListDto dto = new TransferClassListDto();
            dto.setTransferClassNumber(transferClassRecord.getTransferNumber());
            TxTransferClassInfo txTransferClassInfo = (TxTransferClassInfo)txTransferClassInfoMap.get((long)transferClassRecord.getTransferNumber());
            log.info("TxTransferClassRecord is:{} and TxTransferClassInfo is:{} ", (Object)transferClassRecord, (Object)txTransferClassInfo);
            if (txTransferClassInfo == null) continue;
            dto.setChargeUnit(ChargeUnit.isByTime((int)transferClassRecord.getChargeUnit()) ? ChargeUnit.BY_MINUTE.getCode() : transferClassRecord.getChargeUnit().intValue());
            dto.setLessonCount(transferClassRecord.getTransferLessonCount().longValue());
            dto.setLessonMoney(transferClassRecord.getLessonMoney().doubleValue() / 100.0);
            dto.setLeftCount(txTransferClassInfo.getOutLeftCount());
            dto.setLeftMoney(NumberUtil.get2Double((double)(txTransferClassInfo.getOutLeftMoney().doubleValue() / 100.0)));
            dto.setOutSignupPurchaseId(outSignupPurchaseId);
            dto.setInSignupPurchaseId(txTransferClassInfo.getTransferInPurchaseId());
            dto.setCreateTime(txTransferClassInfo.getCreateTime());
            dto.setOperatorCascadeId(txTransferClassInfo.getCascadeId().longValue());
            operatorCascadeIds.add(txTransferClassInfo.getCascadeId());
            inSignupPurchaseIds.add(txTransferClassInfo.getTransferInPurchaseId());
            result.add(dto);
        }
        Map<Long, String> transferInClassName = this.mapTransferInclassNames(inSignupPurchaseIds);
        Map txCascadCredentialListByCascdeIds = this.txCascadeCredentialDao.getTxCascadCredentialListByCascdeIds((Collection)operatorCascadeIds);
        if (operatorCascadeIds.contains(0)) {
            OrgInfo orginfo = this.orgInfoDao.getOrgInfo(Integer.valueOf(orgId.intValue()), new String[0]);
            txCascadCredentialListByCascdeIds.put(0L, orginfo.getContacts());
        }
        for (TransferClassListDto dto : result) {
            dto.setTransferInClassName(transferInClassName.get(dto.getInSignupPurchaseId()));
            dto.setOperator((String)txCascadCredentialListByCascdeIds.get((long)dto.getOperatorCascadeId()));
        }
        return result;
    }

    private Map<Long, String> mapTransferInclassNames(List<Long> inSignupPurchaseIds) {
        List loadByPurchaseIds = this.orgSignupCourseDao.loadByPurchaseIds(inSignupPurchaseIds, new String[]{"orgCourseId", "signupPurchaseId"});
        log.info("loadByPurchaseIds is:{} ", (Object)loadByPurchaseIds);
        HashMap orgCourseIdToPurchaseId = Maps.newHashMap();
        for (OrgSignupCourse osc : loadByPurchaseIds) {
            orgCourseIdToPurchaseId.put(osc.getSignupPurchaseId(), osc.getOrgCourseId());
        }
        log.info("orgCourseIdToPurchaseId is:{} ", (Object)orgCourseIdToPurchaseId);
        Map courseNameMap = this.orgCourseDao.getCourseNameMap((Collection)BaseUtils.getListFilter((List)loadByPurchaseIds, (String)"orgCourseId"));
        log.info("courseNameMap is:{} ", (Object)courseNameMap);
        HashMap newCourseNameMap = Maps.newHashMap();
        for (Map.Entry entry : orgCourseIdToPurchaseId.entrySet()) {
            newCourseNameMap.put(entry.getKey(), courseNameMap.get(entry.getValue()));
        }
        return newCourseNameMap;
    }

    @Override
    public List<TransferRefundListDto> listTransferRefund(Long inSignupPurchaseId) {
        log.info("listTransferRefund by number = {}", (Object)inSignupPurchaseId);
        List recordList = this.txTransferClassRecordDao.listByInPurchaseId(inSignupPurchaseId);
        if (CollectionUtils.isEmpty((Collection)recordList)) {
            return Collections.EMPTY_LIST;
        }
        ArrayList result = Lists.newArrayList();
        for (TxTransferClassRecord transferClassRecord : recordList) {
            TransferRefundListDto refundListDto = new TransferRefundListDto();
            refundListDto.setTransferInfoNumber(transferClassRecord.getTransferNumber());
            refundListDto.setTransferRecordId(transferClassRecord.getId());
            refundListDto.setOutSignuppurchaseId(transferClassRecord.getOutPurchaseId());
            refundListDto.setInSignupPurchaseId(transferClassRecord.getInPurchaseId());
            refundListDto.setRefundMoney(transferClassRecord.getRefundMoney());
            result.add(refundListDto);
        }
        return result;
    }

    @Override
    public void updateReundType(Long transferClassNumber, Integer refundType) {
        log.info("updateReundType by number = {},{}", (Object)transferClassNumber, (Object)refundType);
        this.txTransferClassRecordDao.updateRefundType(transferClassNumber, refundType);
    }

    @Override
    public void cancelTransferClassByPurchase(Long inSignupPurchaseId) {
        log.info("cancelTransferClassByPurchase by number = {}", (Object)inSignupPurchaseId);
        List recordList = this.txTransferClassRecordDao.listByInPurchaseId(inSignupPurchaseId);
        if (CollectionUtils.isNotEmpty((Collection)recordList)) {
            this.cancelTransferClassByNumber(((TxTransferClassRecord)recordList.get(0)).getTransferNumber());
        }
    }

    @Override
    public void confirmTransferClass(Long inSignupPurchaseId) {
        log.info("confirmTransferClass by number = {}", (Object)inSignupPurchaseId);
        TxTransferClassInfo txTransferClassInfo = this.txTransferClassinfoDao.getByInPurchaseId(inSignupPurchaseId);
        if (txTransferClassInfo != null) {
            log.info("confirmTransferClass by number 1 = {}", (Object)inSignupPurchaseId);
            this.txTransferClassinfoDao.updateStatus(txTransferClassInfo.getTransferNumber(), TransferClassStatus.SUCCESS.getCode());
            this.txTransferClassRecordDao.updateStatus(txTransferClassInfo.getTransferNumber(), TransferClassStatus.SUCCESS.getCode());
            List recordList = this.txTransferClassRecordDao.listByTransferNumber(txTransferClassInfo.getTransferNumber());
            if (CollectionUtils.isNotEmpty((Collection)recordList)) {
                for (TxTransferClassRecord record : recordList) {
                    if (txTransferClassInfo.getNeedQuitClass() == 1) {
                        this.orgSignupCourseDao.updateStatusByPurchaseId(record.getOutPurchaseId(), record.getTransferOutClassId(), txTransferClassInfo.getUserId(), Integer.valueOf(SignupCourseStatus.QUIT_CLASS.getCode()));
                        continue;
                    }
                    this.orgSignupCourseDao.resyncLesson(record.getOutPurchaseId(), record.getTransferOutClassId(), txTransferClassInfo.getUserId());
                }
            }
        }
    }

    @Override
    public void cancelTransferClassByNumber(Long transferClassNumber) {
        log.info("cancel transfer class by number = {}", (Object)transferClassNumber);
        this.txTransferClassinfoDao.updateStatus(transferClassNumber, TransferClassStatus.CANCEL.getCode());
        this.txTransferClassRecordDao.updateStatus(transferClassNumber, TransferClassStatus.CANCEL.getCode());
    }

    @Override
    public Integer transferLessonCount(Long userId, Long classId) {
        List classRecords = this.txTransferClassRecordDao.listByUserClass(userId, classId, null, TransferClassStatus.SUCCESS.getCode());
        Integer result = 0;
        if (CollectionUtils.isEmpty((Collection)classRecords)) {
            return result;
        }
        for (TxTransferClassRecord dto : classRecords) {
            result = result + dto.getRealLessonCount();
        }
        return result;
    }
}

