/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.signup.service.Impl;

import com.baijia.commons.lang.utils.date.DateUtils;
import com.baijia.tianxiao.consants.DataStatus;
import com.baijia.tianxiao.consants.UserRole;
import com.baijia.tianxiao.constant.StudentFiannceOpType;
import com.baijia.tianxiao.constants.PayStatus;
import com.baijia.tianxiao.constants.org.BizConf;
import com.baijia.tianxiao.constants.signup.PayResult;
import com.baijia.tianxiao.constants.signup.PayType;
import com.baijia.tianxiao.constants.signup.SplitCourseResult;
import com.baijia.tianxiao.constants.sms.TxSmsCodeType;
import com.baijia.tianxiao.dal.constant.ChargeMode;
import com.baijia.tianxiao.dal.constant.ChargeType;
import com.baijia.tianxiao.dal.constant.ChargeUnit;
import com.baijia.tianxiao.dal.enums.CourseTypeEnum;
import com.baijia.tianxiao.dal.finance.dao.TxStudentFinanceAccountDao;
import com.baijia.tianxiao.dal.finance.po.TxStudentFinanceAccount;
import com.baijia.tianxiao.dal.org.constant.CampusAccountType;
import com.baijia.tianxiao.dal.org.constant.DeleteStatus;
import com.baijia.tianxiao.dal.org.constant.StudentType;
import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseTeacherDao;
import com.baijia.tianxiao.dal.org.dao.OrgInfoDao;
import com.baijia.tianxiao.dal.org.dao.OrgSinupPurchaseDao;
import com.baijia.tianxiao.dal.org.dao.OrgStorageDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.dao.TXCascadeAccountDao;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.org.po.OrgCourse;
import com.baijia.tianxiao.dal.org.po.OrgCourseTeacher;
import com.baijia.tianxiao.dal.org.po.OrgSinupPurchase;
import com.baijia.tianxiao.dal.org.po.OrgStorage;
import com.baijia.tianxiao.dal.org.po.OrgStudent;
import com.baijia.tianxiao.dal.org.po.TXCascadeAccount;
import com.baijia.tianxiao.dal.signup.constant.SignupCourseStatus;
import com.baijia.tianxiao.dal.signup.constant.SignupStatus;
import com.baijia.tianxiao.dal.signup.constant.SignupType;
import com.baijia.tianxiao.dal.signup.constant.TransferClassOrder;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupCourseDao;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupFeeDao;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupInfoDao;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupOnlinePayDao;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupRefundDao;
import com.baijia.tianxiao.dal.signup.po.OrgSignupCourse;
import com.baijia.tianxiao.dal.signup.po.OrgSignupFee;
import com.baijia.tianxiao.dal.signup.po.OrgSignupInfo;
import com.baijia.tianxiao.dal.signup.po.OrgSignupOnlinePay;
import com.baijia.tianxiao.dal.signup.po.OrgSignupRefund;
import com.baijia.tianxiao.dal.user.dao.TeacherDao;
import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.dto.signup.CreatePurchaseResponseDto;
import com.baijia.tianxiao.dto.signup.PayResultDto;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.enums.RedisKeyEnums;
import com.baijia.tianxiao.enums.SignupErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.image.AvatarUtil;
import com.baijia.tianxiao.sal.common.api.CommonMsgService;
import com.baijia.tianxiao.sal.common.api.RedisDefaultService;
import com.baijia.tianxiao.sal.organization.constant.OrgSinupPurchaseStatus;
import com.baijia.tianxiao.sal.organization.org.service.TxCascadeCredentialService;
import com.baijia.tianxiao.sal.signup.constants.SignupRefundType;
import com.baijia.tianxiao.sal.signup.constants.SignupSourceType;
import com.baijia.tianxiao.sal.signup.constants.TransferClassResult;
import com.baijia.tianxiao.sal.signup.dto.PaymentResultDto;
import com.baijia.tianxiao.sal.signup.dto.SignupCourseInfoDto;
import com.baijia.tianxiao.sal.signup.dto.SignupFeeItemDto;
import com.baijia.tianxiao.sal.signup.dto.request.FillCourseInfoRequestDto;
import com.baijia.tianxiao.sal.signup.dto.request.SingupListRequestDto;
import com.baijia.tianxiao.sal.signup.dto.response.OrgSignupListDto;
import com.baijia.tianxiao.sal.signup.dto.response.OrgSignupStorageResponseDto;
import com.baijia.tianxiao.sal.signup.dto.response.OrgSingupInfoDto;
import com.baijia.tianxiao.sal.signup.dto.response.TransferClassListDto;
import com.baijia.tianxiao.sal.signup.dto.response.TransferClassRecordDto;
import com.baijia.tianxiao.sal.signup.service.OrgSignupStorageService;
import com.baijia.tianxiao.sal.signup.service.SignupService;
import com.baijia.tianxiao.sal.signup.service.TransferClassInfoService;
import com.baijia.tianxiao.sal.student.api.OrgStudentService;
import com.baijia.tianxiao.sal.student.api.OrgStudentTagService;
import com.baijia.tianxiao.sal.student.dto.CommentInfoDto;
import com.baijia.tianxiao.sal.student.dto.StudentInfoDto;
import com.baijia.tianxiao.sal.student.dto.TagInfoDto;
import com.baijia.tianxiao.sal.student.dto.response.OrgStudentAddresponseDto;
import com.baijia.tianxiao.sal.student.dto.response.OrgTagListResopnseDto;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.util.BaseUtils;
import com.baijia.tianxiao.util.DigitUppercaseUtils;
import com.baijia.tianxiao.util.GenericsUtils;
import com.baijia.tianxiao.util.NumberUtil;
import com.baijia.tianxiao.util.SerializeUtil;
import com.baijia.tianxiao.util.ShortUrlUtil;
import com.baijia.tianxiao.util.SmsContentHelper;
import com.baijia.tianxiao.util.bean.LoggerService;
import com.baijia.tianxiao.util.date.DateUtil;
import com.baijia.tianxiao.util.encrypt.MD5Utils;
import com.baijia.tianxiao.util.mobile.MaskUtil;
import com.baijia.tianxiao.util.properties.UrlProperties;
import com.baijia.tianxiao.util.rest.RestUtils;
import com.baijia.tianxiao.util.storage.StorageUtil;
import com.baijia.tianxiao.validation.ParamValidateUtils;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import lombok.NonNull;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.Transformer;
import org.apache.commons.lang.StringUtils;
import org.apache.http.Header;
import org.apache.http.message.BasicHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SignupServiceImpl
implements SignupService {
    private static final Logger log = LoggerFactory.getLogger(SignupServiceImpl.class);
    public static final BigDecimal HUNDRED = new BigDecimal(100);
    @Resource
    private OrgCourseDao orgCourseDao;
    @Resource
    private OrgCourseTeacherDao orgCourseTeacherDao;
    @Resource
    private OrgSignupCourseDao orgSignupCourseDao;
    @Resource
    private OrgSignupInfoDao orgSignupInfoDao;
    @Resource
    private OrgInfoDao orgInfoDao;
    @Resource
    private OrgSinupPurchaseDao orgSinupPurchaseDao;
    @Resource
    private OrgSignupFeeDao orgSignupFeeDao;
    @Resource
    private OrgSignupOnlinePayDao orgSignupOninePayDao;
    @Resource
    private OrgStudentDao orgStudentDao;
    @Autowired(required=true)
    private OrgStudentService orgStudentService;
    @Resource
    private OrgAccountDao orgAccountDao;
    @Resource
    private TeacherDao teacherDao;
    @Resource
    private TXCascadeAccountDao txCascadeAccountDao;
    @Resource
    private TxCascadeCredentialService txCascadeCredentialService;
    @Resource
    private OrgStudentTagService orgStudentTagService;
    @Resource
    private TxStudentFinanceAccountDao txStudentFinanceAccountDao;
    @Resource
    private TransferClassInfoService transferClassInfoService;
    @Resource
    private OrgSignupRefundDao orgSignupRefundDao;
    @Resource
    private OrgSignupStorageService orgSignupStorageService;
    @Resource
    private CommonMsgService commonMsgService;
    @Resource
    private RedisDefaultService redisDefaultService;
    @Autowired
    private OrgStorageDao orgStorageDao;

    @Override
    public OrgSignupListDto pcSignupList(SingupListRequestDto requestDto) {
        TXCascadeAccount txCascadeAccount;
        Integer cascadeId = requestDto.getCascadeId();
        if (cascadeId != null && (txCascadeAccount = (TXCascadeAccount)this.txCascadeAccountDao.getById((Serializable)cascadeId, new String[0])) != null && txCascadeAccount.getAccountType() != CampusAccountType.STAFF.getCode()) {
            cascadeId = null;
            requestDto.setCascadeId(null);
        }
        OrgSignupListDto orgSignupListDto = new OrgSignupListDto();
        orgSignupListDto.setList(this.getSignupList(requestDto));
        requestDto.setSignupStatus(SignupStatus.NOT_PAY.getCode());
        orgSignupListDto.setNotPayNum(this.orgSignupInfoDao.countByPurchaseStatus(requestDto.getOrgId(), requestDto.getPurchaseStatusCodes(), requestDto.getSplitCodes(), cascadeId));
        orgSignupListDto.setNotPayPrice(this.orgSignupInfoDao.sumByPurchaseStatus(requestDto.getOrgId(), requestDto.getPurchaseStatusCodes(), requestDto.getSplitCodes(), cascadeId, false).doubleValue() / 100.0);
        requestDto.setSignupStatus(SignupStatus.NOT_SIGN.getCode());
        orgSignupListDto.setNotSignNum(this.orgSignupInfoDao.countByPurchaseStatus(requestDto.getOrgId(), requestDto.getPurchaseStatusCodes(), requestDto.getSplitCodes(), cascadeId));
        orgSignupListDto.setNotSignPrice(this.orgSignupInfoDao.sumByPurchaseStatus(requestDto.getOrgId(), requestDto.getPurchaseStatusCodes(), requestDto.getSplitCodes(), cascadeId, false).doubleValue() / 100.0);
        return orgSignupListDto;
    }

    @Override
    public List<OrgSingupInfoDto> getSignupList(SingupListRequestDto requestDto) {
        List result;
        List courseIds;
        Preconditions.checkNotNull((Object)requestDto.getOrgId(), (Object)"orgId may not be null");
        requestDto.setOrgNumber(this.getOrgNumber(requestDto.getOrgId()));
        Preconditions.checkNotNull((Object)requestDto.getOrgNumber(), (Object)"orgNumber may not be null");
        String key = requestDto.getSearchKey();
        ArrayList purchaseIds = Lists.newArrayList();
        if (StringUtils.isNotBlank((String)key) && CollectionUtils.isNotEmpty((Collection)(courseIds = this.orgCourseDao.getCourseIdsByOrgNumberAndCourseName(requestDto.getOrgNumber(), key, null, CourseTypeEnum.IS_COURSE_TRUE.getCode(), null, null)))) {
            purchaseIds.addAll(this.orgSignupCourseDao.searchPurchaseIdByCourseId((Collection)courseIds, requestDto.getStartTime(), requestDto.getEndTime()));
        }
        if (CollectionUtils.isEmpty((Collection)(result = this.orgSignupInfoDao.getOrgSignupInfo(requestDto.getMethod(), requestDto.getSource(), requestDto.getOrgId(), (Collection)purchaseIds, requestDto.getPurchaseStatusCodes(), requestDto.getSplitCodes(), requestDto.getPayTypeCodes(), key, requestDto.getStartTime(), requestDto.getEndTime(), requestDto.getCascadeId(), requestDto.getCancelStatus(), requestDto.getTransferClassOrder(), requestDto.getOrderTypeList(), (PageDto)requestDto, new String[0])))) {
            return Collections.emptyList();
        }
        this.loadSignupCourseInfo(result);
        this.loadSignupFeeItem(result);
        boolean isShowMobile = this.txCascadeCredentialService.isShowMobile(requestDto.getOrgId(), requestDto.getCascadeId());
        return this.buildOrgSingupInfoDtos(result, this.orgInfoDao.getOrgShortNameByOrgId(Integer.valueOf(requestDto.getOrgId().intValue())), isShowMobile, requestDto.isDownLoadRequest());
    }

    private List<OrgSingupInfoDto> buildOrgSingupInfoDtos(Collection<OrgSignupInfo> orgSignupInfos, String orgName, boolean isShowMobile, boolean downLoadRequest) {
        ArrayList orgSingupInfoDtos = Lists.newArrayList();
        HashSet courseIds = Sets.newHashSet();
        HashSet signupPurchaseIdes = Sets.newHashSet();
        if (CollectionUtils.isNotEmpty(orgSignupInfos)) {
            Long orgId = 0L;
            for (OrgSignupInfo orgSignupInfo : orgSignupInfos) {
                orgId = orgSignupInfo.getOrgId();
                signupPurchaseIdes.add(orgSignupInfo.getSignupPurchaseId());
                if (!CollectionUtils.isNotEmpty((Collection)orgSignupInfo.getOrgSignupCourses())) continue;
                for (OrgSignupCourse orgSignupCourse : orgSignupInfo.getOrgSignupCourses()) {
                    courseIds.add(orgSignupCourse.getOrgCourseId());
                }
            }
            Map courseMap = this.orgCourseDao.getOrgCourseMap((Collection)courseIds, new String[0]);
            Map<Long, List<String>> courseTeacherNameMap = this.getCourseIdTeacherNamesMap(courseIds);
            Map cascadeMap = this.txCascadeCredentialService.getByTxCasCadeIdWithDelete(orgId);
            Map<String, Long> signupRefundMoney = this.mapRefundMoneyWithPurchaseIds(signupPurchaseIdes);
            for (OrgSignupInfo orgSignupInfo : orgSignupInfos) {
                OrgSingupInfoDto dto = this.buildOrgSignupInfoDto(orgSignupInfo, orgName, courseMap, courseTeacherNameMap, cascadeMap, isShowMobile, signupRefundMoney, downLoadRequest);
                orgSingupInfoDtos.add(dto);
            }
        }
        return orgSingupInfoDtos;
    }

    private Map<String, Long> mapRefundMoneyWithPurchaseIds(Set<Long> signupPurchaseIdes) {
        if (GenericsUtils.isNullOrEmpty(signupPurchaseIdes)) {
            return GenericsUtils.emptyMap();
        }
        List byPurcahseIds = this.orgSignupRefundDao.getByPurcahseIds(signupPurchaseIdes);
        log.debug("Signup refund  purchase ={},{}", signupPurchaseIdes, (Object)byPurcahseIds);
        HashMap refundMoneyMap = Maps.newHashMap();
        for (OrgSignupRefund osr : byPurcahseIds) {
            String key = osr.getSignupPurchaseId() + "_" + osr.getCourseId();
            Long refundMoney = (Long)refundMoneyMap.get(key);
            if (refundMoney == null) {
                refundMoney = 0L;
            }
            refundMoneyMap.put(key, refundMoney + osr.getRefundPrice());
        }
        return refundMoneyMap;
    }

    private OrgSingupInfoDto buildOrgSignupInfoDto(OrgSignupInfo orgSignupInfo, String orgName, Map<Long, OrgCourse> courseMap, Map<Long, List<String>> courseTeacherNameMap, Map<Long, String> cascadeMap, boolean isShowMobile, Map<String, Long> signupRefundMoney, boolean downLoadRequest) {
        log.debug("Refund money map = {}", signupRefundMoney);
        OrgSingupInfoDto dto = new OrgSingupInfoDto();
        Long purchaseId = orgSignupInfo.getSignupPurchaseId();
        if (orgSignupInfo != null) {
            dto.setTotalPrice(orgSignupInfo.getTotalPrices().doubleValue() / 100.0);
            this.fillPayType(dto, orgSignupInfo);
            this.fillTransferQuitClass(dto, orgSignupInfo, downLoadRequest);
            this.fillTransferClassOrder(dto, orgSignupInfo);
            dto.setStudentPayPrice(orgSignupInfo.getStudentPayPrice().doubleValue() / 100.0);
            dto.setRealTotalMoney(dto.getTotalPrice() + dto.getStudentPayPrice() + dto.getTransferClassMoney() - dto.getTransferRefundMoney());
            dto.setOrgId(orgSignupInfo.getOrgId());
            dto.setOrgName(orgName);
            if (dto.getSignupType().intValue() == SignupType.FRONTED.getCode()) {
                dto.setSignUpTime(orgSignupInfo.getCreateTime());
            } else {
                dto.setSignUpTime(orgSignupInfo.getUpdateTime());
            }
            if (orgSignupInfo.getPurchaseStatus() == 1) {
                dto.setPayTime(orgSignupInfo.getPayTime());
                String cascadeIdStr = cascadeMap.get(orgSignupInfo.getCascadeId() == null ? 0L : orgSignupInfo.getCascadeId().longValue());
                dto.setCascadeIdStr(cascadeIdStr == null ? "" : cascadeIdStr);
            } else {
                dto.setCascadeIdStr("--");
            }
            if (orgSignupInfo.getStudentPayPrice() > 0L) {
                if (orgSignupInfo.getTotalPrices() > 0L) {
                    dto.setPayTypeStr("\u5b66\u5458\u4f59\u989d\uffe5" + NumberUtil.get2FromDouble((double)dto.getStudentPayPrice()) + "+" + dto.getPayTypeStr() + "\uffe5" + NumberUtil.get2FromDouble((double)dto.getTotalPrice()));
                } else {
                    dto.setPayTypeStr("\u5b66\u751f\u4f59\u989d\u652f\u4ed8");
                }
            }
            log.info("orgSignupInfo is:{} ", (Object)orgSignupInfo);
            Long transferClassDeduction = null;
            Long refundMoney = null;
            int signupStatus = 0;
            if (dto.getTransferClassOrder() == TransferClassOrder.TRANSFER_ORDER.getCode()) {
                dto.setTransferRefundType(orgSignupInfo.getTransferRefundType());
                dto.setTransferClassMoney(orgSignupInfo.getTransferClassMoney().doubleValue() / 100.0);
                dto.setTransferRefundMoney(orgSignupInfo.getTransferRefundMoney().doubleValue() / 100.0);
                transferClassDeduction = orgSignupInfo.getTransferClassMoney();
                if (dto.getTransferRefundMoney() > 0.0) {
                    log.info("need refund ---:{} ", (Object)orgSignupInfo.getTransferRefundMoney());
                    refundMoney = orgSignupInfo.getTransferRefundMoney();
                    dto.setTransferType(TransferClassResult.NEED_REFUND.getStatus());
                    dto.setOpType(2);
                    dto.setPaymentType(1);
                    signupStatus = 2;
                    dto.setShowTotalPrice((double)orgSignupInfo.getTransferRefundMoney().longValue() / 100.0);
                    dto.setChinesePrice(DigitUppercaseUtils.digitUppercase((double)((double)orgSignupInfo.getTransferRefundMoney().longValue() / 100.0)));
                } else if (dto.getTotalPrice() + dto.getStudentPayPrice() > 0.0) {
                    log.info("need pay --- ");
                    dto.setTransferType(TransferClassResult.NEED_PAY.getStatus());
                    dto.setOpType(1);
                    signupStatus = 1;
                    dto.setShowTotalPrice((double)(orgSignupInfo.getTotalPrices() + orgSignupInfo.getStudentPayPrice()) / 100.0);
                    dto.setChinesePrice(DigitUppercaseUtils.digitUppercase((double)dto.getShowTotalPrice()));
                } else {
                    dto.setShowTotalPrice(0.0);
                    dto.setTransferType(TransferClassResult.SUCCESS.getStatus());
                    dto.setShowTotalPrice((double)(orgSignupInfo.getTotalPrices() + orgSignupInfo.getStudentPayPrice()) / 100.0);
                    dto.setChinesePrice(DigitUppercaseUtils.digitUppercase((double)dto.getShowTotalPrice()));
                    signupStatus = 3;
                }
                dto.setPurchaseEndTime(DateUtil.getDiffMinute((Date)orgSignupInfo.getCreateTime(), (int)15));
            } else {
                dto.setShowTotalPrice((double)(orgSignupInfo.getTotalPrices() + orgSignupInfo.getStudentPayPrice()) / 100.0);
                dto.setChinesePrice(DigitUppercaseUtils.digitUppercase((double)dto.getShowTotalPrice()));
                dto.setPurchaseEndTime(orgSignupInfo.getCreateTime() == null ? null : DateUtil.getDiffDateTime((Date)orgSignupInfo.getCreateTime(), (int)7));
                dto.setOpType(0);
            }
            if (dto.getPayResult() == PayResult.SUCCESS.getCode()) {
                dto.setOpType(0);
            }
            log.info("signupStatus is:{} ", (Object)signupStatus);
            dto.setSignupPurchaseId(orgSignupInfo.getSignupPurchaseId());
            dto.setPayPurchaseId(orgSignupInfo.getPayPurchaseId() == 0L ? orgSignupInfo.getSignupPurchaseId() : orgSignupInfo.getPayPurchaseId());
            dto.setCreateTime(orgSignupInfo.getCreateTime());
            dto.setUpdateTime(orgSignupInfo.getUpdateTime());
            dto.setCourseInfos(Lists.newArrayList());
            dto.setId(orgSignupInfo.getId());
            if (orgSignupInfo.getStatus() == 1) {
                dto.setStatus(SignupStatus.CANCEL.getCode());
                dto.setOpType(0);
            } else {
                dto.setStatus((int)orgSignupInfo.getPurchaseStatus(), (int)orgSignupInfo.getSplitResult());
            }
            String remark = "\u65e0";
            if (StringUtils.isNotBlank((String)orgSignupInfo.getRemark())) {
                remark = orgSignupInfo.getRemark();
            }
            if (orgSignupInfo.getTradeNo() != null && orgSignupInfo.getTradeNo() != 0L) {
                dto.setTradeNo(orgSignupInfo.getTradeNo().toString());
            } else {
                dto.setTradeNo(orgSignupInfo.getSignupPurchaseId().toString());
            }
            if (CollectionUtils.isNotEmpty((Collection)orgSignupInfo.getHeaders()) && orgSignupInfo.getTotalPrices().doubleValue() > 0.0) {
                String payUrlWinxin = RestUtils.getWeiXinPurchaseUrl((Long)orgSignupInfo.getSignupPurchaseId(), (Long)orgSignupInfo.getOrgId(), (Double)(orgSignupInfo.getTotalPrices().doubleValue() / 100.0), (Collection)orgSignupInfo.getHeaders());
                dto.setPayUrlWinxin(payUrlWinxin);
            }
            dto.setRemark(remark);
            this.fillSignupStudentInfo(dto, orgSignupInfo, isShowMobile);
            dto.setOperator(orgSignupInfo.getOperator());
            if (CollectionUtils.isNotEmpty((Collection)orgSignupInfo.getOrgSignupCourses())) {
                for (OrgSignupCourse orgSignupCourse : orgSignupInfo.getOrgSignupCourses()) {
                    List<TransferClassListDto> transferClassListDtoList;
                    Long courseId = orgSignupCourse.getOrgCourseId();
                    OrgCourse orgCourse = courseMap.get(courseId);
                    if (orgCourse == null) continue;
                    SignupCourseInfoDto courseInfoDto = this.buildOrgSignupCourseDto(orgSignupCourse, orgCourse, courseTeacherNameMap.get(courseId));
                    String refundAmount = SignupServiceImpl.countReallyRefundMoney(refundMoney, signupRefundMoney.get(purchaseId + "_" + courseId));
                    log.debug("orgSignupCourse is:{}  and courseInfoDto is:{} and transferClassDeduction is:{} ", new Object[]{orgSignupCourse, courseInfoDto, transferClassDeduction});
                    log.info("for payPurchaseId:{} and courseId:{} ,refundAmount is:{} ", new Object[]{purchaseId, courseId, refundAmount});
                    courseInfoDto.setRefundAmount(refundAmount);
                    dto.setAllRefundMoney(dto.getAllRefundMoney() + SignupServiceImpl.countReallyRefundMoneyDouble(refundMoney, signupRefundMoney.get(purchaseId + "_" + courseId)));
                    dto.setAllRefundMoneyStr(SignupServiceImpl.createNumShowStr(dto.getAllRefundMoney()));
                    log.debug("courseInfoDto.totalPrice is:{} ", (Object)courseInfoDto.getTotalPrice());
                    String amountStr = String.valueOf(courseInfoDto.getTotalPrice());
                    log.debug("amountStr is:{} and  signupStatus is:{} ", (Object)amountStr, (Object)signupStatus);
                    if (signupStatus == 0) {
                        courseInfoDto.setAmount(SignupServiceImpl.formatNumberStr(amountStr));
                    } else if (signupStatus == 1) {
                        courseInfoDto.setAmount(SignupServiceImpl.formatNumberStr(SignupServiceImpl.floatingPointCalc(amountStr, (double)transferClassDeduction.longValue() / 100.0, 2)));
                    } else if (signupStatus == 2) {
                        courseInfoDto.setAmount("-" + SignupServiceImpl.formatNumberStr(SignupServiceImpl.floatingPointCalc((double)transferClassDeduction.longValue() / 100.0, amountStr, 2)));
                    } else if (signupStatus == 3) {
                        courseInfoDto.setAmount(SignupServiceImpl.formatNumberStr("0.00"));
                    }
                    courseInfoDto.setRealAmount(SignupServiceImpl.formatNumberStr(SignupServiceImpl.floatingPointCalc((double)orgSignupCourse.getStudentPayPrice().longValue() / 100.0, (double)orgSignupCourse.getPayPrice().longValue() / 100.0, 1)));
                    dto.setPreferentialPrice(dto.getPreferentialPrice() + courseInfoDto.getPreferential());
                    if (orgSignupCourse.getStatus().intValue() == SignupCourseStatus.QUIT_PURCHASE.getCode() || orgSignupCourse.getStatus().intValue() == SignupCourseStatus.QUIT_CLASS.getCode()) {
                        dto.setQuitClass(1);
                    }
                    if (dto.getPayResult() == PayStatus.SUCESS.getCode() && courseInfoDto.getStatus().intValue() == SignupCourseStatus.NOT_PAY.getCode()) {
                        courseInfoDto.setStatus(SignupCourseStatus.HAS_PAY.getCode());
                    }
                    if (dto.getTransferClassOrder() == TransferClassOrder.TRANSFER_ORDER.getCode()) {
                        courseInfoDto.setTransferClassDeduction(SignupServiceImpl.createNumShowStr(transferClassDeduction));
                    }
                    if (!downLoadRequest && GenericsUtils.notNullAndEmpty(transferClassListDtoList = this.transferClassInfoService.listTransferInfo(orgSignupInfo.getOrgId(), orgSignupInfo.getSignupPurchaseId(), orgSignupCourse.getClassId()))) {
                        courseInfoDto.setShowTransferStatus(1);
                        courseInfoDto.setTransferClass(1);
                    }
                    dto.getCourseInfos().add(courseInfoDto);
                }
            }
        }
        return dto;
    }

    public static void main(String[] args) {
        String formatNumberStr = SignupServiceImpl.formatNumberStr("5.0");
        LoggerService.info((String)"{}", (Object[])new Object[]{formatNumberStr});
    }

    public static String countReallyRefundMoney(Long refundMoney, Long transferRefundMoney) {
        refundMoney = refundMoney == null ? 0L : refundMoney;
        transferRefundMoney = transferRefundMoney == null ? 0L : transferRefundMoney;
        boolean needPrefix = (int)(refundMoney + transferRefundMoney) < 0;
        Long moneyNumber = !needPrefix ? -1L * (refundMoney + transferRefundMoney) : refundMoney + transferRefundMoney;
        return SignupServiceImpl.createNumShowStr(moneyNumber);
    }

    public static long countReallyRefundMoneyDouble(Long refundMoney, Long transferRefundMoney) {
        refundMoney = refundMoney == null ? 0L : refundMoney;
        transferRefundMoney = transferRefundMoney == null ? 0L : transferRefundMoney;
        boolean needPrefix = (int)(refundMoney + transferRefundMoney) < 0;
        Long moneyNumber = !needPrefix ? -1L * (refundMoney + transferRefundMoney) : refundMoney + transferRefundMoney;
        if (moneyNumber == null) {
            moneyNumber = 0L;
        }
        return moneyNumber;
    }

    private static String floatingPointCalc(Object value1, Object value2, int type) {
        BigDecimal a1 = new BigDecimal(String.valueOf(value1));
        BigDecimal b1 = new BigDecimal(String.valueOf(value2));
        switch (type) {
            case 1: {
                return a1.add(b1).toPlainString();
            }
            case 2: {
                return a1.subtract(b1).toPlainString();
            }
        }
        return a1.add(b1).toPlainString();
    }

    private static String createNumShowStr(Long moneyNumber) {
        if (moneyNumber == null) {
            moneyNumber = 0L;
        }
        DecimalFormat df = new DecimalFormat("0.00");
        return (moneyNumber < 0L ? "-" : "") + "\uffe5" + df.format((double)Math.abs(moneyNumber) / 100.0);
    }

    private static String formatNumberStr(String numStr) {
        log.info("numStr is:{}", (Object)numStr);
        DecimalFormat df = new DecimalFormat("0.00");
        return "\uffe5" + df.format(new BigDecimal(numStr).doubleValue());
    }

    private SignupCourseInfoDto buildOrgSignupCourseDto(OrgSignupCourse orgSignupCourse, OrgCourse orgCourse, List<String> teacherNames) {
        SignupCourseInfoDto dto = new SignupCourseInfoDto();
        dto.setCount(orgSignupCourse.getCount());
        dto.setDiscount(orgSignupCourse.getCourseDiscount());
        dto.setOrgId(orgSignupCourse.getOrgId());
        dto.setUserId(orgSignupCourse.getUserId());
        dto.setOrgCourseId(orgSignupCourse.getOrgCourseId());
        dto.setClassId(orgSignupCourse.getClassId());
        dto.setCoursePrice((double)orgCourse.getPrice());
        dto.setOriginPrice(orgSignupCourse.getOriginPrice().doubleValue() / 100.0);
        double preferential = ((100.0 - orgSignupCourse.getCourseDiscount().doubleValue()) / 100.0 * (double)orgSignupCourse.getOriginPrice().intValue() * (double)orgSignupCourse.getCount().intValue() + (double)orgSignupCourse.getPreferential().intValue()) / 100.0;
        dto.setPreferential(preferential);
        dto.setRealPayPrice((double)orgSignupCourse.getPayPrice().longValue() / 100.0);
        dto.setPayPrice(orgSignupCourse.getPayPrice().doubleValue() / 100.0);
        dto.setOrgCourseName(orgCourse == null ? "" : orgCourse.getName());
        dto.setOrgCourseNumber(orgCourse == null ? 0L : orgCourse.getNumber());
        dto.setFreq(orgCourse == null || orgCourse.getFreq() == null ? 0 : orgCourse.getFreq());
        dto.setTeacherNames(teacherNames);
        dto.setTeacherNameStr(teacherNames == null || teacherNames.size() == 0 ? "\u5f85\u5b9a" : BaseUtils.listToStr(teacherNames, (String)","));
        dto.setTotalPrice(orgSignupCourse.getTotalPayPrice().doubleValue() / 100.0);
        if (orgCourse != null) {
            dto.setCourseType(orgCourse.getCourseType());
            dto.setChargeType(orgCourse.getChargeType());
        }
        orgSignupCourse.setChargeUnit(Integer.valueOf(orgSignupCourse.getChargeUnit() == null ? ChargeUnit.BY_OTHER.getCode() : orgSignupCourse.getChargeUnit().intValue()));
        dto.setChargeUnit(orgSignupCourse.getChargeUnit());
        dto.setChargeMode(ChargeMode.getByCharegeUnit((Integer)orgSignupCourse.getChargeUnit()).getCode());
        dto.setStudentPayPrice(orgSignupCourse.getStudentPayPrice().doubleValue() / 100.0);
        dto.setLessonCount(orgSignupCourse.getLessonCount() == null ? 0 : orgSignupCourse.getLessonCount());
        dto.setStatus(orgSignupCourse.getStatus());
        return dto;
    }

    private SignupFeeItemDto buildOrgSignupFeeItemDto(OrgSignupFee orgSignupFee) {
        SignupFeeItemDto dto = new SignupFeeItemDto();
        dto.setCount(orgSignupFee.getCount());
        dto.setDiscount(orgSignupFee.getFeeItemDiscount());
        dto.setFeeItemId(orgSignupFee.getFeeItemId());
        dto.setFeeItemName(orgSignupFee.getFeeItemName());
        dto.setOriginPrice(orgSignupFee.getOriginPrice().doubleValue() / 100.0);
        double preferential = ((100.0 - orgSignupFee.getFeeItemDiscount().doubleValue()) / 100.0 * (double)orgSignupFee.getOriginPrice().intValue() * (double)orgSignupFee.getCount().intValue() + (double)orgSignupFee.getPreferential().intValue()) / 100.0;
        dto.setPreferential(preferential);
        dto.setPayPrice(orgSignupFee.getPayPrice().doubleValue() / 100.0);
        return dto;
    }

    private void loadSignupCourseInfo(Collection<OrgSignupInfo> orgSignupInfos) {
        Long purchaseId;
        ArrayList purchaseIds = Lists.newArrayList();
        for (OrgSignupInfo info : orgSignupInfos) {
            purchaseIds.add(info.getSignupPurchaseId());
        }
        List signupCourses = this.orgSignupCourseDao.loadByPurchaseIds((Collection)purchaseIds, new String[0]);
        HashMap signupCourseMaping = Maps.newHashMap();
        for (OrgSignupCourse orgSignupCourse : signupCourses) {
            purchaseId = orgSignupCourse.getSignupPurchaseId();
            if (!signupCourseMaping.containsKey(purchaseId)) {
                signupCourseMaping.put(purchaseId, new ArrayList());
            }
            ((List)signupCourseMaping.get(purchaseId)).add(orgSignupCourse);
        }
        for (OrgSignupInfo orgSignupInfo : orgSignupInfos) {
            purchaseId = orgSignupInfo.getSignupPurchaseId();
            if (!signupCourseMaping.containsKey(purchaseId)) continue;
            orgSignupInfo.setOrgSignupCourses((List)signupCourseMaping.get(purchaseId));
        }
    }

    private void loadSignupFeeItem(Collection<OrgSignupInfo> orgSignupInfos) {
        ArrayList purchaseIds = Lists.newArrayList();
        for (OrgSignupInfo info : orgSignupInfos) {
            purchaseIds.add(info.getSignupPurchaseId());
        }
        List signupFeeItems = this.orgSignupFeeDao.loadByPurchaseIds((Collection)purchaseIds, new String[0]);
        HashMap signupFeeItemMaping = Maps.newHashMap();
        for (OrgSignupFee orgSignupFee : signupFeeItems) {
            Long purchaseId = orgSignupFee.getSignupPurchaseId();
            if (!signupFeeItemMaping.containsKey(purchaseId)) {
                signupFeeItemMaping.put(purchaseId, new ArrayList());
            }
            ((List)signupFeeItemMaping.get(purchaseId)).add(orgSignupFee);
        }
    }

    private OrgSingupInfoDto buildOrgSignupInfoDto(OrgSignupInfo orgSignupInfo, boolean isShowMobile, boolean downLoadRequest) {
        HashSet courseIds = Sets.newHashSet();
        if (CollectionUtils.isNotEmpty((Collection)orgSignupInfo.getOrgSignupCourses())) {
            for (OrgSignupCourse orgSignupCourse : orgSignupInfo.getOrgSignupCourses()) {
                courseIds.add(orgSignupCourse.getOrgCourseId());
            }
        }
        Map courseMap = this.orgCourseDao.getOrgCourseMap((Collection)courseIds, new String[0]);
        Map<Long, List<String>> courseTeacherNameMap = this.getCourseIdTeacherNamesMap(courseIds);
        Map cascadeMap = this.txCascadeCredentialService.getByTxCasCadeIds(orgSignupInfo.getOrgId());
        Long purchaseId = orgSignupInfo.getPayPurchaseId() == 0L ? orgSignupInfo.getSignupPurchaseId() : orgSignupInfo.getPayPurchaseId();
        Map<String, Long> signupRefundMoney = this.mapRefundMoneyWithPurchaseIds(Sets.newHashSet((Object[])new Long[]{purchaseId}));
        return this.buildOrgSignupInfoDto(orgSignupInfo, this.orgInfoDao.getOrgShortNameByOrgId(orgSignupInfo.getOrgId() != null ? Integer.valueOf(orgSignupInfo.getOrgId().intValue()) : null), courseMap, courseTeacherNameMap, cascadeMap, isShowMobile, signupRefundMoney, downLoadRequest);
    }

    @Override
    public OrgSingupInfoDto generarateTradeNo(Collection<Header> headers, double totalPrice, Long orgId) throws BussinessException {
        OrgSingupInfoDto dto = new OrgSingupInfoDto();
        if (totalPrice < 0.0) {
            log.error("totalPrice = {} < 0.", (Object)totalPrice);
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "totalPrice < 0");
        }
        CreatePurchaseResponseDto purchaseResponseDto = RestUtils.createPurchaseResponseDto((Long)orgId, (Double)totalPrice, headers);
        Long purchaseId = purchaseResponseDto.getData().getPurchaseId();
        dto.setSignupPurchaseId(purchaseId);
        String tradeNo = RestUtils.getTradeNo((Long)orgId, (Long)purchaseId, (Double)totalPrice, headers);
        dto.setTradeNo(tradeNo);
        String payUrlWinxin = RestUtils.getWeiXinPurchaseUrl((Long)purchaseId, (Long)orgId, (Double)totalPrice, headers);
        log.info("payUrlWinxin=={}", (Object)payUrlWinxin);
        dto.setPayUrlWinxin(payUrlWinxin);
        dto.setOrgId(orgId);
        dto.setTotalPrice(totalPrice);
        return dto;
    }

    @Override
    public OrgSingupInfoDto signUp(FillCourseInfoRequestDto fillCourseInfoRequestDto) throws BussinessException {
        Preconditions.checkNotNull((Object)fillCourseInfoRequestDto.getOrgId(), (Object)"orgId may not be null");
        fillCourseInfoRequestDto.setOrgNumber(this.getOrgNumber(fillCourseInfoRequestDto.getOrgId()));
        Preconditions.checkNotNull((Object)fillCourseInfoRequestDto.getOrgNumber(), (Object)"orgNumber may not be null");
        Long orgId = fillCourseInfoRequestDto.getOrgId();
        Long orgNumber = fillCourseInfoRequestDto.getOrgNumber();
        log.info("signUp--> =orgId {}, fillCourseInfoRequestDto {}", (Object)orgId, (Object)fillCourseInfoRequestDto);
        if (fillCourseInfoRequestDto.getOrgNumber() == null) {
            fillCourseInfoRequestDto.setOrgNumber(this.getOrgNumber(fillCourseInfoRequestDto.getOrgId()));
        }
        OrgSingupInfoDto dto = null;
        if (fillCourseInfoRequestDto.getSignupType() == SignupType.POS_CARD.getCode()) {
            if (!this.isPurchaseSucce(fillCourseInfoRequestDto.getSignupPurchaseId(), orgId, fillCourseInfoRequestDto.getCascadeId())) {
                throw new BussinessException((UniverseErrorCode)SignupErrorCode.PURCHASE_NOT_SUCCEED);
            }
            dto = this.signupAfterPay(fillCourseInfoRequestDto, orgId, orgNumber);
            return dto;
        }
        if (fillCourseInfoRequestDto.getSignupType() == SignupType.FRONTED.getCode()) {
            dto = this.signupBeforePay(fillCourseInfoRequestDto, orgId, orgNumber);
            return dto;
        }
        if (fillCourseInfoRequestDto.getSignupType() == SignupType.ONLINE.getCode()) {
            return this.signupPayOnline(fillCourseInfoRequestDto, orgId, orgNumber);
        }
        throw new BussinessException((UniverseErrorCode)SignupErrorCode.UNKNOWN_PURCHASE_STATUS);
    }

    private OrgSingupInfoDto signupPayOnline(FillCourseInfoRequestDto fillCourseInfoRequestDto, Long orgId, Long orgNumber) {
        throw new UnsupportedOperationException("not implement....");
    }

    private OrgSingupInfoDto signupBeforePay(FillCourseInfoRequestDto fillCourseInfoRequestDto, Long orgId, Long orgNumber) throws BussinessException {
        if (CollectionUtils.isNotEmpty(fillCourseInfoRequestDto.getCourseInfos())) {
            double totalPrice = 0.0;
            for (SignupCourseInfoDto signupCourseInfoDto : fillCourseInfoRequestDto.getCourseInfos()) {
                totalPrice += this.caculatePayPrice(fillCourseInfoRequestDto.getTransferClassOrder(), signupCourseInfoDto);
            }
            if (fillCourseInfoRequestDto.getFeeItemDtos() != null) {
                for (SignupFeeItemDto signupFeeItemDto : fillCourseInfoRequestDto.getFeeItemDtos()) {
                    totalPrice += this.caculateFeePrice(signupFeeItemDto);
                }
            }
            if (totalPrice > 1.0E7 || totalPrice < 0.0) {
                throw new BussinessException((UniverseErrorCode)SignupErrorCode.TOTALPRICE_ERROR, SignupErrorCode.TOTALPRICE_ERROR.getMessage());
            }
            totalPrice = new BigDecimal(totalPrice).setScale(2, RoundingMode.HALF_UP).doubleValue();
            double realPurchaseMoney = new BigDecimal(fillCourseInfoRequestDto.getTransferClassMoney() + fillCourseInfoRequestDto.getTotalPrice() - fillCourseInfoRequestDto.getTransferRefundMoney()).setScale(2, RoundingMode.HALF_UP).doubleValue();
            log.debug("Signup info caculate money = {},{}", (Object)totalPrice, (Object)realPurchaseMoney);
            if (totalPrice != realPurchaseMoney) {
                throw new BussinessException((UniverseErrorCode)SignupErrorCode.TOTALPRICE_NOTMATCH, SignupErrorCode.TOTALPRICE_NOTMATCH.getMessage());
            }
            long begin = System.currentTimeMillis();
            Long purchaseId = RestUtils.getPurchaseId((Long)orgId, (Double)totalPrice, fillCourseInfoRequestDto.getHeaders());
            String tradeNo = RestUtils.getTradeNo((Long)orgId, (Long)purchaseId, (Double)totalPrice, fillCourseInfoRequestDto.getHeaders());
            long end = System.currentTimeMillis();
            log.debug("signupBeforePay-->    RestUtils.getPurchaseId cost{}", (Object)(end - begin));
            log.info("getPurchaseId--> {}", (Object)purchaseId);
            Date now = new Date();
            OrgSignupInfo orgSignupInfo = new OrgSignupInfo();
            orgSignupInfo.setStudentPayPrice(Long.valueOf(0L));
            orgSignupInfo.setStatus(Integer.valueOf(DataStatus.NORMAL.getValue()));
            orgSignupInfo.setCreateTime(new Date());
            orgSignupInfo.setSplitResult(Integer.valueOf(SplitCourseResult.PENDING.getCode()));
            this.fillOrgSignupInfo(fillCourseInfoRequestDto, orgSignupInfo, orgId, orgNumber);
            orgSignupInfo.setSignupPurchaseId(purchaseId);
            orgSignupInfo.setPayPurchaseId(purchaseId);
            orgSignupInfo.setTradeNo(Long.valueOf(Long.parseLong(tradeNo)));
            fillCourseInfoRequestDto.setSignupPurchaseId(purchaseId);
            orgSignupInfo.setSignupType(Integer.valueOf(1));
            orgSignupInfo.setTotalPrices(Long.valueOf(NumberUtil.multiply((Number)fillCourseInfoRequestDto.getTotalPrice(), (BigDecimal)HUNDRED, (int)0).longValue()));
            ArrayList orgSignupCourses = Lists.newArrayList();
            for (SignupCourseInfoDto signupCourseInfoDto : fillCourseInfoRequestDto.getCourseInfos()) {
                signupCourseInfoDto.setPayPrice(this.caculatePayPrice(orgSignupInfo.getOrderType(), signupCourseInfoDto));
                orgSignupCourses.add(this.fillOrgSignupCourse(fillCourseInfoRequestDto, signupCourseInfoDto, orgSignupInfo.getUserId(), now, orgId));
            }
            orgSignupInfo.setOrgSignupCourses((List)orgSignupCourses);
            ArrayList orgSignupFees = Lists.newArrayList();
            if (fillCourseInfoRequestDto.getFeeItemDtos() != null) {
                for (SignupFeeItemDto signupFeeItemDto : fillCourseInfoRequestDto.getFeeItemDtos()) {
                    signupFeeItemDto.setPayPrice(this.caculateFeePrice(signupFeeItemDto));
                    orgSignupFees.add(this.fillOrgSignupFee(fillCourseInfoRequestDto, signupFeeItemDto, orgSignupInfo.getUserId(), now, orgId));
                }
            }
            orgSignupInfo.setHeaders(fillCourseInfoRequestDto.getHeaders());
            orgSignupInfo.setSourceType(Integer.valueOf(fillCourseInfoRequestDto.getSourceType()));
            log.debug("org signup info for save = {}", (Object)orgSignupInfo);
            this.saveOrUpdateSignupInfo(orgSignupInfo, true);
            this.saveContent(RedisKeyEnums.CW.TIANXIAO_SIGNUP_REDIS_PRE.getRedisKey() + orgSignupInfo.getSignupPurchaseId(), SerializeUtil.serialize((Object)orgSignupInfo));
            boolean bl = this.txCascadeCredentialService.isShowMobile(orgId, fillCourseInfoRequestDto.getCascadeId());
            return this.buildOrgSignupInfoDto(orgSignupInfo, bl, false);
        }
        throw new BussinessException((UniverseErrorCode)SignupErrorCode.SIGNUPCOURSE_NULL);
    }

    public boolean signupCourseInfoEqual(OrgSignupCourse orgSignupCourse, SignupCourseInfoDto signupCourseInfoDto) {
        if (orgSignupCourse == null) {
            return true;
        }
        if (orgSignupCourse.getCount().intValue() != signupCourseInfoDto.getCount()) {
            return false;
        }
        if (orgSignupCourse.getCourseDiscount().intValue() != signupCourseInfoDto.getDiscount()) {
            return false;
        }
        if (orgSignupCourse.getOriginPrice().intValue() != signupCourseInfoDto.getOriginPrice().intValue()) {
            return false;
        }
        return orgSignupCourse.getPreferential().intValue() == NumberUtil.multiply((Number)signupCourseInfoDto.getPreferential(), (BigDecimal)HUNDRED, (int)0).intValue();
    }

    private OrgSingupInfoDto signupAfterPay(FillCourseInfoRequestDto fillCourseInfoRequestDto, Long orgId, Long orgNumber) throws BussinessException {
        long total;
        OrgSignupInfo orgSignupInfo = null;
        if (fillCourseInfoRequestDto.getSignupPurchaseId() != null) {
            orgSignupInfo = this.orgSignupInfoDao.searchByPurchaseId(fillCourseInfoRequestDto.getSignupPurchaseId(), true, new String[0]);
            orgSignupInfo.setOrgSignupCourses(this.orgSignupCourseDao.loadByPurchaseId(fillCourseInfoRequestDto.getSignupPurchaseId(), new String[0]));
        }
        if (orgSignupInfo == null || orgSignupInfo.getSignupType() != 0) {
            throw new BussinessException((UniverseErrorCode)SignupErrorCode.PURCHASEID_ERROR);
        }
        if (orgSignupInfo != null && orgSignupInfo.getSplitResult().intValue() == SplitCourseResult.SUCCESS.getCode()) {
            throw new BussinessException((UniverseErrorCode)SignupErrorCode.COURCE_CHANGE);
        }
        if (orgSignupInfo.getSplitResult() >= SplitCourseResult.PENDING.getCode()) {
            throw new BussinessException((UniverseErrorCode)SignupErrorCode.REPEAT_SUBMIT);
        }
        this.fillOrgSignupInfo(fillCourseInfoRequestDto, orgSignupInfo, orgId, orgNumber);
        orgSignupInfo.setSplitResult(Integer.valueOf(SplitCourseResult.PENDING.getCode()));
        long totalNow = 0L;
        long totalNew = 0L;
        Date now = new Date();
        HashMap<Long, OrgSignupCourse> orgSignupCourseMap = new HashMap<Long, OrgSignupCourse>();
        ArrayList orgSignupCoursesNew = Lists.newArrayList();
        ArrayList orgSignupCoursesNow = Lists.newArrayList();
        orgSignupCoursesNow.addAll(orgSignupInfo.getOrgSignupCourses());
        if (CollectionUtils.isNotEmpty((Collection)orgSignupInfo.getOrgSignupCourses())) {
            for (OrgSignupCourse orgSignupCourse : orgSignupInfo.getOrgSignupCourses()) {
                totalNow += orgSignupCourse.getPayPrice().longValue();
                orgSignupCourseMap.put(orgSignupCourse.getOrgCourseId(), orgSignupCourse);
            }
        }
        if (orgSignupInfo.getTotalPrices() <= totalNow) {
            log.warn(" signupAfterPay get error:{}", (Object)SignupErrorCode.REPEAT_SUBMIT.getMessage());
            throw new BussinessException((UniverseErrorCode)SignupErrorCode.REPEAT_SUBMIT);
        }
        if (CollectionUtils.isNotEmpty(fillCourseInfoRequestDto.getCourseInfos())) {
            for (SignupCourseInfoDto signupCourseInfoDto : fillCourseInfoRequestDto.getCourseInfos()) {
                if (orgSignupCourseMap.containsKey(signupCourseInfoDto.getOrgCourseId())) {
                    if (this.signupCourseInfoEqual((OrgSignupCourse)orgSignupCourseMap.get(signupCourseInfoDto.getOrgCourseId()), signupCourseInfoDto)) continue;
                    log.warn(" fillCourseInfo get error:{}", (Object)SignupErrorCode.COURCE_CHANGE.getMessage());
                    throw new BussinessException((UniverseErrorCode)SignupErrorCode.COURCE_CHANGE);
                }
                signupCourseInfoDto.setPayPrice(this.caculatePayPrice(orgSignupInfo.getOrderType(), signupCourseInfoDto));
                totalNew += NumberUtil.multiply((Number)signupCourseInfoDto.getPayPrice(), (BigDecimal)HUNDRED, (int)0).longValue();
                orgSignupCoursesNew.add(this.fillOrgSignupCourse(fillCourseInfoRequestDto, signupCourseInfoDto, orgSignupInfo.getUserId(), now, orgId));
            }
        }
        if ((total = totalNew + totalNow) < 0L) {
            throw new BussinessException((UniverseErrorCode)SignupErrorCode.TOTALPRICE_ERROR, SignupErrorCode.TOTALPRICE_ERROR.getMessage());
        }
        if ((double)total != orgSignupInfo.getTotalPrices().doubleValue()) {
            throw new BussinessException((UniverseErrorCode)SignupErrorCode.TOTALPRICE_NOTMATCH, SignupErrorCode.TOTALPRICE_NOTMATCH.getMessage());
        }
        if (orgSignupInfo.getPayType().intValue() == PayType.CASH.getCode()) {
            orgSignupInfo.setSplitResult(Integer.valueOf(SplitCourseResult.SUCCESS.getCode()));
        } else {
            orgSignupInfo.setSplitResult(Integer.valueOf(SplitCourseResult.PENDING.getCode()));
        }
        if (CollectionUtils.isNotEmpty((Collection)orgSignupCoursesNew)) {
            orgSignupInfo.setOrgSignupCourses((List)orgSignupCoursesNew);
        }
        orgSignupInfo.setSourceType(Integer.valueOf(fillCourseInfoRequestDto.getSourceType()));
        this.saveOrUpdateSignupInfo(orgSignupInfo, true);
        orgSignupInfo.getOrgSignupCourses().addAll(orgSignupCoursesNow);
        orgSignupInfo.setPurchaseStatus(Integer.valueOf(PayResult.SUCCESS.getCode()));
        this.saveContent(RedisKeyEnums.CW.TIANXIAO_SIGNUP_REDIS_PRE.getRedisKey() + orgSignupInfo.getSignupPurchaseId(), SerializeUtil.serialize((Object)orgSignupInfo));
        boolean isShowMobile = this.txCascadeCredentialService.isShowMobile(orgId, fillCourseInfoRequestDto.getCascadeId());
        return this.buildOrgSignupInfoDto(orgSignupInfo, isShowMobile, false);
    }

    private double caculatePayPrice(int transferClassOrder, SignupCourseInfoDto signupCourseInfoDto) {
        if (transferClassOrder == TransferClassOrder.TRANSFER_ORDER.getCode() || signupCourseInfoDto.getChargeType() != null && signupCourseInfoDto.getChargeType().intValue() == ChargeType.BY_PERIODS.getCode().intValue()) {
            return new BigDecimal(signupCourseInfoDto.getPayPrice()).setScale(2, RoundingMode.HALF_UP).doubleValue();
        }
        BigDecimal result = new BigDecimal(signupCourseInfoDto.getOriginPrice()).multiply(new BigDecimal(signupCourseInfoDto.getDiscount())).divide(HUNDRED).multiply(new BigDecimal(signupCourseInfoDto.getCount())).subtract(new BigDecimal(signupCourseInfoDto.getPreferential())).setScale(2, RoundingMode.HALF_UP).add(new BigDecimal(signupCourseInfoDto.getRoundUpMoney()));
        return result.doubleValue();
    }

    private double caculateFeePrice(SignupFeeItemDto signupFeeItemDto) {
        BigDecimal result = new BigDecimal(signupFeeItemDto.getOriginPrice()).multiply(new BigDecimal(signupFeeItemDto.getDiscount())).divide(HUNDRED).multiply(new BigDecimal(signupFeeItemDto.getCount())).subtract(new BigDecimal(signupFeeItemDto.getPreferential())).setScale(2, RoundingMode.HALF_UP);
        return result.doubleValue();
    }

    private OrgSignupCourse fillOrgSignupCourse(FillCourseInfoRequestDto fillCourseInfoRequestDto, SignupCourseInfoDto signupCourseInfoDto, Long studentId, Date now, Long orgId) {
        OrgCourse orgCourse = this.orgCourseDao.getByCourseId(signupCourseInfoDto.getOrgCourseId(), new String[0]);
        OrgSignupCourse orgSignupCourse = new OrgSignupCourse();
        orgSignupCourse.setCount(Integer.valueOf(signupCourseInfoDto.getCount()));
        if (orgCourse != null && orgCourse.getChargeType() == ChargeType.BY_OTHER.getCode()) {
            orgSignupCourse.setLessonCount(Integer.valueOf(0));
        } else {
            orgSignupCourse.setLessonCount(Integer.valueOf(signupCourseInfoDto.getLessonCount() == null ? 0 : signupCourseInfoDto.getLessonCount()));
        }
        orgSignupCourse.setCourseDiscount(Integer.valueOf(signupCourseInfoDto.getDiscount()));
        orgSignupCourse.setRealDiscount(Integer.valueOf(signupCourseInfoDto.getRealDiscount() == null ? -1 : signupCourseInfoDto.getRealDiscount()));
        orgSignupCourse.setCreateTime(now);
        orgSignupCourse.setUpdateTime(now);
        orgSignupCourse.setOrgCourseId(signupCourseInfoDto.getOrgCourseId());
        orgSignupCourse.setOrgId(orgId);
        orgSignupCourse.setOriginPrice(Integer.valueOf(NumberUtil.multiply((Number)signupCourseInfoDto.getOriginPrice(), (BigDecimal)HUNDRED, (int)0).intValue()));
        orgSignupCourse.setPreferential(Integer.valueOf(NumberUtil.multiply((Number)signupCourseInfoDto.getPreferential(), (BigDecimal)HUNDRED, (int)0).intValue()));
        orgSignupCourse.setSignupPurchaseId(fillCourseInfoRequestDto.getSignupPurchaseId());
        orgSignupCourse.setOrgCourseNumber(signupCourseInfoDto.getOrgCourseNumber());
        orgSignupCourse.setUserId(studentId);
        orgSignupCourse.setPayPrice(Long.valueOf(NumberUtil.multiply((Number)this.caculatePayPrice(fillCourseInfoRequestDto.getTransferClassOrder(), signupCourseInfoDto), (BigDecimal)HUNDRED, (int)0).longValue()));
        orgSignupCourse.setTransferPurchaseMoney(Long.valueOf(NumberUtil.multiply((Number)(fillCourseInfoRequestDto.getTransferClassMoney() - fillCourseInfoRequestDto.getTransferRefundMoney()), (BigDecimal)HUNDRED, (int)0).longValue()));
        orgSignupCourse.setPayPrice(Long.valueOf(orgSignupCourse.getPayPrice() - orgSignupCourse.getTransferPurchaseMoney()));
        orgSignupCourse.setStudentPayPrice(Long.valueOf(0L));
        orgSignupCourse.setChargeUnit(signupCourseInfoDto.getChargeUnit());
        orgSignupCourse.setIsDel(Integer.valueOf(DataStatus.NORMAL.getValue()));
        orgSignupCourse.setStatus(Integer.valueOf(SignupCourseStatus.NOT_PAY.getCode()));
        return orgSignupCourse;
    }

    private OrgSignupFee fillOrgSignupFee(FillCourseInfoRequestDto fillCourseInfoRequestDto, SignupFeeItemDto signupFeeItemDto, Long studentId, Date now, Long orgId) {
        OrgSignupFee orgSignupFee = new OrgSignupFee();
        orgSignupFee.setCount(Integer.valueOf(signupFeeItemDto.getCount()));
        orgSignupFee.setFeeItemDiscount(Integer.valueOf(signupFeeItemDto.getDiscount()));
        orgSignupFee.setCreateTime(now);
        orgSignupFee.setFeeItemId(signupFeeItemDto.getFeeItemId());
        orgSignupFee.setOrgId(orgId);
        orgSignupFee.setOriginPrice(Integer.valueOf(NumberUtil.multiply((Number)signupFeeItemDto.getOriginPrice(), (BigDecimal)HUNDRED, (int)0).intValue()));
        orgSignupFee.setPreferential(Integer.valueOf(NumberUtil.multiply((Number)signupFeeItemDto.getPreferential(), (BigDecimal)HUNDRED, (int)0).intValue()));
        orgSignupFee.setSignupPurchaseId(fillCourseInfoRequestDto.getSignupPurchaseId());
        orgSignupFee.setFeeItemName(signupFeeItemDto.getFeeItemName());
        orgSignupFee.setUserId(studentId);
        orgSignupFee.setPayPrice(Long.valueOf(NumberUtil.multiply((Number)this.caculateFeePrice(signupFeeItemDto), (BigDecimal)HUNDRED, (int)0).longValue()));
        return orgSignupFee;
    }

    @Override
    public Long getStudent(FillCourseInfoRequestDto fillCourseInfoRequestDto) throws BussinessException {
        log.info("Signup get student params={}", (Object)fillCourseInfoRequestDto);
        Long usrId = null;
        Long studentId = null;
        Long orgId = fillCourseInfoRequestDto.getOrgId();
        String mobile = fillCourseInfoRequestDto.getStudentMobile();
        String studentName = fillCourseInfoRequestDto.getStudentName();
        List students = Lists.newArrayList();
        if (fillCourseInfoRequestDto.getStudentId() != null) {
            ArrayList studentIds = Lists.newArrayList();
            studentIds.add(fillCourseInfoRequestDto.getStudentId());
            students = this.orgStudentDao.getStudentByIds(fillCourseInfoRequestDto.getOrgId(), (Collection)studentIds, new String[0]);
        } else {
            students = this.orgStudentDao.getStudentId(orgId, mobile, Integer.valueOf(DeleteStatus.NORMAL.getValue()), studentName, new String[0]);
        }
        StudentInfoDto studentInfoDto = new StudentInfoDto();
        if (!students.isEmpty()) {
            OrgStudent stu = (OrgStudent)students.get(0);
            usrId = stu.getUserId();
            studentId = stu.getId();
            studentInfoDto = this.fillStudentInfoByStu(studentInfoDto, stu);
        }
        log.debug("studentInfoDto = {}", (Object)studentInfoDto);
        studentInfoDto = this.fillStudentInfo(studentInfoDto, fillCourseInfoRequestDto);
        List<CommentInfoDto> commentInfoDtos = this.fillCommentInfoList(fillCourseInfoRequestDto);
        List<TagInfoDto> tagInfoDtos = this.fillTagInfoList(studentId, fillCourseInfoRequestDto);
        log.debug("studentInfoDto = {},tagInfoDto={}", (Object)studentInfoDto, tagInfoDtos);
        studentInfoDto.setConfirm(BizConf.TRUE);
        if (studentInfoDto.getAddCascadeId() == null) {
            studentInfoDto.setAddCascadeId(fillCourseInfoRequestDto.getCascadeId());
        }
        if (studentInfoDto.getGender() == null) {
            studentInfoDto.setGender(Integer.valueOf(-1));
        }
        if (studentId == null) {
            OrgStudentAddresponseDto dto = this.orgStudentService.addStudent(studentInfoDto, commentInfoDtos, tagInfoDtos, orgId);
            usrId = dto.getUserId();
        } else {
            this.orgStudentService.modStudent(studentInfoDto, commentInfoDtos, tagInfoDtos, orgId);
        }
        return usrId;
    }

    private StudentInfoDto fillStudentInfoByStu(StudentInfoDto studentInfoDto, OrgStudent stu) {
        studentInfoDto.setStudentId(stu.getId());
        studentInfoDto.setMobile(stu.getStudentMobile());
        studentInfoDto.setQq(stu.getQq());
        studentInfoDto.setWeixin(stu.getWeixin());
        studentInfoDto.setName(stu.getName());
        studentInfoDto.setBirthday(stu.getBirthday() != null ? Long.valueOf(stu.getBirthday().getTime()) : null);
        studentInfoDto.setRemark(stu.getRemark());
        studentInfoDto.setMail(stu.getMail());
        studentInfoDto.setParentName(stu.getParentName());
        studentInfoDto.setParentMobile(stu.getParentMobile());
        studentInfoDto.setGender(stu.getGender());
        studentInfoDto.setNextRemindTimeDate(stu.getNextRemindTime());
        studentInfoDto.setAddress(stu.getAddress());
        studentInfoDto.setDegreeClass(stu.getDegreeClass());
        studentInfoDto.setFatherOccupation(stu.getFatherOccupation());
        studentInfoDto.setMatherOccupation(stu.getMatherOccupation());
        studentInfoDto.setSource(stu.getSource());
        studentInfoDto.setSchool(stu.getSchool());
        studentInfoDto.setBranchId(stu.getBranchId());
        studentInfoDto.setRelationship(stu.getRelationship());
        studentInfoDto.setLatitude(Double.valueOf(stu.getLatitude() != null ? stu.getLatitude() : 0.0));
        studentInfoDto.setLongitude(Double.valueOf(stu.getLongitude() != null ? stu.getLongitude() : 0.0));
        studentInfoDto.setAreaId(stu.getAreaId());
        studentInfoDto.setStorageId(stu.getAvatar());
        studentInfoDto.setAddCascadeId(stu.getAddCascadeId());
        studentInfoDto.setNextRemindTime(stu.getNextRemindTime() != null ? Long.valueOf(stu.getNextRemindTime().getTime()) : null);
        return studentInfoDto;
    }

    private StudentInfoDto fillStudentInfo(StudentInfoDto studentInfoDto, FillCourseInfoRequestDto fillCourseInfoRequestDto) {
        if (fillCourseInfoRequestDto.getStudentId() != null) {
            studentInfoDto.setStudentId(fillCourseInfoRequestDto.getStudentId());
        }
        if (fillCourseInfoRequestDto.getStudentMobile() != null && !fillCourseInfoRequestDto.getStudentMobile().contains("*")) {
            studentInfoDto.setMobile(fillCourseInfoRequestDto.getStudentMobile());
        }
        if (fillCourseInfoRequestDto.getStudentQQ() != null) {
            studentInfoDto.setQq(fillCourseInfoRequestDto.getStudentQQ());
        }
        if (fillCourseInfoRequestDto.getStudentWx() != null) {
            // empty if block
        }
        if (fillCourseInfoRequestDto.getStudentName() != null) {
            studentInfoDto.setName(fillCourseInfoRequestDto.getStudentName());
        }
        if (fillCourseInfoRequestDto.getBirthday() != null) {
            studentInfoDto.setBirthday(Long.valueOf(fillCourseInfoRequestDto.getBirthday().getTime()));
        }
        if (fillCourseInfoRequestDto.getStudentRemark() != null) {
            studentInfoDto.setRemark(fillCourseInfoRequestDto.getStudentRemark());
        }
        if (fillCourseInfoRequestDto.getEmail() != null) {
            studentInfoDto.setMail(fillCourseInfoRequestDto.getEmail());
        }
        if (fillCourseInfoRequestDto.getParentName() != null) {
            studentInfoDto.setParentName(fillCourseInfoRequestDto.getParentName());
        }
        if (fillCourseInfoRequestDto.getParentMobile() != null && !fillCourseInfoRequestDto.getParentMobile().contains("*")) {
            studentInfoDto.setParentMobile(fillCourseInfoRequestDto.getParentMobile());
        }
        if (fillCourseInfoRequestDto.getGender() != null) {
            studentInfoDto.setGender(fillCourseInfoRequestDto.getGender());
        }
        if (fillCourseInfoRequestDto.getTags() != null) {
            studentInfoDto.setTags(fillCourseInfoRequestDto.getTags());
        }
        return studentInfoDto;
    }

    private List<CommentInfoDto> fillCommentInfoList(FillCourseInfoRequestDto fillCourseInfoRequestDto) {
        return GenericsUtils.emptyList();
    }

    private List<TagInfoDto> fillTagInfoList(Long studentId, FillCourseInfoRequestDto fillCourseInfoRequestDto) {
        String[] tags;
        log.debug("fillTagInfoList={}", (Object)fillCourseInfoRequestDto);
        ArrayList tagInfoDtos = Lists.newArrayList();
        if (studentId == null) {
            return tagInfoDtos;
        }
        if (StringUtils.isEmpty((String)fillCourseInfoRequestDto.getTags())) {
            OrgTagListResopnseDto tagsResponse = this.orgStudentTagService.getTags(Integer.valueOf(StudentType.ORG_STUDENTS.getCode()), studentId, fillCourseInfoRequestDto.getOrgId());
            return tagsResponse.getTags();
        }
        for (String tag : tags = fillCourseInfoRequestDto.getTags().split(" ")) {
            TagInfoDto tagInfoDto = new TagInfoDto();
            tagInfoDto.setContent(tag);
            tagInfoDtos.add(tagInfoDto);
        }
        log.debug("fillTagInfoList={},{}", (Object)tagInfoDtos, (Object)tags);
        return tagInfoDtos;
    }

    private void fillOrgSignupInfo(FillCourseInfoRequestDto fillCourseInfoRequestDto, OrgSignupInfo orgSignupInfo, Long orgId, Long orgNumber) throws BussinessException {
        long begin = System.currentTimeMillis();
        Long stuUserId = this.getStudent(fillCourseInfoRequestDto);
        long end = System.currentTimeMillis();
        log.debug("-->    getStudent cost{}", (Object)(end - begin));
        orgSignupInfo.setUserId(stuUserId);
        orgSignupInfo.setOrgId(orgId);
        orgSignupInfo.setOrgNumber(orgNumber);
        orgSignupInfo.setMobile(fillCourseInfoRequestDto.getStudentMobile());
        orgSignupInfo.setStudentName(fillCourseInfoRequestDto.getStudentName());
        if (orgSignupInfo.getPayType() == null) {
            orgSignupInfo.setPayType(Integer.valueOf(PayType.PAY_POS_CARD.getCode()));
        }
        if (fillCourseInfoRequestDto.getTransferClassOrder() == TransferClassOrder.TRANSFER_ORDER.getCode()) {
            orgSignupInfo.setTransferClassMoney(Long.valueOf(NumberUtil.multiply((Number)fillCourseInfoRequestDto.getTransferClassMoney(), (BigDecimal)HUNDRED, (int)0).longValue()));
            orgSignupInfo.setTransferRefundMoney(Long.valueOf(NumberUtil.multiply((Number)fillCourseInfoRequestDto.getTransferRefundMoney(), (BigDecimal)HUNDRED, (int)0).longValue()));
            orgSignupInfo.setOrderType(Integer.valueOf(fillCourseInfoRequestDto.getTransferClassOrder()));
            orgSignupInfo.setTransferRefundType(SignupRefundType.BY_OLD_PURCHASE_CASH.getCode());
        }
        orgSignupInfo.setRemark(StringUtils.isEmpty((String)fillCourseInfoRequestDto.getRemark()) ? orgSignupInfo.getRemark() : fillCourseInfoRequestDto.getRemark());
        orgSignupInfo.setRemark(orgSignupInfo.getRemark() == null ? "" : orgSignupInfo.getRemark());
        orgSignupInfo.setOperator("");
        orgSignupInfo.setUpdateTime(new Date());
        orgSignupInfo.setSignupType(Integer.valueOf(fillCourseInfoRequestDto.getSignupType()));
        if (orgSignupInfo.getCascadeId() == null || orgSignupInfo.getCascadeId() == 0) {
            orgSignupInfo.setCascadeId(Integer.valueOf(fillCourseInfoRequestDto.getCascadeId() == null ? 0 : fillCourseInfoRequestDto.getCascadeId()));
        }
    }

    @Override
    @Transactional
    public OrgSingupInfoDto payByCash(Long signupPurchaseId, Long orgId, Integer cascadeId) throws BussinessException {
        OrgSignupInfo orgSignupInfo = this.orgSignupInfoDao.searchByPurchaseId(signupPurchaseId, new String[0]);
        boolean isNew = false;
        if (orgSignupInfo == null) {
            OrgSinupPurchase purchase = this.orgSinupPurchaseDao.getByPurchaseId(signupPurchaseId, new String[0]);
            log.debug("get purchase:{} by purchaseId:{}", (Object)purchase, (Object)signupPurchaseId);
            if (purchase != null) {
                isNew = true;
                orgSignupInfo = this.insertSuccSignupInfo(signupPurchaseId, purchase, purchase.getPurchaseId(), cascadeId);
            }
        }
        if (orgSignupInfo == null) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "signup purchase error");
        }
        if (orgSignupInfo.getStatus().intValue() == DataStatus.DELETE.getValue()) {
            throw new BussinessException((UniverseErrorCode)SignupErrorCode.SIGNUP_CANCEL);
        }
        List orgCourseList = this.orgSignupCourseDao.loadByPurchaseId(signupPurchaseId, new String[0]);
        OrgSignupInfo saveObj = new OrgSignupInfo();
        saveObj.setId(orgSignupInfo.getId());
        saveObj.setPayType(Integer.valueOf(PayType.CASH.getCode()));
        saveObj.setPurchaseStatus(Integer.valueOf(1));
        saveObj.setPayTime(new Date());
        if (isNew) {
            saveObj.setSplitResult(Integer.valueOf(SplitCourseResult.NOT_COMMIT.getCode()));
        } else {
            saveObj.setSplitResult(Integer.valueOf(SplitCourseResult.SUCCESS.getCode()));
            this.orgSignupCourseDao.updateStatusByPurchaseId(signupPurchaseId, Integer.valueOf(SignupCourseStatus.HAS_PAY.getCode()));
            for (OrgSignupCourse signupCourse : orgCourseList) {
                signupCourse.setStatus(Integer.valueOf(SignupCourseStatus.HAS_PAY.getCode()));
            }
        }
        this.orgSignupInfoDao.update((Object)saveObj, Boolean.valueOf(false), new String[]{"payType", "purchaseStatus", "splitResult", "payTime"});
        orgSignupInfo.setOrgSignupCourses(orgCourseList);
        orgSignupInfo.setStudentPayPrice(orgSignupInfo.getStudentPayPrice());
        orgSignupInfo.setStatus(Integer.valueOf(DataStatus.NORMAL.getValue()));
        orgSignupInfo.setPayType(Integer.valueOf(PayType.CASH.getCode()));
        orgSignupInfo.setPurchaseStatus(Integer.valueOf(1));
        orgSignupInfo.setCascadeId(cascadeId);
        this.saveContent(RedisKeyEnums.CW.TIANXIAO_SIGNUP_REDIS_PRE.getRedisKey() + orgSignupInfo.getSignupPurchaseId(), SerializeUtil.serialize((Object)orgSignupInfo));
        boolean isShowMobile = this.txCascadeCredentialService.isShowMobile(orgId, cascadeId);
        return this.buildOrgSignupInfoDto(orgSignupInfo, isShowMobile, false);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void delSignupInfo(Long signupPurchaseId, Long orgId) throws BussinessException {
        OrgSignupInfo orgSignupInfo = this.orgSignupInfoDao.searchByPurchaseId(signupPurchaseId, new String[]{"id", "signupPurchaseId", "orderType"});
        if (orgSignupInfo == null) {
            throw new BussinessException((UniverseErrorCode)SignupErrorCode.PURCHASEID_ERROR);
        }
        orgSignupInfo.setIsDel(Integer.valueOf(DataStatus.DELETE.getValue()));
        orgSignupInfo.setUpdateTime(new Date());
        this.orgSignupInfoDao.update((Object)orgSignupInfo, Boolean.valueOf(false), new String[]{"isDel", "updateTime"});
        this.orgSignupCourseDao.delSignupCourseByPurchaseId(signupPurchaseId);
        if (orgSignupInfo.getOrderType().intValue() == TransferClassOrder.TRANSFER_ORDER.getCode()) {
            this.transferClassInfoService.cancelTransferClassByPurchase(orgSignupInfo.getSignupPurchaseId());
        }
    }

    @Override
    public OrgSignupInfo getByPurchaseId(Long orgId, Long signupPurchaseId) throws BussinessException {
        return this.orgSignupInfoDao.getByPurchaseId(orgId, signupPurchaseId);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean isPurchaseSucce(Long payPurchaseId, Long orgId, Integer cascadeId) throws BussinessException {
        Preconditions.checkNotNull((Object)payPurchaseId);
        Preconditions.checkArgument((payPurchaseId > 0L ? 1 : 0) != 0, (Object)"purchase id can not be 0");
        OrgSignupInfo orgSignupInfo = this.orgSignupInfoDao.searchByPayPurchaseId(payPurchaseId, false, new String[0]);
        if (orgSignupInfo == null) {
            orgSignupInfo = this.orgSignupInfoDao.searchByPurchaseId(payPurchaseId, false, new String[0]);
        }
        if (orgSignupInfo != null) {
            orgSignupInfo.checkIsExpired();
        }
        OrgSinupPurchase purchase = this.orgSinupPurchaseDao.getByPurchaseId(payPurchaseId, new String[0]);
        if (orgSignupInfo != null && orgSignupInfo.getPayType() != null && orgSignupInfo.getPayType().intValue() == PayType.CASH.getCode()) {
            byte[] signupBytes = this.getContent(RedisKeyEnums.CW.TIANXIAO_SIGNUP_REDIS_PRE.getRedisKey() + orgSignupInfo.getSignupPurchaseId());
            if (signupBytes == null) {
                return true;
            }
            OrgSignupInfo orgSignupInfoRedis = (OrgSignupInfo)SerializeUtil.unserialize((byte[])signupBytes);
            if (orgSignupInfoRedis != null) {
                orgSignupInfoRedis.setPurchaseStatus(Integer.valueOf(PayResult.SUCCESS.getCode()));
                this.saveContent(RedisKeyEnums.CW.TIANXIAO_SIGNUP_REDIS_PRE.getRedisKey() + orgSignupInfoRedis.getSignupPurchaseId(), SerializeUtil.serialize((Object)orgSignupInfoRedis));
            }
            return true;
        }
        if (purchase.getStatus() != null && purchase.getStatus().intValue() == PayResult.SUCCESS.getCode()) {
            OrgSignupInfo orgSignupInfoRedis;
            Map tradeNoMap = RestUtils.getTradeNoMap((Collection)Lists.newArrayList((Object[])new Long[]{payPurchaseId}));
            if (orgSignupInfo == null) {
                orgSignupInfo = this.insertSuccSignupInfo(payPurchaseId, purchase, (Long)tradeNoMap.get(payPurchaseId), cascadeId);
                this.saveContent(RedisKeyEnums.CW.TIANXIAO_SIGNUP_REDIS_PRE.getRedisKey() + orgSignupInfo.getSignupPurchaseId(), SerializeUtil.serialize((Object)orgSignupInfo));
                return true;
            }
            if (orgSignupInfo.getPurchaseStatus().intValue() != PayResult.SUCCESS.getCode()) {
                if (tradeNoMap.isEmpty() || !tradeNoMap.containsKey(payPurchaseId)) {
                    throw new BussinessException((UniverseErrorCode)SignupErrorCode.PURCHASE_NOT_SUCCEED);
                }
                orgSignupInfo.setPurchaseStatus(Integer.valueOf(PayResult.SUCCESS.getCode()));
                int payType = PayType.getPayTypeByTypeStr((String)purchase.getPayType()).getCode();
                orgSignupInfo.setTradeNo((Long)tradeNoMap.get(payPurchaseId));
                orgSignupInfo.setPayType(Integer.valueOf(payType));
                orgSignupInfo.setPayTime(new Date());
                this.orgSignupInfoDao.update((Object)orgSignupInfo, new String[]{"purchaseStatus", "tradeNo", "payType", "payTime"});
                this.saveContent(RedisKeyEnums.CW.TIANXIAO_SIGNUP_REDIS_PRE.getRedisKey() + orgSignupInfo.getSignupPurchaseId(), SerializeUtil.serialize((Object)orgSignupInfo));
                return true;
            }
            byte[] signupBytes = this.getContent(RedisKeyEnums.CW.TIANXIAO_SIGNUP_REDIS_PRE.getRedisKey() + (orgSignupInfo == null ? payPurchaseId : orgSignupInfo.getSignupPurchaseId()));
            if (signupBytes != null && (orgSignupInfoRedis = (OrgSignupInfo)SerializeUtil.unserialize((byte[])signupBytes)) != null) {
                orgSignupInfoRedis.setPurchaseStatus(Integer.valueOf(PayResult.SUCCESS.getCode()));
                this.saveContent(RedisKeyEnums.CW.TIANXIAO_SIGNUP_REDIS_PRE.getRedisKey() + orgSignupInfoRedis.getSignupPurchaseId(), SerializeUtil.serialize((Object)orgSignupInfoRedis));
            }
            return true;
        }
        return false;
    }

    private OrgSignupInfo insertSuccSignupInfo(Long signupPurchaseId, OrgSinupPurchase sinupPurchase, Long tradeNo, Integer cascadeId) {
        log.info("create signup info from purchase:{}", (Object)sinupPurchase);
        OrgSignupInfo info = new OrgSignupInfo();
        info.setCreateTime(sinupPurchase.getPayTime());
        info.setPayTime(sinupPurchase.getPayTime());
        info.setStatus(Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        info.setIsDel(Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        info.setMobile("");
        info.setOperator("");
        info.setOrgId(sinupPurchase.getOrgId());
        info.setOrgNumber(sinupPurchase.getOrgNumber());
        info.setPayType(Integer.valueOf(PayType.getPayTypeByTypeStr((String)sinupPurchase.getPayType()).getCode()));
        info.setPurchaseStatus(sinupPurchase.getStatus());
        info.setRemark("");
        info.setSignupPurchaseId(signupPurchaseId);
        info.setPayPurchaseId(sinupPurchase.getPurchaseId());
        info.setSignupType(Integer.valueOf(SignupType.POS_CARD.getCode()));
        info.setSplitResult(Integer.valueOf(SplitCourseResult.NOT_COMMIT.getCode()));
        info.setStudentName("");
        info.setTotalPrices(Long.valueOf(NumberUtil.multiply((Number)sinupPurchase.getTotalPrices(), (BigDecimal)HUNDRED, (int)0).longValue()));
        info.setStudentPayPrice(Long.valueOf(0L));
        info.setUpdateTime(new Date());
        info.setUserId(Long.valueOf(0L));
        info.setTradeNo(tradeNo);
        info.setCascadeId(cascadeId);
        this.saveOrUpdateSignupInfo(info, false);
        return info;
    }

    private void saveOrUpdateSignupInfo(@NonNull OrgSignupInfo signupInfo, boolean saveCourses) {
        if (signupInfo == null) {
            throw new NullPointerException("signupInfo");
        }
        if (signupInfo.getSourceType() == null || signupInfo.getSourceType() == 0) {
            signupInfo.setSourceType(SignupSourceType.TX_SIANGUP.getCode());
        }
        if (signupInfo.getPurchaseStatus().intValue() != PayStatus.SUCESS.getCode() && signupInfo.getStudentPayPrice() == 0L && signupInfo.getTotalPrices() == 0L && signupInfo.getTransferRefundMoney() == 0L) {
            if (signupInfo.getOrderType().intValue() == TransferClassOrder.TRANSFER_ORDER.getCode()) {
                signupInfo.setPayType(Integer.valueOf(PayType.TX_NO_PAY.getCode()));
            } else {
                signupInfo.setPayType(Integer.valueOf(PayType.CASH.getCode()));
            }
            signupInfo.setPayTime(new Date());
            signupInfo.setUpdateTime(DateUtil.getDiffMinute((Date)signupInfo.getPayTime(), (int)1));
            signupInfo.setPurchaseStatus(Integer.valueOf(PayResult.SUCCESS.getCode()));
            signupInfo.setSplitResult(Integer.valueOf(SplitCourseResult.SUCCESS.getCode()));
        }
        if (signupInfo.getId() != null && signupInfo.getId() > 0L) {
            this.orgSignupInfoDao.update((Object)signupInfo, new String[0]);
        } else {
            try {
                this.orgSignupInfoDao.save((Object)signupInfo, new String[0]);
            }
            catch (Exception e) {
                log.warn("save signup info unique_purchase_id\u3002e = {}", (Throwable)e);
            }
        }
        if (saveCourses && CollectionUtils.isNotEmpty((Collection)signupInfo.getOrgSignupCourses())) {
            try {
                this.orgSignupCourseDao.saveSignupCourses(signupInfo.getOrgSignupCourses());
            }
            catch (DuplicateKeyException e) {
                log.warn("\u6570\u636e\u91cd\u590d\u3002e = {}", (Throwable)e);
            }
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean sendOnlinePaySms(@NonNull Long signupPurchaseId, @NonNull Long orgId, @NonNull String mobile) throws BussinessException {
        if (signupPurchaseId == null) {
            throw new NullPointerException("signupPurchaseId");
        }
        if (orgId == null) {
            throw new NullPointerException("orgId");
        }
        if (mobile == null) {
            throw new NullPointerException("mobile");
        }
        OrgSignupInfo purchase = this.orgSignupInfoDao.searchByPurchaseId(signupPurchaseId, new String[0]);
        if (purchase.getStatus().intValue() == DataStatus.DELETE.getValue()) {
            throw new BussinessException((UniverseErrorCode)SignupErrorCode.SIGNUP_CANCEL);
        }
        if (!ParamValidateUtils.validateMobile((String)mobile)) {
            throw new BussinessException((UniverseErrorCode)SignupErrorCode.MOBILE_FORMATE_ERROR);
        }
        if (purchase == null || !purchase.getOrgId().equals(orgId)) {
            throw new BussinessException((UniverseErrorCode)SignupErrorCode.PURCHASE_ID_INVALIDATE);
        }
        if (purchase.getPurchaseStatus().intValue() == PayResult.SUCCESS.getCode()) {
            throw new BussinessException((UniverseErrorCode)SignupErrorCode.PURCHASE_ID_ALREADY_PAY_SUCC);
        }
        if (purchase.getSplitResult().intValue() == SplitCourseResult.NOT_COMMIT.getCode()) {
            throw new BussinessException((UniverseErrorCode)SignupErrorCode.SIGNUP_HAS_NOT_COURSE_INFO);
        }
        int count = this.orgSignupOninePayDao.countByMobileAndPurchaseId(signupPurchaseId, mobile, DateUtils.getToday());
        String maxCountStr = UrlProperties.getProperty((String)"max.signup.count");
        int maxCount = 3;
        if (StringUtils.isNumeric((String)maxCountStr)) {
            maxCount = Integer.parseInt(maxCountStr);
        }
        if (count >= maxCount) {
            throw new BussinessException((UniverseErrorCode)SignupErrorCode.SEND_SMS_COUNT_TOO_SOON);
        }
        Long payPurchaseId = purchase.getPayPurchaseId() == 0L ? signupPurchaseId : purchase.getPayPurchaseId();
        OrgSignupOnlinePay onlinePay = new OrgSignupOnlinePay();
        onlinePay.setCreateTime(new Date());
        onlinePay.setPurchaseId(payPurchaseId);
        onlinePay.setOrgId(orgId);
        onlinePay.setToMobile(mobile);
        String smsKey = MD5Utils.MD5((String)("TTS_SIGNUP_KEY" + payPurchaseId + mobile + System.currentTimeMillis()));
        onlinePay.setSmsKey(smsKey);
        this.orgSignupOninePayDao.save((Object)onlinePay, new String[0]);
        purchase.setPayType(Integer.valueOf(PayType.ONLINE_PAYMENT.getCode()));
        this.orgSignupInfoDao.update((Object)purchase, new String[]{"payType"});
        return this.commonMsgService.sendTxSms(orgId, orgId, Integer.valueOf(UserRole.ORGANIZATION.getRole()), null, null, TxSmsCodeType.SIGNUP_PAY_SMS_CONTENT_SIGNAL_TEMPLATE, onlinePay.getId(), mobile, this.buildSmsContent(purchase, smsKey));
    }

    private String buildSmsContent(OrgSignupInfo purchase, String smsKey) {
        log.debug("buildSmsContent  purchaseId = {}", (Object)purchase.getSignupPurchaseId());
        List courses = this.orgSignupCourseDao.loadByPurchaseId(purchase.getSignupPurchaseId(), new String[]{"orgCourseId", "originPrice", "payPrice"});
        HashSet courseIds = Sets.newHashSet();
        CollectionUtils.collect((Iterable)courses, (Transformer)new Transformer<OrgSignupCourse, Long>(){

            public Long transform(OrgSignupCourse input) {
                return input.getOrgCourseId();
            }
        }, (Collection)courseIds);
        Map courseName = this.orgCourseDao.getCourseNameMap((Collection)courseIds);
        log.debug("courseIds = {} courseName={}", (Object)courseIds, (Object)courseName);
        String orgName = this.orgInfoDao.getOrgShortNameByOrgId(Integer.valueOf(purchase.getOrgId().intValue()));
        String cName = null;
        String showCourseName = null;
        for (OrgSignupCourse course : courses) {
            if (cName != null) continue;
            cName = "\u300e" + (String)courseName.get(course.getOrgCourseId()) + "\u300f";
            showCourseName = (String)courseName.get(course.getOrgCourseId());
        }
        String h5Url = ShortUrlUtil.getShortUrl((String)(UrlProperties.getProperty((String)"signup.online.pay.url") + "?smsKey=" + smsKey));
        return SmsContentHelper.createSignupPaySmsMsg(showCourseName, (String)orgName, (String)h5Url, (int)courseName.size());
    }

    private Map<Long, List<String>> getCourseIdTeacherNamesMap(Collection<Long> courseIds) {
        List orgCourseTeachers = this.orgCourseTeacherDao.getOrgCourseTeacher(courseIds, null);
        if (CollectionUtils.isNotEmpty((Collection)orgCourseTeachers)) {
            HashMap result = Maps.newHashMap();
            HashSet teacherIds = Sets.newHashSet();
            for (OrgCourseTeacher orgCourseTeacher : orgCourseTeachers) {
                teacherIds.add(orgCourseTeacher.getUserId());
            }
            Map teacherNames = this.teacherDao.getTeacherRealNameMap((Collection)teacherIds);
            for (OrgCourseTeacher orgCourseTeacher : orgCourseTeachers) {
                String name;
                Long courseId = orgCourseTeacher.getOrgCourseId();
                if (!result.containsKey(courseId)) {
                    result.put(courseId, Lists.newArrayList());
                }
                if ((name = (String)teacherNames.get(orgCourseTeacher.getUserId())) == null) continue;
                ((List)result.get(courseId)).add(name);
            }
            return result;
        }
        return Collections.emptyMap();
    }

    @Override
    public OrgSingupInfoDto getCourseInfo(Collection<Header> headers, Long signupPurchaseId, Long orgId, Integer cascadeId) {
        OrgSignupOnlinePay onlinePayRecord;
        OrgSignupInfo orgSignupInfo = this.orgSignupInfoDao.searchByPurchaseId(signupPurchaseId, new String[0]);
        if (orgSignupInfo == null) {
            byte[] content = this.getContent(RedisKeyEnums.CW.TIANXIAO_SIGNUP_REDIS_PRE.getRedisKey() + signupPurchaseId);
            if (content != null) {
                orgSignupInfo = (OrgSignupInfo)SerializeUtil.unserialize((byte[])content);
            }
        } else {
            orgSignupInfo.setOrgSignupCourses(this.orgSignupCourseDao.loadByPurchaseId(signupPurchaseId, new String[0]));
        }
        boolean isShowMobile = this.txCascadeCredentialService.isShowMobile(orgId, cascadeId);
        if (orgSignupInfo == null) {
            log.warn("orgSignupInfo is null signupPurchaseId:{}", (Object)signupPurchaseId);
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u975e\u62a5\u540d\u8ba2\u5355\u8bb0\u5f55");
        }
        OrgSingupInfoDto dto = this.buildOrgSignupInfoDto(orgSignupInfo, isShowMobile, false);
        if (orgSignupInfo.getPurchaseStatus().intValue() != PayResult.SUCCESS.getCode() && orgSignupInfo.getTotalPrices().doubleValue() > 0.0) {
            log.info("get new TradeNo while pay status is not success");
            String tradeNo = RestUtils.getTradeNo((Long)orgSignupInfo.getOrgId(), (Long)orgSignupInfo.getSignupPurchaseId(), (Double)(orgSignupInfo.getTotalPrices().doubleValue() / 100.0), headers);
            dto.setTradeNo(tradeNo);
            String payUrlWinxin = RestUtils.getWeiXinPurchaseUrl((Long)signupPurchaseId, (Long)orgSignupInfo.getOrgId(), (Double)(orgSignupInfo.getTotalPrices().doubleValue() / 100.0), headers);
            dto.setPayUrlWinxin(payUrlWinxin);
        }
        if ((onlinePayRecord = this.orgSignupOninePayDao.getLastRecordByPurchaseId(signupPurchaseId, new String[]{"createTime"})) != null) {
            dto.setLastSendTime(onlinePayRecord.getCreateTime());
        }
        log.debug("signup info detail == {}", (Object)dto);
        return dto;
    }

    @Override
    public PaymentResultDto getPaymentResultDto(Long signupPurchaseId) throws BussinessException, Exception {
        PayResultDto payResultDto = RestUtils.getSignupPayResultDto((Long)signupPurchaseId);
        PaymentResultDto dto = new PaymentResultDto();
        dto.setCourseName(payResultDto.getCourseName());
        dto.setPaymentMethod(payResultDto.getPayTypeStr());
        dto.setPaymentTime(payResultDto.getPayTime());
        dto.setTotalPrice(payResultDto.getTotalPrice());
        dto.setStatus(payResultDto.getStatus());
        dto.setCount(payResultDto.getCount() == null ? 0 : payResultDto.getCount());
        OrgSignupInfo orgSignupInfo = this.orgSignupInfoDao.searchByPurchaseId(signupPurchaseId, new String[0]);
        dto.setStudentMobile(orgSignupInfo.getMobile());
        dto.setStudentName(orgSignupInfo.getStudentName());
        return dto;
    }

    @Override
    public void updateSignupRemark(Long signupPurchaseId, String remark) {
        OrgSignupInfo orgSignupInfo = this.orgSignupInfoDao.searchByPurchaseId(signupPurchaseId, new String[0]);
        if (orgSignupInfo != null) {
            orgSignupInfo.setRemark(remark);
            orgSignupInfo.setUpdateTime(orgSignupInfo.getUpdateTime());
            this.orgSignupInfoDao.saveOrUpdateSignupInfo(orgSignupInfo);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void cancelSignupInfo(Long signupPurchaseId, Long orgId) throws BussinessException {
        OrgSignupInfo orgSignupInfo = this.orgSignupInfoDao.searchByPurchaseId(signupPurchaseId, new String[]{"id", "signupPurchaseId", "orderType"});
        if (orgSignupInfo == null) {
            throw new BussinessException((UniverseErrorCode)SignupErrorCode.PURCHASEID_ERROR);
        }
        orgSignupInfo.setStatus(Integer.valueOf(DeleteStatus.DELETED.getValue()));
        orgSignupInfo.setUpdateTime(new Date());
        this.orgSignupInfoDao.update((Object)orgSignupInfo, Boolean.valueOf(false), new String[]{"status", "updateTime"});
        List signupCourses = this.orgSignupCourseDao.loadByPurchaseId(signupPurchaseId, new String[0]);
        for (OrgSignupCourse orgSignupCourse : signupCourses) {
            orgSignupCourse.setStatus(Integer.valueOf(DataStatus.DELETE.getValue()));
            orgSignupCourse.setSyncLessonCount(Integer.valueOf(DataStatus.NORMAL.getValue()));
            this.orgSignupCourseDao.update((Object)orgSignupCourse, new String[]{"status", "syncLessonCount"});
        }
        if (orgSignupInfo.getOrderType().intValue() == TransferClassOrder.TRANSFER_ORDER.getCode()) {
            this.transferClassInfoService.cancelTransferClassByPurchase(orgSignupInfo.getSignupPurchaseId());
        }
    }

    @Override
    public OrgSignupInfo changeSignupStudentPrice(Long orgId, Long signupPurchaseId, Integer opType, Long studentPayMoney) throws BussinessException {
        Preconditions.checkNotNull((Object)(opType == StudentFiannceOpType.SIGNUP_PAY.getCode() || opType == StudentFiannceOpType.PAY_CANCEL.getCode() ? 1 : 0), (Object)"orgId may not be null");
        OrgSignupInfo orgSignupInfo = this.orgSignupInfoDao.getByPurchaseId(orgId, signupPurchaseId);
        if (orgSignupInfo == null) {
            throw new BussinessException((UniverseErrorCode)SignupErrorCode.PURCHASEID_ERROR);
        }
        log.info("changeSignupStudentPrice=={},studentPayMoney={}", (Object)orgSignupInfo, (Object)studentPayMoney);
        if (opType == StudentFiannceOpType.SIGNUP_PAY.getCode() && (orgSignupInfo.getStudentPayPrice().intValue() > 0 || (long)orgSignupInfo.getTotalPrices().intValue() < studentPayMoney)) {
            throw new BussinessException((UniverseErrorCode)SignupErrorCode.STUDENT_PAY_ERROR);
        }
        if (opType == StudentFiannceOpType.PAY_CANCEL.getCode() && (orgSignupInfo.getStudentPayPrice().intValue() == 0 || orgSignupInfo.getStudentPayPrice().longValue() != studentPayMoney.longValue())) {
            throw new BussinessException((UniverseErrorCode)SignupErrorCode.STUDENT_PAY_ERROR);
        }
        List signupCourses = this.orgSignupCourseDao.loadByPurchaseId(signupPurchaseId, new String[0]);
        if (TransferClassOrder.hasSignupCourse((Integer)orgSignupInfo.getOrderType()) && CollectionUtils.isEmpty((Collection)signupCourses)) {
            throw new BussinessException((UniverseErrorCode)SignupErrorCode.SIGNUP_HAS_NOT_COURSE_INFO);
        }
        if (opType == StudentFiannceOpType.SIGNUP_PAY.getCode()) {
            orgSignupInfo.setStudentPayPrice(studentPayMoney);
            orgSignupInfo.setTotalPrices(Long.valueOf(orgSignupInfo.getTotalPrices() - studentPayMoney));
            if (orgSignupInfo.getTotalPrices().doubleValue() == 0.0) {
                orgSignupInfo.setPurchaseStatus(OrgSinupPurchaseStatus.DEAL_DONE.getCode());
                orgSignupInfo.setSplitResult(Integer.valueOf(SplitCourseResult.SUCCESS.getCode()));
                orgSignupInfo.setPayType(Integer.valueOf(PayType.TX_STUDENT_PAY.getCode()));
                orgSignupInfo.setPayTime(new Date());
            }
        } else if (opType == StudentFiannceOpType.PAY_CANCEL.getCode()) {
            orgSignupInfo.setStudentPayPrice(Long.valueOf(0L));
            orgSignupInfo.setTotalPrices(Long.valueOf(orgSignupInfo.getTotalPrices() + studentPayMoney));
        } else {
            throw new BussinessException((UniverseErrorCode)SignupErrorCode.STUDENT_PAY_ERROR);
        }
        if (orgSignupInfo.getTotalPrices() > 0L) {
            Long newPurchaseId = RestUtils.getPurchaseId((Long)orgId, (Double)(orgSignupInfo.getTotalPrices().doubleValue() / 100.0), null);
            Long newTradeNo = Long.valueOf(RestUtils.getTradeNo((Long)orgId, (Long)newPurchaseId, (Double)(orgSignupInfo.getTotalPrices().doubleValue() / 100.0), null));
            orgSignupInfo.setPayPurchaseId(newPurchaseId);
            orgSignupInfo.setTradeNo(newTradeNo);
            String payUrlWinxin = RestUtils.getWeiXinPurchaseUrl((Long)signupPurchaseId, (Long)orgSignupInfo.getOrgId(), (Double)(orgSignupInfo.getTotalPrices().doubleValue() / 100.0), SignupServiceImpl.buildHeaders());
            orgSignupInfo.setPayUrlWinxin(payUrlWinxin);
        }
        orgSignupInfo.setUpdateTime(new Date());
        log.info("WSignup service changeSignupStudentPrice=signupinfo=={}", (Object)orgSignupInfo);
        this.orgSignupInfoDao.update((Object)orgSignupInfo, new String[0]);
        Long surplusStudentMoney = studentPayMoney;
        ArrayList signupCourseList = Lists.newArrayList();
        for (OrgSignupCourse orgSignupCourse : signupCourses) {
            if (surplusStudentMoney > 0L) {
                if (surplusStudentMoney - orgSignupCourse.getPayPrice() >= 0L) {
                    surplusStudentMoney = surplusStudentMoney - orgSignupCourse.getPayPrice();
                    orgSignupCourse.setStudentPayPrice(orgSignupCourse.getPayPrice());
                    orgSignupCourse.setPayPrice(Long.valueOf(0L));
                } else {
                    orgSignupCourse.setStudentPayPrice(surplusStudentMoney);
                    orgSignupCourse.setPayPrice(Long.valueOf(orgSignupCourse.getPayPrice() - surplusStudentMoney));
                    surplusStudentMoney = 0L;
                }
            }
            log.info("WSignup service changeSignupStudentPrice=orgSignupCourse=={}", (Object)orgSignupCourse);
            this.orgSignupCourseDao.update((Object)orgSignupCourse, new String[]{"signupPurchaseId", "studentPayPrice", "payPrice", "updateTime"});
            signupCourseList.add(orgSignupCourse);
        }
        orgSignupInfo.setOrgSignupCourses((List)signupCourseList);
        this.saveContent(RedisKeyEnums.CW.TIANXIAO_SIGNUP_REDIS_PRE.getRedisKey() + signupPurchaseId, SerializeUtil.serialize((Object)orgSignupInfo));
        return orgSignupInfo;
    }

    @Override
    public OrgSingupInfoDto detailByPurchaseId(Long orgId, Long signupPurchaseId) throws BussinessException {
        Preconditions.checkNotNull((Object)signupPurchaseId, (Object)"\u8ba2\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        OrgSignupInfo orgSignupInfo = this.orgSignupInfoDao.searchByPurchaseId(signupPurchaseId, new String[0]);
        if (orgSignupInfo == null) {
            byte[] bytes = this.getContent(RedisKeyEnums.CW.TIANXIAO_SIGNUP_REDIS_PRE.getRedisKey() + signupPurchaseId);
            if (bytes == null || bytes.length == 0) {
                return null;
            }
            orgSignupInfo = (OrgSignupInfo)SerializeUtil.unserialize((byte[])bytes);
        } else {
            orgSignupInfo.setOrgSignupCourses(this.orgSignupCourseDao.loadByPurchaseId(signupPurchaseId, new String[0]));
        }
        return this.buildOrgSignupInfoDto(orgSignupInfo, true, false);
    }

    @Override
    public void signupSuccess(Long orgId, Long signupPurchaseId, Integer payType, Integer refundType) {
        OrgSignupInfo orgSignupInfo = this.orgSignupInfoDao.searchByPurchaseId(signupPurchaseId, new String[0]);
        orgSignupInfo.setPurchaseStatus(OrgSinupPurchaseStatus.DEAL_DONE.getCode());
        orgSignupInfo.setSplitResult(Integer.valueOf(SplitCourseResult.SUCCESS.getCode()));
        orgSignupInfo.setPayType(payType);
        orgSignupInfo.setTransferRefundType(refundType);
        orgSignupInfo.setPayTime(new Date());
        this.orgSignupInfoDao.update((Object)orgSignupInfo, new String[0]);
    }

    @Override
    public void syncClassId(PageDto pageDto) {
        List courseList = this.orgSignupCourseDao.getByPage(pageDto, new String[0]);
        for (OrgSignupCourse course : courseList) {
            course.getOrgCourseId();
        }
    }

    @Override
    public List<TransferClassRecordDto> listTransferClassRecordes(Long orgId, Long signupPurchaseId, Long orgCourseId) {
        List<TransferClassListDto> listTransferInfo = this.transferClassInfoService.listTransferInfo(orgId, signupPurchaseId, orgCourseId);
        ArrayList ret = Lists.newArrayList();
        if (GenericsUtils.notNullAndEmpty(listTransferInfo)) {
            for (TransferClassListDto tcld : listTransferInfo) {
                TransferClassRecordDto instance = TransferClassRecordDto.instance(tcld);
                OrgSignupStorageResponseDto orgSignupStorageBySignupPurchaseId = this.orgSignupStorageService.getOrgSignupStorageBySignupPurchaseId(orgId, tcld.getInSignupPurchaseId());
                if (orgSignupStorageBySignupPurchaseId != null) {
                    instance.setRemark(orgSignupStorageBySignupPurchaseId.getRemark());
                    instance.setImageList(orgSignupStorageBySignupPurchaseId.getList());
                }
                ret.add(instance);
            }
        }
        return ret;
    }

    private void fillPayType(OrgSingupInfoDto dto, OrgSignupInfo orgSignupInfo) {
        int payType = PayType.getCodeByPayType((int)orgSignupInfo.getPayType());
        if (payType == PayType.CASH.getCode()) {
            dto.setCashPayPrice(dto.getTotalPrice());
        } else if (payType == PayType.PAY_POS_CARD.getCode()) {
            dto.setPosPayPrice(dto.getTotalPrice());
        } else {
            dto.setOnlinePayPrice(dto.getTotalPrice());
        }
        dto.setSourceType(orgSignupInfo.getSourceType().intValue() == SignupSourceType.TX_SIANGUP.getCode().intValue() ? SignupSourceType.SIGNUP.getCode() : orgSignupInfo.getSourceType());
        dto.setPayResultEnum(PayResult.getPayResultByCode((Integer)orgSignupInfo.getPurchaseStatus()));
        dto.setPayTypeEnum(PayType.getPayTypeByCode((Integer)orgSignupInfo.getPayType()));
        dto.setSignupTypeEnum(SignupType.getTypeByCode((Integer)orgSignupInfo.getSignupType()));
    }

    private void fillTransferQuitClass(OrgSingupInfoDto dto, OrgSignupInfo orgSignupInfo, boolean downLoadRequest) {
        List<TransferClassListDto> transferClassListDtoList;
        if (!downLoadRequest && CollectionUtils.isNotEmpty(transferClassListDtoList = this.transferClassInfoService.listTransferInfo(orgSignupInfo.getOrgId(), orgSignupInfo.getSignupPurchaseId(), null)) && transferClassListDtoList.size() > 0) {
            dto.setTransferClass(1);
        }
    }

    private void fillTransferClassOrder(OrgSingupInfoDto dto, OrgSignupInfo orgSignupInfo) {
        dto.setTransferClassOrder(orgSignupInfo.getOrderType());
        if (dto.getTransferClassOrder() == TransferClassOrder.TRANSFER_ORDER.getCode()) {
            dto.setTransferRefundType(orgSignupInfo.getTransferRefundType());
            dto.setTransferClassMoney(orgSignupInfo.getTransferClassMoney().doubleValue() / 100.0);
            dto.setTransferRefundMoney(orgSignupInfo.getTransferRefundMoney().doubleValue() / 100.0);
            if (dto.getTransferRefundMoney() > 0.0) {
                dto.setTransferType(TransferClassResult.NEED_REFUND.getStatus());
            } else if (dto.getTotalPrice() + dto.getStudentPayPrice() > 0.0) {
                dto.setTransferType(TransferClassResult.NEED_PAY.getStatus());
            } else {
                dto.setTransferType(TransferClassResult.SUCCESS.getStatus());
            }
            if (orgSignupInfo.getCreateTime() != null) {
                dto.setPurchaseEndTime(DateUtil.getDiffMinute((Date)orgSignupInfo.getCreateTime(), (int)15));
            }
        } else if (orgSignupInfo.getCreateTime() != null) {
            dto.setPurchaseEndTime(DateUtil.getDiffDateTime((Date)orgSignupInfo.getCreateTime(), (int)7));
        }
    }

    private void fillSignupStudentInfo(OrgSingupInfoDto dto, OrgSignupInfo orgSignupInfo, boolean isShowMobile) {
        OrgStudent orgStudent;
        dto.setStudentId(orgSignupInfo.getUserId());
        dto.setUserId(orgSignupInfo.getUserId());
        dto.setStudentName(orgSignupInfo.getStudentName());
        dto.setStudentMobile(orgSignupInfo.getMobile());
        if (!isShowMobile) {
            dto.setStudentMobile(MaskUtil.maskMobile((String)dto.getStudentMobile()));
        }
        if (orgSignupInfo.getUserId() != null && orgSignupInfo.getUserId() > 0L && (orgStudent = this.orgStudentDao.getStudent(orgSignupInfo.getOrgId(), orgSignupInfo.getUserId(), Integer.valueOf(DataStatus.NORMAL.getValue()), new String[0])) != null) {
            TxStudentFinanceAccount txStudentFinanceAccount;
            OrgStorage storage;
            if (orgStudent.getAvatar() != null && (storage = this.orgStorageDao.getById(orgStudent.getAvatar().intValue())) != null) {
                String url = StorageUtil.constructUrl((String)storage.getFid(), (String)storage.getSn(), (Integer)storage.getMimeType());
                dto.setStudentAvatar(url);
            }
            if (dto.getStudentAvatar() == null) {
                dto.setStudentAvatar(AvatarUtil.getUserAvatar((long)orgStudent.getId()));
            }
            if ((txStudentFinanceAccount = this.txStudentFinanceAccountDao.getFinanceAccount(orgSignupInfo.getOrgId(), orgStudent.getId())) != null) {
                dto.setStudentAccountBalance(txStudentFinanceAccount.getBalance().doubleValue() / 100.0);
            }
        }
    }

    private Long getOrgNumber(Long orgId) {
        OrgAccount account = this.orgAccountDao.getAccountById(orgId.intValue(), new String[]{"number"});
        if (account == null) {
            return null;
        }
        Integer number = account.getNumber();
        return number != null ? Long.valueOf(number.longValue()) : null;
    }

    private static Collection<Header> buildHeaders() {
        ArrayList headers = Lists.newArrayList();
        BasicHeader header = new BasicHeader("X-FORWARDED-FOR", "");
        headers.add(header);
        return headers;
    }

    private boolean saveContent(String MKEY, byte[] contents) {
        return this.redisDefaultService.setWithExpire(MKEY, contents, 600L);
    }

    private byte[] getContent(String MKEY) {
        return this.redisDefaultService.get(MKEY);
    }
}

