/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.signup.service.Impl;

import com.baijia.tianxiao.constants.signup.PayResult;
import com.baijia.tianxiao.dal.org.constant.OrgImgType;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupInfoDao;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupOnlinePayDao;
import com.baijia.tianxiao.dal.signup.po.OrgSignupInfo;
import com.baijia.tianxiao.dal.signup.po.OrgSignupOnlinePay;
import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sal.organization.org.service.OrgPhotoService;
import com.baijia.tianxiao.sal.signup.dto.response.OrgSingupInfoDto;
import com.baijia.tianxiao.sal.signup.service.SignupOnlinePayService;
import com.baijia.tianxiao.sal.signup.service.SignupService;
import com.baijia.tianxiao.util.mobile.MaskUtil;
import java.util.Calendar;
import java.util.Collection;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SignupOnlinePayServiceImpl
implements SignupOnlinePayService {
    private static final Logger log = LoggerFactory.getLogger(SignupOnlinePayServiceImpl.class);
    @Resource
    private OrgPhotoService orgPhotoService;
    @Resource
    private SignupService signupService;
    @Resource
    private OrgSignupOnlinePayDao orgSignupOnlinePayDao;
    @Resource
    private OrgSignupInfoDao orgSignupInfoDao;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public OrgSingupInfoDto loadSignupInfoBySmsKey(String smsKey, Collection<Header> headers) throws BussinessException {
        if (StringUtils.isBlank((CharSequence)smsKey)) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u77ed\u4fe1\u9a8c\u8bc1\u7801\u9519\u8bef,\u8bf7\u91cd\u65b0\u6253\u5f00\u94fe\u63a5");
        }
        try {
            OrgSignupOnlinePay onlinePay = this.orgSignupOnlinePayDao.getBySmsKey(smsKey, new String[0]);
            if (onlinePay == null) {
                throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u65e0\u6cd5\u627e\u5230\u8ba2\u5355,\u8bf7\u91cd\u65b0\u53d1\u9001\u77ed\u4fe1");
            }
            int maxSuriveDay = 3;
            OrgSignupInfo signupInfo = this.orgSignupInfoDao.searchByPayPurchaseId(onlinePay.getPurchaseId(), false, new String[]{"signupPurchaseId", "purchaseStatus"});
            if (signupInfo.getPurchaseStatus().intValue() != PayResult.SUCCESS.getCode()) {
                boolean isSuccess = this.signupService.isPurchaseSucce(onlinePay.getPurchaseId(), onlinePay.getOrgId(), signupInfo.getCascadeId());
                log.info("Signup info sms key = {},{},{}", new Object[]{onlinePay, signupInfo, isSuccess});
                if (!isSuccess) {
                    Calendar cal = Calendar.getInstance();
                    cal.add(5, 0 - maxSuriveDay);
                    if (onlinePay.getCreateTime().before(cal.getTime())) {
                        throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u77ed\u4fe1\u94fe\u63a5\u5df2\u7ecf\u8fc7\u671f,\u8bf7\u91cd\u65b0\u83b7\u53d6");
                    }
                }
            }
            OrgSingupInfoDto dto = this.signupService.getCourseInfo(headers, signupInfo.getSignupPurchaseId(), onlinePay.getOrgId(), signupInfo.getCascadeId());
            dto.setSignupPurchaseId(dto.getPayPurchaseId());
            dto.setOrgLogoUrl(this.orgPhotoService.getPhotoUrlByOrgIdAndCategory(onlinePay.getOrgId(), OrgImgType.ORG_LOGO));
            dto.setStudentMobile(MaskUtil.maskMobile((String)dto.getStudentMobile()));
            dto.setOrgId(null);
            dto.setStudentId(null);
            return dto;
        }
        catch (BussinessException e) {
            e.printStackTrace();
            log.warn("parse json:{} to object catch error:{}", (Object)smsKey, (Object)e);
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, e.getMessage());
        }
    }
}

