/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.signup.service.Impl;

import com.baijia.tianxiao.dal.constant.ChargeMode;
import com.baijia.tianxiao.dal.constant.ChargeUnit;
import com.baijia.tianxiao.dal.org.dao.OrgCourseDao;
import com.baijia.tianxiao.dal.org.po.OrgCourse;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupCourseDao;
import com.baijia.tianxiao.dal.signup.po.OrgSignupCourse;
import com.baijia.tianxiao.sal.signup.dto.SignupCourseInfoDto;
import com.baijia.tianxiao.sal.signup.service.SignupCourseService;
import com.baijia.tianxiao.util.BaseUtils;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;

@Service
public class SignupCourseServiceImpl
implements SignupCourseService {
    @Resource
    private OrgSignupCourseDao orgSignupCourseDao;
    @Resource
    private OrgCourseDao orgCourseDao;

    @Override
    public List<SignupCourseInfoDto> getBySignupPurchasaeId(Long signupPurchaseId) {
        Preconditions.checkNotNull((Object)signupPurchaseId, (Object)"\u8ba2\u5355\u53f7\u4e0d\u4e3a\u7a7a");
        List signupCourseList = this.orgSignupCourseDao.loadByPurchaseId(signupPurchaseId, new String[0]);
        if (CollectionUtils.isEmpty((Collection)signupCourseList)) {
            return Collections.EMPTY_LIST;
        }
        List courseIds = BaseUtils.getListFilter((List)signupCourseList, (String)"orgCourseId");
        Map courseMap = this.orgCourseDao.getOrgCourseMap((Collection)courseIds, new String[0]);
        ArrayList result = Lists.newArrayList();
        for (OrgSignupCourse orgSignupCourse : signupCourseList) {
            result.add(this.buildOrgSignupCourseDto(orgSignupCourse, (OrgCourse)courseMap.get(orgSignupCourse.getOrgCourseId())));
        }
        return result;
    }

    private SignupCourseInfoDto buildOrgSignupCourseDto(OrgSignupCourse orgSignupCourse, OrgCourse orgCourse) {
        SignupCourseInfoDto dto = new SignupCourseInfoDto();
        dto.setCount(orgSignupCourse.getCount());
        dto.setDiscount(orgSignupCourse.getCourseDiscount());
        dto.setOrgId(orgSignupCourse.getOrgId());
        dto.setUserId(orgSignupCourse.getUserId());
        dto.setOrgCourseId(orgSignupCourse.getOrgCourseId());
        dto.setClassId(orgSignupCourse.getClassId());
        dto.setCoursePrice((double)orgCourse.getPrice());
        dto.setOriginPrice(orgSignupCourse.getOriginPrice().doubleValue() / 100.0);
        double preferential = ((100.0 - orgSignupCourse.getCourseDiscount().doubleValue()) / 100.0 * (double)orgSignupCourse.getOriginPrice().intValue() * (double)orgSignupCourse.getCount().intValue() + (double)orgSignupCourse.getPreferential().intValue()) / 100.0;
        dto.setPreferential(preferential);
        dto.setRealPayPrice((double)orgSignupCourse.getPayPrice().longValue() / 100.0);
        dto.setPayPrice(orgSignupCourse.getPayPrice().doubleValue() / 100.0);
        dto.setOrgCourseName(orgCourse == null ? "" : orgCourse.getName());
        dto.setOrgCourseNumber(orgCourse == null ? 0L : orgCourse.getNumber());
        dto.setFreq(orgCourse == null || orgCourse.getFreq() == null ? 0 : orgCourse.getFreq());
        dto.setTotalPrice(orgSignupCourse.getTotalPayPrice().doubleValue() / 100.0);
        if (orgCourse != null) {
            dto.setCourseType(orgCourse.getCourseType());
            dto.setChargeType(orgCourse.getChargeType());
        }
        dto.setChargeUnit(orgSignupCourse.getChargeUnit());
        dto.setChargeMode(ChargeMode.getByCharegeUnit((Integer)orgSignupCourse.getChargeUnit()).getCode());
        dto.setStudentPayPrice(orgSignupCourse.getStudentPayPrice().doubleValue() / 100.0);
        dto.setLessonCount(orgSignupCourse.getLessonCount() == null ? 0 : orgSignupCourse.getLessonCount());
        dto.setStatus(orgSignupCourse.getStatus());
        return dto;
    }

    @Override
    public Integer sumAllLessonCount(Long orgId, Long orgCourseId, Long userId, List<Integer> status, String ... queryProps) {
        List signupCourseList = this.orgSignupCourseDao.sumAllLessonCount(orgId, orgCourseId, userId, status, queryProps);
        if (CollectionUtils.isEmpty((Collection)signupCourseList)) {
            return 0;
        }
        Integer sumCount = 0;
        for (OrgSignupCourse signupCourse : signupCourseList) {
            if (signupCourse.getChargeUnit().intValue() == ChargeUnit.BY_HOUR.getCode()) {
                sumCount = sumCount + signupCourse.getLessonCount() * 60;
                continue;
            }
            if (signupCourse.getChargeUnit().intValue() == ChargeUnit.BY_HALF_HOUR.getCode()) {
                sumCount = sumCount + signupCourse.getLessonCount() * 30;
                continue;
            }
            if (signupCourse.getChargeUnit().intValue() == ChargeUnit.BY_MINUTE.getCode()) {
                sumCount = sumCount + signupCourse.getLessonCount();
                continue;
            }
            sumCount = sumCount + signupCourse.getLessonCount();
        }
        return sumCount;
    }
}

