/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.signup.dto.response;

import com.baijia.tianxiao.dal.finance.po.TxStudentFinanceAccount;
import com.baijia.tianxiao.sal.signup.dto.BalanceChangeRecord;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StudentBalanceResponseDto {
    private static final Logger log = LoggerFactory.getLogger(StudentBalanceResponseDto.class);
    private Long studentId;
    private String studentName;
    private String studentAvatar;
    private String mobile;
    private double balance;
    private List<BalanceChangeRecord> records;
    private String showInfo = "\u53ef\u5728\u7535\u8111\u7aef\u3010\u8d44\u91d1\u7ba1\u7406\u3011\u4e3a\u5b66\u5458\u8fdb\u884c\u9000\u6b3e";

    public static StudentBalanceResponseDto newInstance(TxStudentFinanceAccount financeAccount, List<BalanceChangeRecord> records) {
        log.info("financeAccount is :{}", (Object)financeAccount);
        StudentBalanceResponseDto sbrd = new StudentBalanceResponseDto();
        if (financeAccount != null) {
            sbrd.balance = (double)financeAccount.getBalance().longValue() / 100.0;
            sbrd.studentId = financeAccount.getStudentId();
        }
        sbrd.setRecords(records);
        return sbrd;
    }

    public Long getStudentId() {
        return this.studentId;
    }

    public String getStudentName() {
        return this.studentName;
    }

    public String getStudentAvatar() {
        return this.studentAvatar;
    }

    public String getMobile() {
        return this.mobile;
    }

    public double getBalance() {
        return this.balance;
    }

    public List<BalanceChangeRecord> getRecords() {
        return this.records;
    }

    public String getShowInfo() {
        return this.showInfo;
    }

    public void setStudentId(Long studentId) {
        this.studentId = studentId;
    }

    public void setStudentName(String studentName) {
        this.studentName = studentName;
    }

    public void setStudentAvatar(String studentAvatar) {
        this.studentAvatar = studentAvatar;
    }

    public void setMobile(String mobile) {
        this.mobile = mobile;
    }

    public void setBalance(double balance) {
        this.balance = balance;
    }

    public void setRecords(List<BalanceChangeRecord> records) {
        this.records = records;
    }

    public void setShowInfo(String showInfo) {
        this.showInfo = showInfo;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StudentBalanceResponseDto)) {
            return false;
        }
        StudentBalanceResponseDto other = (StudentBalanceResponseDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$studentId = this.getStudentId();
        Long other$studentId = other.getStudentId();
        if (this$studentId == null ? other$studentId != null : !((Object)this$studentId).equals(other$studentId)) {
            return false;
        }
        String this$studentName = this.getStudentName();
        String other$studentName = other.getStudentName();
        if (this$studentName == null ? other$studentName != null : !this$studentName.equals(other$studentName)) {
            return false;
        }
        String this$studentAvatar = this.getStudentAvatar();
        String other$studentAvatar = other.getStudentAvatar();
        if (this$studentAvatar == null ? other$studentAvatar != null : !this$studentAvatar.equals(other$studentAvatar)) {
            return false;
        }
        String this$mobile = this.getMobile();
        String other$mobile = other.getMobile();
        if (this$mobile == null ? other$mobile != null : !this$mobile.equals(other$mobile)) {
            return false;
        }
        if (Double.compare(this.getBalance(), other.getBalance()) != 0) {
            return false;
        }
        List<BalanceChangeRecord> this$records = this.getRecords();
        List<BalanceChangeRecord> other$records = other.getRecords();
        if (this$records == null ? other$records != null : !((Object)this$records).equals(other$records)) {
            return false;
        }
        String this$showInfo = this.getShowInfo();
        String other$showInfo = other.getShowInfo();
        return !(this$showInfo == null ? other$showInfo != null : !this$showInfo.equals(other$showInfo));
    }

    protected boolean canEqual(Object other) {
        return other instanceof StudentBalanceResponseDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $studentId = this.getStudentId();
        result = result * 59 + ($studentId == null ? 43 : ((Object)$studentId).hashCode());
        String $studentName = this.getStudentName();
        result = result * 59 + ($studentName == null ? 43 : $studentName.hashCode());
        String $studentAvatar = this.getStudentAvatar();
        result = result * 59 + ($studentAvatar == null ? 43 : $studentAvatar.hashCode());
        String $mobile = this.getMobile();
        result = result * 59 + ($mobile == null ? 43 : $mobile.hashCode());
        long $balance = Double.doubleToLongBits(this.getBalance());
        result = result * 59 + (int)($balance >>> 32 ^ $balance);
        List<BalanceChangeRecord> $records = this.getRecords();
        result = result * 59 + ($records == null ? 43 : ((Object)$records).hashCode());
        String $showInfo = this.getShowInfo();
        result = result * 59 + ($showInfo == null ? 43 : $showInfo.hashCode());
        return result;
    }

    public String toString() {
        return "StudentBalanceResponseDto(studentId=" + this.getStudentId() + ", studentName=" + this.getStudentName() + ", studentAvatar=" + this.getStudentAvatar() + ", mobile=" + this.getMobile() + ", balance=" + this.getBalance() + ", records=" + this.getRecords() + ", showInfo=" + this.getShowInfo() + ")";
    }
}

