/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.signup.dto;

import com.baijia.tianxiao.dal.constant.ChargeType;
import com.baijia.tianxiao.dal.constant.ChargeUnit;
import com.baijia.tianxiao.sal.organization.finance.dto.SignupRefundResponse;
import com.baijia.tianxiao.util.NumberUtil;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class SignupCourseInfoDto
implements Serializable {
    private static final long serialVersionUID = 6811476720391997504L;
    public static final int NORMAT_SHOW_STATUS = 0;
    public static final int HAS_TRANS_COURSE_RECORD = 1;
    private Long orgId;
    private Long userId;
    private Long orgCourseId;
    private Long classId;
    private Long orgCourseNumber;
    private String orgCourseName;
    private Collection<String> teacherNames = Lists.newArrayList();
    private String teacherNameStr;
    private Double coursePrice;
    private Double originPrice;
    private String originPriceStr;
    private Double payPrice = 0.0;
    @JsonIgnore
    private Double realPayPrice = 0.0;
    private int discount = 100;
    private Integer realDiscount = -1;
    private double preferential;
    private Double roundUpMoney = 0.0;
    private int freq;
    private int count;
    private int courseType;
    private double poundage;
    private List<SignupRefundResponse> signupRefundDto;
    private double totalRefundMoney;
    private double profit;
    private double totalPrice;
    private Integer coverId;
    private String coverUrl;
    private Integer lessonCount;
    private Integer chargeType;
    private Integer chargeMode;
    private Integer chargeUnit;
    private Integer status;
    private Double studentPayPrice = 0.0;
    private String amount;
    private String realAmount;
    private String transferClassDeduction = "/";
    private String refundAmount;
    private int showTransferStatus = 0;
    private int transferClass;

    public void setOriginPrice(Double originPrice) {
        this.originPrice = originPrice;
        this.updateOriginPriceStr();
    }

    public void setFreq(int freq) {
        this.freq = freq;
        this.updateOriginPriceStr();
    }

    public void setChargeType(Integer chargeType) {
        this.chargeType = chargeType;
        this.updateOriginPriceStr();
    }

    public void setChargeUnit(Integer chargeUnit) {
        this.chargeUnit = chargeUnit;
        this.updateOriginPriceStr();
    }

    private void updateOriginPriceStr() {
        if (null == this.originPrice || null == this.chargeType || null == this.chargeUnit) {
            return;
        }
        if (this.chargeType == ChargeType.BY_PERIODS.getCode()) {
            if (0 == this.freq) {
                return;
            }
            this.originPriceStr = String.format("\uffe5%s/\u671f\uff08%s\u6b21\uff09", NumberUtil.get2FromDouble((double)this.originPrice), this.freq);
        } else if (this.chargeType == ChargeType.BY_CLASSHOUR.getCode()) {
            this.originPriceStr = ChargeUnit.isByTime((int)this.chargeUnit) ? String.format("\uffe5%s/\u5c0f\u65f6", NumberUtil.get2FromDouble((double)this.originPrice)) : String.format("\uffe5%s/\u6b21", NumberUtil.get2FromDouble((double)this.originPrice));
        } else if (this.chargeType == ChargeType.BY_OTHER.getCode()) {
            this.originPriceStr = "\uffe5" + NumberUtil.get2FromDouble((double)this.originPrice);
        }
    }

    public Long getOrgId() {
        return this.orgId;
    }

    public Long getUserId() {
        return this.userId;
    }

    public Long getOrgCourseId() {
        return this.orgCourseId;
    }

    public Long getClassId() {
        return this.classId;
    }

    public Long getOrgCourseNumber() {
        return this.orgCourseNumber;
    }

    public String getOrgCourseName() {
        return this.orgCourseName;
    }

    public Collection<String> getTeacherNames() {
        return this.teacherNames;
    }

    public String getTeacherNameStr() {
        return this.teacherNameStr;
    }

    public Double getCoursePrice() {
        return this.coursePrice;
    }

    public Double getOriginPrice() {
        return this.originPrice;
    }

    public String getOriginPriceStr() {
        return this.originPriceStr;
    }

    public Double getPayPrice() {
        return this.payPrice;
    }

    public Double getRealPayPrice() {
        return this.realPayPrice;
    }

    public int getDiscount() {
        return this.discount;
    }

    public Integer getRealDiscount() {
        return this.realDiscount;
    }

    public double getPreferential() {
        return this.preferential;
    }

    public Double getRoundUpMoney() {
        return this.roundUpMoney;
    }

    public int getFreq() {
        return this.freq;
    }

    public int getCount() {
        return this.count;
    }

    public int getCourseType() {
        return this.courseType;
    }

    public double getPoundage() {
        return this.poundage;
    }

    public List<SignupRefundResponse> getSignupRefundDto() {
        return this.signupRefundDto;
    }

    public double getTotalRefundMoney() {
        return this.totalRefundMoney;
    }

    public double getProfit() {
        return this.profit;
    }

    public double getTotalPrice() {
        return this.totalPrice;
    }

    public Integer getCoverId() {
        return this.coverId;
    }

    public String getCoverUrl() {
        return this.coverUrl;
    }

    public Integer getLessonCount() {
        return this.lessonCount;
    }

    public Integer getChargeType() {
        return this.chargeType;
    }

    public Integer getChargeMode() {
        return this.chargeMode;
    }

    public Integer getChargeUnit() {
        return this.chargeUnit;
    }

    public Integer getStatus() {
        return this.status;
    }

    public Double getStudentPayPrice() {
        return this.studentPayPrice;
    }

    public String getAmount() {
        return this.amount;
    }

    public String getRealAmount() {
        return this.realAmount;
    }

    public String getTransferClassDeduction() {
        return this.transferClassDeduction;
    }

    public String getRefundAmount() {
        return this.refundAmount;
    }

    public int getShowTransferStatus() {
        return this.showTransferStatus;
    }

    public int getTransferClass() {
        return this.transferClass;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public void setOrgCourseId(Long orgCourseId) {
        this.orgCourseId = orgCourseId;
    }

    public void setClassId(Long classId) {
        this.classId = classId;
    }

    public void setOrgCourseNumber(Long orgCourseNumber) {
        this.orgCourseNumber = orgCourseNumber;
    }

    public void setOrgCourseName(String orgCourseName) {
        this.orgCourseName = orgCourseName;
    }

    public void setTeacherNames(Collection<String> teacherNames) {
        this.teacherNames = teacherNames;
    }

    public void setTeacherNameStr(String teacherNameStr) {
        this.teacherNameStr = teacherNameStr;
    }

    public void setCoursePrice(Double coursePrice) {
        this.coursePrice = coursePrice;
    }

    public void setOriginPriceStr(String originPriceStr) {
        this.originPriceStr = originPriceStr;
    }

    public void setPayPrice(Double payPrice) {
        this.payPrice = payPrice;
    }

    public void setRealPayPrice(Double realPayPrice) {
        this.realPayPrice = realPayPrice;
    }

    public void setDiscount(int discount) {
        this.discount = discount;
    }

    public void setRealDiscount(Integer realDiscount) {
        this.realDiscount = realDiscount;
    }

    public void setPreferential(double preferential) {
        this.preferential = preferential;
    }

    public void setRoundUpMoney(Double roundUpMoney) {
        this.roundUpMoney = roundUpMoney;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public void setCourseType(int courseType) {
        this.courseType = courseType;
    }

    public void setPoundage(double poundage) {
        this.poundage = poundage;
    }

    public void setSignupRefundDto(List<SignupRefundResponse> signupRefundDto) {
        this.signupRefundDto = signupRefundDto;
    }

    public void setTotalRefundMoney(double totalRefundMoney) {
        this.totalRefundMoney = totalRefundMoney;
    }

    public void setProfit(double profit) {
        this.profit = profit;
    }

    public void setTotalPrice(double totalPrice) {
        this.totalPrice = totalPrice;
    }

    public void setCoverId(Integer coverId) {
        this.coverId = coverId;
    }

    public void setCoverUrl(String coverUrl) {
        this.coverUrl = coverUrl;
    }

    public void setLessonCount(Integer lessonCount) {
        this.lessonCount = lessonCount;
    }

    public void setChargeMode(Integer chargeMode) {
        this.chargeMode = chargeMode;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public void setStudentPayPrice(Double studentPayPrice) {
        this.studentPayPrice = studentPayPrice;
    }

    public void setAmount(String amount) {
        this.amount = amount;
    }

    public void setRealAmount(String realAmount) {
        this.realAmount = realAmount;
    }

    public void setTransferClassDeduction(String transferClassDeduction) {
        this.transferClassDeduction = transferClassDeduction;
    }

    public void setRefundAmount(String refundAmount) {
        this.refundAmount = refundAmount;
    }

    public void setShowTransferStatus(int showTransferStatus) {
        this.showTransferStatus = showTransferStatus;
    }

    public void setTransferClass(int transferClass) {
        this.transferClass = transferClass;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SignupCourseInfoDto)) {
            return false;
        }
        SignupCourseInfoDto other = (SignupCourseInfoDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$orgId = this.getOrgId();
        Long other$orgId = other.getOrgId();
        if (this$orgId == null ? other$orgId != null : !((Object)this$orgId).equals(other$orgId)) {
            return false;
        }
        Long this$userId = this.getUserId();
        Long other$userId = other.getUserId();
        if (this$userId == null ? other$userId != null : !((Object)this$userId).equals(other$userId)) {
            return false;
        }
        Long this$orgCourseId = this.getOrgCourseId();
        Long other$orgCourseId = other.getOrgCourseId();
        if (this$orgCourseId == null ? other$orgCourseId != null : !((Object)this$orgCourseId).equals(other$orgCourseId)) {
            return false;
        }
        Long this$classId = this.getClassId();
        Long other$classId = other.getClassId();
        if (this$classId == null ? other$classId != null : !((Object)this$classId).equals(other$classId)) {
            return false;
        }
        Long this$orgCourseNumber = this.getOrgCourseNumber();
        Long other$orgCourseNumber = other.getOrgCourseNumber();
        if (this$orgCourseNumber == null ? other$orgCourseNumber != null : !((Object)this$orgCourseNumber).equals(other$orgCourseNumber)) {
            return false;
        }
        String this$orgCourseName = this.getOrgCourseName();
        String other$orgCourseName = other.getOrgCourseName();
        if (this$orgCourseName == null ? other$orgCourseName != null : !this$orgCourseName.equals(other$orgCourseName)) {
            return false;
        }
        Collection<String> this$teacherNames = this.getTeacherNames();
        Collection<String> other$teacherNames = other.getTeacherNames();
        if (this$teacherNames == null ? other$teacherNames != null : !((Object)this$teacherNames).equals(other$teacherNames)) {
            return false;
        }
        String this$teacherNameStr = this.getTeacherNameStr();
        String other$teacherNameStr = other.getTeacherNameStr();
        if (this$teacherNameStr == null ? other$teacherNameStr != null : !this$teacherNameStr.equals(other$teacherNameStr)) {
            return false;
        }
        Double this$coursePrice = this.getCoursePrice();
        Double other$coursePrice = other.getCoursePrice();
        if (this$coursePrice == null ? other$coursePrice != null : !((Object)this$coursePrice).equals(other$coursePrice)) {
            return false;
        }
        Double this$originPrice = this.getOriginPrice();
        Double other$originPrice = other.getOriginPrice();
        if (this$originPrice == null ? other$originPrice != null : !((Object)this$originPrice).equals(other$originPrice)) {
            return false;
        }
        String this$originPriceStr = this.getOriginPriceStr();
        String other$originPriceStr = other.getOriginPriceStr();
        if (this$originPriceStr == null ? other$originPriceStr != null : !this$originPriceStr.equals(other$originPriceStr)) {
            return false;
        }
        Double this$payPrice = this.getPayPrice();
        Double other$payPrice = other.getPayPrice();
        if (this$payPrice == null ? other$payPrice != null : !((Object)this$payPrice).equals(other$payPrice)) {
            return false;
        }
        Double this$realPayPrice = this.getRealPayPrice();
        Double other$realPayPrice = other.getRealPayPrice();
        if (this$realPayPrice == null ? other$realPayPrice != null : !((Object)this$realPayPrice).equals(other$realPayPrice)) {
            return false;
        }
        if (this.getDiscount() != other.getDiscount()) {
            return false;
        }
        Integer this$realDiscount = this.getRealDiscount();
        Integer other$realDiscount = other.getRealDiscount();
        if (this$realDiscount == null ? other$realDiscount != null : !((Object)this$realDiscount).equals(other$realDiscount)) {
            return false;
        }
        if (Double.compare(this.getPreferential(), other.getPreferential()) != 0) {
            return false;
        }
        Double this$roundUpMoney = this.getRoundUpMoney();
        Double other$roundUpMoney = other.getRoundUpMoney();
        if (this$roundUpMoney == null ? other$roundUpMoney != null : !((Object)this$roundUpMoney).equals(other$roundUpMoney)) {
            return false;
        }
        if (this.getFreq() != other.getFreq()) {
            return false;
        }
        if (this.getCount() != other.getCount()) {
            return false;
        }
        if (this.getCourseType() != other.getCourseType()) {
            return false;
        }
        if (Double.compare(this.getPoundage(), other.getPoundage()) != 0) {
            return false;
        }
        List<SignupRefundResponse> this$signupRefundDto = this.getSignupRefundDto();
        List<SignupRefundResponse> other$signupRefundDto = other.getSignupRefundDto();
        if (this$signupRefundDto == null ? other$signupRefundDto != null : !((Object)this$signupRefundDto).equals(other$signupRefundDto)) {
            return false;
        }
        if (Double.compare(this.getTotalRefundMoney(), other.getTotalRefundMoney()) != 0) {
            return false;
        }
        if (Double.compare(this.getProfit(), other.getProfit()) != 0) {
            return false;
        }
        if (Double.compare(this.getTotalPrice(), other.getTotalPrice()) != 0) {
            return false;
        }
        Integer this$coverId = this.getCoverId();
        Integer other$coverId = other.getCoverId();
        if (this$coverId == null ? other$coverId != null : !((Object)this$coverId).equals(other$coverId)) {
            return false;
        }
        String this$coverUrl = this.getCoverUrl();
        String other$coverUrl = other.getCoverUrl();
        if (this$coverUrl == null ? other$coverUrl != null : !this$coverUrl.equals(other$coverUrl)) {
            return false;
        }
        Integer this$lessonCount = this.getLessonCount();
        Integer other$lessonCount = other.getLessonCount();
        if (this$lessonCount == null ? other$lessonCount != null : !((Object)this$lessonCount).equals(other$lessonCount)) {
            return false;
        }
        Integer this$chargeType = this.getChargeType();
        Integer other$chargeType = other.getChargeType();
        if (this$chargeType == null ? other$chargeType != null : !((Object)this$chargeType).equals(other$chargeType)) {
            return false;
        }
        Integer this$chargeMode = this.getChargeMode();
        Integer other$chargeMode = other.getChargeMode();
        if (this$chargeMode == null ? other$chargeMode != null : !((Object)this$chargeMode).equals(other$chargeMode)) {
            return false;
        }
        Integer this$chargeUnit = this.getChargeUnit();
        Integer other$chargeUnit = other.getChargeUnit();
        if (this$chargeUnit == null ? other$chargeUnit != null : !((Object)this$chargeUnit).equals(other$chargeUnit)) {
            return false;
        }
        Integer this$status = this.getStatus();
        Integer other$status = other.getStatus();
        if (this$status == null ? other$status != null : !((Object)this$status).equals(other$status)) {
            return false;
        }
        Double this$studentPayPrice = this.getStudentPayPrice();
        Double other$studentPayPrice = other.getStudentPayPrice();
        if (this$studentPayPrice == null ? other$studentPayPrice != null : !((Object)this$studentPayPrice).equals(other$studentPayPrice)) {
            return false;
        }
        String this$amount = this.getAmount();
        String other$amount = other.getAmount();
        if (this$amount == null ? other$amount != null : !this$amount.equals(other$amount)) {
            return false;
        }
        String this$realAmount = this.getRealAmount();
        String other$realAmount = other.getRealAmount();
        if (this$realAmount == null ? other$realAmount != null : !this$realAmount.equals(other$realAmount)) {
            return false;
        }
        String this$transferClassDeduction = this.getTransferClassDeduction();
        String other$transferClassDeduction = other.getTransferClassDeduction();
        if (this$transferClassDeduction == null ? other$transferClassDeduction != null : !this$transferClassDeduction.equals(other$transferClassDeduction)) {
            return false;
        }
        String this$refundAmount = this.getRefundAmount();
        String other$refundAmount = other.getRefundAmount();
        if (this$refundAmount == null ? other$refundAmount != null : !this$refundAmount.equals(other$refundAmount)) {
            return false;
        }
        if (this.getShowTransferStatus() != other.getShowTransferStatus()) {
            return false;
        }
        return this.getTransferClass() == other.getTransferClass();
    }

    protected boolean canEqual(Object other) {
        return other instanceof SignupCourseInfoDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $orgId = this.getOrgId();
        result = result * 59 + ($orgId == null ? 43 : ((Object)$orgId).hashCode());
        Long $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 43 : ((Object)$userId).hashCode());
        Long $orgCourseId = this.getOrgCourseId();
        result = result * 59 + ($orgCourseId == null ? 43 : ((Object)$orgCourseId).hashCode());
        Long $classId = this.getClassId();
        result = result * 59 + ($classId == null ? 43 : ((Object)$classId).hashCode());
        Long $orgCourseNumber = this.getOrgCourseNumber();
        result = result * 59 + ($orgCourseNumber == null ? 43 : ((Object)$orgCourseNumber).hashCode());
        String $orgCourseName = this.getOrgCourseName();
        result = result * 59 + ($orgCourseName == null ? 43 : $orgCourseName.hashCode());
        Collection<String> $teacherNames = this.getTeacherNames();
        result = result * 59 + ($teacherNames == null ? 43 : ((Object)$teacherNames).hashCode());
        String $teacherNameStr = this.getTeacherNameStr();
        result = result * 59 + ($teacherNameStr == null ? 43 : $teacherNameStr.hashCode());
        Double $coursePrice = this.getCoursePrice();
        result = result * 59 + ($coursePrice == null ? 43 : ((Object)$coursePrice).hashCode());
        Double $originPrice = this.getOriginPrice();
        result = result * 59 + ($originPrice == null ? 43 : ((Object)$originPrice).hashCode());
        String $originPriceStr = this.getOriginPriceStr();
        result = result * 59 + ($originPriceStr == null ? 43 : $originPriceStr.hashCode());
        Double $payPrice = this.getPayPrice();
        result = result * 59 + ($payPrice == null ? 43 : ((Object)$payPrice).hashCode());
        Double $realPayPrice = this.getRealPayPrice();
        result = result * 59 + ($realPayPrice == null ? 43 : ((Object)$realPayPrice).hashCode());
        result = result * 59 + this.getDiscount();
        Integer $realDiscount = this.getRealDiscount();
        result = result * 59 + ($realDiscount == null ? 43 : ((Object)$realDiscount).hashCode());
        long $preferential = Double.doubleToLongBits(this.getPreferential());
        result = result * 59 + (int)($preferential >>> 32 ^ $preferential);
        Double $roundUpMoney = this.getRoundUpMoney();
        result = result * 59 + ($roundUpMoney == null ? 43 : ((Object)$roundUpMoney).hashCode());
        result = result * 59 + this.getFreq();
        result = result * 59 + this.getCount();
        result = result * 59 + this.getCourseType();
        long $poundage = Double.doubleToLongBits(this.getPoundage());
        result = result * 59 + (int)($poundage >>> 32 ^ $poundage);
        List<SignupRefundResponse> $signupRefundDto = this.getSignupRefundDto();
        result = result * 59 + ($signupRefundDto == null ? 43 : ((Object)$signupRefundDto).hashCode());
        long $totalRefundMoney = Double.doubleToLongBits(this.getTotalRefundMoney());
        result = result * 59 + (int)($totalRefundMoney >>> 32 ^ $totalRefundMoney);
        long $profit = Double.doubleToLongBits(this.getProfit());
        result = result * 59 + (int)($profit >>> 32 ^ $profit);
        long $totalPrice = Double.doubleToLongBits(this.getTotalPrice());
        result = result * 59 + (int)($totalPrice >>> 32 ^ $totalPrice);
        Integer $coverId = this.getCoverId();
        result = result * 59 + ($coverId == null ? 43 : ((Object)$coverId).hashCode());
        String $coverUrl = this.getCoverUrl();
        result = result * 59 + ($coverUrl == null ? 43 : $coverUrl.hashCode());
        Integer $lessonCount = this.getLessonCount();
        result = result * 59 + ($lessonCount == null ? 43 : ((Object)$lessonCount).hashCode());
        Integer $chargeType = this.getChargeType();
        result = result * 59 + ($chargeType == null ? 43 : ((Object)$chargeType).hashCode());
        Integer $chargeMode = this.getChargeMode();
        result = result * 59 + ($chargeMode == null ? 43 : ((Object)$chargeMode).hashCode());
        Integer $chargeUnit = this.getChargeUnit();
        result = result * 59 + ($chargeUnit == null ? 43 : ((Object)$chargeUnit).hashCode());
        Integer $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)$status).hashCode());
        Double $studentPayPrice = this.getStudentPayPrice();
        result = result * 59 + ($studentPayPrice == null ? 43 : ((Object)$studentPayPrice).hashCode());
        String $amount = this.getAmount();
        result = result * 59 + ($amount == null ? 43 : $amount.hashCode());
        String $realAmount = this.getRealAmount();
        result = result * 59 + ($realAmount == null ? 43 : $realAmount.hashCode());
        String $transferClassDeduction = this.getTransferClassDeduction();
        result = result * 59 + ($transferClassDeduction == null ? 43 : $transferClassDeduction.hashCode());
        String $refundAmount = this.getRefundAmount();
        result = result * 59 + ($refundAmount == null ? 43 : $refundAmount.hashCode());
        result = result * 59 + this.getShowTransferStatus();
        result = result * 59 + this.getTransferClass();
        return result;
    }

    public String toString() {
        return "SignupCourseInfoDto(orgId=" + this.getOrgId() + ", userId=" + this.getUserId() + ", orgCourseId=" + this.getOrgCourseId() + ", classId=" + this.getClassId() + ", orgCourseNumber=" + this.getOrgCourseNumber() + ", orgCourseName=" + this.getOrgCourseName() + ", teacherNames=" + this.getTeacherNames() + ", teacherNameStr=" + this.getTeacherNameStr() + ", coursePrice=" + this.getCoursePrice() + ", originPrice=" + this.getOriginPrice() + ", originPriceStr=" + this.getOriginPriceStr() + ", payPrice=" + this.getPayPrice() + ", realPayPrice=" + this.getRealPayPrice() + ", discount=" + this.getDiscount() + ", realDiscount=" + this.getRealDiscount() + ", preferential=" + this.getPreferential() + ", roundUpMoney=" + this.getRoundUpMoney() + ", freq=" + this.getFreq() + ", count=" + this.getCount() + ", courseType=" + this.getCourseType() + ", poundage=" + this.getPoundage() + ", signupRefundDto=" + this.getSignupRefundDto() + ", totalRefundMoney=" + this.getTotalRefundMoney() + ", profit=" + this.getProfit() + ", totalPrice=" + this.getTotalPrice() + ", coverId=" + this.getCoverId() + ", coverUrl=" + this.getCoverUrl() + ", lessonCount=" + this.getLessonCount() + ", chargeType=" + this.getChargeType() + ", chargeMode=" + this.getChargeMode() + ", chargeUnit=" + this.getChargeUnit() + ", status=" + this.getStatus() + ", studentPayPrice=" + this.getStudentPayPrice() + ", amount=" + this.getAmount() + ", realAmount=" + this.getRealAmount() + ", transferClassDeduction=" + this.getTransferClassDeduction() + ", refundAmount=" + this.getRefundAmount() + ", showTransferStatus=" + this.getShowTransferStatus() + ", transferClass=" + this.getTransferClass() + ")";
    }
}

