package com.baijia.tianxiao.sal.signup.service;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;

import org.apache.http.Header;

import com.baijia.tianxiao.dal.signup.po.OrgSignupInfo;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sal.signup.dto.PaymentResultDto;
import com.baijia.tianxiao.sal.signup.dto.request.FillCourseInfoRequestDto;
import com.baijia.tianxiao.sal.signup.dto.request.SingupListRequestDto;
import com.baijia.tianxiao.sal.signup.dto.response.OrgSignupListDto;
import com.baijia.tianxiao.sal.signup.dto.response.OrgSingupInfoDto;
import com.baijia.tianxiao.sal.signup.dto.response.TransferClassRecordDto;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;

/**
 * 报名
 */
public interface SignupService {

    String HEADER_X_FORWARDED_FOR = "X-FORWARDED-FOR";

    BigDecimal HUNDRED = new BigDecimal(100);

    int MAX_SIGNUP_MONEY = 10000000;

    List<OrgSingupInfoDto> getSignupList(SingupListRequestDto signQueryRequestDto);

    /**
     * 生成收费码
     *
     * @param headers
     * @param orgId
     * @return
     */

    OrgSingupInfoDto generarateTradeNo(Collection<Header> headers, double totalPrice, Long orgId)
            throws BussinessException;

    /**
     * 报名
     *
     * @param fillCourseInfoRequestDto
     * @return
     */
    OrgSingupInfoDto signUp(FillCourseInfoRequestDto fillCourseInfoRequestDto) throws BussinessException;

    /**
     * 现金支付
     *
     * @param signupPurchaseId 订单id
     * @param orgId
     * @return
     */
    OrgSingupInfoDto payByCash(Long signupPurchaseId, Long orgId, Integer cascadeId) throws BussinessException;

    /**
     * 删除报名信息
     *
     * @param signupPurchaseId
     * @param orgId
     * @throws BussinessException
     */
    void delSignupInfo(Long signupPurchaseId, Long orgId) throws BussinessException;

    /**
     * 根据订单ID获取支付结果,成功返回true,否则返回false
     *
     * @param signupPurchaseId
     * @return
     * @throws BussinessException
     */
    boolean isPurchaseSucce(Long signupPurchaseId, Long orgId, Integer cascadeId) throws BussinessException;

    /**
     * @param signupPurchaseId
     * @param orgId
     * @param mobile
     * @return
     * @throws BussinessException
     */
    boolean sendOnlinePaySms(Long signupPurchaseId, Long orgId, String mobile) throws BussinessException;

    /**
     * @param signupPurchaseId
     * @param orgId
     * @return
     * @throws BussinessException
     */
/*
    boolean sendSignUpSms(Long signupPurchaseId, Long orgId, String mobile) throws BussinessException;
*/

    OrgSingupInfoDto getCourseInfo(Collection<Header> headers, Long signupPurchaseId, Long orgId, Integer cascadeId);

    OrgSignupListDto pcSignupList(SingupListRequestDto requestDto);

    PaymentResultDto getPaymentResultDto(Long signupPurchaseId) throws BussinessException, Exception;

    void updateSignupRemark(Long signupPurchaseId, String remark);

    /**
     * 取消报名信息
     *
     * @param signupPurchaseId
     * @param orgId
     * @throws BussinessException
     */
    void cancelSignupInfo(Long signupPurchaseId, Long orgId) throws BussinessException;

    OrgSignupInfo getByPurchaseId(Long orgId, Long signupPurchaseId) throws BussinessException;

    OrgSingupInfoDto detailByPurchaseId(Long orgId, Long signupPurchaseId) throws BussinessException;

    OrgSignupInfo changeSignupStudentPrice(Long orgId, Long signupPurchaseId, Integer opType, Long studentPayMoney)
            throws BussinessException;

    void syncClassId(PageDto pageDto);

    void signupSuccess(Long orgId, Long signupPurchaseId, Integer payType, Integer refund);

    /**
     * @param orgId
     * @param orgCourseId
     * @return
     */
    List<TransferClassRecordDto> listTransferClassRecordes(Long orgId, Long signupPurchaseId, Long orgCourseId);

    Long getStudent(FillCourseInfoRequestDto fillCourseInfoRequestDto) throws BussinessException;

}
