package com.baijia.tianxiao.sal.signup.service.Impl;

import com.baijia.tianxiao.consants.DataStatus;
import com.baijia.tianxiao.dal.signup.constant.SignupCourseStatus;
import com.baijia.tianxiao.dal.signup.dao.TxPurchaseTimescardDao;
import com.baijia.tianxiao.dal.signup.po.OrgSignupInfo;
import com.baijia.tianxiao.dal.signup.po.TxPurchaseTimescard;
import com.baijia.tianxiao.sal.signup.service.TxPurchaseTimescardService;
import com.baijia.tianxiao.util.encrypt.MD5Utils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;

/**
 * Created by wengshengli on 2017/7/17.
 */
@Service
@Slf4j
public class TxPurchaseTimesCardServiceIimpl implements TxPurchaseTimescardService {

    @Autowired
    private TxPurchaseTimescardDao txPurchaseTimescardDao;

    @Override
    public void saveTimesCardBySignupinfo(OrgSignupInfo orgSignupinfo) {
        TxPurchaseTimescard txPurchaseTimescard = new TxPurchaseTimescard();
        txPurchaseTimescard.setOrgId(orgSignupinfo.getOrgId());
        txPurchaseTimescard.setStudentId(orgSignupinfo.getStudentId());
        txPurchaseTimescard.setUserId(orgSignupinfo.getUserId());
        txPurchaseTimescard.setSignupPurchaseId(orgSignupinfo.getSignupPurchaseId());
        txPurchaseTimescard.setCardNumber(MD5Utils.MD5Encode16(orgSignupinfo.getSignupPurchaseId().toString()).toUpperCase());
        txPurchaseTimescard.setPayPrice(orgSignupinfo.getTotalPrices());
        txPurchaseTimescard.setStatus(SignupCourseStatus.NOT_PAY.getCode());
        txPurchaseTimescard.setIsDel(DataStatus.NORMAL.getValue());

        if (orgSignupinfo.getTxPurchaseTimescard() != null) {
            txPurchaseTimescard.setLessonCount(orgSignupinfo.getTxPurchaseTimescard().getLessonCount());
            if (orgSignupinfo.getTxPurchaseTimescard().getStartTime() == null) {
                txPurchaseTimescard.setStartTime(new Date());
            } else {
                txPurchaseTimescard.setStartTime(orgSignupinfo.getTxPurchaseTimescard().getStartTime());
            }
            if (orgSignupinfo.getTxPurchaseTimescard().getEndTime() != null) {
                txPurchaseTimescard.setEndTime(orgSignupinfo.getTxPurchaseTimescard().getEndTime());
            }
        }

        Date now = new Date();
        txPurchaseTimescard.setCreateTime(now);
        txPurchaseTimescard.setUpdateTime(now);

        txPurchaseTimescardDao.save(txPurchaseTimescard);
    }
}
