package com.baijia.tianxiao.sal.signup.service.Impl;

import com.baijia.tianxiao.consants.DataStatus;
import com.baijia.tianxiao.dal.signup.constant.SignupCourseStatus;
import com.baijia.tianxiao.dal.signup.dao.TxPurchaseRechargeDao;
import com.baijia.tianxiao.dal.signup.po.OrgSignupInfo;
import com.baijia.tianxiao.dal.signup.po.TxPurchaseRecharge;
import com.baijia.tianxiao.sal.signup.service.TxPurchaseRechargeService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;

/**
 * Created by wengshengli on 2017/7/17.
 */
@Service
@Slf4j
public class TxPurchaseRechaseServiceImpl implements TxPurchaseRechargeService {

    @Autowired
    private TxPurchaseRechargeDao txPurchaseRechargeDao;

    @Override
    public void saveRechargeBySignupinfo(OrgSignupInfo orgSignupinfo) {

        TxPurchaseRecharge txPurchaseRecharge = new TxPurchaseRecharge();
        txPurchaseRecharge.setOrgId(orgSignupinfo.getOrgId());
        txPurchaseRecharge.setStudentId(orgSignupinfo.getStudentId());
        txPurchaseRecharge.setUserId(orgSignupinfo.getUserId());
        txPurchaseRecharge.setSignupPurchaseId(orgSignupinfo.getSignupPurchaseId());
        txPurchaseRecharge.setPayPrice(orgSignupinfo.getTotalPrices());
        txPurchaseRecharge.setStatus(SignupCourseStatus.NOT_PAY.getCode());
        txPurchaseRecharge.setIsDel(DataStatus.NORMAL.getValue());

        Date now = new Date();
        txPurchaseRecharge.setCreateTime(now);
        txPurchaseRecharge.setUpdateTime(now);

        txPurchaseRechargeDao.save(txPurchaseRecharge);
    }
}
