package com.baijia.tianxiao.sal.signup.service.Impl;

import com.baijia.tianxiao.dal.constant.ChargeMode;
import com.baijia.tianxiao.dal.constant.ChargeUnit;
import com.baijia.tianxiao.dal.org.dao.OrgCourseDao;
import com.baijia.tianxiao.dal.org.po.OrgCourse;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupCourseDao;
import com.baijia.tianxiao.dal.signup.po.OrgSignupCourse;
import com.baijia.tianxiao.sal.signup.dto.SignupCourseInfoDto;
import com.baijia.tianxiao.sal.signup.service.SignupCourseService;
import com.baijia.tianxiao.util.BaseUtils;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Collections;
import java.util.List;
import java.util.Map;

/**
 * Created by wengshengli on 2017/5/15.
 */
@Service
public class SignupCourseServiceImpl implements SignupCourseService {

    @Resource
    private OrgSignupCourseDao orgSignupCourseDao;

    @Resource
    private OrgCourseDao orgCourseDao;

    @Override
    public List<SignupCourseInfoDto> getBySignupPurchasaeId(Long signupPurchaseId) {
        Preconditions.checkNotNull(signupPurchaseId, "订单号不为空");
        List<OrgSignupCourse> signupCourseList = orgSignupCourseDao.loadByPurchaseId(signupPurchaseId);
        if (CollectionUtils.isEmpty(signupCourseList)) {
            return Collections.EMPTY_LIST;
        }

        List<Long> courseIds = BaseUtils.getListFilter(signupCourseList, "orgCourseId");

        Map<Long, OrgCourse> courseMap = this.orgCourseDao.getOrgCourseMap(courseIds);

        List<SignupCourseInfoDto> result = Lists.newArrayList();
        for (OrgSignupCourse orgSignupCourse : signupCourseList) {
            result.add(buildOrgSignupCourseDto(orgSignupCourse, courseMap.get(orgSignupCourse.getOrgCourseId())));
        }
        return result;
    }


    private SignupCourseInfoDto buildOrgSignupCourseDto(OrgSignupCourse orgSignupCourse, OrgCourse orgCourse) {
        SignupCourseInfoDto dto = new SignupCourseInfoDto();
        dto.setCount(orgSignupCourse.getCount());
        dto.setDiscount(orgSignupCourse.getCourseDiscount());
        dto.setOrgId(orgSignupCourse.getOrgId());
        dto.setUserId(orgSignupCourse.getUserId());
        dto.setOrgCourseId(orgSignupCourse.getOrgCourseId());
        dto.setClassId(orgSignupCourse.getClassId());
        dto.setCoursePrice(orgCourse.getPrice().doubleValue());
        dto.setOriginPrice(orgSignupCourse.getOriginPrice().doubleValue() / 100);
        // 优惠金额＝(原优惠金额＋原价*count＊(1-折扣百分数))/100
        double preferential = ((100d - orgSignupCourse.getCourseDiscount().doubleValue()) / 100
                * orgSignupCourse.getOriginPrice() * orgSignupCourse.getCount() + orgSignupCourse.getPreferential()) / 100;
        dto.setPreferential(preferential);
        dto.setRealPayPrice(orgSignupCourse.getPayPrice() / 100d);
        dto.setPayPrice(orgSignupCourse.getPayPrice().doubleValue() / 100);
        dto.setOrgCourseName(orgCourse == null ? "" : orgCourse.getName());
        dto.setOrgCourseNumber(orgCourse == null ? 0l : orgCourse.getNumber());
        dto.setFreq(orgCourse == null || orgCourse.getFreq() == null ? 0 : orgCourse.getFreq());
        dto.setTotalPrice(orgSignupCourse.getTotalPayPrice().doubleValue() / 100);

        if (orgCourse != null) {
            dto.setCourseType(orgCourse.getCourseType());
            dto.setChargeType(orgCourse.getChargeType());
        }
        dto.setChargeUnit(orgSignupCourse.getChargeUnit());
        dto.setChargeMode(ChargeMode.getByCharegeUnit(orgSignupCourse.getChargeUnit()).getCode());
        dto.setStudentPayPrice(orgSignupCourse.getStudentPayPrice().doubleValue() / 100);
        dto.setLessonCount(orgSignupCourse.getLessonCount() == null ? 0 : orgSignupCourse.getLessonCount());
        dto.setStatus(orgSignupCourse.getStatus());

        return dto;
    }

    @Override
    public Integer sumAllLessonCount(Long orgId, Long orgCourseId, Long userId, List<Integer> status, String... queryProps) {
        List<OrgSignupCourse> signupCourseList = orgSignupCourseDao.sumAllLessonCount(orgId, orgCourseId, userId, status, queryProps);
        if (CollectionUtils.isEmpty(signupCourseList)) {
            return 0;
        }

        Integer sumCount = 0;
        for (OrgSignupCourse signupCourse : signupCourseList) {
            if (signupCourse.getChargeUnit() == ChargeUnit.BY_HOUR.getCode()) {
                sumCount += signupCourse.getLessonCount() * 60;
            } else if (signupCourse.getChargeUnit() == ChargeUnit.BY_HALF_HOUR.getCode()) {
                sumCount += signupCourse.getLessonCount() * 30;
            } else if (signupCourse.getChargeUnit() == ChargeUnit.BY_MINUTE.getCode()) {
                sumCount += signupCourse.getLessonCount();
            } else {
                sumCount += signupCourse.getLessonCount();
            }
        }
        return sumCount;
    }
}
