package com.baijia.tianxiao.sal.signup.service.Impl;

import com.baijia.tianxiao.dal.constant.ChargeUnit;
import com.baijia.tianxiao.dal.org.dao.OrgStudentCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentKexiaoRecordDao;
import com.baijia.tianxiao.dal.org.dto.StudentCourseKexiaoDocument;
import com.baijia.tianxiao.dal.org.po.OrgStudentCourse;
import com.baijia.tianxiao.dal.signup.constant.SignupCourseStatus;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupCourseDao;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupRefundDao;
import com.baijia.tianxiao.dal.signup.po.OrgSignupCourse;
import com.baijia.tianxiao.dal.signup.po.OrgSignupRefund;
import com.baijia.tianxiao.sal.common.api.KexiaoApiService;
import com.baijia.tianxiao.sal.organization.finance.dto.SignupRefundResponse;
import com.baijia.tianxiao.sal.signup.service.OrgSignupRefundService;
import com.baijia.tianxiao.util.NumberUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import lombok.Data;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.*;

/**
 * 报名 退款
 */
@Service
@Data
@Slf4j
public class OrgSignupRefundServiceImpl implements OrgSignupRefundService {

    @Resource
    private OrgSignupRefundDao orgSignupRefundDao;

    @Resource
    private OrgSignupCourseDao orgSignupCourseDao;

    @Resource
    private OrgStudentCourseDao studentCourseDao;

    @Resource
    private OrgStudentKexiaoRecordDao orgStudentKexiaoRecordDao;

    @Autowired
    private KexiaoApiService kexiaoApiService;

    @Override
    public List<OrgSignupRefund> saveRefund(List<OrgSignupCourse> signupCourses, Long orgId, Long signupPurchaseId, Long courseId, Long userId, Long refundPrice, Integer refundType, Integer cascadeId) {

        log.debug("OrgSignupRefundServiceImpl params={},{},{},{},{},{},{},{}", signupCourses, orgId, signupPurchaseId, courseId, userId, refundPrice, refundType, cascadeId);
        List<OrgSignupCourse> signupCourseList = Lists.newArrayList();
        if (signupPurchaseId != null && signupPurchaseId > 0) {
            OrgSignupCourse orgSignupCourse = orgSignupCourseDao.getByCourseId(orgId, signupPurchaseId, courseId);
            signupCourseList.add(orgSignupCourse);
        } else {
            signupCourseList = signupCourses;
        }

        OrgStudentCourse studentCourse = studentCourseDao.getStudentCourseByRealCourseId(orgId, courseId, userId);
        if (studentCourse == null) {
            return Collections.EMPTY_LIST;
        }

        return saveAll(signupCourseList, studentCourse, courseId, refundPrice, refundType, cascadeId);
    }

    @Override
    public List<SignupRefundResponse> listSignupRefund(Long orgId, Long signupPurchaseId, Long userId, Long courseId) {
        List<OrgSignupRefund> list = orgSignupRefundDao.getOrgSignupRefundByStudent(orgId, signupPurchaseId, userId, courseId);
        if (CollectionUtils.isEmpty(list)) {
            return Collections.EMPTY_LIST;
        }
        List<SignupRefundResponse> signupRefundDto = new ArrayList();
        for (int i = list.size() - 1; i >= 0; i--) {
            OrgSignupRefund o = list.get(i);
            SignupRefundResponse s = new SignupRefundResponse();
            s.setCourseId(o.getCourseId());
            s.setSignupPurchaseId(o.getSignupPurchaseId());
            s.setRefundMoney((double) o.getRefundPrice().longValue() / 100.0D);
            s.setRefundFee((double) o.getRefundFee().longValue() / 100);
            s.setRefundTime(o.getCreateTime());
            s.setRemark(o.getRemark());
            s.setRefundType(o.getRefundType());
            signupRefundDto.add(s);
        }

        return signupRefundDto;
    }

    @Override
    public Map<String, Long> mapSignupRefund(Long orgId, Long signupPurchaseId, Long userId, Long courseId) {
        List<SignupRefundResponse> signupRefundList = listSignupRefund(orgId, signupPurchaseId, userId, courseId);
        Map<String, Long> signupRefundMap = Maps.newHashMap();
        for (SignupRefundResponse signupRefund : signupRefundList) {
            String signupMapKey = signupRefund.getSignupPurchaseId() + "_" + signupRefund.getCourseId();
            if (signupRefundMap.get(signupMapKey) == null) {
                signupRefundMap.put(signupMapKey, (long) ((signupRefund.getRefundMoney() + signupRefund.getRefundFee()) * 100));
            } else {
                signupRefundMap.put(signupMapKey, signupRefundMap.get(signupMapKey) + (long) ((signupRefund.getRefundMoney() + signupRefund.getRefundFee()) * 100));
            }
        }
        log.debug("OrgSignupRefundServiceImpl-->mapSignupRefund:params={},{},{},{},result={}", orgId, signupPurchaseId, userId, courseId, signupRefundMap);
        return signupRefundMap;
    }

    private List<OrgSignupRefund> saveAll(List<OrgSignupCourse> signupCourseList, OrgStudentCourse studentCourse, Long courseId, Long refundPrice, Integer refundType, Integer cascadeId) {
        log.debug("OrgSignupRefundServiceImpl params={},{},{},{},{}", signupCourseList, studentCourse, refundPrice, refundType, cascadeId);

        List<OrgSignupRefund> saveAll = Lists.newArrayList();

        Long allRemainMoney = refundPrice;

        if (CollectionUtils.isEmpty(signupCourseList)) {
            OrgSignupRefund savePo = new OrgSignupRefund();
            if (studentCourse != null) {
                savePo.setClassId(studentCourse.getCourseId());
            }
            savePo.setOrgId(studentCourse.getOrgId());
            savePo.setSignupPurchaseId(NumberUtil.randomSignupPurchaseId4Excel(new Date()));
            savePo.setCourseId(courseId);
            savePo.setUserId(studentCourse.getUserId());
            savePo.setRefundPrice(refundPrice);
            savePo.setRefundFee(0l);
            savePo.setRefundType(refundType);
            savePo.setCascadeId(cascadeId);
            savePo.setRemark("");
            savePo.setCreateTime(new Date());
            savePo.setKexiaoCount(0l);
            savePo.setKexiaoMoney(0l);

            saveAll.add(savePo);
        } else {
            Map<String, Long> signupRefundMap = mapSignupRefund(studentCourse.getOrgId(), null, studentCourse.getUserId(), courseId);

            for (OrgSignupCourse signupCourse : signupCourseList) {
                Long refundMoney = signupRefundMap.get(signupCourse.getSignupPurchaseId() + "_" + signupCourse.getOrgCourseId());
                Long hasQuitMoney = (refundMoney == null) ? 0l : refundMoney.longValue();

                StudentCourseKexiaoDocument financed = kexiaoApiService.finishCountMoney(signupCourse.getOrgId(), signupCourse.getOrgCourseId(), signupCourse.getUserId(), signupCourse.getId(), SignupCourseStatus.inStudentCourseStatus);

                Long canRefundPrice = signupCourse.getTotalPayPrice() - financed.getFinishMoney() - hasQuitMoney;//可退金额
                Long realRefundPrice = (allRemainMoney - canRefundPrice) <= 0 ? allRemainMoney : canRefundPrice;//实际金额
                realRefundPrice = (realRefundPrice.longValue() < 0) ? 0 : realRefundPrice;

                Long canRefundFee = canRefundPrice - realRefundPrice;//可退费用
                Long realRefundFee = canRefundFee.longValue() <= 0 ? 0 : canRefundFee;//实际费用

                allRemainMoney = (allRemainMoney - realRefundPrice) < 0 ? 0 : (allRemainMoney - realRefundPrice);

                OrgSignupRefund savePo = new OrgSignupRefund();
                log.info("[Refund] studentCourse={},courseId={},userId={}", studentCourse, signupCourse.getOrgCourseId(), signupCourse.getUserId());
                if (studentCourse != null) {
                    savePo.setClassId(studentCourse.getCourseId());
                }
                savePo.setOrgId(signupCourse.getOrgId());
                savePo.setSignupPurchaseId(signupCourse.getSignupPurchaseId());
                savePo.setCourseId(signupCourse.getOrgCourseId());
                savePo.setUserId(signupCourse.getUserId());
                savePo.setRefundPrice(realRefundPrice);
                savePo.setRefundFee(realRefundFee);
                savePo.setRefundType(refundType);
                savePo.setCascadeId(cascadeId);
                savePo.setRemark("");
                savePo.setCreateTime(new Date());
                savePo.setChargeUnit(studentCourse.getChargeUnit());
                if (financed != null) {
                    if (studentCourse != null && (studentCourse.getChargeUnit() == ChargeUnit.BY_HOUR.getCode()
                            || studentCourse.getChargeUnit() == ChargeUnit.BY_HALF_HOUR.getCode()
                            || studentCourse.getChargeUnit() == ChargeUnit.BY_MINUTE.getCode())) {
                        if (signupCourse.getChargeUnit() == ChargeUnit.BY_HOUR.getCode()) {
                            savePo.setRefundLessonCount(signupCourse.getLessonCount() * 60 - financed.getFinishTime());
                        } else if (signupCourse.getChargeUnit() == ChargeUnit.BY_HALF_HOUR.getCode()) {
                            savePo.setRefundLessonCount(signupCourse.getLessonCount() * 30 - financed.getFinishTime());
                        } else {
                            savePo.setRefundLessonCount(signupCourse.getLessonCount() - financed.getFinishTime());
                        }
                        savePo.setKexiaoCount(financed.getFinishTime());
                    } else {
                        savePo.setKexiaoCount(financed.getFinishCount());
                        savePo.setRefundLessonCount(signupCourse.getLessonCount() - financed.getFinishCount());
                    }
                    savePo.setKexiaoMoney(financed.getFinishMoney());
                }
                saveAll.add(savePo);
            }
        }
        log.info("OrgSignupRefundServiceImpl=={}", saveAll);
        orgSignupRefundDao.saveAll(saveAll);
        return saveAll;
    }
}
