/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.sal.signup.dto.response;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import com.baijia.tianxiao.dal.signup.constant.TransferClassOrder;
import com.baijia.tianxiao.sal.signup.constants.SignupRefundType;
import com.baijia.tianxiao.sal.signup.dto.SignupFeeItemDto;

import lombok.Data;
import com.baijia.tianxiao.constants.signup.PayResult;
import com.baijia.tianxiao.constants.signup.PayType;
import com.baijia.tianxiao.constants.signup.SplitCourseResult;
import com.baijia.tianxiao.dal.signup.constant.SignupStatus;
import com.baijia.tianxiao.dal.signup.constant.SignupType;
import com.baijia.tianxiao.sal.signup.constants.AppPayType;
import com.baijia.tianxiao.sal.signup.dto.SignupCourseInfoDto;

/**
 * @author cxm
 * @version 1.0
 * @title OrgSingupInfoDto
 * @desc TODO
 * @date 2015年9月8日
 */
@Data
public class OrgSingupInfoDto implements Serializable {
    private static final long serialVersionUID = -7745255487539982963L;
    // 报名ID
    private Long id;

    private String studentName;

    private String studentMobile;

    private String studentAvatar;

    // OrgStudent.userId
    private Long studentId;// 兼容

    private Long userId;

    private Double totalPrice = 0d;// 线上支付金额（或非学生余额金额 ）

    private Double realTotalMoney = 0d;// 真正的订单金额=studentPayPrice+totalPrice+transferClassMoney-transferRefundMoney

    private Double preferentialPrice = 0d;// 优惠合计

    private String chinesePrice;

    private Double onlinePayPrice = 0d;// 在线支付付款金额

    private Double posPayPrice = 0d;// POS支付付款金额

    private Double cashPayPrice = 0d;// 现金支付付款金额

    private Double studentPayPrice = 0d;// 学生储值账户付款金额

    private Double studentAccountBalance = 0d;// 学生账户余额

    private Double transferClassMoney = 0d;
    private Double transferRefundMoney = 0d;

    private long allRefundMoney = 0;//订单明细退款总和
    private String allRefundMoneyStr = "";//订单明细退款总和

    /**
     * @see TransferClassOrder
     */
    private int transferClassOrder;//是否为转班
    private int orderType;

    public void setTransferClassOrder(int transferClassOrder) {
        this.orderType = transferClassOrder;
        this.orderTypeStr = TransferClassOrder.getNameByCode(orderType);

        this.transferClassOrder = transferClassOrder;
        this.transferClassOrderStr = TransferClassOrder.getNameByCode(transferClassOrder);
        if (transferClassOrder != TransferClassOrder.TRANSFER_ORDER.getCode()) {
            this.transferClassOrder = TransferClassOrder.NORMAL_ORDER.getCode();//兼容历史版本
            this.transferClassOrderStr = TransferClassOrder.getNameByCode(transferClassOrder);
        }
    }

    private String transferClassOrderStr;

    private Date purchaseEndTime;// 订单自动取消时间

    private Date signUpTime;

    private Date payTime;

    /**
     * 经办人
     */
    private String operator;

    private int payType;

    private String payTypeStr;

    private int payResult = 1;

    private String payResultStr;

    private String tradeNo;

    private Long signupPurchaseId;

    private Long payPurchaseId;

    private Long orgId;

    private String orgName;

    private List<SignupCourseInfoDto> courseInfos = new ArrayList<SignupCourseInfoDto>();

    private List<SignupFeeItemDto> feeItemDtos = new ArrayList<SignupFeeItemDto>();

    private TimesCardDto timesCardDto;

    private String remark;

    private Integer signupType;

    private String signupTypeStr;

    private String orgLogoUrl;

    // 微信支付码URL
    private String payUrlWinxin;

    private Date lastSendTime;

    // 支付状态1已完成，2待收款，3待报名
    private Integer status;

    private Integer poundage;

    private Integer sourceType;

    private String cascadeIdStr;// 经办人

    private int quitClass;// 0默认1有退班

    private int transferClass;// 0默认 1有转班

    private int transferRefundType;// 转班退款类型:2退款学生余额 ,1线下现金
    private String transferRefundTypeStr;//

    private Integer transferType = 0;

    private int paymentType = PAYMENT_TYPE_PAY;// 0:缴费 1:退款 ,用于控制展示{缴费金额/退款金额} (转班新加)
    private String paymentTypeStr;//
    private int opType = 0;//// 0:待收款tab下面控制收(退)款/取消 展示和浮层显示 0:正常报名待收款 1:转班补款 2:转班退款（转班新增）
    private String orderTypeStr; // 报名类型,后端返回（转班新增）
    private Double showTotalPrice; // 转班新加字段,不共用原有totalPrice字段

    public static final int NORMAT_SIGNUP = 0;
    public static final int TRANSFER_PAY = 1;
    public static final int TRANSFER_REFUND = 2;

    public static final int PAYMENT_TYPE_PAY = 0;
    public static final int PAYMENT_TYPE_REFUND = 1;

    public void setStatus(Integer purchaseStatus, Integer splitResult) {

        if (purchaseStatus != PayResult.SUCCESS.getCode()) {
            status = SignupStatus.NOT_PAY.getCode();// 未支付
        } else if (purchaseStatus == PayResult.SUCCESS.getCode() && splitResult < SplitCourseResult.PENDING.getCode()) {
            status = SignupStatus.NOT_SIGN.getCode();// 待报名
        } else if (purchaseStatus == PayResult.SUCCESS.getCode()
                && splitResult >= SplitCourseResult.PENDING.getCode()) {
            status = SignupStatus.FINISHED.getCode();// 支付已经完成
        }
    }

    private Date createTime;
    private Date updateTime;

    public void setSignupTypeEnum(SignupType signTypeEnum) {
        if (signTypeEnum != null) {
            this.signupType = signTypeEnum.getCode();
            this.signupTypeStr = signTypeEnum.getNote();
        }
    }

    public void setPayTypeEnum(PayType payTypeEnum) {
        if (payTypeEnum != null) {
            this.payType = AppPayType.toAppPayTypeCode(payTypeEnum.getCode());
            this.payTypeStr = payTypeEnum.getNote();
            this.paymentTypeStr = payTypeEnum.getNote();
        }
    }

    public void setPayResultEnum(PayResult payResultEnum) {
        if (payResultEnum != null) {
            this.payResult = payResultEnum.getCode();
            this.payResultStr = payResultEnum.getNote();
        }
    }

    public void setTransferRefundType(int transferRefundType) {
        this.transferRefundType = transferRefundType;
        this.transferRefundTypeStr = SignupRefundType.getNameByCode(transferRefundType);
    }

}
