package com.baijia.tianxiao.sal.signup.dto.request;

import com.baijia.tianxiao.dal.signup.constant.SignupType;
import com.baijia.tianxiao.dal.signup.constant.TransferClassOrder;
import com.baijia.tianxiao.enums.SignupErrorCode;
import com.google.common.base.Preconditions;
import lombok.Data;

import java.util.List;


/**
 * Created by wengshengli on 2017/4/20.
 */
@Data
public class TransferClassRequest extends FillCourseInfoRequestDto {

    private Long classId;
    private Integer needQuitClass;
    private String transferLessonsStr;
    private List<TransferLessonInfoDto> transferLessons;

    public void validate() {
        Preconditions.checkArgument(!(this.getTotalPrice().doubleValue() > 0
                && this.getTransferRefundMoney().doubleValue() > 0), SignupErrorCode.TRANSFER_CLASS_ERROR);
    }

    public void init() {
        this.setTransferClassOrder(TransferClassOrder.TRANSFER_ORDER.getCode());
        this.setSignupType(SignupType.FRONTED.getCode());
    }

}
