/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.sal.signup.dto.request;

import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.List;

import com.baijia.tianxiao.dal.signup.po.TxPurchaseTimescard;
import com.baijia.tianxiao.dto.BaseDto;
import com.baijia.tianxiao.sal.signup.dto.SignupFeeItemDto;
import lombok.Data;

import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;

import com.baijia.tianxiao.sal.signup.dto.SignupCourseInfoDto;

/**
 * @author shanyu
 * @version 1.0
 * @title FillCourseInfo
 * @desc TODO
 * @date 2015年9月9日
 */
@Data
public class FillCourseInfoRequestDto extends BaseDto {

    private static final long serialVersionUID = 363423171246926389L;

    private Long studentId;

    private String studentName;

    private String studentMobile;

    private String studentQQ;

    private String studentWx;

    private String parentName;

    private String parentMobile;

    private String email;

    private Date birthday;

    private Integer gender;

    private String tags;

    private String studentRemark;

    private String operator;

    private Long signupPurchaseId;

    private int signupType;

    private String remark;

    private Long orgId;

    private Long orgNumber;

    private Double totalPrice = 0d;

    private Double transferClassMoney = 0d;

    private Double transferRefundMoney = 0d;

    private int transferClassOrder;

    private Integer cascadeId;

    private int sourceType;

    private String courseInfosStr;

    private List<SignupCourseInfoDto> courseInfos;

    private List<SignupFeeItemDto> feeItemDtos;

    private Collection<Header> headers;

    private TxPurchaseTimescard txPurchaseTimescard;

    public String getRemark() {
        if (StringUtils.isBlank(remark)) {
            this.remark = "";
        }
        return this.remark;
    }
}
